package threads.core.api;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

@Dao
public interface PeerDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertPeer(Peer peer);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    void updatePeer(Peer peer);

    @Delete
    void deletePeer(Peer peer);

    @Query("DELETE FROM Peer")
    void clear();

    @Query("SELECT * FROM Peer WHERE pid = :pid")
    Peer getPeerByPid(String pid);

    @Query("SELECT * FROM Peer WHERE hash =:hash")
    Peer getPeerByHash(String hash);

    @Query("UPDATE Peer SET bundle = :bundle WHERE pid = :pid")
    void setBundle(String pid, String bundle);

    @Query("UPDATE Peer SET hash = :hash WHERE pid = :pid")
    void setHash(String pid, String hash);

}
