/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Addresses;
import threads.core.api.Content;
import threads.core.api.MultiAddresses;
import threads.core.api.Peer;
import threads.ipfs.api.Encryption;

public class PeerEncoder {
    @NonNull
    public static String convert(@NonNull Peer peer, @NonNull String aesKey) {
        String multiAddresses;
        Preconditions.checkNotNull((Object)peer);
        Preconditions.checkNotNull((Object)aesKey);
        Content content = new Content();
        Gson gson = new Gson();
        String addresses = Addresses.toString(peer.getAddresses());
        if (addresses != null) {
            content.put("peers", addresses);
        }
        if ((multiAddresses = MultiAddresses.toString(peer.getMultiAddresses())) != null) {
            content.put("mads", multiAddresses);
        }
        HashMap<String, String> additions = peer.getExternalAdditions();
        Preconditions.checkNotNull(additions);
        content.put("adds", Additionals.toString(additions));
        String data = gson.toJson((Object)content);
        try {
            data = Encryption.encrypt((String)data, (String)aesKey);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return data;
    }
}

