/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import threads.core.api.Additionals;
import threads.core.api.Addresses;
import threads.core.api.Content;
import threads.core.api.MultiAddresses;
import threads.core.api.Peer;
import threads.iota.Entity;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

public class PeerDecoder {
    private static final String TAG = PeerDecoder.class.getSimpleName();

    @Nullable
    public static Peer convert(@NonNull PID owner, @NonNull Entity entity, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)aesKey);
        Gson gson = new Gson();
        try {
            String encContent = Encryption.decrypt((String)entity.getContent(), (String)aesKey);
            Content content = (Content)gson.fromJson(encContent, Content.class);
            Peer peer = PeerDecoder.convert(owner, content);
            if (peer != null) {
                peer.setHash(entity.getHash());
                peer.setBundle(entity.getBundle());
                peer.setTimestamp(entity.getTimestamp());
            }
            return peer;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Peer convert(@NonNull PID owner, @NonNull Content content) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)content);
        try {
            String mads;
            Peer peer = Peer.createPeer(owner);
            String peers = (String)content.get("peers");
            if (peers != null) {
                Addresses addresses = Addresses.toAddresses(peers);
                Preconditions.checkNotNull((Object)addresses);
                peer.setAddresses(addresses);
            }
            if ((mads = (String)content.get("mads")) != null) {
                MultiAddresses multiAddresses = MultiAddresses.toMultiAddresses(mads);
                Preconditions.checkNotNull((Object)multiAddresses);
                peer.setMultiAddresses(multiAddresses);
            }
            String additions = (String)content.get("adds");
            Preconditions.checkNotNull((Object)additions);
            if (!additions.isEmpty()) {
                peer.setExternalAdditions(Additionals.toHashMap(additions));
            }
            return peer;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

