package threads.core.api;

import androidx.annotation.NonNull;

import com.google.gson.Gson;

import java.util.HashMap;

import threads.ipfs.api.Encryption;

import static androidx.core.util.Preconditions.checkNotNull;

public class PeerEncoder {
    @NonNull
    public static String convert(@NonNull Peer peer, @NonNull String aesKey) {
        checkNotNull(peer);
        checkNotNull(aesKey);

        Content content = new Content();
        Gson gson = new Gson();

        String addresses = Addresses.toString(peer.getAddresses());


        if (addresses != null) {
            content.put(Content.PEERS, addresses);
        }

        String multiAddresses = MultiAddresses.toString(peer.getMultiAddresses());


        if (multiAddresses != null) {
            content.put(Content.MADS, multiAddresses);
        }


        HashMap<String, String> additions = peer.getExternalAdditions();
        checkNotNull(additions);
        content.put(Content.ADDS, Additionals.toString(additions));


        String data = gson.toJson(content);
        try {
            data = Encryption.encrypt(data, aesKey);
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }

        return data;

    }
}
