package threads.core.api;

import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.gson.Gson;

import threads.iota.Entity;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

import static androidx.core.util.Preconditions.checkNotNull;

public class PeerDecoder {
    private static final String TAG = PeerDecoder.class.getSimpleName();

    @Nullable
    public static Peer convert(@NonNull PID owner, @NonNull Entity entity, @NonNull String aesKey) {
        checkNotNull(owner);
        checkNotNull(entity);
        checkNotNull(aesKey);
        Gson gson = new Gson();

        try {
            String encContent = Encryption.decrypt(entity.getContent(), aesKey);
            Content content = gson.fromJson(encContent, Content.class);
            Peer peer = convert(owner, content);
            if (peer != null) {
                peer.setHash(entity.getHash());
                peer.setBundle(entity.getBundle());
                peer.setTimestamp(entity.getTimestamp());
            }
            return peer;

        } catch (Throwable e) {
            Log.e(TAG, "" + e.getLocalizedMessage(), e);
        }
        return null;
    }

    @Nullable
    public static Peer convert(@NonNull PID owner, @NonNull Content content) {
        checkNotNull(owner);
        checkNotNull(content);
        try {
            Peer peer = Peer.createPeer(owner);
            // NOT ENCRYPTED
            String peers = content.get(Content.PEERS);
            if (peers != null) {
                Addresses addresses = Addresses.toAddresses(peers);
                checkNotNull(addresses);
                peer.setAddresses(addresses);
            }

            // NOT ENCRYPTED
            String mads = content.get(Content.MADS);
            if (mads != null) {
                MultiAddresses multiAddresses = MultiAddresses.toMultiAddresses(mads);
                checkNotNull(multiAddresses);
                peer.setMultiAddresses(multiAddresses);
            }


            // NOT ENCRYPTED
            String additions = content.get(Content.ADDS);
            checkNotNull(additions);

            if (!additions.isEmpty()) {
                peer.setExternalAdditions(Additionals.toHashMap(additions));
            }

            return peer;

        } catch (Throwable e) {
            Log.e(TAG, "" + e.getLocalizedMessage(), e);
        }
        return null;
    }
}
