/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.Room;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import threads.core.Preferences;
import threads.core.THREADS;
import threads.core.api.EventsDatabase;
import threads.core.api.Message;
import threads.core.api.MessageKind;
import threads.core.api.Server;
import threads.core.api.ThreadsDatabase;
import threads.iota.EntityService;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.AddressesConfig;
import threads.ipfs.api.ApiListener;
import threads.ipfs.api.ConnMgrConfig;
import threads.ipfs.api.DiscoveryConfig;
import threads.ipfs.api.ExperimentalConfig;
import threads.ipfs.api.PubsubConfig;
import threads.ipfs.api.ReproviderConfig;
import threads.ipfs.api.RoutingConfig;
import threads.ipfs.api.SwarmConfig;

public class Singleton {
    private static final Migration MIGRATION_61_62 = new Migration(61, 62){

        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("DROP TABLE TransactionHash");
        }
    };
    private static Singleton SINGLETON = null;
    private final IOTA iota;
    private final ThreadsDatabase threadsDatabase;
    private final EventsDatabase eventsDatabase;
    private final THREADS threads;
    private final ConsoleListener consoleListener = new ConsoleListener();
    @Nullable
    private IPFS ipfs = null;

    private Singleton(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        this.threadsDatabase = (ThreadsDatabase)Room.databaseBuilder((Context)context, ThreadsDatabase.class, (String)ThreadsDatabase.class.getSimpleName()).addMigrations(new Migration[]{MIGRATION_61_62}).build();
        this.eventsDatabase = (EventsDatabase)Room.inMemoryDatabaseBuilder((Context)context, EventsDatabase.class).build();
        EntityService entityService = EntityService.getInstance((Context)context);
        this.threads = THREADS.createThreads(this.threadsDatabase, this.eventsDatabase, entityService);
        this.consoleListener.setReport(Preferences.isReportMode(context));
        this.consoleListener.setDebug(Preferences.isDebugMode(context));
        IOTA.Builder iotaBuilder = new IOTA.Builder();
        Server server = Preferences.getTangleServer(context);
        iotaBuilder.protocol(server.getProtocol());
        iotaBuilder.host(server.getHost());
        iotaBuilder.port(server.getPort());
        iotaBuilder.timeout(Preferences.getTangleTimeout(context));
        this.iota = iotaBuilder.build();
        Integer quicPort = null;
        if (Preferences.isQUICEnabled(context)) {
            quicPort = Preferences.getSwarmPort(context);
        }
        AddressesConfig addresses = AddressesConfig.create((Integer)Preferences.getSwarmPort(context), null, null, (Integer)quicPort);
        ExperimentalConfig experimental = ExperimentalConfig.create();
        experimental.setQUIC(Preferences.isQUICEnabled(context));
        experimental.setFilestoreEnabled(Preferences.isFilestoreEnabled(context));
        experimental.setPreferTLS(Preferences.isPreferTLS(context));
        PubsubConfig pubsub = PubsubConfig.create();
        pubsub.setRouter(Preferences.getPubsubRouter(context));
        SwarmConfig swarmConfig = SwarmConfig.create();
        swarmConfig.setDisableBandwidthMetrics(true);
        swarmConfig.setDisableNatPortMap(false);
        swarmConfig.setDisableRelay(false);
        swarmConfig.setEnableAutoRelay(Preferences.isAutoRelayEnabled(context));
        swarmConfig.setEnableAutoNATService(Preferences.isAutoNATServiceEnabled(context));
        swarmConfig.setEnableRelayHop(Preferences.isRelayHopEnabled(context));
        ConnMgrConfig mgr = swarmConfig.getConnMgr();
        mgr.setGracePeriod(Preferences.getGracePeriod(context));
        mgr.setHighWater(Preferences.getHighWater(context));
        mgr.setLowWater(Preferences.getLowWater(context));
        mgr.setType(Preferences.getConnMgrConfigType(context));
        DiscoveryConfig discoveryConfig = DiscoveryConfig.create();
        discoveryConfig.getMdns().setEnabled(Preferences.isMdnsEnabled(context));
        ReproviderConfig reproviderConfig = ReproviderConfig.create();
        reproviderConfig.setInterval(Preferences.getReproviderInterval(context));
        RoutingConfig routingConfig = RoutingConfig.create();
        routingConfig.setType(Preferences.getRoutingType(context));
        try {
            this.ipfs = IPFS.getInstance((Context)context, (ApiListener)this.consoleListener, (AddressesConfig)addresses, (ExperimentalConfig)experimental, (PubsubConfig)pubsub, (DiscoveryConfig)discoveryConfig, (SwarmConfig)swarmConfig, (RoutingConfig)routingConfig, (ReproviderConfig)reproviderConfig, null);
            Preferences.setPID(context, this.ipfs.getPeerID());
        }
        catch (Throwable e) {
            Preferences.evaluateException(this.threads, "IPFS_INSTALL_FAILURE", e);
        }
    }

    @NonNull
    public static Singleton getInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        if (SINGLETON == null) {
            SINGLETON = new Singleton(context);
        }
        return SINGLETON;
    }

    @NonNull
    public ConsoleListener getConsoleListener() {
        return this.consoleListener;
    }

    @NonNull
    public IOTA getIota() {
        return this.iota;
    }

    @Nullable
    public IPFS getIpfs() {
        return this.ipfs;
    }

    @NonNull
    public EventsDatabase getEventsDatabase() {
        return this.eventsDatabase;
    }

    @NonNull
    public THREADS getThreads() {
        return this.threads;
    }

    @NonNull
    public ThreadsDatabase getThreadsDatabase() {
        return this.threadsDatabase;
    }

    public class ConsoleListener
    implements ApiListener {
        private boolean debug = false;
        private boolean report = false;

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean isReport() {
            return this.report;
        }

        public void setReport(boolean report) {
            this.report = report;
        }

        public void debug(@NonNull String message) {
            if (this.debug && this.report) {
                long timestamp = System.currentTimeMillis();
                new Thread(() -> {
                    Message em = Singleton.this.threads.createMessage(MessageKind.DEBUG, message, timestamp);
                    Singleton.this.threads.storeMessage(em);
                }).start();
            }
        }

        public void info(@NonNull String message) {
            if (this.report) {
                long timestamp = System.currentTimeMillis();
                new Thread(() -> {
                    Message em = Singleton.this.threads.createMessage(MessageKind.INFO, message, timestamp);
                    Singleton.this.threads.storeMessage(em);
                }).start();
            }
        }

        public void error(@NonNull String message) {
            if (this.report) {
                long timestamp = System.currentTimeMillis();
                new Thread(() -> {
                    Message em = Singleton.this.threads.createMessage(MessageKind.ERROR, message, timestamp);
                    Singleton.this.threads.storeMessage(em);
                }).start();
            }
        }

        public void cmd(@NonNull String message) {
            if (this.report) {
                long timestamp = System.currentTimeMillis();
                new Thread(() -> {
                    Message em = Singleton.this.threads.createMessage(MessageKind.CMD, message, timestamp);
                    Singleton.this.threads.storeMessage(em);
                }).start();
            }
        }
    }
}

