/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.HashMap;
import java.util.HashSet;
import threads.core.api.BlockAccountDao;
import threads.core.api.BlockAccountDao_Impl;
import threads.core.api.NoteDao;
import threads.core.api.NoteDao_Impl;
import threads.core.api.PeerDao;
import threads.core.api.PeerDao_Impl;
import threads.core.api.ServerDao;
import threads.core.api.ServerDao_Impl;
import threads.core.api.SettingsDao;
import threads.core.api.SettingsDao_Impl;
import threads.core.api.ThreadDao;
import threads.core.api.ThreadDao_Impl;
import threads.core.api.ThreadsDatabase;
import threads.core.api.UserDao;
import threads.core.api.UserDao_Impl;

public final class ThreadsDatabase_Impl
extends ThreadsDatabase {
    private volatile PeerDao _peerDao;
    private volatile UserDao _userDao;
    private volatile ThreadDao _threadDao;
    private volatile NoteDao _noteDao;
    private volatile BlockAccountDao _blockAccountDao;
    private volatile SettingsDao _settingsDao;
    private volatile ServerDao _serverDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(62){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `User` (`pid` TEXT NOT NULL, `publicKey` TEXT NOT NULL, `alias` TEXT NOT NULL, `type` INTEGER NOT NULL, `status` INTEGER NOT NULL, `image` TEXT, `additionals` TEXT NOT NULL, `hash` TEXT, `bundle` TEXT, `timestamp` INTEGER NOT NULL, PRIMARY KEY(`pid`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Thread` (`thread` INTEGER NOT NULL, `kind` INTEGER NOT NULL, `senderPid` TEXT NOT NULL, `senderKey` TEXT NOT NULL, `sesKey` TEXT NOT NULL, `date` INTEGER NOT NULL, `readOnly` INTEGER NOT NULL, `senderAlias` TEXT NOT NULL, `idx` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `image` TEXT, `markedFlag` INTEGER NOT NULL, `unreadNotes` INTEGER NOT NULL, `cid` TEXT, `expireDate` INTEGER NOT NULL, `status` INTEGER NOT NULL, `members` TEXT NOT NULL, `mimeType` TEXT NOT NULL, `additionals` TEXT NOT NULL, `hash` TEXT, `bundle` TEXT, `timestamp` INTEGER NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Note` (`senderPid` TEXT NOT NULL, `senderKey` TEXT NOT NULL, `sesKey` TEXT NOT NULL, `kind` INTEGER NOT NULL, `thread` TEXT, `noteType` INTEGER NOT NULL, `mimeType` TEXT NOT NULL, `date` INTEGER NOT NULL, `senderAlias` TEXT NOT NULL, `idx` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cid` TEXT, `status` INTEGER NOT NULL, `image` TEXT, `additionals` TEXT NOT NULL, `hash` TEXT, `bundle` TEXT, `timestamp` INTEGER NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `BlockAccount` (`pid` TEXT NOT NULL, PRIMARY KEY(`pid`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Settings` (`id` TEXT NOT NULL, `additionals` TEXT NOT NULL, `hash` TEXT, `bundle` TEXT, `timestamp` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Server` (`host` TEXT NOT NULL, `port` INTEGER NOT NULL, `protocol` TEXT NOT NULL, `alias` TEXT NOT NULL, `idx` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `additionals` TEXT NOT NULL, `hash` TEXT, `bundle` TEXT, `timestamp` INTEGER NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Peer` (`pid` TEXT NOT NULL, `addresses` TEXT NOT NULL, `additionals` TEXT NOT NULL, `hash` TEXT, `bundle` TEXT, `timestamp` INTEGER NOT NULL, PRIMARY KEY(`pid`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '19034fc325077d4d0e588d7b3795a075')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `User`");
                _db.execSQL("DROP TABLE IF EXISTS `Thread`");
                _db.execSQL("DROP TABLE IF EXISTS `Note`");
                _db.execSQL("DROP TABLE IF EXISTS `BlockAccount`");
                _db.execSQL("DROP TABLE IF EXISTS `Settings`");
                _db.execSQL("DROP TABLE IF EXISTS `Server`");
                _db.execSQL("DROP TABLE IF EXISTS `Peer`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (ThreadsDatabase_Impl.this.mCallbacks != null) {
                    int _size = ThreadsDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ThreadsDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                ThreadsDatabase_Impl.this.mDatabase = _db;
                ThreadsDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (ThreadsDatabase_Impl.this.mCallbacks != null) {
                    int _size = ThreadsDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ThreadsDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsUser = new HashMap<String, TableInfo.Column>(10);
                _columnsUser.put("pid", new TableInfo.Column("pid", "TEXT", true, 1));
                _columnsUser.put("publicKey", new TableInfo.Column("publicKey", "TEXT", true, 0));
                _columnsUser.put("alias", new TableInfo.Column("alias", "TEXT", true, 0));
                _columnsUser.put("type", new TableInfo.Column("type", "INTEGER", true, 0));
                _columnsUser.put("status", new TableInfo.Column("status", "INTEGER", true, 0));
                _columnsUser.put("image", new TableInfo.Column("image", "TEXT", false, 0));
                _columnsUser.put("additionals", new TableInfo.Column("additionals", "TEXT", true, 0));
                _columnsUser.put("hash", new TableInfo.Column("hash", "TEXT", false, 0));
                _columnsUser.put("bundle", new TableInfo.Column("bundle", "TEXT", false, 0));
                _columnsUser.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0));
                HashSet _foreignKeysUser = new HashSet(0);
                HashSet _indicesUser = new HashSet(0);
                TableInfo _infoUser = new TableInfo("User", _columnsUser, _foreignKeysUser, _indicesUser);
                TableInfo _existingUser = TableInfo.read((SupportSQLiteDatabase)_db, (String)"User");
                if (!_infoUser.equals((Object)_existingUser)) {
                    throw new IllegalStateException("Migration didn't properly handle User(threads.core.api.User).\n Expected:\n" + _infoUser + "\n Found:\n" + _existingUser);
                }
                HashMap<String, TableInfo.Column> _columnsThread = new HashMap<String, TableInfo.Column>(21);
                _columnsThread.put("thread", new TableInfo.Column("thread", "INTEGER", true, 0));
                _columnsThread.put("kind", new TableInfo.Column("kind", "INTEGER", true, 0));
                _columnsThread.put("senderPid", new TableInfo.Column("senderPid", "TEXT", true, 0));
                _columnsThread.put("senderKey", new TableInfo.Column("senderKey", "TEXT", true, 0));
                _columnsThread.put("sesKey", new TableInfo.Column("sesKey", "TEXT", true, 0));
                _columnsThread.put("date", new TableInfo.Column("date", "INTEGER", true, 0));
                _columnsThread.put("readOnly", new TableInfo.Column("readOnly", "INTEGER", true, 0));
                _columnsThread.put("senderAlias", new TableInfo.Column("senderAlias", "TEXT", true, 0));
                _columnsThread.put("idx", new TableInfo.Column("idx", "INTEGER", true, 1));
                _columnsThread.put("image", new TableInfo.Column("image", "TEXT", false, 0));
                _columnsThread.put("markedFlag", new TableInfo.Column("markedFlag", "INTEGER", true, 0));
                _columnsThread.put("unreadNotes", new TableInfo.Column("unreadNotes", "INTEGER", true, 0));
                _columnsThread.put("cid", new TableInfo.Column("cid", "TEXT", false, 0));
                _columnsThread.put("expireDate", new TableInfo.Column("expireDate", "INTEGER", true, 0));
                _columnsThread.put("status", new TableInfo.Column("status", "INTEGER", true, 0));
                _columnsThread.put("members", new TableInfo.Column("members", "TEXT", true, 0));
                _columnsThread.put("mimeType", new TableInfo.Column("mimeType", "TEXT", true, 0));
                _columnsThread.put("additionals", new TableInfo.Column("additionals", "TEXT", true, 0));
                _columnsThread.put("hash", new TableInfo.Column("hash", "TEXT", false, 0));
                _columnsThread.put("bundle", new TableInfo.Column("bundle", "TEXT", false, 0));
                _columnsThread.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0));
                HashSet _foreignKeysThread = new HashSet(0);
                HashSet _indicesThread = new HashSet(0);
                TableInfo _infoThread = new TableInfo("Thread", _columnsThread, _foreignKeysThread, _indicesThread);
                TableInfo _existingThread = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Thread");
                if (!_infoThread.equals((Object)_existingThread)) {
                    throw new IllegalStateException("Migration didn't properly handle Thread(threads.core.api.Thread).\n Expected:\n" + _infoThread + "\n Found:\n" + _existingThread);
                }
                HashMap<String, TableInfo.Column> _columnsNote = new HashMap<String, TableInfo.Column>(17);
                _columnsNote.put("senderPid", new TableInfo.Column("senderPid", "TEXT", true, 0));
                _columnsNote.put("senderKey", new TableInfo.Column("senderKey", "TEXT", true, 0));
                _columnsNote.put("sesKey", new TableInfo.Column("sesKey", "TEXT", true, 0));
                _columnsNote.put("kind", new TableInfo.Column("kind", "INTEGER", true, 0));
                _columnsNote.put("thread", new TableInfo.Column("thread", "TEXT", false, 0));
                _columnsNote.put("noteType", new TableInfo.Column("noteType", "INTEGER", true, 0));
                _columnsNote.put("mimeType", new TableInfo.Column("mimeType", "TEXT", true, 0));
                _columnsNote.put("date", new TableInfo.Column("date", "INTEGER", true, 0));
                _columnsNote.put("senderAlias", new TableInfo.Column("senderAlias", "TEXT", true, 0));
                _columnsNote.put("idx", new TableInfo.Column("idx", "INTEGER", true, 1));
                _columnsNote.put("cid", new TableInfo.Column("cid", "TEXT", false, 0));
                _columnsNote.put("status", new TableInfo.Column("status", "INTEGER", true, 0));
                _columnsNote.put("image", new TableInfo.Column("image", "TEXT", false, 0));
                _columnsNote.put("additionals", new TableInfo.Column("additionals", "TEXT", true, 0));
                _columnsNote.put("hash", new TableInfo.Column("hash", "TEXT", false, 0));
                _columnsNote.put("bundle", new TableInfo.Column("bundle", "TEXT", false, 0));
                _columnsNote.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0));
                HashSet _foreignKeysNote = new HashSet(0);
                HashSet _indicesNote = new HashSet(0);
                TableInfo _infoNote = new TableInfo("Note", _columnsNote, _foreignKeysNote, _indicesNote);
                TableInfo _existingNote = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Note");
                if (!_infoNote.equals((Object)_existingNote)) {
                    throw new IllegalStateException("Migration didn't properly handle Note(threads.core.api.Note).\n Expected:\n" + _infoNote + "\n Found:\n" + _existingNote);
                }
                HashMap<String, TableInfo.Column> _columnsBlockAccount = new HashMap<String, TableInfo.Column>(1);
                _columnsBlockAccount.put("pid", new TableInfo.Column("pid", "TEXT", true, 1));
                HashSet _foreignKeysBlockAccount = new HashSet(0);
                HashSet _indicesBlockAccount = new HashSet(0);
                TableInfo _infoBlockAccount = new TableInfo("BlockAccount", _columnsBlockAccount, _foreignKeysBlockAccount, _indicesBlockAccount);
                TableInfo _existingBlockAccount = TableInfo.read((SupportSQLiteDatabase)_db, (String)"BlockAccount");
                if (!_infoBlockAccount.equals((Object)_existingBlockAccount)) {
                    throw new IllegalStateException("Migration didn't properly handle BlockAccount(threads.core.api.BlockAccount).\n Expected:\n" + _infoBlockAccount + "\n Found:\n" + _existingBlockAccount);
                }
                HashMap<String, TableInfo.Column> _columnsSettings = new HashMap<String, TableInfo.Column>(5);
                _columnsSettings.put("id", new TableInfo.Column("id", "TEXT", true, 1));
                _columnsSettings.put("additionals", new TableInfo.Column("additionals", "TEXT", true, 0));
                _columnsSettings.put("hash", new TableInfo.Column("hash", "TEXT", false, 0));
                _columnsSettings.put("bundle", new TableInfo.Column("bundle", "TEXT", false, 0));
                _columnsSettings.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0));
                HashSet _foreignKeysSettings = new HashSet(0);
                HashSet _indicesSettings = new HashSet(0);
                TableInfo _infoSettings = new TableInfo("Settings", _columnsSettings, _foreignKeysSettings, _indicesSettings);
                TableInfo _existingSettings = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Settings");
                if (!_infoSettings.equals((Object)_existingSettings)) {
                    throw new IllegalStateException("Migration didn't properly handle Settings(threads.core.api.Settings).\n Expected:\n" + _infoSettings + "\n Found:\n" + _existingSettings);
                }
                HashMap<String, TableInfo.Column> _columnsServer = new HashMap<String, TableInfo.Column>(9);
                _columnsServer.put("host", new TableInfo.Column("host", "TEXT", true, 0));
                _columnsServer.put("port", new TableInfo.Column("port", "INTEGER", true, 0));
                _columnsServer.put("protocol", new TableInfo.Column("protocol", "TEXT", true, 0));
                _columnsServer.put("alias", new TableInfo.Column("alias", "TEXT", true, 0));
                _columnsServer.put("idx", new TableInfo.Column("idx", "INTEGER", true, 1));
                _columnsServer.put("additionals", new TableInfo.Column("additionals", "TEXT", true, 0));
                _columnsServer.put("hash", new TableInfo.Column("hash", "TEXT", false, 0));
                _columnsServer.put("bundle", new TableInfo.Column("bundle", "TEXT", false, 0));
                _columnsServer.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0));
                HashSet _foreignKeysServer = new HashSet(0);
                HashSet _indicesServer = new HashSet(0);
                TableInfo _infoServer = new TableInfo("Server", _columnsServer, _foreignKeysServer, _indicesServer);
                TableInfo _existingServer = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Server");
                if (!_infoServer.equals((Object)_existingServer)) {
                    throw new IllegalStateException("Migration didn't properly handle Server(threads.core.api.Server).\n Expected:\n" + _infoServer + "\n Found:\n" + _existingServer);
                }
                HashMap<String, TableInfo.Column> _columnsPeer = new HashMap<String, TableInfo.Column>(6);
                _columnsPeer.put("pid", new TableInfo.Column("pid", "TEXT", true, 1));
                _columnsPeer.put("addresses", new TableInfo.Column("addresses", "TEXT", true, 0));
                _columnsPeer.put("additionals", new TableInfo.Column("additionals", "TEXT", true, 0));
                _columnsPeer.put("hash", new TableInfo.Column("hash", "TEXT", false, 0));
                _columnsPeer.put("bundle", new TableInfo.Column("bundle", "TEXT", false, 0));
                _columnsPeer.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0));
                HashSet _foreignKeysPeer = new HashSet(0);
                HashSet _indicesPeer = new HashSet(0);
                TableInfo _infoPeer = new TableInfo("Peer", _columnsPeer, _foreignKeysPeer, _indicesPeer);
                TableInfo _existingPeer = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Peer");
                if (!_infoPeer.equals((Object)_existingPeer)) {
                    throw new IllegalStateException("Migration didn't properly handle Peer(threads.core.api.Peer).\n Expected:\n" + _infoPeer + "\n Found:\n" + _existingPeer);
                }
            }
        }, "19034fc325077d4d0e588d7b3795a075", "e84fb434e83a7c1bc9511e7708a4f7ed");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"User", "Thread", "Note", "BlockAccount", "Settings", "Server", "Peer"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `User`");
            _db.execSQL("DELETE FROM `Thread`");
            _db.execSQL("DELETE FROM `Note`");
            _db.execSQL("DELETE FROM `BlockAccount`");
            _db.execSQL("DELETE FROM `Settings`");
            _db.execSQL("DELETE FROM `Server`");
            _db.execSQL("DELETE FROM `Peer`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeerDao peerDao() {
        if (this._peerDao != null) {
            return this._peerDao;
        }
        ThreadsDatabase_Impl threadsDatabase_Impl = this;
        synchronized (threadsDatabase_Impl) {
            if (this._peerDao == null) {
                this._peerDao = new PeerDao_Impl(this);
            }
            return this._peerDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDao userDao() {
        if (this._userDao != null) {
            return this._userDao;
        }
        ThreadsDatabase_Impl threadsDatabase_Impl = this;
        synchronized (threadsDatabase_Impl) {
            if (this._userDao == null) {
                this._userDao = new UserDao_Impl(this);
            }
            return this._userDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadDao threadDao() {
        if (this._threadDao != null) {
            return this._threadDao;
        }
        ThreadsDatabase_Impl threadsDatabase_Impl = this;
        synchronized (threadsDatabase_Impl) {
            if (this._threadDao == null) {
                this._threadDao = new ThreadDao_Impl(this);
            }
            return this._threadDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NoteDao noteDao() {
        if (this._noteDao != null) {
            return this._noteDao;
        }
        ThreadsDatabase_Impl threadsDatabase_Impl = this;
        synchronized (threadsDatabase_Impl) {
            if (this._noteDao == null) {
                this._noteDao = new NoteDao_Impl(this);
            }
            return this._noteDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockAccountDao blockAccountDao() {
        if (this._blockAccountDao != null) {
            return this._blockAccountDao;
        }
        ThreadsDatabase_Impl threadsDatabase_Impl = this;
        synchronized (threadsDatabase_Impl) {
            if (this._blockAccountDao == null) {
                this._blockAccountDao = new BlockAccountDao_Impl(this);
            }
            return this._blockAccountDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettingsDao settingsDao() {
        if (this._settingsDao != null) {
            return this._settingsDao;
        }
        ThreadsDatabase_Impl threadsDatabase_Impl = this;
        synchronized (threadsDatabase_Impl) {
            if (this._settingsDao == null) {
                this._settingsDao = new SettingsDao_Impl(this);
            }
            return this._settingsDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerDao serverDao() {
        if (this._serverDao != null) {
            return this._serverDao;
        }
        ThreadsDatabase_Impl threadsDatabase_Impl = this;
        synchronized (threadsDatabase_Impl) {
            if (this._serverDao == null) {
                this._serverDao = new ServerDao_Impl(this);
            }
            return this._serverDao;
        }
    }
}

