/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Addresses;
import threads.core.api.Content;
import threads.core.api.Peer;

public class PeerEncoder {
    @NonNull
    public static Content convert(@NonNull Peer peer) {
        Preconditions.checkNotNull((Object)peer);
        Content content = new Content();
        String addresses = Addresses.toString(peer.getAddresses());
        if (addresses != null) {
            content.put("peers", addresses);
        }
        HashMap<String, String> additions = peer.getExternalAdditions();
        Preconditions.checkNotNull(additions);
        content.put("adds", Additionals.toString(additions));
        return content;
    }
}

