/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Thread;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

public class NoteRequestEncoder {
    @NonNull
    public static Content convert(@NonNull String publicKey, @NonNull Thread thread, boolean publishImage) throws Exception {
        CID image;
        Preconditions.checkNotNull((Object)publicKey);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkArgument((!publicKey.isEmpty() ? 1 : 0) != 0);
        Content content = new Content();
        String sesKey = thread.getSesKey();
        content.put("pid", thread.getSenderPid().getPid());
        content.put("pubKey", thread.getSenderKey());
        content.put("date", String.valueOf(thread.getDate().getTime()));
        content.put("ro", String.valueOf(thread.isReadOnly()));
        content.put("alias", Encryption.encrypt((String)thread.getSenderAlias(), (String)sesKey));
        if (!sesKey.isEmpty()) {
            content.put("sesKey", Encryption.encryptRSA((String)sesKey, (String)publicKey));
        }
        CID cid = thread.getCid();
        Preconditions.checkNotNull((Object)cid);
        content.put("cid", Encryption.encrypt((String)cid.getCid(), (String)sesKey));
        HashMap<String, String> additions = thread.getExternalAdditions();
        Preconditions.checkNotNull(additions);
        content.put("adds", Encryption.encrypt((String)Additionals.toString(additions), (String)sesKey));
        if (publishImage && (image = thread.getImage()) != null) {
            content.put("img", Encryption.encrypt((String)image.getCid(), (String)sesKey));
        }
        return content;
    }
}

