package threads.core.api;

import androidx.annotation.NonNull;

import java.util.HashMap;

import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

import static androidx.core.util.Preconditions.checkArgument;
import static androidx.core.util.Preconditions.checkNotNull;

public class NoteRequestEncoder {


    @NonNull
    public static Content convert(@NonNull String publicKey,
                                  @NonNull Thread thread,
                                  boolean publishImage) throws Exception {
        checkNotNull(publicKey);
        checkNotNull(thread);
        checkArgument(!publicKey.isEmpty());
        Content content = new Content();

        String sesKey = thread.getSesKey();

        // NOT ENCRYPTED
        content.put(Content.PID, thread.getSenderPid().getPid());

        // NOT ENCRYPTED
        content.put(Content.PKEY, thread.getSenderKey());

        // NOT ENCRYPTED
        content.put(Content.DATE, String.valueOf(thread.getDate().getTime()));

        // NOT ENCRYPTED
        content.put(Content.READ_ONLY, String.valueOf(thread.isReadOnly()));


        // ENCRYPTED
        content.put(Content.ALIAS, Encryption.encrypt(thread.getSenderAlias(), sesKey));

        // ENCRYPTED
        if (!sesKey.isEmpty()) {
            content.put(Content.SKEY, Encryption.encryptRSA(sesKey, publicKey));
        }

        // ENCRYPTED
        CID cid = thread.getCid();
        checkNotNull(cid);
        content.put(Content.CID, Encryption.encrypt(cid.getCid(), sesKey));


        // ENCRYPTED
        HashMap<String, String> additions = thread.getExternalAdditions();
        checkNotNull(additions);
        content.put(Content.ADDS, Encryption.encrypt(Additionals.toString(additions), sesKey));

        // ENCRYPTED
        if (publishImage) {
            CID image = thread.getImage();
            if (image != null) {
                content.put(Content.IMG, Encryption.encrypt(image.getCid(), sesKey));
            }
        }


        return content;
    }
}
