/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import javax.crypto.SecretKey;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Thread;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

public class NoteRequestEncoder {
    @NonNull
    public static Content convert(@NonNull String publicKey, @NonNull Thread thread, boolean publishImage) throws Exception {
        CID image;
        Preconditions.checkNotNull((Object)publicKey);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkArgument((!publicKey.isEmpty() ? 1 : 0) != 0);
        Content content = new Content();
        Pair encSesKey = Encryption.getEncryptedSessionKey((String)publicKey);
        SecretKey aesKey = (SecretKey)encSesKey.first;
        String encSecKey = (String)encSesKey.second;
        content.put("esk", encSecKey);
        content.put("pid", thread.getSenderPid().getPid());
        content.put("pubKey", thread.getSenderKey());
        content.put("date", String.valueOf(thread.getDate().getTime()));
        content.put("ro", String.valueOf(thread.isReadOnly()));
        content.put("alias", Encryption.getEncryptedSessionData((SecretKey)aesKey, (String)thread.getSenderAlias()));
        content.put("sesKey", Encryption.getEncryptedSessionData((SecretKey)aesKey, (String)thread.getSesKey()));
        CID cid = thread.getCid();
        Preconditions.checkNotNull((Object)cid);
        content.put("cid", Encryption.getEncryptedSessionData((SecretKey)aesKey, (String)cid.getCid()));
        HashMap<String, String> additions = thread.getExternalAdditions();
        Preconditions.checkNotNull(additions);
        content.put("adds", Encryption.getEncryptedSessionData((SecretKey)aesKey, (String)Additionals.toString(additions)));
        if (publishImage && (image = thread.getImage()) != null) {
            content.put("img", Encryption.encrypt((String)image.getCid(), (String)thread.getSesKey()));
        }
        return content;
    }
}

