/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.Date;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Kind;
import threads.core.api.Thread;
import threads.core.api.ThreadStatus;
import threads.iota.Entity;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

public class NotePublishDecoder {
    private static final String TAG = NotePublishDecoder.class.getSimpleName();

    @Nullable
    public static Thread convert(@NonNull Entity entity, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)aesKey);
        try {
            String imgValue;
            Long timestamp = entity.getTimestamp();
            Preconditions.checkNotNull((Object)timestamp);
            String encContent = Encryption.decrypt((String)entity.getContent(), (String)aesKey);
            Gson gson = new Gson();
            Content content = (Content)gson.fromJson(encContent, Content.class);
            String senderPid = (String)content.get("pid");
            Preconditions.checkNotNull((Object)senderPid);
            String additions = (String)content.get("adds");
            Preconditions.checkNotNull((Object)additions);
            String readOnlyString = (String)content.get("ro");
            Preconditions.checkNotNull((Object)readOnlyString);
            boolean isReadOnly = Boolean.valueOf(readOnlyString);
            String sesKey = (String)content.get("sesKey");
            Preconditions.checkNotNull((Object)sesKey);
            String senderAlias = (String)content.get("alias");
            Preconditions.checkNotNull((Object)senderAlias);
            String senderKey = (String)content.get("pubKey");
            Preconditions.checkNotNull((Object)senderKey);
            String cidValue = (String)content.get("cid");
            CID cid = null;
            if (cidValue != null) {
                cid = CID.create((String)cidValue);
            }
            String date = (String)content.get("date");
            Preconditions.checkNotNull((Object)date);
            Thread thread = Thread.createThread(ThreadStatus.ONLINE, PID.create((String)senderPid), senderAlias, senderKey, sesKey, Kind.IN, new Date(Long.valueOf(date)), 0L, isReadOnly);
            thread.setCid(cid);
            if (!additions.isEmpty()) {
                thread.setExternalAdditions(Additionals.toHashMap(additions));
            }
            if ((imgValue = (String)content.get("img")) != null) {
                thread.setImage(CID.create((String)imgValue));
            }
            String expireDate = (String)content.get("exp");
            Preconditions.checkNotNull((Object)expireDate);
            thread.setExpireDate(new Date(Long.valueOf(expireDate)));
            thread.setMarkedFlag(false);
            thread.setHash(entity.getHash());
            thread.setBundle(entity.getBundle());
            thread.setTimestamp(entity.getTimestamp());
            return thread;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

