/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.Objects;
import threads.core.api.Server;

public class ServerInfo {
    @NonNull
    private final int port;
    @NonNull
    private final String host;
    @NonNull
    private final String protocol;
    private boolean online = true;
    private long milestone = 0L;
    @NonNull
    private String name = "N/A";
    @NonNull
    private String version = "N/A";
    private boolean supportPoW;

    ServerInfo(@NonNull String protocol, @NonNull String host, int port) {
        Preconditions.checkNotNull((Object)protocol);
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0);
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.supportPoW = false;
    }

    public static ServerInfo createServerInfo(@NonNull String protocol, @NonNull String host, int port) {
        return new ServerInfo(protocol, host, port);
    }

    public static ServerInfo createServerInfo(@NonNull Server server) {
        return ServerInfo.createServerInfo(server.getProtocol(), server.getHost(), server.getPort());
    }

    @NonNull
    public String toString() {
        return "ServerInfo{, port='" + this.port + '\'' + ", host='" + this.host + '\'' + ", protocol='" + this.protocol + '\'' + ", online=" + this.online + ", milestone=" + this.milestone + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", supportPoW=" + this.supportPoW + '}';
    }

    public String getDisplayName() {
        return Server.getServer(this, false);
    }

    public boolean isSupportPoW() {
        return this.supportPoW;
    }

    public void setSupportPoW(boolean supportPoW) {
        this.supportPoW = supportPoW;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInfo that = (ServerInfo)o;
        return this.online == that.online && this.milestone == that.milestone && this.supportPoW == that.supportPoW && Objects.equals(this.port, that.port) && Objects.equals(this.host, that.host) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.host, this.protocol, this.online, this.milestone, this.name, this.version, this.supportPoW);
    }

    @NonNull
    public int getPort() {
        return this.port;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    @NonNull
    public String getProtocol() {
        return this.protocol;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@NonNull String version) {
        this.version = version;
    }

    public long getMilestone() {
        return this.milestone;
    }

    public void setMilestone(long milestone) {
        this.milestone = milestone;
    }
}

