package threads.core.api;

import android.util.Pair;

import androidx.annotation.NonNull;

import java.util.HashMap;

import javax.crypto.SecretKey;

import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

import static androidx.core.util.Preconditions.checkArgument;
import static androidx.core.util.Preconditions.checkNotNull;

public class NoteRequestEncoder {


    @NonNull
    public static Content convert(@NonNull String publicKey,
                                  @NonNull Thread thread,
                                  boolean publishImage) throws Exception {
        checkNotNull(publicKey);
        checkNotNull(thread);
        checkArgument(!publicKey.isEmpty());
        Content content = new Content();
        Pair<SecretKey, String> encSesKey = Encryption.getEncryptedSessionKey(publicKey);
        SecretKey aesKey = encSesKey.first;
        String encSecKey = encSesKey.second;

        // NOT ENCRYPTED
        content.put(Content.ESK, encSecKey);

        // NOT ENCRYPTED
        content.put(Content.PID, thread.getSenderPid().getPid());

        // NOT ENCRYPTED
        content.put(Content.PKEY, thread.getSenderKey());

        // NOT ENCRYPTED
        content.put(Content.DATE, String.valueOf(thread.getDate().getTime()));

        // NOT ENCRYPTED
        content.put(Content.READ_ONLY, String.valueOf(thread.isReadOnly()));


        // ENCRYPTED
        content.put(Content.ALIAS,
                Encryption.getEncryptedSessionData(aesKey, thread.getSenderAlias()));

        // ENCRYPTED
        content.put(Content.SKEY,
                Encryption.getEncryptedSessionData(aesKey, thread.getSesKey()));

        // ENCRYPTED
        CID cid = thread.getCid();
        checkNotNull(cid);
        content.put(Content.CID, Encryption.getEncryptedSessionData(aesKey, cid.getCid()));


        // ENCRYPTED
        HashMap<String, String> additions = thread.getExternalAdditions();
        checkNotNull(additions);
        content.put(Content.ADDS,
                Encryption.getEncryptedSessionData(aesKey, Additionals.toString(additions)));

        // ENCRYPTED
        if (publishImage) {
            CID image = thread.getImage();
            if (image != null) {
                content.put(Content.IMG,
                        Encryption.encrypt(image.getCid(), thread.getSesKey()));
            }
        }


        return content;
    }
}
