/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import threads.core.api.BlockAccount;
import threads.core.api.BlockAccountDao;

public final class BlockAccountDao_Impl
implements BlockAccountDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfBlockAccount;
    private final SharedSQLiteStatement __preparedStmtOfRemoveBlockAccountByPid;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public BlockAccountDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfBlockAccount = new EntityInsertionAdapter<BlockAccount>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BlockAccount`(`pid`) VALUES (?)";
            }

            public void bind(SupportSQLiteStatement stmt, BlockAccount value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
            }
        };
        this.__preparedStmtOfRemoveBlockAccountByPid = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM BlockAccount WHERE pid = ?";
                return "DELETE FROM BlockAccount WHERE pid = ?";
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM BlockAccount";
                return "DELETE FROM BlockAccount";
            }
        };
    }

    @Override
    public void insertBlockAccounts(BlockAccount ... pids) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfBlockAccount.insert((Object[])pids);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBlockAccountByPid(String pid) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveBlockAccountByPid.acquire();
        int _argIndex = 1;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemoveBlockAccountByPid.release(_stmt);
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockAccount getBlockAccountByPid(String pid) {
        String _sql = "SELECT * FROM BlockAccount  WHERE pid =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM BlockAccount  WHERE pid =?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            BlockAccount _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                _result = new BlockAccount(_tmpPid);
            } else {
                _result = null;
            }
            BlockAccount blockAccount = _result;
            return blockAccount;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

