/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import threads.core.api.Additionals;
import threads.core.api.Converter;
import threads.core.api.User;
import threads.core.api.UserDao;
import threads.core.api.UserStatus;
import threads.core.api.UserType;
import threads.ipfs.api.CID;

public final class UserDao_Impl
implements UserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfUser;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfUser;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfUser;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfSetHash;
    private final SharedSQLiteStatement __preparedStmtOfSetAlias;
    private final SharedSQLiteStatement __preparedStmtOfSetPublicKey;
    private final SharedSQLiteStatement __preparedStmtOfSetImage;
    private final SharedSQLiteStatement __preparedStmtOfRemoveUserByPid;
    private final SharedSQLiteStatement __preparedStmtOfSetUserType;
    private final SharedSQLiteStatement __preparedStmtOfSetUserStatus;
    private final SharedSQLiteStatement __preparedStmtOfSetUserStatus_1;
    private final SharedSQLiteStatement __preparedStmtOfSetBundle;

    public UserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUser = new EntityInsertionAdapter<User>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `User`(`pid`,`publicKey`,`alias`,`type`,`status`,`image`,`additionals`,`hash`,`bundle`,`timestamp`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, User value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                if (value.getPublicKey() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPublicKey());
                }
                if (value.getAlias() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAlias());
                }
                Integer _tmp = UserType.toInteger(value.getType());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)_tmp.intValue());
                }
                Integer _tmp_1 = UserStatus.toInteger(value.getStatus());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, (long)_tmp_1.intValue());
                }
                String _tmp_2 = Converter.toString(value.getImage());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = Additionals.toString(value.getAdditionals());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getBundle());
                }
                stmt.bindLong(10, value.getTimestamp());
            }
        };
        this.__deletionAdapterOfUser = new EntityDeletionOrUpdateAdapter<User>(__db){

            public String createQuery() {
                return "DELETE FROM `User` WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, User value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
            }
        };
        this.__updateAdapterOfUser = new EntityDeletionOrUpdateAdapter<User>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `User` SET `pid` = ?,`publicKey` = ?,`alias` = ?,`type` = ?,`status` = ?,`image` = ?,`additionals` = ?,`hash` = ?,`bundle` = ?,`timestamp` = ? WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, User value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                if (value.getPublicKey() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPublicKey());
                }
                if (value.getAlias() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAlias());
                }
                Integer _tmp = UserType.toInteger(value.getType());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)_tmp.intValue());
                }
                Integer _tmp_1 = UserStatus.toInteger(value.getStatus());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, (long)_tmp_1.intValue());
                }
                String _tmp_2 = Converter.toString(value.getImage());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = Additionals.toString(value.getAdditionals());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getBundle());
                }
                stmt.bindLong(10, value.getTimestamp());
                if (value.getPid() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getPid());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM User";
                return "DELETE FROM User";
            }
        };
        this.__preparedStmtOfSetHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET hash = ? WHERE pid = ?";
                return "UPDATE User SET hash = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetAlias = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET alias = ? WHERE pid = ?";
                return "UPDATE User SET alias = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetPublicKey = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET publicKey = ? WHERE pid = ?";
                return "UPDATE User SET publicKey = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetImage = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET image = ? WHERE pid = ?";
                return "UPDATE User SET image = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfRemoveUserByPid = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM User WHERE pid = ?";
                return "DELETE FROM User WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetUserType = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET type = ? WHERE pid = ?";
                return "UPDATE User SET type = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetUserStatus = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET status = ? WHERE pid = ?";
                return "UPDATE User SET status = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetUserStatus_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET status = ? WHERE status = ?";
                return "UPDATE User SET status = ? WHERE status = ?";
            }
        };
        this.__preparedStmtOfSetBundle = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET bundle = ? WHERE pid = ?";
                return "UPDATE User SET bundle = ? WHERE pid = ?";
            }
        };
    }

    @Override
    public void insertUsers(User ... users) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUser.insert((Object[])users);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void removeUsers(User ... users) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUser.handleMultiple((Object[])users);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateUser(User user) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUser.handle((Object)user);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHash(String pid, String hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetHash.acquire();
        int _argIndex = 1;
        if (hash == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, hash);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlias(String pid, String alias) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetAlias.acquire();
        int _argIndex = 1;
        if (alias == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, alias);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetAlias.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublicKey(String pid, String publicKey) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetPublicKey.acquire();
        int _argIndex = 1;
        if (publicKey == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, publicKey);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetPublicKey.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImage(String pid, CID image) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetImage.acquire();
        int _argIndex = 1;
        String _tmp = Converter.toString(image);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetImage.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUserByPid(String pid) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveUserByPid.acquire();
        int _argIndex = 1;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemoveUserByPid.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserType(String pid, UserType type) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetUserType.acquire();
        int _argIndex = 1;
        Integer _tmp = UserType.toInteger(type);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetUserType.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserStatus(String pid, UserStatus status) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetUserStatus.acquire();
        int _argIndex = 1;
        Integer _tmp = UserStatus.toInteger(status);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetUserStatus.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserStatus(UserStatus oldStatus, UserStatus newStatus) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetUserStatus_1.acquire();
        int _argIndex = 1;
        Integer _tmp = UserStatus.toInteger(newStatus);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer _tmp_1 = UserStatus.toInteger(oldStatus);
        if (_tmp_1 == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetUserStatus_1.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundle(String pid, String bundle) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetBundle.acquire();
        int _argIndex = 1;
        if (bundle == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, bundle);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetBundle.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> getUsersByStatus(UserStatus status) {
        String _sql = "SELECT * FROM User WHERE status LIKE ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User WHERE status LIKE ?", (int)1);
        int _argIndex = 1;
        Integer _tmp = UserStatus.toInteger(status);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<User> _result = new ArrayList<User>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                UserType _tmpType = UserType.toUserType(_tmp_1);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                UserStatus _tmpStatus = UserStatus.toUserStatus(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                User _item = new User(_tmpType, _tmpStatus, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                String _tmp_4 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_4);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<User> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> getUsers() {
        String _sql = "SELECT * FROM User";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<User> _result = new ArrayList<User>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                UserType _tmpType = UserType.toUserType(_tmp);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                UserStatus _tmpStatus = UserStatus.toUserStatus(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_2);
                User _item = new User(_tmpType, _tmpStatus, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                String _tmp_3 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_3);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<User> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPublicKey(String pid) {
        String _sql = "SELECT publicKey FROM User WHERE pid = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT publicKey FROM User WHERE pid = ? ", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            String _result = _cursor.moveToFirst() ? _cursor.getString(0) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlias(String pid) {
        String _sql = "SELECT alias FROM User WHERE pid = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT alias FROM User WHERE pid = ? ", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            String _result = _cursor.moveToFirst() ? _cursor.getString(0) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUserByPid(String pid) {
        String _sql = "SELECT * FROM User WHERE pid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            User _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                UserType _tmpType = UserType.toUserType(_tmp);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                UserStatus _tmpStatus = UserStatus.toUserStatus(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_2);
                _result = new User(_tmpType, _tmpStatus, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                String _tmp_3 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_3);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<User> getLiveDataUser(String pid) {
        String _sql = "SELECT * FROM User WHERE pid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"User"}, false, (Callable)new Callable<User>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public User call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    User _result;
                    int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
                    int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
                    int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    if (_cursor.moveToFirst()) {
                        String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                        String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                        String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                        UserType _tmpType = UserType.toUserType(_tmp);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                        UserStatus _tmpStatus = UserStatus.toUserStatus(_tmp_1);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_2);
                        _result = new User(_tmpType, _tmpStatus, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_3);
                        _result.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _result.setHash(_tmpHash);
                        String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                        _result.setBundle(_tmpBundle);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _result.setTimestamp(_tmpTimestamp);
                    } else {
                        _result = null;
                    }
                    User user = _result;
                    return user;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<User>> getLiveDataUsers() {
        String _sql = "SELECT * FROM User";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"User"}, false, (Callable)new Callable<List<User>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<User> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
                    int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
                    int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<User> _result = new ArrayList<User>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                        String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                        String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                        UserType _tmpType = UserType.toUserType(_tmp);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                        UserStatus _tmpStatus = UserStatus.toUserStatus(_tmp_1);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_2);
                        User _item = new User(_tmpType, _tmpStatus, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_3);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                        _item.setBundle(_tmpBundle);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<User> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<User>> getLiveDataUsersByType(UserType type) {
        String _sql = "SELECT * FROM User WHERE type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User WHERE type = ?", (int)1);
        int _argIndex = 1;
        Integer _tmp = UserType.toInteger(type);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"User"}, false, (Callable)new Callable<List<User>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<User> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
                    int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
                    int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<User> _result = new ArrayList<User>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                        String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                        String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                        UserType _tmpType = UserType.toUserType(_tmp_1);
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                        UserStatus _tmpStatus = UserStatus.toUserStatus(_tmp_2);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_3);
                        User _item = new User(_tmpType, _tmpStatus, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_4);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                        _item.setBundle(_tmpBundle);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<User> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUserByHash(String hash) {
        String _sql = "SELECT * FROM User WHERE hash =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User WHERE hash =?", (int)1);
        int _argIndex = 1;
        if (hash == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, hash);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            User _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                UserType _tmpType = UserType.toUserType(_tmp);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                UserStatus _tmpStatus = UserStatus.toUserStatus(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_2);
                _result = new User(_tmpType, _tmpStatus, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                String _tmp_3 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_3);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserStatus getUserStatus(String pid) {
        String _sql = "SELECT status FROM User WHERE pid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT status FROM User WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            UserStatus _result;
            if (_cursor.moveToFirst()) {
                Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                _result = UserStatus.toUserStatus(_tmp);
            } else {
                _result = null;
            }
            UserStatus userStatus = _result;
            return userStatus;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

