/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.TypeConverter;

public enum MessageKind {
    CMD(0),
    ERROR(1),
    INFO(2),
    DEBUG(3);

    @NonNull
    private final Integer code;

    private MessageKind(Integer code) {
        Preconditions.checkNotNull((Object)code);
        this.code = code;
    }

    @TypeConverter
    public static MessageKind toMessageKind(Integer messageKind) {
        Preconditions.checkNotNull((Object)messageKind);
        if (messageKind.equals(CMD.getCode())) {
            return CMD;
        }
        if (messageKind.equals(ERROR.getCode())) {
            return ERROR;
        }
        if (messageKind.equals(INFO.getCode())) {
            return INFO;
        }
        if (messageKind.equals(DEBUG.getCode())) {
            return DEBUG;
        }
        throw new IllegalArgumentException("Could not recognize status");
    }

    @TypeConverter
    public static Integer toInteger(@NonNull MessageKind messageKind) {
        Preconditions.checkNotNull((Object)((Object)messageKind));
        return messageKind.getCode();
    }

    @NonNull
    private Integer getCode() {
        return this.code;
    }
}

