/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class Network {
    private static boolean isIPv6(@NonNull String ma) {
        Preconditions.checkNotNull((Object)ma);
        return ma.startsWith("/ip6/");
    }

    public static boolean isNetworkAvailable(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null) {
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            return activeNetworkInfo != null && activeNetworkInfo.isConnected();
        }
        return false;
    }

    @Nullable
    public static NetworkInfo getNetworkInfo(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm != null) {
            return cm.getActiveNetworkInfo();
        }
        return null;
    }

    public static boolean isConnected(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        android.net.Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasCapability(12);
    }

    public static boolean isConnectedWifi(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        android.net.Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasTransport(1);
    }

    public static boolean isConnectedMobile(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        android.net.Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasTransport(0);
    }

    public static boolean isConnectedFast(Context context) {
        Preconditions.checkNotNull((Object)context);
        NetworkInfo info = Network.getNetworkInfo(context);
        if (info != null && info.isConnected()) {
            if (Network.isConnectedWifi(context)) {
                return true;
            }
            if (Network.isConnectedMobile(context)) {
                return Network.isConnectionFast(info.getSubtype());
            }
        }
        return false;
    }

    public static boolean isConnectionFast(int subType) {
        switch (subType) {
            case 7: {
                return false;
            }
            case 4: {
                return false;
            }
            case 2: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 1: {
                return false;
            }
            case 8: {
                return true;
            }
            case 10: {
                return true;
            }
            case 9: {
                return true;
            }
            case 3: {
                return true;
            }
            case 14: {
                return true;
            }
            case 12: {
                return true;
            }
            case 15: {
                return true;
            }
            case 11: {
                return false;
            }
            case 13: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static Pair<InetAddress, Boolean> getInetAddress(boolean useIPv4) throws Exception {
        Pair result = null;
        ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        for (NetworkInterface intf : interfaces) {
            if (!intf.isUp()) continue;
            ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
            for (InetAddress addr : addrs) {
                if (addr.isLoopbackAddress()) continue;
                if (useIPv4) {
                    if (!(addr instanceof Inet4Address)) continue;
                    if (Network.isValidPublicIP(addr)) {
                        return Pair.create((Object)addr, (Object)true);
                    }
                    return Pair.create((Object)addr, (Object)false);
                }
                if (!(addr instanceof Inet6Address)) continue;
                if (Network.isValidPublicIP(addr)) {
                    if (Network.isIPv6GlobalAddress((Inet6Address)addr)) {
                        return Pair.create((Object)addr, (Object)true);
                    }
                    result = Pair.create((Object)addr, (Object)false);
                    continue;
                }
                if (result != null) continue;
                result = Pair.create((Object)addr, (Object)false);
            }
        }
        return result;
    }

    public static boolean hasGlobalIPv6Address() throws Exception {
        Pair<InetAddress, Boolean> result = Network.getInetAddress(false);
        if (result == null) {
            return false;
        }
        return (Boolean)result.second;
    }

    private static boolean isIPv6GlobalAddress(@NonNull Inet6Address address) {
        Preconditions.checkNotNull((Object)address);
        if (address.isLinkLocalAddress()) {
            return false;
        }
        String host = address.getHostAddress();
        return (host.startsWith("2") || host.startsWith("3")) && host.indexOf(":") == 4;
    }

    private static boolean isValidPublicIP(@NonNull InetAddress address) {
        Preconditions.checkNotNull((Object)address);
        return !address.isSiteLocalAddress() && !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress();
    }
}

