/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import threads.core.api.TransactionHash;
import threads.core.api.TransactionHashDao;

public final class TransactionHashDao_Impl
implements TransactionHashDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfTransactionHash;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfRemoveHash;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAllTransitionHashWithSmallerMilestoneIndex;

    public TransactionHashDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTransactionHash = new EntityInsertionAdapter<TransactionHash>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `TransactionHash`(`hash`,`milestone`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, TransactionHash value) {
                if (value.getHash() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getHash());
                }
                stmt.bindLong(2, value.getMilestone());
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM TransactionHash";
                return "DELETE FROM TransactionHash";
            }
        };
        this.__preparedStmtOfRemoveHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM TransactionHash WHERE hash = ?";
                return "DELETE FROM TransactionHash WHERE hash = ?";
            }
        };
        this.__preparedStmtOfRemoveAllTransitionHashWithSmallerMilestoneIndex = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM TransactionHash WHERE milestone <= ?";
                return "DELETE FROM TransactionHash WHERE milestone <= ?";
            }
        };
    }

    @Override
    public void insertTransitionHash(TransactionHash ... hashes) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfTransactionHash.insert((Object[])hashes);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHash(String hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveHash.acquire();
        int _argIndex = 1;
        if (hash == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, hash);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemoveHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllTransitionHashWithSmallerMilestoneIndex(long milestone) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveAllTransitionHashWithSmallerMilestoneIndex.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, milestone);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemoveAllTransitionHashWithSmallerMilestoneIndex.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTransitionHashes() {
        String _sql = "SELECT hash FROM TransactionHash";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT hash FROM TransactionHash", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long hasHash(String hash) {
        String _sql = "SELECT COUNT(*) FROM TransactionHash WHERE hash =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*) FROM TransactionHash WHERE hash =?", (int)1);
        int _argIndex = 1;
        if (hash == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, hash);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            long _result = _cursor.moveToFirst() ? _cursor.getLong(0) : 0L;
            long l = _result;
            return l;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

