/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import java.util.Objects;
import threads.core.api.Converter;
import threads.core.api.Entity;
import threads.core.api.UserStatus;
import threads.core.api.UserType;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

@androidx.room.Entity
public class User
extends Entity {
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="pid")
    private final String pid;
    @NonNull
    @ColumnInfo(name="publicKey")
    private String publicKey;
    @NonNull
    @ColumnInfo(name="alias")
    private String alias;
    @NonNull
    @TypeConverters(value={UserType.class})
    @ColumnInfo(name="type")
    private UserType type;
    @NonNull
    @TypeConverters(value={UserStatus.class})
    @ColumnInfo(name="status")
    private UserStatus status;
    @Nullable
    @ColumnInfo(name="image")
    @TypeConverters(value={Converter.class})
    private CID image;

    User(@NonNull UserType type, @NonNull UserStatus status, @NonNull String alias, @NonNull String publicKey, @NonNull String pid, @Nullable CID image) {
        this.type = type;
        this.status = status;
        this.alias = alias;
        this.publicKey = publicKey;
        this.pid = pid;
        this.image = image;
    }

    @NonNull
    public static User createUser(@NonNull UserType type, @NonNull UserStatus status, @NonNull String alias, @NonNull String publicKey, @NonNull PID pid, @Nullable CID image) {
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull((Object)((Object)status));
        Preconditions.checkNotNull((Object)alias);
        Preconditions.checkNotNull((Object)publicKey);
        Preconditions.checkNotNull((Object)pid);
        return new User(type, status, alias, publicKey, pid.getPid(), image);
    }

    @NonNull
    public UserType getType() {
        return this.type;
    }

    public void setType(@NonNull UserType type) {
        Preconditions.checkNotNull((Object)((Object)type));
        this.type = type;
    }

    @NonNull
    String getPid() {
        return this.pid;
    }

    @NonNull
    public UserStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NonNull UserStatus status) {
        this.status = status;
    }

    @NonNull
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(@NonNull String alias) {
        this.alias = alias;
    }

    @NonNull
    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(@NonNull String publicKey) {
        this.publicKey = publicKey;
    }

    @Nullable
    public CID getImage() {
        return this.image;
    }

    public void setImage(@Nullable CID image) {
        this.image = image;
    }

    @NonNull
    public String getSesKey() {
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.pid, user.pid);
    }

    public int hashCode() {
        return Objects.hash(this.pid);
    }

    public boolean areItemsTheSame(@NonNull User user) {
        Preconditions.checkNotNull((Object)user);
        return this.pid.equals(user.pid);
    }

    public boolean sameContent(@NonNull User o) {
        Preconditions.checkNotNull((Object)o);
        if (this == o) {
            return true;
        }
        return Objects.equals((Object)this.status, (Object)o.getStatus()) && Objects.equals(this.alias, o.getAlias());
    }

    public PID getPID() {
        return PID.create((String)this.pid);
    }
}

