/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.TypeConverter;

public enum ThreadStatus {
    OFFLINE(0),
    ONLINE(1),
    REQUEST(2),
    EXPIRED(3),
    DELETING(4),
    ERROR(5),
    LEACHING(6),
    PUBLISHING(7);

    @NonNull
    private final Integer code;

    private ThreadStatus(Integer code) {
        Preconditions.checkNotNull((Object)code);
        this.code = code;
    }

    @TypeConverter
    public static ThreadStatus toThreadStatus(Integer status) {
        Preconditions.checkNotNull((Object)status);
        if (status.equals(OFFLINE.getCode())) {
            return OFFLINE;
        }
        if (status.equals(ONLINE.getCode())) {
            return ONLINE;
        }
        if (status.equals(REQUEST.getCode())) {
            return REQUEST;
        }
        if (status.equals(EXPIRED.getCode())) {
            return EXPIRED;
        }
        if (status.equals(DELETING.getCode())) {
            return DELETING;
        }
        if (status.equals(ERROR.getCode())) {
            return ERROR;
        }
        if (status.equals(LEACHING.getCode())) {
            return LEACHING;
        }
        if (status.equals(PUBLISHING.getCode())) {
            return PUBLISHING;
        }
        throw new IllegalArgumentException("Could not recognize status");
    }

    @TypeConverter
    public static Integer toInteger(ThreadStatus status) {
        Preconditions.checkNotNull((Object)((Object)status));
        return status.getCode();
    }

    @NonNull
    private Integer getCode() {
        return this.code;
    }
}

