/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.pdf.PdfRenderer;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.format.DateFormat;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.amulyakhare.textdrawable.TextDrawable;
import com.amulyakhare.textdrawable.util.ColorGenerator;
import com.j256.simplemagic.ContentInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import org.iota.jota.utils.TrytesConverter;
import threads.core.Singleton;
import threads.core.api.AddressType;
import threads.core.api.Converter;
import threads.core.api.EventsDatabase;
import threads.core.api.LinkType;
import threads.core.api.Note;
import threads.core.api.NoteType;
import threads.core.api.Thread;
import threads.core.api.ThreadsAPI;
import threads.core.api.ThreadsDatabase;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

public class THREADS
extends ThreadsAPI {
    public static final String TAG = THREADS.class.getSimpleName();
    public static final long SNAPSHOT = 1L;
    private static final int THUMBNAIL_SIZE = 128;

    private THREADS(Builder builder) {
        super(builder.threadsDatabase, builder.eventsDatabase);
    }

    @NonNull
    public static Bitmap getUserImage(@NonNull String name) {
        Preconditions.checkNotNull((Object)name);
        Canvas canvas = new Canvas();
        String letter = name.substring(0, 1);
        int color = ColorGenerator.MATERIAL.getColor((Object)name);
        TextDrawable drawable = TextDrawable.builder().buildRound(letter, color);
        Bitmap bitmap = Bitmap.createBitmap((int)64, (int)64, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        canvas.setBitmap(bitmap);
        drawable.setBounds(0, 0, 64, 64);
        drawable.draw(canvas);
        return bitmap;
    }

    public static Optional<String> getExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }

    @NonNull
    public static String getAddress(@NonNull CID cid) {
        Preconditions.checkNotNull((Object)cid);
        String address = TrytesConverter.asciiToTrytes((String)cid.getCid());
        return IOTA.addChecksum((String)address.substring(0, 81));
    }

    @NonNull
    public static String getAddress(@NonNull PID pid, @NonNull AddressType addressType) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)((Object)addressType));
        String address = TrytesConverter.asciiToTrytes((String)pid.getPid());
        Preconditions.checkNotNull((Object)address);
        switch (addressType) {
            case PEER: {
                return IOTA.addChecksum((String)address.substring(0, 81));
            }
            case INBOX: {
                return IOTA.addChecksum((String)address.substring(address.length() - 81));
            }
        }
        throw new RuntimeException("Not supported address type");
    }

    @NonNull
    public static THREADS createThreads(@NonNull ThreadsDatabase threadsDatabase, @NonNull EventsDatabase eventsDatabase) {
        Preconditions.checkNotNull((Object)((Object)threadsDatabase));
        Preconditions.checkNotNull((Object)((Object)eventsDatabase));
        return new Builder().threadsDatabase(threadsDatabase).eventsDatabase(eventsDatabase).build();
    }

    @Nullable
    public static LinkType getLinkType(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        if (note.getNoteType() == NoteType.LINK) {
            String linkType = note.getAdditional(LinkType.class.getSimpleName());
            return LinkType.valueOf(linkType);
        }
        return null;
    }

    public static double getLatitude(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        if (note.getNoteType() == NoteType.LOCATION) {
            return Double.valueOf(note.getAdditional("LATITUDE"));
        }
        return Double.NaN;
    }

    public static double getLongitude(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        if (note.getNoteType() == NoteType.LOCATION) {
            return Double.valueOf(note.getAdditional("LONGITUDE"));
        }
        return Double.NaN;
    }

    public static double getZoom(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        if (note.getNoteType() == NoteType.LOCATION) {
            return Double.valueOf(note.getAdditional("ZOOM"));
        }
        return Double.NaN;
    }

    @NonNull
    public static Date getTomorrow() {
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    @NonNull
    public static Date getYesterday() {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    @NonNull
    public static byte[] getImage(@NonNull Drawable drawable) {
        Canvas canvas = new Canvas();
        Bitmap bitmap = Bitmap.createBitmap((int)64, (int)64, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        canvas.setBitmap(bitmap);
        drawable.setBounds(0, 0, 64, 64);
        drawable.draw(canvas);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        return stream.toByteArray();
    }

    @NonNull
    public static byte[] getImage(@NonNull Context context, @NonNull String name, @DrawableRes int id) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)name);
        Drawable drawable = context.getDrawable(id);
        Preconditions.checkNotNull((Object)drawable);
        int color = ColorGenerator.MATERIAL.getColor((Object)name);
        drawable.setColorFilter(color, PorterDuff.Mode.SRC_ATOP);
        return THREADS.getImage(drawable);
    }

    @NonNull
    public static byte[] getImage(@NonNull Context context, @DrawableRes int id) {
        Preconditions.checkNotNull((Object)context);
        Drawable drawable = context.getDrawable(id);
        Preconditions.checkNotNull((Object)drawable);
        return THREADS.getImage(drawable);
    }

    @NonNull
    public static Bitmap getThumbnail(@NonNull Context context, @NonNull Uri uri) throws IOException {
        int k;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)uri);
        InputStream input = context.getContentResolver().openInputStream(uri);
        BitmapFactory.Options onlyBoundsOptions = new BitmapFactory.Options();
        onlyBoundsOptions.inJustDecodeBounds = true;
        onlyBoundsOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
        BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)onlyBoundsOptions);
        input.close();
        if (onlyBoundsOptions.outWidth == -1 || onlyBoundsOptions.outHeight == -1) {
            return null;
        }
        int originalSize = onlyBoundsOptions.outHeight > onlyBoundsOptions.outWidth ? onlyBoundsOptions.outHeight : onlyBoundsOptions.outWidth;
        double ratio = originalSize > 128 ? (double)(originalSize / 128) : 1.0;
        int sampleSize = k = Integer.highestOneBit((int)Math.floor(ratio));
        if (k == 0) {
            sampleSize = 1;
        }
        BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
        bitmapOptions.inSampleSize = sampleSize;
        bitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
        input = context.getContentResolver().openInputStream(uri);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)bitmapOptions);
        input.close();
        return bitmap;
    }

    @Nullable
    public static byte[] getPreviewImage(@NonNull Context context, @NonNull File file, @Nullable IPFS ipfs) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)file);
        Bitmap bitmap = THREADS.getPreview(context, file, ipfs);
        if (bitmap != null) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.WEBP, 100, (OutputStream)stream);
            byte[] image = stream.toByteArray();
            bitmap.recycle();
            return image;
        }
        return null;
    }

    @Nullable
    public static byte[] getPreviewImage(@NonNull Context context, @NonNull File file, @NonNull String filename) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)filename);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            ContentInfo contentInfo;
            String mimeType;
            Optional<String> result;
            Bitmap bitmap = null;
            if (!filename.isEmpty() && (result = THREADS.getExtension(filename)).isPresent() && (mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(result.get())) != null) {
                bitmap = THREADS.getPreview(context, file, mimeType);
            }
            if (bitmap == null && (contentInfo = ipfs.getContentInfo(file)) != null && (mimeType = contentInfo.getMimeType()) != null) {
                bitmap = THREADS.getPreview(context, file, mimeType);
            }
            if (bitmap != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.WEBP, 100, (OutputStream)stream);
                byte[] image = stream.toByteArray();
                bitmap.recycle();
                return image;
            }
        }
        return null;
    }

    @Nullable
    public static byte[] getPreviewImage(@NonNull Context context, @NonNull Uri uri) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)uri);
        Bitmap bitmap = THREADS.getPreview(context, uri);
        if (bitmap != null) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.WEBP, 100, (OutputStream)stream);
            byte[] image = stream.toByteArray();
            bitmap.recycle();
            return image;
        }
        return null;
    }

    @Nullable
    public static Bitmap getPreview(@NonNull Context context, @NonNull File file, @Nullable IPFS ipfs) throws Exception {
        String mimeType;
        ContentInfo contentInfo;
        String mimeType2;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)file);
        Optional<String> result = THREADS.getExtension(file.getName());
        if (result.isPresent() && (mimeType2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(result.get())) != null) {
            return THREADS.getPreview(context, file, mimeType2);
        }
        if (ipfs != null && (contentInfo = ipfs.getContentInfo(file)) != null && (mimeType = contentInfo.getMimeType()) != null) {
            return THREADS.getPreview(context, file, mimeType);
        }
        return null;
    }

    @Nullable
    private static Bitmap getPreview(@NonNull Context context, @NonNull File file, @NonNull String mimeType) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)mimeType);
        if (mimeType.startsWith("video")) {
            Bitmap bitmap;
            MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
            mediaMetadataRetriever.setDataSource(context, Uri.fromFile((File)file));
            try {
                String time = mediaMetadataRetriever.extractMetadata(9);
                Long timeUs = Long.decode(time);
                long timeFrame = timeUs / 100L * 5L;
                bitmap = mediaMetadataRetriever.getFrameAtTime(timeFrame);
            }
            catch (Throwable e) {
                bitmap = mediaMetadataRetriever.getFrameAtTime();
            }
            mediaMetadataRetriever.release();
            return bitmap;
        }
        if (mimeType.startsWith("application/pdf")) {
            return THREADS.getPDFBitmap(context, Uri.fromFile((File)file));
        }
        if (mimeType.startsWith("image")) {
            return THREADS.getThumbnail(context, Uri.fromFile((File)file));
        }
        return null;
    }

    @Nullable
    public static Bitmap getPreview(@NonNull Context context, @NonNull Uri uri) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)uri);
        FileDetails fileDetails = THREADS.getFileDetails(context, uri);
        Preconditions.checkNotNull((Object)fileDetails);
        String mimeType = fileDetails.getMimeType();
        if (mimeType.startsWith("video")) {
            Bitmap bitmap;
            MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
            mediaMetadataRetriever.setDataSource(context, uri);
            try {
                String time = mediaMetadataRetriever.extractMetadata(9);
                Long timeUs = Long.decode(time);
                long timeFrame = timeUs / 100L * 5L;
                bitmap = mediaMetadataRetriever.getFrameAtTime(timeFrame);
            }
            catch (Throwable e) {
                bitmap = mediaMetadataRetriever.getFrameAtTime();
            }
            mediaMetadataRetriever.release();
            return bitmap;
        }
        if (mimeType.startsWith("application/pdf")) {
            return THREADS.getPDFBitmap(context, uri);
        }
        if (mimeType.startsWith("image")) {
            return THREADS.getThumbnail(context, uri);
        }
        return null;
    }

    @NonNull
    public static Bitmap getPDFBitmap(@NonNull Context context, @NonNull Uri uri) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)uri);
        ParcelFileDescriptor fileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
        Preconditions.checkNotNull((Object)fileDescriptor);
        PdfRenderer pdfRenderer = new PdfRenderer(fileDescriptor);
        PdfRenderer.Page rendererPage = pdfRenderer.openPage(0);
        int rendererPageWidth = rendererPage.getWidth();
        int rendererPageHeight = rendererPage.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)rendererPageWidth, (int)rendererPageHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        rendererPage.render(bitmap, null, null, 1);
        rendererPage.close();
        pdfRenderer.close();
        fileDescriptor.close();
        return bitmap;
    }

    public static byte[] getImage(@NonNull String displayName) {
        String letter = displayName.substring(0, 1);
        int color = ColorGenerator.MATERIAL.getColor((Object)displayName);
        Canvas canvas = new Canvas();
        TextDrawable drawable = TextDrawable.builder().buildRound(letter, color);
        Bitmap bitmap = Bitmap.createBitmap((int)64, (int)64, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        canvas.setBitmap(bitmap);
        drawable.setBounds(0, 0, 64, 64);
        drawable.draw(canvas);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        return stream.toByteArray();
    }

    @NonNull
    public static String getDate(@NonNull Date date) {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date today = c.getTime();
        c.set(2, 0);
        c.set(5, 0);
        Date lastYear = c.getTime();
        if (date.before(today)) {
            if (date.before(lastYear)) {
                return DateFormat.format((CharSequence)"dd.MM.yyyy", (Date)date).toString();
            }
            return DateFormat.format((CharSequence)"dd.MMMM", (Date)date).toString();
        }
        return DateFormat.format((CharSequence)"HH:mm", (Date)date).toString();
    }

    @NonNull
    public static Calendar getUserAgeOffsetCalendar(int offset) {
        Date now = new Date();
        GregorianCalendar init = new GregorianCalendar();
        init.setTime(now);
        int mYear = init.get(1);
        int mMonth = init.get(2);
        int mDay = init.get(5);
        return new GregorianCalendar(mYear - offset, mMonth, mDay);
    }

    static long getOffsetDate(int offsetInYears) {
        return THREADS.getUserAgeOffsetCalendar(offsetInYears).getTime().getTime();
    }

    @NonNull
    public static Date getOffsetYearDate(int offsetInYears) {
        return THREADS.getUserAgeOffsetCalendar(offsetInYears).getTime();
    }

    public static long getTodayDate() {
        return THREADS.getToday().getTime();
    }

    @NonNull
    public static Date getToday() {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    @Nullable
    public static CID createNameImage(@NonNull THREADS threads, @NonNull IPFS ipfs, @NonNull String name, @NonNull String key) throws Exception {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)threads);
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)key);
        byte[] data = THREADS.getImage(name);
        return threads.storeData(ipfs, data, key);
    }

    @Nullable
    public static CID createResourceImage(@NonNull Context context, @NonNull THREADS threads, @NonNull IPFS ipfs, @DrawableRes int id, @NonNull String key) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)threads);
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)key);
        byte[] data = THREADS.getImage(context, id);
        return threads.storeData(ipfs, data, key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static FileDetails getFileDetails(@NonNull Context context, @NonNull Uri uri) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)uri);
        String mimeType = context.getContentResolver().getType(uri);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        ContentResolver contentResolver = context.getContentResolver();
        try (Cursor cursor = contentResolver.query(uri, new String[]{"_display_name", "_size"}, null, null, null);){
            Preconditions.checkNotNull((Object)cursor);
            cursor.moveToFirst();
            String fileName = cursor.getString(0);
            long fileSize = cursor.getLong(1);
            FileDetails fileDetails = FileDetails.create(fileName, mimeType, fileSize);
            return fileDetails;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    public void updateThreadInfo(@NonNull Thread thread, @NonNull String mimeType, @NonNull String message, boolean increase) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)mimeType);
        Preconditions.checkNotNull((Object)message);
        this.setAdditional(thread, "THREAD_MIME_TYPE", mimeType, true);
        this.setAdditional(thread, "THREAD_CONTENT", message, true);
        this.setAdditional(thread, "THREAD_DATE", "" + Converter.toLong(new Date()), true);
        if (increase) {
            this.incrementUnreadNotesNumber(thread);
        } else {
            this.refreshNotesNumber(thread);
        }
    }

    @NonNull
    public InputStream stream(@NonNull IPFS ipfs, @NonNull CID cid, @NonNull String key) throws Exception {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)cid);
        Preconditions.checkNotNull((Object)key);
        return ipfs.stream(cid, key, -1, true);
    }

    public boolean receive(@NonNull IPFS ipfs, @NonNull CID cid, @NonNull String key, int timeout) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)cid);
        Preconditions.checkNotNull((Object)key);
        byte[] bytes = ipfs.get(cid, key, timeout, false);
        if (bytes.length > 0) {
            try {
                this.pin_add(ipfs, cid, true);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public File receive(@NonNull IPFS ipfs, @NonNull CID cid, @NonNull String key, @NonNull IPFS.Progress progress, int timeout, long size) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)cid);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)progress);
        return ipfs.get(cid, key, progress, false, timeout, size, true);
    }

    @Nullable
    public Bitmap getImage(@NonNull IPFS ipfs, @NonNull Thread thread) throws Exception {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)thread);
        CID image = thread.getImage();
        String key = thread.getSesKey();
        if (image != null) {
            return this.getImage(ipfs, image, key);
        }
        return null;
    }

    @Nullable
    public Bitmap getImage(@NonNull IPFS ipfs, @NonNull CID image, @NonNull String key) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)image);
        Preconditions.checkNotNull((Object)key);
        byte[] bytes = ipfs.get(image, key, -1, true);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public boolean download(@NonNull IPFS ipfs, @NonNull File file, @NonNull CID cid, @NonNull String key, @NonNull IPFS.Progress progress, boolean pin, boolean offline, int timeout, long size) {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)cid);
        Preconditions.checkNotNull((Object)progress);
        Preconditions.checkNotNull((Object)key);
        ipfs.store(file, cid, key, progress, offline, timeout, size, pin);
        return file.exists();
    }

    @Nullable
    public CID store(@NonNull Context context, @NonNull IPFS ipfs, @NonNull Uri uri, @NonNull String key) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)uri);
        Preconditions.checkNotNull((Object)key);
        InputStream inputStream = context.getContentResolver().openInputStream(uri);
        Preconditions.checkNotNull((Object)inputStream);
        return this.storeStream(ipfs, key, inputStream);
    }

    public static class Builder {
        EventsDatabase eventsDatabase = null;
        ThreadsDatabase threadsDatabase = null;

        public THREADS build() {
            Preconditions.checkNotNull((Object)((Object)this.threadsDatabase));
            Preconditions.checkNotNull((Object)((Object)this.eventsDatabase));
            return new THREADS(this);
        }

        public Builder threadsDatabase(@NonNull ThreadsDatabase threadsDatabase) {
            Preconditions.checkNotNull((Object)((Object)threadsDatabase));
            this.threadsDatabase = threadsDatabase;
            return this;
        }

        public Builder eventsDatabase(@NonNull EventsDatabase eventsDatabase) {
            Preconditions.checkNotNull((Object)((Object)eventsDatabase));
            this.eventsDatabase = eventsDatabase;
            return this;
        }
    }

    public static class FileDetails {
        @NonNull
        private final String fileName;
        @NonNull
        private final String mimeType;
        private final long fileSize;

        private FileDetails(@NonNull String fileName, @NonNull String mimeType, long fileSize) {
            Preconditions.checkNotNull((Object)fileName);
            Preconditions.checkNotNull((Object)mimeType);
            Preconditions.checkArgument((fileSize > 0L ? 1 : 0) != 0);
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.fileSize = fileSize;
        }

        public static FileDetails create(@NonNull String fileName, @NonNull String mimeType, long fileSize) {
            return new FileDetails(fileName, mimeType, fileSize);
        }

        @NonNull
        public String getFileName() {
            return this.fileName;
        }

        @NonNull
        public String getMimeType() {
            return this.mimeType;
        }

        public long getFileSize() {
            return this.fileSize;
        }
    }
}

