package threads.core.api;

import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.gson.Gson;

import java.util.Date;

import threads.iota.Entity;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

import static androidx.core.util.Preconditions.checkNotNull;

class NotePublishDecoder {

    private static final String TAG = NotePublishDecoder.class.getSimpleName();

    @Nullable
    static Thread convert(@NonNull Entity entity, @NonNull String aesKey) {
        checkNotNull(entity);
        checkNotNull(aesKey);
        try {

            Long timestamp = entity.getTimestamp();
            checkNotNull(timestamp);

            String encContent = Encryption.decrypt(entity.getContent(), aesKey);
            Gson gson = new Gson();
            Content content = gson.fromJson(encContent, Content.class);

            String senderPid = content.get(Content.PID);
            checkNotNull(senderPid);


            String additions = content.get(Content.ADDS);
            checkNotNull(additions);

            String readOnlyString = content.get(Content.READ_ONLY);
            checkNotNull(readOnlyString);
            boolean isReadOnly = Boolean.valueOf(readOnlyString);

            String sesKey = content.get(Content.SKEY);
            checkNotNull(sesKey);

            String senderAlias = content.get(Content.ALIAS);
            checkNotNull(senderAlias);

            String senderKey = content.get(Content.PKEY);
            checkNotNull(senderKey);

            String cidValue = content.get(Content.CID);
            CID cid = null;
            if (cidValue != null) {
                cid = CID.create(cidValue);
            }

            String date = content.get(Content.DATE);
            checkNotNull(date);

            Thread thread = Thread.createThread(
                    ThreadStatus.ONLINE,
                    PID.create(senderPid),
                    senderAlias,
                    senderKey,
                    sesKey,
                    Kind.IN,
                    new Date(Long.valueOf(date)),
                    0,
                    isReadOnly);

            thread.setCid(cid);

            if (!additions.isEmpty()) {
                thread.setExternalAdditions(Additionals.toHashMap(additions));
            }


            String imgValue = content.get(Content.IMG);
            if (imgValue != null) {
                thread.setImage(CID.create(imgValue));
            }

            String expireDate = content.get(Content.EXPIRE_DATE);
            checkNotNull(expireDate);
            thread.setExpireDate(new Date(Long.valueOf(expireDate)));
            thread.setMarkedFlag(false);

            thread.setHash(entity.getHash());
            thread.setBundle(entity.getBundle());
            thread.setTimestamp(entity.getTimestamp());
            return thread;

        } catch (Throwable e) {
            Log.e(TAG, "" + e.getLocalizedMessage(), e);
        }
        return null;
    }

}
