/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import threads.core.api.Additionals;
import threads.core.api.Addresses;
import threads.core.api.Content;
import threads.core.api.Peer;
import threads.iota.Entity;
import threads.ipfs.api.PID;

public class PeerDecoder {
    private static final String TAG = PeerDecoder.class.getSimpleName();

    @Nullable
    static Peer convert(@NonNull PID owner, @NonNull Entity entity) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)entity);
        Gson gson = new Gson();
        Content content = (Content)gson.fromJson(entity.getContent(), Content.class);
        Peer peer = PeerDecoder.convert(owner, content);
        if (peer != null) {
            peer.setHash((String)entity.getHashes().get(0));
            peer.setBundle(entity.getBundle());
            peer.setTimestamp(entity.getTimestamp());
        }
        return peer;
    }

    @Nullable
    static Peer convert(@NonNull PID owner, @NonNull Content content) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)content);
        try {
            Peer peer = Peer.createPeer(owner);
            String peers = (String)content.get("peers");
            if (peers != null) {
                Addresses addresses = Addresses.toAddresses(peers);
                Preconditions.checkNotNull((Object)addresses);
                peer.setAddresses(addresses);
            }
            String additions = (String)content.get("adds");
            Preconditions.checkNotNull((Object)additions);
            if (!additions.isEmpty()) {
                peer.setExternalAdditions(Additionals.toHashMap(additions));
            }
            return peer;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

