/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import threads.core.api.Additionals;
import threads.core.api.Addresses;
import threads.core.api.Peer;
import threads.core.api.PeerDao;

public final class PeerDao_Impl
implements PeerDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfPeer;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfPeer;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfPeer;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfSetBundle;
    private final SharedSQLiteStatement __preparedStmtOfSetHash;

    public PeerDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPeer = new EntityInsertionAdapter<Peer>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Peer`(`pid`,`addresses`,`additionals`,`hash`,`bundle`,`timestamp`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Peer value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                String _tmp = Addresses.toString(value.getAddresses());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = Additionals.toString(value.getAdditionals());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getBundle());
                }
                stmt.bindLong(6, value.getTimestamp());
            }
        };
        this.__deletionAdapterOfPeer = new EntityDeletionOrUpdateAdapter<Peer>(__db){

            public String createQuery() {
                return "DELETE FROM `Peer` WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Peer value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
            }
        };
        this.__updateAdapterOfPeer = new EntityDeletionOrUpdateAdapter<Peer>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `Peer` SET `pid` = ?,`addresses` = ?,`additionals` = ?,`hash` = ?,`bundle` = ?,`timestamp` = ? WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Peer value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                String _tmp = Addresses.toString(value.getAddresses());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = Additionals.toString(value.getAdditionals());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getBundle());
                }
                stmt.bindLong(6, value.getTimestamp());
                if (value.getPid() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getPid());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Peer";
                return "DELETE FROM Peer";
            }
        };
        this.__preparedStmtOfSetBundle = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Peer SET bundle = ? WHERE pid = ?";
                return "UPDATE Peer SET bundle = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Peer SET hash = ? WHERE pid = ?";
                return "UPDATE Peer SET hash = ? WHERE pid = ?";
            }
        };
    }

    @Override
    public void insertPeer(Peer peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPeer.insert((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deletePeer(Peer peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPeer.handle((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updatePeer(Peer peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPeer.handle((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundle(String pid, String bundle) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetBundle.acquire();
        int _argIndex = 1;
        if (bundle == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, bundle);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetBundle.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHash(String pid, String hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetHash.acquire();
        int _argIndex = 1;
        if (hash == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, hash);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Peer getPeerByPid(String pid) {
        String _sql = "SELECT * FROM Peer WHERE pid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Peer _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfAddresses = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addresses");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                _result = new Peer(_tmpPid);
                String _tmp = _cursor.getString(_cursorIndexOfAddresses);
                Addresses _tmpAddresses = Addresses.toAddresses(_tmp);
                _result.setAddresses(_tmpAddresses);
                String _tmp_1 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_1);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Peer peer = _result;
            return peer;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Peer getPeerByHash(String hash) {
        String _sql = "SELECT * FROM Peer WHERE hash =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer WHERE hash =?", (int)1);
        int _argIndex = 1;
        if (hash == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, hash);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Peer _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfAddresses = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addresses");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                _result = new Peer(_tmpPid);
                String _tmp = _cursor.getString(_cursorIndexOfAddresses);
                Addresses _tmpAddresses = Addresses.toAddresses(_tmp);
                _result.setAddresses(_tmpAddresses);
                String _tmp_1 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_1);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Peer peer = _result;
            return peer;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

