/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.TypeConverters;
import androidx.room.Update;
import java.util.Date;
import java.util.List;
import threads.core.api.Converter;
import threads.core.api.Kind;
import threads.core.api.Note;
import threads.core.api.NoteStatus;
import threads.core.api.NoteType;
import threads.ipfs.api.CID;

@Dao
public interface NoteDao {
    @Insert(onConflict=1)
    public long insertNote(Note var1);

    @Insert(onConflict=1)
    public void insertNotes(Note ... var1);

    @Query(value="SELECT * FROM Note WHERE kind LIKE :kind AND status LIKE :status")
    @TypeConverters(value={Kind.class, NoteStatus.class})
    public List<Note> getNotesByKindAndStatus(Kind var1, NoteStatus var2);

    @Query(value="SELECT hash FROM Note WHERE idx = :idx ")
    public String getHash(long var1);

    @Query(value="UPDATE Note SET status = :status WHERE idx = :idx")
    @TypeConverters(value={NoteStatus.class})
    public void setNoteStatus(long var1, NoteStatus var3);

    @Query(value="UPDATE Note SET status = :newStatus WHERE status = :oldStatus")
    @TypeConverters(value={NoteStatus.class})
    public void setNoteStatus(NoteStatus var1, NoteStatus var2);

    @Query(value="UPDATE Note SET cid = :cid WHERE idx = :idx")
    @TypeConverters(value={Converter.class})
    public void setCid(long var1, CID var3);

    @Query(value="UPDATE Note SET hash = :hash WHERE idx = :idx")
    public void setHash(long var1, String var3);

    @Query(value="UPDATE Note SET bundle = :bundle WHERE idx = :idx")
    public void setBundle(long var1, String var3);

    @Query(value="SELECT * FROM Note")
    public List<Note> getNotes();

    @Query(value="UPDATE Note SET mimeType =:mimeType  WHERE idx = :idx")
    public void setMimeType(long var1, String var3);

    @Query(value="SELECT * FROM Note WHERE cid = :cid")
    @TypeConverters(value={Converter.class})
    public List<Note> getNotesByCid(CID var1);

    @Query(value="SELECT * FROM Note WHERE idx =:idx")
    public Note getNoteByIdx(long var1);

    @Query(value="SELECT * FROM Note WHERE thread =:thread")
    @TypeConverters(value={Converter.class})
    public List<Note> getNotesByThread(CID var1);

    @Query(value="SELECT * FROM Note WHERE date =:date")
    @TypeConverters(value={Converter.class})
    public List<Note> getNotesByDate(Date var1);

    @Query(value="SELECT * FROM Note WHERE thread =:thread")
    @TypeConverters(value={Converter.class})
    public LiveData<List<Note>> getLiveDataNotesByThread(CID var1);

    @Query(value="SELECT * FROM Note")
    public LiveData<List<Note>> getLiveDataNotes();

    @Update(onConflict=1)
    public void updateNote(Note var1);

    @Delete
    public void removeNote(Note var1);

    @Query(value="SELECT mimeType FROM Note WHERE idx = :idx")
    public String getMimeType(long var1);

    @Query(value="DELETE FROM Note")
    public void clear();

    @Query(value="SELECT * FROM Note WHERE noteType =:type")
    @TypeConverters(value={NoteType.class})
    public List<Note> getNotesByType(NoteType var1);

    @Query(value="UPDATE Note SET image = :image WHERE idx = :idx")
    @TypeConverters(value={Converter.class})
    public void setImage(long var1, CID var3);

    @Query(value="SELECT status FROM Note WHERE idx = :idx")
    @TypeConverters(value={NoteStatus.class})
    public NoteStatus getNoteStatus(long var1);

    @Query(value="SELECT noteType FROM Note WHERE idx = :idx")
    @TypeConverters(value={NoteType.class})
    public NoteType getNoteType(long var1);
}

