/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import java.util.Date;
import java.util.Objects;
import threads.core.THREADS;
import threads.core.api.AddressType;
import threads.core.api.Converter;
import threads.core.api.Entity;
import threads.core.api.Kind;
import threads.core.api.NoteStatus;
import threads.core.api.NoteType;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

@androidx.room.Entity
public class Note
extends Entity {
    @NonNull
    @ColumnInfo(name="senderAlias")
    private final String senderAlias;
    @NonNull
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="senderPid")
    private final PID senderPid;
    @NonNull
    @ColumnInfo(name="senderKey")
    private final String senderKey;
    @NonNull
    @ColumnInfo(name="sesKey")
    private final String sesKey;
    @NonNull
    @TypeConverters(value={Kind.class})
    @ColumnInfo(name="kind")
    private final Kind kind;
    @Nullable
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="thread")
    private final CID thread;
    @NonNull
    @TypeConverters(value={NoteType.class})
    @ColumnInfo(name="noteType")
    private final NoteType noteType;
    @NonNull
    @ColumnInfo(name="mimeType")
    private final String mimeType;
    @NonNull
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="date")
    private final Date date;
    @PrimaryKey(autoGenerate=true)
    private long idx;
    @Nullable
    @ColumnInfo(name="cid")
    @TypeConverters(value={Converter.class})
    private CID cid;
    @NonNull
    @TypeConverters(value={NoteStatus.class})
    @ColumnInfo(name="status")
    private NoteStatus status;
    @Nullable
    @ColumnInfo(name="image")
    @TypeConverters(value={Converter.class})
    private CID image;

    Note(@Nullable CID thread, @NonNull PID senderPid, @NonNull String senderAlias, @NonNull String senderKey, @NonNull String sesKey, @NonNull String mimeType, @NonNull NoteStatus status, @NonNull Kind kind, @NonNull NoteType noteType, @NonNull Date date) {
        this.thread = thread;
        this.senderPid = senderPid;
        this.senderAlias = senderAlias;
        this.senderKey = senderKey;
        this.sesKey = sesKey;
        this.mimeType = mimeType;
        this.status = status;
        this.kind = kind;
        this.noteType = noteType;
        this.date = date;
    }

    public static Note createNote(@Nullable CID thread, @NonNull PID senderPid, @NonNull String senderAlias, @NonNull String senderKey, @NonNull String sesKey, @NonNull NoteStatus status, @NonNull Kind kind, @NonNull NoteType noteType, @NonNull String mimeType, @NonNull Date date) {
        Preconditions.checkNotNull((Object)senderPid);
        Preconditions.checkNotNull((Object)senderAlias);
        Preconditions.checkNotNull((Object)senderKey);
        Preconditions.checkNotNull((Object)sesKey);
        Preconditions.checkNotNull((Object)((Object)status));
        Preconditions.checkNotNull((Object)((Object)kind));
        Preconditions.checkNotNull((Object)((Object)noteType));
        Preconditions.checkNotNull((Object)mimeType);
        Preconditions.checkNotNull((Object)date);
        return new Note(thread, senderPid, senderAlias, senderKey, sesKey, mimeType, status, kind, noteType, date);
    }

    @Nullable
    public CID getImage() {
        return this.image;
    }

    public void setImage(@Nullable CID image) {
        this.image = image;
    }

    @NonNull
    public String getSenderBox() {
        return THREADS.getAddress(this.getSenderPid(), AddressType.INBOX);
    }

    @NonNull
    public String getSenderKey() {
        return this.senderKey;
    }

    @NonNull
    public String getSesKey() {
        return this.sesKey;
    }

    @NonNull
    public PID getSenderPid() {
        return this.senderPid;
    }

    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    public long getIdx() {
        return this.idx;
    }

    void setIdx(long idx) {
        this.idx = idx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note that = (Note)o;
        return Objects.equals(this.idx, that.idx);
    }

    public int hashCode() {
        return Objects.hash(this.idx);
    }

    @NonNull
    public String getSenderAlias() {
        return this.senderAlias;
    }

    @NonNull
    public Kind getKind() {
        return this.kind;
    }

    @NonNull
    public NoteType getNoteType() {
        return this.noteType;
    }

    @NonNull
    public Date getDate() {
        return this.date;
    }

    public boolean areItemsTheSame(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        return this.idx == note.getIdx();
    }

    @Nullable
    public CID getThread() {
        return this.thread;
    }

    @NonNull
    public NoteStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NonNull NoteStatus status) {
        this.status = status;
    }

    public boolean sameContent(@NonNull Note o) {
        Preconditions.checkNotNull((Object)o);
        if (this == o) {
            return true;
        }
        return this.noteType == o.getNoteType() && this.status == o.getStatus() && Objects.equals(this.cid, o.getCid()) && Objects.equals(this.image, o.getImage()) && Objects.equals(this.date, o.getDate());
    }

    public boolean sameNote(@NonNull Note o) {
        Preconditions.checkNotNull((Object)o);
        if (this == o) {
            return true;
        }
        return this.noteType == o.getNoteType() && Objects.equals(this.cid, o.getCid()) && Objects.equals(this.thread, o.getThread()) && Objects.equals(this.senderPid, o.getSenderPid()) && Objects.equals(this.image, o.getImage()) && Objects.equals(this.date, o.getDate());
    }

    @NonNull
    public String toString() {
        return "Note{senderAlias='" + this.senderAlias + '\'' + ", senderPid='" + this.senderPid + '\'' + ", senderKey='" + this.senderKey + '\'' + ", sesKey='" + this.sesKey + '\'' + ", kind=" + (Object)((Object)this.kind) + ", thread='" + this.thread + '\'' + ", noteType=" + (Object)((Object)this.noteType) + ", mimeType='" + this.mimeType + '\'' + ", date=" + this.date + ", idx=" + this.idx + ", cid='" + this.cid + '\'' + ", status=" + (Object)((Object)this.status) + '}';
    }

    public boolean isEncrypted() {
        return !this.sesKey.isEmpty();
    }

    @Nullable
    public CID getCid() {
        return this.cid;
    }

    public void setCid(@Nullable CID cid) {
        this.cid = cid;
    }
}

