package threads.core.api;

import androidx.annotation.NonNull;

import java.util.HashMap;

import static androidx.core.util.Preconditions.checkNotNull;

public class PeerEncoder {
    @NonNull
    public static Content convert(@NonNull Peer peer) {
        checkNotNull(peer);

        Content content = new Content();

        String addresses = Addresses.toString(peer.getAddresses());

        // NOT ENCRYPTED
        if (addresses != null) {
            content.put(Content.PEERS, addresses);
        }

        // NOT ENCRYPTED
        HashMap<String, String> additions = peer.getExternalAdditions();
        checkNotNull(additions);
        content.put(Content.ADDS, Additionals.toString(additions));


        return content;

    }
}
