package threads.core.api;


import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

@Dao
public interface BlockAccountDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertBlockAccounts(BlockAccount... pids);

    @Query("SELECT * FROM BlockAccount  WHERE pid =:pid")
    BlockAccount getBlockAccountByPid(String pid);

    @Query("DELETE FROM BlockAccount WHERE pid = :pid")
    void removeBlockAccountByPid(String pid);

    @Query("DELETE FROM BlockAccount")
    void clear();
}
