goog.provide('shadow.api');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('shadow.dom');
goog.require('clojure.string');
goog.require('shadow.util');
shadow.api.ready_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
shadow.api.load_order_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
shadow.api.script__GT_dom_el = (function shadow$api$script__GT_dom_el(script){
var temp__5457__auto__ = shadow.dom.data(script,new cljs.core.Keyword(null,"ref","ref",1289896967));
if(cljs.core.truth_(temp__5457__auto__)){
var dom_ref = temp__5457__auto__;
var pred__140030 = cljs.core._EQ_;
var expr__140031 = dom_ref;
if(cljs.core.truth_((pred__140030.cljs$core$IFn$_invoke$arity$2 ? pred__140030.cljs$core$IFn$_invoke$arity$2("none",expr__140031) : pred__140030.call(null,"none",expr__140031)))){
return null;
} else {
if(cljs.core.truth_((pred__140030.cljs$core$IFn$_invoke$arity$2 ? pred__140030.cljs$core$IFn$_invoke$arity$2("self",expr__140031) : pred__140030.call(null,"self",expr__140031)))){
return script;
} else {
if(cljs.core.truth_((pred__140030.cljs$core$IFn$_invoke$arity$2 ? pred__140030.cljs$core$IFn$_invoke$arity$2("parent",expr__140031) : pred__140030.call(null,"parent",expr__140031)))){
return shadow.dom.get_parent(script);
} else {
if(cljs.core.truth_((pred__140030.cljs$core$IFn$_invoke$arity$2 ? pred__140030.cljs$core$IFn$_invoke$arity$2("previous-sibling",expr__140031) : pred__140030.call(null,"previous-sibling",expr__140031)))){
return shadow.dom.get_previous_sibling(script);
} else {
if(cljs.core.truth_((pred__140030.cljs$core$IFn$_invoke$arity$2 ? pred__140030.cljs$core$IFn$_invoke$arity$2("next-sibling",expr__140031) : pred__140030.call(null,"next-sibling",expr__140031)))){
return shadow.dom.get_next_sibling(script);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("script tag with invalid dom ref",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dom-ref","dom-ref",-1127826326),dom_ref,new cljs.core.Keyword(null,"script","script",-1304443801),script], null));
}
}
}
}
}
} else {
return null;
}
});
/**
 * a <script type="shadow/run" data-fn="js-fn">edn-args</script> tag is meant to embed calls to javascript in html
 * instead of writing the javascript inline, we only define the call and its args + the location in the dom
 * we want to reference. this allows the javascript to be loaded as late as possible, avoids unknown reference errors,
 * does not litter the html with $(function() {}); and since a dom reference point is provided it makes it more
 * logical to reference dom elements via the server, no need to mess with id/class selectors.
 * 
 * script tags will be executed as soon as the js module is loaded (assuming it called module-ready), not on dom ready
 * which means it triggers earlier
 */
shadow.api.run_script_tag = (function shadow$api$run_script_tag(script){
var init_fn = shadow.dom.data(script,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = shadow.dom.get_html(script);
var args__$1 = (cljs.core.truth_((function (){var and__3938__auto__ = args;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("",args);
} else {
return and__3938__auto__;
}
})())?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(args):null);
var dom_el = shadow.api.script__GT_dom_el(script);
var args__$2 = (cljs.core.truth_(dom_el)?cljs.core.cons(dom_el,args__$1):args__$1);
var queued_fn = goog.getObjectByName(init_fn);
if(cljs.core.truth_(queued_fn)){
var console__37940__auto___140034 = (window["console"]);
if(cljs.core.truth_(console__37940__auto___140034)){
console__37940__auto___140034.log(shadow.util.console_friendly("init"),shadow.util.console_friendly(init_fn));
} else {
}

return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(queued_fn,args__$2);
} else {
var console__37940__auto__ = (window["console"]);
if(cljs.core.truth_(console__37940__auto__)){
return console__37940__auto__.log(shadow.util.console_friendly("unknown init function"),shadow.util.console_friendly(init_fn),shadow.util.console_friendly(args__$2));
} else {
return null;
}
}
});
shadow.api.script_tags_for_ns = (function shadow$api$script_tags_for_ns(ns_name){
var ns_name__$1 = clojure.string.replace(ns_name,/-/,"_");
var iter__4324__auto__ = ((function (ns_name__$1){
return (function shadow$api$script_tags_for_ns_$_iter__140037(s__140038){
return (new cljs.core.LazySeq(null,((function (ns_name__$1){
return (function (){
var s__140038__$1 = s__140038;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__140038__$1);
if(temp__5457__auto__){
var s__140038__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__140038__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__140038__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__140040 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__140039 = (0);
while(true){
if((i__140039 < size__4323__auto__)){
var script = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__140039);
var fn = shadow.dom.data(script,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var fn_ns = fn.substring((0),fn.lastIndexOf("."));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns_name__$1,fn_ns)){
cljs.core.chunk_append(b__140040,script);

var G__140041 = (i__140039 + (1));
i__140039 = G__140041;
continue;
} else {
var G__140042 = (i__140039 + (1));
i__140039 = G__140042;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__140040),shadow$api$script_tags_for_ns_$_iter__140037(cljs.core.chunk_rest(s__140038__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__140040),null);
}
} else {
var script = cljs.core.first(s__140038__$2);
var fn = shadow.dom.data(script,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var fn_ns = fn.substring((0),fn.lastIndexOf("."));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns_name__$1,fn_ns)){
return cljs.core.cons(script,shadow$api$script_tags_for_ns_$_iter__140037(cljs.core.rest(s__140038__$2)));
} else {
var G__140043 = cljs.core.rest(s__140038__$2);
s__140038__$1 = G__140043;
continue;
}
}
} else {
return null;
}
break;
}
});})(ns_name__$1))
,null,null));
});})(ns_name__$1))
;
return iter__4324__auto__(shadow.dom.query.cljs$core$IFn$_invoke$arity$1("script[type=\"shadow/run\"]"));
});
/**
 * use after calling (dom/set-html node html) and that html may contain embedded script tags
 * 
 *   only runs tags when the namespace of the function is already loaded, if the ns is not yet loaded to ns-ready function
 *   will pick remaining tags
 */
shadow.api.run_embedded_tags = (function shadow$api$run_embedded_tags(node){
var seq__140045 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2("script[type=\"shadow/run\"]",node));
var chunk__140048 = null;
var count__140049 = (0);
var i__140050 = (0);
while(true){
if((i__140050 < count__140049)){
var script = chunk__140048.cljs$core$IIndexed$_nth$arity$2(null,i__140050);
var fn = shadow.dom.data(script,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var fn_ns = fn.substring((0),fn.lastIndexOf("."));
if(cljs.core.contains_QMARK_(cljs.core.deref(shadow.api.ready_ref),fn_ns)){
shadow.api.run_script_tag(script);


var G__140054 = seq__140045;
var G__140055 = chunk__140048;
var G__140056 = count__140049;
var G__140057 = (i__140050 + (1));
seq__140045 = G__140054;
chunk__140048 = G__140055;
count__140049 = G__140056;
i__140050 = G__140057;
continue;
} else {
var G__140059 = seq__140045;
var G__140060 = chunk__140048;
var G__140061 = count__140049;
var G__140062 = (i__140050 + (1));
seq__140045 = G__140059;
chunk__140048 = G__140060;
count__140049 = G__140061;
i__140050 = G__140062;
continue;
}
} else {
var temp__5457__auto__ = cljs.core.seq(seq__140045);
if(temp__5457__auto__){
var seq__140045__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__140045__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__140045__$1);
var G__140064 = cljs.core.chunk_rest(seq__140045__$1);
var G__140065 = c__4351__auto__;
var G__140066 = cljs.core.count(c__4351__auto__);
var G__140067 = (0);
seq__140045 = G__140064;
chunk__140048 = G__140065;
count__140049 = G__140066;
i__140050 = G__140067;
continue;
} else {
var script = cljs.core.first(seq__140045__$1);
var fn = shadow.dom.data(script,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var fn_ns = fn.substring((0),fn.lastIndexOf("."));
if(cljs.core.contains_QMARK_(cljs.core.deref(shadow.api.ready_ref),fn_ns)){
shadow.api.run_script_tag(script);


var G__140069 = cljs.core.next(seq__140045__$1);
var G__140070 = null;
var G__140071 = (0);
var G__140072 = (0);
seq__140045 = G__140069;
chunk__140048 = G__140070;
count__140049 = G__140071;
i__140050 = G__140072;
continue;
} else {
var G__140073 = cljs.core.next(seq__140045__$1);
var G__140074 = null;
var G__140075 = (0);
var G__140076 = (0);
seq__140045 = G__140073;
chunk__140048 = G__140074;
count__140049 = G__140075;
i__140050 = G__140076;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.api.run_tags_for_ns = (function shadow$api$run_tags_for_ns(ns_name){
var console__37940__auto___140081 = (window["console"]);
if(cljs.core.truth_(console__37940__auto___140081)){
console__37940__auto___140081.log(shadow.util.console_friendly("ns-ready"),shadow.util.console_friendly(ns_name));
} else {
}

var seq__140077 = cljs.core.seq(shadow.api.script_tags_for_ns(ns_name));
var chunk__140078 = null;
var count__140079 = (0);
var i__140080 = (0);
while(true){
if((i__140080 < count__140079)){
var script = chunk__140078.cljs$core$IIndexed$_nth$arity$2(null,i__140080);
shadow.api.run_script_tag(script);


var G__140082 = seq__140077;
var G__140083 = chunk__140078;
var G__140084 = count__140079;
var G__140085 = (i__140080 + (1));
seq__140077 = G__140082;
chunk__140078 = G__140083;
count__140079 = G__140084;
i__140080 = G__140085;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__140077);
if(temp__5457__auto__){
var seq__140077__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__140077__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__140077__$1);
var G__140086 = cljs.core.chunk_rest(seq__140077__$1);
var G__140087 = c__4351__auto__;
var G__140088 = cljs.core.count(c__4351__auto__);
var G__140089 = (0);
seq__140077 = G__140086;
chunk__140078 = G__140087;
count__140079 = G__140088;
i__140080 = G__140089;
continue;
} else {
var script = cljs.core.first(seq__140077__$1);
shadow.api.run_script_tag(script);


var G__140090 = cljs.core.next(seq__140077__$1);
var G__140091 = null;
var G__140092 = (0);
var G__140093 = (0);
seq__140077 = G__140090;
chunk__140078 = G__140091;
count__140079 = G__140092;
i__140080 = G__140093;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.api.restart = (function shadow$api$restart(){
var seq__140094 = cljs.core.seq(cljs.core.deref(shadow.api.load_order_ref));
var chunk__140097 = null;
var count__140098 = (0);
var i__140099 = (0);
while(true){
if((i__140099 < count__140098)){
var ns_name = chunk__140097.cljs$core$IIndexed$_nth$arity$2(null,i__140099);
var map__140102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.api.ready_ref),ns_name);
var map__140102__$1 = ((((!((map__140102 == null)))?(((((map__140102.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__140102.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__140102):map__140102);
var opts = map__140102__$1;
var reloadable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140102__$1,new cljs.core.Keyword(null,"reloadable","reloadable",-1517539404));
if(cljs.core.truth_(reloadable)){
shadow.api.run_tags_for_ns(ns_name);


var G__140107 = seq__140094;
var G__140108 = chunk__140097;
var G__140109 = count__140098;
var G__140110 = (i__140099 + (1));
seq__140094 = G__140107;
chunk__140097 = G__140108;
count__140098 = G__140109;
i__140099 = G__140110;
continue;
} else {
var G__140111 = seq__140094;
var G__140112 = chunk__140097;
var G__140113 = count__140098;
var G__140114 = (i__140099 + (1));
seq__140094 = G__140111;
chunk__140097 = G__140112;
count__140098 = G__140113;
i__140099 = G__140114;
continue;
}
} else {
var temp__5457__auto__ = cljs.core.seq(seq__140094);
if(temp__5457__auto__){
var seq__140094__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__140094__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__140094__$1);
var G__140115 = cljs.core.chunk_rest(seq__140094__$1);
var G__140116 = c__4351__auto__;
var G__140117 = cljs.core.count(c__4351__auto__);
var G__140118 = (0);
seq__140094 = G__140115;
chunk__140097 = G__140116;
count__140098 = G__140117;
i__140099 = G__140118;
continue;
} else {
var ns_name = cljs.core.first(seq__140094__$1);
var map__140104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.api.ready_ref),ns_name);
var map__140104__$1 = ((((!((map__140104 == null)))?(((((map__140104.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__140104.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__140104):map__140104);
var opts = map__140104__$1;
var reloadable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__140104__$1,new cljs.core.Keyword(null,"reloadable","reloadable",-1517539404));
if(cljs.core.truth_(reloadable)){
shadow.api.run_tags_for_ns(ns_name);


var G__140119 = cljs.core.next(seq__140094__$1);
var G__140120 = null;
var G__140121 = (0);
var G__140122 = (0);
seq__140094 = G__140119;
chunk__140097 = G__140120;
count__140098 = G__140121;
i__140099 = G__140122;
continue;
} else {
var G__140123 = cljs.core.next(seq__140094__$1);
var G__140124 = null;
var G__140125 = (0);
var G__140126 = (0);
seq__140094 = G__140123;
chunk__140097 = G__140124;
count__140098 = G__140125;
i__140099 = G__140126;
continue;
}
}
} else {
return null;
}
}
break;
}
});
/**
 * use (ns-ready) macro, do not use this directly
 */
shadow.api.ns_ready_STAR_ = (function shadow$api$ns_ready_STAR_(ns_name,opts){
if(cljs.core.contains_QMARK_(cljs.core.deref(shadow.api.ready_ref),ns_name)){
return null;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(shadow.api.ready_ref,cljs.core.assoc,ns_name,opts);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(shadow.api.load_order_ref,cljs.core.conj,ns_name);

return setTimeout((function (){
return shadow.api.run_tags_for_ns(ns_name);
}),(0));
}
});
goog.exportSymbol('shadow.api.ns_ready_STAR_', shadow.api.ns_ready_STAR_);

//# sourceMappingURL=shadow.api.js.map
