goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__57342 = arguments.length;
switch (G__57342) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async57347 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57347 = (function (f,blockable,meta57348){
this.f = f;
this.blockable = blockable;
this.meta57348 = meta57348;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async57347.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57349,meta57348__$1){
var self__ = this;
var _57349__$1 = this;
return (new cljs.core.async.t_cljs$core$async57347(self__.f,self__.blockable,meta57348__$1));
});

cljs.core.async.t_cljs$core$async57347.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57349){
var self__ = this;
var _57349__$1 = this;
return self__.meta57348;
});

cljs.core.async.t_cljs$core$async57347.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async57347.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async57347.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async57347.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async57347.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta57348","meta57348",1985306314,null)], null);
});

cljs.core.async.t_cljs$core$async57347.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57347.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57347";

cljs.core.async.t_cljs$core$async57347.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async57347");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async57347.
 */
cljs.core.async.__GT_t_cljs$core$async57347 = (function cljs$core$async$__GT_t_cljs$core$async57347(f__$1,blockable__$1,meta57348){
return (new cljs.core.async.t_cljs$core$async57347(f__$1,blockable__$1,meta57348));
});

}

return (new cljs.core.async.t_cljs$core$async57347(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__57377 = arguments.length;
switch (G__57377) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__57382 = arguments.length;
switch (G__57382) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__57385 = arguments.length;
switch (G__57385) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_57387 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_57387) : fn1.call(null,val_57387));
} else {
cljs.core.async.impl.dispatch.run(((function (val_57387,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_57387) : fn1.call(null,val_57387));
});})(val_57387,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__57389 = arguments.length;
switch (G__57389) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4408__auto___57398 = n;
var x_57399 = (0);
while(true){
if((x_57399 < n__4408__auto___57398)){
(a[x_57399] = (0));

var G__57400 = (x_57399 + (1));
x_57399 = G__57400;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__57402 = (i + (1));
i = G__57402;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async57403 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57403 = (function (flag,meta57404){
this.flag = flag;
this.meta57404 = meta57404;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async57403.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_57405,meta57404__$1){
var self__ = this;
var _57405__$1 = this;
return (new cljs.core.async.t_cljs$core$async57403(self__.flag,meta57404__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async57403.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_57405){
var self__ = this;
var _57405__$1 = this;
return self__.meta57404;
});})(flag))
;

cljs.core.async.t_cljs$core$async57403.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async57403.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async57403.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async57403.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async57403.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta57404","meta57404",-1798162351,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async57403.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57403.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57403";

cljs.core.async.t_cljs$core$async57403.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async57403");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async57403.
 */
cljs.core.async.__GT_t_cljs$core$async57403 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async57403(flag__$1,meta57404){
return (new cljs.core.async.t_cljs$core$async57403(flag__$1,meta57404));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async57403(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async57406 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57406 = (function (flag,cb,meta57407){
this.flag = flag;
this.cb = cb;
this.meta57407 = meta57407;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async57406.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57408,meta57407__$1){
var self__ = this;
var _57408__$1 = this;
return (new cljs.core.async.t_cljs$core$async57406(self__.flag,self__.cb,meta57407__$1));
});

cljs.core.async.t_cljs$core$async57406.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57408){
var self__ = this;
var _57408__$1 = this;
return self__.meta57407;
});

cljs.core.async.t_cljs$core$async57406.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async57406.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async57406.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async57406.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async57406.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta57407","meta57407",940952753,null)], null);
});

cljs.core.async.t_cljs$core$async57406.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57406.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57406";

cljs.core.async.t_cljs$core$async57406.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async57406");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async57406.
 */
cljs.core.async.__GT_t_cljs$core$async57406 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async57406(flag__$1,cb__$1,meta57407){
return (new cljs.core.async.t_cljs$core$async57406(flag__$1,cb__$1,meta57407));
});

}

return (new cljs.core.async.t_cljs$core$async57406(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__57409_SHARP_){
var G__57411 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__57409_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__57411) : fret.call(null,G__57411));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__57410_SHARP_){
var G__57412 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__57410_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__57412) : fret.call(null,G__57412));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__3949__auto__ = wport;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return port;
}
})()], null));
} else {
var G__57413 = (i + (1));
i = G__57413;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3949__auto__ = ret;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3938__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___57419 = arguments.length;
var i__4532__auto___57420 = (0);
while(true){
if((i__4532__auto___57420 < len__4531__auto___57419)){
args__4534__auto__.push((arguments[i__4532__auto___57420]));

var G__57421 = (i__4532__auto___57420 + (1));
i__4532__auto___57420 = G__57421;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__57416){
var map__57417 = p__57416;
var map__57417__$1 = ((((!((map__57417 == null)))?(((((map__57417.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57417.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__57417):map__57417);
var opts = map__57417__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq57414){
var G__57415 = cljs.core.first(seq57414);
var seq57414__$1 = cljs.core.next(seq57414);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57415,seq57414__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__57423 = arguments.length;
switch (G__57423) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__32222__auto___57489 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___57489){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___57489){
return (function (state_57447){
var state_val_57448 = (state_57447[(1)]);
if((state_val_57448 === (7))){
var inst_57443 = (state_57447[(2)]);
var state_57447__$1 = state_57447;
var statearr_57453_57490 = state_57447__$1;
(statearr_57453_57490[(2)] = inst_57443);

(statearr_57453_57490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57448 === (1))){
var state_57447__$1 = state_57447;
var statearr_57454_57491 = state_57447__$1;
(statearr_57454_57491[(2)] = null);

(statearr_57454_57491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57448 === (4))){
var inst_57426 = (state_57447[(7)]);
var inst_57426__$1 = (state_57447[(2)]);
var inst_57427 = (inst_57426__$1 == null);
var state_57447__$1 = (function (){var statearr_57455 = state_57447;
(statearr_57455[(7)] = inst_57426__$1);

return statearr_57455;
})();
if(cljs.core.truth_(inst_57427)){
var statearr_57456_57492 = state_57447__$1;
(statearr_57456_57492[(1)] = (5));

} else {
var statearr_57457_57493 = state_57447__$1;
(statearr_57457_57493[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57448 === (13))){
var state_57447__$1 = state_57447;
var statearr_57458_57494 = state_57447__$1;
(statearr_57458_57494[(2)] = null);

(statearr_57458_57494[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57448 === (6))){
var inst_57426 = (state_57447[(7)]);
var state_57447__$1 = state_57447;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_57447__$1,(11),to,inst_57426);
} else {
if((state_val_57448 === (3))){
var inst_57445 = (state_57447[(2)]);
var state_57447__$1 = state_57447;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57447__$1,inst_57445);
} else {
if((state_val_57448 === (12))){
var state_57447__$1 = state_57447;
var statearr_57462_57495 = state_57447__$1;
(statearr_57462_57495[(2)] = null);

(statearr_57462_57495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57448 === (2))){
var state_57447__$1 = state_57447;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57447__$1,(4),from);
} else {
if((state_val_57448 === (11))){
var inst_57436 = (state_57447[(2)]);
var state_57447__$1 = state_57447;
if(cljs.core.truth_(inst_57436)){
var statearr_57466_57496 = state_57447__$1;
(statearr_57466_57496[(1)] = (12));

} else {
var statearr_57467_57498 = state_57447__$1;
(statearr_57467_57498[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57448 === (9))){
var state_57447__$1 = state_57447;
var statearr_57468_57500 = state_57447__$1;
(statearr_57468_57500[(2)] = null);

(statearr_57468_57500[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57448 === (5))){
var state_57447__$1 = state_57447;
if(cljs.core.truth_(close_QMARK_)){
var statearr_57469_57501 = state_57447__$1;
(statearr_57469_57501[(1)] = (8));

} else {
var statearr_57470_57502 = state_57447__$1;
(statearr_57470_57502[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57448 === (14))){
var inst_57441 = (state_57447[(2)]);
var state_57447__$1 = state_57447;
var statearr_57475_57503 = state_57447__$1;
(statearr_57475_57503[(2)] = inst_57441);

(statearr_57475_57503[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57448 === (10))){
var inst_57433 = (state_57447[(2)]);
var state_57447__$1 = state_57447;
var statearr_57476_57504 = state_57447__$1;
(statearr_57476_57504[(2)] = inst_57433);

(statearr_57476_57504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57448 === (8))){
var inst_57430 = cljs.core.async.close_BANG_(to);
var state_57447__$1 = state_57447;
var statearr_57477_57505 = state_57447__$1;
(statearr_57477_57505[(2)] = inst_57430);

(statearr_57477_57505[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___57489))
;
return ((function (switch__31990__auto__,c__32222__auto___57489){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_57478 = [null,null,null,null,null,null,null,null];
(statearr_57478[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_57478[(1)] = (1));

return statearr_57478;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_57447){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_57447);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e57479){if((e57479 instanceof Object)){
var ex__31994__auto__ = e57479;
var statearr_57480_57507 = state_57447;
(statearr_57480_57507[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_57447);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57479;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57508 = state_57447;
state_57447 = G__57508;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_57447){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_57447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___57489))
})();
var state__32224__auto__ = (function (){var statearr_57484 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_57484[(6)] = c__32222__auto___57489);

return statearr_57484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___57489))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__57509){
var vec__57510 = p__57509;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57510,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57510,(1),null);
var job = vec__57510;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__32222__auto___57685 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___57685,res,vec__57510,v,p,job,jobs,results){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___57685,res,vec__57510,v,p,job,jobs,results){
return (function (state_57517){
var state_val_57518 = (state_57517[(1)]);
if((state_val_57518 === (1))){
var state_57517__$1 = state_57517;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_57517__$1,(2),res,v);
} else {
if((state_val_57518 === (2))){
var inst_57514 = (state_57517[(2)]);
var inst_57515 = cljs.core.async.close_BANG_(res);
var state_57517__$1 = (function (){var statearr_57519 = state_57517;
(statearr_57519[(7)] = inst_57514);

return statearr_57519;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_57517__$1,inst_57515);
} else {
return null;
}
}
});})(c__32222__auto___57685,res,vec__57510,v,p,job,jobs,results))
;
return ((function (switch__31990__auto__,c__32222__auto___57685,res,vec__57510,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0 = (function (){
var statearr_57520 = [null,null,null,null,null,null,null,null];
(statearr_57520[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__);

(statearr_57520[(1)] = (1));

return statearr_57520;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1 = (function (state_57517){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_57517);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e57521){if((e57521 instanceof Object)){
var ex__31994__auto__ = e57521;
var statearr_57522_57688 = state_57517;
(statearr_57522_57688[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_57517);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57521;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57689 = state_57517;
state_57517 = G__57689;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__ = function(state_57517){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1.call(this,state_57517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___57685,res,vec__57510,v,p,job,jobs,results))
})();
var state__32224__auto__ = (function (){var statearr_57523 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_57523[(6)] = c__32222__auto___57685);

return statearr_57523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___57685,res,vec__57510,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__57524){
var vec__57525 = p__57524;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57525,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57525,(1),null);
var job = vec__57525;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4408__auto___57693 = n;
var __57694 = (0);
while(true){
if((__57694 < n__4408__auto___57693)){
var G__57528_57695 = type;
var G__57528_57696__$1 = (((G__57528_57695 instanceof cljs.core.Keyword))?G__57528_57695.fqn:null);
switch (G__57528_57696__$1) {
case "compute":
var c__32222__auto___57698 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__57694,c__32222__auto___57698,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (__57694,c__32222__auto___57698,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async){
return (function (state_57541){
var state_val_57542 = (state_57541[(1)]);
if((state_val_57542 === (1))){
var state_57541__$1 = state_57541;
var statearr_57543_57699 = state_57541__$1;
(statearr_57543_57699[(2)] = null);

(statearr_57543_57699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57542 === (2))){
var state_57541__$1 = state_57541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57541__$1,(4),jobs);
} else {
if((state_val_57542 === (3))){
var inst_57539 = (state_57541[(2)]);
var state_57541__$1 = state_57541;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57541__$1,inst_57539);
} else {
if((state_val_57542 === (4))){
var inst_57531 = (state_57541[(2)]);
var inst_57532 = process(inst_57531);
var state_57541__$1 = state_57541;
if(cljs.core.truth_(inst_57532)){
var statearr_57544_57703 = state_57541__$1;
(statearr_57544_57703[(1)] = (5));

} else {
var statearr_57545_57704 = state_57541__$1;
(statearr_57545_57704[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57542 === (5))){
var state_57541__$1 = state_57541;
var statearr_57546_57705 = state_57541__$1;
(statearr_57546_57705[(2)] = null);

(statearr_57546_57705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57542 === (6))){
var state_57541__$1 = state_57541;
var statearr_57547_57706 = state_57541__$1;
(statearr_57547_57706[(2)] = null);

(statearr_57547_57706[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57542 === (7))){
var inst_57537 = (state_57541[(2)]);
var state_57541__$1 = state_57541;
var statearr_57548_57707 = state_57541__$1;
(statearr_57548_57707[(2)] = inst_57537);

(statearr_57548_57707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__57694,c__32222__auto___57698,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async))
;
return ((function (__57694,switch__31990__auto__,c__32222__auto___57698,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0 = (function (){
var statearr_57549 = [null,null,null,null,null,null,null];
(statearr_57549[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__);

(statearr_57549[(1)] = (1));

return statearr_57549;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1 = (function (state_57541){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_57541);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e57550){if((e57550 instanceof Object)){
var ex__31994__auto__ = e57550;
var statearr_57551_57708 = state_57541;
(statearr_57551_57708[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_57541);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57550;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57709 = state_57541;
state_57541 = G__57709;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__ = function(state_57541){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1.call(this,state_57541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__;
})()
;})(__57694,switch__31990__auto__,c__32222__auto___57698,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async))
})();
var state__32224__auto__ = (function (){var statearr_57552 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_57552[(6)] = c__32222__auto___57698);

return statearr_57552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(__57694,c__32222__auto___57698,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async))
);


break;
case "async":
var c__32222__auto___57710 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__57694,c__32222__auto___57710,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (__57694,c__32222__auto___57710,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async){
return (function (state_57565){
var state_val_57566 = (state_57565[(1)]);
if((state_val_57566 === (1))){
var state_57565__$1 = state_57565;
var statearr_57567_57711 = state_57565__$1;
(statearr_57567_57711[(2)] = null);

(statearr_57567_57711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57566 === (2))){
var state_57565__$1 = state_57565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57565__$1,(4),jobs);
} else {
if((state_val_57566 === (3))){
var inst_57563 = (state_57565[(2)]);
var state_57565__$1 = state_57565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57565__$1,inst_57563);
} else {
if((state_val_57566 === (4))){
var inst_57555 = (state_57565[(2)]);
var inst_57556 = async(inst_57555);
var state_57565__$1 = state_57565;
if(cljs.core.truth_(inst_57556)){
var statearr_57568_57712 = state_57565__$1;
(statearr_57568_57712[(1)] = (5));

} else {
var statearr_57569_57713 = state_57565__$1;
(statearr_57569_57713[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57566 === (5))){
var state_57565__$1 = state_57565;
var statearr_57570_57714 = state_57565__$1;
(statearr_57570_57714[(2)] = null);

(statearr_57570_57714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57566 === (6))){
var state_57565__$1 = state_57565;
var statearr_57571_57715 = state_57565__$1;
(statearr_57571_57715[(2)] = null);

(statearr_57571_57715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57566 === (7))){
var inst_57561 = (state_57565[(2)]);
var state_57565__$1 = state_57565;
var statearr_57572_57716 = state_57565__$1;
(statearr_57572_57716[(2)] = inst_57561);

(statearr_57572_57716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__57694,c__32222__auto___57710,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async))
;
return ((function (__57694,switch__31990__auto__,c__32222__auto___57710,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0 = (function (){
var statearr_57573 = [null,null,null,null,null,null,null];
(statearr_57573[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__);

(statearr_57573[(1)] = (1));

return statearr_57573;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1 = (function (state_57565){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_57565);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e57574){if((e57574 instanceof Object)){
var ex__31994__auto__ = e57574;
var statearr_57575_57717 = state_57565;
(statearr_57575_57717[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_57565);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57574;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57718 = state_57565;
state_57565 = G__57718;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__ = function(state_57565){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1.call(this,state_57565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__;
})()
;})(__57694,switch__31990__auto__,c__32222__auto___57710,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async))
})();
var state__32224__auto__ = (function (){var statearr_57576 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_57576[(6)] = c__32222__auto___57710);

return statearr_57576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(__57694,c__32222__auto___57710,G__57528_57695,G__57528_57696__$1,n__4408__auto___57693,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__57528_57696__$1)].join('')));

}

var G__57719 = (__57694 + (1));
__57694 = G__57719;
continue;
} else {
}
break;
}

var c__32222__auto___57720 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___57720,jobs,results,process,async){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___57720,jobs,results,process,async){
return (function (state_57598){
var state_val_57599 = (state_57598[(1)]);
if((state_val_57599 === (1))){
var state_57598__$1 = state_57598;
var statearr_57600_57722 = state_57598__$1;
(statearr_57600_57722[(2)] = null);

(statearr_57600_57722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57599 === (2))){
var state_57598__$1 = state_57598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57598__$1,(4),from);
} else {
if((state_val_57599 === (3))){
var inst_57596 = (state_57598[(2)]);
var state_57598__$1 = state_57598;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57598__$1,inst_57596);
} else {
if((state_val_57599 === (4))){
var inst_57579 = (state_57598[(7)]);
var inst_57579__$1 = (state_57598[(2)]);
var inst_57580 = (inst_57579__$1 == null);
var state_57598__$1 = (function (){var statearr_57601 = state_57598;
(statearr_57601[(7)] = inst_57579__$1);

return statearr_57601;
})();
if(cljs.core.truth_(inst_57580)){
var statearr_57602_57724 = state_57598__$1;
(statearr_57602_57724[(1)] = (5));

} else {
var statearr_57603_57725 = state_57598__$1;
(statearr_57603_57725[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57599 === (5))){
var inst_57582 = cljs.core.async.close_BANG_(jobs);
var state_57598__$1 = state_57598;
var statearr_57604_57726 = state_57598__$1;
(statearr_57604_57726[(2)] = inst_57582);

(statearr_57604_57726[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57599 === (6))){
var inst_57579 = (state_57598[(7)]);
var inst_57584 = (state_57598[(8)]);
var inst_57584__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_57585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57586 = [inst_57579,inst_57584__$1];
var inst_57587 = (new cljs.core.PersistentVector(null,2,(5),inst_57585,inst_57586,null));
var state_57598__$1 = (function (){var statearr_57606 = state_57598;
(statearr_57606[(8)] = inst_57584__$1);

return statearr_57606;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_57598__$1,(8),jobs,inst_57587);
} else {
if((state_val_57599 === (7))){
var inst_57594 = (state_57598[(2)]);
var state_57598__$1 = state_57598;
var statearr_57607_57727 = state_57598__$1;
(statearr_57607_57727[(2)] = inst_57594);

(statearr_57607_57727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57599 === (8))){
var inst_57584 = (state_57598[(8)]);
var inst_57589 = (state_57598[(2)]);
var state_57598__$1 = (function (){var statearr_57608 = state_57598;
(statearr_57608[(9)] = inst_57589);

return statearr_57608;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_57598__$1,(9),results,inst_57584);
} else {
if((state_val_57599 === (9))){
var inst_57591 = (state_57598[(2)]);
var state_57598__$1 = (function (){var statearr_57609 = state_57598;
(statearr_57609[(10)] = inst_57591);

return statearr_57609;
})();
var statearr_57610_57728 = state_57598__$1;
(statearr_57610_57728[(2)] = null);

(statearr_57610_57728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___57720,jobs,results,process,async))
;
return ((function (switch__31990__auto__,c__32222__auto___57720,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0 = (function (){
var statearr_57611 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_57611[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__);

(statearr_57611[(1)] = (1));

return statearr_57611;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1 = (function (state_57598){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_57598);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e57612){if((e57612 instanceof Object)){
var ex__31994__auto__ = e57612;
var statearr_57613_57730 = state_57598;
(statearr_57613_57730[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_57598);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57612;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57731 = state_57598;
state_57598 = G__57731;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__ = function(state_57598){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1.call(this,state_57598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___57720,jobs,results,process,async))
})();
var state__32224__auto__ = (function (){var statearr_57614 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_57614[(6)] = c__32222__auto___57720);

return statearr_57614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___57720,jobs,results,process,async))
);


var c__32222__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto__,jobs,results,process,async){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto__,jobs,results,process,async){
return (function (state_57652){
var state_val_57653 = (state_57652[(1)]);
if((state_val_57653 === (7))){
var inst_57648 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
var statearr_57654_57737 = state_57652__$1;
(statearr_57654_57737[(2)] = inst_57648);

(statearr_57654_57737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (20))){
var state_57652__$1 = state_57652;
var statearr_57655_57738 = state_57652__$1;
(statearr_57655_57738[(2)] = null);

(statearr_57655_57738[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (1))){
var state_57652__$1 = state_57652;
var statearr_57656_57739 = state_57652__$1;
(statearr_57656_57739[(2)] = null);

(statearr_57656_57739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (4))){
var inst_57617 = (state_57652[(7)]);
var inst_57617__$1 = (state_57652[(2)]);
var inst_57618 = (inst_57617__$1 == null);
var state_57652__$1 = (function (){var statearr_57657 = state_57652;
(statearr_57657[(7)] = inst_57617__$1);

return statearr_57657;
})();
if(cljs.core.truth_(inst_57618)){
var statearr_57658_57740 = state_57652__$1;
(statearr_57658_57740[(1)] = (5));

} else {
var statearr_57659_57741 = state_57652__$1;
(statearr_57659_57741[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (15))){
var inst_57630 = (state_57652[(8)]);
var state_57652__$1 = state_57652;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_57652__$1,(18),to,inst_57630);
} else {
if((state_val_57653 === (21))){
var inst_57643 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
var statearr_57660_57742 = state_57652__$1;
(statearr_57660_57742[(2)] = inst_57643);

(statearr_57660_57742[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (13))){
var inst_57645 = (state_57652[(2)]);
var state_57652__$1 = (function (){var statearr_57661 = state_57652;
(statearr_57661[(9)] = inst_57645);

return statearr_57661;
})();
var statearr_57662_57743 = state_57652__$1;
(statearr_57662_57743[(2)] = null);

(statearr_57662_57743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (6))){
var inst_57617 = (state_57652[(7)]);
var state_57652__$1 = state_57652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57652__$1,(11),inst_57617);
} else {
if((state_val_57653 === (17))){
var inst_57638 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
if(cljs.core.truth_(inst_57638)){
var statearr_57663_57744 = state_57652__$1;
(statearr_57663_57744[(1)] = (19));

} else {
var statearr_57664_57745 = state_57652__$1;
(statearr_57664_57745[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (3))){
var inst_57650 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57652__$1,inst_57650);
} else {
if((state_val_57653 === (12))){
var inst_57627 = (state_57652[(10)]);
var state_57652__$1 = state_57652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57652__$1,(14),inst_57627);
} else {
if((state_val_57653 === (2))){
var state_57652__$1 = state_57652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57652__$1,(4),results);
} else {
if((state_val_57653 === (19))){
var state_57652__$1 = state_57652;
var statearr_57665_57746 = state_57652__$1;
(statearr_57665_57746[(2)] = null);

(statearr_57665_57746[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (11))){
var inst_57627 = (state_57652[(2)]);
var state_57652__$1 = (function (){var statearr_57666 = state_57652;
(statearr_57666[(10)] = inst_57627);

return statearr_57666;
})();
var statearr_57667_57748 = state_57652__$1;
(statearr_57667_57748[(2)] = null);

(statearr_57667_57748[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (9))){
var state_57652__$1 = state_57652;
var statearr_57668_57750 = state_57652__$1;
(statearr_57668_57750[(2)] = null);

(statearr_57668_57750[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (5))){
var state_57652__$1 = state_57652;
if(cljs.core.truth_(close_QMARK_)){
var statearr_57669_57751 = state_57652__$1;
(statearr_57669_57751[(1)] = (8));

} else {
var statearr_57670_57752 = state_57652__$1;
(statearr_57670_57752[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (14))){
var inst_57632 = (state_57652[(11)]);
var inst_57630 = (state_57652[(8)]);
var inst_57630__$1 = (state_57652[(2)]);
var inst_57631 = (inst_57630__$1 == null);
var inst_57632__$1 = cljs.core.not(inst_57631);
var state_57652__$1 = (function (){var statearr_57674 = state_57652;
(statearr_57674[(11)] = inst_57632__$1);

(statearr_57674[(8)] = inst_57630__$1);

return statearr_57674;
})();
if(inst_57632__$1){
var statearr_57675_57754 = state_57652__$1;
(statearr_57675_57754[(1)] = (15));

} else {
var statearr_57676_57755 = state_57652__$1;
(statearr_57676_57755[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (16))){
var inst_57632 = (state_57652[(11)]);
var state_57652__$1 = state_57652;
var statearr_57677_57757 = state_57652__$1;
(statearr_57677_57757[(2)] = inst_57632);

(statearr_57677_57757[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (10))){
var inst_57624 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
var statearr_57678_57758 = state_57652__$1;
(statearr_57678_57758[(2)] = inst_57624);

(statearr_57678_57758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (18))){
var inst_57635 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
var statearr_57679_57759 = state_57652__$1;
(statearr_57679_57759[(2)] = inst_57635);

(statearr_57679_57759[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (8))){
var inst_57621 = cljs.core.async.close_BANG_(to);
var state_57652__$1 = state_57652;
var statearr_57680_57760 = state_57652__$1;
(statearr_57680_57760[(2)] = inst_57621);

(statearr_57680_57760[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto__,jobs,results,process,async))
;
return ((function (switch__31990__auto__,c__32222__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0 = (function (){
var statearr_57681 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57681[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__);

(statearr_57681[(1)] = (1));

return statearr_57681;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1 = (function (state_57652){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_57652);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e57682){if((e57682 instanceof Object)){
var ex__31994__auto__ = e57682;
var statearr_57683_57761 = state_57652;
(statearr_57683_57761[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_57652);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57682;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57762 = state_57652;
state_57652 = G__57762;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__ = function(state_57652){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1.call(this,state_57652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31991__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto__,jobs,results,process,async))
})();
var state__32224__auto__ = (function (){var statearr_57684 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_57684[(6)] = c__32222__auto__);

return statearr_57684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto__,jobs,results,process,async))
);

return c__32222__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__57765 = arguments.length;
switch (G__57765) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__57772 = arguments.length;
switch (G__57772) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__57775 = arguments.length;
switch (G__57775) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__32222__auto___57824 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___57824,tc,fc){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___57824,tc,fc){
return (function (state_57801){
var state_val_57802 = (state_57801[(1)]);
if((state_val_57802 === (7))){
var inst_57797 = (state_57801[(2)]);
var state_57801__$1 = state_57801;
var statearr_57803_57825 = state_57801__$1;
(statearr_57803_57825[(2)] = inst_57797);

(statearr_57803_57825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57802 === (1))){
var state_57801__$1 = state_57801;
var statearr_57804_57826 = state_57801__$1;
(statearr_57804_57826[(2)] = null);

(statearr_57804_57826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57802 === (4))){
var inst_57778 = (state_57801[(7)]);
var inst_57778__$1 = (state_57801[(2)]);
var inst_57779 = (inst_57778__$1 == null);
var state_57801__$1 = (function (){var statearr_57805 = state_57801;
(statearr_57805[(7)] = inst_57778__$1);

return statearr_57805;
})();
if(cljs.core.truth_(inst_57779)){
var statearr_57806_57827 = state_57801__$1;
(statearr_57806_57827[(1)] = (5));

} else {
var statearr_57807_57828 = state_57801__$1;
(statearr_57807_57828[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57802 === (13))){
var state_57801__$1 = state_57801;
var statearr_57808_57829 = state_57801__$1;
(statearr_57808_57829[(2)] = null);

(statearr_57808_57829[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57802 === (6))){
var inst_57778 = (state_57801[(7)]);
var inst_57784 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_57778) : p.call(null,inst_57778));
var state_57801__$1 = state_57801;
if(cljs.core.truth_(inst_57784)){
var statearr_57809_57830 = state_57801__$1;
(statearr_57809_57830[(1)] = (9));

} else {
var statearr_57810_57831 = state_57801__$1;
(statearr_57810_57831[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57802 === (3))){
var inst_57799 = (state_57801[(2)]);
var state_57801__$1 = state_57801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57801__$1,inst_57799);
} else {
if((state_val_57802 === (12))){
var state_57801__$1 = state_57801;
var statearr_57811_57832 = state_57801__$1;
(statearr_57811_57832[(2)] = null);

(statearr_57811_57832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57802 === (2))){
var state_57801__$1 = state_57801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57801__$1,(4),ch);
} else {
if((state_val_57802 === (11))){
var inst_57778 = (state_57801[(7)]);
var inst_57788 = (state_57801[(2)]);
var state_57801__$1 = state_57801;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_57801__$1,(8),inst_57788,inst_57778);
} else {
if((state_val_57802 === (9))){
var state_57801__$1 = state_57801;
var statearr_57812_57836 = state_57801__$1;
(statearr_57812_57836[(2)] = tc);

(statearr_57812_57836[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57802 === (5))){
var inst_57781 = cljs.core.async.close_BANG_(tc);
var inst_57782 = cljs.core.async.close_BANG_(fc);
var state_57801__$1 = (function (){var statearr_57813 = state_57801;
(statearr_57813[(8)] = inst_57781);

return statearr_57813;
})();
var statearr_57814_57837 = state_57801__$1;
(statearr_57814_57837[(2)] = inst_57782);

(statearr_57814_57837[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57802 === (14))){
var inst_57795 = (state_57801[(2)]);
var state_57801__$1 = state_57801;
var statearr_57815_57838 = state_57801__$1;
(statearr_57815_57838[(2)] = inst_57795);

(statearr_57815_57838[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57802 === (10))){
var state_57801__$1 = state_57801;
var statearr_57816_57839 = state_57801__$1;
(statearr_57816_57839[(2)] = fc);

(statearr_57816_57839[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57802 === (8))){
var inst_57790 = (state_57801[(2)]);
var state_57801__$1 = state_57801;
if(cljs.core.truth_(inst_57790)){
var statearr_57817_57840 = state_57801__$1;
(statearr_57817_57840[(1)] = (12));

} else {
var statearr_57818_57841 = state_57801__$1;
(statearr_57818_57841[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___57824,tc,fc))
;
return ((function (switch__31990__auto__,c__32222__auto___57824,tc,fc){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_57819 = [null,null,null,null,null,null,null,null,null];
(statearr_57819[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_57819[(1)] = (1));

return statearr_57819;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_57801){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_57801);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e57820){if((e57820 instanceof Object)){
var ex__31994__auto__ = e57820;
var statearr_57821_57842 = state_57801;
(statearr_57821_57842[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_57801);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57820;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57843 = state_57801;
state_57801 = G__57843;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_57801){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_57801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___57824,tc,fc))
})();
var state__32224__auto__ = (function (){var statearr_57822 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_57822[(6)] = c__32222__auto___57824);

return statearr_57822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___57824,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__32222__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto__){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto__){
return (function (state_57866){
var state_val_57867 = (state_57866[(1)]);
if((state_val_57867 === (7))){
var inst_57861 = (state_57866[(2)]);
var state_57866__$1 = state_57866;
var statearr_57868_57892 = state_57866__$1;
(statearr_57868_57892[(2)] = inst_57861);

(statearr_57868_57892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57867 === (1))){
var inst_57845 = init;
var state_57866__$1 = (function (){var statearr_57869 = state_57866;
(statearr_57869[(7)] = inst_57845);

return statearr_57869;
})();
var statearr_57870_57893 = state_57866__$1;
(statearr_57870_57893[(2)] = null);

(statearr_57870_57893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57867 === (4))){
var inst_57848 = (state_57866[(8)]);
var inst_57848__$1 = (state_57866[(2)]);
var inst_57849 = (inst_57848__$1 == null);
var state_57866__$1 = (function (){var statearr_57871 = state_57866;
(statearr_57871[(8)] = inst_57848__$1);

return statearr_57871;
})();
if(cljs.core.truth_(inst_57849)){
var statearr_57872_57894 = state_57866__$1;
(statearr_57872_57894[(1)] = (5));

} else {
var statearr_57873_57895 = state_57866__$1;
(statearr_57873_57895[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57867 === (6))){
var inst_57852 = (state_57866[(9)]);
var inst_57848 = (state_57866[(8)]);
var inst_57845 = (state_57866[(7)]);
var inst_57852__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_57845,inst_57848) : f.call(null,inst_57845,inst_57848));
var inst_57853 = cljs.core.reduced_QMARK_(inst_57852__$1);
var state_57866__$1 = (function (){var statearr_57874 = state_57866;
(statearr_57874[(9)] = inst_57852__$1);

return statearr_57874;
})();
if(inst_57853){
var statearr_57875_57896 = state_57866__$1;
(statearr_57875_57896[(1)] = (8));

} else {
var statearr_57876_57897 = state_57866__$1;
(statearr_57876_57897[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57867 === (3))){
var inst_57863 = (state_57866[(2)]);
var state_57866__$1 = state_57866;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57866__$1,inst_57863);
} else {
if((state_val_57867 === (2))){
var state_57866__$1 = state_57866;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57866__$1,(4),ch);
} else {
if((state_val_57867 === (9))){
var inst_57852 = (state_57866[(9)]);
var inst_57845 = inst_57852;
var state_57866__$1 = (function (){var statearr_57883 = state_57866;
(statearr_57883[(7)] = inst_57845);

return statearr_57883;
})();
var statearr_57884_57898 = state_57866__$1;
(statearr_57884_57898[(2)] = null);

(statearr_57884_57898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57867 === (5))){
var inst_57845 = (state_57866[(7)]);
var state_57866__$1 = state_57866;
var statearr_57885_57905 = state_57866__$1;
(statearr_57885_57905[(2)] = inst_57845);

(statearr_57885_57905[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57867 === (10))){
var inst_57859 = (state_57866[(2)]);
var state_57866__$1 = state_57866;
var statearr_57886_57906 = state_57866__$1;
(statearr_57886_57906[(2)] = inst_57859);

(statearr_57886_57906[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57867 === (8))){
var inst_57852 = (state_57866[(9)]);
var inst_57855 = cljs.core.deref(inst_57852);
var state_57866__$1 = state_57866;
var statearr_57887_57907 = state_57866__$1;
(statearr_57887_57907[(2)] = inst_57855);

(statearr_57887_57907[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto__))
;
return ((function (switch__31990__auto__,c__32222__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__31991__auto__ = null;
var cljs$core$async$reduce_$_state_machine__31991__auto____0 = (function (){
var statearr_57888 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57888[(0)] = cljs$core$async$reduce_$_state_machine__31991__auto__);

(statearr_57888[(1)] = (1));

return statearr_57888;
});
var cljs$core$async$reduce_$_state_machine__31991__auto____1 = (function (state_57866){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_57866);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e57889){if((e57889 instanceof Object)){
var ex__31994__auto__ = e57889;
var statearr_57890_57908 = state_57866;
(statearr_57890_57908[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_57866);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57889;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57909 = state_57866;
state_57866 = G__57909;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__31991__auto__ = function(state_57866){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__31991__auto____1.call(this,state_57866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__31991__auto____0;
cljs$core$async$reduce_$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__31991__auto____1;
return cljs$core$async$reduce_$_state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto__))
})();
var state__32224__auto__ = (function (){var statearr_57891 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_57891[(6)] = c__32222__auto__);

return statearr_57891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto__))
);

return c__32222__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__32222__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto__,f__$1){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto__,f__$1){
return (function (state_57915){
var state_val_57916 = (state_57915[(1)]);
if((state_val_57916 === (1))){
var inst_57910 = cljs.core.async.reduce(f__$1,init,ch);
var state_57915__$1 = state_57915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57915__$1,(2),inst_57910);
} else {
if((state_val_57916 === (2))){
var inst_57912 = (state_57915[(2)]);
var inst_57913 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_57912) : f__$1.call(null,inst_57912));
var state_57915__$1 = state_57915;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57915__$1,inst_57913);
} else {
return null;
}
}
});})(c__32222__auto__,f__$1))
;
return ((function (switch__31990__auto__,c__32222__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__31991__auto__ = null;
var cljs$core$async$transduce_$_state_machine__31991__auto____0 = (function (){
var statearr_57923 = [null,null,null,null,null,null,null];
(statearr_57923[(0)] = cljs$core$async$transduce_$_state_machine__31991__auto__);

(statearr_57923[(1)] = (1));

return statearr_57923;
});
var cljs$core$async$transduce_$_state_machine__31991__auto____1 = (function (state_57915){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_57915);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e57924){if((e57924 instanceof Object)){
var ex__31994__auto__ = e57924;
var statearr_57925_57927 = state_57915;
(statearr_57925_57927[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_57915);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57924;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57928 = state_57915;
state_57915 = G__57928;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__31991__auto__ = function(state_57915){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__31991__auto____1.call(this,state_57915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__31991__auto____0;
cljs$core$async$transduce_$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__31991__auto____1;
return cljs$core$async$transduce_$_state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto__,f__$1))
})();
var state__32224__auto__ = (function (){var statearr_57926 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_57926[(6)] = c__32222__auto__);

return statearr_57926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto__,f__$1))
);

return c__32222__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__57930 = arguments.length;
switch (G__57930) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__32222__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto__){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto__){
return (function (state_57955){
var state_val_57956 = (state_57955[(1)]);
if((state_val_57956 === (7))){
var inst_57937 = (state_57955[(2)]);
var state_57955__$1 = state_57955;
var statearr_57958_57990 = state_57955__$1;
(statearr_57958_57990[(2)] = inst_57937);

(statearr_57958_57990[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57956 === (1))){
var inst_57931 = cljs.core.seq(coll);
var inst_57932 = inst_57931;
var state_57955__$1 = (function (){var statearr_57960 = state_57955;
(statearr_57960[(7)] = inst_57932);

return statearr_57960;
})();
var statearr_57961_57993 = state_57955__$1;
(statearr_57961_57993[(2)] = null);

(statearr_57961_57993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57956 === (4))){
var inst_57932 = (state_57955[(7)]);
var inst_57935 = cljs.core.first(inst_57932);
var state_57955__$1 = state_57955;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_57955__$1,(7),ch,inst_57935);
} else {
if((state_val_57956 === (13))){
var inst_57949 = (state_57955[(2)]);
var state_57955__$1 = state_57955;
var statearr_57962_57997 = state_57955__$1;
(statearr_57962_57997[(2)] = inst_57949);

(statearr_57962_57997[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57956 === (6))){
var inst_57940 = (state_57955[(2)]);
var state_57955__$1 = state_57955;
if(cljs.core.truth_(inst_57940)){
var statearr_57963_57998 = state_57955__$1;
(statearr_57963_57998[(1)] = (8));

} else {
var statearr_57964_57999 = state_57955__$1;
(statearr_57964_57999[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57956 === (3))){
var inst_57953 = (state_57955[(2)]);
var state_57955__$1 = state_57955;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57955__$1,inst_57953);
} else {
if((state_val_57956 === (12))){
var state_57955__$1 = state_57955;
var statearr_57967_58000 = state_57955__$1;
(statearr_57967_58000[(2)] = null);

(statearr_57967_58000[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57956 === (2))){
var inst_57932 = (state_57955[(7)]);
var state_57955__$1 = state_57955;
if(cljs.core.truth_(inst_57932)){
var statearr_57968_58001 = state_57955__$1;
(statearr_57968_58001[(1)] = (4));

} else {
var statearr_57969_58002 = state_57955__$1;
(statearr_57969_58002[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57956 === (11))){
var inst_57946 = cljs.core.async.close_BANG_(ch);
var state_57955__$1 = state_57955;
var statearr_57970_58003 = state_57955__$1;
(statearr_57970_58003[(2)] = inst_57946);

(statearr_57970_58003[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57956 === (9))){
var state_57955__$1 = state_57955;
if(cljs.core.truth_(close_QMARK_)){
var statearr_57972_58004 = state_57955__$1;
(statearr_57972_58004[(1)] = (11));

} else {
var statearr_57973_58005 = state_57955__$1;
(statearr_57973_58005[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57956 === (5))){
var inst_57932 = (state_57955[(7)]);
var state_57955__$1 = state_57955;
var statearr_57974_58010 = state_57955__$1;
(statearr_57974_58010[(2)] = inst_57932);

(statearr_57974_58010[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57956 === (10))){
var inst_57951 = (state_57955[(2)]);
var state_57955__$1 = state_57955;
var statearr_57975_58011 = state_57955__$1;
(statearr_57975_58011[(2)] = inst_57951);

(statearr_57975_58011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57956 === (8))){
var inst_57932 = (state_57955[(7)]);
var inst_57942 = cljs.core.next(inst_57932);
var inst_57932__$1 = inst_57942;
var state_57955__$1 = (function (){var statearr_57977 = state_57955;
(statearr_57977[(7)] = inst_57932__$1);

return statearr_57977;
})();
var statearr_57978_58012 = state_57955__$1;
(statearr_57978_58012[(2)] = null);

(statearr_57978_58012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto__))
;
return ((function (switch__31990__auto__,c__32222__auto__){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_57979 = [null,null,null,null,null,null,null,null];
(statearr_57979[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_57979[(1)] = (1));

return statearr_57979;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_57955){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_57955);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e57980){if((e57980 instanceof Object)){
var ex__31994__auto__ = e57980;
var statearr_57981_58014 = state_57955;
(statearr_57981_58014[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_57955);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57980;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58015 = state_57955;
state_57955 = G__58015;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_57955){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_57955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto__))
})();
var state__32224__auto__ = (function (){var statearr_57982 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_57982[(6)] = c__32222__auto__);

return statearr_57982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto__))
);

return c__32222__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4244__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4244__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4244__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto__.call(null,m));
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async58026 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async58026 = (function (ch,cs,meta58027){
this.ch = ch;
this.cs = cs;
this.meta58027 = meta58027;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async58026.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_58028,meta58027__$1){
var self__ = this;
var _58028__$1 = this;
return (new cljs.core.async.t_cljs$core$async58026(self__.ch,self__.cs,meta58027__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async58026.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_58028){
var self__ = this;
var _58028__$1 = this;
return self__.meta58027;
});})(cs))
;

cljs.core.async.t_cljs$core$async58026.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async58026.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async58026.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async58026.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async58026.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async58026.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async58026.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta58027","meta58027",535626234,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async58026.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async58026.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async58026";

cljs.core.async.t_cljs$core$async58026.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async58026");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async58026.
 */
cljs.core.async.__GT_t_cljs$core$async58026 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async58026(ch__$1,cs__$1,meta58027){
return (new cljs.core.async.t_cljs$core$async58026(ch__$1,cs__$1,meta58027));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async58026(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__32222__auto___58297 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___58297,cs,m,dchan,dctr,done){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___58297,cs,m,dchan,dctr,done){
return (function (state_58171){
var state_val_58172 = (state_58171[(1)]);
if((state_val_58172 === (7))){
var inst_58167 = (state_58171[(2)]);
var state_58171__$1 = state_58171;
var statearr_58173_58298 = state_58171__$1;
(statearr_58173_58298[(2)] = inst_58167);

(statearr_58173_58298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (20))){
var inst_58070 = (state_58171[(7)]);
var inst_58082 = cljs.core.first(inst_58070);
var inst_58083 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_58082,(0),null);
var inst_58084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_58082,(1),null);
var state_58171__$1 = (function (){var statearr_58174 = state_58171;
(statearr_58174[(8)] = inst_58083);

return statearr_58174;
})();
if(cljs.core.truth_(inst_58084)){
var statearr_58175_58301 = state_58171__$1;
(statearr_58175_58301[(1)] = (22));

} else {
var statearr_58176_58302 = state_58171__$1;
(statearr_58176_58302[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (27))){
var inst_58114 = (state_58171[(9)]);
var inst_58112 = (state_58171[(10)]);
var inst_58038 = (state_58171[(11)]);
var inst_58119 = (state_58171[(12)]);
var inst_58119__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_58112,inst_58114);
var inst_58120 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_58119__$1,inst_58038,done);
var state_58171__$1 = (function (){var statearr_58177 = state_58171;
(statearr_58177[(12)] = inst_58119__$1);

return statearr_58177;
})();
if(cljs.core.truth_(inst_58120)){
var statearr_58178_58303 = state_58171__$1;
(statearr_58178_58303[(1)] = (30));

} else {
var statearr_58179_58304 = state_58171__$1;
(statearr_58179_58304[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (1))){
var state_58171__$1 = state_58171;
var statearr_58180_58305 = state_58171__$1;
(statearr_58180_58305[(2)] = null);

(statearr_58180_58305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (24))){
var inst_58070 = (state_58171[(7)]);
var inst_58089 = (state_58171[(2)]);
var inst_58090 = cljs.core.next(inst_58070);
var inst_58047 = inst_58090;
var inst_58048 = null;
var inst_58049 = (0);
var inst_58050 = (0);
var state_58171__$1 = (function (){var statearr_58181 = state_58171;
(statearr_58181[(13)] = inst_58089);

(statearr_58181[(14)] = inst_58047);

(statearr_58181[(15)] = inst_58050);

(statearr_58181[(16)] = inst_58048);

(statearr_58181[(17)] = inst_58049);

return statearr_58181;
})();
var statearr_58182_58306 = state_58171__$1;
(statearr_58182_58306[(2)] = null);

(statearr_58182_58306[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (39))){
var state_58171__$1 = state_58171;
var statearr_58186_58307 = state_58171__$1;
(statearr_58186_58307[(2)] = null);

(statearr_58186_58307[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (4))){
var inst_58038 = (state_58171[(11)]);
var inst_58038__$1 = (state_58171[(2)]);
var inst_58039 = (inst_58038__$1 == null);
var state_58171__$1 = (function (){var statearr_58194 = state_58171;
(statearr_58194[(11)] = inst_58038__$1);

return statearr_58194;
})();
if(cljs.core.truth_(inst_58039)){
var statearr_58195_58308 = state_58171__$1;
(statearr_58195_58308[(1)] = (5));

} else {
var statearr_58196_58309 = state_58171__$1;
(statearr_58196_58309[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (15))){
var inst_58047 = (state_58171[(14)]);
var inst_58050 = (state_58171[(15)]);
var inst_58048 = (state_58171[(16)]);
var inst_58049 = (state_58171[(17)]);
var inst_58066 = (state_58171[(2)]);
var inst_58067 = (inst_58050 + (1));
var tmp58183 = inst_58047;
var tmp58184 = inst_58048;
var tmp58185 = inst_58049;
var inst_58047__$1 = tmp58183;
var inst_58048__$1 = tmp58184;
var inst_58049__$1 = tmp58185;
var inst_58050__$1 = inst_58067;
var state_58171__$1 = (function (){var statearr_58197 = state_58171;
(statearr_58197[(14)] = inst_58047__$1);

(statearr_58197[(15)] = inst_58050__$1);

(statearr_58197[(16)] = inst_58048__$1);

(statearr_58197[(17)] = inst_58049__$1);

(statearr_58197[(18)] = inst_58066);

return statearr_58197;
})();
var statearr_58198_58310 = state_58171__$1;
(statearr_58198_58310[(2)] = null);

(statearr_58198_58310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (21))){
var inst_58093 = (state_58171[(2)]);
var state_58171__$1 = state_58171;
var statearr_58202_58311 = state_58171__$1;
(statearr_58202_58311[(2)] = inst_58093);

(statearr_58202_58311[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (31))){
var inst_58119 = (state_58171[(12)]);
var inst_58123 = done(null);
var inst_58124 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_58119);
var state_58171__$1 = (function (){var statearr_58203 = state_58171;
(statearr_58203[(19)] = inst_58123);

return statearr_58203;
})();
var statearr_58204_58312 = state_58171__$1;
(statearr_58204_58312[(2)] = inst_58124);

(statearr_58204_58312[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (32))){
var inst_58111 = (state_58171[(20)]);
var inst_58114 = (state_58171[(9)]);
var inst_58112 = (state_58171[(10)]);
var inst_58113 = (state_58171[(21)]);
var inst_58126 = (state_58171[(2)]);
var inst_58127 = (inst_58114 + (1));
var tmp58199 = inst_58111;
var tmp58200 = inst_58112;
var tmp58201 = inst_58113;
var inst_58111__$1 = tmp58199;
var inst_58112__$1 = tmp58200;
var inst_58113__$1 = tmp58201;
var inst_58114__$1 = inst_58127;
var state_58171__$1 = (function (){var statearr_58205 = state_58171;
(statearr_58205[(20)] = inst_58111__$1);

(statearr_58205[(22)] = inst_58126);

(statearr_58205[(9)] = inst_58114__$1);

(statearr_58205[(10)] = inst_58112__$1);

(statearr_58205[(21)] = inst_58113__$1);

return statearr_58205;
})();
var statearr_58212_58313 = state_58171__$1;
(statearr_58212_58313[(2)] = null);

(statearr_58212_58313[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (40))){
var inst_58139 = (state_58171[(23)]);
var inst_58143 = done(null);
var inst_58144 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_58139);
var state_58171__$1 = (function (){var statearr_58214 = state_58171;
(statearr_58214[(24)] = inst_58143);

return statearr_58214;
})();
var statearr_58221_58320 = state_58171__$1;
(statearr_58221_58320[(2)] = inst_58144);

(statearr_58221_58320[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (33))){
var inst_58130 = (state_58171[(25)]);
var inst_58132 = cljs.core.chunked_seq_QMARK_(inst_58130);
var state_58171__$1 = state_58171;
if(inst_58132){
var statearr_58222_58326 = state_58171__$1;
(statearr_58222_58326[(1)] = (36));

} else {
var statearr_58223_58327 = state_58171__$1;
(statearr_58223_58327[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (13))){
var inst_58060 = (state_58171[(26)]);
var inst_58063 = cljs.core.async.close_BANG_(inst_58060);
var state_58171__$1 = state_58171;
var statearr_58224_58328 = state_58171__$1;
(statearr_58224_58328[(2)] = inst_58063);

(statearr_58224_58328[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (22))){
var inst_58083 = (state_58171[(8)]);
var inst_58086 = cljs.core.async.close_BANG_(inst_58083);
var state_58171__$1 = state_58171;
var statearr_58225_58329 = state_58171__$1;
(statearr_58225_58329[(2)] = inst_58086);

(statearr_58225_58329[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (36))){
var inst_58130 = (state_58171[(25)]);
var inst_58134 = cljs.core.chunk_first(inst_58130);
var inst_58135 = cljs.core.chunk_rest(inst_58130);
var inst_58136 = cljs.core.count(inst_58134);
var inst_58111 = inst_58135;
var inst_58112 = inst_58134;
var inst_58113 = inst_58136;
var inst_58114 = (0);
var state_58171__$1 = (function (){var statearr_58226 = state_58171;
(statearr_58226[(20)] = inst_58111);

(statearr_58226[(9)] = inst_58114);

(statearr_58226[(10)] = inst_58112);

(statearr_58226[(21)] = inst_58113);

return statearr_58226;
})();
var statearr_58227_58330 = state_58171__$1;
(statearr_58227_58330[(2)] = null);

(statearr_58227_58330[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (41))){
var inst_58130 = (state_58171[(25)]);
var inst_58146 = (state_58171[(2)]);
var inst_58147 = cljs.core.next(inst_58130);
var inst_58111 = inst_58147;
var inst_58112 = null;
var inst_58113 = (0);
var inst_58114 = (0);
var state_58171__$1 = (function (){var statearr_58228 = state_58171;
(statearr_58228[(20)] = inst_58111);

(statearr_58228[(9)] = inst_58114);

(statearr_58228[(10)] = inst_58112);

(statearr_58228[(27)] = inst_58146);

(statearr_58228[(21)] = inst_58113);

return statearr_58228;
})();
var statearr_58229_58331 = state_58171__$1;
(statearr_58229_58331[(2)] = null);

(statearr_58229_58331[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (43))){
var state_58171__$1 = state_58171;
var statearr_58230_58332 = state_58171__$1;
(statearr_58230_58332[(2)] = null);

(statearr_58230_58332[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (29))){
var inst_58155 = (state_58171[(2)]);
var state_58171__$1 = state_58171;
var statearr_58231_58333 = state_58171__$1;
(statearr_58231_58333[(2)] = inst_58155);

(statearr_58231_58333[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (44))){
var inst_58164 = (state_58171[(2)]);
var state_58171__$1 = (function (){var statearr_58232 = state_58171;
(statearr_58232[(28)] = inst_58164);

return statearr_58232;
})();
var statearr_58233_58334 = state_58171__$1;
(statearr_58233_58334[(2)] = null);

(statearr_58233_58334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (6))){
var inst_58103 = (state_58171[(29)]);
var inst_58102 = cljs.core.deref(cs);
var inst_58103__$1 = cljs.core.keys(inst_58102);
var inst_58104 = cljs.core.count(inst_58103__$1);
var inst_58105 = cljs.core.reset_BANG_(dctr,inst_58104);
var inst_58110 = cljs.core.seq(inst_58103__$1);
var inst_58111 = inst_58110;
var inst_58112 = null;
var inst_58113 = (0);
var inst_58114 = (0);
var state_58171__$1 = (function (){var statearr_58235 = state_58171;
(statearr_58235[(20)] = inst_58111);

(statearr_58235[(30)] = inst_58105);

(statearr_58235[(9)] = inst_58114);

(statearr_58235[(10)] = inst_58112);

(statearr_58235[(21)] = inst_58113);

(statearr_58235[(29)] = inst_58103__$1);

return statearr_58235;
})();
var statearr_58236_58335 = state_58171__$1;
(statearr_58236_58335[(2)] = null);

(statearr_58236_58335[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (28))){
var inst_58111 = (state_58171[(20)]);
var inst_58130 = (state_58171[(25)]);
var inst_58130__$1 = cljs.core.seq(inst_58111);
var state_58171__$1 = (function (){var statearr_58240 = state_58171;
(statearr_58240[(25)] = inst_58130__$1);

return statearr_58240;
})();
if(inst_58130__$1){
var statearr_58241_58336 = state_58171__$1;
(statearr_58241_58336[(1)] = (33));

} else {
var statearr_58242_58337 = state_58171__$1;
(statearr_58242_58337[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (25))){
var inst_58114 = (state_58171[(9)]);
var inst_58113 = (state_58171[(21)]);
var inst_58116 = (inst_58114 < inst_58113);
var inst_58117 = inst_58116;
var state_58171__$1 = state_58171;
if(cljs.core.truth_(inst_58117)){
var statearr_58243_58338 = state_58171__$1;
(statearr_58243_58338[(1)] = (27));

} else {
var statearr_58244_58341 = state_58171__$1;
(statearr_58244_58341[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (34))){
var state_58171__$1 = state_58171;
var statearr_58245_58342 = state_58171__$1;
(statearr_58245_58342[(2)] = null);

(statearr_58245_58342[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (17))){
var state_58171__$1 = state_58171;
var statearr_58246_58343 = state_58171__$1;
(statearr_58246_58343[(2)] = null);

(statearr_58246_58343[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (3))){
var inst_58169 = (state_58171[(2)]);
var state_58171__$1 = state_58171;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58171__$1,inst_58169);
} else {
if((state_val_58172 === (12))){
var inst_58098 = (state_58171[(2)]);
var state_58171__$1 = state_58171;
var statearr_58251_58344 = state_58171__$1;
(statearr_58251_58344[(2)] = inst_58098);

(statearr_58251_58344[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (2))){
var state_58171__$1 = state_58171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58171__$1,(4),ch);
} else {
if((state_val_58172 === (23))){
var state_58171__$1 = state_58171;
var statearr_58252_58345 = state_58171__$1;
(statearr_58252_58345[(2)] = null);

(statearr_58252_58345[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (35))){
var inst_58153 = (state_58171[(2)]);
var state_58171__$1 = state_58171;
var statearr_58253_58348 = state_58171__$1;
(statearr_58253_58348[(2)] = inst_58153);

(statearr_58253_58348[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (19))){
var inst_58070 = (state_58171[(7)]);
var inst_58074 = cljs.core.chunk_first(inst_58070);
var inst_58075 = cljs.core.chunk_rest(inst_58070);
var inst_58076 = cljs.core.count(inst_58074);
var inst_58047 = inst_58075;
var inst_58048 = inst_58074;
var inst_58049 = inst_58076;
var inst_58050 = (0);
var state_58171__$1 = (function (){var statearr_58257 = state_58171;
(statearr_58257[(14)] = inst_58047);

(statearr_58257[(15)] = inst_58050);

(statearr_58257[(16)] = inst_58048);

(statearr_58257[(17)] = inst_58049);

return statearr_58257;
})();
var statearr_58258_58349 = state_58171__$1;
(statearr_58258_58349[(2)] = null);

(statearr_58258_58349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (11))){
var inst_58047 = (state_58171[(14)]);
var inst_58070 = (state_58171[(7)]);
var inst_58070__$1 = cljs.core.seq(inst_58047);
var state_58171__$1 = (function (){var statearr_58259 = state_58171;
(statearr_58259[(7)] = inst_58070__$1);

return statearr_58259;
})();
if(inst_58070__$1){
var statearr_58260_58350 = state_58171__$1;
(statearr_58260_58350[(1)] = (16));

} else {
var statearr_58261_58351 = state_58171__$1;
(statearr_58261_58351[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (9))){
var inst_58100 = (state_58171[(2)]);
var state_58171__$1 = state_58171;
var statearr_58262_58352 = state_58171__$1;
(statearr_58262_58352[(2)] = inst_58100);

(statearr_58262_58352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (5))){
var inst_58045 = cljs.core.deref(cs);
var inst_58046 = cljs.core.seq(inst_58045);
var inst_58047 = inst_58046;
var inst_58048 = null;
var inst_58049 = (0);
var inst_58050 = (0);
var state_58171__$1 = (function (){var statearr_58263 = state_58171;
(statearr_58263[(14)] = inst_58047);

(statearr_58263[(15)] = inst_58050);

(statearr_58263[(16)] = inst_58048);

(statearr_58263[(17)] = inst_58049);

return statearr_58263;
})();
var statearr_58264_58353 = state_58171__$1;
(statearr_58264_58353[(2)] = null);

(statearr_58264_58353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (14))){
var state_58171__$1 = state_58171;
var statearr_58267_58354 = state_58171__$1;
(statearr_58267_58354[(2)] = null);

(statearr_58267_58354[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (45))){
var inst_58161 = (state_58171[(2)]);
var state_58171__$1 = state_58171;
var statearr_58268_58356 = state_58171__$1;
(statearr_58268_58356[(2)] = inst_58161);

(statearr_58268_58356[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (26))){
var inst_58103 = (state_58171[(29)]);
var inst_58157 = (state_58171[(2)]);
var inst_58158 = cljs.core.seq(inst_58103);
var state_58171__$1 = (function (){var statearr_58269 = state_58171;
(statearr_58269[(31)] = inst_58157);

return statearr_58269;
})();
if(inst_58158){
var statearr_58270_58359 = state_58171__$1;
(statearr_58270_58359[(1)] = (42));

} else {
var statearr_58271_58360 = state_58171__$1;
(statearr_58271_58360[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (16))){
var inst_58070 = (state_58171[(7)]);
var inst_58072 = cljs.core.chunked_seq_QMARK_(inst_58070);
var state_58171__$1 = state_58171;
if(inst_58072){
var statearr_58273_58361 = state_58171__$1;
(statearr_58273_58361[(1)] = (19));

} else {
var statearr_58274_58362 = state_58171__$1;
(statearr_58274_58362[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (38))){
var inst_58150 = (state_58171[(2)]);
var state_58171__$1 = state_58171;
var statearr_58275_58363 = state_58171__$1;
(statearr_58275_58363[(2)] = inst_58150);

(statearr_58275_58363[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (30))){
var state_58171__$1 = state_58171;
var statearr_58276_58364 = state_58171__$1;
(statearr_58276_58364[(2)] = null);

(statearr_58276_58364[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (10))){
var inst_58050 = (state_58171[(15)]);
var inst_58048 = (state_58171[(16)]);
var inst_58059 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_58048,inst_58050);
var inst_58060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_58059,(0),null);
var inst_58061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_58059,(1),null);
var state_58171__$1 = (function (){var statearr_58277 = state_58171;
(statearr_58277[(26)] = inst_58060);

return statearr_58277;
})();
if(cljs.core.truth_(inst_58061)){
var statearr_58278_58365 = state_58171__$1;
(statearr_58278_58365[(1)] = (13));

} else {
var statearr_58279_58366 = state_58171__$1;
(statearr_58279_58366[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (18))){
var inst_58096 = (state_58171[(2)]);
var state_58171__$1 = state_58171;
var statearr_58280_58367 = state_58171__$1;
(statearr_58280_58367[(2)] = inst_58096);

(statearr_58280_58367[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (42))){
var state_58171__$1 = state_58171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58171__$1,(45),dchan);
} else {
if((state_val_58172 === (37))){
var inst_58139 = (state_58171[(23)]);
var inst_58038 = (state_58171[(11)]);
var inst_58130 = (state_58171[(25)]);
var inst_58139__$1 = cljs.core.first(inst_58130);
var inst_58140 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_58139__$1,inst_58038,done);
var state_58171__$1 = (function (){var statearr_58281 = state_58171;
(statearr_58281[(23)] = inst_58139__$1);

return statearr_58281;
})();
if(cljs.core.truth_(inst_58140)){
var statearr_58282_58368 = state_58171__$1;
(statearr_58282_58368[(1)] = (39));

} else {
var statearr_58283_58369 = state_58171__$1;
(statearr_58283_58369[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58172 === (8))){
var inst_58050 = (state_58171[(15)]);
var inst_58049 = (state_58171[(17)]);
var inst_58053 = (inst_58050 < inst_58049);
var inst_58054 = inst_58053;
var state_58171__$1 = state_58171;
if(cljs.core.truth_(inst_58054)){
var statearr_58284_58370 = state_58171__$1;
(statearr_58284_58370[(1)] = (10));

} else {
var statearr_58285_58371 = state_58171__$1;
(statearr_58285_58371[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___58297,cs,m,dchan,dctr,done))
;
return ((function (switch__31990__auto__,c__32222__auto___58297,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__31991__auto__ = null;
var cljs$core$async$mult_$_state_machine__31991__auto____0 = (function (){
var statearr_58286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58286[(0)] = cljs$core$async$mult_$_state_machine__31991__auto__);

(statearr_58286[(1)] = (1));

return statearr_58286;
});
var cljs$core$async$mult_$_state_machine__31991__auto____1 = (function (state_58171){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_58171);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e58287){if((e58287 instanceof Object)){
var ex__31994__auto__ = e58287;
var statearr_58288_58372 = state_58171;
(statearr_58288_58372[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_58171);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58287;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58373 = state_58171;
state_58171 = G__58373;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__31991__auto__ = function(state_58171){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__31991__auto____1.call(this,state_58171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__31991__auto____0;
cljs$core$async$mult_$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__31991__auto____1;
return cljs$core$async$mult_$_state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___58297,cs,m,dchan,dctr,done))
})();
var state__32224__auto__ = (function (){var statearr_58289 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_58289[(6)] = c__32222__auto___58297);

return statearr_58289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___58297,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__58375 = arguments.length;
switch (G__58375) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto__.call(null,m));
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4244__auto__.call(null,m,state_map));
} else {
var m__4244__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4244__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4244__auto__.call(null,m,mode));
} else {
var m__4244__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4244__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___58398 = arguments.length;
var i__4532__auto___58399 = (0);
while(true){
if((i__4532__auto___58399 < len__4531__auto___58398)){
args__4534__auto__.push((arguments[i__4532__auto___58399]));

var G__58400 = (i__4532__auto___58399 + (1));
i__4532__auto___58399 = G__58400;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__58390){
var map__58391 = p__58390;
var map__58391__$1 = ((((!((map__58391 == null)))?(((((map__58391.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58391.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__58391):map__58391);
var opts = map__58391__$1;
var statearr_58393_58402 = state;
(statearr_58393_58402[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__58391,map__58391__$1,opts){
return (function (val){
var statearr_58395_58403 = state;
(statearr_58395_58403[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__58391,map__58391__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_58396_58404 = state;
(statearr_58396_58404[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq58385){
var G__58386 = cljs.core.first(seq58385);
var seq58385__$1 = cljs.core.next(seq58385);
var G__58387 = cljs.core.first(seq58385__$1);
var seq58385__$2 = cljs.core.next(seq58385__$1);
var G__58388 = cljs.core.first(seq58385__$2);
var seq58385__$3 = cljs.core.next(seq58385__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__58386,G__58387,G__58388,seq58385__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_(solos)))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async58408 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async58408 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta58409){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta58409 = meta58409;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async58408.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_58410,meta58409__$1){
var self__ = this;
var _58410__$1 = this;
return (new cljs.core.async.t_cljs$core$async58408(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta58409__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58408.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_58410){
var self__ = this;
var _58410__$1 = this;
return self__.meta58409;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58408.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async58408.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58408.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async58408.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58408.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58408.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58408.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58408.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58408.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta58409","meta58409",1988686827,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async58408.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async58408.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async58408";

cljs.core.async.t_cljs$core$async58408.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async58408");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async58408.
 */
cljs.core.async.__GT_t_cljs$core$async58408 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async58408(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta58409){
return (new cljs.core.async.t_cljs$core$async58408(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta58409));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async58408(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__32222__auto___58590 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___58590,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___58590,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_58512){
var state_val_58513 = (state_58512[(1)]);
if((state_val_58513 === (7))){
var inst_58427 = (state_58512[(2)]);
var state_58512__$1 = state_58512;
var statearr_58514_58593 = state_58512__$1;
(statearr_58514_58593[(2)] = inst_58427);

(statearr_58514_58593[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (20))){
var inst_58439 = (state_58512[(7)]);
var state_58512__$1 = state_58512;
var statearr_58515_58594 = state_58512__$1;
(statearr_58515_58594[(2)] = inst_58439);

(statearr_58515_58594[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (27))){
var state_58512__$1 = state_58512;
var statearr_58517_58595 = state_58512__$1;
(statearr_58517_58595[(2)] = null);

(statearr_58517_58595[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (1))){
var inst_58414 = (state_58512[(8)]);
var inst_58414__$1 = calc_state();
var inst_58416 = (inst_58414__$1 == null);
var inst_58417 = cljs.core.not(inst_58416);
var state_58512__$1 = (function (){var statearr_58519 = state_58512;
(statearr_58519[(8)] = inst_58414__$1);

return statearr_58519;
})();
if(inst_58417){
var statearr_58520_58596 = state_58512__$1;
(statearr_58520_58596[(1)] = (2));

} else {
var statearr_58521_58597 = state_58512__$1;
(statearr_58521_58597[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (24))){
var inst_58486 = (state_58512[(9)]);
var inst_58463 = (state_58512[(10)]);
var inst_58472 = (state_58512[(11)]);
var inst_58486__$1 = (inst_58463.cljs$core$IFn$_invoke$arity$1 ? inst_58463.cljs$core$IFn$_invoke$arity$1(inst_58472) : inst_58463.call(null,inst_58472));
var state_58512__$1 = (function (){var statearr_58522 = state_58512;
(statearr_58522[(9)] = inst_58486__$1);

return statearr_58522;
})();
if(cljs.core.truth_(inst_58486__$1)){
var statearr_58523_58598 = state_58512__$1;
(statearr_58523_58598[(1)] = (29));

} else {
var statearr_58524_58599 = state_58512__$1;
(statearr_58524_58599[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (4))){
var inst_58430 = (state_58512[(2)]);
var state_58512__$1 = state_58512;
if(cljs.core.truth_(inst_58430)){
var statearr_58525_58601 = state_58512__$1;
(statearr_58525_58601[(1)] = (8));

} else {
var statearr_58526_58602 = state_58512__$1;
(statearr_58526_58602[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (15))){
var inst_58457 = (state_58512[(2)]);
var state_58512__$1 = state_58512;
if(cljs.core.truth_(inst_58457)){
var statearr_58527_58604 = state_58512__$1;
(statearr_58527_58604[(1)] = (19));

} else {
var statearr_58529_58605 = state_58512__$1;
(statearr_58529_58605[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (21))){
var inst_58462 = (state_58512[(12)]);
var inst_58462__$1 = (state_58512[(2)]);
var inst_58463 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58462__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_58464 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58462__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_58465 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58462__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_58512__$1 = (function (){var statearr_58530 = state_58512;
(statearr_58530[(10)] = inst_58463);

(statearr_58530[(12)] = inst_58462__$1);

(statearr_58530[(13)] = inst_58464);

return statearr_58530;
})();
return cljs.core.async.ioc_alts_BANG_(state_58512__$1,(22),inst_58465);
} else {
if((state_val_58513 === (31))){
var inst_58494 = (state_58512[(2)]);
var state_58512__$1 = state_58512;
if(cljs.core.truth_(inst_58494)){
var statearr_58531_58606 = state_58512__$1;
(statearr_58531_58606[(1)] = (32));

} else {
var statearr_58532_58607 = state_58512__$1;
(statearr_58532_58607[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (32))){
var inst_58471 = (state_58512[(14)]);
var state_58512__$1 = state_58512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_58512__$1,(35),out,inst_58471);
} else {
if((state_val_58513 === (33))){
var inst_58462 = (state_58512[(12)]);
var inst_58439 = inst_58462;
var state_58512__$1 = (function (){var statearr_58534 = state_58512;
(statearr_58534[(7)] = inst_58439);

return statearr_58534;
})();
var statearr_58535_58608 = state_58512__$1;
(statearr_58535_58608[(2)] = null);

(statearr_58535_58608[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (13))){
var inst_58439 = (state_58512[(7)]);
var inst_58446 = inst_58439.cljs$lang$protocol_mask$partition0$;
var inst_58447 = (inst_58446 & (64));
var inst_58448 = inst_58439.cljs$core$ISeq$;
var inst_58449 = (cljs.core.PROTOCOL_SENTINEL === inst_58448);
var inst_58450 = ((inst_58447) || (inst_58449));
var state_58512__$1 = state_58512;
if(cljs.core.truth_(inst_58450)){
var statearr_58536_58611 = state_58512__$1;
(statearr_58536_58611[(1)] = (16));

} else {
var statearr_58537_58612 = state_58512__$1;
(statearr_58537_58612[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (22))){
var inst_58471 = (state_58512[(14)]);
var inst_58472 = (state_58512[(11)]);
var inst_58470 = (state_58512[(2)]);
var inst_58471__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_58470,(0),null);
var inst_58472__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_58470,(1),null);
var inst_58473 = (inst_58471__$1 == null);
var inst_58474 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_58472__$1,change);
var inst_58475 = ((inst_58473) || (inst_58474));
var state_58512__$1 = (function (){var statearr_58538 = state_58512;
(statearr_58538[(14)] = inst_58471__$1);

(statearr_58538[(11)] = inst_58472__$1);

return statearr_58538;
})();
if(cljs.core.truth_(inst_58475)){
var statearr_58539_58613 = state_58512__$1;
(statearr_58539_58613[(1)] = (23));

} else {
var statearr_58540_58614 = state_58512__$1;
(statearr_58540_58614[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (36))){
var inst_58462 = (state_58512[(12)]);
var inst_58439 = inst_58462;
var state_58512__$1 = (function (){var statearr_58541 = state_58512;
(statearr_58541[(7)] = inst_58439);

return statearr_58541;
})();
var statearr_58542_58619 = state_58512__$1;
(statearr_58542_58619[(2)] = null);

(statearr_58542_58619[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (29))){
var inst_58486 = (state_58512[(9)]);
var state_58512__$1 = state_58512;
var statearr_58543_58620 = state_58512__$1;
(statearr_58543_58620[(2)] = inst_58486);

(statearr_58543_58620[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (6))){
var state_58512__$1 = state_58512;
var statearr_58544_58621 = state_58512__$1;
(statearr_58544_58621[(2)] = false);

(statearr_58544_58621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (28))){
var inst_58482 = (state_58512[(2)]);
var inst_58483 = calc_state();
var inst_58439 = inst_58483;
var state_58512__$1 = (function (){var statearr_58545 = state_58512;
(statearr_58545[(7)] = inst_58439);

(statearr_58545[(15)] = inst_58482);

return statearr_58545;
})();
var statearr_58546_58622 = state_58512__$1;
(statearr_58546_58622[(2)] = null);

(statearr_58546_58622[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (25))){
var inst_58508 = (state_58512[(2)]);
var state_58512__$1 = state_58512;
var statearr_58547_58623 = state_58512__$1;
(statearr_58547_58623[(2)] = inst_58508);

(statearr_58547_58623[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (34))){
var inst_58506 = (state_58512[(2)]);
var state_58512__$1 = state_58512;
var statearr_58548_58624 = state_58512__$1;
(statearr_58548_58624[(2)] = inst_58506);

(statearr_58548_58624[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (17))){
var state_58512__$1 = state_58512;
var statearr_58549_58625 = state_58512__$1;
(statearr_58549_58625[(2)] = false);

(statearr_58549_58625[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (3))){
var state_58512__$1 = state_58512;
var statearr_58550_58626 = state_58512__$1;
(statearr_58550_58626[(2)] = false);

(statearr_58550_58626[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (12))){
var inst_58510 = (state_58512[(2)]);
var state_58512__$1 = state_58512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58512__$1,inst_58510);
} else {
if((state_val_58513 === (2))){
var inst_58414 = (state_58512[(8)]);
var inst_58419 = inst_58414.cljs$lang$protocol_mask$partition0$;
var inst_58420 = (inst_58419 & (64));
var inst_58421 = inst_58414.cljs$core$ISeq$;
var inst_58422 = (cljs.core.PROTOCOL_SENTINEL === inst_58421);
var inst_58423 = ((inst_58420) || (inst_58422));
var state_58512__$1 = state_58512;
if(cljs.core.truth_(inst_58423)){
var statearr_58553_58627 = state_58512__$1;
(statearr_58553_58627[(1)] = (5));

} else {
var statearr_58554_58628 = state_58512__$1;
(statearr_58554_58628[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (23))){
var inst_58471 = (state_58512[(14)]);
var inst_58477 = (inst_58471 == null);
var state_58512__$1 = state_58512;
if(cljs.core.truth_(inst_58477)){
var statearr_58558_58629 = state_58512__$1;
(statearr_58558_58629[(1)] = (26));

} else {
var statearr_58559_58630 = state_58512__$1;
(statearr_58559_58630[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (35))){
var inst_58497 = (state_58512[(2)]);
var state_58512__$1 = state_58512;
if(cljs.core.truth_(inst_58497)){
var statearr_58560_58631 = state_58512__$1;
(statearr_58560_58631[(1)] = (36));

} else {
var statearr_58562_58632 = state_58512__$1;
(statearr_58562_58632[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (19))){
var inst_58439 = (state_58512[(7)]);
var inst_58459 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_58439);
var state_58512__$1 = state_58512;
var statearr_58563_58635 = state_58512__$1;
(statearr_58563_58635[(2)] = inst_58459);

(statearr_58563_58635[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (11))){
var inst_58439 = (state_58512[(7)]);
var inst_58443 = (inst_58439 == null);
var inst_58444 = cljs.core.not(inst_58443);
var state_58512__$1 = state_58512;
if(inst_58444){
var statearr_58564_58636 = state_58512__$1;
(statearr_58564_58636[(1)] = (13));

} else {
var statearr_58565_58637 = state_58512__$1;
(statearr_58565_58637[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (9))){
var inst_58414 = (state_58512[(8)]);
var state_58512__$1 = state_58512;
var statearr_58566_58638 = state_58512__$1;
(statearr_58566_58638[(2)] = inst_58414);

(statearr_58566_58638[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (5))){
var state_58512__$1 = state_58512;
var statearr_58567_58639 = state_58512__$1;
(statearr_58567_58639[(2)] = true);

(statearr_58567_58639[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (14))){
var state_58512__$1 = state_58512;
var statearr_58570_58640 = state_58512__$1;
(statearr_58570_58640[(2)] = false);

(statearr_58570_58640[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (26))){
var inst_58472 = (state_58512[(11)]);
var inst_58479 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_58472);
var state_58512__$1 = state_58512;
var statearr_58571_58641 = state_58512__$1;
(statearr_58571_58641[(2)] = inst_58479);

(statearr_58571_58641[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (16))){
var state_58512__$1 = state_58512;
var statearr_58573_58642 = state_58512__$1;
(statearr_58573_58642[(2)] = true);

(statearr_58573_58642[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (38))){
var inst_58502 = (state_58512[(2)]);
var state_58512__$1 = state_58512;
var statearr_58574_58643 = state_58512__$1;
(statearr_58574_58643[(2)] = inst_58502);

(statearr_58574_58643[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (30))){
var inst_58463 = (state_58512[(10)]);
var inst_58472 = (state_58512[(11)]);
var inst_58464 = (state_58512[(13)]);
var inst_58489 = cljs.core.empty_QMARK_(inst_58463);
var inst_58490 = (inst_58464.cljs$core$IFn$_invoke$arity$1 ? inst_58464.cljs$core$IFn$_invoke$arity$1(inst_58472) : inst_58464.call(null,inst_58472));
var inst_58491 = cljs.core.not(inst_58490);
var inst_58492 = ((inst_58489) && (inst_58491));
var state_58512__$1 = state_58512;
var statearr_58577_58645 = state_58512__$1;
(statearr_58577_58645[(2)] = inst_58492);

(statearr_58577_58645[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (10))){
var inst_58414 = (state_58512[(8)]);
var inst_58435 = (state_58512[(2)]);
var inst_58436 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58435,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_58437 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58435,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_58438 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58435,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_58439 = inst_58414;
var state_58512__$1 = (function (){var statearr_58578 = state_58512;
(statearr_58578[(16)] = inst_58436);

(statearr_58578[(7)] = inst_58439);

(statearr_58578[(17)] = inst_58438);

(statearr_58578[(18)] = inst_58437);

return statearr_58578;
})();
var statearr_58579_58648 = state_58512__$1;
(statearr_58579_58648[(2)] = null);

(statearr_58579_58648[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (18))){
var inst_58454 = (state_58512[(2)]);
var state_58512__$1 = state_58512;
var statearr_58580_58649 = state_58512__$1;
(statearr_58580_58649[(2)] = inst_58454);

(statearr_58580_58649[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (37))){
var state_58512__$1 = state_58512;
var statearr_58581_58650 = state_58512__$1;
(statearr_58581_58650[(2)] = null);

(statearr_58581_58650[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58513 === (8))){
var inst_58414 = (state_58512[(8)]);
var inst_58432 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_58414);
var state_58512__$1 = state_58512;
var statearr_58584_58651 = state_58512__$1;
(statearr_58584_58651[(2)] = inst_58432);

(statearr_58584_58651[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___58590,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__31990__auto__,c__32222__auto___58590,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__31991__auto__ = null;
var cljs$core$async$mix_$_state_machine__31991__auto____0 = (function (){
var statearr_58586 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58586[(0)] = cljs$core$async$mix_$_state_machine__31991__auto__);

(statearr_58586[(1)] = (1));

return statearr_58586;
});
var cljs$core$async$mix_$_state_machine__31991__auto____1 = (function (state_58512){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_58512);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e58587){if((e58587 instanceof Object)){
var ex__31994__auto__ = e58587;
var statearr_58588_58654 = state_58512;
(statearr_58588_58654[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_58512);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58587;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58655 = state_58512;
state_58512 = G__58655;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__31991__auto__ = function(state_58512){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__31991__auto____1.call(this,state_58512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__31991__auto____0;
cljs$core$async$mix_$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__31991__auto____1;
return cljs$core$async$mix_$_state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___58590,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__32224__auto__ = (function (){var statearr_58589 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_58589[(6)] = c__32222__auto___58590);

return statearr_58589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___58590,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4244__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4244__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4244__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4244__auto__.call(null,p,v,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4244__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__58660 = arguments.length;
switch (G__58660) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4244__auto__.call(null,p));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__4244__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4244__auto__.call(null,p,v));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__4244__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__58674 = arguments.length;
switch (G__58674) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__3949__auto__,mults){
return (function (p1__58672_SHARP_){
if(cljs.core.truth_((p1__58672_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__58672_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__58672_SHARP_.call(null,topic)))){
return p1__58672_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__58672_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__3949__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async58675 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async58675 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta58676){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta58676 = meta58676;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async58675.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_58677,meta58676__$1){
var self__ = this;
var _58677__$1 = this;
return (new cljs.core.async.t_cljs$core$async58675(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta58676__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async58675.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_58677){
var self__ = this;
var _58677__$1 = this;
return self__.meta58676;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async58675.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async58675.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async58675.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async58675.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async58675.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async58675.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async58675.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async58675.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta58676","meta58676",-972414581,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async58675.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async58675.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async58675";

cljs.core.async.t_cljs$core$async58675.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async58675");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async58675.
 */
cljs.core.async.__GT_t_cljs$core$async58675 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async58675(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta58676){
return (new cljs.core.async.t_cljs$core$async58675(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta58676));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async58675(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__32222__auto___58813 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___58813,mults,ensure_mult,p){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___58813,mults,ensure_mult,p){
return (function (state_58755){
var state_val_58757 = (state_58755[(1)]);
if((state_val_58757 === (7))){
var inst_58751 = (state_58755[(2)]);
var state_58755__$1 = state_58755;
var statearr_58760_58814 = state_58755__$1;
(statearr_58760_58814[(2)] = inst_58751);

(statearr_58760_58814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (20))){
var state_58755__$1 = state_58755;
var statearr_58761_58816 = state_58755__$1;
(statearr_58761_58816[(2)] = null);

(statearr_58761_58816[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (1))){
var state_58755__$1 = state_58755;
var statearr_58762_58817 = state_58755__$1;
(statearr_58762_58817[(2)] = null);

(statearr_58762_58817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (24))){
var inst_58734 = (state_58755[(7)]);
var inst_58743 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_58734);
var state_58755__$1 = state_58755;
var statearr_58765_58818 = state_58755__$1;
(statearr_58765_58818[(2)] = inst_58743);

(statearr_58765_58818[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (4))){
var inst_58685 = (state_58755[(8)]);
var inst_58685__$1 = (state_58755[(2)]);
var inst_58686 = (inst_58685__$1 == null);
var state_58755__$1 = (function (){var statearr_58768 = state_58755;
(statearr_58768[(8)] = inst_58685__$1);

return statearr_58768;
})();
if(cljs.core.truth_(inst_58686)){
var statearr_58769_58819 = state_58755__$1;
(statearr_58769_58819[(1)] = (5));

} else {
var statearr_58770_58820 = state_58755__$1;
(statearr_58770_58820[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (15))){
var inst_58728 = (state_58755[(2)]);
var state_58755__$1 = state_58755;
var statearr_58771_58822 = state_58755__$1;
(statearr_58771_58822[(2)] = inst_58728);

(statearr_58771_58822[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (21))){
var inst_58748 = (state_58755[(2)]);
var state_58755__$1 = (function (){var statearr_58773 = state_58755;
(statearr_58773[(9)] = inst_58748);

return statearr_58773;
})();
var statearr_58774_58823 = state_58755__$1;
(statearr_58774_58823[(2)] = null);

(statearr_58774_58823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (13))){
var inst_58710 = (state_58755[(10)]);
var inst_58712 = cljs.core.chunked_seq_QMARK_(inst_58710);
var state_58755__$1 = state_58755;
if(inst_58712){
var statearr_58775_58825 = state_58755__$1;
(statearr_58775_58825[(1)] = (16));

} else {
var statearr_58776_58826 = state_58755__$1;
(statearr_58776_58826[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (22))){
var inst_58740 = (state_58755[(2)]);
var state_58755__$1 = state_58755;
if(cljs.core.truth_(inst_58740)){
var statearr_58777_58827 = state_58755__$1;
(statearr_58777_58827[(1)] = (23));

} else {
var statearr_58778_58828 = state_58755__$1;
(statearr_58778_58828[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (6))){
var inst_58734 = (state_58755[(7)]);
var inst_58736 = (state_58755[(11)]);
var inst_58685 = (state_58755[(8)]);
var inst_58734__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_58685) : topic_fn.call(null,inst_58685));
var inst_58735 = cljs.core.deref(mults);
var inst_58736__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58735,inst_58734__$1);
var state_58755__$1 = (function (){var statearr_58780 = state_58755;
(statearr_58780[(7)] = inst_58734__$1);

(statearr_58780[(11)] = inst_58736__$1);

return statearr_58780;
})();
if(cljs.core.truth_(inst_58736__$1)){
var statearr_58781_58831 = state_58755__$1;
(statearr_58781_58831[(1)] = (19));

} else {
var statearr_58782_58832 = state_58755__$1;
(statearr_58782_58832[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (25))){
var inst_58745 = (state_58755[(2)]);
var state_58755__$1 = state_58755;
var statearr_58783_58833 = state_58755__$1;
(statearr_58783_58833[(2)] = inst_58745);

(statearr_58783_58833[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (17))){
var inst_58710 = (state_58755[(10)]);
var inst_58719 = cljs.core.first(inst_58710);
var inst_58720 = cljs.core.async.muxch_STAR_(inst_58719);
var inst_58721 = cljs.core.async.close_BANG_(inst_58720);
var inst_58722 = cljs.core.next(inst_58710);
var inst_58695 = inst_58722;
var inst_58696 = null;
var inst_58697 = (0);
var inst_58698 = (0);
var state_58755__$1 = (function (){var statearr_58784 = state_58755;
(statearr_58784[(12)] = inst_58698);

(statearr_58784[(13)] = inst_58697);

(statearr_58784[(14)] = inst_58696);

(statearr_58784[(15)] = inst_58695);

(statearr_58784[(16)] = inst_58721);

return statearr_58784;
})();
var statearr_58785_58834 = state_58755__$1;
(statearr_58785_58834[(2)] = null);

(statearr_58785_58834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (3))){
var inst_58753 = (state_58755[(2)]);
var state_58755__$1 = state_58755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58755__$1,inst_58753);
} else {
if((state_val_58757 === (12))){
var inst_58730 = (state_58755[(2)]);
var state_58755__$1 = state_58755;
var statearr_58786_58835 = state_58755__$1;
(statearr_58786_58835[(2)] = inst_58730);

(statearr_58786_58835[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (2))){
var state_58755__$1 = state_58755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58755__$1,(4),ch);
} else {
if((state_val_58757 === (23))){
var state_58755__$1 = state_58755;
var statearr_58787_58836 = state_58755__$1;
(statearr_58787_58836[(2)] = null);

(statearr_58787_58836[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (19))){
var inst_58736 = (state_58755[(11)]);
var inst_58685 = (state_58755[(8)]);
var inst_58738 = cljs.core.async.muxch_STAR_(inst_58736);
var state_58755__$1 = state_58755;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_58755__$1,(22),inst_58738,inst_58685);
} else {
if((state_val_58757 === (11))){
var inst_58710 = (state_58755[(10)]);
var inst_58695 = (state_58755[(15)]);
var inst_58710__$1 = cljs.core.seq(inst_58695);
var state_58755__$1 = (function (){var statearr_58788 = state_58755;
(statearr_58788[(10)] = inst_58710__$1);

return statearr_58788;
})();
if(inst_58710__$1){
var statearr_58789_58837 = state_58755__$1;
(statearr_58789_58837[(1)] = (13));

} else {
var statearr_58790_58838 = state_58755__$1;
(statearr_58790_58838[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (9))){
var inst_58732 = (state_58755[(2)]);
var state_58755__$1 = state_58755;
var statearr_58791_58839 = state_58755__$1;
(statearr_58791_58839[(2)] = inst_58732);

(statearr_58791_58839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (5))){
var inst_58692 = cljs.core.deref(mults);
var inst_58693 = cljs.core.vals(inst_58692);
var inst_58694 = cljs.core.seq(inst_58693);
var inst_58695 = inst_58694;
var inst_58696 = null;
var inst_58697 = (0);
var inst_58698 = (0);
var state_58755__$1 = (function (){var statearr_58792 = state_58755;
(statearr_58792[(12)] = inst_58698);

(statearr_58792[(13)] = inst_58697);

(statearr_58792[(14)] = inst_58696);

(statearr_58792[(15)] = inst_58695);

return statearr_58792;
})();
var statearr_58793_58842 = state_58755__$1;
(statearr_58793_58842[(2)] = null);

(statearr_58793_58842[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (14))){
var state_58755__$1 = state_58755;
var statearr_58797_58843 = state_58755__$1;
(statearr_58797_58843[(2)] = null);

(statearr_58797_58843[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (16))){
var inst_58710 = (state_58755[(10)]);
var inst_58714 = cljs.core.chunk_first(inst_58710);
var inst_58715 = cljs.core.chunk_rest(inst_58710);
var inst_58716 = cljs.core.count(inst_58714);
var inst_58695 = inst_58715;
var inst_58696 = inst_58714;
var inst_58697 = inst_58716;
var inst_58698 = (0);
var state_58755__$1 = (function (){var statearr_58798 = state_58755;
(statearr_58798[(12)] = inst_58698);

(statearr_58798[(13)] = inst_58697);

(statearr_58798[(14)] = inst_58696);

(statearr_58798[(15)] = inst_58695);

return statearr_58798;
})();
var statearr_58799_58847 = state_58755__$1;
(statearr_58799_58847[(2)] = null);

(statearr_58799_58847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (10))){
var inst_58698 = (state_58755[(12)]);
var inst_58697 = (state_58755[(13)]);
var inst_58696 = (state_58755[(14)]);
var inst_58695 = (state_58755[(15)]);
var inst_58704 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_58696,inst_58698);
var inst_58705 = cljs.core.async.muxch_STAR_(inst_58704);
var inst_58706 = cljs.core.async.close_BANG_(inst_58705);
var inst_58707 = (inst_58698 + (1));
var tmp58794 = inst_58697;
var tmp58795 = inst_58696;
var tmp58796 = inst_58695;
var inst_58695__$1 = tmp58796;
var inst_58696__$1 = tmp58795;
var inst_58697__$1 = tmp58794;
var inst_58698__$1 = inst_58707;
var state_58755__$1 = (function (){var statearr_58801 = state_58755;
(statearr_58801[(17)] = inst_58706);

(statearr_58801[(12)] = inst_58698__$1);

(statearr_58801[(13)] = inst_58697__$1);

(statearr_58801[(14)] = inst_58696__$1);

(statearr_58801[(15)] = inst_58695__$1);

return statearr_58801;
})();
var statearr_58802_58849 = state_58755__$1;
(statearr_58802_58849[(2)] = null);

(statearr_58802_58849[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (18))){
var inst_58725 = (state_58755[(2)]);
var state_58755__$1 = state_58755;
var statearr_58803_58850 = state_58755__$1;
(statearr_58803_58850[(2)] = inst_58725);

(statearr_58803_58850[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58757 === (8))){
var inst_58698 = (state_58755[(12)]);
var inst_58697 = (state_58755[(13)]);
var inst_58701 = (inst_58698 < inst_58697);
var inst_58702 = inst_58701;
var state_58755__$1 = state_58755;
if(cljs.core.truth_(inst_58702)){
var statearr_58804_58851 = state_58755__$1;
(statearr_58804_58851[(1)] = (10));

} else {
var statearr_58805_58852 = state_58755__$1;
(statearr_58805_58852[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___58813,mults,ensure_mult,p))
;
return ((function (switch__31990__auto__,c__32222__auto___58813,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_58806 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58806[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_58806[(1)] = (1));

return statearr_58806;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_58755){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_58755);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e58807){if((e58807 instanceof Object)){
var ex__31994__auto__ = e58807;
var statearr_58808_58854 = state_58755;
(statearr_58808_58854[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_58755);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58807;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58855 = state_58755;
state_58755 = G__58855;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_58755){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_58755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___58813,mults,ensure_mult,p))
})();
var state__32224__auto__ = (function (){var statearr_58809 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_58809[(6)] = c__32222__auto___58813);

return statearr_58809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___58813,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__58857 = arguments.length;
switch (G__58857) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__58862 = arguments.length;
switch (G__58862) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__58866 = arguments.length;
switch (G__58866) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__32222__auto___58939 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___58939,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___58939,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_58905){
var state_val_58906 = (state_58905[(1)]);
if((state_val_58906 === (7))){
var state_58905__$1 = state_58905;
var statearr_58907_58940 = state_58905__$1;
(statearr_58907_58940[(2)] = null);

(statearr_58907_58940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (1))){
var state_58905__$1 = state_58905;
var statearr_58908_58941 = state_58905__$1;
(statearr_58908_58941[(2)] = null);

(statearr_58908_58941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (4))){
var inst_58869 = (state_58905[(7)]);
var inst_58871 = (inst_58869 < cnt);
var state_58905__$1 = state_58905;
if(cljs.core.truth_(inst_58871)){
var statearr_58909_58942 = state_58905__$1;
(statearr_58909_58942[(1)] = (6));

} else {
var statearr_58910_58943 = state_58905__$1;
(statearr_58910_58943[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (15))){
var inst_58901 = (state_58905[(2)]);
var state_58905__$1 = state_58905;
var statearr_58912_58944 = state_58905__$1;
(statearr_58912_58944[(2)] = inst_58901);

(statearr_58912_58944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (13))){
var inst_58894 = cljs.core.async.close_BANG_(out);
var state_58905__$1 = state_58905;
var statearr_58913_58945 = state_58905__$1;
(statearr_58913_58945[(2)] = inst_58894);

(statearr_58913_58945[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (6))){
var state_58905__$1 = state_58905;
var statearr_58914_58946 = state_58905__$1;
(statearr_58914_58946[(2)] = null);

(statearr_58914_58946[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (3))){
var inst_58903 = (state_58905[(2)]);
var state_58905__$1 = state_58905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58905__$1,inst_58903);
} else {
if((state_val_58906 === (12))){
var inst_58891 = (state_58905[(8)]);
var inst_58891__$1 = (state_58905[(2)]);
var inst_58892 = cljs.core.some(cljs.core.nil_QMARK_,inst_58891__$1);
var state_58905__$1 = (function (){var statearr_58915 = state_58905;
(statearr_58915[(8)] = inst_58891__$1);

return statearr_58915;
})();
if(cljs.core.truth_(inst_58892)){
var statearr_58916_58947 = state_58905__$1;
(statearr_58916_58947[(1)] = (13));

} else {
var statearr_58917_58948 = state_58905__$1;
(statearr_58917_58948[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (2))){
var inst_58868 = cljs.core.reset_BANG_(dctr,cnt);
var inst_58869 = (0);
var state_58905__$1 = (function (){var statearr_58918 = state_58905;
(statearr_58918[(9)] = inst_58868);

(statearr_58918[(7)] = inst_58869);

return statearr_58918;
})();
var statearr_58919_58952 = state_58905__$1;
(statearr_58919_58952[(2)] = null);

(statearr_58919_58952[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (11))){
var inst_58869 = (state_58905[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_58905,(10),Object,null,(9));
var inst_58878 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_58869) : chs__$1.call(null,inst_58869));
var inst_58879 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_58869) : done.call(null,inst_58869));
var inst_58880 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_58878,inst_58879);
var state_58905__$1 = state_58905;
var statearr_58920_58953 = state_58905__$1;
(statearr_58920_58953[(2)] = inst_58880);


cljs.core.async.impl.ioc_helpers.process_exception(state_58905__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (9))){
var inst_58869 = (state_58905[(7)]);
var inst_58882 = (state_58905[(2)]);
var inst_58883 = (inst_58869 + (1));
var inst_58869__$1 = inst_58883;
var state_58905__$1 = (function (){var statearr_58921 = state_58905;
(statearr_58921[(10)] = inst_58882);

(statearr_58921[(7)] = inst_58869__$1);

return statearr_58921;
})();
var statearr_58922_58954 = state_58905__$1;
(statearr_58922_58954[(2)] = null);

(statearr_58922_58954[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (5))){
var inst_58889 = (state_58905[(2)]);
var state_58905__$1 = (function (){var statearr_58923 = state_58905;
(statearr_58923[(11)] = inst_58889);

return statearr_58923;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58905__$1,(12),dchan);
} else {
if((state_val_58906 === (14))){
var inst_58891 = (state_58905[(8)]);
var inst_58896 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_58891);
var state_58905__$1 = state_58905;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_58905__$1,(16),out,inst_58896);
} else {
if((state_val_58906 === (16))){
var inst_58898 = (state_58905[(2)]);
var state_58905__$1 = (function (){var statearr_58924 = state_58905;
(statearr_58924[(12)] = inst_58898);

return statearr_58924;
})();
var statearr_58925_58955 = state_58905__$1;
(statearr_58925_58955[(2)] = null);

(statearr_58925_58955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (10))){
var inst_58873 = (state_58905[(2)]);
var inst_58874 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_58905__$1 = (function (){var statearr_58929 = state_58905;
(statearr_58929[(13)] = inst_58873);

return statearr_58929;
})();
var statearr_58930_58956 = state_58905__$1;
(statearr_58930_58956[(2)] = inst_58874);


cljs.core.async.impl.ioc_helpers.process_exception(state_58905__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58906 === (8))){
var inst_58887 = (state_58905[(2)]);
var state_58905__$1 = state_58905;
var statearr_58931_58961 = state_58905__$1;
(statearr_58931_58961[(2)] = inst_58887);

(statearr_58931_58961[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___58939,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__31990__auto__,c__32222__auto___58939,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_58932 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58932[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_58932[(1)] = (1));

return statearr_58932;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_58905){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_58905);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e58933){if((e58933 instanceof Object)){
var ex__31994__auto__ = e58933;
var statearr_58934_58971 = state_58905;
(statearr_58934_58971[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_58905);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58933;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58975 = state_58905;
state_58905 = G__58975;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_58905){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_58905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___58939,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__32224__auto__ = (function (){var statearr_58935 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_58935[(6)] = c__32222__auto___58939);

return statearr_58935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___58939,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__58995 = arguments.length;
switch (G__58995) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32222__auto___59096 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___59096,out){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___59096,out){
return (function (state_59051){
var state_val_59052 = (state_59051[(1)]);
if((state_val_59052 === (7))){
var inst_59023 = (state_59051[(7)]);
var inst_59024 = (state_59051[(8)]);
var inst_59023__$1 = (state_59051[(2)]);
var inst_59024__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59023__$1,(0),null);
var inst_59025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59023__$1,(1),null);
var inst_59026 = (inst_59024__$1 == null);
var state_59051__$1 = (function (){var statearr_59066 = state_59051;
(statearr_59066[(7)] = inst_59023__$1);

(statearr_59066[(8)] = inst_59024__$1);

(statearr_59066[(9)] = inst_59025);

return statearr_59066;
})();
if(cljs.core.truth_(inst_59026)){
var statearr_59071_59097 = state_59051__$1;
(statearr_59071_59097[(1)] = (8));

} else {
var statearr_59072_59098 = state_59051__$1;
(statearr_59072_59098[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59052 === (1))){
var inst_59010 = cljs.core.vec(chs);
var inst_59011 = inst_59010;
var state_59051__$1 = (function (){var statearr_59073 = state_59051;
(statearr_59073[(10)] = inst_59011);

return statearr_59073;
})();
var statearr_59074_59099 = state_59051__$1;
(statearr_59074_59099[(2)] = null);

(statearr_59074_59099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59052 === (4))){
var inst_59011 = (state_59051[(10)]);
var state_59051__$1 = state_59051;
return cljs.core.async.ioc_alts_BANG_(state_59051__$1,(7),inst_59011);
} else {
if((state_val_59052 === (6))){
var inst_59043 = (state_59051[(2)]);
var state_59051__$1 = state_59051;
var statearr_59075_59100 = state_59051__$1;
(statearr_59075_59100[(2)] = inst_59043);

(statearr_59075_59100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59052 === (3))){
var inst_59045 = (state_59051[(2)]);
var state_59051__$1 = state_59051;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59051__$1,inst_59045);
} else {
if((state_val_59052 === (2))){
var inst_59011 = (state_59051[(10)]);
var inst_59016 = cljs.core.count(inst_59011);
var inst_59017 = (inst_59016 > (0));
var state_59051__$1 = state_59051;
if(cljs.core.truth_(inst_59017)){
var statearr_59077_59102 = state_59051__$1;
(statearr_59077_59102[(1)] = (4));

} else {
var statearr_59078_59103 = state_59051__$1;
(statearr_59078_59103[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59052 === (11))){
var inst_59011 = (state_59051[(10)]);
var inst_59036 = (state_59051[(2)]);
var tmp59076 = inst_59011;
var inst_59011__$1 = tmp59076;
var state_59051__$1 = (function (){var statearr_59079 = state_59051;
(statearr_59079[(10)] = inst_59011__$1);

(statearr_59079[(11)] = inst_59036);

return statearr_59079;
})();
var statearr_59080_59105 = state_59051__$1;
(statearr_59080_59105[(2)] = null);

(statearr_59080_59105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59052 === (9))){
var inst_59024 = (state_59051[(8)]);
var state_59051__$1 = state_59051;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_59051__$1,(11),out,inst_59024);
} else {
if((state_val_59052 === (5))){
var inst_59041 = cljs.core.async.close_BANG_(out);
var state_59051__$1 = state_59051;
var statearr_59081_59106 = state_59051__$1;
(statearr_59081_59106[(2)] = inst_59041);

(statearr_59081_59106[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59052 === (10))){
var inst_59039 = (state_59051[(2)]);
var state_59051__$1 = state_59051;
var statearr_59083_59108 = state_59051__$1;
(statearr_59083_59108[(2)] = inst_59039);

(statearr_59083_59108[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59052 === (8))){
var inst_59023 = (state_59051[(7)]);
var inst_59011 = (state_59051[(10)]);
var inst_59024 = (state_59051[(8)]);
var inst_59025 = (state_59051[(9)]);
var inst_59031 = (function (){var cs = inst_59011;
var vec__59019 = inst_59023;
var v = inst_59024;
var c = inst_59025;
return ((function (cs,vec__59019,v,c,inst_59023,inst_59011,inst_59024,inst_59025,state_val_59052,c__32222__auto___59096,out){
return (function (p1__58986_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__58986_SHARP_);
});
;})(cs,vec__59019,v,c,inst_59023,inst_59011,inst_59024,inst_59025,state_val_59052,c__32222__auto___59096,out))
})();
var inst_59032 = cljs.core.filterv(inst_59031,inst_59011);
var inst_59011__$1 = inst_59032;
var state_59051__$1 = (function (){var statearr_59085 = state_59051;
(statearr_59085[(10)] = inst_59011__$1);

return statearr_59085;
})();
var statearr_59086_59109 = state_59051__$1;
(statearr_59086_59109[(2)] = null);

(statearr_59086_59109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___59096,out))
;
return ((function (switch__31990__auto__,c__32222__auto___59096,out){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_59087 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59087[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_59087[(1)] = (1));

return statearr_59087;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_59051){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_59051);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e59091){if((e59091 instanceof Object)){
var ex__31994__auto__ = e59091;
var statearr_59092_59110 = state_59051;
(statearr_59092_59110[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_59051);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59091;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59111 = state_59051;
state_59051 = G__59111;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_59051){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_59051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___59096,out))
})();
var state__32224__auto__ = (function (){var statearr_59093 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_59093[(6)] = c__32222__auto___59096);

return statearr_59093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___59096,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__59113 = arguments.length;
switch (G__59113) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32222__auto___59158 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___59158,out){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___59158,out){
return (function (state_59137){
var state_val_59138 = (state_59137[(1)]);
if((state_val_59138 === (7))){
var inst_59119 = (state_59137[(7)]);
var inst_59119__$1 = (state_59137[(2)]);
var inst_59120 = (inst_59119__$1 == null);
var inst_59121 = cljs.core.not(inst_59120);
var state_59137__$1 = (function (){var statearr_59139 = state_59137;
(statearr_59139[(7)] = inst_59119__$1);

return statearr_59139;
})();
if(inst_59121){
var statearr_59140_59159 = state_59137__$1;
(statearr_59140_59159[(1)] = (8));

} else {
var statearr_59141_59160 = state_59137__$1;
(statearr_59141_59160[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59138 === (1))){
var inst_59114 = (0);
var state_59137__$1 = (function (){var statearr_59142 = state_59137;
(statearr_59142[(8)] = inst_59114);

return statearr_59142;
})();
var statearr_59143_59161 = state_59137__$1;
(statearr_59143_59161[(2)] = null);

(statearr_59143_59161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59138 === (4))){
var state_59137__$1 = state_59137;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59137__$1,(7),ch);
} else {
if((state_val_59138 === (6))){
var inst_59132 = (state_59137[(2)]);
var state_59137__$1 = state_59137;
var statearr_59144_59162 = state_59137__$1;
(statearr_59144_59162[(2)] = inst_59132);

(statearr_59144_59162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59138 === (3))){
var inst_59134 = (state_59137[(2)]);
var inst_59135 = cljs.core.async.close_BANG_(out);
var state_59137__$1 = (function (){var statearr_59145 = state_59137;
(statearr_59145[(9)] = inst_59134);

return statearr_59145;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_59137__$1,inst_59135);
} else {
if((state_val_59138 === (2))){
var inst_59114 = (state_59137[(8)]);
var inst_59116 = (inst_59114 < n);
var state_59137__$1 = state_59137;
if(cljs.core.truth_(inst_59116)){
var statearr_59146_59163 = state_59137__$1;
(statearr_59146_59163[(1)] = (4));

} else {
var statearr_59147_59164 = state_59137__$1;
(statearr_59147_59164[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59138 === (11))){
var inst_59114 = (state_59137[(8)]);
var inst_59124 = (state_59137[(2)]);
var inst_59125 = (inst_59114 + (1));
var inst_59114__$1 = inst_59125;
var state_59137__$1 = (function (){var statearr_59148 = state_59137;
(statearr_59148[(8)] = inst_59114__$1);

(statearr_59148[(10)] = inst_59124);

return statearr_59148;
})();
var statearr_59149_59165 = state_59137__$1;
(statearr_59149_59165[(2)] = null);

(statearr_59149_59165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59138 === (9))){
var state_59137__$1 = state_59137;
var statearr_59150_59166 = state_59137__$1;
(statearr_59150_59166[(2)] = null);

(statearr_59150_59166[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59138 === (5))){
var state_59137__$1 = state_59137;
var statearr_59151_59167 = state_59137__$1;
(statearr_59151_59167[(2)] = null);

(statearr_59151_59167[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59138 === (10))){
var inst_59129 = (state_59137[(2)]);
var state_59137__$1 = state_59137;
var statearr_59152_59168 = state_59137__$1;
(statearr_59152_59168[(2)] = inst_59129);

(statearr_59152_59168[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59138 === (8))){
var inst_59119 = (state_59137[(7)]);
var state_59137__$1 = state_59137;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_59137__$1,(11),out,inst_59119);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___59158,out))
;
return ((function (switch__31990__auto__,c__32222__auto___59158,out){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_59153 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_59153[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_59153[(1)] = (1));

return statearr_59153;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_59137){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_59137);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e59154){if((e59154 instanceof Object)){
var ex__31994__auto__ = e59154;
var statearr_59155_59169 = state_59137;
(statearr_59155_59169[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_59137);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59154;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59170 = state_59137;
state_59137 = G__59170;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_59137){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_59137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___59158,out))
})();
var state__32224__auto__ = (function (){var statearr_59156 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_59156[(6)] = c__32222__auto___59158);

return statearr_59156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___59158,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async59172 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59172 = (function (f,ch,meta59173){
this.f = f;
this.ch = ch;
this.meta59173 = meta59173;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async59172.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_59174,meta59173__$1){
var self__ = this;
var _59174__$1 = this;
return (new cljs.core.async.t_cljs$core$async59172(self__.f,self__.ch,meta59173__$1));
});

cljs.core.async.t_cljs$core$async59172.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_59174){
var self__ = this;
var _59174__$1 = this;
return self__.meta59173;
});

cljs.core.async.t_cljs$core$async59172.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59172.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async59172.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async59172.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59172.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async59175 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59175 = (function (f,ch,meta59173,_,fn1,meta59176){
this.f = f;
this.ch = ch;
this.meta59173 = meta59173;
this._ = _;
this.fn1 = fn1;
this.meta59176 = meta59176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async59175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_59177,meta59176__$1){
var self__ = this;
var _59177__$1 = this;
return (new cljs.core.async.t_cljs$core$async59175(self__.f,self__.ch,self__.meta59173,self__._,self__.fn1,meta59176__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async59175.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_59177){
var self__ = this;
var _59177__$1 = this;
return self__.meta59176;
});})(___$1))
;

cljs.core.async.t_cljs$core$async59175.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59175.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async59175.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async59175.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__59171_SHARP_){
var G__59178 = (((p1__59171_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__59171_SHARP_) : self__.f.call(null,p1__59171_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__59178) : f1.call(null,G__59178));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async59175.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta59173","meta59173",-1812430736,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async59172","cljs.core.async/t_cljs$core$async59172",1319502683,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta59176","meta59176",2137913218,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async59175.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59175.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59175";

cljs.core.async.t_cljs$core$async59175.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async59175");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async59175.
 */
cljs.core.async.__GT_t_cljs$core$async59175 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async59175(f__$1,ch__$1,meta59173__$1,___$2,fn1__$1,meta59176){
return (new cljs.core.async.t_cljs$core$async59175(f__$1,ch__$1,meta59173__$1,___$2,fn1__$1,meta59176));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async59175(self__.f,self__.ch,self__.meta59173,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3938__auto__ = ret;
if(cljs.core.truth_(and__3938__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__3938__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__59179 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__59179) : self__.f.call(null,G__59179));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async59172.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59172.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async59172.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta59173","meta59173",-1812430736,null)], null);
});

cljs.core.async.t_cljs$core$async59172.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59172.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59172";

cljs.core.async.t_cljs$core$async59172.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async59172");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async59172.
 */
cljs.core.async.__GT_t_cljs$core$async59172 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async59172(f__$1,ch__$1,meta59173){
return (new cljs.core.async.t_cljs$core$async59172(f__$1,ch__$1,meta59173));
});

}

return (new cljs.core.async.t_cljs$core$async59172(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async59180 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59180 = (function (f,ch,meta59181){
this.f = f;
this.ch = ch;
this.meta59181 = meta59181;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async59180.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_59182,meta59181__$1){
var self__ = this;
var _59182__$1 = this;
return (new cljs.core.async.t_cljs$core$async59180(self__.f,self__.ch,meta59181__$1));
});

cljs.core.async.t_cljs$core$async59180.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_59182){
var self__ = this;
var _59182__$1 = this;
return self__.meta59181;
});

cljs.core.async.t_cljs$core$async59180.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59180.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async59180.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59180.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async59180.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59180.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async59180.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta59181","meta59181",933168413,null)], null);
});

cljs.core.async.t_cljs$core$async59180.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59180.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59180";

cljs.core.async.t_cljs$core$async59180.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async59180");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async59180.
 */
cljs.core.async.__GT_t_cljs$core$async59180 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async59180(f__$1,ch__$1,meta59181){
return (new cljs.core.async.t_cljs$core$async59180(f__$1,ch__$1,meta59181));
});

}

return (new cljs.core.async.t_cljs$core$async59180(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async59183 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59183 = (function (p,ch,meta59184){
this.p = p;
this.ch = ch;
this.meta59184 = meta59184;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async59183.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_59185,meta59184__$1){
var self__ = this;
var _59185__$1 = this;
return (new cljs.core.async.t_cljs$core$async59183(self__.p,self__.ch,meta59184__$1));
});

cljs.core.async.t_cljs$core$async59183.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_59185){
var self__ = this;
var _59185__$1 = this;
return self__.meta59184;
});

cljs.core.async.t_cljs$core$async59183.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59183.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async59183.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async59183.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59183.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async59183.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59183.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async59183.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta59184","meta59184",85004626,null)], null);
});

cljs.core.async.t_cljs$core$async59183.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59183.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59183";

cljs.core.async.t_cljs$core$async59183.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async59183");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async59183.
 */
cljs.core.async.__GT_t_cljs$core$async59183 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async59183(p__$1,ch__$1,meta59184){
return (new cljs.core.async.t_cljs$core$async59183(p__$1,ch__$1,meta59184));
});

}

return (new cljs.core.async.t_cljs$core$async59183(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__59187 = arguments.length;
switch (G__59187) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32222__auto___59227 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___59227,out){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___59227,out){
return (function (state_59208){
var state_val_59209 = (state_59208[(1)]);
if((state_val_59209 === (7))){
var inst_59204 = (state_59208[(2)]);
var state_59208__$1 = state_59208;
var statearr_59210_59228 = state_59208__$1;
(statearr_59210_59228[(2)] = inst_59204);

(statearr_59210_59228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59209 === (1))){
var state_59208__$1 = state_59208;
var statearr_59211_59229 = state_59208__$1;
(statearr_59211_59229[(2)] = null);

(statearr_59211_59229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59209 === (4))){
var inst_59190 = (state_59208[(7)]);
var inst_59190__$1 = (state_59208[(2)]);
var inst_59191 = (inst_59190__$1 == null);
var state_59208__$1 = (function (){var statearr_59212 = state_59208;
(statearr_59212[(7)] = inst_59190__$1);

return statearr_59212;
})();
if(cljs.core.truth_(inst_59191)){
var statearr_59213_59230 = state_59208__$1;
(statearr_59213_59230[(1)] = (5));

} else {
var statearr_59214_59231 = state_59208__$1;
(statearr_59214_59231[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59209 === (6))){
var inst_59190 = (state_59208[(7)]);
var inst_59195 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_59190) : p.call(null,inst_59190));
var state_59208__$1 = state_59208;
if(cljs.core.truth_(inst_59195)){
var statearr_59215_59232 = state_59208__$1;
(statearr_59215_59232[(1)] = (8));

} else {
var statearr_59216_59233 = state_59208__$1;
(statearr_59216_59233[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59209 === (3))){
var inst_59206 = (state_59208[(2)]);
var state_59208__$1 = state_59208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59208__$1,inst_59206);
} else {
if((state_val_59209 === (2))){
var state_59208__$1 = state_59208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59208__$1,(4),ch);
} else {
if((state_val_59209 === (11))){
var inst_59198 = (state_59208[(2)]);
var state_59208__$1 = state_59208;
var statearr_59217_59234 = state_59208__$1;
(statearr_59217_59234[(2)] = inst_59198);

(statearr_59217_59234[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59209 === (9))){
var state_59208__$1 = state_59208;
var statearr_59218_59235 = state_59208__$1;
(statearr_59218_59235[(2)] = null);

(statearr_59218_59235[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59209 === (5))){
var inst_59193 = cljs.core.async.close_BANG_(out);
var state_59208__$1 = state_59208;
var statearr_59219_59236 = state_59208__$1;
(statearr_59219_59236[(2)] = inst_59193);

(statearr_59219_59236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59209 === (10))){
var inst_59201 = (state_59208[(2)]);
var state_59208__$1 = (function (){var statearr_59220 = state_59208;
(statearr_59220[(8)] = inst_59201);

return statearr_59220;
})();
var statearr_59221_59237 = state_59208__$1;
(statearr_59221_59237[(2)] = null);

(statearr_59221_59237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59209 === (8))){
var inst_59190 = (state_59208[(7)]);
var state_59208__$1 = state_59208;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_59208__$1,(11),out,inst_59190);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___59227,out))
;
return ((function (switch__31990__auto__,c__32222__auto___59227,out){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_59222 = [null,null,null,null,null,null,null,null,null];
(statearr_59222[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_59222[(1)] = (1));

return statearr_59222;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_59208){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_59208);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e59223){if((e59223 instanceof Object)){
var ex__31994__auto__ = e59223;
var statearr_59224_59238 = state_59208;
(statearr_59224_59238[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_59208);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59223;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59239 = state_59208;
state_59208 = G__59239;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_59208){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_59208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___59227,out))
})();
var state__32224__auto__ = (function (){var statearr_59225 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_59225[(6)] = c__32222__auto___59227);

return statearr_59225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___59227,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__59241 = arguments.length;
switch (G__59241) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__32222__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto__){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto__){
return (function (state_59304){
var state_val_59305 = (state_59304[(1)]);
if((state_val_59305 === (7))){
var inst_59300 = (state_59304[(2)]);
var state_59304__$1 = state_59304;
var statearr_59306_59344 = state_59304__$1;
(statearr_59306_59344[(2)] = inst_59300);

(statearr_59306_59344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (20))){
var inst_59270 = (state_59304[(7)]);
var inst_59281 = (state_59304[(2)]);
var inst_59282 = cljs.core.next(inst_59270);
var inst_59256 = inst_59282;
var inst_59257 = null;
var inst_59258 = (0);
var inst_59259 = (0);
var state_59304__$1 = (function (){var statearr_59307 = state_59304;
(statearr_59307[(8)] = inst_59259);

(statearr_59307[(9)] = inst_59281);

(statearr_59307[(10)] = inst_59257);

(statearr_59307[(11)] = inst_59258);

(statearr_59307[(12)] = inst_59256);

return statearr_59307;
})();
var statearr_59308_59345 = state_59304__$1;
(statearr_59308_59345[(2)] = null);

(statearr_59308_59345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (1))){
var state_59304__$1 = state_59304;
var statearr_59309_59346 = state_59304__$1;
(statearr_59309_59346[(2)] = null);

(statearr_59309_59346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (4))){
var inst_59245 = (state_59304[(13)]);
var inst_59245__$1 = (state_59304[(2)]);
var inst_59246 = (inst_59245__$1 == null);
var state_59304__$1 = (function (){var statearr_59310 = state_59304;
(statearr_59310[(13)] = inst_59245__$1);

return statearr_59310;
})();
if(cljs.core.truth_(inst_59246)){
var statearr_59311_59347 = state_59304__$1;
(statearr_59311_59347[(1)] = (5));

} else {
var statearr_59312_59348 = state_59304__$1;
(statearr_59312_59348[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (15))){
var state_59304__$1 = state_59304;
var statearr_59316_59349 = state_59304__$1;
(statearr_59316_59349[(2)] = null);

(statearr_59316_59349[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (21))){
var state_59304__$1 = state_59304;
var statearr_59317_59350 = state_59304__$1;
(statearr_59317_59350[(2)] = null);

(statearr_59317_59350[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (13))){
var inst_59259 = (state_59304[(8)]);
var inst_59257 = (state_59304[(10)]);
var inst_59258 = (state_59304[(11)]);
var inst_59256 = (state_59304[(12)]);
var inst_59266 = (state_59304[(2)]);
var inst_59267 = (inst_59259 + (1));
var tmp59313 = inst_59257;
var tmp59314 = inst_59258;
var tmp59315 = inst_59256;
var inst_59256__$1 = tmp59315;
var inst_59257__$1 = tmp59313;
var inst_59258__$1 = tmp59314;
var inst_59259__$1 = inst_59267;
var state_59304__$1 = (function (){var statearr_59318 = state_59304;
(statearr_59318[(8)] = inst_59259__$1);

(statearr_59318[(10)] = inst_59257__$1);

(statearr_59318[(14)] = inst_59266);

(statearr_59318[(11)] = inst_59258__$1);

(statearr_59318[(12)] = inst_59256__$1);

return statearr_59318;
})();
var statearr_59319_59351 = state_59304__$1;
(statearr_59319_59351[(2)] = null);

(statearr_59319_59351[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (22))){
var state_59304__$1 = state_59304;
var statearr_59320_59352 = state_59304__$1;
(statearr_59320_59352[(2)] = null);

(statearr_59320_59352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (6))){
var inst_59245 = (state_59304[(13)]);
var inst_59254 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_59245) : f.call(null,inst_59245));
var inst_59255 = cljs.core.seq(inst_59254);
var inst_59256 = inst_59255;
var inst_59257 = null;
var inst_59258 = (0);
var inst_59259 = (0);
var state_59304__$1 = (function (){var statearr_59321 = state_59304;
(statearr_59321[(8)] = inst_59259);

(statearr_59321[(10)] = inst_59257);

(statearr_59321[(11)] = inst_59258);

(statearr_59321[(12)] = inst_59256);

return statearr_59321;
})();
var statearr_59322_59353 = state_59304__$1;
(statearr_59322_59353[(2)] = null);

(statearr_59322_59353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (17))){
var inst_59270 = (state_59304[(7)]);
var inst_59274 = cljs.core.chunk_first(inst_59270);
var inst_59275 = cljs.core.chunk_rest(inst_59270);
var inst_59276 = cljs.core.count(inst_59274);
var inst_59256 = inst_59275;
var inst_59257 = inst_59274;
var inst_59258 = inst_59276;
var inst_59259 = (0);
var state_59304__$1 = (function (){var statearr_59323 = state_59304;
(statearr_59323[(8)] = inst_59259);

(statearr_59323[(10)] = inst_59257);

(statearr_59323[(11)] = inst_59258);

(statearr_59323[(12)] = inst_59256);

return statearr_59323;
})();
var statearr_59324_59354 = state_59304__$1;
(statearr_59324_59354[(2)] = null);

(statearr_59324_59354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (3))){
var inst_59302 = (state_59304[(2)]);
var state_59304__$1 = state_59304;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59304__$1,inst_59302);
} else {
if((state_val_59305 === (12))){
var inst_59290 = (state_59304[(2)]);
var state_59304__$1 = state_59304;
var statearr_59325_59355 = state_59304__$1;
(statearr_59325_59355[(2)] = inst_59290);

(statearr_59325_59355[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (2))){
var state_59304__$1 = state_59304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59304__$1,(4),in$);
} else {
if((state_val_59305 === (23))){
var inst_59298 = (state_59304[(2)]);
var state_59304__$1 = state_59304;
var statearr_59326_59356 = state_59304__$1;
(statearr_59326_59356[(2)] = inst_59298);

(statearr_59326_59356[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (19))){
var inst_59285 = (state_59304[(2)]);
var state_59304__$1 = state_59304;
var statearr_59327_59357 = state_59304__$1;
(statearr_59327_59357[(2)] = inst_59285);

(statearr_59327_59357[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (11))){
var inst_59270 = (state_59304[(7)]);
var inst_59256 = (state_59304[(12)]);
var inst_59270__$1 = cljs.core.seq(inst_59256);
var state_59304__$1 = (function (){var statearr_59328 = state_59304;
(statearr_59328[(7)] = inst_59270__$1);

return statearr_59328;
})();
if(inst_59270__$1){
var statearr_59329_59358 = state_59304__$1;
(statearr_59329_59358[(1)] = (14));

} else {
var statearr_59330_59359 = state_59304__$1;
(statearr_59330_59359[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (9))){
var inst_59292 = (state_59304[(2)]);
var inst_59293 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_59304__$1 = (function (){var statearr_59331 = state_59304;
(statearr_59331[(15)] = inst_59292);

return statearr_59331;
})();
if(cljs.core.truth_(inst_59293)){
var statearr_59332_59360 = state_59304__$1;
(statearr_59332_59360[(1)] = (21));

} else {
var statearr_59333_59361 = state_59304__$1;
(statearr_59333_59361[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (5))){
var inst_59248 = cljs.core.async.close_BANG_(out);
var state_59304__$1 = state_59304;
var statearr_59334_59362 = state_59304__$1;
(statearr_59334_59362[(2)] = inst_59248);

(statearr_59334_59362[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (14))){
var inst_59270 = (state_59304[(7)]);
var inst_59272 = cljs.core.chunked_seq_QMARK_(inst_59270);
var state_59304__$1 = state_59304;
if(inst_59272){
var statearr_59335_59363 = state_59304__$1;
(statearr_59335_59363[(1)] = (17));

} else {
var statearr_59336_59364 = state_59304__$1;
(statearr_59336_59364[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (16))){
var inst_59288 = (state_59304[(2)]);
var state_59304__$1 = state_59304;
var statearr_59337_59365 = state_59304__$1;
(statearr_59337_59365[(2)] = inst_59288);

(statearr_59337_59365[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59305 === (10))){
var inst_59259 = (state_59304[(8)]);
var inst_59257 = (state_59304[(10)]);
var inst_59264 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_59257,inst_59259);
var state_59304__$1 = state_59304;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_59304__$1,(13),out,inst_59264);
} else {
if((state_val_59305 === (18))){
var inst_59270 = (state_59304[(7)]);
var inst_59279 = cljs.core.first(inst_59270);
var state_59304__$1 = state_59304;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_59304__$1,(20),out,inst_59279);
} else {
if((state_val_59305 === (8))){
var inst_59259 = (state_59304[(8)]);
var inst_59258 = (state_59304[(11)]);
var inst_59261 = (inst_59259 < inst_59258);
var inst_59262 = inst_59261;
var state_59304__$1 = state_59304;
if(cljs.core.truth_(inst_59262)){
var statearr_59338_59366 = state_59304__$1;
(statearr_59338_59366[(1)] = (10));

} else {
var statearr_59339_59367 = state_59304__$1;
(statearr_59339_59367[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto__))
;
return ((function (switch__31990__auto__,c__32222__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__31991__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__31991__auto____0 = (function (){
var statearr_59340 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59340[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__31991__auto__);

(statearr_59340[(1)] = (1));

return statearr_59340;
});
var cljs$core$async$mapcat_STAR__$_state_machine__31991__auto____1 = (function (state_59304){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_59304);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e59341){if((e59341 instanceof Object)){
var ex__31994__auto__ = e59341;
var statearr_59342_59368 = state_59304;
(statearr_59342_59368[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_59304);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59341;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59369 = state_59304;
state_59304 = G__59369;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__31991__auto__ = function(state_59304){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__31991__auto____1.call(this,state_59304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__31991__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__31991__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto__))
})();
var state__32224__auto__ = (function (){var statearr_59343 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_59343[(6)] = c__32222__auto__);

return statearr_59343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto__))
);

return c__32222__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__59371 = arguments.length;
switch (G__59371) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__59374 = arguments.length;
switch (G__59374) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__59377 = arguments.length;
switch (G__59377) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32222__auto___59424 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___59424,out){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___59424,out){
return (function (state_59401){
var state_val_59402 = (state_59401[(1)]);
if((state_val_59402 === (7))){
var inst_59396 = (state_59401[(2)]);
var state_59401__$1 = state_59401;
var statearr_59403_59425 = state_59401__$1;
(statearr_59403_59425[(2)] = inst_59396);

(statearr_59403_59425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59402 === (1))){
var inst_59378 = null;
var state_59401__$1 = (function (){var statearr_59404 = state_59401;
(statearr_59404[(7)] = inst_59378);

return statearr_59404;
})();
var statearr_59405_59426 = state_59401__$1;
(statearr_59405_59426[(2)] = null);

(statearr_59405_59426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59402 === (4))){
var inst_59381 = (state_59401[(8)]);
var inst_59381__$1 = (state_59401[(2)]);
var inst_59382 = (inst_59381__$1 == null);
var inst_59383 = cljs.core.not(inst_59382);
var state_59401__$1 = (function (){var statearr_59406 = state_59401;
(statearr_59406[(8)] = inst_59381__$1);

return statearr_59406;
})();
if(inst_59383){
var statearr_59407_59427 = state_59401__$1;
(statearr_59407_59427[(1)] = (5));

} else {
var statearr_59408_59428 = state_59401__$1;
(statearr_59408_59428[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59402 === (6))){
var state_59401__$1 = state_59401;
var statearr_59409_59429 = state_59401__$1;
(statearr_59409_59429[(2)] = null);

(statearr_59409_59429[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59402 === (3))){
var inst_59398 = (state_59401[(2)]);
var inst_59399 = cljs.core.async.close_BANG_(out);
var state_59401__$1 = (function (){var statearr_59410 = state_59401;
(statearr_59410[(9)] = inst_59398);

return statearr_59410;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_59401__$1,inst_59399);
} else {
if((state_val_59402 === (2))){
var state_59401__$1 = state_59401;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59401__$1,(4),ch);
} else {
if((state_val_59402 === (11))){
var inst_59381 = (state_59401[(8)]);
var inst_59390 = (state_59401[(2)]);
var inst_59378 = inst_59381;
var state_59401__$1 = (function (){var statearr_59411 = state_59401;
(statearr_59411[(7)] = inst_59378);

(statearr_59411[(10)] = inst_59390);

return statearr_59411;
})();
var statearr_59412_59430 = state_59401__$1;
(statearr_59412_59430[(2)] = null);

(statearr_59412_59430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59402 === (9))){
var inst_59381 = (state_59401[(8)]);
var state_59401__$1 = state_59401;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_59401__$1,(11),out,inst_59381);
} else {
if((state_val_59402 === (5))){
var inst_59378 = (state_59401[(7)]);
var inst_59381 = (state_59401[(8)]);
var inst_59385 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_59381,inst_59378);
var state_59401__$1 = state_59401;
if(inst_59385){
var statearr_59414_59431 = state_59401__$1;
(statearr_59414_59431[(1)] = (8));

} else {
var statearr_59415_59432 = state_59401__$1;
(statearr_59415_59432[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59402 === (10))){
var inst_59393 = (state_59401[(2)]);
var state_59401__$1 = state_59401;
var statearr_59416_59433 = state_59401__$1;
(statearr_59416_59433[(2)] = inst_59393);

(statearr_59416_59433[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59402 === (8))){
var inst_59378 = (state_59401[(7)]);
var tmp59413 = inst_59378;
var inst_59378__$1 = tmp59413;
var state_59401__$1 = (function (){var statearr_59417 = state_59401;
(statearr_59417[(7)] = inst_59378__$1);

return statearr_59417;
})();
var statearr_59418_59434 = state_59401__$1;
(statearr_59418_59434[(2)] = null);

(statearr_59418_59434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___59424,out))
;
return ((function (switch__31990__auto__,c__32222__auto___59424,out){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_59419 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_59419[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_59419[(1)] = (1));

return statearr_59419;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_59401){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_59401);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e59420){if((e59420 instanceof Object)){
var ex__31994__auto__ = e59420;
var statearr_59421_59435 = state_59401;
(statearr_59421_59435[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_59401);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59420;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59436 = state_59401;
state_59401 = G__59436;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_59401){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_59401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___59424,out))
})();
var state__32224__auto__ = (function (){var statearr_59422 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_59422[(6)] = c__32222__auto___59424);

return statearr_59422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___59424,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__59438 = arguments.length;
switch (G__59438) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32222__auto___59504 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___59504,out){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___59504,out){
return (function (state_59476){
var state_val_59477 = (state_59476[(1)]);
if((state_val_59477 === (7))){
var inst_59472 = (state_59476[(2)]);
var state_59476__$1 = state_59476;
var statearr_59478_59505 = state_59476__$1;
(statearr_59478_59505[(2)] = inst_59472);

(statearr_59478_59505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59477 === (1))){
var inst_59439 = (new Array(n));
var inst_59440 = inst_59439;
var inst_59441 = (0);
var state_59476__$1 = (function (){var statearr_59479 = state_59476;
(statearr_59479[(7)] = inst_59441);

(statearr_59479[(8)] = inst_59440);

return statearr_59479;
})();
var statearr_59480_59506 = state_59476__$1;
(statearr_59480_59506[(2)] = null);

(statearr_59480_59506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59477 === (4))){
var inst_59444 = (state_59476[(9)]);
var inst_59444__$1 = (state_59476[(2)]);
var inst_59445 = (inst_59444__$1 == null);
var inst_59446 = cljs.core.not(inst_59445);
var state_59476__$1 = (function (){var statearr_59481 = state_59476;
(statearr_59481[(9)] = inst_59444__$1);

return statearr_59481;
})();
if(inst_59446){
var statearr_59482_59507 = state_59476__$1;
(statearr_59482_59507[(1)] = (5));

} else {
var statearr_59483_59508 = state_59476__$1;
(statearr_59483_59508[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59477 === (15))){
var inst_59466 = (state_59476[(2)]);
var state_59476__$1 = state_59476;
var statearr_59484_59509 = state_59476__$1;
(statearr_59484_59509[(2)] = inst_59466);

(statearr_59484_59509[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59477 === (13))){
var state_59476__$1 = state_59476;
var statearr_59485_59510 = state_59476__$1;
(statearr_59485_59510[(2)] = null);

(statearr_59485_59510[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59477 === (6))){
var inst_59441 = (state_59476[(7)]);
var inst_59462 = (inst_59441 > (0));
var state_59476__$1 = state_59476;
if(cljs.core.truth_(inst_59462)){
var statearr_59486_59511 = state_59476__$1;
(statearr_59486_59511[(1)] = (12));

} else {
var statearr_59487_59512 = state_59476__$1;
(statearr_59487_59512[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59477 === (3))){
var inst_59474 = (state_59476[(2)]);
var state_59476__$1 = state_59476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59476__$1,inst_59474);
} else {
if((state_val_59477 === (12))){
var inst_59440 = (state_59476[(8)]);
var inst_59464 = cljs.core.vec(inst_59440);
var state_59476__$1 = state_59476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_59476__$1,(15),out,inst_59464);
} else {
if((state_val_59477 === (2))){
var state_59476__$1 = state_59476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59476__$1,(4),ch);
} else {
if((state_val_59477 === (11))){
var inst_59456 = (state_59476[(2)]);
var inst_59457 = (new Array(n));
var inst_59440 = inst_59457;
var inst_59441 = (0);
var state_59476__$1 = (function (){var statearr_59488 = state_59476;
(statearr_59488[(10)] = inst_59456);

(statearr_59488[(7)] = inst_59441);

(statearr_59488[(8)] = inst_59440);

return statearr_59488;
})();
var statearr_59489_59513 = state_59476__$1;
(statearr_59489_59513[(2)] = null);

(statearr_59489_59513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59477 === (9))){
var inst_59440 = (state_59476[(8)]);
var inst_59454 = cljs.core.vec(inst_59440);
var state_59476__$1 = state_59476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_59476__$1,(11),out,inst_59454);
} else {
if((state_val_59477 === (5))){
var inst_59444 = (state_59476[(9)]);
var inst_59449 = (state_59476[(11)]);
var inst_59441 = (state_59476[(7)]);
var inst_59440 = (state_59476[(8)]);
var inst_59448 = (inst_59440[inst_59441] = inst_59444);
var inst_59449__$1 = (inst_59441 + (1));
var inst_59450 = (inst_59449__$1 < n);
var state_59476__$1 = (function (){var statearr_59490 = state_59476;
(statearr_59490[(11)] = inst_59449__$1);

(statearr_59490[(12)] = inst_59448);

return statearr_59490;
})();
if(cljs.core.truth_(inst_59450)){
var statearr_59491_59514 = state_59476__$1;
(statearr_59491_59514[(1)] = (8));

} else {
var statearr_59492_59515 = state_59476__$1;
(statearr_59492_59515[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59477 === (14))){
var inst_59469 = (state_59476[(2)]);
var inst_59470 = cljs.core.async.close_BANG_(out);
var state_59476__$1 = (function (){var statearr_59494 = state_59476;
(statearr_59494[(13)] = inst_59469);

return statearr_59494;
})();
var statearr_59495_59516 = state_59476__$1;
(statearr_59495_59516[(2)] = inst_59470);

(statearr_59495_59516[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59477 === (10))){
var inst_59460 = (state_59476[(2)]);
var state_59476__$1 = state_59476;
var statearr_59496_59517 = state_59476__$1;
(statearr_59496_59517[(2)] = inst_59460);

(statearr_59496_59517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59477 === (8))){
var inst_59449 = (state_59476[(11)]);
var inst_59440 = (state_59476[(8)]);
var tmp59493 = inst_59440;
var inst_59440__$1 = tmp59493;
var inst_59441 = inst_59449;
var state_59476__$1 = (function (){var statearr_59497 = state_59476;
(statearr_59497[(7)] = inst_59441);

(statearr_59497[(8)] = inst_59440__$1);

return statearr_59497;
})();
var statearr_59498_59518 = state_59476__$1;
(statearr_59498_59518[(2)] = null);

(statearr_59498_59518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___59504,out))
;
return ((function (switch__31990__auto__,c__32222__auto___59504,out){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_59499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59499[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_59499[(1)] = (1));

return statearr_59499;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_59476){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_59476);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e59500){if((e59500 instanceof Object)){
var ex__31994__auto__ = e59500;
var statearr_59501_59519 = state_59476;
(statearr_59501_59519[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_59476);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59500;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59520 = state_59476;
state_59476 = G__59520;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_59476){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_59476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___59504,out))
})();
var state__32224__auto__ = (function (){var statearr_59502 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_59502[(6)] = c__32222__auto___59504);

return statearr_59502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___59504,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__59522 = arguments.length;
switch (G__59522) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32222__auto___59592 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32222__auto___59592,out){
return (function (){
var f__32223__auto__ = (function (){var switch__31990__auto__ = ((function (c__32222__auto___59592,out){
return (function (state_59564){
var state_val_59565 = (state_59564[(1)]);
if((state_val_59565 === (7))){
var inst_59560 = (state_59564[(2)]);
var state_59564__$1 = state_59564;
var statearr_59566_59593 = state_59564__$1;
(statearr_59566_59593[(2)] = inst_59560);

(statearr_59566_59593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59565 === (1))){
var inst_59523 = [];
var inst_59524 = inst_59523;
var inst_59525 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_59564__$1 = (function (){var statearr_59567 = state_59564;
(statearr_59567[(7)] = inst_59525);

(statearr_59567[(8)] = inst_59524);

return statearr_59567;
})();
var statearr_59568_59594 = state_59564__$1;
(statearr_59568_59594[(2)] = null);

(statearr_59568_59594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59565 === (4))){
var inst_59528 = (state_59564[(9)]);
var inst_59528__$1 = (state_59564[(2)]);
var inst_59529 = (inst_59528__$1 == null);
var inst_59530 = cljs.core.not(inst_59529);
var state_59564__$1 = (function (){var statearr_59569 = state_59564;
(statearr_59569[(9)] = inst_59528__$1);

return statearr_59569;
})();
if(inst_59530){
var statearr_59570_59595 = state_59564__$1;
(statearr_59570_59595[(1)] = (5));

} else {
var statearr_59571_59596 = state_59564__$1;
(statearr_59571_59596[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59565 === (15))){
var inst_59554 = (state_59564[(2)]);
var state_59564__$1 = state_59564;
var statearr_59572_59597 = state_59564__$1;
(statearr_59572_59597[(2)] = inst_59554);

(statearr_59572_59597[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59565 === (13))){
var state_59564__$1 = state_59564;
var statearr_59573_59598 = state_59564__$1;
(statearr_59573_59598[(2)] = null);

(statearr_59573_59598[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59565 === (6))){
var inst_59524 = (state_59564[(8)]);
var inst_59549 = inst_59524.length;
var inst_59550 = (inst_59549 > (0));
var state_59564__$1 = state_59564;
if(cljs.core.truth_(inst_59550)){
var statearr_59574_59599 = state_59564__$1;
(statearr_59574_59599[(1)] = (12));

} else {
var statearr_59575_59600 = state_59564__$1;
(statearr_59575_59600[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59565 === (3))){
var inst_59562 = (state_59564[(2)]);
var state_59564__$1 = state_59564;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59564__$1,inst_59562);
} else {
if((state_val_59565 === (12))){
var inst_59524 = (state_59564[(8)]);
var inst_59552 = cljs.core.vec(inst_59524);
var state_59564__$1 = state_59564;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_59564__$1,(15),out,inst_59552);
} else {
if((state_val_59565 === (2))){
var state_59564__$1 = state_59564;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59564__$1,(4),ch);
} else {
if((state_val_59565 === (11))){
var inst_59532 = (state_59564[(10)]);
var inst_59528 = (state_59564[(9)]);
var inst_59542 = (state_59564[(2)]);
var inst_59543 = [];
var inst_59544 = inst_59543.push(inst_59528);
var inst_59524 = inst_59543;
var inst_59525 = inst_59532;
var state_59564__$1 = (function (){var statearr_59576 = state_59564;
(statearr_59576[(7)] = inst_59525);

(statearr_59576[(8)] = inst_59524);

(statearr_59576[(11)] = inst_59542);

(statearr_59576[(12)] = inst_59544);

return statearr_59576;
})();
var statearr_59577_59601 = state_59564__$1;
(statearr_59577_59601[(2)] = null);

(statearr_59577_59601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59565 === (9))){
var inst_59524 = (state_59564[(8)]);
var inst_59540 = cljs.core.vec(inst_59524);
var state_59564__$1 = state_59564;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_59564__$1,(11),out,inst_59540);
} else {
if((state_val_59565 === (5))){
var inst_59525 = (state_59564[(7)]);
var inst_59532 = (state_59564[(10)]);
var inst_59528 = (state_59564[(9)]);
var inst_59532__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_59528) : f.call(null,inst_59528));
var inst_59533 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_59532__$1,inst_59525);
var inst_59534 = cljs.core.keyword_identical_QMARK_(inst_59525,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_59535 = ((inst_59533) || (inst_59534));
var state_59564__$1 = (function (){var statearr_59578 = state_59564;
(statearr_59578[(10)] = inst_59532__$1);

return statearr_59578;
})();
if(cljs.core.truth_(inst_59535)){
var statearr_59579_59602 = state_59564__$1;
(statearr_59579_59602[(1)] = (8));

} else {
var statearr_59580_59603 = state_59564__$1;
(statearr_59580_59603[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59565 === (14))){
var inst_59557 = (state_59564[(2)]);
var inst_59558 = cljs.core.async.close_BANG_(out);
var state_59564__$1 = (function (){var statearr_59582 = state_59564;
(statearr_59582[(13)] = inst_59557);

return statearr_59582;
})();
var statearr_59583_59604 = state_59564__$1;
(statearr_59583_59604[(2)] = inst_59558);

(statearr_59583_59604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59565 === (10))){
var inst_59547 = (state_59564[(2)]);
var state_59564__$1 = state_59564;
var statearr_59584_59605 = state_59564__$1;
(statearr_59584_59605[(2)] = inst_59547);

(statearr_59584_59605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59565 === (8))){
var inst_59524 = (state_59564[(8)]);
var inst_59532 = (state_59564[(10)]);
var inst_59528 = (state_59564[(9)]);
var inst_59537 = inst_59524.push(inst_59528);
var tmp59581 = inst_59524;
var inst_59524__$1 = tmp59581;
var inst_59525 = inst_59532;
var state_59564__$1 = (function (){var statearr_59585 = state_59564;
(statearr_59585[(7)] = inst_59525);

(statearr_59585[(8)] = inst_59524__$1);

(statearr_59585[(14)] = inst_59537);

return statearr_59585;
})();
var statearr_59586_59606 = state_59564__$1;
(statearr_59586_59606[(2)] = null);

(statearr_59586_59606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32222__auto___59592,out))
;
return ((function (switch__31990__auto__,c__32222__auto___59592,out){
return (function() {
var cljs$core$async$state_machine__31991__auto__ = null;
var cljs$core$async$state_machine__31991__auto____0 = (function (){
var statearr_59587 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59587[(0)] = cljs$core$async$state_machine__31991__auto__);

(statearr_59587[(1)] = (1));

return statearr_59587;
});
var cljs$core$async$state_machine__31991__auto____1 = (function (state_59564){
while(true){
var ret_value__31992__auto__ = (function (){try{while(true){
var result__31993__auto__ = switch__31990__auto__(state_59564);
if(cljs.core.keyword_identical_QMARK_(result__31993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31993__auto__;
}
break;
}
}catch (e59588){if((e59588 instanceof Object)){
var ex__31994__auto__ = e59588;
var statearr_59589_59607 = state_59564;
(statearr_59589_59607[(5)] = ex__31994__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_59564);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59588;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31992__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59608 = state_59564;
state_59564 = G__59608;
continue;
} else {
return ret_value__31992__auto__;
}
break;
}
});
cljs$core$async$state_machine__31991__auto__ = function(state_59564){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31991__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31991__auto____1.call(this,state_59564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31991__auto____0;
cljs$core$async$state_machine__31991__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31991__auto____1;
return cljs$core$async$state_machine__31991__auto__;
})()
;})(switch__31990__auto__,c__32222__auto___59592,out))
})();
var state__32224__auto__ = (function (){var statearr_59590 = (f__32223__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32223__auto__.cljs$core$IFn$_invoke$arity$0() : f__32223__auto__.call(null));
(statearr_59590[(6)] = c__32222__auto___59592);

return statearr_59590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32224__auto__);
});})(c__32222__auto___59592,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=cljs.core.async.js.map
