#!/usr/bin/env node
module.exports =
/******/ (function(modules, runtime) { // webpackBootstrap
/******/ 	"use strict";
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	__webpack_require__.ab = __dirname + "/";
/******/
/******/ 	// the startup function
/******/ 	function startup() {
/******/ 		// Load entry module and return exports
/******/ 		return __webpack_require__(130);
/******/ 	};
/******/ 	// initialize runtime
/******/ 	runtime(__webpack_require__);
/******/
/******/ 	// run startup
/******/ 	return startup();
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var cloneArrayBuffer = __webpack_require__(600);

/**
 * Creates a clone of `dataView`.
 *
 * @private
 * @param {Object} dataView The data view to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned data view.
 */
function cloneDataView(dataView, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}

module.exports = cloneDataView;


/***/ }),
/* 1 */
/***/ (function(__unusedmodule, exports) {

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

// It turns out that some (most?) JavaScript engines don't self-host
// `Array.prototype.sort`. This makes sense because C++ will likely remain
// faster than JS when doing raw CPU-intensive sorting. However, when using a
// custom comparator function, calling back and forth between the VM's C++ and
// JIT'd JS is rather slow *and* loses JIT type information, resulting in
// worse generated code for the comparator function than would be optimal. In
// fact, when sorting with a comparator, these costs outweigh the benefits of
// sorting in C++. By using our own JS-implemented Quick Sort (below), we get
// a ~3500ms mean speed-up in `bench/bench.html`.

/**
 * Swap the elements indexed by `x` and `y` in the array `ary`.
 *
 * @param {Array} ary
 *        The array.
 * @param {Number} x
 *        The index of the first item.
 * @param {Number} y
 *        The index of the second item.
 */
function swap(ary, x, y) {
  var temp = ary[x];
  ary[x] = ary[y];
  ary[y] = temp;
}

/**
 * Returns a random integer within the range `low .. high` inclusive.
 *
 * @param {Number} low
 *        The lower bound on the range.
 * @param {Number} high
 *        The upper bound on the range.
 */
function randomIntInRange(low, high) {
  return Math.round(low + (Math.random() * (high - low)));
}

/**
 * The Quick Sort algorithm.
 *
 * @param {Array} ary
 *        An array to sort.
 * @param {function} comparator
 *        Function to use to compare two items.
 * @param {Number} p
 *        Start index of the array
 * @param {Number} r
 *        End index of the array
 */
function doQuickSort(ary, comparator, p, r) {
  // If our lower bound is less than our upper bound, we (1) partition the
  // array into two pieces and (2) recurse on each half. If it is not, this is
  // the empty array and our base case.

  if (p < r) {
    // (1) Partitioning.
    //
    // The partitioning chooses a pivot between `p` and `r` and moves all
    // elements that are less than or equal to the pivot to the before it, and
    // all the elements that are greater than it after it. The effect is that
    // once partition is done, the pivot is in the exact place it will be when
    // the array is put in sorted order, and it will not need to be moved
    // again. This runs in O(n) time.

    // Always choose a random pivot so that an input array which is reverse
    // sorted does not cause O(n^2) running time.
    var pivotIndex = randomIntInRange(p, r);
    var i = p - 1;

    swap(ary, pivotIndex, r);
    var pivot = ary[r];

    // Immediately after `j` is incremented in this loop, the following hold
    // true:
    //
    //   * Every element in `ary[p .. i]` is less than or equal to the pivot.
    //
    //   * Every element in `ary[i+1 .. j-1]` is greater than the pivot.
    for (var j = p; j < r; j++) {
      if (comparator(ary[j], pivot) <= 0) {
        i += 1;
        swap(ary, i, j);
      }
    }

    swap(ary, i + 1, j);
    var q = i + 1;

    // (2) Recurse on each half.

    doQuickSort(ary, comparator, p, q - 1);
    doQuickSort(ary, comparator, q + 1, r);
  }
}

/**
 * Sort the given array in-place with the given comparator function.
 *
 * @param {Array} ary
 *        An array to sort.
 * @param {function} comparator
 *        Function to use to compare two items.
 */
exports.quickSort = function (ary, comparator) {
  doQuickSort(ary, comparator, 0, ary.length - 1);
};


/***/ }),
/* 2 */
/***/ (function(module) {

/**
 * A specialized version of `matchesProperty` for source values suitable
 * for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function matchesStrictComparable(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue &&
      (srcValue !== undefined || (key in Object(object)));
  };
}

module.exports = matchesStrictComparable;


/***/ }),
/* 3 */,
/* 4 */,
/* 5 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.program = exports.expression = exports.statements = exports.statement = exports.smart = void 0;

var formatters = _interopRequireWildcard(__webpack_require__(822));

var _builder = _interopRequireDefault(__webpack_require__(397));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const smart = (0, _builder.default)(formatters.smart);
exports.smart = smart;
const statement = (0, _builder.default)(formatters.statement);
exports.statement = statement;
const statements = (0, _builder.default)(formatters.statements);
exports.statements = statements;
const expression = (0, _builder.default)(formatters.expression);
exports.expression = expression;
const program = (0, _builder.default)(formatters.program);
exports.program = program;

var _default = Object.assign(smart.bind(undefined), {
  smart,
  statement,
  statements,
  expression,
  program,
  ast: smart.ast
});

exports.default = _default;

/***/ }),
/* 6 */,
/* 7 */,
/* 8 */,
/* 9 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var hashClear = __webpack_require__(711),
    hashDelete = __webpack_require__(638),
    hashGet = __webpack_require__(936),
    hashHas = __webpack_require__(802),
    hashSet = __webpack_require__(261);

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

module.exports = Hash;


/***/ }),
/* 10 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseGetTag = __webpack_require__(51),
    isObject = __webpack_require__(988);

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

module.exports = isFunction;


/***/ }),
/* 11 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _helperHoistVariables = _interopRequireDefault(__webpack_require__(759));

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const visitor = {
  enter(path, state) {
    if (path.isThisExpression()) {
      state.foundThis = true;
    }

    if (path.isReferencedIdentifier({
      name: "arguments"
    })) {
      state.foundArguments = true;
    }
  },

  Function(path) {
    path.skip();
  }

};

function _default(path, scope = path.scope) {
  const {
    node
  } = path;
  const container = t.functionExpression(null, [], node.body, node.generator, node.async);
  let callee = container;
  let args = [];
  (0, _helperHoistVariables.default)(path, id => scope.push({
    id
  }));
  const state = {
    foundThis: false,
    foundArguments: false
  };
  path.traverse(visitor, state);

  if (state.foundArguments || state.foundThis) {
    callee = t.memberExpression(container, t.identifier("apply"));
    args = [];

    if (state.foundThis) {
      args.push(t.thisExpression());
    }

    if (state.foundArguments) {
      if (!state.foundThis) args.push(t.nullLiteral());
      args.push(t.identifier("arguments"));
    }
  }

  let call = t.callExpression(callee, args);
  if (node.generator) call = t.yieldExpression(call, true);
  return t.returnStatement(call);
}

/***/ }),
/* 12 */,
/* 13 */,
/* 14 */,
/* 15 */,
/* 16 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = loadPrivatePartialConfig;
exports.loadPartialConfig = loadPartialConfig;

function _path() {
  const data = _interopRequireDefault(__webpack_require__(267));

  _path = function () {
    return data;
  };

  return data;
}

var _plugin = _interopRequireDefault(__webpack_require__(426));

var _util = __webpack_require__(390);

var _item = __webpack_require__(131);

var _configChain = __webpack_require__(235);

var _environment = __webpack_require__(983);

var _options = __webpack_require__(394);

var _files = __webpack_require__(151);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function resolveRootMode(rootDir, rootMode) {
  switch (rootMode) {
    case "root":
      return rootDir;

    case "upward-optional":
      {
        const upwardRootDir = (0, _files.findConfigUpwards)(rootDir);
        return upwardRootDir === null ? rootDir : upwardRootDir;
      }

    case "upward":
      {
        const upwardRootDir = (0, _files.findConfigUpwards)(rootDir);
        if (upwardRootDir !== null) return upwardRootDir;
        throw Object.assign(new Error(`Babel was run with rootMode:"upward" but a root could not ` + `be found when searching upward from "${rootDir}"`), {
          code: "BABEL_ROOT_NOT_FOUND",
          dirname: rootDir
        });
      }

    default:
      throw new Error(`Assertion failure - unknown rootMode value`);
  }
}

function loadPrivatePartialConfig(inputOpts) {
  if (inputOpts != null && (typeof inputOpts !== "object" || Array.isArray(inputOpts))) {
    throw new Error("Babel options must be an object, null, or undefined");
  }

  const args = inputOpts ? (0, _options.validate)("arguments", inputOpts) : {};
  const {
    envName = (0, _environment.getEnv)(),
    cwd = ".",
    root: rootDir = ".",
    rootMode = "root",
    caller
  } = args;

  const absoluteCwd = _path().default.resolve(cwd);

  const absoluteRootDir = resolveRootMode(_path().default.resolve(absoluteCwd, rootDir), rootMode);
  const context = {
    filename: typeof args.filename === "string" ? _path().default.resolve(cwd, args.filename) : undefined,
    cwd: absoluteCwd,
    root: absoluteRootDir,
    envName,
    caller
  };
  const configChain = (0, _configChain.buildRootChain)(args, context);
  if (!configChain) return null;
  const options = {};
  configChain.options.forEach(opts => {
    (0, _util.mergeOptions)(options, opts);
  });
  options.babelrc = false;
  options.configFile = false;
  options.passPerPreset = false;
  options.envName = context.envName;
  options.cwd = context.cwd;
  options.root = context.root;
  options.filename = typeof context.filename === "string" ? context.filename : undefined;
  options.plugins = configChain.plugins.map(descriptor => (0, _item.createItemFromDescriptor)(descriptor));
  options.presets = configChain.presets.map(descriptor => (0, _item.createItemFromDescriptor)(descriptor));
  return {
    options,
    context,
    ignore: configChain.ignore,
    babelrc: configChain.babelrc,
    config: configChain.config
  };
}

function loadPartialConfig(inputOpts) {
  const result = loadPrivatePartialConfig(inputOpts);
  if (!result) return null;
  const {
    options,
    babelrc,
    ignore,
    config
  } = result;
  (options.plugins || []).forEach(item => {
    if (item.value instanceof _plugin.default) {
      throw new Error("Passing cached plugin instances is not supported in " + "babel.loadPartialConfig()");
    }
  });
  return new PartialConfig(options, babelrc ? babelrc.filepath : undefined, ignore ? ignore.filepath : undefined, config ? config.filepath : undefined);
}

class PartialConfig {
  constructor(options, babelrc, ignore, config) {
    this.options = options;
    this.babelignore = ignore;
    this.babelrc = babelrc;
    this.config = config;
    Object.freeze(this);
  }

  hasFilesystemConfig() {
    return this.babelrc !== undefined || this.config !== undefined;
  }

}

Object.freeze(PartialConfig.prototype);

/***/ }),
/* 17 */,
/* 18 */,
/* 19 */,
/* 20 */
/***/ (function(module) {

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}

module.exports = setCacheAdd;


/***/ }),
/* 21 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _buildMatchMemberExpression = _interopRequireDefault(__webpack_require__(451));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const isReactComponent = (0, _buildMatchMemberExpression.default)("React.Component");
var _default = isReactComponent;
exports.default = _default;

/***/ }),
/* 22 */
/***/ (function(module) {

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

module.exports = listCacheClear;


/***/ }),
/* 23 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = __webpack_require__(57);

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

function _pluginSyntaxObjectRestSpread() {
  const data = _interopRequireDefault(__webpack_require__(490));

  _pluginSyntaxObjectRestSpread = function () {
    return data;
  };

  return data;
}

function _core() {
  const data = __webpack_require__(278);

  _core = function () {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const ZERO_REFS = (() => {
  const node = _core().types.identifier("a");

  const property = _core().types.objectProperty(_core().types.identifier("key"), node);

  const pattern = _core().types.objectPattern([property]);

  return _core().types.isReferenced(node, property, pattern) ? 1 : 0;
})();

var _default = (0, _helperPluginUtils().declare)((api, opts) => {
  api.assertVersion(7);
  const {
    useBuiltIns = false,
    loose = false
  } = opts;

  if (typeof loose !== "boolean") {
    throw new Error(".loose must be a boolean, or undefined");
  }

  function getExtendsHelper(file) {
    return useBuiltIns ? _core().types.memberExpression(_core().types.identifier("Object"), _core().types.identifier("assign")) : file.addHelper("extends");
  }

  function hasRestElement(path) {
    let foundRestElement = false;
    visitRestElements(path, restElement => {
      foundRestElement = true;
      restElement.stop();
    });
    return foundRestElement;
  }

  function hasObjectPatternRestElement(path) {
    let foundRestElement = false;
    visitRestElements(path, restElement => {
      if (restElement.parentPath.isObjectPattern()) {
        foundRestElement = true;
        restElement.stop();
      }
    });
    return foundRestElement;
  }

  function visitRestElements(path, visitor) {
    path.traverse({
      Expression(path) {
        const parentType = path.parent.type;

        if (parentType === "AssignmentPattern" && path.key === "right" || parentType === "ObjectProperty" && path.parent.computed && path.key === "key") {
          path.skip();
        }
      },

      RestElement: visitor
    });
  }

  function hasSpread(node) {
    for (const prop of node.properties) {
      if (_core().types.isSpreadElement(prop)) {
        return true;
      }
    }

    return false;
  }

  function extractNormalizedKeys(path) {
    const props = path.node.properties;
    const keys = [];
    let allLiteral = true;

    for (const prop of props) {
      if (_core().types.isIdentifier(prop.key) && !prop.computed) {
        keys.push(_core().types.stringLiteral(prop.key.name));
      } else if (_core().types.isTemplateLiteral(prop.key)) {
        keys.push(_core().types.cloneNode(prop.key));
      } else if (_core().types.isLiteral(prop.key)) {
        keys.push(_core().types.stringLiteral(String(prop.key.value)));
      } else {
        keys.push(_core().types.cloneNode(prop.key));
        allLiteral = false;
      }
    }

    return {
      keys,
      allLiteral
    };
  }

  function replaceImpureComputedKeys(path) {
    const impureComputedPropertyDeclarators = [];

    for (const propPath of path.get("properties")) {
      const key = propPath.get("key");

      if (propPath.node.computed && !key.isPure()) {
        const name = path.scope.generateUidBasedOnNode(key.node);

        const declarator = _core().types.variableDeclarator(_core().types.identifier(name), key.node);

        impureComputedPropertyDeclarators.push(declarator);
        key.replaceWith(_core().types.identifier(name));
      }
    }

    return impureComputedPropertyDeclarators;
  }

  function removeUnusedExcludedKeys(path) {
    const bindings = path.getOuterBindingIdentifierPaths();
    Object.keys(bindings).forEach(bindingName => {
      const bindingParentPath = bindings[bindingName].parentPath;

      if (path.scope.getBinding(bindingName).references > ZERO_REFS || !bindingParentPath.isObjectProperty()) {
        return;
      }

      bindingParentPath.remove();
    });
  }

  function createObjectSpread(path, file, objRef) {
    const props = path.get("properties");
    const last = props[props.length - 1];

    _core().types.assertRestElement(last.node);

    const restElement = _core().types.cloneNode(last.node);

    last.remove();
    const impureComputedPropertyDeclarators = replaceImpureComputedKeys(path);
    const {
      keys,
      allLiteral
    } = extractNormalizedKeys(path);

    if (keys.length === 0) {
      return [impureComputedPropertyDeclarators, restElement.argument, _core().types.callExpression(getExtendsHelper(file), [_core().types.objectExpression([]), _core().types.cloneNode(objRef)])];
    }

    let keyExpression;

    if (!allLiteral) {
      keyExpression = _core().types.callExpression(_core().types.memberExpression(_core().types.arrayExpression(keys), _core().types.identifier("map")), [file.addHelper("toPropertyKey")]);
    } else {
      keyExpression = _core().types.arrayExpression(keys);
    }

    return [impureComputedPropertyDeclarators, restElement.argument, _core().types.callExpression(file.addHelper(`objectWithoutProperties${loose ? "Loose" : ""}`), [_core().types.cloneNode(objRef), keyExpression])];
  }

  function replaceRestElement(parentPath, paramPath) {
    if (paramPath.isAssignmentPattern()) {
      replaceRestElement(parentPath, paramPath.get("left"));
      return;
    }

    if (paramPath.isArrayPattern() && hasRestElement(paramPath)) {
      const elements = paramPath.get("elements");

      for (let i = 0; i < elements.length; i++) {
        replaceRestElement(parentPath, elements[i]);
      }
    }

    if (paramPath.isObjectPattern() && hasRestElement(paramPath)) {
      const uid = parentPath.scope.generateUidIdentifier("ref");

      const declar = _core().types.variableDeclaration("let", [_core().types.variableDeclarator(paramPath.node, uid)]);

      parentPath.ensureBlock();
      parentPath.get("body").unshiftContainer("body", declar);
      paramPath.replaceWith(_core().types.cloneNode(uid));
    }
  }

  return {
    name: "proposal-object-rest-spread",
    inherits: _pluginSyntaxObjectRestSpread().default,
    visitor: {
      Function(path) {
        const params = path.get("params");

        for (let i = params.length - 1; i >= 0; i--) {
          replaceRestElement(params[i].parentPath, params[i]);
        }
      },

      VariableDeclarator(path, file) {
        if (!path.get("id").isObjectPattern()) {
          return;
        }

        let insertionPath = path;
        const originalPath = path;
        visitRestElements(path.get("id"), path => {
          if (!path.parentPath.isObjectPattern()) {
            return;
          }

          if (originalPath.node.id.properties.length > 1 && !_core().types.isIdentifier(originalPath.node.init)) {
            const initRef = path.scope.generateUidIdentifierBasedOnNode(originalPath.node.init, "ref");
            originalPath.insertBefore(_core().types.variableDeclarator(initRef, originalPath.node.init));
            originalPath.replaceWith(_core().types.variableDeclarator(originalPath.node.id, _core().types.cloneNode(initRef)));
            return;
          }

          let ref = originalPath.node.init;
          const refPropertyPath = [];
          let kind;
          path.findParent(path => {
            if (path.isObjectProperty()) {
              refPropertyPath.unshift(path.node.key.name);
            } else if (path.isVariableDeclarator()) {
              kind = path.parentPath.node.kind;
              return true;
            }
          });

          if (refPropertyPath.length) {
            refPropertyPath.forEach(prop => {
              ref = _core().types.memberExpression(ref, _core().types.identifier(prop));
            });
          }

          const objectPatternPath = path.findParent(path => path.isObjectPattern());
          const [impureComputedPropertyDeclarators, argument, callExpression] = createObjectSpread(objectPatternPath, file, ref);

          if (loose) {
            removeUnusedExcludedKeys(objectPatternPath);
          }

          _core().types.assertIdentifier(argument);

          insertionPath.insertBefore(impureComputedPropertyDeclarators);
          insertionPath.insertAfter(_core().types.variableDeclarator(argument, callExpression));
          insertionPath = insertionPath.getSibling(insertionPath.key + 1);
          path.scope.registerBinding(kind, insertionPath);

          if (objectPatternPath.node.properties.length === 0) {
            objectPatternPath.findParent(path => path.isObjectProperty() || path.isVariableDeclarator()).remove();
          }
        });
      },

      ExportNamedDeclaration(path) {
        const declaration = path.get("declaration");
        if (!declaration.isVariableDeclaration()) return;
        const hasRest = declaration.get("declarations").some(path => hasRestElement(path.get("id")));
        if (!hasRest) return;
        const specifiers = [];

        for (const name of Object.keys(path.getOuterBindingIdentifiers(path))) {
          specifiers.push(_core().types.exportSpecifier(_core().types.identifier(name), _core().types.identifier(name)));
        }

        path.replaceWith(declaration.node);
        path.insertAfter(_core().types.exportNamedDeclaration(null, specifiers));
      },

      CatchClause(path) {
        const paramPath = path.get("param");
        replaceRestElement(paramPath.parentPath, paramPath);
      },

      AssignmentExpression(path, file) {
        const leftPath = path.get("left");

        if (leftPath.isObjectPattern() && hasRestElement(leftPath)) {
          const nodes = [];
          const refName = path.scope.generateUidBasedOnNode(path.node.right, "ref");
          nodes.push(_core().types.variableDeclaration("var", [_core().types.variableDeclarator(_core().types.identifier(refName), path.node.right)]));
          const [impureComputedPropertyDeclarators, argument, callExpression] = createObjectSpread(leftPath, file, _core().types.identifier(refName));

          if (impureComputedPropertyDeclarators.length > 0) {
            nodes.push(_core().types.variableDeclaration("var", impureComputedPropertyDeclarators));
          }

          const nodeWithoutSpread = _core().types.cloneNode(path.node);

          nodeWithoutSpread.right = _core().types.identifier(refName);
          nodes.push(_core().types.expressionStatement(nodeWithoutSpread));
          nodes.push(_core().types.toStatement(_core().types.assignmentExpression("=", argument, callExpression)));
          nodes.push(_core().types.expressionStatement(_core().types.identifier(refName)));
          path.replaceWithMultiple(nodes);
        }
      },

      ForXStatement(path) {
        const {
          node,
          scope
        } = path;
        const leftPath = path.get("left");
        const left = node.left;

        if (!hasObjectPatternRestElement(leftPath)) {
          return;
        }

        if (!_core().types.isVariableDeclaration(left)) {
          const temp = scope.generateUidIdentifier("ref");
          node.left = _core().types.variableDeclaration("var", [_core().types.variableDeclarator(temp)]);
          path.ensureBlock();

          if (node.body.body.length === 0 && path.isCompletionRecord()) {
            node.body.body.unshift(_core().types.expressionStatement(scope.buildUndefinedNode()));
          }

          node.body.body.unshift(_core().types.expressionStatement(_core().types.assignmentExpression("=", left, _core().types.cloneNode(temp))));
        } else {
          const pattern = left.declarations[0].id;
          const key = scope.generateUidIdentifier("ref");
          node.left = _core().types.variableDeclaration(left.kind, [_core().types.variableDeclarator(key, null)]);
          path.ensureBlock();
          node.body.body.unshift(_core().types.variableDeclaration(node.left.kind, [_core().types.variableDeclarator(pattern, _core().types.cloneNode(key))]));
        }
      },

      ArrayPattern(path) {
        const objectPatterns = [];
        visitRestElements(path, path => {
          if (!path.parentPath.isObjectPattern()) {
            return;
          }

          const objectPattern = path.parentPath;
          const uid = path.scope.generateUidIdentifier("ref");
          objectPatterns.push(_core().types.variableDeclarator(objectPattern.node, uid));
          objectPattern.replaceWith(_core().types.cloneNode(uid));
          path.skip();
        });

        if (objectPatterns.length > 0) {
          const statementPath = path.getStatementParent();
          statementPath.insertAfter(_core().types.variableDeclaration(statementPath.node.kind || "var", objectPatterns));
        }
      },

      ObjectExpression(path, file) {
        if (!hasSpread(path.node)) return;
        const args = [];
        let props = [];

        function push() {
          args.push(_core().types.objectExpression(props));
          props = [];
        }

        for (const prop of path.node.properties) {
          if (_core().types.isSpreadElement(prop)) {
            push();
            args.push(prop.argument);
          } else {
            props.push(prop);
          }
        }

        if (props.length) {
          push();
        }

        let helper;

        if (loose) {
          helper = getExtendsHelper(file);
        } else {
          try {
            helper = file.addHelper("objectSpread2");
          } catch (_unused) {
            this.file.declarations["objectSpread2"] = null;
            helper = file.addHelper("objectSpread");
          }
        }

        path.replaceWith(_core().types.callExpression(helper, args));
      }

    }
  };
});

exports.default = _default;

/***/ }),
/* 24 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _assert = _interopRequireDefault(__webpack_require__(59));

var t = _interopRequireWildcard(__webpack_require__(978));

var _importBuilder = _interopRequireDefault(__webpack_require__(752));

var _isModule = _interopRequireDefault(__webpack_require__(916));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ImportInjector {
  constructor(path, importedSource, opts) {
    this._defaultOpts = {
      importedSource: null,
      importedType: "commonjs",
      importedInterop: "babel",
      importingInterop: "babel",
      ensureLiveReference: false,
      ensureNoContext: false
    };
    const programPath = path.find(p => p.isProgram());
    this._programPath = programPath;
    this._programScope = programPath.scope;
    this._hub = programPath.hub;
    this._defaultOpts = this._applyDefaults(importedSource, opts, true);
  }

  addDefault(importedSourceIn, opts) {
    return this.addNamed("default", importedSourceIn, opts);
  }

  addNamed(importName, importedSourceIn, opts) {
    (0, _assert.default)(typeof importName === "string");
    return this._generateImport(this._applyDefaults(importedSourceIn, opts), importName);
  }

  addNamespace(importedSourceIn, opts) {
    return this._generateImport(this._applyDefaults(importedSourceIn, opts), null);
  }

  addSideEffect(importedSourceIn, opts) {
    return this._generateImport(this._applyDefaults(importedSourceIn, opts), false);
  }

  _applyDefaults(importedSource, opts, isInit = false) {
    const optsList = [];

    if (typeof importedSource === "string") {
      optsList.push({
        importedSource
      });
      optsList.push(opts);
    } else {
      (0, _assert.default)(!opts, "Unexpected secondary arguments.");
      optsList.push(importedSource);
    }

    const newOpts = Object.assign({}, this._defaultOpts);

    for (const opts of optsList) {
      if (!opts) continue;
      Object.keys(newOpts).forEach(key => {
        if (opts[key] !== undefined) newOpts[key] = opts[key];
      });

      if (!isInit) {
        if (opts.nameHint !== undefined) newOpts.nameHint = opts.nameHint;
        if (opts.blockHoist !== undefined) newOpts.blockHoist = opts.blockHoist;
      }
    }

    return newOpts;
  }

  _generateImport(opts, importName) {
    const isDefault = importName === "default";
    const isNamed = !!importName && !isDefault;
    const isNamespace = importName === null;
    const {
      importedSource,
      importedType,
      importedInterop,
      importingInterop,
      ensureLiveReference,
      ensureNoContext,
      nameHint,
      blockHoist
    } = opts;
    let name = nameHint || importName;
    const isMod = (0, _isModule.default)(this._programPath);
    const isModuleForNode = isMod && importingInterop === "node";
    const isModuleForBabel = isMod && importingInterop === "babel";
    const builder = new _importBuilder.default(importedSource, this._programScope, this._hub);

    if (importedType === "es6") {
      if (!isModuleForNode && !isModuleForBabel) {
        throw new Error("Cannot import an ES6 module from CommonJS");
      }

      builder.import();

      if (isNamespace) {
        builder.namespace(nameHint || importedSource);
      } else if (isDefault || isNamed) {
        builder.named(name, importName);
      }
    } else if (importedType !== "commonjs") {
      throw new Error(`Unexpected interopType "${importedType}"`);
    } else if (importedInterop === "babel") {
      if (isModuleForNode) {
        name = name !== "default" ? name : importedSource;
        const es6Default = `${importedSource}$es6Default`;
        builder.import();

        if (isNamespace) {
          builder.default(es6Default).var(name || importedSource).wildcardInterop();
        } else if (isDefault) {
          if (ensureLiveReference) {
            builder.default(es6Default).var(name || importedSource).defaultInterop().read("default");
          } else {
            builder.default(es6Default).var(name).defaultInterop().prop(importName);
          }
        } else if (isNamed) {
          builder.default(es6Default).read(importName);
        }
      } else if (isModuleForBabel) {
        builder.import();

        if (isNamespace) {
          builder.namespace(name || importedSource);
        } else if (isDefault || isNamed) {
          builder.named(name, importName);
        }
      } else {
        builder.require();

        if (isNamespace) {
          builder.var(name || importedSource).wildcardInterop();
        } else if ((isDefault || isNamed) && ensureLiveReference) {
          if (isDefault) {
            name = name !== "default" ? name : importedSource;
            builder.var(name).read(importName);
            builder.defaultInterop();
          } else {
            builder.var(importedSource).read(importName);
          }
        } else if (isDefault) {
          builder.var(name).defaultInterop().prop(importName);
        } else if (isNamed) {
          builder.var(name).prop(importName);
        }
      }
    } else if (importedInterop === "compiled") {
      if (isModuleForNode) {
        builder.import();

        if (isNamespace) {
          builder.default(name || importedSource);
        } else if (isDefault || isNamed) {
          builder.default(importedSource).read(name);
        }
      } else if (isModuleForBabel) {
        builder.import();

        if (isNamespace) {
          builder.namespace(name || importedSource);
        } else if (isDefault || isNamed) {
          builder.named(name, importName);
        }
      } else {
        builder.require();

        if (isNamespace) {
          builder.var(name || importedSource);
        } else if (isDefault || isNamed) {
          if (ensureLiveReference) {
            builder.var(importedSource).read(name);
          } else {
            builder.prop(importName).var(name);
          }
        }
      }
    } else if (importedInterop === "uncompiled") {
      if (isDefault && ensureLiveReference) {
        throw new Error("No live reference for commonjs default");
      }

      if (isModuleForNode) {
        builder.import();

        if (isNamespace) {
          builder.default(name || importedSource);
        } else if (isDefault) {
          builder.default(name);
        } else if (isNamed) {
          builder.default(importedSource).read(name);
        }
      } else if (isModuleForBabel) {
        builder.import();

        if (isNamespace) {
          builder.default(name || importedSource);
        } else if (isDefault) {
          builder.default(name);
        } else if (isNamed) {
          builder.named(name, importName);
        }
      } else {
        builder.require();

        if (isNamespace) {
          builder.var(name || importedSource);
        } else if (isDefault) {
          builder.var(name);
        } else if (isNamed) {
          if (ensureLiveReference) {
            builder.var(importedSource).read(name);
          } else {
            builder.var(name).prop(importName);
          }
        }
      }
    } else {
      throw new Error(`Unknown importedInterop "${importedInterop}".`);
    }

    const {
      statements,
      resultName
    } = builder.done();

    this._insertStatements(statements, blockHoist);

    if ((isDefault || isNamed) && ensureNoContext && resultName.type !== "Identifier") {
      return t.sequenceExpression([t.numericLiteral(0), resultName]);
    }

    return resultName;
  }

  _insertStatements(statements, blockHoist = 3) {
    statements.forEach(node => {
      node._blockHoist = blockHoist;
    });

    const targetPath = this._programPath.get("body").find(p => {
      const val = p.node._blockHoist;
      return Number.isFinite(val) && val < 4;
    });

    if (targetPath) {
      targetPath.insertBefore(statements);
    } else {
      this._programPath.unshiftContainer("body", statements);
    }
  }

}

exports.default = ImportInjector;

/***/ }),
/* 25 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = __webpack_require__(57);

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

var _default = (0, _helperPluginUtils().declare)(api => {
  api.assertVersion(7);
  return {
    name: "syntax-async-generators",

    manipulateOptions(opts, parserOpts) {
      parserOpts.plugins.push("asyncGenerators");
    }

  };
});

exports.default = _default;

/***/ }),
/* 26 */,
/* 27 */,
/* 28 */,
/* 29 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = generateCode;

function _convertSourceMap() {
  const data = _interopRequireDefault(__webpack_require__(597));

  _convertSourceMap = function () {
    return data;
  };

  return data;
}

function _generator() {
  const data = _interopRequireDefault(__webpack_require__(33));

  _generator = function () {
    return data;
  };

  return data;
}

var _mergeMap = _interopRequireDefault(__webpack_require__(805));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function generateCode(pluginPasses, file) {
  const {
    opts,
    ast,
    code,
    inputMap
  } = file;
  const results = [];

  for (const plugins of pluginPasses) {
    for (const plugin of plugins) {
      const {
        generatorOverride
      } = plugin;

      if (generatorOverride) {
        const result = generatorOverride(ast, opts.generatorOpts, code, _generator().default);
        if (result !== undefined) results.push(result);
      }
    }
  }

  let result;

  if (results.length === 0) {
    result = (0, _generator().default)(ast, opts.generatorOpts, code);
  } else if (results.length === 1) {
    result = results[0];

    if (typeof result.then === "function") {
      throw new Error(`You appear to be using an async codegen plugin, ` + `which your current version of Babel does not support. ` + `If you're using a published plugin, ` + `you may need to upgrade your @babel/core version.`);
    }
  } else {
    throw new Error("More than one plugin attempted to override codegen.");
  }

  let {
    code: outputCode,
    map: outputMap
  } = result;

  if (outputMap && inputMap) {
    outputMap = (0, _mergeMap.default)(inputMap.toObject(), outputMap);
  }

  if (opts.sourceMaps === "inline" || opts.sourceMaps === "both") {
    outputCode += "\n" + _convertSourceMap().default.fromObject(outputMap).toComment();
  }

  if (opts.sourceMaps === "inline") {
    outputMap = null;
  }

  return {
    outputCode,
    outputMap
  };
}

/***/ }),
/* 30 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseIsRegExp = __webpack_require__(109),
    baseUnary = __webpack_require__(231),
    nodeUtil = __webpack_require__(616);

/* Node.js helper references. */
var nodeIsRegExp = nodeUtil && nodeUtil.isRegExp;

/**
 * Checks if `value` is classified as a `RegExp` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a regexp, else `false`.
 * @example
 *
 * _.isRegExp(/abc/);
 * // => true
 *
 * _.isRegExp('/abc/');
 * // => false
 */
var isRegExp = nodeIsRegExp ? baseUnary(nodeIsRegExp) : baseIsRegExp;

module.exports = isRegExp;


/***/ }),
/* 31 */,
/* 32 */,
/* 33 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
exports.CodeGenerator = void 0;

var _sourceMap = _interopRequireDefault(__webpack_require__(801));

var _printer = _interopRequireDefault(__webpack_require__(344));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Generator extends _printer.default {
  constructor(ast, opts = {}, code) {
    const format = normalizeOptions(code, opts);
    const map = opts.sourceMaps ? new _sourceMap.default(opts, code) : null;
    super(format, map);
    this.ast = ast;
  }

  generate() {
    return super.generate(this.ast);
  }

}

function normalizeOptions(code, opts) {
  const format = {
    auxiliaryCommentBefore: opts.auxiliaryCommentBefore,
    auxiliaryCommentAfter: opts.auxiliaryCommentAfter,
    shouldPrintComment: opts.shouldPrintComment,
    retainLines: opts.retainLines,
    retainFunctionParens: opts.retainFunctionParens,
    comments: opts.comments == null || opts.comments,
    compact: opts.compact,
    minified: opts.minified,
    concise: opts.concise,
    jsonCompatibleStrings: opts.jsonCompatibleStrings,
    indent: {
      adjustMultilineComment: true,
      style: "  ",
      base: 0
    },
    decoratorsBeforeExport: !!opts.decoratorsBeforeExport,
    jsescOption: Object.assign({
      quotes: "double",
      wrap: true
    }, opts.jsescOption)
  };

  if (format.minified) {
    format.compact = true;

    format.shouldPrintComment = format.shouldPrintComment || (() => format.comments);
  } else {
    format.shouldPrintComment = format.shouldPrintComment || (value => format.comments || value.indexOf("@license") >= 0 || value.indexOf("@preserve") >= 0);
  }

  if (format.compact === "auto") {
    format.compact = code.length > 500000;

    if (format.compact) {
      console.error("[BABEL] Note: The code generator has deoptimised the styling of " + `${opts.filename} as it exceeds the max of ${"500KB"}.`);
    }
  }

  if (format.compact) {
    format.indent.adjustMultilineComment = false;
  }

  return format;
}

class CodeGenerator {
  constructor(ast, opts, code) {
    this._generator = new Generator(ast, opts, code);
  }

  generate() {
    return this._generator.generate();
  }

}

exports.CodeGenerator = CodeGenerator;

function _default(ast, opts, code) {
  const gen = new Generator(ast, opts, code);
  return gen.generate();
}

/***/ }),
/* 34 */
/***/ (function(module) {

/**
 * A specialized version of `_.indexOf` which performs strict equality
 * comparisons of values, i.e. `===`.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function strictIndexOf(array, value, fromIndex) {
  var index = fromIndex - 1,
      length = array.length;

  while (++index < length) {
    if (array[index] === value) {
      return index;
    }
  }
  return -1;
}

module.exports = strictIndexOf;


/***/ }),
/* 35 */
/***/ (function(module, __unusedexports, __webpack_require__) {

"use strict";

const { coerce, lte } = __webpack_require__(676);
const modulesByVersions = __webpack_require__(519);

module.exports = function (raw) {
  const corejs = coerce(String(raw));
  if (corejs.major !== 3) {
    throw RangeError('This version of `core-js-compat` works only with `core-js@3`.');
  }
  const result = [];
  for (const version of Object.keys(modulesByVersions)) {
    if (lte(coerce(version), corejs)) {
      result.push(...modulesByVersions[version]);
    }
  }
  return result;
};


/***/ }),
/* 36 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


var util = _interopRequireWildcard(__webpack_require__(930));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

/**
 * Copyright (c) 2014-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var hasOwn = Object.prototype.hasOwnProperty; // The hoist function takes a FunctionExpression or FunctionDeclaration
// and replaces any Declaration nodes in its body with assignments, then
// returns a VariableDeclaration containing just the names of the removed
// declarations.

exports.hoist = function (funPath) {
  var t = util.getTypes();
  t.assertFunction(funPath.node);
  var vars = {};

  function varDeclToExpr(_ref, includeIdentifiers) {
    var vdec = _ref.node,
        scope = _ref.scope;
    t.assertVariableDeclaration(vdec); // TODO assert.equal(vdec.kind, "var");

    var exprs = [];
    vdec.declarations.forEach(function (dec) {
      // Note: We duplicate 'dec.id' here to ensure that the variable declaration IDs don't
      // have the same 'loc' value, since that can make sourcemaps and retainLines behave poorly.
      vars[dec.id.name] = t.identifier(dec.id.name); // Remove the binding, to avoid "duplicate declaration" errors when it will
      // be injected again.

      scope.removeBinding(dec.id.name);

      if (dec.init) {
        exprs.push(t.assignmentExpression("=", dec.id, dec.init));
      } else if (includeIdentifiers) {
        exprs.push(dec.id);
      }
    });
    if (exprs.length === 0) return null;
    if (exprs.length === 1) return exprs[0];
    return t.sequenceExpression(exprs);
  }

  funPath.get("body").traverse({
    VariableDeclaration: {
      exit: function exit(path) {
        var expr = varDeclToExpr(path, false);

        if (expr === null) {
          path.remove();
        } else {
          // We don't need to traverse this expression any further because
          // there can't be any new declarations inside an expression.
          util.replaceWithOrRemove(path, t.expressionStatement(expr));
        } // Since the original node has been either removed or replaced,
        // avoid traversing it any further.


        path.skip();
      }
    },
    ForStatement: function ForStatement(path) {
      var init = path.get("init");

      if (init.isVariableDeclaration()) {
        util.replaceWithOrRemove(init, varDeclToExpr(init, false));
      }
    },
    ForXStatement: function ForXStatement(path) {
      var left = path.get("left");

      if (left.isVariableDeclaration()) {
        util.replaceWithOrRemove(left, varDeclToExpr(left, true));
      }
    },
    FunctionDeclaration: function FunctionDeclaration(path) {
      var node = path.node;
      vars[node.id.name] = node.id;
      var assignment = t.expressionStatement(t.assignmentExpression("=", t.clone(node.id), t.functionExpression(path.scope.generateUidIdentifierBasedOnNode(node), node.params, node.body, node.generator, node.expression)));

      if (path.parentPath.isBlockStatement()) {
        // Insert the assignment form before the first statement in the
        // enclosing block.
        path.parentPath.unshiftContainer("body", assignment); // Remove the function declaration now that we've inserted the
        // equivalent assignment form at the beginning of the block.

        path.remove();
      } else {
        // If the parent node is not a block statement, then we can just
        // replace the declaration with the equivalent assignment form
        // without worrying about hoisting it.
        util.replaceWithOrRemove(path, assignment);
      } // Remove the binding, to avoid "duplicate declaration" errors when it will
      // be injected again.


      path.scope.removeBinding(node.id.name); // Don't hoist variables out of inner functions.

      path.skip();
    },
    FunctionExpression: function FunctionExpression(path) {
      // Don't descend into nested function expressions.
      path.skip();
    },
    ArrowFunctionExpression: function ArrowFunctionExpression(path) {
      // Don't descend into nested function expressions.
      path.skip();
    }
  });
  var paramNames = {};
  funPath.get("params").forEach(function (paramPath) {
    var param = paramPath.node;

    if (t.isIdentifier(param)) {
      paramNames[param.name] = param;
    } else {// Variables declared by destructuring parameter patterns will be
      // harmlessly re-declared.
    }
  });
  var declarations = [];
  Object.keys(vars).forEach(function (name) {
    if (!hasOwn.call(paramNames, name)) {
      declarations.push(t.variableDeclarator(vars[name], null));
    }
  });

  if (declarations.length === 0) {
    return null; // Be sure to handle this case!
  }

  return t.variableDeclaration("var", declarations);
};

/***/ }),
/* 37 */,
/* 38 */,
/* 39 */
/***/ (function(__unusedmodule, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TargetNames = exports.UseBuiltInsOption = exports.ModulesOption = exports.TopLevelOptions = void 0;
const TopLevelOptions = {
  configPath: "configPath",
  corejs: "corejs",
  debug: "debug",
  exclude: "exclude",
  forceAllTransforms: "forceAllTransforms",
  ignoreBrowserslistConfig: "ignoreBrowserslistConfig",
  include: "include",
  loose: "loose",
  modules: "modules",
  shippedProposals: "shippedProposals",
  spec: "spec",
  targets: "targets",
  useBuiltIns: "useBuiltIns"
};
exports.TopLevelOptions = TopLevelOptions;
const ModulesOption = {
  false: false,
  auto: "auto",
  amd: "amd",
  commonjs: "commonjs",
  cjs: "cjs",
  systemjs: "systemjs",
  umd: "umd"
};
exports.ModulesOption = ModulesOption;
const UseBuiltInsOption = {
  false: false,
  entry: "entry",
  usage: "usage"
};
exports.UseBuiltInsOption = UseBuiltInsOption;
const TargetNames = {
  esmodules: "esmodules",
  node: "node",
  browsers: "browsers",
  chrome: "chrome",
  opera: "opera",
  edge: "edge",
  firefox: "firefox",
  safari: "safari",
  ie: "ie",
  ios: "ios",
  android: "android",
  electron: "electron",
  samsung: "samsung",
  uglify: "uglify"
};
exports.TargetNames = TargetNames;

/***/ }),
/* 40 */
/***/ (function(__unusedmodule, __unusedexports, __webpack_require__) {

"use strict";


var _utils = _interopRequireWildcard(__webpack_require__(138));

var _placeholders = __webpack_require__(807);

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

(0, _utils.default)("Noop", {
  visitor: []
});
(0, _utils.default)("Placeholder", {
  visitor: [],
  builder: ["expectedNode", "name"],
  fields: {
    name: {
      validate: (0, _utils.assertNodeType)("Identifier")
    },
    expectedNode: {
      validate: (0, _utils.assertOneOf)(..._placeholders.PLACEHOLDERS)
    }
  }
});
(0, _utils.default)("V8IntrinsicIdentifier", {
  builder: ["name"],
  fields: {
    name: {
      validate: (0, _utils.assertValueType)("string")
    }
  }
});

/***/ }),
/* 41 */,
/* 42 */,
/* 43 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VariableDeclarator = VariableDeclarator;
exports.TypeCastExpression = TypeCastExpression;
exports.NewExpression = NewExpression;
exports.TemplateLiteral = TemplateLiteral;
exports.UnaryExpression = UnaryExpression;
exports.BinaryExpression = BinaryExpression;
exports.LogicalExpression = LogicalExpression;
exports.ConditionalExpression = ConditionalExpression;
exports.SequenceExpression = SequenceExpression;
exports.ParenthesizedExpression = ParenthesizedExpression;
exports.AssignmentExpression = AssignmentExpression;
exports.UpdateExpression = UpdateExpression;
exports.StringLiteral = StringLiteral;
exports.NumericLiteral = NumericLiteral;
exports.BooleanLiteral = BooleanLiteral;
exports.NullLiteral = NullLiteral;
exports.RegExpLiteral = RegExpLiteral;
exports.ObjectExpression = ObjectExpression;
exports.ArrayExpression = ArrayExpression;
exports.RestElement = RestElement;
exports.ClassDeclaration = exports.ClassExpression = exports.FunctionDeclaration = exports.ArrowFunctionExpression = exports.FunctionExpression = Func;
exports.CallExpression = CallExpression;
exports.TaggedTemplateExpression = TaggedTemplateExpression;
Object.defineProperty(exports, "Identifier", {
  enumerable: true,
  get: function () {
    return _infererReference.default;
  }
});

var t = _interopRequireWildcard(__webpack_require__(978));

var _infererReference = _interopRequireDefault(__webpack_require__(205));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function VariableDeclarator() {
  const id = this.get("id");
  if (!id.isIdentifier()) return;
  const init = this.get("init");
  let type = init.getTypeAnnotation();

  if (type && type.type === "AnyTypeAnnotation") {
    if (init.isCallExpression() && init.get("callee").isIdentifier({
      name: "Array"
    }) && !init.scope.hasBinding("Array", true)) {
      type = ArrayExpression();
    }
  }

  return type;
}

function TypeCastExpression(node) {
  return node.typeAnnotation;
}

TypeCastExpression.validParent = true;

function NewExpression(node) {
  if (this.get("callee").isIdentifier()) {
    return t.genericTypeAnnotation(node.callee);
  }
}

function TemplateLiteral() {
  return t.stringTypeAnnotation();
}

function UnaryExpression(node) {
  const operator = node.operator;

  if (operator === "void") {
    return t.voidTypeAnnotation();
  } else if (t.NUMBER_UNARY_OPERATORS.indexOf(operator) >= 0) {
    return t.numberTypeAnnotation();
  } else if (t.STRING_UNARY_OPERATORS.indexOf(operator) >= 0) {
    return t.stringTypeAnnotation();
  } else if (t.BOOLEAN_UNARY_OPERATORS.indexOf(operator) >= 0) {
    return t.booleanTypeAnnotation();
  }
}

function BinaryExpression(node) {
  const operator = node.operator;

  if (t.NUMBER_BINARY_OPERATORS.indexOf(operator) >= 0) {
    return t.numberTypeAnnotation();
  } else if (t.BOOLEAN_BINARY_OPERATORS.indexOf(operator) >= 0) {
    return t.booleanTypeAnnotation();
  } else if (operator === "+") {
    const right = this.get("right");
    const left = this.get("left");

    if (left.isBaseType("number") && right.isBaseType("number")) {
      return t.numberTypeAnnotation();
    } else if (left.isBaseType("string") || right.isBaseType("string")) {
      return t.stringTypeAnnotation();
    }

    return t.unionTypeAnnotation([t.stringTypeAnnotation(), t.numberTypeAnnotation()]);
  }
}

function LogicalExpression() {
  return t.createUnionTypeAnnotation([this.get("left").getTypeAnnotation(), this.get("right").getTypeAnnotation()]);
}

function ConditionalExpression() {
  return t.createUnionTypeAnnotation([this.get("consequent").getTypeAnnotation(), this.get("alternate").getTypeAnnotation()]);
}

function SequenceExpression() {
  return this.get("expressions").pop().getTypeAnnotation();
}

function ParenthesizedExpression() {
  return this.get("expression").getTypeAnnotation();
}

function AssignmentExpression() {
  return this.get("right").getTypeAnnotation();
}

function UpdateExpression(node) {
  const operator = node.operator;

  if (operator === "++" || operator === "--") {
    return t.numberTypeAnnotation();
  }
}

function StringLiteral() {
  return t.stringTypeAnnotation();
}

function NumericLiteral() {
  return t.numberTypeAnnotation();
}

function BooleanLiteral() {
  return t.booleanTypeAnnotation();
}

function NullLiteral() {
  return t.nullLiteralTypeAnnotation();
}

function RegExpLiteral() {
  return t.genericTypeAnnotation(t.identifier("RegExp"));
}

function ObjectExpression() {
  return t.genericTypeAnnotation(t.identifier("Object"));
}

function ArrayExpression() {
  return t.genericTypeAnnotation(t.identifier("Array"));
}

function RestElement() {
  return ArrayExpression();
}

RestElement.validParent = true;

function Func() {
  return t.genericTypeAnnotation(t.identifier("Function"));
}

const isArrayFrom = t.buildMatchMemberExpression("Array.from");
const isObjectKeys = t.buildMatchMemberExpression("Object.keys");
const isObjectValues = t.buildMatchMemberExpression("Object.values");
const isObjectEntries = t.buildMatchMemberExpression("Object.entries");

function CallExpression() {
  const {
    callee
  } = this.node;

  if (isObjectKeys(callee)) {
    return t.arrayTypeAnnotation(t.stringTypeAnnotation());
  } else if (isArrayFrom(callee) || isObjectValues(callee)) {
    return t.arrayTypeAnnotation(t.anyTypeAnnotation());
  } else if (isObjectEntries(callee)) {
    return t.arrayTypeAnnotation(t.tupleTypeAnnotation([t.stringTypeAnnotation(), t.anyTypeAnnotation()]));
  }

  return resolveCall(this.get("callee"));
}

function TaggedTemplateExpression() {
  return resolveCall(this.get("tag"));
}

function resolveCall(callee) {
  callee = callee.resolve();

  if (callee.isFunction()) {
    if (callee.is("async")) {
      if (callee.is("generator")) {
        return t.genericTypeAnnotation(t.identifier("AsyncIterator"));
      } else {
        return t.genericTypeAnnotation(t.identifier("Promise"));
      }
    } else {
      if (callee.node.returnType) {
        return callee.node.returnType;
      } else {}
    }
  }
}

/***/ }),
/* 44 */,
/* 45 */,
/* 46 */,
/* 47 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _core = __webpack_require__(278);

const buildForAwait = (0, _core.template)(`
  async function wrapper() {
    var ITERATOR_COMPLETION = true;
    var ITERATOR_HAD_ERROR_KEY = false;
    var ITERATOR_ERROR_KEY;
    try {
      for (
        var ITERATOR_KEY = GET_ITERATOR(OBJECT), STEP_KEY, STEP_VALUE;
        (
          STEP_KEY = await ITERATOR_KEY.next(),
          ITERATOR_COMPLETION = STEP_KEY.done,
          STEP_VALUE = await STEP_KEY.value,
          !ITERATOR_COMPLETION
        );
        ITERATOR_COMPLETION = true) {
      }
    } catch (err) {
      ITERATOR_HAD_ERROR_KEY = true;
      ITERATOR_ERROR_KEY = err;
    } finally {
      try {
        if (!ITERATOR_COMPLETION && ITERATOR_KEY.return != null) {
          await ITERATOR_KEY.return();
        }
      } finally {
        if (ITERATOR_HAD_ERROR_KEY) {
          throw ITERATOR_ERROR_KEY;
        }
      }
    }
  }
`);

function _default(path, {
  getAsyncIterator
}) {
  const {
    node,
    scope,
    parent
  } = path;
  const stepKey = scope.generateUidIdentifier("step");
  const stepValue = scope.generateUidIdentifier("value");
  const left = node.left;
  let declar;

  if (_core.types.isIdentifier(left) || _core.types.isPattern(left) || _core.types.isMemberExpression(left)) {
    declar = _core.types.expressionStatement(_core.types.assignmentExpression("=", left, stepValue));
  } else if (_core.types.isVariableDeclaration(left)) {
    declar = _core.types.variableDeclaration(left.kind, [_core.types.variableDeclarator(left.declarations[0].id, stepValue)]);
  }

  let template = buildForAwait({
    ITERATOR_HAD_ERROR_KEY: scope.generateUidIdentifier("didIteratorError"),
    ITERATOR_COMPLETION: scope.generateUidIdentifier("iteratorNormalCompletion"),
    ITERATOR_ERROR_KEY: scope.generateUidIdentifier("iteratorError"),
    ITERATOR_KEY: scope.generateUidIdentifier("iterator"),
    GET_ITERATOR: getAsyncIterator,
    OBJECT: node.right,
    STEP_VALUE: stepValue,
    STEP_KEY: stepKey
  });
  template = template.body.body;

  const isLabeledParent = _core.types.isLabeledStatement(parent);

  const tryBody = template[3].block.body;
  const loop = tryBody[0];

  if (isLabeledParent) {
    tryBody[0] = _core.types.labeledStatement(parent.label, loop);
  }

  return {
    replaceParent: isLabeledParent,
    node: template,
    declar,
    loop
  };
}

/***/ }),
/* 48 */
/***/ (function(module) {

/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

module.exports = stubArray;


/***/ }),
/* 49 */,
/* 50 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = __webpack_require__(57);

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

function regex() {
  const data = _interopRequireWildcard(__webpack_require__(106));

  regex = function () {
    return data;
  };

  return data;
}

function _core() {
  const data = __webpack_require__(278);

  _core = function () {
    return data;
  };

  return data;
}

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

var _default = (0, _helperPluginUtils().declare)(api => {
  api.assertVersion(7);
  return {
    name: "transform-sticky-regex",
    visitor: {
      RegExpLiteral(path) {
        const {
          node
        } = path;
        if (!regex().is(node, "y")) return;
        path.replaceWith(_core().types.newExpression(_core().types.identifier("RegExp"), [_core().types.stringLiteral(node.pattern), _core().types.stringLiteral(node.flags)]));
      }

    }
  };
});

exports.default = _default;

/***/ }),
/* 51 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var Symbol = __webpack_require__(498),
    getRawTag = __webpack_require__(985),
    objectToString = __webpack_require__(602);

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ }),
/* 52 */,
/* 53 */,
/* 54 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

var SourceMapGenerator = __webpack_require__(454).SourceMapGenerator;
var util = __webpack_require__(290);

// Matches a Windows-style `\r\n` newline or a `\n` newline used by all other
// operating systems these days (capturing the result).
var REGEX_NEWLINE = /(\r?\n)/;

// Newline character code for charCodeAt() comparisons
var NEWLINE_CODE = 10;

// Private symbol for identifying `SourceNode`s when multiple versions of
// the source-map library are loaded. This MUST NOT CHANGE across
// versions!
var isSourceNode = "$$$isSourceNode$$$";

/**
 * SourceNodes provide a way to abstract over interpolating/concatenating
 * snippets of generated JavaScript source code while maintaining the line and
 * column information associated with the original source code.
 *
 * @param aLine The original line number.
 * @param aColumn The original column number.
 * @param aSource The original source's filename.
 * @param aChunks Optional. An array of strings which are snippets of
 *        generated JS, or other SourceNodes.
 * @param aName The original identifier.
 */
function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
  this.children = [];
  this.sourceContents = {};
  this.line = aLine == null ? null : aLine;
  this.column = aColumn == null ? null : aColumn;
  this.source = aSource == null ? null : aSource;
  this.name = aName == null ? null : aName;
  this[isSourceNode] = true;
  if (aChunks != null) this.add(aChunks);
}

/**
 * Creates a SourceNode from generated code and a SourceMapConsumer.
 *
 * @param aGeneratedCode The generated code
 * @param aSourceMapConsumer The SourceMap for the generated code
 * @param aRelativePath Optional. The path that relative sources in the
 *        SourceMapConsumer should be relative to.
 */
SourceNode.fromStringWithSourceMap =
  function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
    // The SourceNode we want to fill with the generated code
    // and the SourceMap
    var node = new SourceNode();

    // All even indices of this array are one line of the generated code,
    // while all odd indices are the newlines between two adjacent lines
    // (since `REGEX_NEWLINE` captures its match).
    // Processed fragments are accessed by calling `shiftNextLine`.
    var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
    var remainingLinesIndex = 0;
    var shiftNextLine = function() {
      var lineContents = getNextLine();
      // The last line of a file might not have a newline.
      var newLine = getNextLine() || "";
      return lineContents + newLine;

      function getNextLine() {
        return remainingLinesIndex < remainingLines.length ?
            remainingLines[remainingLinesIndex++] : undefined;
      }
    };

    // We need to remember the position of "remainingLines"
    var lastGeneratedLine = 1, lastGeneratedColumn = 0;

    // The generate SourceNodes we need a code range.
    // To extract it current and last mapping is used.
    // Here we store the last mapping.
    var lastMapping = null;

    aSourceMapConsumer.eachMapping(function (mapping) {
      if (lastMapping !== null) {
        // We add the code from "lastMapping" to "mapping":
        // First check if there is a new line in between.
        if (lastGeneratedLine < mapping.generatedLine) {
          // Associate first line with "lastMapping"
          addMappingWithCode(lastMapping, shiftNextLine());
          lastGeneratedLine++;
          lastGeneratedColumn = 0;
          // The remaining code is added without mapping
        } else {
          // There is no new line in between.
          // Associate the code between "lastGeneratedColumn" and
          // "mapping.generatedColumn" with "lastMapping"
          var nextLine = remainingLines[remainingLinesIndex];
          var code = nextLine.substr(0, mapping.generatedColumn -
                                        lastGeneratedColumn);
          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn -
                                              lastGeneratedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
          addMappingWithCode(lastMapping, code);
          // No more remaining code, continue
          lastMapping = mapping;
          return;
        }
      }
      // We add the generated code until the first mapping
      // to the SourceNode without any mapping.
      // Each line is added as separate string.
      while (lastGeneratedLine < mapping.generatedLine) {
        node.add(shiftNextLine());
        lastGeneratedLine++;
      }
      if (lastGeneratedColumn < mapping.generatedColumn) {
        var nextLine = remainingLines[remainingLinesIndex];
        node.add(nextLine.substr(0, mapping.generatedColumn));
        remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
        lastGeneratedColumn = mapping.generatedColumn;
      }
      lastMapping = mapping;
    }, this);
    // We have processed all mappings.
    if (remainingLinesIndex < remainingLines.length) {
      if (lastMapping) {
        // Associate the remaining code in the current line with "lastMapping"
        addMappingWithCode(lastMapping, shiftNextLine());
      }
      // and add the remaining lines without any mapping
      node.add(remainingLines.splice(remainingLinesIndex).join(""));
    }

    // Copy sourcesContent into SourceNode
    aSourceMapConsumer.sources.forEach(function (sourceFile) {
      var content = aSourceMapConsumer.sourceContentFor(sourceFile);
      if (content != null) {
        if (aRelativePath != null) {
          sourceFile = util.join(aRelativePath, sourceFile);
        }
        node.setSourceContent(sourceFile, content);
      }
    });

    return node;

    function addMappingWithCode(mapping, code) {
      if (mapping === null || mapping.source === undefined) {
        node.add(code);
      } else {
        var source = aRelativePath
          ? util.join(aRelativePath, mapping.source)
          : mapping.source;
        node.add(new SourceNode(mapping.originalLine,
                                mapping.originalColumn,
                                source,
                                code,
                                mapping.name));
      }
    }
  };

/**
 * Add a chunk of generated JS to this source node.
 *
 * @param aChunk A string snippet of generated JS code, another instance of
 *        SourceNode, or an array where each member is one of those things.
 */
SourceNode.prototype.add = function SourceNode_add(aChunk) {
  if (Array.isArray(aChunk)) {
    aChunk.forEach(function (chunk) {
      this.add(chunk);
    }, this);
  }
  else if (aChunk[isSourceNode] || typeof aChunk === "string") {
    if (aChunk) {
      this.children.push(aChunk);
    }
  }
  else {
    throw new TypeError(
      "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
    );
  }
  return this;
};

/**
 * Add a chunk of generated JS to the beginning of this source node.
 *
 * @param aChunk A string snippet of generated JS code, another instance of
 *        SourceNode, or an array where each member is one of those things.
 */
SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
  if (Array.isArray(aChunk)) {
    for (var i = aChunk.length-1; i >= 0; i--) {
      this.prepend(aChunk[i]);
    }
  }
  else if (aChunk[isSourceNode] || typeof aChunk === "string") {
    this.children.unshift(aChunk);
  }
  else {
    throw new TypeError(
      "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
    );
  }
  return this;
};

/**
 * Walk over the tree of JS snippets in this node and its children. The
 * walking function is called once for each snippet of JS and is passed that
 * snippet and the its original associated source's line/column location.
 *
 * @param aFn The traversal function.
 */
SourceNode.prototype.walk = function SourceNode_walk(aFn) {
  var chunk;
  for (var i = 0, len = this.children.length; i < len; i++) {
    chunk = this.children[i];
    if (chunk[isSourceNode]) {
      chunk.walk(aFn);
    }
    else {
      if (chunk !== '') {
        aFn(chunk, { source: this.source,
                     line: this.line,
                     column: this.column,
                     name: this.name });
      }
    }
  }
};

/**
 * Like `String.prototype.join` except for SourceNodes. Inserts `aStr` between
 * each of `this.children`.
 *
 * @param aSep The separator.
 */
SourceNode.prototype.join = function SourceNode_join(aSep) {
  var newChildren;
  var i;
  var len = this.children.length;
  if (len > 0) {
    newChildren = [];
    for (i = 0; i < len-1; i++) {
      newChildren.push(this.children[i]);
      newChildren.push(aSep);
    }
    newChildren.push(this.children[i]);
    this.children = newChildren;
  }
  return this;
};

/**
 * Call String.prototype.replace on the very right-most source snippet. Useful
 * for trimming whitespace from the end of a source node, etc.
 *
 * @param aPattern The pattern to replace.
 * @param aReplacement The thing to replace the pattern with.
 */
SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
  var lastChild = this.children[this.children.length - 1];
  if (lastChild[isSourceNode]) {
    lastChild.replaceRight(aPattern, aReplacement);
  }
  else if (typeof lastChild === 'string') {
    this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
  }
  else {
    this.children.push(''.replace(aPattern, aReplacement));
  }
  return this;
};

/**
 * Set the source content for a source file. This will be added to the SourceMapGenerator
 * in the sourcesContent field.
 *
 * @param aSourceFile The filename of the source file
 * @param aSourceContent The content of the source file
 */
SourceNode.prototype.setSourceContent =
  function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
    this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
  };

/**
 * Walk over the tree of SourceNodes. The walking function is called for each
 * source file content and is passed the filename and source content.
 *
 * @param aFn The traversal function.
 */
SourceNode.prototype.walkSourceContents =
  function SourceNode_walkSourceContents(aFn) {
    for (var i = 0, len = this.children.length; i < len; i++) {
      if (this.children[i][isSourceNode]) {
        this.children[i].walkSourceContents(aFn);
      }
    }

    var sources = Object.keys(this.sourceContents);
    for (var i = 0, len = sources.length; i < len; i++) {
      aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
    }
  };

/**
 * Return the string representation of this source node. Walks over the tree
 * and concatenates all the various snippets together to one string.
 */
SourceNode.prototype.toString = function SourceNode_toString() {
  var str = "";
  this.walk(function (chunk) {
    str += chunk;
  });
  return str;
};

/**
 * Returns the string representation of this source node along with a source
 * map.
 */
SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
  var generated = {
    code: "",
    line: 1,
    column: 0
  };
  var map = new SourceMapGenerator(aArgs);
  var sourceMappingActive = false;
  var lastOriginalSource = null;
  var lastOriginalLine = null;
  var lastOriginalColumn = null;
  var lastOriginalName = null;
  this.walk(function (chunk, original) {
    generated.code += chunk;
    if (original.source !== null
        && original.line !== null
        && original.column !== null) {
      if(lastOriginalSource !== original.source
         || lastOriginalLine !== original.line
         || lastOriginalColumn !== original.column
         || lastOriginalName !== original.name) {
        map.addMapping({
          source: original.source,
          original: {
            line: original.line,
            column: original.column
          },
          generated: {
            line: generated.line,
            column: generated.column
          },
          name: original.name
        });
      }
      lastOriginalSource = original.source;
      lastOriginalLine = original.line;
      lastOriginalColumn = original.column;
      lastOriginalName = original.name;
      sourceMappingActive = true;
    } else if (sourceMappingActive) {
      map.addMapping({
        generated: {
          line: generated.line,
          column: generated.column
        }
      });
      lastOriginalSource = null;
      sourceMappingActive = false;
    }
    for (var idx = 0, length = chunk.length; idx < length; idx++) {
      if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
        generated.line++;
        generated.column = 0;
        // Mappings end at eol
        if (idx + 1 === length) {
          lastOriginalSource = null;
          sourceMappingActive = false;
        } else if (sourceMappingActive) {
          map.addMapping({
            source: original.source,
            original: {
              line: original.line,
              column: original.column
            },
            generated: {
              line: generated.line,
              column: generated.column
            },
            name: original.name
          });
        }
      } else {
        generated.column++;
      }
    }
  });
  this.walkSourceContents(function (sourceFile, sourceContent) {
    map.setSourceContent(sourceFile, sourceContent);
  });

  return { code: generated.code, map: map };
};

exports.SourceNode = SourceNode;


/***/ }),
/* 55 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = __webpack_require__(57);

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

var _default = (0, _helperPluginUtils().declare)(api => {
  api.assertVersion(7);
  return {
    name: "transform-literals",
    visitor: {
      NumericLiteral({
        node
      }) {
        if (node.extra && /^0[ob]/i.test(node.extra.raw)) {
          node.extra = undefined;
        }
      },

      StringLiteral({
        node
      }) {
        if (node.extra && /\\[u]/gi.test(node.extra.raw)) {
          node.extra = undefined;
        }
      }

    }
  };
});

exports.default = _default;

/***/ }),
/* 56 */,
/* 57 */
/***/ (function(__unusedmodule, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.declare = declare;

function declare(builder) {
  return (api, options, dirname) => {
    if (!api.assertVersion) {
      api = Object.assign(copyApiObject(api), {
        assertVersion(range) {
          throwVersionError(range, api.version);
        }

      });
    }

    return builder(api, options || {}, dirname);
  };
}

function copyApiObject(api) {
  let proto = null;

  if (typeof api.version === "string" && /^7\./.test(api.version)) {
    proto = Object.getPrototypeOf(api);

    if (proto && (!has(proto, "version") || !has(proto, "transform") || !has(proto, "template") || !has(proto, "types"))) {
      proto = null;
    }
  }

  return Object.assign({}, proto, api);
}

function has(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
}

function throwVersionError(range, version) {
  if (typeof range === "number") {
    if (!Number.isInteger(range)) {
      throw new Error("Expected string or integer value.");
    }

    range = `^${range}.0.0-0`;
  }

  if (typeof range !== "string") {
    throw new Error("Expected string or integer value.");
  }

  const limit = Error.stackTraceLimit;

  if (typeof limit === "number" && limit < 25) {
    Error.stackTraceLimit = 25;
  }

  let err;

  if (version.slice(0, 2) === "7.") {
    err = new Error(`Requires Babel "^7.0.0-beta.41", but was loaded with "${version}". ` + `You'll need to update your @babel/core version.`);
  } else {
    err = new Error(`Requires Babel "${range}", but was loaded with "${version}". ` + `If you are sure you have a compatible version of @babel/core, ` + `it is likely that something in your build process is loading the ` + `wrong version. Inspect the stack trace of this error to look for ` + `the first entry that doesn't mention "@babel/core" or "babel-core" ` + `to see what is calling Babel.`);
  }

  if (typeof limit === "number") {
    Error.stackTraceLimit = limit;
  }

  throw Object.assign(err, {
    code: "BABEL_VERSION_UNSUPPORTED",
    version,
    range
  });
}

/***/ }),
/* 58 */
/***/ (function(module, __unusedexports, __webpack_require__) {

/*
  Copyright (C) 2013 Yusuke Suzuki <utatane.tea@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

(function () {
    'use strict';

    var code = __webpack_require__(613);

    function isStrictModeReservedWordES6(id) {
        switch (id) {
        case 'implements':
        case 'interface':
        case 'package':
        case 'private':
        case 'protected':
        case 'public':
        case 'static':
        case 'let':
            return true;
        default:
            return false;
        }
    }

    function isKeywordES5(id, strict) {
        // yield should not be treated as keyword under non-strict mode.
        if (!strict && id === 'yield') {
            return false;
        }
        return isKeywordES6(id, strict);
    }

    function isKeywordES6(id, strict) {
        if (strict && isStrictModeReservedWordES6(id)) {
            return true;
        }

        switch (id.length) {
        case 2:
            return (id === 'if') || (id === 'in') || (id === 'do');
        case 3:
            return (id === 'var') || (id === 'for') || (id === 'new') || (id === 'try');
        case 4:
            return (id === 'this') || (id === 'else') || (id === 'case') ||
                (id === 'void') || (id === 'with') || (id === 'enum');
        case 5:
            return (id === 'while') || (id === 'break') || (id === 'catch') ||
                (id === 'throw') || (id === 'const') || (id === 'yield') ||
                (id === 'class') || (id === 'super');
        case 6:
            return (id === 'return') || (id === 'typeof') || (id === 'delete') ||
                (id === 'switch') || (id === 'export') || (id === 'import');
        case 7:
            return (id === 'default') || (id === 'finally') || (id === 'extends');
        case 8:
            return (id === 'function') || (id === 'continue') || (id === 'debugger');
        case 10:
            return (id === 'instanceof');
        default:
            return false;
        }
    }

    function isReservedWordES5(id, strict) {
        return id === 'null' || id === 'true' || id === 'false' || isKeywordES5(id, strict);
    }

    function isReservedWordES6(id, strict) {
        return id === 'null' || id === 'true' || id === 'false' || isKeywordES6(id, strict);
    }

    function isRestrictedWord(id) {
        return id === 'eval' || id === 'arguments';
    }

    function isIdentifierNameES5(id) {
        var i, iz, ch;

        if (id.length === 0) { return false; }

        ch = id.charCodeAt(0);
        if (!code.isIdentifierStartES5(ch)) {
            return false;
        }

        for (i = 1, iz = id.length; i < iz; ++i) {
            ch = id.charCodeAt(i);
            if (!code.isIdentifierPartES5(ch)) {
                return false;
            }
        }
        return true;
    }

    function decodeUtf16(lead, trail) {
        return (lead - 0xD800) * 0x400 + (trail - 0xDC00) + 0x10000;
    }

    function isIdentifierNameES6(id) {
        var i, iz, ch, lowCh, check;

        if (id.length === 0) { return false; }

        check = code.isIdentifierStartES6;
        for (i = 0, iz = id.length; i < iz; ++i) {
            ch = id.charCodeAt(i);
            if (0xD800 <= ch && ch <= 0xDBFF) {
                ++i;
                if (i >= iz) { return false; }
                lowCh = id.charCodeAt(i);
                if (!(0xDC00 <= lowCh && lowCh <= 0xDFFF)) {
                    return false;
                }
                ch = decodeUtf16(ch, lowCh);
            }
            if (!check(ch)) {
                return false;
            }
            check = code.isIdentifierPartES6;
        }
        return true;
    }

    function isIdentifierES5(id, strict) {
        return isIdentifierNameES5(id) && !isReservedWordES5(id, strict);
    }

    function isIdentifierES6(id, strict) {
        return isIdentifierNameES6(id) && !isReservedWordES6(id, strict);
    }

    module.exports = {
        isKeywordES5: isKeywordES5,
        isKeywordES6: isKeywordES6,
        isReservedWordES5: isReservedWordES5,
        isReservedWordES6: isReservedWordES6,
        isRestrictedWord: isRestrictedWord,
        isIdentifierNameES5: isIdentifierNameES5,
        isIdentifierNameES6: isIdentifierNameES6,
        isIdentifierES5: isIdentifierES5,
        isIdentifierES6: isIdentifierES6
    };
}());
/* vim: set sw=4 ts=4 et tw=80 : */


/***/ }),
/* 59 */
/***/ (function(module) {

module.exports = require("assert");

/***/ }),
/* 60 */
/***/ (function(module) {

module.exports = {"es6.module":{"edge":"16","firefox":"60","chrome":"61","safari":"10.1","opera":"48","ios_saf":"10.3","and_chr":"71","and_ff":"64"}};

/***/ }),
/* 61 */,
/* 62 */,
/* 63 */,
/* 64 */,
/* 65 */,
/* 66 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseCreate = __webpack_require__(782),
    getPrototype = __webpack_require__(931),
    isPrototype = __webpack_require__(514);

/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return (typeof object.constructor == 'function' && !isPrototype(object))
    ? baseCreate(getPrototype(object))
    : {};
}

module.exports = initCloneObject;


/***/ }),
/* 67 */,
/* 68 */
/***/ (function(__unusedmodule, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NOT_LOCAL_BINDING = exports.BLOCK_SCOPED_SYMBOL = exports.INHERIT_KEYS = exports.UNARY_OPERATORS = exports.STRING_UNARY_OPERATORS = exports.NUMBER_UNARY_OPERATORS = exports.BOOLEAN_UNARY_OPERATORS = exports.BINARY_OPERATORS = exports.NUMBER_BINARY_OPERATORS = exports.BOOLEAN_BINARY_OPERATORS = exports.COMPARISON_BINARY_OPERATORS = exports.EQUALITY_BINARY_OPERATORS = exports.BOOLEAN_NUMBER_BINARY_OPERATORS = exports.UPDATE_OPERATORS = exports.LOGICAL_OPERATORS = exports.COMMENT_KEYS = exports.FOR_INIT_KEYS = exports.FLATTENABLE_KEYS = exports.STATEMENT_OR_BLOCK_KEYS = void 0;
const STATEMENT_OR_BLOCK_KEYS = ["consequent", "body", "alternate"];
exports.STATEMENT_OR_BLOCK_KEYS = STATEMENT_OR_BLOCK_KEYS;
const FLATTENABLE_KEYS = ["body", "expressions"];
exports.FLATTENABLE_KEYS = FLATTENABLE_KEYS;
const FOR_INIT_KEYS = ["left", "init"];
exports.FOR_INIT_KEYS = FOR_INIT_KEYS;
const COMMENT_KEYS = ["leadingComments", "trailingComments", "innerComments"];
exports.COMMENT_KEYS = COMMENT_KEYS;
const LOGICAL_OPERATORS = ["||", "&&", "??"];
exports.LOGICAL_OPERATORS = LOGICAL_OPERATORS;
const UPDATE_OPERATORS = ["++", "--"];
exports.UPDATE_OPERATORS = UPDATE_OPERATORS;
const BOOLEAN_NUMBER_BINARY_OPERATORS = [">", "<", ">=", "<="];
exports.BOOLEAN_NUMBER_BINARY_OPERATORS = BOOLEAN_NUMBER_BINARY_OPERATORS;
const EQUALITY_BINARY_OPERATORS = ["==", "===", "!=", "!=="];
exports.EQUALITY_BINARY_OPERATORS = EQUALITY_BINARY_OPERATORS;
const COMPARISON_BINARY_OPERATORS = [...EQUALITY_BINARY_OPERATORS, "in", "instanceof"];
exports.COMPARISON_BINARY_OPERATORS = COMPARISON_BINARY_OPERATORS;
const BOOLEAN_BINARY_OPERATORS = [...COMPARISON_BINARY_OPERATORS, ...BOOLEAN_NUMBER_BINARY_OPERATORS];
exports.BOOLEAN_BINARY_OPERATORS = BOOLEAN_BINARY_OPERATORS;
const NUMBER_BINARY_OPERATORS = ["-", "/", "%", "*", "**", "&", "|", ">>", ">>>", "<<", "^"];
exports.NUMBER_BINARY_OPERATORS = NUMBER_BINARY_OPERATORS;
const BINARY_OPERATORS = ["+", ...NUMBER_BINARY_OPERATORS, ...BOOLEAN_BINARY_OPERATORS];
exports.BINARY_OPERATORS = BINARY_OPERATORS;
const BOOLEAN_UNARY_OPERATORS = ["delete", "!"];
exports.BOOLEAN_UNARY_OPERATORS = BOOLEAN_UNARY_OPERATORS;
const NUMBER_UNARY_OPERATORS = ["+", "-", "~"];
exports.NUMBER_UNARY_OPERATORS = NUMBER_UNARY_OPERATORS;
const STRING_UNARY_OPERATORS = ["typeof"];
exports.STRING_UNARY_OPERATORS = STRING_UNARY_OPERATORS;
const UNARY_OPERATORS = ["void", "throw", ...BOOLEAN_UNARY_OPERATORS, ...NUMBER_UNARY_OPERATORS, ...STRING_UNARY_OPERATORS];
exports.UNARY_OPERATORS = UNARY_OPERATORS;
const INHERIT_KEYS = {
  optional: ["typeAnnotation", "typeParameters", "returnType"],
  force: ["start", "loc", "end"]
};
exports.INHERIT_KEYS = INHERIT_KEYS;
const BLOCK_SCOPED_SYMBOL = Symbol.for("var used to be block scoped");
exports.BLOCK_SCOPED_SYMBOL = BLOCK_SCOPED_SYMBOL;
const NOT_LOCAL_BINDING = Symbol.for("should not be considered a local binding");
exports.NOT_LOCAL_BINDING = NOT_LOCAL_BINDING;

/***/ }),
/* 69 */
/***/ (function(module) {

function webpackEmptyContext(req) {
	if (typeof req === 'number' && __webpack_require__.m[req])
  return __webpack_require__(req);
try { return require(req) }
catch (e) { if (e.code !== 'MODULE_NOT_FOUND') throw e }
var e = new Error("Cannot find module '" + req + "'");
	e.code = 'MODULE_NOT_FOUND';
	throw e;
}
webpackEmptyContext.keys = function() { return []; };
webpackEmptyContext.resolve = webpackEmptyContext;
module.exports = webpackEmptyContext;
webpackEmptyContext.id = 69;

/***/ }),
/* 70 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseSetToString = __webpack_require__(532),
    shortOut = __webpack_require__(304);

/**
 * Sets the `toString` method of `func` to return `string`.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var setToString = shortOut(baseSetToString);

module.exports = setToString;


/***/ }),
/* 71 */,
/* 72 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = loadFullConfig;

var _util = __webpack_require__(390);

var context = _interopRequireWildcard(__webpack_require__(278));

var _plugin = _interopRequireDefault(__webpack_require__(426));

var _item = __webpack_require__(131);

var _configChain = __webpack_require__(235);

function _traverse() {
  const data = _interopRequireDefault(__webpack_require__(167));

  _traverse = function () {
    return data;
  };

  return data;
}

var _caching = __webpack_require__(194);

var _options = __webpack_require__(394);

var _plugins = __webpack_require__(673);

var _configApi = _interopRequireDefault(__webpack_require__(627));

var _partial = _interopRequireDefault(__webpack_require__(16));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function loadFullConfig(inputOpts) {
  const result = (0, _partial.default)(inputOpts);

  if (!result) {
    return null;
  }

  const {
    options,
    context
  } = result;
  const optionDefaults = {};
  const passes = [[]];

  try {
    const {
      plugins,
      presets
    } = options;

    if (!plugins || !presets) {
      throw new Error("Assertion failure - plugins and presets exist");
    }

    const ignored = function recurseDescriptors(config, pass) {
      const plugins = config.plugins.reduce((acc, descriptor) => {
        if (descriptor.options !== false) {
          acc.push(loadPluginDescriptor(descriptor, context));
        }

        return acc;
      }, []);
      const presets = config.presets.reduce((acc, descriptor) => {
        if (descriptor.options !== false) {
          acc.push({
            preset: loadPresetDescriptor(descriptor, context),
            pass: descriptor.ownPass ? [] : pass
          });
        }

        return acc;
      }, []);

      if (presets.length > 0) {
        passes.splice(1, 0, ...presets.map(o => o.pass).filter(p => p !== pass));

        for (const _ref of presets) {
          const {
            preset,
            pass
          } = _ref;
          if (!preset) return true;
          const ignored = recurseDescriptors({
            plugins: preset.plugins,
            presets: preset.presets
          }, pass);
          if (ignored) return true;
          preset.options.forEach(opts => {
            (0, _util.mergeOptions)(optionDefaults, opts);
          });
        }
      }

      if (plugins.length > 0) {
        pass.unshift(...plugins);
      }
    }({
      plugins: plugins.map(item => {
        const desc = (0, _item.getItemDescriptor)(item);

        if (!desc) {
          throw new Error("Assertion failure - must be config item");
        }

        return desc;
      }),
      presets: presets.map(item => {
        const desc = (0, _item.getItemDescriptor)(item);

        if (!desc) {
          throw new Error("Assertion failure - must be config item");
        }

        return desc;
      })
    }, passes[0]);

    if (ignored) return null;
  } catch (e) {
    if (!/^\[BABEL\]/.test(e.message)) {
      e.message = `[BABEL] ${context.filename || "unknown"}: ${e.message}`;
    }

    throw e;
  }

  const opts = optionDefaults;
  (0, _util.mergeOptions)(opts, options);
  opts.plugins = passes[0];
  opts.presets = passes.slice(1).filter(plugins => plugins.length > 0).map(plugins => ({
    plugins
  }));
  opts.passPerPreset = opts.presets.length > 0;
  return {
    options: opts,
    passes: passes
  };
}

const loadDescriptor = (0, _caching.makeWeakCache)(({
  value,
  options,
  dirname,
  alias
}, cache) => {
  if (options === false) throw new Error("Assertion failure");
  options = options || {};
  let item = value;

  if (typeof value === "function") {
    const api = Object.assign({}, context, {}, (0, _configApi.default)(cache));

    try {
      item = value(api, options, dirname);
    } catch (e) {
      if (alias) {
        e.message += ` (While processing: ${JSON.stringify(alias)})`;
      }

      throw e;
    }
  }

  if (!item || typeof item !== "object") {
    throw new Error("Plugin/Preset did not return an object.");
  }

  if (typeof item.then === "function") {
    throw new Error(`You appear to be using an async plugin, ` + `which your current version of Babel does not support. ` + `If you're using a published plugin, ` + `you may need to upgrade your @babel/core version.`);
  }

  return {
    value: item,
    options,
    dirname,
    alias
  };
});

function loadPluginDescriptor(descriptor, context) {
  if (descriptor.value instanceof _plugin.default) {
    if (descriptor.options) {
      throw new Error("Passed options to an existing Plugin instance will not work.");
    }

    return descriptor.value;
  }

  return instantiatePlugin(loadDescriptor(descriptor, context), context);
}

const instantiatePlugin = (0, _caching.makeWeakCache)(({
  value,
  options,
  dirname,
  alias
}, cache) => {
  const pluginObj = (0, _plugins.validatePluginObject)(value);
  const plugin = Object.assign({}, pluginObj);

  if (plugin.visitor) {
    plugin.visitor = _traverse().default.explode(Object.assign({}, plugin.visitor));
  }

  if (plugin.inherits) {
    const inheritsDescriptor = {
      name: undefined,
      alias: `${alias}$inherits`,
      value: plugin.inherits,
      options,
      dirname
    };
    const inherits = cache.invalidate(data => loadPluginDescriptor(inheritsDescriptor, data));
    plugin.pre = chain(inherits.pre, plugin.pre);
    plugin.post = chain(inherits.post, plugin.post);
    plugin.manipulateOptions = chain(inherits.manipulateOptions, plugin.manipulateOptions);
    plugin.visitor = _traverse().default.visitors.merge([inherits.visitor || {}, plugin.visitor || {}]);
  }

  return new _plugin.default(plugin, options, alias);
});

const validateIfOptionNeedsFilename = (options, descriptor) => {
  if (options.test || options.include || options.exclude) {
    const formattedPresetName = descriptor.name ? `"${descriptor.name}"` : "/* your preset */";
    throw new Error([`Preset ${formattedPresetName} requires a filename to be set when babel is called directly,`, `\`\`\``, `babel.transform(code, { filename: 'file.ts', presets: [${formattedPresetName}] });`, `\`\`\``, `See https://babeljs.io/docs/en/options#filename for more information.`].join("\n"));
  }
};

const validatePreset = (preset, context, descriptor) => {
  if (!context.filename) {
    const {
      options
    } = preset;
    validateIfOptionNeedsFilename(options, descriptor);

    if (options.overrides) {
      options.overrides.forEach(overrideOptions => validateIfOptionNeedsFilename(overrideOptions, descriptor));
    }
  }
};

const loadPresetDescriptor = (descriptor, context) => {
  const preset = instantiatePreset(loadDescriptor(descriptor, context));
  validatePreset(preset, context, descriptor);
  return (0, _configChain.buildPresetChain)(preset, context);
};

const instantiatePreset = (0, _caching.makeWeakCache)(({
  value,
  dirname,
  alias
}) => {
  return {
    options: (0, _options.validate)("preset", value),
    alias,
    dirname
  };
});

function chain(a, b) {
  const fns = [a, b].filter(Boolean);
  if (fns.length <= 1) return fns[0];
  return function (...args) {
    for (const fn of fns) {
      fn.apply(this, args);
    }
  };
}

/***/ }),
/* 73 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var getMapData = __webpack_require__(343);

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

module.exports = mapCacheSet;


/***/ }),
/* 74 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var Symbol = __webpack_require__(498),
    Uint8Array = __webpack_require__(161),
    eq = __webpack_require__(338),
    equalArrays = __webpack_require__(90),
    mapToArray = __webpack_require__(664),
    setToArray = __webpack_require__(438);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]';

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return eq(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag:
      var convert = mapToArray;

    case setTag:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
      convert || (convert = setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

module.exports = equalByTag;


/***/ }),
/* 75 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = __webpack_require__(57);

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

var _default = (0, _helperPluginUtils().declare)(api => {
  api.assertVersion(7);
  return {
    name: "syntax-optional-catch-binding",

    manipulateOptions(opts, parserOpts) {
      parserOpts.plugins.push("optionalCatchBinding");
    }

  };
});

exports.default = _default;

/***/ }),
/* 76 */
/***/ (function(module) {

function BrowserslistError (message) {
  this.name = 'BrowserslistError'
  this.message = message
  this.browserslist = true
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, BrowserslistError)
  }
}

BrowserslistError.prototype = Error.prototype

module.exports = BrowserslistError


/***/ }),
/* 77 */,
/* 78 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var getMapData = __webpack_require__(343);

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = mapCacheDelete;


/***/ }),
/* 79 */
/***/ (function(module) {

module.exports={"0":"56","1":"57","2":"58","3":"60","4":"62","5":"63","6":"64","7":"11.1","8":"68","9":"12.1",A:"10",B:"11",C:"12",D:"7",E:"9",F:"4",G:"8",H:"6",I:"17",J:"18",K:"13",L:"15",M:"46",N:"16",O:"5",P:"19",Q:"20",R:"21",S:"22",T:"23",U:"24",V:"25",W:"26",X:"27",Y:"28",Z:"29",a:"30",b:"31",c:"32",d:"33",e:"34",f:"14",g:"36",h:"37",i:"38",j:"39",k:"40",l:"41",m:"42",n:"43",o:"44",p:"45",q:"76",r:"47",s:"48",t:"49",u:"50",v:"51",w:"52",x:"53",y:"54",z:"55",AB:"35",BB:"66",CB:"4.2-4.3",DB:"65",EB:"59",FB:"67",GB:"11.5",HB:"69",IB:"70",JB:"71",KB:"72",LB:"61",MB:"3",NB:"10.1",OB:"3.2",PB:"78",QB:"9.0-9.2",RB:"77",SB:"79",TB:"80",UB:"81",VB:"3.1",WB:"74",XB:"5.1",YB:"6.1",ZB:"7.1",aB:"9.1",bB:"73",cB:"3.6",dB:"3.5",eB:"TP",fB:"9.5-9.6",gB:"10.0-10.1",hB:"10.5",iB:"10.6",jB:"2",kB:"11.6",lB:"4.0-4.1",mB:"5.5",nB:"5.0-5.1",oB:"6.0-6.1",pB:"7.0-7.1",qB:"8.1-8.4",rB:"75",sB:"9.3",tB:"10.0-10.2",uB:"10.3",vB:"11.0-11.2",wB:"11.3-11.4",xB:"12.0-12.1",yB:"12.2-12.4",zB:"13.0-13.1","0B":"13.2","1B":"13.3","2B":"all","3B":"2.1","4B":"2.2","5B":"2.3","6B":"4.1","7B":"4.4","8B":"4.4.3-4.4.4","9B":"12.12",AC:"5.0-5.4",BC:"6.2-6.4",CC:"7.2-7.4",DC:"8.2",EC:"9.2",FC:"1.2",GC:"7.12",HC:"2.5"};


/***/ }),
/* 80 */,
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

/**
 * Module dependencies.
 */

const tty = __webpack_require__(867);
const util = __webpack_require__(357);

/**
 * This is the Node.js implementation of `debug()`.
 */

exports.init = init;
exports.log = log;
exports.formatArgs = formatArgs;
exports.save = save;
exports.load = load;
exports.useColors = useColors;

/**
 * Colors.
 */

exports.colors = [6, 2, 3, 4, 5, 1];

try {
	// Optional dependency (as in, doesn't need to be installed, NOT like optionalDependencies in package.json)
	// eslint-disable-next-line import/no-extraneous-dependencies
	const supportsColor = __webpack_require__(247);

	if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
		exports.colors = [
			20,
			21,
			26,
			27,
			32,
			33,
			38,
			39,
			40,
			41,
			42,
			43,
			44,
			45,
			56,
			57,
			62,
			63,
			68,
			69,
			74,
			75,
			76,
			77,
			78,
			79,
			80,
			81,
			92,
			93,
			98,
			99,
			112,
			113,
			128,
			129,
			134,
			135,
			148,
			149,
			160,
			161,
			162,
			163,
			164,
			165,
			166,
			167,
			168,
			169,
			170,
			171,
			172,
			173,
			178,
			179,
			184,
			185,
			196,
			197,
			198,
			199,
			200,
			201,
			202,
			203,
			204,
			205,
			206,
			207,
			208,
			209,
			214,
			215,
			220,
			221
		];
	}
} catch (error) {
	// Swallow - we only care if `supports-color` is available; it doesn't have to be.
}

/**
 * Build up the default `inspectOpts` object from the environment variables.
 *
 *   $ DEBUG_COLORS=no DEBUG_DEPTH=10 DEBUG_SHOW_HIDDEN=enabled node script.js
 */

exports.inspectOpts = Object.keys(process.env).filter(key => {
	return /^debug_/i.test(key);
}).reduce((obj, key) => {
	// Camel-case
	const prop = key
		.substring(6)
		.toLowerCase()
		.replace(/_([a-z])/g, (_, k) => {
			return k.toUpperCase();
		});

	// Coerce string value into JS value
	let val = process.env[key];
	if (/^(yes|on|true|enabled)$/i.test(val)) {
		val = true;
	} else if (/^(no|off|false|disabled)$/i.test(val)) {
		val = false;
	} else if (val === 'null') {
		val = null;
	} else {
		val = Number(val);
	}

	obj[prop] = val;
	return obj;
}, {});

/**
 * Is stdout a TTY? Colored output is enabled when `true`.
 */

function useColors() {
	return 'colors' in exports.inspectOpts ?
		Boolean(exports.inspectOpts.colors) :
		tty.isatty(process.stderr.fd);
}

/**
 * Adds ANSI color escape codes if enabled.
 *
 * @api public
 */

function formatArgs(args) {
	const {namespace: name, useColors} = this;

	if (useColors) {
		const c = this.color;
		const colorCode = '\u001B[3' + (c < 8 ? c : '8;5;' + c);
		const prefix = `  ${colorCode};1m${name} \u001B[0m`;

		args[0] = prefix + args[0].split('\n').join('\n' + prefix);
		args.push(colorCode + 'm+' + module.exports.humanize(this.diff) + '\u001B[0m');
	} else {
		args[0] = getDate() + name + ' ' + args[0];
	}
}

function getDate() {
	if (exports.inspectOpts.hideDate) {
		return '';
	}
	return new Date().toISOString() + ' ';
}

/**
 * Invokes `util.format()` with the specified arguments and writes to stderr.
 */

function log(...args) {
	return process.stderr.write(util.format(...args) + '\n');
}

/**
 * Save `namespaces`.
 *
 * @param {String} namespaces
 * @api private
 */
function save(namespaces) {
	if (namespaces) {
		process.env.DEBUG = namespaces;
	} else {
		// If you set a process.env field to null or undefined, it gets cast to the
		// string 'null' or 'undefined'. Just delete instead.
		delete process.env.DEBUG;
	}
}

/**
 * Load `namespaces`.
 *
 * @return {String} returns the previously persisted debug modes
 * @api private
 */

function load() {
	return process.env.DEBUG;
}

/**
 * Init logic for `debug` instances.
 *
 * Create a new `inspectOpts` object in case `useColors` is set
 * differently for a particular `debug` instance.
 */

function init(debug) {
	debug.inspectOpts = {};

	const keys = Object.keys(exports.inspectOpts);
	for (let i = 0; i < keys.length; i++) {
		debug.inspectOpts[keys[i]] = exports.inspectOpts[keys[i]];
	}
}

module.exports = __webpack_require__(486)(exports);

const {formatters} = module.exports;

/**
 * Map %o to `util.inspect()`, all on a single line.
 */

formatters.o = function (v) {
	this.inspectOpts.colors = this.useColors;
	return util.inspect(v, this.inspectOpts)
		.replace(/\s*\n\s*/g, ' ');
};

/**
 * Map %O to `util.inspect()`, allowing multiple lines if needed.
 */

formatters.O = function (v) {
	this.inspectOpts.colors = this.useColors;
	return util.inspect(v, this.inspectOpts);
};


/***/ }),
/* 82 */,
/* 83 */
/***/ (function(module) {

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

module.exports = identity;


/***/ }),
/* 84 */,
/* 85 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = buildChildren;

var _generated = __webpack_require__(897);

var _cleanJSXElementLiteralChild = _interopRequireDefault(__webpack_require__(272));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function buildChildren(node) {
  const elements = [];

  for (let i = 0; i < node.children.length; i++) {
    let child = node.children[i];

    if ((0, _generated.isJSXText)(child)) {
      (0, _cleanJSXElementLiteralChild.default)(child, elements);
      continue;
    }

    if ((0, _generated.isJSXExpressionContainer)(child)) child = child.expression;
    if ((0, _generated.isJSXEmptyExpression)(child)) continue;
    elements.push(child);
  }

  return elements;
}

/***/ }),
/* 86 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logUsagePolyfills = exports.logEntryPolyfills = exports.logPluginOrPolyfill = void 0;

var _semver = _interopRequireDefault(__webpack_require__(864));

var _utils = __webpack_require__(882);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const wordEnds = size => {
  return size > 1 ? "s" : "";
};

const logPluginOrPolyfill = (item, targetVersions, list) => {
  const minVersions = list[item] || {};
  const filteredList = Object.keys(targetVersions).reduce((result, env) => {
    const minVersion = minVersions[env];
    const targetVersion = targetVersions[env];

    if (!minVersion) {
      result[env] = (0, _utils.prettifyVersion)(targetVersion);
    } else {
      const minIsUnreleased = (0, _utils.isUnreleasedVersion)(minVersion, env);
      const targetIsUnreleased = (0, _utils.isUnreleasedVersion)(targetVersion, env);

      if (!targetIsUnreleased && (minIsUnreleased || _semver.default.lt(targetVersion.toString(), (0, _utils.semverify)(minVersion)))) {
        result[env] = (0, _utils.prettifyVersion)(targetVersion);
      }
    }

    return result;
  }, {});
  const formattedTargets = JSON.stringify(filteredList).replace(/,/g, ", ").replace(/^\{"/, '{ "').replace(/"\}$/, '" }');
  console.log(`  ${item} ${formattedTargets}`);
};

exports.logPluginOrPolyfill = logPluginOrPolyfill;

const logEntryPolyfills = (polyfillName, importPolyfillIncluded, polyfills, filename, polyfillTargets, allBuiltInsList) => {
  if (process.env.BABEL_ENV === "test") {
    filename = filename.replace(/\\/g, "/");
  }

  if (!importPolyfillIncluded) {
    console.log(`\n[${filename}] Import of ${polyfillName} was not found.`);
    return;
  }

  if (!polyfills.size) {
    console.log(`\n[${filename}] Based on your targets, polyfills were not added.`);
    return;
  }

  console.log(`\n[${filename}] Replaced ${polyfillName} entries with the following polyfill${wordEnds(polyfills.size)}:`);

  for (const polyfill of polyfills) {
    logPluginOrPolyfill(polyfill, polyfillTargets, allBuiltInsList);
  }
};

exports.logEntryPolyfills = logEntryPolyfills;

const logUsagePolyfills = (polyfills, filename, polyfillTargets, allBuiltInsList) => {
  if (process.env.BABEL_ENV === "test") {
    filename = filename.replace(/\\/g, "/");
  }

  if (!polyfills.size) {
    console.log(`\n[${filename}] Based on your code and targets, core-js polyfills were not added.`);
    return;
  }

  console.log(`\n[${filename}] Added following core-js polyfill${wordEnds(polyfills.size)}:`);

  for (const polyfill of polyfills) {
    logPluginOrPolyfill(polyfill, polyfillTargets, allBuiltInsList);
  }
};

exports.logUsagePolyfills = logUsagePolyfills;

/***/ }),
/* 87 */
/***/ (function(module) {

module.exports = require("os");

/***/ }),
/* 88 */,
/* 89 */,
/* 90 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var SetCache = __webpack_require__(727),
    arraySome = __webpack_require__(213),
    cacheHas = __webpack_require__(275);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Assume cyclic values are equal.
  var stacked = stack.get(array);
  if (stacked && stack.get(other)) {
    return stacked == other;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

module.exports = equalArrays;


/***/ }),
/* 91 */,
/* 92 */,
/* 93 */
/***/ (function(module) {

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = stubFalse;


/***/ }),
/* 94 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

/*
 * Copyright 2009-2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE.txt or:
 * http://opensource.org/licenses/BSD-3-Clause
 */
exports.SourceMapGenerator = __webpack_require__(454).SourceMapGenerator;
exports.SourceMapConsumer = __webpack_require__(276).SourceMapConsumer;
exports.SourceNode = __webpack_require__(54).SourceNode;


/***/ }),
/* 95 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TSTYPE_TYPES = exports.TSTYPEELEMENT_TYPES = exports.PRIVATE_TYPES = exports.JSX_TYPES = exports.ENUMMEMBER_TYPES = exports.ENUMBODY_TYPES = exports.FLOWPREDICATE_TYPES = exports.FLOWDECLARATION_TYPES = exports.FLOWBASEANNOTATION_TYPES = exports.FLOWTYPE_TYPES = exports.FLOW_TYPES = exports.MODULESPECIFIER_TYPES = exports.EXPORTDECLARATION_TYPES = exports.MODULEDECLARATION_TYPES = exports.CLASS_TYPES = exports.PATTERN_TYPES = exports.UNARYLIKE_TYPES = exports.PROPERTY_TYPES = exports.OBJECTMEMBER_TYPES = exports.METHOD_TYPES = exports.USERWHITESPACABLE_TYPES = exports.IMMUTABLE_TYPES = exports.LITERAL_TYPES = exports.TSENTITYNAME_TYPES = exports.LVAL_TYPES = exports.PATTERNLIKE_TYPES = exports.DECLARATION_TYPES = exports.PUREISH_TYPES = exports.FUNCTIONPARENT_TYPES = exports.FUNCTION_TYPES = exports.FORXSTATEMENT_TYPES = exports.FOR_TYPES = exports.EXPRESSIONWRAPPER_TYPES = exports.WHILE_TYPES = exports.LOOP_TYPES = exports.CONDITIONAL_TYPES = exports.COMPLETIONSTATEMENT_TYPES = exports.TERMINATORLESS_TYPES = exports.STATEMENT_TYPES = exports.BLOCK_TYPES = exports.BLOCKPARENT_TYPES = exports.SCOPABLE_TYPES = exports.BINARY_TYPES = exports.EXPRESSION_TYPES = void 0;

var _definitions = __webpack_require__(288);

const EXPRESSION_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Expression"];
exports.EXPRESSION_TYPES = EXPRESSION_TYPES;
const BINARY_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Binary"];
exports.BINARY_TYPES = BINARY_TYPES;
const SCOPABLE_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Scopable"];
exports.SCOPABLE_TYPES = SCOPABLE_TYPES;
const BLOCKPARENT_TYPES = _definitions.FLIPPED_ALIAS_KEYS["BlockParent"];
exports.BLOCKPARENT_TYPES = BLOCKPARENT_TYPES;
const BLOCK_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Block"];
exports.BLOCK_TYPES = BLOCK_TYPES;
const STATEMENT_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Statement"];
exports.STATEMENT_TYPES = STATEMENT_TYPES;
const TERMINATORLESS_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Terminatorless"];
exports.TERMINATORLESS_TYPES = TERMINATORLESS_TYPES;
const COMPLETIONSTATEMENT_TYPES = _definitions.FLIPPED_ALIAS_KEYS["CompletionStatement"];
exports.COMPLETIONSTATEMENT_TYPES = COMPLETIONSTATEMENT_TYPES;
const CONDITIONAL_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Conditional"];
exports.CONDITIONAL_TYPES = CONDITIONAL_TYPES;
const LOOP_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Loop"];
exports.LOOP_TYPES = LOOP_TYPES;
const WHILE_TYPES = _definitions.FLIPPED_ALIAS_KEYS["While"];
exports.WHILE_TYPES = WHILE_TYPES;
const EXPRESSIONWRAPPER_TYPES = _definitions.FLIPPED_ALIAS_KEYS["ExpressionWrapper"];
exports.EXPRESSIONWRAPPER_TYPES = EXPRESSIONWRAPPER_TYPES;
const FOR_TYPES = _definitions.FLIPPED_ALIAS_KEYS["For"];
exports.FOR_TYPES = FOR_TYPES;
const FORXSTATEMENT_TYPES = _definitions.FLIPPED_ALIAS_KEYS["ForXStatement"];
exports.FORXSTATEMENT_TYPES = FORXSTATEMENT_TYPES;
const FUNCTION_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Function"];
exports.FUNCTION_TYPES = FUNCTION_TYPES;
const FUNCTIONPARENT_TYPES = _definitions.FLIPPED_ALIAS_KEYS["FunctionParent"];
exports.FUNCTIONPARENT_TYPES = FUNCTIONPARENT_TYPES;
const PUREISH_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Pureish"];
exports.PUREISH_TYPES = PUREISH_TYPES;
const DECLARATION_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Declaration"];
exports.DECLARATION_TYPES = DECLARATION_TYPES;
const PATTERNLIKE_TYPES = _definitions.FLIPPED_ALIAS_KEYS["PatternLike"];
exports.PATTERNLIKE_TYPES = PATTERNLIKE_TYPES;
const LVAL_TYPES = _definitions.FLIPPED_ALIAS_KEYS["LVal"];
exports.LVAL_TYPES = LVAL_TYPES;
const TSENTITYNAME_TYPES = _definitions.FLIPPED_ALIAS_KEYS["TSEntityName"];
exports.TSENTITYNAME_TYPES = TSENTITYNAME_TYPES;
const LITERAL_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Literal"];
exports.LITERAL_TYPES = LITERAL_TYPES;
const IMMUTABLE_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Immutable"];
exports.IMMUTABLE_TYPES = IMMUTABLE_TYPES;
const USERWHITESPACABLE_TYPES = _definitions.FLIPPED_ALIAS_KEYS["UserWhitespacable"];
exports.USERWHITESPACABLE_TYPES = USERWHITESPACABLE_TYPES;
const METHOD_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Method"];
exports.METHOD_TYPES = METHOD_TYPES;
const OBJECTMEMBER_TYPES = _definitions.FLIPPED_ALIAS_KEYS["ObjectMember"];
exports.OBJECTMEMBER_TYPES = OBJECTMEMBER_TYPES;
const PROPERTY_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Property"];
exports.PROPERTY_TYPES = PROPERTY_TYPES;
const UNARYLIKE_TYPES = _definitions.FLIPPED_ALIAS_KEYS["UnaryLike"];
exports.UNARYLIKE_TYPES = UNARYLIKE_TYPES;
const PATTERN_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Pattern"];
exports.PATTERN_TYPES = PATTERN_TYPES;
const CLASS_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Class"];
exports.CLASS_TYPES = CLASS_TYPES;
const MODULEDECLARATION_TYPES = _definitions.FLIPPED_ALIAS_KEYS["ModuleDeclaration"];
exports.MODULEDECLARATION_TYPES = MODULEDECLARATION_TYPES;
const EXPORTDECLARATION_TYPES = _definitions.FLIPPED_ALIAS_KEYS["ExportDeclaration"];
exports.EXPORTDECLARATION_TYPES = EXPORTDECLARATION_TYPES;
const MODULESPECIFIER_TYPES = _definitions.FLIPPED_ALIAS_KEYS["ModuleSpecifier"];
exports.MODULESPECIFIER_TYPES = MODULESPECIFIER_TYPES;
const FLOW_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Flow"];
exports.FLOW_TYPES = FLOW_TYPES;
const FLOWTYPE_TYPES = _definitions.FLIPPED_ALIAS_KEYS["FlowType"];
exports.FLOWTYPE_TYPES = FLOWTYPE_TYPES;
const FLOWBASEANNOTATION_TYPES = _definitions.FLIPPED_ALIAS_KEYS["FlowBaseAnnotation"];
exports.FLOWBASEANNOTATION_TYPES = FLOWBASEANNOTATION_TYPES;
const FLOWDECLARATION_TYPES = _definitions.FLIPPED_ALIAS_KEYS["FlowDeclaration"];
exports.FLOWDECLARATION_TYPES = FLOWDECLARATION_TYPES;
const FLOWPREDICATE_TYPES = _definitions.FLIPPED_ALIAS_KEYS["FlowPredicate"];
exports.FLOWPREDICATE_TYPES = FLOWPREDICATE_TYPES;
const ENUMBODY_TYPES = _definitions.FLIPPED_ALIAS_KEYS["EnumBody"];
exports.ENUMBODY_TYPES = ENUMBODY_TYPES;
const ENUMMEMBER_TYPES = _definitions.FLIPPED_ALIAS_KEYS["EnumMember"];
exports.ENUMMEMBER_TYPES = ENUMMEMBER_TYPES;
const JSX_TYPES = _definitions.FLIPPED_ALIAS_KEYS["JSX"];
exports.JSX_TYPES = JSX_TYPES;
const PRIVATE_TYPES = _definitions.FLIPPED_ALIAS_KEYS["Private"];
exports.PRIVATE_TYPES = PRIVATE_TYPES;
const TSTYPEELEMENT_TYPES = _definitions.FLIPPED_ALIAS_KEYS["TSTypeElement"];
exports.TSTYPEELEMENT_TYPES = TSTYPEELEMENT_TYPES;
const TSTYPE_TYPES = _definitions.FLIPPED_ALIAS_KEYS["TSType"];
exports.TSTYPE_TYPES = TSTYPE_TYPES;

/***/ }),
/* 96 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isNodesEquivalent;

var _definitions = __webpack_require__(288);

function isNodesEquivalent(a, b) {
  if (typeof a !== "object" || typeof b !== "object" || a == null || b == null) {
    return a === b;
  }

  if (a.type !== b.type) {
    return false;
  }

  const fields = Object.keys(_definitions.NODE_FIELDS[a.type] || a.type);
  const visitorKeys = _definitions.VISITOR_KEYS[a.type];

  for (const field of fields) {
    if (typeof a[field] !== typeof b[field]) {
      return false;
    }

    if (a[field] == null && b[field] == null) {
      continue;
    } else if (a[field] == null || b[field] == null) {
      return false;
    }

    if (Array.isArray(a[field])) {
      if (!Array.isArray(b[field])) {
        return false;
      }

      if (a[field].length !== b[field].length) {
        return false;
      }

      for (let i = 0; i < a[field].length; i++) {
        if (!isNodesEquivalent(a[field][i], b[field][i])) {
          return false;
        }
      }

      continue;
    }

    if (typeof a[field] === "object" && (!visitorKeys || !visitorKeys.includes(field))) {
      for (const key of Object.keys(a[field])) {
        if (a[field][key] !== b[field][key]) {
          return false;
        }
      }

      continue;
    }

    if (!isNodesEquivalent(a[field], b[field])) {
      return false;
    }
  }

  return true;
}

/***/ }),
/* 97 */
/***/ (function(__unusedmodule, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PossibleGlobalObjects = exports.CommonInstanceDependencies = exports.StaticProperties = exports.InstanceProperties = exports.BuiltIns = exports.PromiseDependencies = exports.CommonIterators = void 0;
const ArrayNatureIterators = ["es.array.iterator", "web.dom-collections.iterator"];
const CommonIterators = ["es.string.iterator", ...ArrayNatureIterators];
exports.CommonIterators = CommonIterators;
const ArrayNatureIteratorsWithTag = ["es.object.to-string", ...ArrayNatureIterators];
const CommonIteratorsWithTag = ["es.object.to-string", ...CommonIterators];
const TypedArrayDependencies = ["es.typed-array.copy-within", "es.typed-array.every", "es.typed-array.fill", "es.typed-array.filter", "es.typed-array.find", "es.typed-array.find-index", "es.typed-array.for-each", "es.typed-array.includes", "es.typed-array.index-of", "es.typed-array.iterator", "es.typed-array.join", "es.typed-array.last-index-of", "es.typed-array.map", "es.typed-array.reduce", "es.typed-array.reduce-right", "es.typed-array.reverse", "es.typed-array.set", "es.typed-array.slice", "es.typed-array.some", "es.typed-array.sort", "es.typed-array.subarray", "es.typed-array.to-locale-string", "es.typed-array.to-string", "es.object.to-string", "es.array.iterator", "es.array-buffer.slice"];
const TypedArrayStaticMethods = {
  from: "es.typed-array.from",
  of: "es.typed-array.of"
};
const PromiseDependencies = ["es.promise", "es.object.to-string"];
exports.PromiseDependencies = PromiseDependencies;
const PromiseDependenciesWithIterators = [...PromiseDependencies, ...CommonIterators];
const SymbolDependencies = ["es.symbol", "es.symbol.description", "es.object.to-string"];
const MapDependencies = ["es.map", "esnext.map.delete-all", "esnext.map.every", "esnext.map.filter", "esnext.map.find", "esnext.map.find-key", "esnext.map.includes", "esnext.map.key-of", "esnext.map.map-keys", "esnext.map.map-values", "esnext.map.merge", "esnext.map.reduce", "esnext.map.some", "esnext.map.update", ...CommonIteratorsWithTag];
const SetDependencies = ["es.set", "esnext.set.add-all", "esnext.set.delete-all", "esnext.set.difference", "esnext.set.every", "esnext.set.filter", "esnext.set.find", "esnext.set.intersection", "esnext.set.is-disjoint-from", "esnext.set.is-subset-of", "esnext.set.is-superset-of", "esnext.set.join", "esnext.set.map", "esnext.set.reduce", "esnext.set.some", "esnext.set.symmetric-difference", "esnext.set.union", ...CommonIteratorsWithTag];
const WeakMapDependencies = ["es.weak-map", "esnext.weak-map.delete-all", ...CommonIteratorsWithTag];
const WeakSetDependencies = ["es.weak-set", "esnext.weak-set.add-all", "esnext.weak-set.delete-all", ...CommonIteratorsWithTag];
const URLSearchParamsDependencies = ["web.url", ...CommonIteratorsWithTag];
const BuiltIns = {
  AggregateError: ["esnext.aggregate-error", ...CommonIterators],
  ArrayBuffer: ["es.array-buffer.constructor", "es.array-buffer.slice", "es.object.to-string"],
  DataView: ["es.data-view", "es.array-buffer.slice", "es.object.to-string"],
  Date: ["es.date.to-string"],
  Float32Array: ["es.typed-array.float32-array", ...TypedArrayDependencies],
  Float64Array: ["es.typed-array.float64-array", ...TypedArrayDependencies],
  Int8Array: ["es.typed-array.int8-array", ...TypedArrayDependencies],
  Int16Array: ["es.typed-array.int16-array", ...TypedArrayDependencies],
  Int32Array: ["es.typed-array.int32-array", ...TypedArrayDependencies],
  Uint8Array: ["es.typed-array.uint8-array", ...TypedArrayDependencies],
  Uint8ClampedArray: ["es.typed-array.uint8-clamped-array", ...TypedArrayDependencies],
  Uint16Array: ["es.typed-array.uint16-array", ...TypedArrayDependencies],
  Uint32Array: ["es.typed-array.uint32-array", ...TypedArrayDependencies],
  Map: MapDependencies,
  Number: ["es.number.constructor"],
  Observable: ["esnext.observable", "esnext.symbol.observable", "es.object.to-string", ...CommonIteratorsWithTag],
  Promise: PromiseDependencies,
  RegExp: ["es.regexp.constructor", "es.regexp.exec", "es.regexp.to-string"],
  Set: SetDependencies,
  Symbol: SymbolDependencies,
  URL: ["web.url", ...URLSearchParamsDependencies],
  URLSearchParams: URLSearchParamsDependencies,
  WeakMap: WeakMapDependencies,
  WeakSet: WeakSetDependencies,
  clearImmediate: ["web.immediate"],
  compositeKey: ["esnext.composite-key"],
  compositeSymbol: ["esnext.composite-symbol", ...SymbolDependencies],
  fetch: PromiseDependencies,
  globalThis: ["esnext.global-this"],
  parseFloat: ["es.parse-float"],
  parseInt: ["es.parse-int"],
  queueMicrotask: ["web.queue-microtask"],
  setTimeout: ["web.timers"],
  setInterval: ["web.timers"],
  setImmediate: ["web.immediate"]
};
exports.BuiltIns = BuiltIns;
const InstanceProperties = {
  at: ["esnext.string.at"],
  anchor: ["es.string.anchor"],
  big: ["es.string.big"],
  bind: ["es.function.bind"],
  blink: ["es.string.blink"],
  bold: ["es.string.bold"],
  codePointAt: ["es.string.code-point-at"],
  codePoints: ["esnext.string.code-points"],
  concat: ["es.array.concat"],
  copyWithin: ["es.array.copy-within"],
  description: ["es.symbol", "es.symbol.description"],
  endsWith: ["es.string.ends-with"],
  entries: ArrayNatureIteratorsWithTag,
  every: ["es.array.every"],
  exec: ["es.regexp.exec"],
  fill: ["es.array.fill"],
  filter: ["es.array.filter"],
  finally: ["es.promise.finally", ...PromiseDependencies],
  find: ["es.array.find"],
  findIndex: ["es.array.find-index"],
  fixed: ["es.string.fixed"],
  flags: ["es.regexp.flags"],
  flat: ["es.array.flat", "es.array.unscopables.flat"],
  flatMap: ["es.array.flat-map", "es.array.unscopables.flat-map"],
  fontcolor: ["es.string.fontcolor"],
  fontsize: ["es.string.fontsize"],
  forEach: ["es.array.for-each", "web.dom-collections.for-each"],
  includes: ["es.array.includes", "es.string.includes"],
  indexOf: ["es.array.index-of"],
  italics: ["es.string.italics"],
  join: ["es.array.join"],
  keys: ArrayNatureIteratorsWithTag,
  lastIndex: ["esnext.array.last-index"],
  lastIndexOf: ["es.array.last-index-of"],
  lastItem: ["esnext.array.last-item"],
  link: ["es.string.link"],
  match: ["es.string.match", "es.regexp.exec"],
  matchAll: ["esnext.string.match-all"],
  map: ["es.array.map"],
  name: ["es.function.name"],
  padEnd: ["es.string.pad-end"],
  padStart: ["es.string.pad-start"],
  reduce: ["es.array.reduce"],
  reduceRight: ["es.array.reduce-right"],
  repeat: ["es.string.repeat"],
  replace: ["es.string.replace", "es.regexp.exec"],
  replaceAll: ["esnext.string.replace-all"],
  reverse: ["es.array.reverse"],
  search: ["es.string.search", "es.regexp.exec"],
  slice: ["es.array.slice"],
  small: ["es.string.small"],
  some: ["es.array.some"],
  sort: ["es.array.sort"],
  splice: ["es.array.splice"],
  split: ["es.string.split", "es.regexp.exec"],
  startsWith: ["es.string.starts-with"],
  strike: ["es.string.strike"],
  sub: ["es.string.sub"],
  sup: ["es.string.sup"],
  toFixed: ["es.number.to-fixed"],
  toISOString: ["es.date.to-iso-string"],
  toJSON: ["es.date.to-json", "web.url.to-json"],
  toPrecision: ["es.number.to-precision"],
  toString: ["es.object.to-string", "es.regexp.to-string", "es.date.to-string"],
  trim: ["es.string.trim"],
  trimEnd: ["es.string.trim-end"],
  trimLeft: ["es.string.trim-start"],
  trimRight: ["es.string.trim-end"],
  trimStart: ["es.string.trim-start"],
  values: ArrayNatureIteratorsWithTag,
  __defineGetter__: ["es.object.define-getter"],
  __defineSetter__: ["es.object.define-setter"],
  __lookupGetter__: ["es.object.lookup-getter"],
  __lookupSetter__: ["es.object.lookup-setter"]
};
exports.InstanceProperties = InstanceProperties;
const StaticProperties = {
  Array: {
    from: ["es.array.from", "es.string.iterator"],
    isArray: ["es.array.is-array"],
    of: ["es.array.of"]
  },
  Date: {
    now: "es.date.now"
  },
  Object: {
    assign: "es.object.assign",
    create: "es.object.create",
    defineProperty: "es.object.define-property",
    defineProperties: "es.object.define-properties",
    entries: "es.object.entries",
    freeze: "es.object.freeze",
    fromEntries: ["es.object.from-entries", "es.array.iterator"],
    getOwnPropertyDescriptor: "es.object.get-own-property-descriptor",
    getOwnPropertyDescriptors: "es.object.get-own-property-descriptors",
    getOwnPropertyNames: "es.object.get-own-property-names",
    getOwnPropertySymbols: "es.symbol",
    getPrototypeOf: "es.object.get-prototype-of",
    is: "es.object.is",
    isExtensible: "es.object.is-extensible",
    isFrozen: "es.object.is-frozen",
    isSealed: "es.object.is-sealed",
    keys: "es.object.keys",
    preventExtensions: "es.object.prevent-extensions",
    seal: "es.object.seal",
    setPrototypeOf: "es.object.set-prototype-of",
    values: "es.object.values"
  },
  Math: {
    DEG_PER_RAD: "esnext.math.deg-per-rad",
    RAD_PER_DEG: "esnext.math.rad-per-deg",
    acosh: "es.math.acosh",
    asinh: "es.math.asinh",
    atanh: "es.math.atanh",
    cbrt: "es.math.cbrt",
    clamp: "esnext.math.clamp",
    clz32: "es.math.clz32",
    cosh: "es.math.cosh",
    degrees: "esnext.math.degrees",
    expm1: "es.math.expm1",
    fround: "es.math.fround",
    fscale: "esnext.math.fscale",
    hypot: "es.math.hypot",
    iaddh: "esnext.math.iaddh",
    imul: "es.math.imul",
    imulh: "esnext.math.imulh",
    isubh: "esnext.math.isubh",
    log1p: "es.math.log1p",
    log10: "es.math.log10",
    log2: "es.math.log2",
    radians: "esnext.math.radians",
    scale: "esnext.math.scale",
    seededPRNG: "esnext.math.seeded-prng",
    sign: "es.math.sign",
    signbit: "esnext.math.signbit",
    sinh: "es.math.sinh",
    tanh: "es.math.tanh",
    trunc: "es.math.trunc",
    umulh: "esnext.math.umulh"
  },
  String: {
    fromCodePoint: "es.string.from-code-point",
    raw: "es.string.raw"
  },
  Number: {
    EPSILON: "es.number.epsilon",
    MIN_SAFE_INTEGER: "es.number.min-safe-integer",
    MAX_SAFE_INTEGER: "es.number.max-safe-integer",
    fromString: "esnext.number.from-string",
    isFinite: "es.number.is-finite",
    isInteger: "es.number.is-integer",
    isSafeInteger: "es.number.is-safe-integer",
    isNaN: "es.number.is-nan",
    parseFloat: "es.number.parse-float",
    parseInt: "es.number.parse-int"
  },
  Map: {
    from: ["esnext.map.from", ...MapDependencies],
    groupBy: ["esnext.map.group-by", ...MapDependencies],
    keyBy: ["esnext.map.key-by", ...MapDependencies],
    of: ["esnext.map.of", ...MapDependencies]
  },
  Set: {
    from: ["esnext.set.from", ...SetDependencies],
    of: ["esnext.set.of", ...SetDependencies]
  },
  WeakMap: {
    from: ["esnext.weak-map.from", ...WeakMapDependencies],
    of: ["esnext.weak-map.of", ...WeakMapDependencies]
  },
  WeakSet: {
    from: ["esnext.weak-set.from", ...WeakSetDependencies],
    of: ["esnext.weak-set.of", ...WeakSetDependencies]
  },
  Promise: {
    all: PromiseDependenciesWithIterators,
    allSettled: ["esnext.promise.all-settled", ...PromiseDependenciesWithIterators],
    any: ["esnext.promise.any", ...PromiseDependenciesWithIterators],
    race: PromiseDependenciesWithIterators,
    try: ["esnext.promise.try", ...PromiseDependenciesWithIterators]
  },
  Reflect: {
    apply: "es.reflect.apply",
    construct: "es.reflect.construct",
    defineMetadata: "esnext.reflect.define-metadata",
    defineProperty: "es.reflect.define-property",
    deleteMetadata: "esnext.reflect.delete-metadata",
    deleteProperty: "es.reflect.delete-property",
    get: "es.reflect.get",
    getMetadata: "esnext.reflect.get-metadata",
    getMetadataKeys: "esnext.reflect.get-metadata-keys",
    getOwnMetadata: "esnext.reflect.get-own-metadata",
    getOwnMetadataKeys: "esnext.reflect.get-own-metadata-keys",
    getOwnPropertyDescriptor: "es.reflect.get-own-property-descriptor",
    getPrototypeOf: "es.reflect.get-prototype-of",
    has: "es.reflect.has",
    hasMetadata: "esnext.reflect.has-metadata",
    hasOwnMetadata: "esnext.reflect.has-own-metadata",
    isExtensible: "es.reflect.is-extensible",
    metadata: "esnext.reflect.metadata",
    ownKeys: "es.reflect.own-keys",
    preventExtensions: "es.reflect.prevent-extensions",
    set: "es.reflect.set",
    setPrototypeOf: "es.reflect.set-prototype-of"
  },
  Symbol: {
    asyncIterator: ["es.symbol.async-iterator"],
    dispose: ["esnext.symbol.dispose"],
    hasInstance: ["es.symbol.has-instance", "es.function.has-instance"],
    isConcatSpreadable: ["es.symbol.is-concat-spreadable", "es.array.concat"],
    iterator: ["es.symbol.iterator", ...CommonIteratorsWithTag],
    match: ["es.symbol.match", "es.string.match"],
    observable: ["esnext.symbol.observable"],
    patternMatch: ["esnext.symbol.pattern-match"],
    replace: ["es.symbol.replace", "es.string.replace"],
    search: ["es.symbol.search", "es.string.search"],
    species: ["es.symbol.species", "es.array.species"],
    split: ["es.symbol.split", "es.string.split"],
    toPrimitive: ["es.symbol.to-primitive", "es.date.to-primitive"],
    toStringTag: ["es.symbol.to-string-tag", "es.object.to-string", "es.math.to-string-tag", "es.json.to-string-tag"],
    unscopables: ["es.symbol.unscopables"]
  },
  ArrayBuffer: {
    isView: ["es.array-buffer.is-view"]
  },
  Int8Array: TypedArrayStaticMethods,
  Uint8Array: TypedArrayStaticMethods,
  Uint8ClampedArray: TypedArrayStaticMethods,
  Int16Array: TypedArrayStaticMethods,
  Uint16Array: TypedArrayStaticMethods,
  Int32Array: TypedArrayStaticMethods,
  Uint32Array: TypedArrayStaticMethods,
  Float32Array: TypedArrayStaticMethods,
  Float64Array: TypedArrayStaticMethods
};
exports.StaticProperties = StaticProperties;
const CommonInstanceDependencies = new Set(["es.object.to-string", "es.object.define-getter", "es.object.define-setter", "es.object.lookup-getter", "es.object.lookup-setter", "es.regexp.exec"]);
exports.CommonInstanceDependencies = CommonInstanceDependencies;
const PossibleGlobalObjects = new Set(["global", "globalThis", "self", "window"]);
exports.PossibleGlobalObjects = PossibleGlobalObjects;

/***/ }),
/* 98 */,
/* 99 */
/***/ (function(__unusedmodule, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hooks = void 0;
const hooks = [function (self, parent) {
  const removeParent = self.key === "test" && (parent.isWhile() || parent.isSwitchCase()) || self.key === "declaration" && parent.isExportDeclaration() || self.key === "body" && parent.isLabeledStatement() || self.listKey === "declarations" && parent.isVariableDeclaration() && parent.node.declarations.length === 1 || self.key === "expression" && parent.isExpressionStatement();

  if (removeParent) {
    parent.remove();
    return true;
  }
}, function (self, parent) {
  if (parent.isSequenceExpression() && parent.node.expressions.length === 1) {
    parent.replaceWith(parent.node.expressions[0]);
    return true;
  }
}, function (self, parent) {
  if (parent.isBinary()) {
    if (self.key === "left") {
      parent.replaceWith(parent.node.right);
    } else {
      parent.replaceWith(parent.node.left);
    }

    return true;
  }
}, function (self, parent) {
  if (parent.isIfStatement() && (self.key === "consequent" || self.key === "alternate") || self.key === "body" && (parent.isLoop() || parent.isArrowFunctionExpression())) {
    self.replaceWith({
      type: "BlockStatement",
      body: []
    });
    return true;
  }
}];
exports.hooks = hooks;

/***/ }),
/* 100 */,
/* 101 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = gatherSequenceExpressions;

var _getBindingIdentifiers = _interopRequireDefault(__webpack_require__(705));

var _generated = __webpack_require__(897);

var _generated2 = __webpack_require__(405);

var _cloneNode = _interopRequireDefault(__webpack_require__(533));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function gatherSequenceExpressions(nodes, scope, declars) {
  const exprs = [];
  let ensureLastUndefined = true;

  for (const node of nodes) {
    ensureLastUndefined = false;

    if ((0, _generated.isExpression)(node)) {
      exprs.push(node);
    } else if ((0, _generated.isExpressionStatement)(node)) {
      exprs.push(node.expression);
    } else if ((0, _generated.isVariableDeclaration)(node)) {
      if (node.kind !== "var") return;

      for (const declar of node.declarations) {
        const bindings = (0, _getBindingIdentifiers.default)(declar);

        for (const key of Object.keys(bindings)) {
          declars.push({
            kind: node.kind,
            id: (0, _cloneNode.default)(bindings[key])
          });
        }

        if (declar.init) {
          exprs.push((0, _generated2.assignmentExpression)("=", declar.id, declar.init));
        }
      }

      ensureLastUndefined = true;
    } else if ((0, _generated.isIfStatement)(node)) {
      const consequent = node.consequent ? gatherSequenceExpressions([node.consequent], scope, declars) : scope.buildUndefinedNode();
      const alternate = node.alternate ? gatherSequenceExpressions([node.alternate], scope, declars) : scope.buildUndefinedNode();
      if (!consequent || !alternate) return;
      exprs.push((0, _generated2.conditionalExpression)(node.test, consequent, alternate));
    } else if ((0, _generated.isBlockStatement)(node)) {
      const body = gatherSequenceExpressions(node.body, scope, declars);
      if (!body) return;
      exprs.push(body);
    } else if ((0, _generated.isEmptyStatement)(node)) {
      ensureLastUndefined = true;
    } else {
      return;
    }
  }

  if (ensureLastUndefined) {
    exprs.push(scope.buildUndefinedNode());
  }

  if (exprs.length === 1) {
    return exprs[0];
  } else {
    return (0, _generated2.sequenceExpression)(exprs);
  }
}

/***/ }),
/* 102 */,
/* 103 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFromAstSync = transformFromAstSync;
exports.transformFromAstAsync = transformFromAstAsync;
exports.transformFromAst = void 0;

var _config = _interopRequireDefault(__webpack_require__(520));

var _transformation = __webpack_require__(367);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const transformFromAst = function transformFromAst(ast, code, opts, callback) {
  if (typeof opts === "function") {
    callback = opts;
    opts = undefined;
  }

  if (callback === undefined) return transformFromAstSync(ast, code, opts);
  const cb = callback;
  process.nextTick(() => {
    let cfg;

    try {
      cfg = (0, _config.default)(opts);
      if (cfg === null) return cb(null, null);
    } catch (err) {
      return cb(err);
    }

    if (!ast) return cb(new Error("No AST given"));
    (0, _transformation.runAsync)(cfg, code, ast, cb);
  });
};

exports.transformFromAst = transformFromAst;

function transformFromAstSync(ast, code, opts) {
  const config = (0, _config.default)(opts);
  if (config === null) return null;
  if (!ast) throw new Error("No AST given");
  return (0, _transformation.runSync)(config, code, ast);
}

function transformFromAstAsync(ast, code, opts) {
  return new Promise((res, rej) => {
    transformFromAst(ast, code, opts, (err, result) => {
      if (err == null) res(result);else rej(err);
    });
  });
}

/***/ }),
/* 104 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addDefault = addDefault;
exports.addNamed = addNamed;
exports.addNamespace = addNamespace;
exports.addSideEffect = addSideEffect;
Object.defineProperty(exports, "ImportInjector", {
  enumerable: true,
  get: function () {
    return _importInjector.default;
  }
});
Object.defineProperty(exports, "isModule", {
  enumerable: true,
  get: function () {
    return _isModule.default;
  }
});

var _importInjector = _interopRequireDefault(__webpack_require__(24));

var _isModule = _interopRequireDefault(__webpack_require__(916));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function addDefault(path, importedSource, opts) {
  return new _importInjector.default(path).addDefault(importedSource, opts);
}

function addNamed(path, name, importedSource, opts) {
  return new _importInjector.default(path).addNamed(name, importedSource, opts);
}

function addNamespace(path, importedSource, opts) {
  return new _importInjector.default(path).addNamespace(importedSource, opts);
}

function addSideEffect(path, importedSource, opts) {
  return new _importInjector.default(path).addSideEffect(importedSource, opts);
}

/***/ }),
/* 105 */,
/* 106 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.is = is;
exports.pullFlag = pullFlag;

function _pull() {
  const data = _interopRequireDefault(__webpack_require__(502));

  _pull = function () {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function is(node, flag) {
  return node.type === "RegExpLiteral" && node.flags.indexOf(flag) >= 0;
}

function pullFlag(node, flag) {
  const flags = node.flags.split("");
  if (node.flags.indexOf(flag) < 0) return;
  (0, _pull().default)(flags, flag);
  node.flags = flags.join("");
}

/***/ }),
/* 107 */,
/* 108 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = inheritsComments;

var _inheritTrailingComments = _interopRequireDefault(__webpack_require__(253));

var _inheritLeadingComments = _interopRequireDefault(__webpack_require__(618));

var _inheritInnerComments = _interopRequireDefault(__webpack_require__(315));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function inheritsComments(child, parent) {
  (0, _inheritTrailingComments.default)(child, parent);
  (0, _inheritLeadingComments.default)(child, parent);
  (0, _inheritInnerComments.default)(child, parent);
  return child;
}

/***/ }),
/* 109 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseGetTag = __webpack_require__(51),
    isObjectLike = __webpack_require__(337);

/** `Object#toString` result references. */
var regexpTag = '[object RegExp]';

/**
 * The base implementation of `_.isRegExp` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a regexp, else `false`.
 */
function baseIsRegExp(value) {
  return isObjectLike(value) && baseGetTag(value) == regexpTag;
}

module.exports = baseIsRegExp;


/***/ }),
/* 110 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseSlice = __webpack_require__(778),
    isIterateeCall = __webpack_require__(663),
    toInteger = __webpack_require__(813);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeCeil = Math.ceil,
    nativeMax = Math.max;

/**
 * Creates an array of elements split into groups the length of `size`.
 * If `array` can't be split evenly, the final chunk will be the remaining
 * elements.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Array
 * @param {Array} array The array to process.
 * @param {number} [size=1] The length of each chunk
 * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
 * @returns {Array} Returns the new array of chunks.
 * @example
 *
 * _.chunk(['a', 'b', 'c', 'd'], 2);
 * // => [['a', 'b'], ['c', 'd']]
 *
 * _.chunk(['a', 'b', 'c', 'd'], 3);
 * // => [['a', 'b', 'c'], ['d']]
 */
function chunk(array, size, guard) {
  if ((guard ? isIterateeCall(array, size, guard) : size === undefined)) {
    size = 1;
  } else {
    size = nativeMax(toInteger(size), 0);
  }
  var length = array == null ? 0 : array.length;
  if (!length || size < 1) {
    return [];
  }
  var index = 0,
      resIndex = 0,
      result = Array(nativeCeil(length / size));

  while (index < length) {
    result[resIndex++] = baseSlice(array, index, (index += size));
  }
  return result;
}

module.exports = chunk;


/***/ }),
/* 111 */,
/* 112 */,
/* 113 */,
/* 114 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseValues = __webpack_require__(378),
    keys = __webpack_require__(863);

/**
 * Creates an array of the own enumerable string keyed property values of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property values.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.values(new Foo);
 * // => [1, 2] (iteration order is not guaranteed)
 *
 * _.values('hi');
 * // => ['h', 'i']
 */
function values(object) {
  return object == null ? [] : baseValues(object, keys(object));
}

module.exports = values;


/***/ }),
/* 115 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = removeTypeDuplicates;

var _generated = __webpack_require__(897);

function removeTypeDuplicates(nodes) {
  const generics = {};
  const bases = {};
  const typeGroups = [];
  const types = [];

  for (let i = 0; i < nodes.length; i++) {
    const node = nodes[i];
    if (!node) continue;

    if (types.indexOf(node) >= 0) {
      continue;
    }

    if ((0, _generated.isAnyTypeAnnotation)(node)) {
      return [node];
    }

    if ((0, _generated.isFlowBaseAnnotation)(node)) {
      bases[node.type] = node;
      continue;
    }

    if ((0, _generated.isUnionTypeAnnotation)(node)) {
      if (typeGroups.indexOf(node.types) < 0) {
        nodes = nodes.concat(node.types);
        typeGroups.push(node.types);
      }

      continue;
    }

    if ((0, _generated.isGenericTypeAnnotation)(node)) {
      const name = node.id.name;

      if (generics[name]) {
        let existing = generics[name];

        if (existing.typeParameters) {
          if (node.typeParameters) {
            existing.typeParameters.params = removeTypeDuplicates(existing.typeParameters.params.concat(node.typeParameters.params));
          }
        } else {
          existing = node.typeParameters;
        }
      } else {
        generics[name] = node;
      }

      continue;
    }

    types.push(node);
  }

  for (const type of Object.keys(bases)) {
    types.push(bases[type]);
  }

  for (const name of Object.keys(generics)) {
    types.push(generics[name]);
  }

  return types;
}

/***/ }),
/* 116 */,
/* 117 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isLet;

var _generated = __webpack_require__(897);

var _constants = __webpack_require__(68);

function isLet(node) {
  return (0, _generated.isVariableDeclaration)(node) && (node.kind !== "var" || node[_constants.BLOCK_SCOPED_SYMBOL]);
}

/***/ }),
/* 118 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _includes = _interopRequireDefault(__webpack_require__(249));

var _repeat = _interopRequireDefault(__webpack_require__(258));

var _renamer = _interopRequireDefault(__webpack_require__(862));

var _index = _interopRequireDefault(__webpack_require__(167));

var _defaults = _interopRequireDefault(__webpack_require__(605));

var _binding = _interopRequireDefault(__webpack_require__(923));

var _globals = _interopRequireDefault(__webpack_require__(938));

var t = _interopRequireWildcard(__webpack_require__(978));

var _cache = __webpack_require__(715);

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function gatherNodeParts(node, parts) {
  if (t.isModuleDeclaration(node)) {
    if (node.source) {
      gatherNodeParts(node.source, parts);
    } else if (node.specifiers && node.specifiers.length) {
      for (const specifier of node.specifiers) {
        gatherNodeParts(specifier, parts);
      }
    } else if (node.declaration) {
      gatherNodeParts(node.declaration, parts);
    }
  } else if (t.isModuleSpecifier(node)) {
    gatherNodeParts(node.local, parts);
  } else if (t.isMemberExpression(node)) {
    gatherNodeParts(node.object, parts);
    gatherNodeParts(node.property, parts);
  } else if (t.isIdentifier(node)) {
    parts.push(node.name);
  } else if (t.isLiteral(node)) {
    parts.push(node.value);
  } else if (t.isCallExpression(node)) {
    gatherNodeParts(node.callee, parts);
  } else if (t.isObjectExpression(node) || t.isObjectPattern(node)) {
    for (const prop of node.properties) {
      gatherNodeParts(prop.key || prop.argument, parts);
    }
  } else if (t.isPrivateName(node)) {
    gatherNodeParts(node.id, parts);
  } else if (t.isThisExpression(node)) {
    parts.push("this");
  } else if (t.isSuper(node)) {
    parts.push("super");
  }
}

const collectorVisitor = {
  For(path) {
    for (const key of t.FOR_INIT_KEYS) {
      const declar = path.get(key);

      if (declar.isVar()) {
        const parentScope = path.scope.getFunctionParent() || path.scope.getProgramParent();
        parentScope.registerBinding("var", declar);
      }
    }
  },

  Declaration(path) {
    if (path.isBlockScoped()) return;

    if (path.isExportDeclaration() && path.get("declaration").isDeclaration()) {
      return;
    }

    const parent = path.scope.getFunctionParent() || path.scope.getProgramParent();
    parent.registerDeclaration(path);
  },

  ReferencedIdentifier(path, state) {
    state.references.push(path);
  },

  ForXStatement(path, state) {
    const left = path.get("left");

    if (left.isPattern() || left.isIdentifier()) {
      state.constantViolations.push(path);
    }
  },

  ExportDeclaration: {
    exit(path) {
      const {
        node,
        scope
      } = path;
      const declar = node.declaration;

      if (t.isClassDeclaration(declar) || t.isFunctionDeclaration(declar)) {
        const id = declar.id;
        if (!id) return;
        const binding = scope.getBinding(id.name);
        if (binding) binding.reference(path);
      } else if (t.isVariableDeclaration(declar)) {
        for (const decl of declar.declarations) {
          for (const name of Object.keys(t.getBindingIdentifiers(decl))) {
            const binding = scope.getBinding(name);
            if (binding) binding.reference(path);
          }
        }
      }
    }

  },

  LabeledStatement(path) {
    path.scope.getProgramParent().addGlobal(path.node);
    path.scope.getBlockParent().registerDeclaration(path);
  },

  AssignmentExpression(path, state) {
    state.assignments.push(path);
  },

  UpdateExpression(path, state) {
    state.constantViolations.push(path);
  },

  UnaryExpression(path, state) {
    if (path.node.operator === "delete") {
      state.constantViolations.push(path);
    }
  },

  BlockScoped(path) {
    let scope = path.scope;
    if (scope.path === path) scope = scope.parent;
    scope.getBlockParent().registerDeclaration(path);
  },

  ClassDeclaration(path) {
    const id = path.node.id;
    if (!id) return;
    const name = id.name;
    path.scope.bindings[name] = path.scope.getBinding(name);
  },

  Block(path) {
    const paths = path.get("body");

    for (const bodyPath of paths) {
      if (bodyPath.isFunctionDeclaration()) {
        path.scope.getBlockParent().registerDeclaration(bodyPath);
      }
    }
  }

};
let uid = 0;

class Scope {
  constructor(path) {
    const {
      node
    } = path;

    const cached = _cache.scope.get(node);

    if (cached && cached.path === path) {
      return cached;
    }

    _cache.scope.set(node, this);

    this.uid = uid++;
    this.block = node;
    this.path = path;
    this.labels = new Map();
  }

  get parent() {
    const parent = this.path.findParent(p => p.isScope());
    return parent && parent.scope;
  }

  get parentBlock() {
    return this.path.parent;
  }

  get hub() {
    return this.path.hub;
  }

  traverse(node, opts, state) {
    (0, _index.default)(node, opts, this, state, this.path);
  }

  generateDeclaredUidIdentifier(name) {
    const id = this.generateUidIdentifier(name);
    this.push({
      id
    });
    return t.cloneNode(id);
  }

  generateUidIdentifier(name) {
    return t.identifier(this.generateUid(name));
  }

  generateUid(name = "temp") {
    name = t.toIdentifier(name).replace(/^_+/, "").replace(/[0-9]+$/g, "");
    let uid;
    let i = 0;

    do {
      uid = this._generateUid(name, i);
      i++;
    } while (this.hasLabel(uid) || this.hasBinding(uid) || this.hasGlobal(uid) || this.hasReference(uid));

    const program = this.getProgramParent();
    program.references[uid] = true;
    program.uids[uid] = true;
    return uid;
  }

  _generateUid(name, i) {
    let id = name;
    if (i > 1) id += i;
    return `_${id}`;
  }

  generateUidBasedOnNode(parent, defaultName) {
    let node = parent;

    if (t.isAssignmentExpression(parent)) {
      node = parent.left;
    } else if (t.isVariableDeclarator(parent)) {
      node = parent.id;
    } else if (t.isObjectProperty(node) || t.isObjectMethod(node)) {
      node = node.key;
    }

    const parts = [];
    gatherNodeParts(node, parts);
    let id = parts.join("$");
    id = id.replace(/^_/, "") || defaultName || "ref";
    return this.generateUid(id.slice(0, 20));
  }

  generateUidIdentifierBasedOnNode(parent, defaultName) {
    return t.identifier(this.generateUidBasedOnNode(parent, defaultName));
  }

  isStatic(node) {
    if (t.isThisExpression(node) || t.isSuper(node)) {
      return true;
    }

    if (t.isIdentifier(node)) {
      const binding = this.getBinding(node.name);

      if (binding) {
        return binding.constant;
      } else {
        return this.hasBinding(node.name);
      }
    }

    return false;
  }

  maybeGenerateMemoised(node, dontPush) {
    if (this.isStatic(node)) {
      return null;
    } else {
      const id = this.generateUidIdentifierBasedOnNode(node);

      if (!dontPush) {
        this.push({
          id
        });
        return t.cloneNode(id);
      }

      return id;
    }
  }

  checkBlockScopedCollisions(local, kind, name, id) {
    if (kind === "param") return;
    if (local.kind === "local") return;
    const duplicate = kind === "let" || local.kind === "let" || local.kind === "const" || local.kind === "module" || local.kind === "param" && (kind === "let" || kind === "const");

    if (duplicate) {
      throw this.hub.buildError(id, `Duplicate declaration "${name}"`, TypeError);
    }
  }

  rename(oldName, newName, block) {
    const binding = this.getBinding(oldName);

    if (binding) {
      newName = newName || this.generateUidIdentifier(oldName).name;
      return new _renamer.default(binding, oldName, newName).rename(block);
    }
  }

  _renameFromMap(map, oldName, newName, value) {
    if (map[oldName]) {
      map[newName] = value;
      map[oldName] = null;
    }
  }

  dump() {
    const sep = (0, _repeat.default)("-", 60);
    console.log(sep);
    let scope = this;

    do {
      console.log("#", scope.block.type);

      for (const name of Object.keys(scope.bindings)) {
        const binding = scope.bindings[name];
        console.log(" -", name, {
          constant: binding.constant,
          references: binding.references,
          violations: binding.constantViolations.length,
          kind: binding.kind
        });
      }
    } while (scope = scope.parent);

    console.log(sep);
  }

  toArray(node, i) {
    if (t.isIdentifier(node)) {
      const binding = this.getBinding(node.name);

      if (binding && binding.constant && binding.path.isGenericType("Array")) {
        return node;
      }
    }

    if (t.isArrayExpression(node)) {
      return node;
    }

    if (t.isIdentifier(node, {
      name: "arguments"
    })) {
      return t.callExpression(t.memberExpression(t.memberExpression(t.memberExpression(t.identifier("Array"), t.identifier("prototype")), t.identifier("slice")), t.identifier("call")), [node]);
    }

    let helperName;
    const args = [node];

    if (i === true) {
      helperName = "toConsumableArray";
    } else if (i) {
      args.push(t.numericLiteral(i));
      helperName = "slicedToArray";
    } else {
      helperName = "toArray";
    }

    return t.callExpression(this.hub.addHelper(helperName), args);
  }

  hasLabel(name) {
    return !!this.getLabel(name);
  }

  getLabel(name) {
    return this.labels.get(name);
  }

  registerLabel(path) {
    this.labels.set(path.node.label.name, path);
  }

  registerDeclaration(path) {
    if (path.isLabeledStatement()) {
      this.registerLabel(path);
    } else if (path.isFunctionDeclaration()) {
      this.registerBinding("hoisted", path.get("id"), path);
    } else if (path.isVariableDeclaration()) {
      const declarations = path.get("declarations");

      for (const declar of declarations) {
        this.registerBinding(path.node.kind, declar);
      }
    } else if (path.isClassDeclaration()) {
      this.registerBinding("let", path);
    } else if (path.isImportDeclaration()) {
      const specifiers = path.get("specifiers");

      for (const specifier of specifiers) {
        this.registerBinding("module", specifier);
      }
    } else if (path.isExportDeclaration()) {
      const declar = path.get("declaration");

      if (declar.isClassDeclaration() || declar.isFunctionDeclaration() || declar.isVariableDeclaration()) {
        this.registerDeclaration(declar);
      }
    } else {
      this.registerBinding("unknown", path);
    }
  }

  buildUndefinedNode() {
    return t.unaryExpression("void", t.numericLiteral(0), true);
  }

  registerConstantViolation(path) {
    const ids = path.getBindingIdentifiers();

    for (const name of Object.keys(ids)) {
      const binding = this.getBinding(name);
      if (binding) binding.reassign(path);
    }
  }

  registerBinding(kind, path, bindingPath = path) {
    if (!kind) throw new ReferenceError("no `kind`");

    if (path.isVariableDeclaration()) {
      const declarators = path.get("declarations");

      for (const declar of declarators) {
        this.registerBinding(kind, declar);
      }

      return;
    }

    const parent = this.getProgramParent();
    const ids = path.getOuterBindingIdentifiers(true);

    for (const name of Object.keys(ids)) {
      for (const id of ids[name]) {
        const local = this.getOwnBinding(name);

        if (local) {
          if (local.identifier === id) continue;
          this.checkBlockScopedCollisions(local, kind, name, id);
        }

        parent.references[name] = true;

        if (local) {
          this.registerConstantViolation(bindingPath);
        } else {
          this.bindings[name] = new _binding.default({
            identifier: id,
            scope: this,
            path: bindingPath,
            kind: kind
          });
        }
      }
    }
  }

  addGlobal(node) {
    this.globals[node.name] = node;
  }

  hasUid(name) {
    let scope = this;

    do {
      if (scope.uids[name]) return true;
    } while (scope = scope.parent);

    return false;
  }

  hasGlobal(name) {
    let scope = this;

    do {
      if (scope.globals[name]) return true;
    } while (scope = scope.parent);

    return false;
  }

  hasReference(name) {
    let scope = this;

    do {
      if (scope.references[name]) return true;
    } while (scope = scope.parent);

    return false;
  }

  isPure(node, constantsOnly) {
    if (t.isIdentifier(node)) {
      const binding = this.getBinding(node.name);
      if (!binding) return false;
      if (constantsOnly) return binding.constant;
      return true;
    } else if (t.isClass(node)) {
      if (node.superClass && !this.isPure(node.superClass, constantsOnly)) {
        return false;
      }

      return this.isPure(node.body, constantsOnly);
    } else if (t.isClassBody(node)) {
      for (const method of node.body) {
        if (!this.isPure(method, constantsOnly)) return false;
      }

      return true;
    } else if (t.isBinary(node)) {
      return this.isPure(node.left, constantsOnly) && this.isPure(node.right, constantsOnly);
    } else if (t.isArrayExpression(node)) {
      for (const elem of node.elements) {
        if (!this.isPure(elem, constantsOnly)) return false;
      }

      return true;
    } else if (t.isObjectExpression(node)) {
      for (const prop of node.properties) {
        if (!this.isPure(prop, constantsOnly)) return false;
      }

      return true;
    } else if (t.isClassMethod(node)) {
      if (node.computed && !this.isPure(node.key, constantsOnly)) return false;
      if (node.kind === "get" || node.kind === "set") return false;
      return true;
    } else if (t.isProperty(node)) {
      if (node.computed && !this.isPure(node.key, constantsOnly)) return false;
      return this.isPure(node.value, constantsOnly);
    } else if (t.isUnaryExpression(node)) {
      return this.isPure(node.argument, constantsOnly);
    } else if (t.isTaggedTemplateExpression(node)) {
      return t.matchesPattern(node.tag, "String.raw") && !this.hasBinding("String", true) && this.isPure(node.quasi, constantsOnly);
    } else if (t.isTemplateLiteral(node)) {
      for (const expression of node.expressions) {
        if (!this.isPure(expression, constantsOnly)) return false;
      }

      return true;
    } else {
      return t.isPureish(node);
    }
  }

  setData(key, val) {
    return this.data[key] = val;
  }

  getData(key) {
    let scope = this;

    do {
      const data = scope.data[key];
      if (data != null) return data;
    } while (scope = scope.parent);
  }

  removeData(key) {
    let scope = this;

    do {
      const data = scope.data[key];
      if (data != null) scope.data[key] = null;
    } while (scope = scope.parent);
  }

  init() {
    if (!this.references) this.crawl();
  }

  crawl() {
    const path = this.path;
    this.references = Object.create(null);
    this.bindings = Object.create(null);
    this.globals = Object.create(null);
    this.uids = Object.create(null);
    this.data = Object.create(null);

    if (path.isLoop()) {
      for (const key of t.FOR_INIT_KEYS) {
        const node = path.get(key);
        if (node.isBlockScoped()) this.registerBinding(node.node.kind, node);
      }
    }

    if (path.isFunctionExpression() && path.has("id")) {
      if (!path.get("id").node[t.NOT_LOCAL_BINDING]) {
        this.registerBinding("local", path.get("id"), path);
      }
    }

    if (path.isClassExpression() && path.has("id")) {
      if (!path.get("id").node[t.NOT_LOCAL_BINDING]) {
        this.registerBinding("local", path);
      }
    }

    if (path.isFunction()) {
      const params = path.get("params");

      for (const param of params) {
        this.registerBinding("param", param);
      }
    }

    if (path.isCatchClause()) {
      this.registerBinding("let", path);
    }

    const parent = this.getProgramParent();
    if (parent.crawling) return;
    const state = {
      references: [],
      constantViolations: [],
      assignments: []
    };
    this.crawling = true;
    path.traverse(collectorVisitor, state);
    this.crawling = false;

    for (const path of state.assignments) {
      const ids = path.getBindingIdentifiers();
      let programParent;

      for (const name of Object.keys(ids)) {
        if (path.scope.getBinding(name)) continue;
        programParent = programParent || path.scope.getProgramParent();
        programParent.addGlobal(ids[name]);
      }

      path.scope.registerConstantViolation(path);
    }

    for (const ref of state.references) {
      const binding = ref.scope.getBinding(ref.node.name);

      if (binding) {
        binding.reference(ref);
      } else {
        ref.scope.getProgramParent().addGlobal(ref.node);
      }
    }

    for (const path of state.constantViolations) {
      path.scope.registerConstantViolation(path);
    }
  }

  push(opts) {
    let path = this.path;

    if (!path.isBlockStatement() && !path.isProgram()) {
      path = this.getBlockParent().path;
    }

    if (path.isSwitchStatement()) {
      path = (this.getFunctionParent() || this.getProgramParent()).path;
    }

    if (path.isLoop() || path.isCatchClause() || path.isFunction()) {
      path.ensureBlock();
      path = path.get("body");
    }

    const unique = opts.unique;
    const kind = opts.kind || "var";
    const blockHoist = opts._blockHoist == null ? 2 : opts._blockHoist;
    const dataKey = `declaration:${kind}:${blockHoist}`;
    let declarPath = !unique && path.getData(dataKey);

    if (!declarPath) {
      const declar = t.variableDeclaration(kind, []);
      declar._blockHoist = blockHoist;
      [declarPath] = path.unshiftContainer("body", [declar]);
      if (!unique) path.setData(dataKey, declarPath);
    }

    const declarator = t.variableDeclarator(opts.id, opts.init);
    declarPath.node.declarations.push(declarator);
    this.registerBinding(kind, declarPath.get("declarations").pop());
  }

  getProgramParent() {
    let scope = this;

    do {
      if (scope.path.isProgram()) {
        return scope;
      }
    } while (scope = scope.parent);

    throw new Error("Couldn't find a Program");
  }

  getFunctionParent() {
    let scope = this;

    do {
      if (scope.path.isFunctionParent()) {
        return scope;
      }
    } while (scope = scope.parent);

    return null;
  }

  getBlockParent() {
    let scope = this;

    do {
      if (scope.path.isBlockParent()) {
        return scope;
      }
    } while (scope = scope.parent);

    throw new Error("We couldn't find a BlockStatement, For, Switch, Function, Loop or Program...");
  }

  getAllBindings() {
    const ids = Object.create(null);
    let scope = this;

    do {
      (0, _defaults.default)(ids, scope.bindings);
      scope = scope.parent;
    } while (scope);

    return ids;
  }

  getAllBindingsOfKind() {
    const ids = Object.create(null);

    for (const kind of arguments) {
      let scope = this;

      do {
        for (const name of Object.keys(scope.bindings)) {
          const binding = scope.bindings[name];
          if (binding.kind === kind) ids[name] = binding;
        }

        scope = scope.parent;
      } while (scope);
    }

    return ids;
  }

  bindingIdentifierEquals(name, node) {
    return this.getBindingIdentifier(name) === node;
  }

  getBinding(name) {
    let scope = this;

    do {
      const binding = scope.getOwnBinding(name);
      if (binding) return binding;
    } while (scope = scope.parent);
  }

  getOwnBinding(name) {
    return this.bindings[name];
  }

  getBindingIdentifier(name) {
    const info = this.getBinding(name);
    return info && info.identifier;
  }

  getOwnBindingIdentifier(name) {
    const binding = this.bindings[name];
    return binding && binding.identifier;
  }

  hasOwnBinding(name) {
    return !!this.getOwnBinding(name);
  }

  hasBinding(name, noGlobals) {
    if (!name) return false;
    if (this.hasOwnBinding(name)) return true;
    if (this.parentHasBinding(name, noGlobals)) return true;
    if (this.hasUid(name)) return true;
    if (!noGlobals && (0, _includes.default)(Scope.globals, name)) return true;
    if (!noGlobals && (0, _includes.default)(Scope.contextVariables, name)) return true;
    return false;
  }

  parentHasBinding(name, noGlobals) {
    return this.parent && this.parent.hasBinding(name, noGlobals);
  }

  moveBindingTo(name, scope) {
    const info = this.getBinding(name);

    if (info) {
      info.scope.removeOwnBinding(name);
      info.scope = scope;
      scope.bindings[name] = info;
    }
  }

  removeOwnBinding(name) {
    delete this.bindings[name];
  }

  removeBinding(name) {
    const info = this.getBinding(name);

    if (info) {
      info.scope.removeOwnBinding(name);
    }

    let scope = this;

    do {
      if (scope.uids[name]) {
        scope.uids[name] = false;
      }
    } while (scope = scope.parent);
  }

}

exports.default = Scope;
Scope.globals = Object.keys(_globals.default.builtin);
Scope.contextVariables = ["arguments", "undefined", "Infinity", "NaN"];

/***/ }),
/* 119 */
/***/ (function(module) {

module.exports = new Map([
	['General_Category', new Map([
		['C', 'Other'],
		['Cc', 'Control'],
		['cntrl', 'Control'],
		['Cf', 'Format'],
		['Cn', 'Unassigned'],
		['Co', 'Private_Use'],
		['Cs', 'Surrogate'],
		['L', 'Letter'],
		['LC', 'Cased_Letter'],
		['Ll', 'Lowercase_Letter'],
		['Lm', 'Modifier_Letter'],
		['Lo', 'Other_Letter'],
		['Lt', 'Titlecase_Letter'],
		['Lu', 'Uppercase_Letter'],
		['M', 'Mark'],
		['Combining_Mark', 'Mark'],
		['Mc', 'Spacing_Mark'],
		['Me', 'Enclosing_Mark'],
		['Mn', 'Nonspacing_Mark'],
		['N', 'Number'],
		['Nd', 'Decimal_Number'],
		['digit', 'Decimal_Number'],
		['Nl', 'Letter_Number'],
		['No', 'Other_Number'],
		['P', 'Punctuation'],
		['punct', 'Punctuation'],
		['Pc', 'Connector_Punctuation'],
		['Pd', 'Dash_Punctuation'],
		['Pe', 'Close_Punctuation'],
		['Pf', 'Final_Punctuation'],
		['Pi', 'Initial_Punctuation'],
		['Po', 'Other_Punctuation'],
		['Ps', 'Open_Punctuation'],
		['S', 'Symbol'],
		['Sc', 'Currency_Symbol'],
		['Sk', 'Modifier_Symbol'],
		['Sm', 'Math_Symbol'],
		['So', 'Other_Symbol'],
		['Z', 'Separator'],
		['Zl', 'Line_Separator'],
		['Zp', 'Paragraph_Separator'],
		['Zs', 'Space_Separator'],
		['Other', 'Other'],
		['Control', 'Control'],
		['Format', 'Format'],
		['Unassigned', 'Unassigned'],
		['Private_Use', 'Private_Use'],
		['Surrogate', 'Surrogate'],
		['Letter', 'Letter'],
		['Cased_Letter', 'Cased_Letter'],
		['Lowercase_Letter', 'Lowercase_Letter'],
		['Modifier_Letter', 'Modifier_Letter'],
		['Other_Letter', 'Other_Letter'],
		['Titlecase_Letter', 'Titlecase_Letter'],
		['Uppercase_Letter', 'Uppercase_Letter'],
		['Mark', 'Mark'],
		['Spacing_Mark', 'Spacing_Mark'],
		['Enclosing_Mark', 'Enclosing_Mark'],
		['Nonspacing_Mark', 'Nonspacing_Mark'],
		['Number', 'Number'],
		['Decimal_Number', 'Decimal_Number'],
		['Letter_Number', 'Letter_Number'],
		['Other_Number', 'Other_Number'],
		['Punctuation', 'Punctuation'],
		['Connector_Punctuation', 'Connector_Punctuation'],
		['Dash_Punctuation', 'Dash_Punctuation'],
		['Close_Punctuation', 'Close_Punctuation'],
		['Final_Punctuation', 'Final_Punctuation'],
		['Initial_Punctuation', 'Initial_Punctuation'],
		['Other_Punctuation', 'Other_Punctuation'],
		['Open_Punctuation', 'Open_Punctuation'],
		['Symbol', 'Symbol'],
		['Currency_Symbol', 'Currency_Symbol'],
		['Modifier_Symbol', 'Modifier_Symbol'],
		['Math_Symbol', 'Math_Symbol'],
		['Other_Symbol', 'Other_Symbol'],
		['Separator', 'Separator'],
		['Line_Separator', 'Line_Separator'],
		['Paragraph_Separator', 'Paragraph_Separator'],
		['Space_Separator', 'Space_Separator']
	])],
	['Script', new Map([
		['Adlm', 'Adlam'],
		['Aghb', 'Caucasian_Albanian'],
		['Ahom', 'Ahom'],
		['Arab', 'Arabic'],
		['Armi', 'Imperial_Aramaic'],
		['Armn', 'Armenian'],
		['Avst', 'Avestan'],
		['Bali', 'Balinese'],
		['Bamu', 'Bamum'],
		['Bass', 'Bassa_Vah'],
		['Batk', 'Batak'],
		['Beng', 'Bengali'],
		['Bhks', 'Bhaiksuki'],
		['Bopo', 'Bopomofo'],
		['Brah', 'Brahmi'],
		['Brai', 'Braille'],
		['Bugi', 'Buginese'],
		['Buhd', 'Buhid'],
		['Cakm', 'Chakma'],
		['Cans', 'Canadian_Aboriginal'],
		['Cari', 'Carian'],
		['Cham', 'Cham'],
		['Cher', 'Cherokee'],
		['Copt', 'Coptic'],
		['Qaac', 'Coptic'],
		['Cprt', 'Cypriot'],
		['Cyrl', 'Cyrillic'],
		['Deva', 'Devanagari'],
		['Dogr', 'Dogra'],
		['Dsrt', 'Deseret'],
		['Dupl', 'Duployan'],
		['Egyp', 'Egyptian_Hieroglyphs'],
		['Elba', 'Elbasan'],
		['Elym', 'Elymaic'],
		['Ethi', 'Ethiopic'],
		['Geor', 'Georgian'],
		['Glag', 'Glagolitic'],
		['Gong', 'Gunjala_Gondi'],
		['Gonm', 'Masaram_Gondi'],
		['Goth', 'Gothic'],
		['Gran', 'Grantha'],
		['Grek', 'Greek'],
		['Gujr', 'Gujarati'],
		['Guru', 'Gurmukhi'],
		['Hang', 'Hangul'],
		['Hani', 'Han'],
		['Hano', 'Hanunoo'],
		['Hatr', 'Hatran'],
		['Hebr', 'Hebrew'],
		['Hira', 'Hiragana'],
		['Hluw', 'Anatolian_Hieroglyphs'],
		['Hmng', 'Pahawh_Hmong'],
		['Hmnp', 'Nyiakeng_Puachue_Hmong'],
		['Hrkt', 'Katakana_Or_Hiragana'],
		['Hung', 'Old_Hungarian'],
		['Ital', 'Old_Italic'],
		['Java', 'Javanese'],
		['Kali', 'Kayah_Li'],
		['Kana', 'Katakana'],
		['Khar', 'Kharoshthi'],
		['Khmr', 'Khmer'],
		['Khoj', 'Khojki'],
		['Knda', 'Kannada'],
		['Kthi', 'Kaithi'],
		['Lana', 'Tai_Tham'],
		['Laoo', 'Lao'],
		['Latn', 'Latin'],
		['Lepc', 'Lepcha'],
		['Limb', 'Limbu'],
		['Lina', 'Linear_A'],
		['Linb', 'Linear_B'],
		['Lisu', 'Lisu'],
		['Lyci', 'Lycian'],
		['Lydi', 'Lydian'],
		['Mahj', 'Mahajani'],
		['Maka', 'Makasar'],
		['Mand', 'Mandaic'],
		['Mani', 'Manichaean'],
		['Marc', 'Marchen'],
		['Medf', 'Medefaidrin'],
		['Mend', 'Mende_Kikakui'],
		['Merc', 'Meroitic_Cursive'],
		['Mero', 'Meroitic_Hieroglyphs'],
		['Mlym', 'Malayalam'],
		['Modi', 'Modi'],
		['Mong', 'Mongolian'],
		['Mroo', 'Mro'],
		['Mtei', 'Meetei_Mayek'],
		['Mult', 'Multani'],
		['Mymr', 'Myanmar'],
		['Nand', 'Nandinagari'],
		['Narb', 'Old_North_Arabian'],
		['Nbat', 'Nabataean'],
		['Newa', 'Newa'],
		['Nkoo', 'Nko'],
		['Nshu', 'Nushu'],
		['Ogam', 'Ogham'],
		['Olck', 'Ol_Chiki'],
		['Orkh', 'Old_Turkic'],
		['Orya', 'Oriya'],
		['Osge', 'Osage'],
		['Osma', 'Osmanya'],
		['Palm', 'Palmyrene'],
		['Pauc', 'Pau_Cin_Hau'],
		['Perm', 'Old_Permic'],
		['Phag', 'Phags_Pa'],
		['Phli', 'Inscriptional_Pahlavi'],
		['Phlp', 'Psalter_Pahlavi'],
		['Phnx', 'Phoenician'],
		['Plrd', 'Miao'],
		['Prti', 'Inscriptional_Parthian'],
		['Rjng', 'Rejang'],
		['Rohg', 'Hanifi_Rohingya'],
		['Runr', 'Runic'],
		['Samr', 'Samaritan'],
		['Sarb', 'Old_South_Arabian'],
		['Saur', 'Saurashtra'],
		['Sgnw', 'SignWriting'],
		['Shaw', 'Shavian'],
		['Shrd', 'Sharada'],
		['Sidd', 'Siddham'],
		['Sind', 'Khudawadi'],
		['Sinh', 'Sinhala'],
		['Sogd', 'Sogdian'],
		['Sogo', 'Old_Sogdian'],
		['Sora', 'Sora_Sompeng'],
		['Soyo', 'Soyombo'],
		['Sund', 'Sundanese'],
		['Sylo', 'Syloti_Nagri'],
		['Syrc', 'Syriac'],
		['Tagb', 'Tagbanwa'],
		['Takr', 'Takri'],
		['Tale', 'Tai_Le'],
		['Talu', 'New_Tai_Lue'],
		['Taml', 'Tamil'],
		['Tang', 'Tangut'],
		['Tavt', 'Tai_Viet'],
		['Telu', 'Telugu'],
		['Tfng', 'Tifinagh'],
		['Tglg', 'Tagalog'],
		['Thaa', 'Thaana'],
		['Thai', 'Thai'],
		['Tibt', 'Tibetan'],
		['Tirh', 'Tirhuta'],
		['Ugar', 'Ugaritic'],
		['Vaii', 'Vai'],
		['Wara', 'Warang_Citi'],
		['Wcho', 'Wancho'],
		['Xpeo', 'Old_Persian'],
		['Xsux', 'Cuneiform'],
		['Yiii', 'Yi'],
		['Zanb', 'Zanabazar_Square'],
		['Zinh', 'Inherited'],
		['Qaai', 'Inherited'],
		['Zyyy', 'Common'],
		['Zzzz', 'Unknown'],
		['Adlam', 'Adlam'],
		['Caucasian_Albanian', 'Caucasian_Albanian'],
		['Arabic', 'Arabic'],
		['Imperial_Aramaic', 'Imperial_Aramaic'],
		['Armenian', 'Armenian'],
		['Avestan', 'Avestan'],
		['Balinese', 'Balinese'],
		['Bamum', 'Bamum'],
		['Bassa_Vah', 'Bassa_Vah'],
		['Batak', 'Batak'],
		['Bengali', 'Bengali'],
		['Bhaiksuki', 'Bhaiksuki'],
		['Bopomofo', 'Bopomofo'],
		['Brahmi', 'Brahmi'],
		['Braille', 'Braille'],
		['Buginese', 'Buginese'],
		['Buhid', 'Buhid'],
		['Chakma', 'Chakma'],
		['Canadian_Aboriginal', 'Canadian_Aboriginal'],
		['Carian', 'Carian'],
		['Cherokee', 'Cherokee'],
		['Coptic', 'Coptic'],
		['Cypriot', 'Cypriot'],
		['Cyrillic', 'Cyrillic'],
		['Devanagari', 'Devanagari'],
		['Dogra', 'Dogra'],
		['Deseret', 'Deseret'],
		['Duployan', 'Duployan'],
		['Egyptian_Hieroglyphs', 'Egyptian_Hieroglyphs'],
		['Elbasan', 'Elbasan'],
		['Elymaic', 'Elymaic'],
		['Ethiopic', 'Ethiopic'],
		['Georgian', 'Georgian'],
		['Glagolitic', 'Glagolitic'],
		['Gunjala_Gondi', 'Gunjala_Gondi'],
		['Masaram_Gondi', 'Masaram_Gondi'],
		['Gothic', 'Gothic'],
		['Grantha', 'Grantha'],
		['Greek', 'Greek'],
		['Gujarati', 'Gujarati'],
		['Gurmukhi', 'Gurmukhi'],
		['Hangul', 'Hangul'],
		['Han', 'Han'],
		['Hanunoo', 'Hanunoo'],
		['Hatran', 'Hatran'],
		['Hebrew', 'Hebrew'],
		['Hiragana', 'Hiragana'],
		['Anatolian_Hieroglyphs', 'Anatolian_Hieroglyphs'],
		['Pahawh_Hmong', 'Pahawh_Hmong'],
		['Nyiakeng_Puachue_Hmong', 'Nyiakeng_Puachue_Hmong'],
		['Katakana_Or_Hiragana', 'Katakana_Or_Hiragana'],
		['Old_Hungarian', 'Old_Hungarian'],
		['Old_Italic', 'Old_Italic'],
		['Javanese', 'Javanese'],
		['Kayah_Li', 'Kayah_Li'],
		['Katakana', 'Katakana'],
		['Kharoshthi', 'Kharoshthi'],
		['Khmer', 'Khmer'],
		['Khojki', 'Khojki'],
		['Kannada', 'Kannada'],
		['Kaithi', 'Kaithi'],
		['Tai_Tham', 'Tai_Tham'],
		['Lao', 'Lao'],
		['Latin', 'Latin'],
		['Lepcha', 'Lepcha'],
		['Limbu', 'Limbu'],
		['Linear_A', 'Linear_A'],
		['Linear_B', 'Linear_B'],
		['Lycian', 'Lycian'],
		['Lydian', 'Lydian'],
		['Mahajani', 'Mahajani'],
		['Makasar', 'Makasar'],
		['Mandaic', 'Mandaic'],
		['Manichaean', 'Manichaean'],
		['Marchen', 'Marchen'],
		['Medefaidrin', 'Medefaidrin'],
		['Mende_Kikakui', 'Mende_Kikakui'],
		['Meroitic_Cursive', 'Meroitic_Cursive'],
		['Meroitic_Hieroglyphs', 'Meroitic_Hieroglyphs'],
		['Malayalam', 'Malayalam'],
		['Mongolian', 'Mongolian'],
		['Mro', 'Mro'],
		['Meetei_Mayek', 'Meetei_Mayek'],
		['Multani', 'Multani'],
		['Myanmar', 'Myanmar'],
		['Nandinagari', 'Nandinagari'],
		['Old_North_Arabian', 'Old_North_Arabian'],
		['Nabataean', 'Nabataean'],
		['Nko', 'Nko'],
		['Nushu', 'Nushu'],
		['Ogham', 'Ogham'],
		['Ol_Chiki', 'Ol_Chiki'],
		['Old_Turkic', 'Old_Turkic'],
		['Oriya', 'Oriya'],
		['Osage', 'Osage'],
		['Osmanya', 'Osmanya'],
		['Palmyrene', 'Palmyrene'],
		['Pau_Cin_Hau', 'Pau_Cin_Hau'],
		['Old_Permic', 'Old_Permic'],
		['Phags_Pa', 'Phags_Pa'],
		['Inscriptional_Pahlavi', 'Inscriptional_Pahlavi'],
		['Psalter_Pahlavi', 'Psalter_Pahlavi'],
		['Phoenician', 'Phoenician'],
		['Miao', 'Miao'],
		['Inscriptional_Parthian', 'Inscriptional_Parthian'],
		['Rejang', 'Rejang'],
		['Hanifi_Rohingya', 'Hanifi_Rohingya'],
		['Runic', 'Runic'],
		['Samaritan', 'Samaritan'],
		['Old_South_Arabian', 'Old_South_Arabian'],
		['Saurashtra', 'Saurashtra'],
		['SignWriting', 'SignWriting'],
		['Shavian', 'Shavian'],
		['Sharada', 'Sharada'],
		['Siddham', 'Siddham'],
		['Khudawadi', 'Khudawadi'],
		['Sinhala', 'Sinhala'],
		['Sogdian', 'Sogdian'],
		['Old_Sogdian', 'Old_Sogdian'],
		['Sora_Sompeng', 'Sora_Sompeng'],
		['Soyombo', 'Soyombo'],
		['Sundanese', 'Sundanese'],
		['Syloti_Nagri', 'Syloti_Nagri'],
		['Syriac', 'Syriac'],
		['Tagbanwa', 'Tagbanwa'],
		['Takri', 'Takri'],
		['Tai_Le', 'Tai_Le'],
		['New_Tai_Lue', 'New_Tai_Lue'],
		['Tamil', 'Tamil'],
		['Tangut', 'Tangut'],
		['Tai_Viet', 'Tai_Viet'],
		['Telugu', 'Telugu'],
		['Tifinagh', 'Tifinagh'],
		['Tagalog', 'Tagalog'],
		['Thaana', 'Thaana'],
		['Tibetan', 'Tibetan'],
		['Tirhuta', 'Tirhuta'],
		['Ugaritic', 'Ugaritic'],
		['Vai', 'Vai'],
		['Warang_Citi', 'Warang_Citi'],
		['Wancho', 'Wancho'],
		['Old_Persian', 'Old_Persian'],
		['Cuneiform', 'Cuneiform'],
		['Yi', 'Yi'],
		['Zanabazar_Square', 'Zanabazar_Square'],
		['Inherited', 'Inherited'],
		['Common', 'Common'],
		['Unknown', 'Unknown']
	])],
	['Script_Extensions', new Map([
		['Adlm', 'Adlam'],
		['Aghb', 'Caucasian_Albanian'],
		['Ahom', 'Ahom'],
		['Arab', 'Arabic'],
		['Armi', 'Imperial_Aramaic'],
		['Armn', 'Armenian'],
		['Avst', 'Avestan'],
		['Bali', 'Balinese'],
		['Bamu', 'Bamum'],
		['Bass', 'Bassa_Vah'],
		['Batk', 'Batak'],
		['Beng', 'Bengali'],
		['Bhks', 'Bhaiksuki'],
		['Bopo', 'Bopomofo'],
		['Brah', 'Brahmi'],
		['Brai', 'Braille'],
		['Bugi', 'Buginese'],
		['Buhd', 'Buhid'],
		['Cakm', 'Chakma'],
		['Cans', 'Canadian_Aboriginal'],
		['Cari', 'Carian'],
		['Cham', 'Cham'],
		['Cher', 'Cherokee'],
		['Copt', 'Coptic'],
		['Qaac', 'Coptic'],
		['Cprt', 'Cypriot'],
		['Cyrl', 'Cyrillic'],
		['Deva', 'Devanagari'],
		['Dogr', 'Dogra'],
		['Dsrt', 'Deseret'],
		['Dupl', 'Duployan'],
		['Egyp', 'Egyptian_Hieroglyphs'],
		['Elba', 'Elbasan'],
		['Elym', 'Elymaic'],
		['Ethi', 'Ethiopic'],
		['Geor', 'Georgian'],
		['Glag', 'Glagolitic'],
		['Gong', 'Gunjala_Gondi'],
		['Gonm', 'Masaram_Gondi'],
		['Goth', 'Gothic'],
		['Gran', 'Grantha'],
		['Grek', 'Greek'],
		['Gujr', 'Gujarati'],
		['Guru', 'Gurmukhi'],
		['Hang', 'Hangul'],
		['Hani', 'Han'],
		['Hano', 'Hanunoo'],
		['Hatr', 'Hatran'],
		['Hebr', 'Hebrew'],
		['Hira', 'Hiragana'],
		['Hluw', 'Anatolian_Hieroglyphs'],
		['Hmng', 'Pahawh_Hmong'],
		['Hmnp', 'Nyiakeng_Puachue_Hmong'],
		['Hrkt', 'Katakana_Or_Hiragana'],
		['Hung', 'Old_Hungarian'],
		['Ital', 'Old_Italic'],
		['Java', 'Javanese'],
		['Kali', 'Kayah_Li'],
		['Kana', 'Katakana'],
		['Khar', 'Kharoshthi'],
		['Khmr', 'Khmer'],
		['Khoj', 'Khojki'],
		['Knda', 'Kannada'],
		['Kthi', 'Kaithi'],
		['Lana', 'Tai_Tham'],
		['Laoo', 'Lao'],
		['Latn', 'Latin'],
		['Lepc', 'Lepcha'],
		['Limb', 'Limbu'],
		['Lina', 'Linear_A'],
		['Linb', 'Linear_B'],
		['Lisu', 'Lisu'],
		['Lyci', 'Lycian'],
		['Lydi', 'Lydian'],
		['Mahj', 'Mahajani'],
		['Maka', 'Makasar'],
		['Mand', 'Mandaic'],
		['Mani', 'Manichaean'],
		['Marc', 'Marchen'],
		['Medf', 'Medefaidrin'],
		['Mend', 'Mende_Kikakui'],
		['Merc', 'Meroitic_Cursive'],
		['Mero', 'Meroitic_Hieroglyphs'],
		['Mlym', 'Malayalam'],
		['Modi', 'Modi'],
		['Mong', 'Mongolian'],
		['Mroo', 'Mro'],
		['Mtei', 'Meetei_Mayek'],
		['Mult', 'Multani'],
		['Mymr', 'Myanmar'],
		['Nand', 'Nandinagari'],
		['Narb', 'Old_North_Arabian'],
		['Nbat', 'Nabataean'],
		['Newa', 'Newa'],
		['Nkoo', 'Nko'],
		['Nshu', 'Nushu'],
		['Ogam', 'Ogham'],
		['Olck', 'Ol_Chiki'],
		['Orkh', 'Old_Turkic'],
		['Orya', 'Oriya'],
		['Osge', 'Osage'],
		['Osma', 'Osmanya'],
		['Palm', 'Palmyrene'],
		['Pauc', 'Pau_Cin_Hau'],
		['Perm', 'Old_Permic'],
		['Phag', 'Phags_Pa'],
		['Phli', 'Inscriptional_Pahlavi'],
		['Phlp', 'Psalter_Pahlavi'],
		['Phnx', 'Phoenician'],
		['Plrd', 'Miao'],
		['Prti', 'Inscriptional_Parthian'],
		['Rjng', 'Rejang'],
		['Rohg', 'Hanifi_Rohingya'],
		['Runr', 'Runic'],
		['Samr', 'Samaritan'],
		['Sarb', 'Old_South_Arabian'],
		['Saur', 'Saurashtra'],
		['Sgnw', 'SignWriting'],
		['Shaw', 'Shavian'],
		['Shrd', 'Sharada'],
		['Sidd', 'Siddham'],
		['Sind', 'Khudawadi'],
		['Sinh', 'Sinhala'],
		['Sogd', 'Sogdian'],
		['Sogo', 'Old_Sogdian'],
		['Sora', 'Sora_Sompeng'],
		['Soyo', 'Soyombo'],
		['Sund', 'Sundanese'],
		['Sylo', 'Syloti_Nagri'],
		['Syrc', 'Syriac'],
		['Tagb', 'Tagbanwa'],
		['Takr', 'Takri'],
		['Tale', 'Tai_Le'],
		['Talu', 'New_Tai_Lue'],
		['Taml', 'Tamil'],
		['Tang', 'Tangut'],
		['Tavt', 'Tai_Viet'],
		['Telu', 'Telugu'],
		['Tfng', 'Tifinagh'],
		['Tglg', 'Tagalog'],
		['Thaa', 'Thaana'],
		['Thai', 'Thai'],
		['Tibt', 'Tibetan'],
		['Tirh', 'Tirhuta'],
		['Ugar', 'Ugaritic'],
		['Vaii', 'Vai'],
		['Wara', 'Warang_Citi'],
		['Wcho', 'Wancho'],
		['Xpeo', 'Old_Persian'],
		['Xsux', 'Cuneiform'],
		['Yiii', 'Yi'],
		['Zanb', 'Zanabazar_Square'],
		['Zinh', 'Inherited'],
		['Qaai', 'Inherited'],
		['Zyyy', 'Common'],
		['Zzzz', 'Unknown'],
		['Adlam', 'Adlam'],
		['Caucasian_Albanian', 'Caucasian_Albanian'],
		['Arabic', 'Arabic'],
		['Imperial_Aramaic', 'Imperial_Aramaic'],
		['Armenian', 'Armenian'],
		['Avestan', 'Avestan'],
		['Balinese', 'Balinese'],
		['Bamum', 'Bamum'],
		['Bassa_Vah', 'Bassa_Vah'],
		['Batak', 'Batak'],
		['Bengali', 'Bengali'],
		['Bhaiksuki', 'Bhaiksuki'],
		['Bopomofo', 'Bopomofo'],
		['Brahmi', 'Brahmi'],
		['Braille', 'Braille'],
		['Buginese', 'Buginese'],
		['Buhid', 'Buhid'],
		['Chakma', 'Chakma'],
		['Canadian_Aboriginal', 'Canadian_Aboriginal'],
		['Carian', 'Carian'],
		['Cherokee', 'Cherokee'],
		['Coptic', 'Coptic'],
		['Cypriot', 'Cypriot'],
		['Cyrillic', 'Cyrillic'],
		['Devanagari', 'Devanagari'],
		['Dogra', 'Dogra'],
		['Deseret', 'Deseret'],
		['Duployan', 'Duployan'],
		['Egyptian_Hieroglyphs', 'Egyptian_Hieroglyphs'],
		['Elbasan', 'Elbasan'],
		['Elymaic', 'Elymaic'],
		['Ethiopic', 'Ethiopic'],
		['Georgian', 'Georgian'],
		['Glagolitic', 'Glagolitic'],
		['Gunjala_Gondi', 'Gunjala_Gondi'],
		['Masaram_Gondi', 'Masaram_Gondi'],
		['Gothic', 'Gothic'],
		['Grantha', 'Grantha'],
		['Greek', 'Greek'],
		['Gujarati', 'Gujarati'],
		['Gurmukhi', 'Gurmukhi'],
		['Hangul', 'Hangul'],
		['Han', 'Han'],
		['Hanunoo', 'Hanunoo'],
		['Hatran', 'Hatran'],
		['Hebrew', 'Hebrew'],
		['Hiragana', 'Hiragana'],
		['Anatolian_Hieroglyphs', 'Anatolian_Hieroglyphs'],
		['Pahawh_Hmong', 'Pahawh_Hmong'],
		['Nyiakeng_Puachue_Hmong', 'Nyiakeng_Puachue_Hmong'],
		['Katakana_Or_Hiragana', 'Katakana_Or_Hiragana'],
		['Old_Hungarian', 'Old_Hungarian'],
		['Old_Italic', 'Old_Italic'],
		['Javanese', 'Javanese'],
		['Kayah_Li', 'Kayah_Li'],
		['Katakana', 'Katakana'],
		['Kharoshthi', 'Kharoshthi'],
		['Khmer', 'Khmer'],
		['Khojki', 'Khojki'],
		['Kannada', 'Kannada'],
		['Kaithi', 'Kaithi'],
		['Tai_Tham', 'Tai_Tham'],
		['Lao', 'Lao'],
		['Latin', 'Latin'],
		['Lepcha', 'Lepcha'],
		['Limbu', 'Limbu'],
		['Linear_A', 'Linear_A'],
		['Linear_B', 'Linear_B'],
		['Lycian', 'Lycian'],
		['Lydian', 'Lydian'],
		['Mahajani', 'Mahajani'],
		['Makasar', 'Makasar'],
		['Mandaic', 'Mandaic'],
		['Manichaean', 'Manichaean'],
		['Marchen', 'Marchen'],
		['Medefaidrin', 'Medefaidrin'],
		['Mende_Kikakui', 'Mende_Kikakui'],
		['Meroitic_Cursive', 'Meroitic_Cursive'],
		['Meroitic_Hieroglyphs', 'Meroitic_Hieroglyphs'],
		['Malayalam', 'Malayalam'],
		['Mongolian', 'Mongolian'],
		['Mro', 'Mro'],
		['Meetei_Mayek', 'Meetei_Mayek'],
		['Multani', 'Multani'],
		['Myanmar', 'Myanmar'],
		['Nandinagari', 'Nandinagari'],
		['Old_North_Arabian', 'Old_North_Arabian'],
		['Nabataean', 'Nabataean'],
		['Nko', 'Nko'],
		['Nushu', 'Nushu'],
		['Ogham', 'Ogham'],
		['Ol_Chiki', 'Ol_Chiki'],
		['Old_Turkic', 'Old_Turkic'],
		['Oriya', 'Oriya'],
		['Osage', 'Osage'],
		['Osmanya', 'Osmanya'],
		['Palmyrene', 'Palmyrene'],
		['Pau_Cin_Hau', 'Pau_Cin_Hau'],
		['Old_Permic', 'Old_Permic'],
		['Phags_Pa', 'Phags_Pa'],
		['Inscriptional_Pahlavi', 'Inscriptional_Pahlavi'],
		['Psalter_Pahlavi', 'Psalter_Pahlavi'],
		['Phoenician', 'Phoenician'],
		['Miao', 'Miao'],
		['Inscriptional_Parthian', 'Inscriptional_Parthian'],
		['Rejang', 'Rejang'],
		['Hanifi_Rohingya', 'Hanifi_Rohingya'],
		['Runic', 'Runic'],
		['Samaritan', 'Samaritan'],
		['Old_South_Arabian', 'Old_South_Arabian'],
		['Saurashtra', 'Saurashtra'],
		['SignWriting', 'SignWriting'],
		['Shavian', 'Shavian'],
		['Sharada', 'Sharada'],
		['Siddham', 'Siddham'],
		['Khudawadi', 'Khudawadi'],
		['Sinhala', 'Sinhala'],
		['Sogdian', 'Sogdian'],
		['Old_Sogdian', 'Old_Sogdian'],
		['Sora_Sompeng', 'Sora_Sompeng'],
		['Soyombo', 'Soyombo'],
		['Sundanese', 'Sundanese'],
		['Syloti_Nagri', 'Syloti_Nagri'],
		['Syriac', 'Syriac'],
		['Tagbanwa', 'Tagbanwa'],
		['Takri', 'Takri'],
		['Tai_Le', 'Tai_Le'],
		['New_Tai_Lue', 'New_Tai_Lue'],
		['Tamil', 'Tamil'],
		['Tangut', 'Tangut'],
		['Tai_Viet', 'Tai_Viet'],
		['Telugu', 'Telugu'],
		['Tifinagh', 'Tifinagh'],
		['Tagalog', 'Tagalog'],
		['Thaana', 'Thaana'],
		['Tibetan', 'Tibetan'],
		['Tirhuta', 'Tirhuta'],
		['Ugaritic', 'Ugaritic'],
		['Vai', 'Vai'],
		['Warang_Citi', 'Warang_Citi'],
		['Wancho', 'Wancho'],
		['Old_Persian', 'Old_Persian'],
		['Cuneiform', 'Cuneiform'],
		['Yi', 'Yi'],
		['Zanabazar_Square', 'Zanabazar_Square'],
		['Inherited', 'Inherited'],
		['Common', 'Common'],
		['Unknown', 'Unknown']
	])]
]);


/***/ }),
/* 120 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var Stack = __webpack_require__(598),
    equalArrays = __webpack_require__(90),
    equalByTag = __webpack_require__(74),
    equalObjects = __webpack_require__(586),
    getTag = __webpack_require__(700),
    isArray = __webpack_require__(143),
    isBuffer = __webpack_require__(546),
    isTypedArray = __webpack_require__(850);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    objectTag = '[object Object]';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray(object),
      othIsArr = isArray(other),
      objTag = objIsArr ? arrayTag : getTag(object),
      othTag = othIsArr ? arrayTag : getTag(other);

  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;

  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && isBuffer(object)) {
    if (!isBuffer(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack);
    return (objIsArr || isTypedArray(object))
      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new Stack);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack);
  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}

module.exports = baseIsEqualDeep;


/***/ }),
/* 121 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var mapCacheClear = __webpack_require__(812),
    mapCacheDelete = __webpack_require__(78),
    mapCacheGet = __webpack_require__(604),
    mapCacheHas = __webpack_require__(809),
    mapCacheSet = __webpack_require__(73);

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

module.exports = MapCache;


/***/ }),
/* 122 */,
/* 123 */,
/* 124 */,
/* 125 */,
/* 126 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var MapCache = __webpack_require__(121);

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `clear`, `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result) || cache;
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache);
  return memoized;
}

// Expose `MapCache`.
memoize.Cache = MapCache;

module.exports = memoize;


/***/ }),
/* 127 */
/***/ (function(module) {

module.exports = {"_args":[["@babel/plugin-proposal-dynamic-import@7.7.0","/mnt/c/Users/thheller/code/shadow-cljs/packages/babel-worker"]],"_from":"@babel/plugin-proposal-dynamic-import@7.7.0","_id":"@babel/plugin-proposal-dynamic-import@7.7.0","_inBundle":false,"_integrity":"sha512-7poL3Xi+QFPC7sGAzEIbXUyYzGJwbc2+gSD0AkiC5k52kH2cqHdqxm5hNFfLW3cRSTcx9bN0Fl7/6zWcLLnKAQ==","_location":"/@babel/plugin-proposal-dynamic-import","_phantomChildren":{},"_requested":{"type":"version","registry":true,"raw":"@babel/plugin-proposal-dynamic-import@7.7.0","name":"@babel/plugin-proposal-dynamic-import","escapedName":"@babel%2fplugin-proposal-dynamic-import","scope":"@babel","rawSpec":"7.7.0","saveSpec":null,"fetchSpec":"7.7.0"},"_requiredBy":["/@babel/preset-env"],"_resolved":"https://registry.npmjs.org/@babel/plugin-proposal-dynamic-import/-/plugin-proposal-dynamic-import-7.7.0.tgz","_spec":"7.7.0","_where":"/mnt/c/Users/thheller/code/shadow-cljs/packages/babel-worker","dependencies":{"@babel/helper-plugin-utils":"^7.0.0","@babel/plugin-syntax-dynamic-import":"^7.2.0"},"description":"Transform import() expressions","devDependencies":{"@babel/core":"^7.7.0","@babel/helper-plugin-test-runner":"^7.0.0"},"gitHead":"97faa83953cb87e332554fa559a4956d202343ea","keywords":["babel-plugin"],"license":"MIT","main":"lib/index.js","name":"@babel/plugin-proposal-dynamic-import","peerDependencies":{"@babel/core":"^7.0.0-0"},"publishConfig":{"access":"public"},"repository":{"type":"git","url":"https://github.com/babel/babel/tree/master/packages/babel-plugin-proposal-dynamic-import"},"version":"7.7.0"};

/***/ }),
/* 128 */,
/* 129 */,
/* 130 */
/***/ (function(__unusedmodule, __unusedexports, __webpack_require__) {

(function(){
var shadow$provide = {};
var g,aa=this||self;
function ba(a){var b=typeof a;if("object"==b)if(a){if(a instanceof Array)return"array";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if("[object Window]"==c)return"object";if("[object Array]"==c||"number"==typeof a.length&&"undefined"!=typeof a.splice&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("splice"))return"array";if("[object Function]"==c||"undefined"!=typeof a.call&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("call"))return"function"}else return"null";else if("function"==
b&&"undefined"==typeof a.call)return"object";return b}var ea="closure_uid_"+(1E9*Math.random()>>>0),fa=0;function ha(a,b,c){return a.call.apply(a.bind,arguments)}function ia(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var e=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(e,d);return a.apply(b,e)}}return function(){return a.apply(b,arguments)}}
function ja(a,b,c){ja=Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?ha:ia;return ja.apply(null,arguments)};function ma(a){var b=a.length;if(0<b){for(var c=Array(b),d=0;d<b;d++)c[d]=a[d];return c}return[]};function na(a){var b=[],c=0,d;for(d in a)b[c++]=d;return b};function oa(a,b){this.Rc=a===pa&&b||"";this.oc=qa}var qa={},pa={},ra=new oa(pa,"");function sa(){}sa.prototype.Na=function(){return this};(new sa).Na("");function ta(a,b){this.Pc=a===va&&b||"";this.pc=xa}var xa={},va={};function ya(a){return-1!=za.toLowerCase().indexOf(a.toLowerCase())};function Aa(){}Aa.prototype.Na=function(){return this};(new Aa).Na("");function Ba(){}Ba.prototype.Na=function(){return this};(new Ba).Na("");var za;a:{var Da=aa.navigator;if(Da){var Ea=Da.userAgent;if(Ea){za=Ea;break a}}za=""}function Fa(a){return-1!=za.indexOf(a)};function Ha(){this.ic="";this.nc=Ia}function Ja(){var a=Ka;if(a instanceof Ha&&a.constructor===Ha&&a.nc===Ia)return a.ic;ba(a);return"type_error:SafeHtml"}var Ia={};Ha.prototype.Na=function(a){this.ic=a;return this};(new Ha).Na("\x3c!DOCTYPE html\x3e");var Ka=(new Ha).Na("");(new Ha).Na("\x3cbr\x3e");function La(a){var b=new ta(va,ra instanceof oa&&ra.constructor===oa&&ra.oc===qa?ra.Rc:"type_error:Const");b instanceof ta&&b.constructor===ta&&b.pc===xa?b=b.Pc:(ba(b),b="type_error:TrustedResourceUrl");a.src=b.toString()};function Ma(a,b){null!=a&&this.append.apply(this,arguments)}g=Ma.prototype;g.Ra="";g.set=function(a){this.Ra=""+a};g.append=function(a,b,c){this.Ra+=String(a);if(null!=b)for(var d=1;d<arguments.length;d++)this.Ra+=arguments[d];return this};g.clear=function(){this.Ra=""};g.getLength=function(){return this.Ra.length};g.toString=function(){return this.Ra};var Na={},Oa={},Pa,v={},Qa=null,Ra=!0,Sa=null;function Ta(){return new Ua(null,5,[Va,!0,Wa,!0,Xa,!1,Ya,!1,Za,null],null)}function $a(){Ra=!1;Qa=function(){return console.log.apply(console,ma(arguments))}}function H(a){return null!=a&&!1!==a}function bb(a){return null==a?!0:!1===a?!0:!1}function cb(a,b){return a[ba(null==b?null:b)]?!0:a._?!0:!1}
function db(a,b){var c=null==b?null:b.constructor;c=H(H(c)?c.sb:c)?c.Xa:ba(b);return Error(["No protocol method ",a," defined for type ",c,": ",b].join(""))}function eb(a){var b=a.Xa;return H(b)?b:J.a(a)}var fb="undefined"!==typeof Symbol&&"function"===ba(Symbol)?Symbol.iterator:"@@iterator";function gb(a){for(var b=a.length,c=Array(b),d=0;;)if(d<b)c[d]=a[d],d+=1;else break;return c}function hb(){}
var ib=function ib(a){if(null!=a&&null!=a.Y)return a.Y(a);var c=ib[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=ib._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("ICounted.-count",a);};function jb(){}var kb=function kb(a){if(null!=a&&null!=a.V)return a.V(a);var c=kb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=kb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IEmptyableCollection.-empty",a);};function lb(){}
var mb=function mb(a,b){if(null!=a&&null!=a.X)return a.X(a,b);var d=mb[ba(null==a?null:a)];if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);d=mb._;if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);throw db("ICollection.-conj",a);};function nb(){}var ob=function ob(a){switch(arguments.length){case 2:return ob.b(arguments[0],arguments[1]);case 3:return ob.f(arguments[0],arguments[1],arguments[2]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}};
ob.b=function(a,b){if(null!=a&&null!=a.K)return a.K(a,b);var c=ob[ba(null==a?null:a)];if(null!=c)return c.b?c.b(a,b):c.call(null,a,b);c=ob._;if(null!=c)return c.b?c.b(a,b):c.call(null,a,b);throw db("IIndexed.-nth",a);};ob.f=function(a,b,c){if(null!=a&&null!=a.wa)return a.wa(a,b,c);var d=ob[ba(null==a?null:a)];if(null!=d)return d.f?d.f(a,b,c):d.call(null,a,b,c);d=ob._;if(null!=d)return d.f?d.f(a,b,c):d.call(null,a,b,c);throw db("IIndexed.-nth",a);};ob.H=3;
var pb=function pb(a){if(null!=a&&null!=a.ra)return a.ra(a);var c=pb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=pb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("ISeq.-first",a);},qb=function qb(a){if(null!=a&&null!=a.ua)return a.ua(a);var c=qb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=qb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("ISeq.-rest",a);};function rb(){}
var sb=function sb(a){if(null!=a&&null!=a.aa)return a.aa(a);var c=sb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=sb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("INext.-next",a);};function tb(){}var ub=function ub(a){switch(arguments.length){case 2:return ub.b(arguments[0],arguments[1]);case 3:return ub.f(arguments[0],arguments[1],arguments[2]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}};
ub.b=function(a,b){if(null!=a&&null!=a.T)return a.T(a,b);var c=ub[ba(null==a?null:a)];if(null!=c)return c.b?c.b(a,b):c.call(null,a,b);c=ub._;if(null!=c)return c.b?c.b(a,b):c.call(null,a,b);throw db("ILookup.-lookup",a);};ub.f=function(a,b,c){if(null!=a&&null!=a.C)return a.C(a,b,c);var d=ub[ba(null==a?null:a)];if(null!=d)return d.f?d.f(a,b,c):d.call(null,a,b,c);d=ub._;if(null!=d)return d.f?d.f(a,b,c):d.call(null,a,b,c);throw db("ILookup.-lookup",a);};ub.H=3;
var vb=function vb(a,b,c){if(null!=a&&null!=a.Sa)return a.Sa(a,b,c);var e=vb[ba(null==a?null:a)];if(null!=e)return e.f?e.f(a,b,c):e.call(null,a,b,c);e=vb._;if(null!=e)return e.f?e.f(a,b,c):e.call(null,a,b,c);throw db("IAssociative.-assoc",a);},wb=function wb(a,b){if(null!=a&&null!=a.lb)return a.lb(a,b);var d=wb[ba(null==a?null:a)];if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);d=wb._;if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);throw db("IFind.-find",a);};function xb(){}
var yb=function yb(a){if(null!=a&&null!=a.vc)return a.key;var c=yb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=yb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IMapEntry.-key",a);},zb=function zb(a){if(null!=a&&null!=a.wc)return a.v;var c=zb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=zb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IMapEntry.-val",a);};function Ab(){}function Bb(){}
var Cb=function Cb(a){if(null!=a&&null!=a.Eb)return a.Eb(a);var c=Cb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Cb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IDeref.-deref",a);};function Db(){}
var Eb=function Eb(a){if(null!=a&&null!=a.N)return a.N(a);var c=Eb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Eb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IMeta.-meta",a);},Fb=function Fb(a,b){if(null!=a&&null!=a.S)return a.S(a,b);var d=Fb[ba(null==a?null:a)];if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);d=Fb._;if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);throw db("IWithMeta.-with-meta",a);};function Gb(){}
var Hb=function Hb(a){switch(arguments.length){case 2:return Hb.b(arguments[0],arguments[1]);case 3:return Hb.f(arguments[0],arguments[1],arguments[2]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}};Hb.b=function(a,b){if(null!=a&&null!=a.sa)return a.sa(a,b);var c=Hb[ba(null==a?null:a)];if(null!=c)return c.b?c.b(a,b):c.call(null,a,b);c=Hb._;if(null!=c)return c.b?c.b(a,b):c.call(null,a,b);throw db("IReduce.-reduce",a);};
Hb.f=function(a,b,c){if(null!=a&&null!=a.ta)return a.ta(a,b,c);var d=Hb[ba(null==a?null:a)];if(null!=d)return d.f?d.f(a,b,c):d.call(null,a,b,c);d=Hb._;if(null!=d)return d.f?d.f(a,b,c):d.call(null,a,b,c);throw db("IReduce.-reduce",a);};Hb.H=3;function Ib(){}
var Jb=function Jb(a,b,c){if(null!=a&&null!=a.Fb)return a.Fb(a,b,c);var e=Jb[ba(null==a?null:a)];if(null!=e)return e.f?e.f(a,b,c):e.call(null,a,b,c);e=Jb._;if(null!=e)return e.f?e.f(a,b,c):e.call(null,a,b,c);throw db("IKVReduce.-kv-reduce",a);},Kb=function Kb(a,b){if(null!=a&&null!=a.O)return a.O(a,b);var d=Kb[ba(null==a?null:a)];if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);d=Kb._;if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);throw db("IEquiv.-equiv",a);},Lb=function Lb(a){if(null!=a&&null!=
a.P)return a.P(a);var c=Lb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Lb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IHash.-hash",a);};function Mb(){}var Nb=function Nb(a){if(null!=a&&null!=a.U)return a.U(a);var c=Nb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Nb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("ISeqable.-seq",a);};function Ob(){}function Pb(){}function Qb(){}
var Rb=function Rb(a,b){if(null!=a&&null!=a.dc)return a.dc(a,b);var d=Rb[ba(null==a?null:a)];if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);d=Rb._;if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);throw db("IWriter.-write",a);};function Sb(){}
var Tb=function Tb(a,b,c){if(null!=a&&null!=a.R)return a.R(a,b,c);var e=Tb[ba(null==a?null:a)];if(null!=e)return e.f?e.f(a,b,c):e.call(null,a,b,c);e=Tb._;if(null!=e)return e.f?e.f(a,b,c):e.call(null,a,b,c);throw db("IPrintWithWriter.-pr-writer",a);},Ub=function Ub(a){if(null!=a&&null!=a.cb)return a.cb(a);var c=Ub[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Ub._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IEditableCollection.-as-transient",a);},Vb=function Vb(a,b){if(null!=
a&&null!=a.fb)return a.fb(a,b);var d=Vb[ba(null==a?null:a)];if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);d=Vb._;if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);throw db("ITransientCollection.-conj!",a);},Wb=function Wb(a){if(null!=a&&null!=a.qb)return a.qb(a);var c=Wb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Wb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("ITransientCollection.-persistent!",a);},Xb=function Xb(a,b,c){if(null!=a&&null!=a.eb)return a.eb(a,b,c);
var e=Xb[ba(null==a?null:a)];if(null!=e)return e.f?e.f(a,b,c):e.call(null,a,b,c);e=Xb._;if(null!=e)return e.f?e.f(a,b,c):e.call(null,a,b,c);throw db("ITransientAssociative.-assoc!",a);},Yb=function Yb(a){if(null!=a&&null!=a.Zb)return a.Zb(a);var c=Yb[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Yb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IChunk.-drop-first",a);},Zb=function Zb(a){if(null!=a&&null!=a.Ob)return a.Ob(a);var c=Zb[ba(null==a?null:a)];if(null!=c)return c.a?
c.a(a):c.call(null,a);c=Zb._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IChunkedSeq.-chunked-first",a);},$b=function $b(a){if(null!=a&&null!=a.Db)return a.Db(a);var c=$b[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=$b._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IChunkedSeq.-chunked-rest",a);},ac=function ac(a){if(null!=a&&null!=a.nb)return a.nb(a);var c=ac[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=ac._;if(null!=c)return c.a?c.a(a):
c.call(null,a);throw db("INamed.-name",a);},bc=function bc(a){if(null!=a&&null!=a.ob)return a.ob(a);var c=bc[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=bc._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("INamed.-namespace",a);},cc=function cc(a,b){if(null!=a&&null!=a.zc)return a.zc(a,b);var d=cc[ba(null==a?null:a)];if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);d=cc._;if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);throw db("IReset.-reset!",a);},dc=function dc(a){switch(arguments.length){case 2:return dc.b(arguments[0],
arguments[1]);case 3:return dc.f(arguments[0],arguments[1],arguments[2]);case 4:return dc.A(arguments[0],arguments[1],arguments[2],arguments[3]);case 5:return dc.M(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}};
dc.b=function(a,b){if(null!=a&&null!=a.Bc)return a.Bc(a,b);var c=dc[ba(null==a?null:a)];if(null!=c)return c.b?c.b(a,b):c.call(null,a,b);c=dc._;if(null!=c)return c.b?c.b(a,b):c.call(null,a,b);throw db("ISwap.-swap!",a);};dc.f=function(a,b,c){if(null!=a&&null!=a.Cc)return a.Cc(a,b,c);var d=dc[ba(null==a?null:a)];if(null!=d)return d.f?d.f(a,b,c):d.call(null,a,b,c);d=dc._;if(null!=d)return d.f?d.f(a,b,c):d.call(null,a,b,c);throw db("ISwap.-swap!",a);};
dc.A=function(a,b,c,d){if(null!=a&&null!=a.Dc)return a.Dc(a,b,c,d);var e=dc[ba(null==a?null:a)];if(null!=e)return e.A?e.A(a,b,c,d):e.call(null,a,b,c,d);e=dc._;if(null!=e)return e.A?e.A(a,b,c,d):e.call(null,a,b,c,d);throw db("ISwap.-swap!",a);};dc.M=function(a,b,c,d,e){if(null!=a&&null!=a.Ec)return a.Ec(a,b,c,d,e);var f=dc[ba(null==a?null:a)];if(null!=f)return f.M?f.M(a,b,c,d,e):f.call(null,a,b,c,d,e);f=dc._;if(null!=f)return f.M?f.M(a,b,c,d,e):f.call(null,a,b,c,d,e);throw db("ISwap.-swap!",a);};
dc.H=5;function ec(){}var fc=function fc(a){if(null!=a&&null!=a.Da)return a.Da(a);var c=fc[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=fc._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IIterable.-iterator",a);};function gc(a){this.Qc=a;this.i=1073741824;this.w=0}gc.prototype.dc=function(a,b){return this.Qc.append(b)};function hc(a){var b=new Ma;a.R(null,new gc(b),Ta());return J.a(b)}
var ic="undefined"!==typeof Math&&"undefined"!==typeof Math.imul&&0!==Math.imul(4294967295,5)?function(a,b){return Math.imul(a,b)}:function(a,b){var c=a&65535,d=b&65535;return c*d+((a>>>16&65535)*d+c*(b>>>16&65535)<<16>>>0)|0};function jc(a){a=ic(a|0,-862048943);return ic(a<<15|a>>>-15,461845907)}function kc(a,b){a=(a|0)^(b|0);return ic(a<<13|a>>>-13,5)+-430675100|0}function lc(a,b){a=(a|0)^b;a=ic(a^a>>>16,-2048144789);a=ic(a^a>>>13,-1028477387);return a^a>>>16}
function mc(a){a:{var b=1;for(var c=0;;)if(b<a.length)c=kc(c,jc(a.charCodeAt(b-1)|a.charCodeAt(b)<<16)),b+=2;else{b=c;break a}}return lc(1===(a.length&1)?b^jc(a.charCodeAt(a.length-1)):b,ic(2,a.length))}var nc={},oc=0;function pc(a){255<oc&&(nc={},oc=0);if(null==a)return 0;var b=nc[a];if("number"===typeof b)a=b;else{a:if(null!=a)if(b=a.length,0<b)for(var c=0,d=0;;)if(c<b)d=ic(31,d)+a.charCodeAt(c),c+=1;else{b=d;break a}else b=0;else b=0;nc[a]=b;oc+=1;a=b}return a}
function qc(a){if(null!=a&&(a.i&4194304||v===a.Yc))return a.P(null)^0;if("number"===typeof a){if(H(isFinite(a)))return Math.floor(a)%2147483647;switch(a){case Infinity:return 2146435072;case -Infinity:return-1048576;default:return 2146959360}}else return!0===a?a=1231:!1===a?a=1237:"string"===typeof a?(a=pc(a),a=0===a?a:lc(kc(0,jc(a)),4)):a=a instanceof Date?a.valueOf()^0:null==a?0:Lb(a)^0,a}function rc(a,b){return a^b+2654435769+(a<<6)+(a>>2)}
function sc(a,b,c,d,e){this.ib=a;this.name=b;this.Va=c;this.bb=d;this.La=e;this.i=2154168321;this.w=4096}g=sc.prototype;g.toString=function(){return this.Va};g.O=function(a,b){return b instanceof sc?this.Va===b.Va:!1};
g.call=function(){function a(d,e,f){return tc.f?tc.f(e,this,f):tc.call(null,e,this,f)}function b(d,e){return tc.b?tc.b(e,this):tc.call(null,e,this)}var c=null;c=function(d,e,f){switch(arguments.length){case 2:return b.call(this,d,e);case 3:return a.call(this,d,e,f)}throw Error("Invalid arity: "+(arguments.length-1));};c.b=b;c.f=a;return c}();g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return tc.b?tc.b(a,this):tc.call(null,a,this)};
g.b=function(a,b){return tc.f?tc.f(a,this,b):tc.call(null,a,this,b)};g.N=function(){return this.La};g.S=function(a,b){return new sc(this.ib,this.name,this.Va,this.bb,b)};g.P=function(){var a=this.bb;return null!=a?a:this.bb=a=rc(mc(this.name),pc(this.ib))};g.nb=function(){return this.name};g.ob=function(){return this.ib};g.R=function(a,b){return Rb(b,this.Va)};
var uc=function uc(a){switch(arguments.length){case 1:return uc.a(arguments[0]);case 2:return uc.b(arguments[0],arguments[1]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}};uc.a=function(a){for(;;){if(a instanceof sc)return a;if("string"===typeof a){var b=a.indexOf("/");return 1>b?uc.b(null,a):uc.b(a.substring(0,b),a.substring(b+1,a.length))}if(a instanceof M)a=a.Ma;else throw Error("no conversion to symbol");}};
uc.b=function(a,b){var c=null!=a?[J.a(a),"/",J.a(b)].join(""):b;return new sc(a,b,c,null,null)};uc.H=2;function vc(a){return null!=a?a.w&131072||v===a.Zc?!0:a.w?!1:cb(ec,a):cb(ec,a)}function O(a){if(null==a)return null;if(null!=a&&(a.i&8388608||v===a.Ac))return a.U(null);if(Array.isArray(a)||"string"===typeof a)return 0===a.length?null:new wc(a,0,null);if(cb(Mb,a))return Nb(a);throw Error([J.a(a)," is not ISeqable"].join(""));}
function R(a){if(null==a)return null;if(null!=a&&(a.i&64||v===a.Wa))return a.ra(null);a=O(a);return null==a?null:pb(a)}function xc(a){return null!=a?null!=a&&(a.i&64||v===a.Wa)?a.ua(null):(a=O(a))?a.ua(null):yc:yc}function U(a){return null==a?null:null!=a&&(a.i&128||v===a.pb)?a.aa(null):O(xc(a))}
var zc=function zc(a){switch(arguments.length){case 1:return zc.a(arguments[0]);case 2:return zc.b(arguments[0],arguments[1]);default:for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return zc.o(arguments[0],arguments[1],new wc(c.slice(2),0,null))}};zc.a=function(){return!0};zc.b=function(a,b){return null==a?null==b:a===b||Kb(a,b)};zc.o=function(a,b,c){for(;;)if(zc.b(a,b))if(U(c))a=b,b=R(c),c=U(c);else return zc.b(b,R(c));else return!1};
zc.G=function(a){var b=R(a),c=U(a);a=R(c);c=U(c);return this.o(b,a,c)};zc.H=2;function Ac(a){this.B=a}Ac.prototype.next=function(){if(null!=this.B){var a=R(this.B);this.B=U(this.B);return{value:a,done:!1}}return{value:null,done:!0}};function Bc(a){return new Ac(O(a))}function Cc(a){var b=0,c=1;for(a=O(a);;)if(null!=a)b+=1,c=ic(31,c)+qc(R(a))|0,a=U(a);else return lc(kc(0,jc(c)),b)}var Ec=lc(kc(0,jc(1)),0);
function Fc(a){var b=0,c=0;for(a=O(a);;)if(null!=a)b+=1,c=c+qc(R(a))|0,a=U(a);else return lc(kc(0,jc(c)),b)}var Gc=lc(kc(0,jc(0)),0);hb["null"]=!0;ib["null"]=function(){return 0};Date.prototype.O=function(a,b){return b instanceof Date&&this.valueOf()===b.valueOf()};Kb.number=function(a,b){return a===b};Db["function"]=!0;Eb["function"]=function(){return null};Lb._=function(a){return a[ea]||(a[ea]=++fa)};function Hc(){this.v=!1;this.i=32768;this.w=0}Hc.prototype.Eb=function(){return this.v};
function Ic(a){return a instanceof Hc}function Jc(a){return Cb(a)}function Kc(a,b){var c=a.length;if(0===a.length)return b.u?b.u():b.call(null);for(var d=a[0],e=1;;)if(e<c){var f=a[e];d=b.b?b.b(d,f):b.call(null,d,f);if(Ic(d))return Cb(d);e+=1}else return d}function Lc(a,b,c){var d=a.length,e=c;for(c=0;;)if(c<d){var f=a[c];e=b.b?b.b(e,f):b.call(null,e,f);if(Ic(e))return Cb(e);c+=1}else return e}
function Mc(a,b,c,d){for(var e=a.length;;)if(d<e){var f=a[d];c=b.b?b.b(c,f):b.call(null,c,f);if(Ic(c))return Cb(c);d+=1}else return c}function Nc(a){return null!=a?a.i&2||v===a.qc?!0:a.i?!1:cb(hb,a):cb(hb,a)}function Oc(a){return null!=a?a.i&16||v===a.ac?!0:a.i?!1:cb(nb,a):cb(nb,a)}function V(a,b,c){var d=W.a?W.a(a):W.call(null,a);if(c>=d)return-1;!(0<c)&&0>c&&(c+=d,c=0>c?0:c);for(;;)if(c<d){if(zc.b(Pc?Pc(a,c):Qc.call(null,a,c),b))return c;c+=1}else return-1}
function Rc(a,b,c){var d=W.a?W.a(a):W.call(null,a);if(0===d)return-1;0<c?(--d,c=d<c?d:c):c=0>c?d+c:c;for(;;)if(0<=c){if(zc.b(Pc?Pc(a,c):Qc.call(null,a,c),b))return c;--c}else return-1}function Sc(a,b){this.c=a;this.m=b}Sc.prototype.ba=function(){return this.m<this.c.length};Sc.prototype.next=function(){var a=this.c[this.m];this.m+=1;return a};function wc(a,b,c){this.c=a;this.m=b;this.l=c;this.i=166592766;this.w=139264}g=wc.prototype;g.toString=function(){return hc(this)};
g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W.a?W.a(this):W.call(null,this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.K=function(a,b){a=b+this.m;if(0<=a&&a<this.c.length)return this.c[a];throw Error("Index out of bounds");};g.wa=function(a,b,c){a=b+this.m;return 0<=a&&a<this.c.length?this.c[a]:c};
g.Da=function(){return new Sc(this.c,this.m)};g.N=function(){return this.l};g.aa=function(){return this.m+1<this.c.length?new wc(this.c,this.m+1,null):null};g.Y=function(){var a=this.c.length-this.m;return 0>a?0:a};g.P=function(){return Cc(this)};g.O=function(a,b){return Tc.b?Tc.b(this,b):Tc.call(null,this,b)};g.V=function(){return yc};g.sa=function(a,b){return Mc(this.c,b,this.c[this.m],this.m+1)};g.ta=function(a,b,c){return Mc(this.c,b,c,this.m)};g.ra=function(){return this.c[this.m]};
g.ua=function(){return this.m+1<this.c.length?new wc(this.c,this.m+1,null):yc};g.U=function(){return this.m<this.c.length?this:null};g.S=function(a,b){return b===this.l?this:new wc(this.c,this.m,b)};g.X=function(a,b){return Uc.b?Uc.b(b,this):Uc.call(null,b,this)};wc.prototype[fb]=function(){return Bc(this)};function Vc(a){return 0<a.length?new wc(a,0,null):null}Kb._=function(a,b){return a===b};
var Wc=function Wc(a){switch(arguments.length){case 0:return Wc.u();case 1:return Wc.a(arguments[0]);case 2:return Wc.b(arguments[0],arguments[1]);default:for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return Wc.o(arguments[0],arguments[1],new wc(c.slice(2),0,null))}};Wc.u=function(){return Xc};Wc.a=function(a){return a};Wc.b=function(a,b){return null!=a?mb(a,b):new Yc(null,b,null,1,null)};
Wc.o=function(a,b,c){for(;;)if(H(c))a=Wc.b(a,b),b=R(c),c=U(c);else return Wc.b(a,b)};Wc.G=function(a){var b=R(a),c=U(a);a=R(c);c=U(c);return this.o(b,a,c)};Wc.H=2;function W(a){if(null!=a)if(null!=a&&(a.i&2||v===a.qc))a=a.Y(null);else if(Array.isArray(a))a=a.length;else if("string"===typeof a)a=a.length;else if(null!=a&&(a.i&8388608||v===a.Ac))a:{a=O(a);for(var b=0;;){if(Nc(a)){a=b+ib(a);break a}a=U(a);b+=1}}else a=ib(a);else a=0;return a}
function Zc(a,b,c){for(;;){if(null==a)return c;if(0===b)return O(a)?R(a):c;if(Oc(a))return ob.f(a,b,c);if(O(a))a=U(a),--b;else return c}}function Qc(a){switch(arguments.length){case 2:return Pc(arguments[0],arguments[1]);case 3:return X(arguments[0],arguments[1],arguments[2]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}}
function Pc(a,b){if("number"!==typeof b)throw Error("Index argument to nth must be a number");if(null==a)return a;if(null!=a&&(a.i&16||v===a.ac))return a.K(null,b);if(Array.isArray(a)){if(-1<b&&b<a.length)return a[b|0];throw Error("Index out of bounds");}if("string"===typeof a){if(-1<b&&b<a.length)return a.charAt(b|0);throw Error("Index out of bounds");}if(null!=a&&(a.i&64||v===a.Wa)||null!=a&&(a.i&16777216||v===a.cc)){if(0>b)throw Error("Index out of bounds");a:for(;;){if(null==a)throw Error("Index out of bounds");
if(0===b){if(O(a)){a=R(a);break a}throw Error("Index out of bounds");}if(Oc(a)){a=ob.b(a,b);break a}if(O(a))a=U(a),--b;else throw Error("Index out of bounds");}return a}if(cb(nb,a))return ob.b(a,b);throw Error(["nth not supported on this type ",J.a(eb(null==a?null:a.constructor))].join(""));}
function X(a,b,c){if("number"!==typeof b)throw Error("Index argument to nth must be a number.");if(null==a)return c;if(null!=a&&(a.i&16||v===a.ac))return a.wa(null,b,c);if(Array.isArray(a))return-1<b&&b<a.length?a[b|0]:c;if("string"===typeof a)return-1<b&&b<a.length?a.charAt(b|0):c;if(null!=a&&(a.i&64||v===a.Wa)||null!=a&&(a.i&16777216||v===a.cc))return 0>b?c:Zc(a,b,c);if(cb(nb,a))return ob.f(a,b,c);throw Error(["nth not supported on this type ",J.a(eb(null==a?null:a.constructor))].join(""));}
var tc=function tc(a){switch(arguments.length){case 2:return tc.b(arguments[0],arguments[1]);case 3:return tc.f(arguments[0],arguments[1],arguments[2]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}};tc.b=function(a,b){return null==a?null:null!=a&&(a.i&256||v===a.uc)?a.T(null,b):Array.isArray(a)?null!=b&&b<a.length?a[b|0]:null:"string"===typeof a?null!=b&&b<a.length?a.charAt(b|0):null:cb(tb,a)?ub.b(a,b):null};
tc.f=function(a,b,c){return null!=a?null!=a&&(a.i&256||v===a.uc)?a.C(null,b,c):Array.isArray(a)?null!=b&&-1<b&&b<a.length?a[b|0]:c:"string"===typeof a?null!=b&&-1<b&&b<a.length?a.charAt(b|0):c:cb(tb,a)?ub.f(a,b,c):c:c};tc.H=3;var $c=function $c(a){switch(arguments.length){case 3:return $c.f(arguments[0],arguments[1],arguments[2]);default:for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return $c.o(arguments[0],arguments[1],arguments[2],new wc(c.slice(3),0,null))}};
$c.f=function(a,b,c){return null!=a&&(a.i&512||v===a.Uc)?a.Sa(null,b,c):null!=a?vb(a,b,c):ad([b,c])};$c.o=function(a,b,c,d){for(;;)if(a=$c.f(a,b,c),H(d))b=R(d),c=R(U(d)),d=U(U(d));else return a};$c.G=function(a){var b=R(a),c=U(a);a=R(c);var d=U(c);c=R(d);d=U(d);return this.o(b,a,c,d)};$c.H=3;function bd(a,b){this.g=a;this.l=b;this.i=393217;this.w=0}g=bd.prototype;g.N=function(){return this.l};g.S=function(a,b){return new bd(this.g,b)};
g.call=function(){function a(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca,ab){n=this;return cd.mb?cd.mb(n.g,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca,ab):cd.call(null,n.g,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca,ab)}function b(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca){n=this;return n.g.na?n.g.na(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca):n.g.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca)}function c(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua){n=this;return n.g.ma?n.g.ma(r,t,u,
w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua):n.g.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua)}function d(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka){n=this;return n.g.la?n.g.la(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka):n.g.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka)}function e(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca){n=this;return n.g.ka?n.g.ka(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca):n.g.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca)}function f(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y){n=this;return n.g.ja?n.g.ja(r,
t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y):n.g.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y)}function h(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S){n=this;return n.g.ia?n.g.ia(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S):n.g.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S)}function k(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q){n=this;return n.g.ha?n.g.ha(r,t,u,w,y,A,B,C,D,G,I,N,P,Q):n.g.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q)}function l(n,r,t,u,w,y,A,B,C,D,G,I,N,P){n=this;return n.g.ga?n.g.ga(r,t,u,w,y,A,B,C,D,G,I,N,P):n.g.call(null,r,t,u,w,y,A,B,C,D,G,I,N,
P)}function m(n,r,t,u,w,y,A,B,C,D,G,I,N){n=this;return n.g.fa?n.g.fa(r,t,u,w,y,A,B,C,D,G,I,N):n.g.call(null,r,t,u,w,y,A,B,C,D,G,I,N)}function p(n,r,t,u,w,y,A,B,C,D,G,I){n=this;return n.g.ea?n.g.ea(r,t,u,w,y,A,B,C,D,G,I):n.g.call(null,r,t,u,w,y,A,B,C,D,G,I)}function q(n,r,t,u,w,y,A,B,C,D,G){n=this;return n.g.da?n.g.da(r,t,u,w,y,A,B,C,D,G):n.g.call(null,r,t,u,w,y,A,B,C,D,G)}function x(n,r,t,u,w,y,A,B,C,D){n=this;return n.g.qa?n.g.qa(r,t,u,w,y,A,B,C,D):n.g.call(null,r,t,u,w,y,A,B,C,D)}function z(n,r,
t,u,w,y,A,B,C){n=this;return n.g.$?n.g.$(r,t,u,w,y,A,B,C):n.g.call(null,r,t,u,w,y,A,B,C)}function E(n,r,t,u,w,y,A,B){n=this;return n.g.pa?n.g.pa(r,t,u,w,y,A,B):n.g.call(null,r,t,u,w,y,A,B)}function K(n,r,t,u,w,y,A){n=this;return n.g.oa?n.g.oa(r,t,u,w,y,A):n.g.call(null,r,t,u,w,y,A)}function F(n,r,t,u,w,y){n=this;return n.g.M?n.g.M(r,t,u,w,y):n.g.call(null,r,t,u,w,y)}function T(n,r,t,u,w){n=this;return n.g.A?n.g.A(r,t,u,w):n.g.call(null,r,t,u,w)}function Z(n,r,t,u){n=this;return n.g.f?n.g.f(r,t,u):
n.g.call(null,r,t,u)}function la(n,r,t){n=this;return n.g.b?n.g.b(r,t):n.g.call(null,r,t)}function wa(n,r){n=this;return n.g.a?n.g.a(r):n.g.call(null,r)}function Ga(n){n=this;return n.g.u?n.g.u():n.g.call(null)}var da=null;da=function(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca,ab){switch(arguments.length){case 1:return Ga.call(this,n);case 2:return wa.call(this,n,r);case 3:return la.call(this,n,r,t);case 4:return Z.call(this,n,r,t,u);case 5:return T.call(this,n,r,t,u,w);case 6:return F.call(this,
n,r,t,u,w,y);case 7:return K.call(this,n,r,t,u,w,y,A);case 8:return E.call(this,n,r,t,u,w,y,A,B);case 9:return z.call(this,n,r,t,u,w,y,A,B,C);case 10:return x.call(this,n,r,t,u,w,y,A,B,C,D);case 11:return q.call(this,n,r,t,u,w,y,A,B,C,D,G);case 12:return p.call(this,n,r,t,u,w,y,A,B,C,D,G,I);case 13:return m.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N);case 14:return l.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P);case 15:return k.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q);case 16:return h.call(this,n,r,t,u,w,y,A,
B,C,D,G,I,N,P,Q,S);case 17:return f.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y);case 18:return e.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca);case 19:return d.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka);case 20:return c.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua);case 21:return b.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca);case 22:return a.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca,ab)}throw Error("Invalid arity: "+(arguments.length-1));};da.a=Ga;da.b=
wa;da.f=la;da.A=Z;da.M=T;da.oa=F;da.pa=K;da.$=E;da.qa=z;da.da=x;da.ea=q;da.fa=p;da.ga=m;da.ha=l;da.ia=k;da.ja=h;da.ka=f;da.la=e;da.ma=d;da.na=c;da.Pb=b;da.mb=a;return da}();g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.u=function(){return this.g.u?this.g.u():this.g.call(null)};g.a=function(a){return this.g.a?this.g.a(a):this.g.call(null,a)};g.b=function(a,b){return this.g.b?this.g.b(a,b):this.g.call(null,a,b)};
g.f=function(a,b,c){return this.g.f?this.g.f(a,b,c):this.g.call(null,a,b,c)};g.A=function(a,b,c,d){return this.g.A?this.g.A(a,b,c,d):this.g.call(null,a,b,c,d)};g.M=function(a,b,c,d,e){return this.g.M?this.g.M(a,b,c,d,e):this.g.call(null,a,b,c,d,e)};g.oa=function(a,b,c,d,e,f){return this.g.oa?this.g.oa(a,b,c,d,e,f):this.g.call(null,a,b,c,d,e,f)};g.pa=function(a,b,c,d,e,f,h){return this.g.pa?this.g.pa(a,b,c,d,e,f,h):this.g.call(null,a,b,c,d,e,f,h)};
g.$=function(a,b,c,d,e,f,h,k){return this.g.$?this.g.$(a,b,c,d,e,f,h,k):this.g.call(null,a,b,c,d,e,f,h,k)};g.qa=function(a,b,c,d,e,f,h,k,l){return this.g.qa?this.g.qa(a,b,c,d,e,f,h,k,l):this.g.call(null,a,b,c,d,e,f,h,k,l)};g.da=function(a,b,c,d,e,f,h,k,l,m){return this.g.da?this.g.da(a,b,c,d,e,f,h,k,l,m):this.g.call(null,a,b,c,d,e,f,h,k,l,m)};g.ea=function(a,b,c,d,e,f,h,k,l,m,p){return this.g.ea?this.g.ea(a,b,c,d,e,f,h,k,l,m,p):this.g.call(null,a,b,c,d,e,f,h,k,l,m,p)};
g.fa=function(a,b,c,d,e,f,h,k,l,m,p,q){return this.g.fa?this.g.fa(a,b,c,d,e,f,h,k,l,m,p,q):this.g.call(null,a,b,c,d,e,f,h,k,l,m,p,q)};g.ga=function(a,b,c,d,e,f,h,k,l,m,p,q,x){return this.g.ga?this.g.ga(a,b,c,d,e,f,h,k,l,m,p,q,x):this.g.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x)};g.ha=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z){return this.g.ha?this.g.ha(a,b,c,d,e,f,h,k,l,m,p,q,x,z):this.g.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z)};
g.ia=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E){return this.g.ia?this.g.ia(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E):this.g.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E)};g.ja=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K){return this.g.ja?this.g.ja(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K):this.g.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K)};g.ka=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F){return this.g.ka?this.g.ka(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F):this.g.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F)};
g.la=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T){return this.g.la?this.g.la(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T):this.g.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T)};g.ma=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z){return this.g.ma?this.g.ma(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z):this.g.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z)};
g.na=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la){return this.g.na?this.g.na(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la):this.g.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la)};g.Pb=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa){return cd.mb?cd.mb(this.g,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa):cd.call(null,this.g,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa)};function dd(a,b){return"function"==ba(a)?new bd(a,b):null==a?null:Fb(a,b)}
function ed(a){return null!=a&&(null!=a?a.i&131072||v===a.bc||(a.i?0:cb(Db,a)):cb(Db,a))?Eb(a):null}function fd(a){return null==a?!1:null!=a?a.i&4096||v===a.ed?!0:a.i?!1:cb(Ab,a):cb(Ab,a)}function gd(a){return null!=a?a.i&16777216||v===a.cc?!0:a.i?!1:cb(Ob,a):cb(Ob,a)}function hd(a){return null==a?!1:null!=a?a.i&1024||v===a.bd?!0:a.i?!1:cb(xb,a):cb(xb,a)}function id(a){return null!=a?a.i&67108864||v===a.dd?!0:a.i?!1:cb(Qb,a):cb(Qb,a)}
function jd(a){return null!=a?a.i&16384||v===a.fd?!0:a.i?!1:cb(Bb,a):cb(Bb,a)}function kd(a){return null!=a?a.w&512||v===a.Vc?!0:!1:!1}function ld(a,b,c,d,e){for(;0!==e;)c[d]=a[b],d+=1,--e,b+=1}var md={};function nd(a){return null==a?!1:!1===a?!1:!0}function od(a,b){return tc.f(a,b,md)===md?!1:!0}function pd(a,b){var c=O(b);return c?(b=R(c),c=U(c),qd?qd(a,b,c):rd.call(null,a,b,c)):a.u?a.u():a.call(null)}
function sd(a,b,c){for(c=O(c);;)if(c){var d=R(c);b=a.b?a.b(b,d):a.call(null,b,d);if(Ic(b))return Cb(b);c=U(c)}else return b}function td(a,b){a=fc(a);if(H(a.ba()))for(var c=a.next();;)if(a.ba()){var d=a.next();c=b.b?b.b(c,d):b.call(null,c,d);if(Ic(c))return Cb(c)}else return c;else return b.u?b.u():b.call(null)}function ud(a,b,c){for(a=fc(a);;)if(a.ba()){var d=a.next();c=b.b?b.b(c,d):b.call(null,c,d);if(Ic(c))return Cb(c)}else return c}
function rd(a){switch(arguments.length){case 2:return vd(arguments[0],arguments[1]);case 3:return qd(arguments[0],arguments[1],arguments[2]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}}function vd(a,b){return null!=b&&(b.i&524288||v===b.yc)?b.sa(null,a):Array.isArray(b)?Kc(b,a):"string"===typeof b?Kc(b,a):cb(Gb,b)?Hb.b(b,a):vc(b)?td(b,a):pd(a,b)}
function qd(a,b,c){return null!=c&&(c.i&524288||v===c.yc)?c.ta(null,a,b):Array.isArray(c)?Lc(c,a,b):"string"===typeof c?Lc(c,a,b):cb(Gb,c)?Hb.f(c,a,b):vc(c)?ud(c,a,b):sd(a,b,c)}function wd(a,b){return null!=b?Jb(b,a,!0):!0}function xd(a){return a}function yd(a){if("number"===typeof a)return String.fromCharCode(a);if("string"===typeof a&&1===a.length)return a;throw Error("Argument to char must be a character or number");}function zd(a){a=(a-a%2)/2;return 0<=a?Math.floor(a):Math.ceil(a)}
function Ad(a){a-=a>>1&1431655765;a=(a&858993459)+(a>>2&858993459);return 16843009*(a+(a>>4)&252645135)>>24}var J=function J(a){switch(arguments.length){case 0:return J.u();case 1:return J.a(arguments[0]);default:for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return J.o(arguments[0],new wc(c.slice(1),0,null))}};J.u=function(){return""};J.a=function(a){return null==a?"":[a].join("")};J.o=function(a,b){for(a=new Ma(J.a(a));;)if(H(b))a=a.append(J.a(R(b))),b=U(b);else return a.toString()};
J.G=function(a){var b=R(a);a=U(a);return this.o(b,a)};J.H=1;function Tc(a,b){if(gd(b))if(Nc(a)&&Nc(b)&&W(a)!==W(b))a=!1;else a:for(a=O(a),b=O(b);;){if(null==a){a=null==b;break a}if(null!=b&&zc.b(R(a),R(b)))a=U(a),b=U(b);else{a=!1;break a}}else a=null;return nd(a)}function Yc(a,b,c,d,e){this.l=a;this.first=b;this.Pa=c;this.count=d;this.s=e;this.i=65937646;this.w=8192}g=Yc.prototype;g.toString=function(){return hc(this)};
g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,this.count)}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.l};g.aa=function(){return 1===this.count?null:this.Pa};g.Y=function(){return this.count};g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};g.O=function(a,b){return Tc(this,b)};
g.V=function(){return Fb(yc,this.l)};g.sa=function(a,b){return pd(b,this)};g.ta=function(a,b,c){return sd(b,c,this)};g.ra=function(){return this.first};g.ua=function(){return 1===this.count?yc:this.Pa};g.U=function(){return this};g.S=function(a,b){return b===this.l?this:new Yc(b,this.first,this.Pa,this.count,this.s)};g.X=function(a,b){return new Yc(this.l,b,this,this.count+1,null)};function Bd(a){return null!=a?a.i&33554432||v===a.ad?!0:a.i?!1:cb(Pb,a):cb(Pb,a)}Yc.prototype[fb]=function(){return Bc(this)};
function Cd(a){this.l=a;this.i=65937614;this.w=8192}g=Cd.prototype;g.toString=function(){return hc(this)};g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.l};g.aa=function(){return null};g.Y=function(){return 0};g.P=function(){return Ec};g.O=function(a,b){return Bd(b)||gd(b)?null==O(b):!1};g.V=function(){return this};
g.sa=function(a,b){return pd(b,this)};g.ta=function(a,b,c){return sd(b,c,this)};g.ra=function(){return null};g.ua=function(){return yc};g.U=function(){return null};g.S=function(a,b){return b===this.l?this:new Cd(b)};g.X=function(a,b){return new Yc(this.l,b,null,1,null)};var yc=new Cd(null);Cd.prototype[fb]=function(){return Bc(this)};var Dd=function Dd(a){for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return Dd.o(0<c.length?new wc(c.slice(0),0,null):null)};
Dd.o=function(a){if(a instanceof wc&&0===a.m)var b=a.c;else a:for(b=[];;)if(null!=a)b.push(pb(a)),a=sb(a);else break a;a=b.length;for(var c=yc;;)if(0<a){var d=a-1;c=mb(c,b[a-1]);a=d}else return c};Dd.H=0;Dd.G=function(a){return this.o(O(a))};function Ed(a,b,c,d){this.l=a;this.first=b;this.Pa=c;this.s=d;this.i=65929452;this.w=8192}g=Ed.prototype;g.toString=function(){return hc(this)};
g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.l};g.aa=function(){return null==this.Pa?null:O(this.Pa)};g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};g.O=function(a,b){return Tc(this,b)};g.V=function(){return yc};
g.sa=function(a,b){return pd(b,this)};g.ta=function(a,b,c){return sd(b,c,this)};g.ra=function(){return this.first};g.ua=function(){return null==this.Pa?yc:this.Pa};g.U=function(){return this};g.S=function(a,b){return b===this.l?this:new Ed(b,this.first,this.Pa,this.s)};g.X=function(a,b){return new Ed(null,b,this,null)};Ed.prototype[fb]=function(){return Bc(this)};function Uc(a,b){return null==b?new Yc(null,a,null,1,null):null!=b&&(b.i&64||v===b.Wa)?new Ed(null,a,b,null):new Ed(null,a,O(b),null)}
function M(a,b,c,d){this.ib=a;this.name=b;this.Ma=c;this.bb=d;this.i=2153775105;this.w=4096}g=M.prototype;g.toString=function(){return[":",J.a(this.Ma)].join("")};g.O=function(a,b){return b instanceof M?this.Ma===b.Ma:!1};g.call=function(){var a=null;a=function(b,c,d){switch(arguments.length){case 2:return tc.b(c,this);case 3:return tc.f(c,this,d)}throw Error("Invalid arity: "+(arguments.length-1));};a.b=function(b,c){return tc.b(c,this)};a.f=function(b,c,d){return tc.f(c,this,d)};return a}();
g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return tc.b(a,this)};g.b=function(a,b){return tc.f(a,this,b)};g.P=function(){var a=this.bb;return null!=a?a:this.bb=a=rc(mc(this.name),pc(this.ib))+2654435769|0};g.nb=function(){return this.name};g.ob=function(){return this.ib};g.R=function(a,b){return Rb(b,[":",J.a(this.Ma)].join(""))};function Fd(a,b){return a===b?!0:a instanceof M&&b instanceof M?a.Ma===b.Ma:!1}
function Gd(a){if(null!=a&&(a.w&4096||v===a.xc))return a.ob(null);throw Error(["Doesn't support namespace: ",J.a(a)].join(""));}var Hd=function Hd(a){switch(arguments.length){case 1:return Hd.a(arguments[0]);case 2:return Hd.b(arguments[0],arguments[1]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}};
Hd.a=function(a){if(a instanceof M)return a;if(a instanceof sc)return new M(Gd(a),Id.a?Id.a(a):Id.call(null,a),a.Va,null);if("string"===typeof a){var b=a.split("/");return 2===b.length?new M(b[0],b[1],a,null):new M(null,b[0],a,null)}return null};
Hd.b=function(a,b){a=a instanceof M?Id.a?Id.a(a):Id.call(null,a):a instanceof sc?Id.a?Id.a(a):Id.call(null,a):a;b=b instanceof M?Id.a?Id.a(b):Id.call(null,b):b instanceof sc?Id.a?Id.a(b):Id.call(null,b):b;return new M(a,b,[H(a)?[J.a(a),"/"].join(""):null,J.a(b)].join(""),null)};Hd.H=2;function Jd(a,b,c,d){this.l=a;this.ub=b;this.B=c;this.s=d;this.i=32374988;this.w=1}g=Jd.prototype;g.toString=function(){return hc(this)};
function Kd(a){null!=a.ub&&(a.B=a.ub.u?a.ub.u():a.ub.call(null),a.ub=null);return a.B}g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.l};g.aa=function(){this.U(null);return null==this.B?null:U(this.B)};g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};g.O=function(a,b){return Tc(this,b)};
g.V=function(){return Fb(yc,this.l)};g.sa=function(a,b){return pd(b,this)};g.ta=function(a,b,c){return sd(b,c,this)};g.ra=function(){this.U(null);return null==this.B?null:R(this.B)};g.ua=function(){this.U(null);return null!=this.B?xc(this.B):yc};g.U=function(){Kd(this);if(null==this.B)return null;for(var a=this.B;;)if(a instanceof Jd)a=Kd(a);else return this.B=a,O(this.B)};g.S=function(a,b){var c=this;return b===this.l?c:new Jd(b,function(){return c.U(null)},null,this.s)};
g.X=function(a,b){return Uc(b,this)};Jd.prototype[fb]=function(){return Bc(this)};function Ld(a){this.D=a;this.end=0;this.i=2;this.w=0}Ld.prototype.add=function(a){this.D[this.end]=a;return this.end+=1};Ld.prototype.za=function(){var a=new Md(this.D,0,this.end);this.D=null;return a};Ld.prototype.Y=function(){return this.end};function Md(a,b,c){this.c=a;this.ca=b;this.end=c;this.i=524306;this.w=0}g=Md.prototype;g.Y=function(){return this.end-this.ca};g.K=function(a,b){return this.c[this.ca+b]};
g.wa=function(a,b,c){return 0<=b&&b<this.end-this.ca?this.c[this.ca+b]:c};g.Zb=function(){if(this.ca===this.end)throw Error("-drop-first of empty chunk");return new Md(this.c,this.ca+1,this.end)};g.sa=function(a,b){return Mc(this.c,b,this.c[this.ca],this.ca+1)};g.ta=function(a,b,c){return Mc(this.c,b,c,this.ca)};function Nd(a,b,c,d){this.za=a;this.Ia=b;this.l=c;this.s=d;this.i=31850732;this.w=1536}g=Nd.prototype;g.toString=function(){return hc(this)};
g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.l};g.aa=function(){return 1<ib(this.za)?new Nd(Yb(this.za),this.Ia,null,null):null==this.Ia?null:Nb(this.Ia)};g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};
g.O=function(a,b){return Tc(this,b)};g.V=function(){return yc};g.ra=function(){return ob.b(this.za,0)};g.ua=function(){return 1<ib(this.za)?new Nd(Yb(this.za),this.Ia,null,null):null==this.Ia?yc:this.Ia};g.U=function(){return this};g.Ob=function(){return this.za};g.Db=function(){return null==this.Ia?yc:this.Ia};g.S=function(a,b){return b===this.l?this:new Nd(this.za,this.Ia,b,this.s)};g.X=function(a,b){return Uc(b,this)};g.$b=function(){return null==this.Ia?null:this.Ia};Nd.prototype[fb]=function(){return Bc(this)};
function Od(a,b){return 0===ib(a)?b:new Nd(a,b,null,null)}function Pd(a,b){a.add(b)}function Qd(a){var b=[];for(a=O(a);;)if(null!=a)b.push(R(a)),a=U(a);else return b}function Rd(a,b){if(Nc(b))return W(b);var c=0;for(b=O(b);;)if(null!=b&&c<a)c+=1,b=U(b);else return c}
var Sd=function Sd(a){if(null==a)return null;var c=U(a);return null==c?O(R(a)):Uc(R(a),Sd.a?Sd.a(c):Sd.call(null,c))},Td=function Td(a){switch(arguments.length){case 0:return Td.u();case 1:return Td.a(arguments[0]);case 2:return Td.b(arguments[0],arguments[1]);default:for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return Td.o(arguments[0],arguments[1],new wc(c.slice(2),0,null))}};Td.u=function(){return new Jd(null,function(){return null},null,null)};
Td.a=function(a){return new Jd(null,function(){return a},null,null)};Td.b=function(a,b){return new Jd(null,function(){var c=O(a);return c?kd(c)?Od(Zb(c),Td.b($b(c),b)):Uc(R(c),Td.b(xc(c),b)):b},null,null)};Td.o=function(a,b,c){return function h(e,f){return new Jd(null,function(){var k=O(e);return k?kd(k)?Od(Zb(k),h($b(k),f)):Uc(R(k),h(xc(k),f)):H(f)?h(R(f),U(f)):null},null,null)}(Td.b(a,b),c)};Td.G=function(a){var b=R(a),c=U(a);a=R(c);c=U(c);return this.o(b,a,c)};Td.H=2;
var Ud=function Ud(a){switch(arguments.length){case 0:return Ud.u();case 1:return Ud.a(arguments[0]);case 2:return Ud.b(arguments[0],arguments[1]);default:for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return Ud.o(arguments[0],arguments[1],new wc(c.slice(2),0,null))}};Ud.u=function(){return Ub(Xc)};Ud.a=function(a){return a};Ud.b=function(a,b){return Vb(a,b)};Ud.o=function(a,b,c){for(;;)if(a=Vb(a,b),H(c))b=R(c),c=U(c);else return a};
Ud.G=function(a){var b=R(a),c=U(a);a=R(c);c=U(c);return this.o(b,a,c)};Ud.H=2;function Vd(a,b,c){return Xb(a,b,c)}
function Wd(a,b,c){var d=O(c);if(0===b)return a.u?a.u():a.call(null);c=pb(d);var e=qb(d);if(1===b)return a.a?a.a(c):a.call(null,c);d=pb(e);var f=qb(e);if(2===b)return a.b?a.b(c,d):a.call(null,c,d);e=pb(f);var h=qb(f);if(3===b)return a.f?a.f(c,d,e):a.call(null,c,d,e);f=pb(h);var k=qb(h);if(4===b)return a.A?a.A(c,d,e,f):a.call(null,c,d,e,f);h=pb(k);var l=qb(k);if(5===b)return a.M?a.M(c,d,e,f,h):a.call(null,c,d,e,f,h);k=pb(l);var m=qb(l);if(6===b)return a.oa?a.oa(c,d,e,f,h,k):a.call(null,c,d,e,f,h,k);
l=pb(m);var p=qb(m);if(7===b)return a.pa?a.pa(c,d,e,f,h,k,l):a.call(null,c,d,e,f,h,k,l);m=pb(p);var q=qb(p);if(8===b)return a.$?a.$(c,d,e,f,h,k,l,m):a.call(null,c,d,e,f,h,k,l,m);p=pb(q);var x=qb(q);if(9===b)return a.qa?a.qa(c,d,e,f,h,k,l,m,p):a.call(null,c,d,e,f,h,k,l,m,p);q=pb(x);var z=qb(x);if(10===b)return a.da?a.da(c,d,e,f,h,k,l,m,p,q):a.call(null,c,d,e,f,h,k,l,m,p,q);x=pb(z);var E=qb(z);if(11===b)return a.ea?a.ea(c,d,e,f,h,k,l,m,p,q,x):a.call(null,c,d,e,f,h,k,l,m,p,q,x);z=pb(E);var K=qb(E);if(12===
b)return a.fa?a.fa(c,d,e,f,h,k,l,m,p,q,x,z):a.call(null,c,d,e,f,h,k,l,m,p,q,x,z);E=pb(K);var F=qb(K);if(13===b)return a.ga?a.ga(c,d,e,f,h,k,l,m,p,q,x,z,E):a.call(null,c,d,e,f,h,k,l,m,p,q,x,z,E);K=pb(F);var T=qb(F);if(14===b)return a.ha?a.ha(c,d,e,f,h,k,l,m,p,q,x,z,E,K):a.call(null,c,d,e,f,h,k,l,m,p,q,x,z,E,K);F=pb(T);var Z=qb(T);if(15===b)return a.ia?a.ia(c,d,e,f,h,k,l,m,p,q,x,z,E,K,F):a.call(null,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F);T=pb(Z);var la=qb(Z);if(16===b)return a.ja?a.ja(c,d,e,f,h,k,l,m,p,q,x,
z,E,K,F,T):a.call(null,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T);Z=pb(la);var wa=qb(la);if(17===b)return a.ka?a.ka(c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z):a.call(null,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z);la=pb(wa);var Ga=qb(wa);if(18===b)return a.la?a.la(c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la):a.call(null,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la);wa=pb(Ga);Ga=qb(Ga);if(19===b)return a.ma?a.ma(c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa):a.call(null,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa);var da=pb(Ga);qb(Ga);if(20===b)return a.na?
a.na(c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa,da):a.call(null,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa,da);throw Error("Only up to 20 arguments supported on functions");}function Xd(a){return null!=a&&(a.i&128||v===a.pb)?a.aa(null):O(xc(a))}function Yd(a,b,c){return null==c?a.a?a.a(b):a.call(a,b):Zd(a,b,pb(c),Xd(c))}function Zd(a,b,c,d){return null==d?a.b?a.b(b,c):a.call(a,b,c):$d(a,b,c,pb(d),Xd(d))}function $d(a,b,c,d,e){return null==e?a.f?a.f(b,c,d):a.call(a,b,c,d):ae(a,b,c,d,pb(e),Xd(e))}
function ae(a,b,c,d,e,f){if(null==f)return a.A?a.A(b,c,d,e):a.call(a,b,c,d,e);var h=pb(f),k=U(f);if(null==k)return a.M?a.M(b,c,d,e,h):a.call(a,b,c,d,e,h);f=pb(k);var l=U(k);if(null==l)return a.oa?a.oa(b,c,d,e,h,f):a.call(a,b,c,d,e,h,f);k=pb(l);var m=U(l);if(null==m)return a.pa?a.pa(b,c,d,e,h,f,k):a.call(a,b,c,d,e,h,f,k);l=pb(m);var p=U(m);if(null==p)return a.$?a.$(b,c,d,e,h,f,k,l):a.call(a,b,c,d,e,h,f,k,l);m=pb(p);var q=U(p);if(null==q)return a.qa?a.qa(b,c,d,e,h,f,k,l,m):a.call(a,b,c,d,e,h,f,k,l,
m);p=pb(q);var x=U(q);if(null==x)return a.da?a.da(b,c,d,e,h,f,k,l,m,p):a.call(a,b,c,d,e,h,f,k,l,m,p);q=pb(x);var z=U(x);if(null==z)return a.ea?a.ea(b,c,d,e,h,f,k,l,m,p,q):a.call(a,b,c,d,e,h,f,k,l,m,p,q);x=pb(z);var E=U(z);if(null==E)return a.fa?a.fa(b,c,d,e,h,f,k,l,m,p,q,x):a.call(a,b,c,d,e,h,f,k,l,m,p,q,x);z=pb(E);var K=U(E);if(null==K)return a.ga?a.ga(b,c,d,e,h,f,k,l,m,p,q,x,z):a.call(a,b,c,d,e,h,f,k,l,m,p,q,x,z);E=pb(K);var F=U(K);if(null==F)return a.ha?a.ha(b,c,d,e,h,f,k,l,m,p,q,x,z,E):a.call(a,
b,c,d,e,h,f,k,l,m,p,q,x,z,E);K=pb(F);var T=U(F);if(null==T)return a.ia?a.ia(b,c,d,e,h,f,k,l,m,p,q,x,z,E,K):a.call(a,b,c,d,e,h,f,k,l,m,p,q,x,z,E,K);F=pb(T);var Z=U(T);if(null==Z)return a.ja?a.ja(b,c,d,e,h,f,k,l,m,p,q,x,z,E,K,F):a.call(a,b,c,d,e,h,f,k,l,m,p,q,x,z,E,K,F);T=pb(Z);var la=U(Z);if(null==la)return a.ka?a.ka(b,c,d,e,h,f,k,l,m,p,q,x,z,E,K,F,T):a.call(a,b,c,d,e,h,f,k,l,m,p,q,x,z,E,K,F,T);Z=pb(la);var wa=U(la);if(null==wa)return a.la?a.la(b,c,d,e,h,f,k,l,m,p,q,x,z,E,K,F,T,Z):a.call(a,b,c,d,e,
h,f,k,l,m,p,q,x,z,E,K,F,T,Z);la=pb(wa);var Ga=U(wa);if(null==Ga)return a.ma?a.ma(b,c,d,e,h,f,k,l,m,p,q,x,z,E,K,F,T,Z,la):a.call(a,b,c,d,e,h,f,k,l,m,p,q,x,z,E,K,F,T,Z,la);wa=pb(Ga);Ga=U(Ga);if(null==Ga)return a.na?a.na(b,c,d,e,h,f,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa):a.call(a,b,c,d,e,h,f,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa);b=[b,c,d,e,h,f,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa];for(c=Ga;;)if(c)b.push(pb(c)),c=U(c);else break;return a.apply(a,b)}
function cd(a){switch(arguments.length){case 2:return be(arguments[0],arguments[1]);case 3:return ce(arguments[0],arguments[1],arguments[2]);case 4:var b=arguments[0];var c=arguments[1],d=arguments[2],e=arguments[3];b.G?(c=Uc(c,Uc(d,e)),d=b.H,e=2+Rd(d-1,e),b=e<=d?Wd(b,e,c):b.G(c)):b=Zd(b,c,d,O(e));return b;case 5:return de(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);default:b=[];e=arguments.length;for(c=0;;)if(c<e)b.push(arguments[c]),c+=1;else break;return ee(arguments[0],arguments[1],
arguments[2],arguments[3],arguments[4],new wc(b.slice(5),0,null))}}function be(a,b){if(a.G){var c=a.H,d=Rd(c+1,b);return d<=c?Wd(a,d,b):a.G(b)}b=O(b);return null==b?a.u?a.u():a.call(a):Yd(a,pb(b),Xd(b))}function ce(a,b,c){if(a.G){b=Uc(b,c);var d=a.H;c=Rd(d,c)+1;return c<=d?Wd(a,c,b):a.G(b)}return Yd(a,b,O(c))}function de(a,b,c,d,e){return a.G?(b=Uc(b,Uc(c,Uc(d,e))),c=a.H,e=3+Rd(c-2,e),e<=c?Wd(a,e,b):a.G(b)):$d(a,b,c,d,O(e))}
function ee(a,b,c,d,e,f){return a.G?(f=Sd(f),b=Uc(b,Uc(c,Uc(d,Uc(e,f)))),c=a.H,f=4+Rd(c-3,f),f<=c?Wd(a,f,b):a.G(b)):ae(a,b,c,d,e,Sd(f))}
function fe(){if("undefined"===typeof Na||"undefined"===typeof Oa||"undefined"===typeof Pa)Pa=function(a){this.Kc=a;this.i=393216;this.w=0},Pa.prototype.S=function(a,b){return new Pa(b)},Pa.prototype.N=function(){return this.Kc},Pa.prototype.ba=function(){return!1},Pa.prototype.next=function(){return Error("No such element")},Pa.prototype.remove=function(){return Error("Unsupported operation")},Pa.Tb=function(){return new ge(null,1,5,he,[ie],null)},Pa.sb=!0,Pa.Xa="cljs.core/t_cljs$core116584",Pa.Gb=
function(a){return Rb(a,"cljs.core/t_cljs$core116584")};return new Pa(je)}function ke(a,b){for(;;){if(null==O(b))return!0;var c=R(b);c=a.a?a.a(c):a.call(null,c);if(H(c))b=U(b);else return!1}}function le(a){for(var b=xd;;)if(a=O(a)){var c=R(a);c=b.a?b.a(c):b.call(null,c);if(H(c))return c;a=U(a)}else return null}function me(a){if("number"===typeof a&&!isNaN(a)&&Infinity!==a&&parseFloat(a)===parseInt(a,10))return 0===(a&1);throw Error(["Argument must be an integer: ",J.a(a)].join(""));}
function ne(){return function(){function a(b){if(0<arguments.length)for(var c=0,d=Array(arguments.length-0);c<d.length;)d[c]=arguments[c+0],++c;return!1}a.H=0;a.G=function(b){O(b);return!1};a.o=function(){return!1};return a}()}
function oe(){var a=pe;return function(){function b(k,l,m){return a.A?a.A(!0,k,l,m):a.call(null,!0,k,l,m)}function c(k,l){return a.f?a.f(!0,k,l):a.call(null,!0,k,l)}function d(k){return a.b?a.b(!0,k):a.call(null,!0,k)}function e(){return a.a?a.a(!0):a.call(null,!0)}var f=null,h=function(){function k(m,p,q,x){var z=null;if(3<arguments.length){z=0;for(var E=Array(arguments.length-3);z<E.length;)E[z]=arguments[z+3],++z;z=new wc(E,0,null)}return l.call(this,m,p,q,z)}function l(m,p,q,x){return ee(a,!0,
m,p,q,Vc([x]))}k.H=3;k.G=function(m){var p=R(m);m=U(m);var q=R(m);m=U(m);var x=R(m);m=xc(m);return l(p,q,x,m)};k.o=l;return k}();f=function(k,l,m,p){switch(arguments.length){case 0:return e.call(this);case 1:return d.call(this,k);case 2:return c.call(this,k,l);case 3:return b.call(this,k,l,m);default:var q=null;if(3<arguments.length){q=0;for(var x=Array(arguments.length-3);q<x.length;)x[q]=arguments[q+3],++q;q=new wc(x,0,null)}return h.o(k,l,m,q)}throw Error("Invalid arity: "+arguments.length);};
f.H=3;f.G=h.G;f.u=e;f.a=d;f.b=c;f.f=b;f.o=h.o;return f}()}function qe(a){this.state=a;this.mc=this.Tc=this.l=null;this.w=16386;this.i=6455296}qe.prototype.O=function(a,b){return this===b};qe.prototype.Eb=function(){return this.state};qe.prototype.N=function(){return this.l};qe.prototype.P=function(){return this[ea]||(this[ea]=++fa)};
function re(a,b){if(a instanceof qe){var c=a.Tc;if(null!=c&&!H(c.a?c.a(b):c.call(null,b)))throw Error("Validator rejected reference state");c=a.state;a.state=b;if(null!=a.mc)a:for(var d=O(a.mc),e=null,f=0,h=0;;)if(h<f){var k=e.K(null,h),l=X(k,0,null);k=X(k,1,null);k.A?k.A(l,a,c,b):k.call(null,l,a,c,b);h+=1}else if(d=O(d))kd(d)?(e=Zb(d),d=$b(d),l=e,f=W(e),e=l):(e=R(d),l=X(e,0,null),k=X(e,1,null),k.A?k.A(l,a,c,b):k.call(null,l,a,c,b),d=U(d),e=null,f=0),h=0;else break a;return b}return cc(a,b)}
var se=function se(a){switch(arguments.length){case 2:return se.b(arguments[0],arguments[1]);case 3:return se.f(arguments[0],arguments[1],arguments[2]);case 4:return se.A(arguments[0],arguments[1],arguments[2],arguments[3]);default:for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return se.o(arguments[0],arguments[1],arguments[2],arguments[3],new wc(c.slice(4),0,null))}};
se.b=function(a,b){if(a instanceof qe){var c=a.state;b=b.a?b.a(c):b.call(null,c);a=re(a,b)}else a=dc.b(a,b);return a};se.f=function(a,b,c){if(a instanceof qe){var d=a.state;b=b.b?b.b(d,c):b.call(null,d,c);a=re(a,b)}else a=dc.f(a,b,c);return a};se.A=function(a,b,c,d){if(a instanceof qe){var e=a.state;b=b.f?b.f(e,c,d):b.call(null,e,c,d);a=re(a,b)}else a=dc.A(a,b,c,d);return a};se.o=function(a,b,c,d,e){return a instanceof qe?re(a,de(b,a.state,c,d,e)):dc.M(a,b,c,d,e)};
se.G=function(a){var b=R(a),c=U(a);a=R(c);var d=U(c);c=R(d);var e=U(d);d=R(e);e=U(e);return this.o(b,a,c,d,e)};se.H=4;
var te=function te(a){switch(arguments.length){case 1:return te.a(arguments[0]);case 2:return te.b(arguments[0],arguments[1]);case 3:return te.f(arguments[0],arguments[1],arguments[2]);case 4:return te.A(arguments[0],arguments[1],arguments[2],arguments[3]);default:for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return te.o(arguments[0],arguments[1],arguments[2],arguments[3],new wc(c.slice(4),0,null))}};
te.a=function(a){return function(b){return function(){function c(k,l){l=a.a?a.a(l):a.call(null,l);return b.b?b.b(k,l):b.call(null,k,l)}function d(k){return b.a?b.a(k):b.call(null,k)}function e(){return b.u?b.u():b.call(null)}var f=null,h=function(){function k(m,p,q){var x=null;if(2<arguments.length){x=0;for(var z=Array(arguments.length-2);x<z.length;)z[x]=arguments[x+2],++x;x=new wc(z,0,null)}return l.call(this,m,p,x)}function l(m,p,q){p=ce(a,p,q);return b.b?b.b(m,p):b.call(null,m,p)}k.H=2;k.G=function(m){var p=
R(m);m=U(m);var q=R(m);m=xc(m);return l(p,q,m)};k.o=l;return k}();f=function(k,l,m){switch(arguments.length){case 0:return e.call(this);case 1:return d.call(this,k);case 2:return c.call(this,k,l);default:var p=null;if(2<arguments.length){p=0;for(var q=Array(arguments.length-2);p<q.length;)q[p]=arguments[p+2],++p;p=new wc(q,0,null)}return h.o(k,l,p)}throw Error("Invalid arity: "+arguments.length);};f.H=2;f.G=h.G;f.u=e;f.a=d;f.b=c;f.o=h.o;return f}()}};
te.b=function(a,b){return new Jd(null,function(){var c=O(b);if(c){if(kd(c)){for(var d=Zb(c),e=W(d),f=new Ld(Array(e)),h=0;;)if(h<e)Pd(f,function(){var k=ob.b(d,h);return a.a?a.a(k):a.call(null,k)}()),h+=1;else break;return Od(f.za(),te.b(a,$b(c)))}return Uc(function(){var k=R(c);return a.a?a.a(k):a.call(null,k)}(),te.b(a,xc(c)))}return null},null,null)};
te.f=function(a,b,c){return new Jd(null,function(){var d=O(b),e=O(c);if(d&&e){var f=R(d);var h=R(e);f=a.b?a.b(f,h):a.call(null,f,h);d=Uc(f,te.f(a,xc(d),xc(e)))}else d=null;return d},null,null)};te.A=function(a,b,c,d){return new Jd(null,function(){var e=O(b),f=O(c),h=O(d);if(e&&f&&h){var k=R(e);var l=R(f),m=R(h);k=a.f?a.f(k,l,m):a.call(null,k,l,m);e=Uc(k,te.A(a,xc(e),xc(f),xc(h)))}else e=null;return e},null,null)};
te.o=function(a,b,c,d,e){return te.b(function(f){return be(a,f)},function k(h){return new Jd(null,function(){var l=te.b(O,h);return ke(xd,l)?Uc(te.b(R,l),k(te.b(xc,l))):null},null,null)}(Wc.o(e,d,Vc([c,b]))))};te.G=function(a){var b=R(a),c=U(a);a=R(c);var d=U(c);c=R(d);var e=U(d);d=R(e);e=U(e);return this.o(b,a,c,d,e)};te.H=4;function ue(a,b){return new Jd(null,function(){if(0<a){var c=O(b);return c?Uc(R(c),ue(a-1,xc(c))):null}return null},null,null)}
function ve(a,b){return new Jd(null,function(){a:for(var c=a,d=b;;)if(d=O(d),0<c&&d)--c,d=xc(d);else break a;return d},null,null)}function we(a,b,c,d){this.l=a;this.count=b;this.v=c;this.next=d;this.s=null;this.i=32374988;this.w=1}g=we.prototype;g.toString=function(){return hc(this)};
g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,this.count)}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.l};g.aa=function(){return null==this.next?1<this.count?this.next=new we(null,this.count-1,this.v,null):-1===this.count?this:null:this.next};
g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};g.O=function(a,b){return Tc(this,b)};g.V=function(){return yc};g.sa=function(a,b){if(-1===this.count)for(var c=b.b?b.b(this.v,this.v):b.call(null,this.v,this.v);;){if(Ic(c))return Cb(c);c=b.b?b.b(c,this.v):b.call(null,c,this.v)}else for(a=1,c=this.v;;)if(a<this.count){c=b.b?b.b(c,this.v):b.call(null,c,this.v);if(Ic(c))return Cb(c);a+=1}else return c};
g.ta=function(a,b,c){if(-1===this.count)for(c=b.b?b.b(c,this.v):b.call(null,c,this.v);;){if(Ic(c))return Cb(c);c=b.b?b.b(c,this.v):b.call(null,c,this.v)}else for(a=0;;)if(a<this.count){c=b.b?b.b(c,this.v):b.call(null,c,this.v);if(Ic(c))return Cb(c);a+=1}else return c};g.ra=function(){return this.v};g.ua=function(){return null==this.next?1<this.count?this.next=new we(null,this.count-1,this.v,null):-1===this.count?this:yc:this.next};g.U=function(){return this};
g.S=function(a,b){return b===this.l?this:new we(b,this.count,this.v,this.next)};g.X=function(a,b){return Uc(b,this)};var xe=function xe(a){switch(arguments.length){case 0:return xe.u();case 1:return xe.a(arguments[0]);case 2:return xe.b(arguments[0],arguments[1]);default:for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return xe.o(arguments[0],arguments[1],new wc(c.slice(2),0,null))}};xe.u=function(){return yc};
xe.a=function(a){return new Jd(null,function(){return a},null,null)};xe.b=function(a,b){return new Jd(null,function(){var c=O(a),d=O(b);return c&&d?Uc(R(c),Uc(R(d),xe.b(xc(c),xc(d)))):null},null,null)};xe.o=function(a,b,c){return new Jd(null,function(){var d=te.b(O,Wc.o(c,b,Vc([a])));return ke(xd,d)?Td.b(te.b(R,d),be(xe,te.b(xc,d))):null},null,null)};xe.G=function(a){var b=R(a),c=U(a);a=R(c);c=U(c);return this.o(b,a,c)};xe.H=2;
function ye(a,b){return null!=a?null!=a&&(a.w&4||v===a.Xc)?Fb(Wb(qd(Vb,Ub(a),b)),ed(a)):qd(mb,a,b):qd(Wc,a,b)}function ze(a,b){this.J=a;this.c=b}function Ae(a){return new ze(a,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])}function Be(a){a=a.j;return 32>a?0:a-1>>>5<<5}function Ce(a,b,c){for(;;){if(0===b)return c;var d=Ae(a);d.c[0]=c;c=d;b-=5}}
var De=function De(a,b,c,d){var f=new ze(c.J,gb(c.c)),h=a.j-1>>>b&31;5===b?f.c[h]=d:(c=c.c[h],null!=c?(b-=5,a=De.A?De.A(a,b,c,d):De.call(null,a,b,c,d)):a=Ce(null,b-5,d),f.c[h]=a);return f};function Ee(a,b){if(b>=Be(a))return a.I;var c=a.root;for(a=a.shift;;)if(0<a){var d=a-5;c=c.c[b>>>a&31];a=d}else return c.c}function Fe(a,b){if(0<=b&&b<a.j)b=Ee(a,b);else throw a=a.j,Error(["No item ",J.a(b)," in vector of length ",J.a(a)].join(""));return b}
var Ge=function Ge(a,b,c,d,e){var h=new ze(c.J,gb(c.c));if(0===b)h.c[d&31]=e;else{var k=d>>>b&31;b-=5;c=c.c[k];a=Ge.M?Ge.M(a,b,c,d,e):Ge.call(null,a,b,c,d,e);h.c[k]=a}return h};function He(a,b,c){this.Mb=this.m=0;this.c=a;this.Sc=b;this.start=0;this.end=c}He.prototype.ba=function(){return this.m<this.end};He.prototype.next=function(){32===this.m-this.Mb&&(this.c=Ee(this.Sc,this.m),this.Mb+=32);var a=this.c[this.m&31];this.m+=1;return a};
function Ie(a,b,c,d){return c<d?Je(a,b,Pc(a,c),c+1,d):b.u?b.u():b.call(null)}function Je(a,b,c,d,e){var f=c;c=d;for(d=Ee(a,d);;)if(c<e){var h=c&31;d=0===h?Ee(a,c):d;h=d[h];f=b.b?b.b(f,h):b.call(null,f,h);if(Ic(f))return Cb(f);c+=1}else return f}function ge(a,b,c,d,e,f){this.l=a;this.j=b;this.shift=c;this.root=d;this.I=e;this.s=f;this.i=167666463;this.w=139268}g=ge.prototype;g.lb=function(a,b){return 0<=b&&b<this.j?new Ke(b,Ee(this,b)[b&31]):null};g.toString=function(){return hc(this)};
g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.T=function(a,b){return this.C(null,b,null)};g.C=function(a,b,c){return"number"===typeof b?this.wa(null,b,c):c};
g.Fb=function(a,b,c){a=0;for(var d=c;;)if(a<this.j){var e=Ee(this,a);c=e.length;a:for(var f=0;;)if(f<c){var h=f+a,k=e[f];d=b.f?b.f(d,h,k):b.call(null,d,h,k);if(Ic(d)){e=d;break a}f+=1}else{e=d;break a}if(Ic(e))return Cb(e);a+=c;d=e}else return d};g.K=function(a,b){return Fe(this,b)[b&31]};g.wa=function(a,b,c){return 0<=b&&b<this.j?Ee(this,b)[b&31]:c};
g.Qb=function(a,b){if(0<=a&&a<this.j){if(Be(this)<=a){var c=gb(this.I);c[a&31]=b;return new ge(this.l,this.j,this.shift,this.root,c,null)}return new ge(this.l,this.j,this.shift,Ge(this,this.shift,this.root,a,b),this.I,null)}if(a===this.j)return this.X(null,b);throw Error(["Index ",J.a(a)," out of bounds  [0,",J.a(this.j),"]"].join(""));};g.Da=function(){var a=this.j;return new He(0<W(this)?Ee(this,0):null,this,a)};g.N=function(){return this.l};g.Y=function(){return this.j};
g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};g.O=function(a,b){if(b instanceof ge)if(this.j===W(b))for(a=this.Da(null),b=b.Da(null);;)if(a.ba()){var c=a.next(),d=b.next();if(!zc.b(c,d))return!1}else return!0;else return!1;else return Tc(this,b)};g.cb=function(){return new Le(this.j,this.shift,Me.a?Me.a(this.root):Me.call(null,this.root),Ne.a?Ne.a(this.I):Ne.call(null,this.I))};g.V=function(){return Fb(Xc,this.l)};g.sa=function(a,b){return Ie(this,b,0,this.j)};
g.ta=function(a,b,c){a=0;for(var d=c;;)if(a<this.j){var e=Ee(this,a);c=e.length;a:for(var f=0;;)if(f<c){var h=e[f];d=b.b?b.b(d,h):b.call(null,d,h);if(Ic(d)){e=d;break a}f+=1}else{e=d;break a}if(Ic(e))return Cb(e);a+=c;d=e}else return d};g.Sa=function(a,b,c){if("number"===typeof b)return this.Qb(b,c);throw Error("Vector's key for assoc must be a number.");};
g.U=function(){if(0===this.j)return null;if(32>=this.j)return new wc(this.I,0,null);a:{var a=this.root;for(var b=this.shift;;)if(0<b)b-=5,a=a.c[0];else{a=a.c;break a}}return Oe?Oe(this,a,0,0):Pe.call(null,this,a,0,0)};g.S=function(a,b){return b===this.l?this:new ge(b,this.j,this.shift,this.root,this.I,this.s)};
g.X=function(a,b){if(32>this.j-Be(this)){a=this.I.length;for(var c=Array(a+1),d=0;;)if(d<a)c[d]=this.I[d],d+=1;else break;c[a]=b;return new ge(this.l,this.j+1,this.shift,this.root,c,null)}a=(c=this.j>>>5>1<<this.shift)?this.shift+5:this.shift;c?(c=Ae(null),c.c[0]=this.root,d=Ce(null,this.shift,new ze(null,this.I)),c.c[1]=d):c=De(this,this.shift,this.root,new ze(null,this.I));return new ge(this.l,this.j+1,a,c,[b],null)};
g.call=function(){var a=null;a=function(b,c,d){switch(arguments.length){case 2:return this.K(null,c);case 3:return this.wa(null,c,d)}throw Error("Invalid arity: "+(arguments.length-1));};a.b=function(b,c){return this.K(null,c)};a.f=function(b,c,d){return this.wa(null,c,d)};return a}();g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return this.K(null,a)};g.b=function(a,b){return this.wa(null,a,b)};
var he=new ze(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]),Xc=new ge(null,0,5,he,[],Ec);ge.prototype[fb]=function(){return Bc(this)};
function Qe(a){if(H(Re.a?Re.a(a):Re.call(null,a)))a=new ge(null,2,5,he,[Se.a?Se.a(a):Se.call(null,a),Te.a?Te.a(a):Te.call(null,a)],null);else if(jd(a))a=dd(a,null);else if(Array.isArray(a))a:{var b=a.length;if(32>b)a=new ge(null,b,5,he,a,null);else for(var c=32,d=(new ge(null,32,5,he,a.slice(0,32),null)).cb(null);;)if(c<b){var e=c+1;d=Ud.b(d,a[c]);c=e}else{a=Wb(d);break a}}else a=Wb(qd(Vb,Ub(Xc),a));return a}
function Ue(a,b,c,d,e){this.ya=a;this.node=b;this.m=c;this.ca=d;this.l=e;this.s=null;this.i=32375020;this.w=1536}g=Ue.prototype;g.toString=function(){return hc(this)};g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.l};g.aa=function(){if(this.ca+1<this.node.length){var a=this.ya;var b=this.node,c=this.m,d=this.ca+1;a=Oe?Oe(a,b,c,d):Pe.call(null,a,b,c,d);return null==a?null:a}return this.$b()};
g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};g.O=function(a,b){return Tc(this,b)};g.V=function(){return yc};g.sa=function(a,b){return Ie(this.ya,b,this.m+this.ca,W(this.ya))};g.ta=function(a,b,c){return Je(this.ya,b,c,this.m+this.ca,W(this.ya))};g.ra=function(){return this.node[this.ca]};g.ua=function(){if(this.ca+1<this.node.length){var a=this.ya;var b=this.node,c=this.m,d=this.ca+1;a=Oe?Oe(a,b,c,d):Pe.call(null,a,b,c,d);return null==a?yc:a}return this.Db(null)};g.U=function(){return this};
g.Ob=function(){var a=this.node;return new Md(a,this.ca,a.length)};g.Db=function(){var a=this.m+this.node.length;if(a<ib(this.ya)){var b=this.ya,c=Ee(this.ya,a);return Oe?Oe(b,c,a,0):Pe.call(null,b,c,a,0)}return yc};g.S=function(a,b){return b===this.l?this:Ve?Ve(this.ya,this.node,this.m,this.ca,b):Pe.call(null,this.ya,this.node,this.m,this.ca,b)};g.X=function(a,b){return Uc(b,this)};
g.$b=function(){var a=this.m+this.node.length;if(a<ib(this.ya)){var b=this.ya,c=Ee(this.ya,a);return Oe?Oe(b,c,a,0):Pe.call(null,b,c,a,0)}return null};Ue.prototype[fb]=function(){return Bc(this)};
function Pe(a){switch(arguments.length){case 3:var b=arguments[0],c=arguments[1],d=arguments[2];return new Ue(b,Fe(b,c),c,d,null);case 4:return Oe(arguments[0],arguments[1],arguments[2],arguments[3]);case 5:return Ve(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}}function Oe(a,b,c,d){return new Ue(a,b,c,d,null)}function Ve(a,b,c,d,e){return new Ue(a,b,c,d,e)}
function We(a,b){return a===b.J?b:new ze(a,gb(b.c))}function Me(a){return new ze({},gb(a.c))}function Ne(a){var b=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];ld(a,0,b,0,a.length);return b}var Xe=function Xe(a,b,c,d){c=We(a.root.J,c);var f=a.j-1>>>b&31;if(5===b)a=d;else{var h=c.c[f];null!=h?(b-=5,a=Xe.A?Xe.A(a,b,h,d):Xe.call(null,a,b,h,d)):a=Ce(a.root.J,b-5,d)}c.c[f]=a;return c};
function Le(a,b,c,d){this.j=a;this.shift=b;this.root=c;this.I=d;this.w=88;this.i=275}g=Le.prototype;
g.fb=function(a,b){if(this.root.J){if(32>this.j-Be(this))this.I[this.j&31]=b;else{a=new ze(this.root.J,this.I);var c=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];c[0]=b;this.I=c;this.j>>>5>1<<this.shift?(b=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null],c=this.shift+5,b[0]=
this.root,b[1]=Ce(this.root.J,this.shift,a),this.root=new ze(this.root.J,b),this.shift=c):this.root=Xe(this,this.shift,this.root,a)}this.j+=1;return this}throw Error("conj! after persistent!");};g.qb=function(){if(this.root.J){this.root.J=null;var a=this.j-Be(this),b=Array(a);ld(this.I,0,b,0,a);return new ge(null,this.j,this.shift,this.root,b,null)}throw Error("persistent! called twice");};
g.eb=function(a,b,c){if("number"===typeof b)return Ye(this,b,c);throw Error("TransientVector's key for assoc! must be a number.");};
function Ye(a,b,c){if(a.root.J){if(0<=b&&b<a.j){if(Be(a)<=b)a.I[b&31]=c;else{var d=function(){return function k(f,h){h=We(a.root.J,h);if(0===f)h.c[b&31]=c;else{var l=b>>>f&31;f=k(f-5,h.c[l]);h.c[l]=f}return h}(a.shift,a.root)}();a.root=d}return a}if(b===a.j)return a.fb(null,c);throw Error(["Index ",J.a(b)," out of bounds for TransientVector of length",J.a(a.j)].join(""));}throw Error("assoc! after persistent!");}g.Y=function(){if(this.root.J)return this.j;throw Error("count after persistent!");};
g.K=function(a,b){if(this.root.J)return Fe(this,b)[b&31];throw Error("nth after persistent!");};g.wa=function(a,b,c){return 0<=b&&b<this.j?this.K(null,b):c};g.T=function(a,b){return this.C(null,b,null)};g.C=function(a,b,c){if(this.root.J)return"number"===typeof b?this.wa(null,b,c):c;throw Error("lookup after persistent!");};
g.call=function(){var a=null;a=function(b,c,d){switch(arguments.length){case 2:return this.T(null,c);case 3:return this.C(null,c,d)}throw Error("Invalid arity: "+(arguments.length-1));};a.b=function(b,c){return this.T(null,c)};a.f=function(b,c,d){return this.C(null,c,d)};return a}();g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return this.T(null,a)};g.b=function(a,b){return this.C(null,a,b)};function Ze(a,b){this.hb=a;this.Ab=b}
Ze.prototype.ba=function(){var a=null!=this.hb&&O(this.hb);return a?a:null!=this.Ab?this.Ab.ba():!1};Ze.prototype.next=function(){if(null!=this.hb){var a=R(this.hb);this.hb=U(this.hb);return a}if(null!=this.Ab&&this.Ab.ba())return this.Ab.next();throw Error("No such element");};Ze.prototype.remove=function(){return Error("Unsupported operation")};function $e(a,b,c,d){this.l=a;this.Ba=b;this.Ea=c;this.s=d;this.i=31850700;this.w=0}g=$e.prototype;g.toString=function(){return hc(this)};
g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.l};g.aa=function(){var a=U(this.Ba);return a?new $e(this.l,a,this.Ea,null):null!=this.Ea?new $e(this.l,this.Ea,null,null):null};g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};
g.O=function(a,b){return Tc(this,b)};g.V=function(){return Fb(yc,this.l)};g.ra=function(){return R(this.Ba)};g.ua=function(){var a=U(this.Ba);return a?new $e(this.l,a,this.Ea,null):null==this.Ea?this.V(null):new $e(this.l,this.Ea,null,null)};g.U=function(){return this};g.S=function(a,b){return b===this.l?this:new $e(b,this.Ba,this.Ea,this.s)};g.X=function(a,b){return Uc(b,this)};$e.prototype[fb]=function(){return Bc(this)};
function af(a,b,c,d,e){this.l=a;this.count=b;this.Ba=c;this.Ea=d;this.s=e;this.w=139264;this.i=31858766}g=af.prototype;g.toString=function(){return hc(this)};g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,this.count.a?this.count.a(this):this.count.call(null,this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.Da=function(){return new Ze(this.Ba,fc(this.Ea))};g.N=function(){return this.l};g.Y=function(){return this.count};
g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};g.O=function(a,b){return Tc(this,b)};g.V=function(){return Fb(bf,this.l)};g.ra=function(){return R(this.Ba)};g.ua=function(){return xc(O(this))};g.U=function(){var a=O(this.Ea),b=this.Ba;return H(H(b)?b:a)?new $e(null,this.Ba,O(a),null):null};g.S=function(a,b){return b===this.l?this:new af(b,this.count,this.Ba,this.Ea,this.s)};
g.X=function(a,b){H(this.Ba)?(a=this.Ea,b=new af(this.l,this.count+1,this.Ba,Wc.b(H(a)?a:Xc,b),null)):b=new af(this.l,this.count+1,Wc.b(this.Ba,b),Xc,null);return b};var bf=new af(null,0,null,Xc,Ec);af.prototype[fb]=function(){return Bc(this)};function cf(){this.i=2097152;this.w=0}cf.prototype.O=function(){return!1};var df=new cf;
function ef(a,b){return nd(hd(b)&&!id(b)?W(a)===W(b)?(null!=a?a.i&1048576||v===a.$c||(a.i?0:cb(Ib,a)):cb(Ib,a))?wd(function(c,d,e){return zc.b(tc.f(b,d,df),e)?!0:new Hc},a):ke(function(c){return zc.b(tc.f(b,R(c),df),R(U(c)))},a):null:null)}function ff(a){this.B=a}ff.prototype.next=function(){if(null!=this.B){var a=R(this.B),b=X(a,0,null);a=X(a,1,null);this.B=U(this.B);return{value:[b,a],done:!1}}return{value:null,done:!0}};function gf(a){this.B=a}
gf.prototype.next=function(){if(null!=this.B){var a=R(this.B);this.B=U(this.B);return{value:[a,a],done:!1}}return{value:null,done:!0}};
function hf(a,b){if(b instanceof M)a:{var c=a.length;b=b.Ma;for(var d=0;;){if(c<=d){a=-1;break a}if(a[d]instanceof M&&b===a[d].Ma){a=d;break a}d+=2}}else if("string"==typeof b||"number"===typeof b)a:for(c=a.length,d=0;;){if(c<=d){a=-1;break a}if(b===a[d]){a=d;break a}d+=2}else if(b instanceof sc)a:for(c=a.length,b=b.Va,d=0;;){if(c<=d){a=-1;break a}if(a[d]instanceof sc&&b===a[d].Va){a=d;break a}d+=2}else if(null==b)a:for(b=a.length,c=0;;){if(b<=c){a=-1;break a}if(null==a[c]){a=c;break a}c+=2}else a:for(c=
a.length,d=0;;){if(c<=d){a=-1;break a}if(zc.b(b,a[d])){a=d;break a}d+=2}return a}function Ke(a,b){this.key=a;this.v=b;this.s=null;this.i=166619935;this.w=0}g=Ke.prototype;g.lb=function(a,b){switch(b){case 0:return new Ke(0,this.key);case 1:return new Ke(1,this.v);default:return null}};
g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.T=function(a,b){return this.wa(null,b,null)};g.C=function(a,b,c){return this.wa(null,b,c)};g.K=function(a,b){if(0===b)return this.key;if(1===b)return this.v;throw Error("Index out of bounds");};
g.wa=function(a,b,c){return 0===b?this.key:1===b?this.v:c};g.Qb=function(a,b){return(new ge(null,2,5,he,[this.key,this.v],null)).Qb(a,b)};g.N=function(){return null};g.Y=function(){return 2};g.vc=function(){return this.key};g.wc=function(){return this.v};g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};g.O=function(a,b){return Tc(this,b)};g.V=function(){return null};
g.sa=function(a,b){a:if(a=this.Y(null),0===a)b=b.u?b.u():b.call(null);else for(var c=this.K(null,0),d=1;;)if(d<a){var e=this.K(null,d);c=b.b?b.b(c,e):b.call(null,c,e);if(Ic(c)){b=Cb(c);break a}d+=1}else{b=c;break a}return b};g.ta=function(a,b,c){a:{a=this.Y(null);var d=c;for(c=0;;)if(c<a){var e=this.K(null,c);d=b.b?b.b(d,e):b.call(null,d,e);if(Ic(d)){b=Cb(d);break a}c+=1}else{b=d;break a}}return b};g.Sa=function(a,b,c){return $c.f(new ge(null,2,5,he,[this.key,this.v],null),b,c)};
g.U=function(){return new wc([this.key,this.v],0,null)};g.S=function(a,b){return dd(new ge(null,2,5,he,[this.key,this.v],null),b)};g.X=function(a,b){return new ge(null,3,5,he,[this.key,this.v,b],null)};g.call=function(){var a=null;a=function(b,c,d){switch(arguments.length){case 2:return this.K(null,c);case 3:return this.wa(null,c,d)}throw Error("Invalid arity: "+(arguments.length-1));};a.b=function(b,c){return this.K(null,c)};a.f=function(b,c,d){return this.wa(null,c,d)};return a}();
g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return this.K(null,a)};g.b=function(a,b){return this.wa(null,a,b)};function Re(a){return null!=a?a.i&2048||v===a.cd?!0:!1:!1}function jf(a,b,c){this.c=a;this.m=b;this.La=c;this.i=32374990;this.w=0}g=jf.prototype;g.toString=function(){return hc(this)};
g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.La};g.aa=function(){return this.m<this.c.length-2?new jf(this.c,this.m+2,null):null};g.Y=function(){return(this.c.length-this.m)/2};g.P=function(){return Cc(this)};
g.O=function(a,b){return Tc(this,b)};g.V=function(){return yc};g.sa=function(a,b){return pd(b,this)};g.ta=function(a,b,c){return sd(b,c,this)};g.ra=function(){return new Ke(this.c[this.m],this.c[this.m+1])};g.ua=function(){return this.m<this.c.length-2?new jf(this.c,this.m+2,null):yc};g.U=function(){return this};g.S=function(a,b){return b===this.La?this:new jf(this.c,this.m,b)};g.X=function(a,b){return Uc(b,this)};jf.prototype[fb]=function(){return Bc(this)};
function kf(a,b){this.c=a;this.m=0;this.j=b}kf.prototype.ba=function(){return this.m<this.j};kf.prototype.next=function(){var a=new Ke(this.c[this.m],this.c[this.m+1]);this.m+=2;return a};function Ua(a,b,c,d){this.l=a;this.j=b;this.c=c;this.s=d;this.i=16647951;this.w=139268}g=Ua.prototype;g.lb=function(a,b){a=hf(this.c,b);return-1===a?null:new Ke(this.c[a],this.c[a+1])};g.toString=function(){return hc(this)};g.keys=function(){return Bc(lf.a?lf.a(this):lf.call(null,this))};g.entries=function(){return new ff(O(O(this)))};
g.values=function(){return Bc(mf.a?mf.a(this):mf.call(null,this))};g.has=function(a){return od(this,a)};g.get=function(a,b){return this.C(null,a,b)};g.forEach=function(a){for(var b=O(this),c=null,d=0,e=0;;)if(e<d){var f=c.K(null,e),h=X(f,0,null);f=X(f,1,null);a.b?a.b(f,h):a.call(null,f,h);e+=1}else if(b=O(b))kd(b)?(c=Zb(b),b=$b(b),h=c,d=W(c),c=h):(c=R(b),h=X(c,0,null),f=X(c,1,null),a.b?a.b(f,h):a.call(null,f,h),b=U(b),c=null,d=0),e=0;else return null};g.T=function(a,b){return this.C(null,b,null)};
g.C=function(a,b,c){a=hf(this.c,b);return-1===a?c:this.c[a+1]};g.Fb=function(a,b,c){a=this.c.length;for(var d=0;;)if(d<a){var e=this.c[d],f=this.c[d+1];c=b.f?b.f(c,e,f):b.call(null,c,e,f);if(Ic(c))return Cb(c);d+=2}else return c};g.Da=function(){return new kf(this.c,2*this.j)};g.N=function(){return this.l};g.Y=function(){return this.j};g.P=function(){var a=this.s;return null!=a?a:this.s=a=Fc(this)};
g.O=function(a,b){if(hd(b)&&!id(b))if(a=this.c.length,this.j===b.Y(null))for(var c=0;;)if(c<a){var d=b.C(null,this.c[c],md);if(d!==md)if(zc.b(this.c[c+1],d))c+=2;else return!1;else return!1}else return!0;else return!1;else return!1};g.cb=function(){return new nf(this.c.length,gb(this.c))};g.V=function(){return Fb(je,this.l)};g.sa=function(a,b){return td(this,b)};g.ta=function(a,b,c){return ud(this,b,c)};
g.Sa=function(a,b,c){a=hf(this.c,b);if(-1===a){if(this.j<of){a=this.c;for(var d=a.length,e=Array(d+2),f=0;;)if(f<d)e[f]=a[f],f+=1;else break;e[d]=b;e[d+1]=c;return new Ua(this.l,this.j+1,e,null)}return Fb(vb(ye(pf,this),b,c),this.l)}if(c===this.c[a+1])return this;b=gb(this.c);b[a+1]=c;return new Ua(this.l,this.j,b,null)};g.U=function(){var a=this.c;return 0<=a.length-2?new jf(a,0,null):null};g.S=function(a,b){return b===this.l?this:new Ua(b,this.j,this.c,this.s)};
g.X=function(a,b){if(jd(b))return this.Sa(null,ob.b(b,0),ob.b(b,1));a=this;for(b=O(b);;){if(null==b)return a;var c=R(b);if(jd(c))a=vb(a,ob.b(c,0),ob.b(c,1)),b=U(b);else throw Error("conj on a map takes map entries or seqables of map entries");}};
g.call=function(){var a=null;a=function(b,c,d){switch(arguments.length){case 2:return this.T(null,c);case 3:return this.C(null,c,d)}throw Error("Invalid arity: "+(arguments.length-1));};a.b=function(b,c){return this.T(null,c)};a.f=function(b,c,d){return this.C(null,c,d)};return a}();g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return this.T(null,a)};g.b=function(a,b){return this.C(null,a,b)};var je=new Ua(null,0,[],Gc),of=8;
function ad(a){for(var b=[],c=0;;)if(c<a.length){var d=a[c],e=a[c+1],f=hf(b,d);-1===f?(f=b,f.push(d),f.push(e)):b[f+1]=e;c+=2}else break;return new Ua(null,b.length/2,b,null)}Ua.prototype[fb]=function(){return Bc(this)};function nf(a,b){this.gb={};this.ab=a;this.c=b;this.i=259;this.w=56}g=nf.prototype;g.Y=function(){if(this.gb)return zd(this.ab);throw Error("count after persistent!");};g.T=function(a,b){return this.C(null,b,null)};
g.C=function(a,b,c){if(this.gb)return a=hf(this.c,b),-1===a?c:this.c[a+1];throw Error("lookup after persistent!");};g.fb=function(a,b){if(this.gb){if(Re(b))return this.eb(null,Se.a?Se.a(b):Se.call(null,b),Te.a?Te.a(b):Te.call(null,b));if(jd(b))return this.eb(null,b.a?b.a(0):b.call(null,0),b.a?b.a(1):b.call(null,1));a=O(b);for(b=this;;){var c=R(a);if(H(c))a=U(a),b=Xb(b,Se.a?Se.a(c):Se.call(null,c),Te.a?Te.a(c):Te.call(null,c));else return b}}else throw Error("conj! after persistent!");};
g.qb=function(){if(this.gb)return this.gb=!1,new Ua(null,zd(this.ab),this.c,null);throw Error("persistent! called twice");};g.eb=function(a,b,c){if(this.gb){a=hf(this.c,b);if(-1===a)return this.ab+2<=2*of?(this.ab+=2,this.c.push(b),this.c.push(c),this):Vd(qf.b?qf.b(this.ab,this.c):qf.call(null,this.ab,this.c),b,c);c!==this.c[a+1]&&(this.c[a+1]=c);return this}throw Error("assoc! after persistent!");};
g.call=function(){var a=null;a=function(b,c,d){switch(arguments.length){case 2:return this.C(null,c,null);case 3:return this.C(null,c,d)}throw Error("Invalid arity: "+(arguments.length-1));};a.b=function(b,c){return this.C(null,c,null)};a.f=function(b,c,d){return this.C(null,c,d)};return a}();g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return this.C(null,a,null)};g.b=function(a,b){return this.C(null,a,b)};
function qf(a,b){for(var c=Ub(pf),d=0;;)if(d<a)c=Xb(c,b[d],b[d+1]),d+=2;else return c}function rf(){this.v=!1}function sf(a,b){return a===b?!0:Fd(a,b)?!0:zc.b(a,b)}function tf(a,b,c){a=gb(a);a[b]=c;return a}function uf(a,b,c,d){a=a.Za(b);a.c[c]=d;return a}function vf(a,b,c){for(var d=a.length,e=0,f=c;;)if(e<d){c=a[e];if(null!=c){var h=a[e+1];c=b.f?b.f(f,c,h):b.call(null,f,c,h)}else c=a[e+1],c=null!=c?c.yb(b,f):f;if(Ic(c))return c;e+=2;f=c}else return f}
function wf(a){this.c=a;this.m=0;this.Ja=this.zb=null}wf.prototype.advance=function(){for(var a=this.c.length;;)if(this.m<a){var b=this.c[this.m],c=this.c[this.m+1];null!=b?b=this.zb=new Ke(b,c):null!=c?(b=fc(c),b=b.ba()?this.Ja=b:!1):b=!1;this.m+=2;if(b)return!0}else return!1};wf.prototype.ba=function(){var a=null!=this.zb;return a?a:(a=null!=this.Ja)?a:this.advance()};
wf.prototype.next=function(){if(null!=this.zb){var a=this.zb;this.zb=null;return a}if(null!=this.Ja)return a=this.Ja.next(),this.Ja.ba()||(this.Ja=null),a;if(this.advance())return this.next();throw Error("No such element");};wf.prototype.remove=function(){return Error("Unsupported operation")};function xf(a,b,c){this.J=a;this.W=b;this.c=c;this.w=131072;this.i=0}g=xf.prototype;
g.Za=function(a){if(a===this.J)return this;var b=Ad(this.W),c=Array(0>b?4:2*(b+1));ld(this.c,0,c,0,2*b);return new xf(a,this.W,c)};g.xb=function(){return yf?yf(this.c):zf.call(null,this.c)};g.yb=function(a,b){return vf(this.c,a,b)};g.$a=function(a,b,c,d){var e=1<<(b>>>a&31);if(0===(this.W&e))return d;var f=Ad(this.W&e-1);e=this.c[2*f];f=this.c[2*f+1];return null==e?f.$a(a+5,b,c,d):sf(c,e)?f:d};
g.Ha=function(a,b,c,d,e,f){var h=1<<(c>>>b&31),k=Ad(this.W&h-1);if(0===(this.W&h)){var l=Ad(this.W);if(2*l<this.c.length){a=this.Za(a);b=a.c;f.v=!0;c=2*(l-k);f=2*k+(c-1);for(l=2*(k+1)+(c-1);0!==c;)b[l]=b[f],--l,--c,--f;b[2*k]=d;b[2*k+1]=e;a.W|=h;return a}if(16<=l){k=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];k[c>>>b&31]=Af.Ha(a,b+5,c,d,e,f);for(e=d=0;;)if(32>d)0===(this.W>>>d&1)?
d+=1:(k[d]=null!=this.c[e]?Af.Ha(a,b+5,qc(this.c[e]),this.c[e],this.c[e+1],f):this.c[e+1],e+=2,d+=1);else break;return new Bf(a,l+1,k)}b=Array(2*(l+4));ld(this.c,0,b,0,2*k);b[2*k]=d;b[2*k+1]=e;ld(this.c,2*k,b,2*(k+1),2*(l-k));f.v=!0;a=this.Za(a);a.c=b;a.W|=h;return a}l=this.c[2*k];h=this.c[2*k+1];if(null==l)return l=h.Ha(a,b+5,c,d,e,f),l===h?this:uf(this,a,2*k+1,l);if(sf(d,l))return e===h?this:uf(this,a,2*k+1,e);f.v=!0;f=b+5;d=Cf?Cf(a,f,l,h,c,d,e):Df.call(null,a,f,l,h,c,d,e);e=2*k;k=2*k+1;a=this.Za(a);
a.c[e]=null;a.c[k]=d;return a};
g.Ga=function(a,b,c,d,e){var f=1<<(b>>>a&31),h=Ad(this.W&f-1);if(0===(this.W&f)){var k=Ad(this.W);if(16<=k){h=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];h[b>>>a&31]=Af.Ga(a+5,b,c,d,e);for(d=c=0;;)if(32>c)0===(this.W>>>c&1)?c+=1:(h[c]=null!=this.c[d]?Af.Ga(a+5,qc(this.c[d]),this.c[d],this.c[d+1],e):this.c[d+1],d+=2,c+=1);else break;return new Bf(null,k+1,h)}a=Array(2*(k+1));ld(this.c,
0,a,0,2*h);a[2*h]=c;a[2*h+1]=d;ld(this.c,2*h,a,2*(h+1),2*(k-h));e.v=!0;return new xf(null,this.W|f,a)}var l=this.c[2*h];f=this.c[2*h+1];if(null==l)return k=f.Ga(a+5,b,c,d,e),k===f?this:new xf(null,this.W,tf(this.c,2*h+1,k));if(sf(c,l))return d===f?this:new xf(null,this.W,tf(this.c,2*h+1,d));e.v=!0;e=this.W;k=this.c;a+=5;a=Ef?Ef(a,l,f,b,c,d):Df.call(null,a,l,f,b,c,d);c=2*h;h=2*h+1;d=gb(k);d[c]=null;d[h]=a;return new xf(null,e,d)};
g.wb=function(a,b,c,d){var e=1<<(b>>>a&31);if(0===(this.W&e))return d;var f=Ad(this.W&e-1);e=this.c[2*f];f=this.c[2*f+1];return null==e?f.wb(a+5,b,c,d):sf(c,e)?new Ke(e,f):d};g.Da=function(){return new wf(this.c)};var Af=new xf(null,0,[]);function Ff(a){this.c=a;this.m=0;this.Ja=null}Ff.prototype.ba=function(){for(var a=this.c.length;;){if(null!=this.Ja&&this.Ja.ba())return!0;if(this.m<a){var b=this.c[this.m];this.m+=1;null!=b&&(this.Ja=fc(b))}else return!1}};
Ff.prototype.next=function(){if(this.ba())return this.Ja.next();throw Error("No such element");};Ff.prototype.remove=function(){return Error("Unsupported operation")};function Bf(a,b,c){this.J=a;this.j=b;this.c=c;this.w=131072;this.i=0}g=Bf.prototype;g.Za=function(a){return a===this.J?this:new Bf(a,this.j,gb(this.c))};g.xb=function(){return Gf?Gf(this.c):Hf.call(null,this.c)};
g.yb=function(a,b){for(var c=this.c.length,d=0;;)if(d<c){var e=this.c[d];if(null!=e){b=e.yb(a,b);if(Ic(b))return b;d+=1}else d+=1}else return b};g.$a=function(a,b,c,d){var e=this.c[b>>>a&31];return null!=e?e.$a(a+5,b,c,d):d};g.Ha=function(a,b,c,d,e,f){var h=c>>>b&31,k=this.c[h];if(null==k)return a=uf(this,a,h,Af.Ha(a,b+5,c,d,e,f)),a.j+=1,a;b=k.Ha(a,b+5,c,d,e,f);return b===k?this:uf(this,a,h,b)};
g.Ga=function(a,b,c,d,e){var f=b>>>a&31,h=this.c[f];if(null==h)return new Bf(null,this.j+1,tf(this.c,f,Af.Ga(a+5,b,c,d,e)));a=h.Ga(a+5,b,c,d,e);return a===h?this:new Bf(null,this.j,tf(this.c,f,a))};g.wb=function(a,b,c,d){var e=this.c[b>>>a&31];return null!=e?e.wb(a+5,b,c,d):d};g.Da=function(){return new Ff(this.c)};function If(a,b,c){b*=2;for(var d=0;;)if(d<b){if(sf(c,a[d]))return d;d+=2}else return-1}function Jf(a,b,c,d){this.J=a;this.Ta=b;this.j=c;this.c=d;this.w=131072;this.i=0}g=Jf.prototype;
g.Za=function(a){if(a===this.J)return this;var b=Array(2*(this.j+1));ld(this.c,0,b,0,2*this.j);return new Jf(a,this.Ta,this.j,b)};g.xb=function(){return yf?yf(this.c):zf.call(null,this.c)};g.yb=function(a,b){return vf(this.c,a,b)};g.$a=function(a,b,c,d){a=If(this.c,this.j,c);return 0>a?d:sf(c,this.c[a])?this.c[a+1]:d};
g.Ha=function(a,b,c,d,e,f){if(c===this.Ta){b=If(this.c,this.j,d);if(-1===b){if(this.c.length>2*this.j)return b=2*this.j,c=2*this.j+1,a=this.Za(a),a.c[b]=d,a.c[c]=e,f.v=!0,a.j+=1,a;c=this.c.length;b=Array(c+2);ld(this.c,0,b,0,c);b[c]=d;b[c+1]=e;f.v=!0;d=this.j+1;a===this.J?(this.c=b,this.j=d,a=this):a=new Jf(this.J,this.Ta,d,b);return a}return this.c[b+1]===e?this:uf(this,a,b+1,e)}return(new xf(a,1<<(this.Ta>>>b&31),[null,this,null,null])).Ha(a,b,c,d,e,f)};
g.Ga=function(a,b,c,d,e){return b===this.Ta?(a=If(this.c,this.j,c),-1===a?(a=2*this.j,b=Array(a+2),ld(this.c,0,b,0,a),b[a]=c,b[a+1]=d,e.v=!0,new Jf(null,this.Ta,this.j+1,b)):zc.b(this.c[a+1],d)?this:new Jf(null,this.Ta,this.j,tf(this.c,a+1,d))):(new xf(null,1<<(this.Ta>>>a&31),[null,this])).Ga(a,b,c,d,e)};g.wb=function(a,b,c,d){a=If(this.c,this.j,c);return 0>a?d:sf(c,this.c[a])?new Ke(this.c[a],this.c[a+1]):d};g.Da=function(){return new wf(this.c)};
function Df(a){switch(arguments.length){case 6:return Ef(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5]);case 7:return Cf(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}}function Ef(a,b,c,d,e,f){var h=qc(b);if(h===d)return new Jf(null,h,2,[b,c,e,f]);var k=new rf;return Af.Ga(a,h,b,c,k).Ga(a,d,e,f,k)}
function Cf(a,b,c,d,e,f,h){var k=qc(c);if(k===e)return new Jf(null,k,2,[c,d,f,h]);var l=new rf;return Af.Ha(a,b,k,c,d,l).Ha(a,b,e,f,h,l)}function Kf(a,b,c,d,e){this.l=a;this.Ka=b;this.m=c;this.B=d;this.s=e;this.i=32374988;this.w=0}g=Kf.prototype;g.toString=function(){return hc(this)};
g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.l};g.aa=function(){if(null==this.B){var a=this.Ka,b=this.m+2;return Lf?Lf(a,b,null):zf.call(null,a,b,null)}a=this.Ka;b=this.m;var c=U(this.B);return Lf?Lf(a,b,c):zf.call(null,a,b,c)};
g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};g.O=function(a,b){return Tc(this,b)};g.V=function(){return yc};g.sa=function(a,b){return pd(b,this)};g.ta=function(a,b,c){return sd(b,c,this)};g.ra=function(){return null==this.B?new Ke(this.Ka[this.m],this.Ka[this.m+1]):R(this.B)};
g.ua=function(){var a=this,b=null==a.B?function(){var c=a.Ka,d=a.m+2;return Lf?Lf(c,d,null):zf.call(null,c,d,null)}():function(){var c=a.Ka,d=a.m,e=U(a.B);return Lf?Lf(c,d,e):zf.call(null,c,d,e)}();return null!=b?b:yc};g.U=function(){return this};g.S=function(a,b){return b===this.l?this:new Kf(b,this.Ka,this.m,this.B,this.s)};g.X=function(a,b){return Uc(b,this)};Kf.prototype[fb]=function(){return Bc(this)};
function zf(a){switch(arguments.length){case 1:return yf(arguments[0]);case 3:return Lf(arguments[0],arguments[1],arguments[2]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}}function yf(a){return Lf(a,0,null)}function Lf(a,b,c){if(null==c)for(c=a.length;;)if(b<c){if(null!=a[b])return new Kf(null,a,b,null,null);var d=a[b+1];if(H(d)&&(d=d.xb(),H(d)))return new Kf(null,a,b+2,d,null);b+=2}else return null;else return new Kf(null,a,b,c,null)}
function Mf(a,b,c,d,e){this.l=a;this.Ka=b;this.m=c;this.B=d;this.s=e;this.i=32374988;this.w=0}g=Mf.prototype;g.toString=function(){return hc(this)};g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.l};g.aa=function(){var a=this.Ka,b=this.m,c=U(this.B);return Nf?Nf(a,b,c):Hf.call(null,a,b,c)};g.P=function(){var a=this.s;return null!=a?a:this.s=a=Cc(this)};g.O=function(a,b){return Tc(this,b)};
g.V=function(){return yc};g.sa=function(a,b){return pd(b,this)};g.ta=function(a,b,c){return sd(b,c,this)};g.ra=function(){return R(this.B)};g.ua=function(){var a=this.Ka;var b=this.m,c=U(this.B);a=Nf?Nf(a,b,c):Hf.call(null,a,b,c);return null!=a?a:yc};g.U=function(){return this};g.S=function(a,b){return b===this.l?this:new Mf(b,this.Ka,this.m,this.B,this.s)};g.X=function(a,b){return Uc(b,this)};Mf.prototype[fb]=function(){return Bc(this)};
function Hf(a){switch(arguments.length){case 1:return Gf(arguments[0]);case 3:return Nf(arguments[0],arguments[1],arguments[2]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}}function Gf(a){return Nf(a,0,null)}function Nf(a,b,c){if(null==c)for(c=a.length;;)if(b<c){var d=a[b];if(H(d)&&(d=d.xb(),H(d)))return new Mf(null,a,b+1,d,null);b+=1}else return null;else return new Mf(null,a,b,c,null)}function Of(a,b){this.va=a;this.kc=b;this.Vb=!1}
Of.prototype.ba=function(){return!this.Vb||this.kc.ba()};Of.prototype.next=function(){if(this.Vb)return this.kc.next();this.Vb=!0;return new Ke(null,this.va)};Of.prototype.remove=function(){return Error("Unsupported operation")};function Pf(a,b,c,d,e,f){this.l=a;this.j=b;this.root=c;this.xa=d;this.va=e;this.s=f;this.i=16123663;this.w=139268}g=Pf.prototype;g.lb=function(a,b){return null==b?this.xa?new Ke(null,this.va):null:null==this.root?null:this.root.wb(0,qc(b),b,null)};g.toString=function(){return hc(this)};
g.keys=function(){return Bc(lf.a?lf.a(this):lf.call(null,this))};g.entries=function(){return new ff(O(O(this)))};g.values=function(){return Bc(mf.a?mf.a(this):mf.call(null,this))};g.has=function(a){return od(this,a)};g.get=function(a,b){return this.C(null,a,b)};
g.forEach=function(a){for(var b=O(this),c=null,d=0,e=0;;)if(e<d){var f=c.K(null,e),h=X(f,0,null);f=X(f,1,null);a.b?a.b(f,h):a.call(null,f,h);e+=1}else if(b=O(b))kd(b)?(c=Zb(b),b=$b(b),h=c,d=W(c),c=h):(c=R(b),h=X(c,0,null),f=X(c,1,null),a.b?a.b(f,h):a.call(null,f,h),b=U(b),c=null,d=0),e=0;else return null};g.T=function(a,b){return this.C(null,b,null)};g.C=function(a,b,c){return null==b?this.xa?this.va:c:null==this.root?c:this.root.$a(0,qc(b),b,c)};
g.Fb=function(a,b,c){a=this.xa?b.f?b.f(c,null,this.va):b.call(null,c,null,this.va):c;Ic(a)?b=Cb(a):null!=this.root?(b=this.root.yb(b,a),b=Ic(b)?Jc.a?Jc.a(b):Jc.call(null,b):b):b=a;return b};g.Da=function(){var a=this.root?fc(this.root):fe();return this.xa?new Of(this.va,a):a};g.N=function(){return this.l};g.Y=function(){return this.j};g.P=function(){var a=this.s;return null!=a?a:this.s=a=Fc(this)};g.O=function(a,b){return ef(this,b)};g.cb=function(){return new Qf(this.root,this.j,this.xa,this.va)};
g.V=function(){return Fb(pf,this.l)};g.Sa=function(a,b,c){if(null==b)return this.xa&&c===this.va?this:new Pf(this.l,this.xa?this.j:this.j+1,this.root,!0,c,null);a=new rf;b=(null==this.root?Af:this.root).Ga(0,qc(b),b,c,a);return b===this.root?this:new Pf(this.l,a.v?this.j+1:this.j,b,this.xa,this.va,null)};g.U=function(){if(0<this.j){var a=null!=this.root?this.root.xb():null;return this.xa?Uc(new Ke(null,this.va),a):a}return null};
g.S=function(a,b){return b===this.l?this:new Pf(b,this.j,this.root,this.xa,this.va,this.s)};g.X=function(a,b){if(jd(b))return this.Sa(null,ob.b(b,0),ob.b(b,1));a=this;for(b=O(b);;){if(null==b)return a;var c=R(b);if(jd(c))a=vb(a,ob.b(c,0),ob.b(c,1)),b=U(b);else throw Error("conj on a map takes map entries or seqables of map entries");}};
g.call=function(){var a=null;a=function(b,c,d){switch(arguments.length){case 2:return this.T(null,c);case 3:return this.C(null,c,d)}throw Error("Invalid arity: "+(arguments.length-1));};a.b=function(b,c){return this.T(null,c)};a.f=function(b,c,d){return this.C(null,c,d)};return a}();g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return this.T(null,a)};g.b=function(a,b){return this.C(null,a,b)};var pf=new Pf(null,0,null,!1,null,Gc);Pf.prototype[fb]=function(){return Bc(this)};
function Qf(a,b,c,d){this.J={};this.root=a;this.count=b;this.xa=c;this.va=d;this.i=259;this.w=56}function Rf(a,b,c){if(a.J){if(null==b)a.va!==c&&(a.va=c),a.xa||(a.count+=1,a.xa=!0);else{var d=new rf;b=(null==a.root?Af:a.root).Ha(a.J,0,qc(b),b,c,d);b!==a.root&&(a.root=b);d.v&&(a.count+=1)}return a}throw Error("assoc! after persistent!");}g=Qf.prototype;g.Y=function(){if(this.J)return this.count;throw Error("count after persistent!");};
g.T=function(a,b){return null==b?this.xa?this.va:null:null==this.root?null:this.root.$a(0,qc(b),b)};g.C=function(a,b,c){return null==b?this.xa?this.va:c:null==this.root?c:this.root.$a(0,qc(b),b,c)};
g.fb=function(a,b){a:if(this.J)if(Re(b))a=Rf(this,Se.a?Se.a(b):Se.call(null,b),Te.a?Te.a(b):Te.call(null,b));else if(jd(b))a=Rf(this,b.a?b.a(0):b.call(null,0),b.a?b.a(1):b.call(null,1));else for(a=O(b),b=this;;){var c=R(a);if(H(c))a=U(a),b=Rf(b,Se.a?Se.a(c):Se.call(null,c),Te.a?Te.a(c):Te.call(null,c));else{a=b;break a}}else throw Error("conj! after persistent");return a};
g.qb=function(){if(this.J){this.J=null;var a=new Pf(null,this.count,this.root,this.xa,this.va,null)}else throw Error("persistent! called twice");return a};g.eb=function(a,b,c){return Rf(this,b,c)};g.call=function(){var a=null;a=function(b,c,d){switch(arguments.length){case 2:return this.T(null,c);case 3:return this.C(null,c,d)}throw Error("Invalid arity: "+(arguments.length-1));};a.b=function(b,c){return this.T(null,c)};a.f=function(b,c,d){return this.C(null,c,d)};return a}();
g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return this.T(null,a)};g.b=function(a,b){return this.C(null,a,b)};var Sf=function Sf(a){for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return Sf.o(0<c.length?new wc(c.slice(0),0,null):null)};Sf.o=function(a){a=O(a);for(var b=Ub(pf);;)if(a){var c=U(U(a));b=Vd(b,R(a),R(U(a)));a=c}else return Wb(b)};Sf.H=0;Sf.G=function(a){return this.o(O(a))};
function Tf(a,b){this.F=a;this.La=b;this.i=32374988;this.w=0}g=Tf.prototype;g.toString=function(){return hc(this)};g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.La};g.aa=function(){var a=(null!=this.F?this.F.i&128||v===this.F.pb||(this.F.i?0:cb(rb,this.F)):cb(rb,this.F))?this.F.aa(null):U(this.F);return null==a?null:new Tf(a,null)};g.P=function(){return Cc(this)};
g.O=function(a,b){return Tc(this,b)};g.V=function(){return yc};g.sa=function(a,b){return pd(b,this)};g.ta=function(a,b,c){return sd(b,c,this)};g.ra=function(){return this.F.ra(null).key};g.ua=function(){var a=(null!=this.F?this.F.i&128||v===this.F.pb||(this.F.i?0:cb(rb,this.F)):cb(rb,this.F))?this.F.aa(null):U(this.F);return null!=a?new Tf(a,null):yc};g.U=function(){return this};g.S=function(a,b){return b===this.La?this:new Tf(this.F,b)};g.X=function(a,b){return Uc(b,this)};Tf.prototype[fb]=function(){return Bc(this)};
function lf(a){return(a=O(a))?new Tf(a,null):null}function Se(a){return yb(a)}function Uf(a,b){this.F=a;this.La=b;this.i=32374988;this.w=0}g=Uf.prototype;g.toString=function(){return hc(this)};g.indexOf=function(){var a=null;a=function(b,c){switch(arguments.length){case 1:return V(this,b,0);case 2:return V(this,b,c)}throw Error("Invalid arity: "+arguments.length);};a.a=function(b){return V(this,b,0)};a.b=function(b,c){return V(this,b,c)};return a}();
g.lastIndexOf=function(){function a(c){return Rc(this,c,W(this))}var b=null;b=function(c,d){switch(arguments.length){case 1:return a.call(this,c);case 2:return Rc(this,c,d)}throw Error("Invalid arity: "+arguments.length);};b.a=a;b.b=function(c,d){return Rc(this,c,d)};return b}();g.N=function(){return this.La};g.aa=function(){var a=(null!=this.F?this.F.i&128||v===this.F.pb||(this.F.i?0:cb(rb,this.F)):cb(rb,this.F))?this.F.aa(null):U(this.F);return null==a?null:new Uf(a,null)};g.P=function(){return Cc(this)};
g.O=function(a,b){return Tc(this,b)};g.V=function(){return yc};g.sa=function(a,b){return pd(b,this)};g.ta=function(a,b,c){return sd(b,c,this)};g.ra=function(){return this.F.ra(null).v};g.ua=function(){var a=(null!=this.F?this.F.i&128||v===this.F.pb||(this.F.i?0:cb(rb,this.F)):cb(rb,this.F))?this.F.aa(null):U(this.F);return null!=a?new Uf(a,null):yc};g.U=function(){return this};g.S=function(a,b){return b===this.La?this:new Uf(this.F,b)};g.X=function(a,b){return Uc(b,this)};Uf.prototype[fb]=function(){return Bc(this)};
function mf(a){return(a=O(a))?new Uf(a,null):null}function Te(a){return zb(a)}var Vf=function Vf(a){for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return Vf.o(0<c.length?new wc(c.slice(0),0,null):null)};Vf.o=function(a){return H(le(a))?vd(function(b,c){return Wc.b(H(b)?b:je,c)},a):null};Vf.H=0;Vf.G=function(a){return this.o(O(a))};function Wf(a){this.Ub=a}Wf.prototype.ba=function(){return this.Ub.ba()};
Wf.prototype.next=function(){if(this.Ub.ba())return this.Ub.next().key;throw Error("No such element");};Wf.prototype.remove=function(){return Error("Unsupported operation")};function Xf(a,b,c){this.l=a;this.Ua=b;this.s=c;this.i=15077647;this.w=139268}g=Xf.prototype;g.toString=function(){return hc(this)};g.keys=function(){return Bc(O(this))};g.entries=function(){return new gf(O(O(this)))};g.values=function(){return Bc(O(this))};g.has=function(a){return od(this,a)};
g.forEach=function(a){for(var b=O(this),c=null,d=0,e=0;;)if(e<d){var f=c.K(null,e),h=X(f,0,null);f=X(f,1,null);a.b?a.b(f,h):a.call(null,f,h);e+=1}else if(b=O(b))kd(b)?(c=Zb(b),b=$b(b),h=c,d=W(c),c=h):(c=R(b),h=X(c,0,null),f=X(c,1,null),a.b?a.b(f,h):a.call(null,f,h),b=U(b),c=null,d=0),e=0;else return null};g.T=function(a,b){return this.C(null,b,null)};g.C=function(a,b,c){a=wb(this.Ua,b);return H(a)?yb(a):c};g.Da=function(){return new Wf(fc(this.Ua))};g.N=function(){return this.l};g.Y=function(){return ib(this.Ua)};
g.P=function(){var a=this.s;return null!=a?a:this.s=a=Fc(this)};g.O=function(a,b){if(fd(b))if(W(this)===W(b))try{return wd(function(c,d){return(c=od(b,d))?c:new Hc},this.Ua)}catch(c){if(c instanceof Error)return!1;throw c;}else return!1;else return!1};g.cb=function(){return new Yf(Ub(this.Ua))};g.V=function(){return Fb(Zf,this.l)};g.U=function(){return lf(this.Ua)};g.S=function(a,b){return b===this.l?this:new Xf(b,this.Ua,this.s)};g.X=function(a,b){return new Xf(this.l,$c.f(this.Ua,b,null),null)};
g.call=function(){var a=null;a=function(b,c,d){switch(arguments.length){case 2:return this.T(null,c);case 3:return this.C(null,c,d)}throw Error("Invalid arity: "+(arguments.length-1));};a.b=function(b,c){return this.T(null,c)};a.f=function(b,c,d){return this.C(null,c,d)};return a}();g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return this.T(null,a)};g.b=function(a,b){return this.C(null,a,b)};var Zf=new Xf(null,je,Gc);Xf.prototype[fb]=function(){return Bc(this)};
function Yf(a){this.Qa=a;this.w=136;this.i=259}g=Yf.prototype;g.fb=function(a,b){this.Qa=Xb(this.Qa,b,null);return this};g.qb=function(){return new Xf(null,Wb(this.Qa),null)};g.Y=function(){return W(this.Qa)};g.T=function(a,b){return this.C(null,b,null)};g.C=function(a,b,c){return ub.f(this.Qa,b,md)===md?c:b};
g.call=function(){function a(d,e,f){return ub.f(this.Qa,e,md)===md?f:e}function b(d,e){return ub.f(this.Qa,e,md)===md?null:e}var c=null;c=function(d,e,f){switch(arguments.length){case 2:return b.call(this,d,e);case 3:return a.call(this,d,e,f)}throw Error("Invalid arity: "+(arguments.length-1));};c.b=b;c.f=a;return c}();g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};g.a=function(a){return ub.f(this.Qa,a,md)===md?null:a};g.b=function(a,b){return ub.f(this.Qa,a,md)===md?b:a};
function $f(a){if(fd(a))return dd(a,null);a=O(a);if(null==a)return Zf;if(a instanceof wc&&0===a.m){a=a.c;for(var b=a.length,c=Ub(Zf),d=0;;)if(d<b)Vb(c,a[d]),d+=1;else break;return Wb(c)}for(c=Ub(Zf);;)if(null!=a)b=U(a),c=Vb(c,pb(a)),a=b;else return Wb(c)}function Id(a){if(null!=a&&(a.w&4096||v===a.xc))return a.nb(null);if("string"===typeof a)return a;throw Error(["Doesn't support name: ",J.a(a)].join(""));}
function ag(a,b){return new Jd(null,function(){var c=O(b);return c?Uc(R(c),ag(a,ve(a,c))):null},null,null)}function bg(a){return Wb(qd(function(b,c){return Vd(b,c,tc.f(b,c,0)+1)},Ub(je),a))}
function cg(){var a=Id;return function(){function b(k,l,m){return new ge(null,2,5,he,[Gd.f?Gd.f(k,l,m):Gd.call(null,k,l,m),a.f?a.f(k,l,m):a.call(null,k,l,m)],null)}function c(k,l){return new ge(null,2,5,he,[Gd.b?Gd.b(k,l):Gd.call(null,k,l),a.b?a.b(k,l):a.call(null,k,l)],null)}function d(k){return new ge(null,2,5,he,[Gd.a?Gd.a(k):Gd.call(null,k),a.a?a.a(k):a.call(null,k)],null)}function e(){return new ge(null,2,5,he,[Gd.u?Gd.u():Gd.call(null),a.u?a.u():a.call(null)],null)}var f=null,h=function(){function k(m,
p,q,x){var z=null;if(3<arguments.length){z=0;for(var E=Array(arguments.length-3);z<E.length;)E[z]=arguments[z+3],++z;z=new wc(E,0,null)}return l.call(this,m,p,q,z)}function l(m,p,q,x){return new ge(null,2,5,he,[de(Gd,m,p,q,x),de(a,m,p,q,x)],null)}k.H=3;k.G=function(m){var p=R(m);m=U(m);var q=R(m);m=U(m);var x=R(m);m=xc(m);return l(p,q,x,m)};k.o=l;return k}();f=function(k,l,m,p){switch(arguments.length){case 0:return e.call(this);case 1:return d.call(this,k);case 2:return c.call(this,k,l);case 3:return b.call(this,
k,l,m);default:var q=null;if(3<arguments.length){q=0;for(var x=Array(arguments.length-3);q<x.length;)x[q]=arguments[q+3],++q;q=new wc(x,0,null)}return h.o(k,l,m,q)}throw Error("Invalid arity: "+arguments.length);};f.H=3;f.G=h.G;f.u=e;f.a=d;f.b=c;f.f=b;f.o=h.o;return f}()}function dg(a,b){if("string"===typeof b)return a=a.exec(b),zc.b(R(a),b)?1===W(a)?R(a):Qe(a):null;throw new TypeError("re-matches must match against a string.");}
function eg(a,b){if("string"===typeof b)return a=a.exec(b),null==a?null:1===W(a)?R(a):Qe(a);throw new TypeError("re-find must match against a string.");}
function fg(a,b,c,d,e,f,h){var k=Sa;Sa=null==Sa?null:Sa-1;try{if(null!=Sa&&0>Sa)return Rb(a,"#");Rb(a,c);if(0===Za.a(f))O(h)&&Rb(a,function(){var z=gg.a(f);return H(z)?z:"..."}());else{if(O(h)){var l=R(h);b.f?b.f(l,a,f):b.call(null,l,a,f)}for(var m=U(h),p=Za.a(f)-1;;)if(!m||null!=p&&0===p){O(m)&&0===p&&(Rb(a,d),Rb(a,function(){var z=gg.a(f);return H(z)?z:"..."}()));break}else{Rb(a,d);var q=R(m);c=a;h=f;b.f?b.f(q,c,h):b.call(null,q,c,h);var x=U(m);c=p-1;m=x;p=c}}return Rb(a,e)}finally{Sa=k}}
function hg(a,b){b=O(b);for(var c=null,d=0,e=0;;)if(e<d){var f=c.K(null,e);Rb(a,f);e+=1}else if(b=O(b))c=b,kd(c)?(b=Zb(c),d=$b(c),c=b,f=W(b),b=d,d=f):(f=R(c),Rb(a,f),b=U(c),c=null,d=0),e=0;else return null}function ig(a){if(null==Qa)throw Error("No *print-fn* fn set for evaluation environment");Qa.a?Qa.a(a):Qa.call(null,a)}var jg={'"':'\\"',"\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
function kg(a){return['"',J.a(a.replace(/[\\"\b\f\n\r\t]/g,function(b){return jg[b]})),'"'].join("")}function lg(a,b){return nd(tc.b(a,Xa))?null!=b&&(b.i&131072||v===b.bc)?null!=ed(b):!1:!1}
function mg(a,b,c){if(null==a)return Rb(b,"nil");if(lg(c,a)){Rb(b,"^");var d=ed(a);ng.f?ng.f(d,b,c):ng.call(null,d,b,c);Rb(b," ")}if(a.sb)return a.Gb(b);if(null!=a?a.i&2147483648||v===a.Z||(a.i?0:cb(Sb,a)):cb(Sb,a))return Tb(a,b,c);if(!0===a||!1===a)return Rb(b,J.a(a));if("number"===typeof a)return Rb(b,isNaN(a)?"##NaN":a===Number.POSITIVE_INFINITY?"##Inf":a===Number.NEGATIVE_INFINITY?"##-Inf":J.a(a));if(null!=a&&a.constructor===Object)return Rb(b,"#js "),d=te.b(function(f){return new Ke(null!=dg(/[A-Za-z_\*\+\?!\-'][\w\*\+\?!\-']*/,
f)?Hd.a(f):f,a[f])},na(a)),og.A?og.A(d,ng,b,c):og.call(null,d,ng,b,c);if(Array.isArray(a))return fg(b,ng,"#js ["," ","]",c,a);if("string"==typeof a)return H(Wa.a(c))?Rb(b,kg(a)):Rb(b,a);if("function"==ba(a)){var e=a.name;c=H(function(){var f=null==e;return f?f:/^[\s\xa0]*$/.test(e)}())?"Function":e;return hg(b,Vc(["#object[",c,H(!1)?[' "',J.a(a),'"'].join(""):"","]"]))}if(a instanceof Date)return c=function(f,h){for(f=J.a(f);;)if(f.length<h)f=["0",f].join("");else return f},hg(b,Vc(['#inst "',J.a(a.getUTCFullYear()),
"-",c(a.getUTCMonth()+1,2),"-",c(a.getUTCDate(),2),"T",c(a.getUTCHours(),2),":",c(a.getUTCMinutes(),2),":",c(a.getUTCSeconds(),2),".",c(a.getUTCMilliseconds(),3),"-",'00:00"']));if(a instanceof RegExp)return hg(b,Vc(['#"',a.source,'"']));if(H(function(){var f=null==a?null:a.constructor;return null==f?null:f.Xa}()))return hg(b,Vc(["#object[",a.constructor.Xa.replace(/\//g,"."),"]"]));e=function(){var f=null==a?null:a.constructor;return null==f?null:f.name}();c=H(function(){var f=null==e;return f?f:
/^[\s\xa0]*$/.test(e)}())?"Object":e;return null==a.constructor?hg(b,Vc(["#object[",c,"]"])):hg(b,Vc(["#object[",c," ",J.a(a),"]"]))}function ng(a,b,c){var d=pg.a(c);return H(d)?(c=$c.f(c,qg,mg),d.f?d.f(a,b,c):d.call(null,a,b,c)):mg(a,b,c)}
function rg(a,b){var c=new Ma;a:{var d=new gc(c);ng(R(a),d,b);a=O(U(a));for(var e=null,f=0,h=0;;)if(h<f){var k=e.K(null,h);Rb(d," ");ng(k,d,b);h+=1}else if(a=O(a))e=a,kd(e)?(a=Zb(e),f=$b(e),e=a,k=W(a),a=f,f=k):(k=R(e),Rb(d," "),ng(k,d,b),a=U(e),e=null,f=0),h=0;else break a}return c}function sg(a){var b=Ta();return null==a||bb(O(a))?"":J.a(rg(a,b))}function tg(a){return a instanceof sc?uc.b(null,Id(a)):Hd.b(null,Id(a))}
function ug(a){if(H(!1)){var b=O(a),c=O(b),d=R(c);U(c);X(d,0,null);X(d,1,null);c=null==a?null:null!=a&&(a.i&4||v===a.rc)?a.V(null):(null!=a?a.i&4||v===a.rc||(a.i?0:cb(jb,a)):cb(jb,a))?kb(a):null;for(a=null;;){d=a;b=O(b);a=R(b);var e=U(b),f=a;a=X(f,0,null);b=X(f,1,null);if(H(f))if(a instanceof M||a instanceof sc)if(H(d))if(zc.b(d,Gd(a)))c=$c.f(c,tg(a),b),a=d,b=e;else return null;else if(d=Gd(a),H(d))c=$c.f(c,tg(a),b),a=d,b=e;else return null;else return null;else return new ge(null,2,5,he,[d,c],null)}}else return null}
function vg(a,b,c,d,e){return fg(d,function(f,h,k){var l=yb(f);c.f?c.f(l,h,k):c.call(null,l,h,k);Rb(h," ");f=zb(f);return c.f?c.f(f,h,k):c.call(null,f,h,k)},[J.a(a),"{"].join(""),", ","}",e,O(b))}function og(a,b,c,d){var e=hd(a)?ug(a):null,f=X(e,0,null);e=X(e,1,null);return H(f)?vg(["#:",J.a(f)].join(""),e,b,c,d):vg(null,a,b,c,d)}wc.prototype.Z=v;wc.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};Jd.prototype.Z=v;Jd.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};
Ke.prototype.Z=v;Ke.prototype.R=function(a,b,c){return fg(b,ng,"["," ","]",c,this)};Kf.prototype.Z=v;Kf.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};jf.prototype.Z=v;jf.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};Ue.prototype.Z=v;Ue.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};Ed.prototype.Z=v;Ed.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};Pf.prototype.Z=v;Pf.prototype.R=function(a,b,c){return og(this,ng,b,c)};
Mf.prototype.Z=v;Mf.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};Xf.prototype.Z=v;Xf.prototype.R=function(a,b,c){return fg(b,ng,"#{"," ","}",c,this)};Nd.prototype.Z=v;Nd.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};qe.prototype.Z=v;qe.prototype.R=function(a,b,c){Rb(b,"#object[cljs.core.Atom ");ng(new Ua(null,1,[wg,this.state],null),b,c);return Rb(b,"]")};Uf.prototype.Z=v;Uf.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};we.prototype.Z=v;
we.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};ge.prototype.Z=v;ge.prototype.R=function(a,b,c){return fg(b,ng,"["," ","]",c,this)};$e.prototype.Z=v;$e.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};Cd.prototype.Z=v;Cd.prototype.R=function(a,b){return Rb(b,"()")};af.prototype.Z=v;af.prototype.R=function(a,b,c){return fg(b,ng,"#queue ["," ","]",c,O(this))};Ua.prototype.Z=v;Ua.prototype.R=function(a,b,c){return og(this,ng,b,c)};Tf.prototype.Z=v;
Tf.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};Yc.prototype.Z=v;Yc.prototype.R=function(a,b,c){return fg(b,ng,"("," ",")",c,this)};function xg(){}var yg=function yg(a){if(null!=a&&null!=a.tc)return a.tc(a);var c=yg[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=yg._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IEncodeJS.-clj-\x3ejs",a);};
function zg(a,b){return(null!=a?v===a.sc||(a.Fc?0:cb(xg,a)):cb(xg,a))?yg(a):"string"===typeof a||"number"===typeof a||a instanceof M||a instanceof sc?b.a?b.a(a):b.call(null,a):sg(Vc([a]))}var Ag=function Ag(a){for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return Ag.o(arguments[0],1<c.length?new wc(c.slice(1),0,null):null)};
Ag.o=function(a,b){b=null!=b&&(b.i&64||v===b.Wa)?be(Sf,b):b;var c=tc.f(b,Bg,Id),d=function h(f){if(null==f)return null;if(null!=f?v===f.sc||(f.Fc?0:cb(xg,f)):cb(xg,f))return yg(f);if(f instanceof M)return c.a?c.a(f):c.call(null,f);if(f instanceof sc)return J.a(f);if(hd(f)){var k={};f=O(f);for(var l=null,m=0,p=0;;)if(p<m){var q=l.K(null,p),x=X(q,0,null),z=X(q,1,null);q=k;x=zg(x,d);z=h(z);q[x]=z;p+=1}else if(f=O(f))kd(f)?(m=Zb(f),f=$b(f),l=m,m=W(m)):(l=R(f),m=X(l,0,null),p=X(l,1,null),l=k,m=zg(m,d),
p=h(p),l[m]=p,f=U(f),l=null,m=0),p=0;else break;return k}if(null==f?0:null!=f?f.i&8||v===f.Wc||(f.i?0:cb(lb,f)):cb(lb,f)){k=[];f=O(te.b(h,f));l=null;for(p=m=0;;)if(p<m)q=l.K(null,p),k.push(q),p+=1;else if(f=O(f))l=f,kd(l)?(f=Zb(l),p=$b(l),l=f,m=W(f),f=p):(f=R(l),k.push(f),f=U(l),l=null,m=0),p=0;else break;return k}return f};return d(a)};Ag.H=1;Ag.G=function(a){var b=R(a);a=U(a);return this.o(b,a)};var Cg=null;function Dg(){null==Cg&&(Cg=new qe(new Ua(null,3,[Eg,je,Fg,je,Gg,je],null)));return Cg}
function Hg(a,b,c){var d=zc.b(b,c);if(d)return d;d=Gg.a(a);d=d.a?d.a(b):d.call(null,b);if(d=od(d,c))return d;if(jd(c))if(jd(b))if(W(c)===W(b)){d=!0;for(var e=0;;)if(d&&e!==W(c))d=Hg(a,b.a?b.a(e):b.call(null,e),c.a?c.a(e):c.call(null,e)),e+=1;else return d}else return!1;else return!1;else return!1}function Ig(a){var b=Cb(Dg());a=tc.b(Eg.a(b),a);return O(a)?a:null}function Jg(a,b,c,d){se.b(a,function(){return Cb(b)});se.b(c,function(){return Cb(d)})}
var Kg=function Kg(a,b,c){var e=function(){var f=Cb(c);return f.a?f.a(a):f.call(null,a)}();e=H(H(e)?e.a?e.a(b):e.call(null,b):e)?!0:null;if(H(e))return e;e=function(){for(var f=Ig(b);;)if(0<W(f)){var h=R(f);Kg.f?Kg.f(a,h,c):Kg.call(null,a,h,c);f=xc(f)}else return null}();if(H(e))return e;e=function(){for(var f=Ig(a);;)if(0<W(f)){var h=R(f);Kg.f?Kg.f(h,b,c):Kg.call(null,h,b,c);f=xc(f)}else return null}();return H(e)?e:!1};function Lg(a,b,c,d){c=Kg(a,b,c);return H(c)?c:Hg(d,a,b)}
var Mg=function Mg(a,b,c,d,e,f,h,k){var m=qd(function(q,x){var z=X(x,0,null);X(x,1,null);if(Hg(Cb(c),b,z)&&(q=null==q||Lg(z,R(q),e,Cb(c))?x:q,!Lg(R(q),z,e,Cb(c))))throw Error(["Multiple methods in multimethod '",J.a(a),"' match dispatch value: ",J.a(b)," -\x3e ",J.a(z)," and ",J.a(R(q)),", and neither is preferred"].join(""));return q},null,Cb(d)),p=function(){if(null==m){var q=Cb(d);q=q.a?q.a(k):q.call(null,k)}else q=!1;return H(q)?new ge(null,2,5,he,[k,q],null):m}();if(H(p)){if(zc.b(Cb(h),Cb(c)))return se.A(f,
$c,b,R(U(p))),R(U(p));Jg(f,d,h,c);return Mg.$?Mg.$(a,b,c,d,e,f,h,k):Mg.call(null,a,b,c,d,e,f,h,k)}return null};function Ng(a,b){throw Error(["No method in multimethod '",J.a(a),"' for dispatch value: ",J.a(b)].join(""));}function Og(){var a=uc.b("cljs.tools.reader.impl.inspect","inspect*"),b=Pg,c=Qg,d=Rg,e=Sg,f=Tg,h=Ug,k=Vg;this.name=a;this.h=h;this.Jc=k;this.Jb=b;this.Lb=c;this.Oc=d;this.Kb=e;this.Cb=f;this.i=4194305;this.w=4352}g=Og.prototype;
g.call=function(){function a(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca,ab){n=this;var Dc=ee(n.h,r,t,u,w,Vc([y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca,ab])),Kh=Wg(this,Dc);H(Kh)||Ng(n.name,Dc);return ee(Kh,r,t,u,w,Vc([y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca,ab]))}function b(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca){n=this;var ab=n.h.na?n.h.na(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca):n.h.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca),Dc=Wg(this,ab);H(Dc)||Ng(n.name,ab);return Dc.na?Dc.na(r,
t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca):Dc.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca)}function c(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua){n=this;var Ca=n.h.ma?n.h.ma(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua):n.h.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua),ab=Wg(this,Ca);H(ab)||Ng(n.name,Ca);return ab.ma?ab.ma(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua):ab.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua)}function d(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka){n=this;var ua=n.h.la?
n.h.la(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka):n.h.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka),Ca=Wg(this,ua);H(Ca)||Ng(n.name,ua);return Ca.la?Ca.la(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka):Ca.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka)}function e(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca){n=this;var ka=n.h.ka?n.h.ka(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca):n.h.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca),ua=Wg(this,ka);H(ua)||Ng(n.name,ka);return ua.ka?ua.ka(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca):ua.call(null,
r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca)}function f(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y){n=this;var ca=n.h.ja?n.h.ja(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y):n.h.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y),ka=Wg(this,ca);H(ka)||Ng(n.name,ca);return ka.ja?ka.ja(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y):ka.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y)}function h(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S){n=this;var Y=n.h.ia?n.h.ia(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S):n.h.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S),ca=Wg(this,Y);H(ca)||Ng(n.name,
Y);return ca.ia?ca.ia(r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S):ca.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S)}function k(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q){n=this;var S=n.h.ha?n.h.ha(r,t,u,w,y,A,B,C,D,G,I,N,P,Q):n.h.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q),Y=Wg(this,S);H(Y)||Ng(n.name,S);return Y.ha?Y.ha(r,t,u,w,y,A,B,C,D,G,I,N,P,Q):Y.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P,Q)}function l(n,r,t,u,w,y,A,B,C,D,G,I,N,P){n=this;var Q=n.h.ga?n.h.ga(r,t,u,w,y,A,B,C,D,G,I,N,P):n.h.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P),S=Wg(this,
Q);H(S)||Ng(n.name,Q);return S.ga?S.ga(r,t,u,w,y,A,B,C,D,G,I,N,P):S.call(null,r,t,u,w,y,A,B,C,D,G,I,N,P)}function m(n,r,t,u,w,y,A,B,C,D,G,I,N){n=this;var P=n.h.fa?n.h.fa(r,t,u,w,y,A,B,C,D,G,I,N):n.h.call(null,r,t,u,w,y,A,B,C,D,G,I,N),Q=Wg(this,P);H(Q)||Ng(n.name,P);return Q.fa?Q.fa(r,t,u,w,y,A,B,C,D,G,I,N):Q.call(null,r,t,u,w,y,A,B,C,D,G,I,N)}function p(n,r,t,u,w,y,A,B,C,D,G,I){n=this;var N=n.h.ea?n.h.ea(r,t,u,w,y,A,B,C,D,G,I):n.h.call(null,r,t,u,w,y,A,B,C,D,G,I),P=Wg(this,N);H(P)||Ng(n.name,N);return P.ea?
P.ea(r,t,u,w,y,A,B,C,D,G,I):P.call(null,r,t,u,w,y,A,B,C,D,G,I)}function q(n,r,t,u,w,y,A,B,C,D,G){n=this;var I=n.h.da?n.h.da(r,t,u,w,y,A,B,C,D,G):n.h.call(null,r,t,u,w,y,A,B,C,D,G),N=Wg(this,I);H(N)||Ng(n.name,I);return N.da?N.da(r,t,u,w,y,A,B,C,D,G):N.call(null,r,t,u,w,y,A,B,C,D,G)}function x(n,r,t,u,w,y,A,B,C,D){n=this;var G=n.h.qa?n.h.qa(r,t,u,w,y,A,B,C,D):n.h.call(null,r,t,u,w,y,A,B,C,D),I=Wg(this,G);H(I)||Ng(n.name,G);return I.qa?I.qa(r,t,u,w,y,A,B,C,D):I.call(null,r,t,u,w,y,A,B,C,D)}function z(n,
r,t,u,w,y,A,B,C){n=this;var D=n.h.$?n.h.$(r,t,u,w,y,A,B,C):n.h.call(null,r,t,u,w,y,A,B,C),G=Wg(this,D);H(G)||Ng(n.name,D);return G.$?G.$(r,t,u,w,y,A,B,C):G.call(null,r,t,u,w,y,A,B,C)}function E(n,r,t,u,w,y,A,B){n=this;var C=n.h.pa?n.h.pa(r,t,u,w,y,A,B):n.h.call(null,r,t,u,w,y,A,B),D=Wg(this,C);H(D)||Ng(n.name,C);return D.pa?D.pa(r,t,u,w,y,A,B):D.call(null,r,t,u,w,y,A,B)}function K(n,r,t,u,w,y,A){n=this;var B=n.h.oa?n.h.oa(r,t,u,w,y,A):n.h.call(null,r,t,u,w,y,A),C=Wg(this,B);H(C)||Ng(n.name,B);return C.oa?
C.oa(r,t,u,w,y,A):C.call(null,r,t,u,w,y,A)}function F(n,r,t,u,w,y){n=this;var A=n.h.M?n.h.M(r,t,u,w,y):n.h.call(null,r,t,u,w,y),B=Wg(this,A);H(B)||Ng(n.name,A);return B.M?B.M(r,t,u,w,y):B.call(null,r,t,u,w,y)}function T(n,r,t,u,w){n=this;var y=n.h.A?n.h.A(r,t,u,w):n.h.call(null,r,t,u,w),A=Wg(this,y);H(A)||Ng(n.name,y);return A.A?A.A(r,t,u,w):A.call(null,r,t,u,w)}function Z(n,r,t,u){n=this;var w=n.h.f?n.h.f(r,t,u):n.h.call(null,r,t,u),y=Wg(this,w);H(y)||Ng(n.name,w);return y.f?y.f(r,t,u):y.call(null,
r,t,u)}function la(n,r,t){n=this;var u=n.h.b?n.h.b(r,t):n.h.call(null,r,t),w=Wg(this,u);H(w)||Ng(n.name,u);return w.b?w.b(r,t):w.call(null,r,t)}function wa(n,r){n=this;var t=n.h.a?n.h.a(r):n.h.call(null,r),u=Wg(this,t);H(u)||Ng(n.name,t);return u.a?u.a(r):u.call(null,r)}function Ga(n){n=this;var r=n.h.u?n.h.u():n.h.call(null),t=Wg(this,r);H(t)||Ng(n.name,r);return t.u?t.u():t.call(null)}var da=null;da=function(n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca,ab){switch(arguments.length){case 1:return Ga.call(this,
n);case 2:return wa.call(this,n,r);case 3:return la.call(this,n,r,t);case 4:return Z.call(this,n,r,t,u);case 5:return T.call(this,n,r,t,u,w);case 6:return F.call(this,n,r,t,u,w,y);case 7:return K.call(this,n,r,t,u,w,y,A);case 8:return E.call(this,n,r,t,u,w,y,A,B);case 9:return z.call(this,n,r,t,u,w,y,A,B,C);case 10:return x.call(this,n,r,t,u,w,y,A,B,C,D);case 11:return q.call(this,n,r,t,u,w,y,A,B,C,D,G);case 12:return p.call(this,n,r,t,u,w,y,A,B,C,D,G,I);case 13:return m.call(this,n,r,t,u,w,y,A,B,
C,D,G,I,N);case 14:return l.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P);case 15:return k.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q);case 16:return h.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S);case 17:return f.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y);case 18:return e.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca);case 19:return d.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka);case 20:return c.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua);case 21:return b.call(this,n,r,t,u,w,y,A,B,C,D,G,I,
N,P,Q,S,Y,ca,ka,ua,Ca);case 22:return a.call(this,n,r,t,u,w,y,A,B,C,D,G,I,N,P,Q,S,Y,ca,ka,ua,Ca,ab)}throw Error("Invalid arity: "+(arguments.length-1));};da.a=Ga;da.b=wa;da.f=la;da.A=Z;da.M=T;da.oa=F;da.pa=K;da.$=E;da.qa=z;da.da=x;da.ea=q;da.fa=p;da.ga=m;da.ha=l;da.ia=k;da.ja=h;da.ka=f;da.la=e;da.ma=d;da.na=c;da.Pb=b;da.mb=a;return da}();g.apply=function(a,b){return this.call.apply(this,[this].concat(gb(b)))};
g.u=function(){var a=this.h.u?this.h.u():this.h.call(null),b=Wg(this,a);H(b)||Ng(this.name,a);return b.u?b.u():b.call(null)};g.a=function(a){var b=this.h.a?this.h.a(a):this.h.call(null,a),c=Wg(this,b);H(c)||Ng(this.name,b);return c.a?c.a(a):c.call(null,a)};g.b=function(a,b){var c=this.h.b?this.h.b(a,b):this.h.call(null,a,b),d=Wg(this,c);H(d)||Ng(this.name,c);return d.b?d.b(a,b):d.call(null,a,b)};
g.f=function(a,b,c){var d=this.h.f?this.h.f(a,b,c):this.h.call(null,a,b,c),e=Wg(this,d);H(e)||Ng(this.name,d);return e.f?e.f(a,b,c):e.call(null,a,b,c)};g.A=function(a,b,c,d){var e=this.h.A?this.h.A(a,b,c,d):this.h.call(null,a,b,c,d),f=Wg(this,e);H(f)||Ng(this.name,e);return f.A?f.A(a,b,c,d):f.call(null,a,b,c,d)};g.M=function(a,b,c,d,e){var f=this.h.M?this.h.M(a,b,c,d,e):this.h.call(null,a,b,c,d,e),h=Wg(this,f);H(h)||Ng(this.name,f);return h.M?h.M(a,b,c,d,e):h.call(null,a,b,c,d,e)};
g.oa=function(a,b,c,d,e,f){var h=this.h.oa?this.h.oa(a,b,c,d,e,f):this.h.call(null,a,b,c,d,e,f),k=Wg(this,h);H(k)||Ng(this.name,h);return k.oa?k.oa(a,b,c,d,e,f):k.call(null,a,b,c,d,e,f)};g.pa=function(a,b,c,d,e,f,h){var k=this.h.pa?this.h.pa(a,b,c,d,e,f,h):this.h.call(null,a,b,c,d,e,f,h),l=Wg(this,k);H(l)||Ng(this.name,k);return l.pa?l.pa(a,b,c,d,e,f,h):l.call(null,a,b,c,d,e,f,h)};
g.$=function(a,b,c,d,e,f,h,k){var l=this.h.$?this.h.$(a,b,c,d,e,f,h,k):this.h.call(null,a,b,c,d,e,f,h,k),m=Wg(this,l);H(m)||Ng(this.name,l);return m.$?m.$(a,b,c,d,e,f,h,k):m.call(null,a,b,c,d,e,f,h,k)};g.qa=function(a,b,c,d,e,f,h,k,l){var m=this.h.qa?this.h.qa(a,b,c,d,e,f,h,k,l):this.h.call(null,a,b,c,d,e,f,h,k,l),p=Wg(this,m);H(p)||Ng(this.name,m);return p.qa?p.qa(a,b,c,d,e,f,h,k,l):p.call(null,a,b,c,d,e,f,h,k,l)};
g.da=function(a,b,c,d,e,f,h,k,l,m){var p=this.h.da?this.h.da(a,b,c,d,e,f,h,k,l,m):this.h.call(null,a,b,c,d,e,f,h,k,l,m),q=Wg(this,p);H(q)||Ng(this.name,p);return q.da?q.da(a,b,c,d,e,f,h,k,l,m):q.call(null,a,b,c,d,e,f,h,k,l,m)};g.ea=function(a,b,c,d,e,f,h,k,l,m,p){var q=this.h.ea?this.h.ea(a,b,c,d,e,f,h,k,l,m,p):this.h.call(null,a,b,c,d,e,f,h,k,l,m,p),x=Wg(this,q);H(x)||Ng(this.name,q);return x.ea?x.ea(a,b,c,d,e,f,h,k,l,m,p):x.call(null,a,b,c,d,e,f,h,k,l,m,p)};
g.fa=function(a,b,c,d,e,f,h,k,l,m,p,q){var x=this.h.fa?this.h.fa(a,b,c,d,e,f,h,k,l,m,p,q):this.h.call(null,a,b,c,d,e,f,h,k,l,m,p,q),z=Wg(this,x);H(z)||Ng(this.name,x);return z.fa?z.fa(a,b,c,d,e,f,h,k,l,m,p,q):z.call(null,a,b,c,d,e,f,h,k,l,m,p,q)};g.ga=function(a,b,c,d,e,f,h,k,l,m,p,q,x){var z=this.h.ga?this.h.ga(a,b,c,d,e,f,h,k,l,m,p,q,x):this.h.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x),E=Wg(this,z);H(E)||Ng(this.name,z);return E.ga?E.ga(a,b,c,d,e,f,h,k,l,m,p,q,x):E.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x)};
g.ha=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z){var E=this.h.ha?this.h.ha(a,b,c,d,e,f,h,k,l,m,p,q,x,z):this.h.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z),K=Wg(this,E);H(K)||Ng(this.name,E);return K.ha?K.ha(a,b,c,d,e,f,h,k,l,m,p,q,x,z):K.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z)};
g.ia=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E){var K=this.h.ia?this.h.ia(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E):this.h.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E),F=Wg(this,K);H(F)||Ng(this.name,K);return F.ia?F.ia(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E):F.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E)};
g.ja=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K){var F=this.h.ja?this.h.ja(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K):this.h.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K),T=Wg(this,F);H(T)||Ng(this.name,F);return T.ja?T.ja(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K):T.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K)};
g.ka=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F){var T=this.h.ka?this.h.ka(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F):this.h.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F),Z=Wg(this,T);H(Z)||Ng(this.name,T);return Z.ka?Z.ka(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F):Z.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F)};
g.la=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T){var Z=this.h.la?this.h.la(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T):this.h.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T),la=Wg(this,Z);H(la)||Ng(this.name,Z);return la.la?la.la(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T):la.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T)};
g.ma=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z){var la=this.h.ma?this.h.ma(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z):this.h.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z),wa=Wg(this,la);H(wa)||Ng(this.name,la);return wa.ma?wa.ma(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z):wa.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z)};
g.na=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la){var wa=this.h.na?this.h.na(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la):this.h.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la),Ga=Wg(this,wa);H(Ga)||Ng(this.name,wa);return Ga.na?Ga.na(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la):Ga.call(null,a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la)};
g.Pb=function(a,b,c,d,e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa){var Ga=ee(this.h,a,b,c,d,Vc([e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa])),da=Wg(this,Ga);H(da)||Ng(this.name,Ga);return ee(da,a,b,c,d,Vc([e,f,h,k,l,m,p,q,x,z,E,K,F,T,Z,la,wa]))};function Xg(a,b){var c=pe;se.A(c.Lb,$c,a,b);Jg(c.Kb,c.Lb,c.Cb,c.Jb)}function Wg(a,b){zc.b(Cb(a.Cb),Cb(a.Jb))||Jg(a.Kb,a.Lb,a.Cb,a.Jb);var c=Cb(a.Kb);c=c.a?c.a(b):c.call(null,b);return H(c)?c:Mg(a.name,b,a.Jb,a.Lb,a.Oc,a.Kb,a.Cb,a.Jc)}g.nb=function(){return ac(this.name)};
g.ob=function(){return bc(this.name)};g.P=function(){return this[ea]||(this[ea]=++fa)};function Yg(a){this.Bb=a;this.s=null;this.i=2153775104;this.w=2048}Yg.prototype.toString=function(){return this.Bb};Yg.prototype.O=function(a,b){return b instanceof Yg&&this.Bb===b.Bb};Yg.prototype.R=function(a,b){return Rb(b,['#uuid "',J.a(this.Bb),'"'].join(""))};Yg.prototype.P=function(){null==this.s&&(this.s=qc(this.Bb));return this.s};
function Zg(a,b,c){var d=Error(a);this.message=a;this.data=b;this.Xb=c;this.name=d.name;this.description=d.description;this.number=d.number;this.fileName=d.fileName;this.lineNumber=d.lineNumber;this.columnNumber=d.columnNumber;this.stack=d.stack;return this}Zg.prototype.__proto__=Error.prototype;Zg.prototype.Z=v;
Zg.prototype.R=function(a,b,c){Rb(b,"#error {:message ");ng(this.message,b,c);H(this.data)&&(Rb(b,", :data "),ng(this.data,b,c));H(this.Xb)&&(Rb(b,", :cause "),ng(this.Xb,b,c));return Rb(b,"}")};Zg.prototype.toString=function(){return hc(this)};"undefined"!==typeof console&&$a();zc.b("nodejs","nodejs")&&(aa=global);$a();var $g=new sc(null,"val","val",1769233139,null),ah=new M(null,"code","code",1586293142),wg=new M(null,"val","val",128701612),bh=new M(null,"readers","readers",-2118263030),ch=new M(null,"line","line",212345235),Xa=new M(null,"meta","meta",1499536964),dh=new M(null,"map","map",1371690461),eh=new M(null,"string","string",-1989541586),fh=new M(null,"namespaced-map","namespaced-map",1235665380),gh=new sc(null,"meta117930","meta117930",993366462,null),hh=new M(null,"col","col",-1959363084),Fg=new M(null,
"descendants","descendants",1824886031),ih=new M(null,"tag","tag",-1290361223),jh=new sc(null,"meta117712","meta117712",1039885678,null),kh=new M(null,"catch-block","catch-block",1175212748),lh=new sc(null,"inst","inst",-2008473268,null),mh=new M(null,"recur","recur",-437573268),nh=new M(null,"ex-kind","ex-kind",1581199296),pg=new M(null,"alt-impl","alt-impl",670969595),oh=new sc(null,"-Inf","-Inf",-2123243689,null),Vg=new M(null,"default","default",-1987822328),ph=new M(null,"prev","prev",-1597069226),
qh=new sc(null,"Inf","Inf",647172781,null),Ya=new M(null,"dup","dup",556298533),rh=new sc(null,"/","/",-1371932971,null),Za=new M(null,"print-length","print-length",1931866356),sh=new M(null,"nil","nil",99600501),Va=new M(null,"flush-on-newline","flush-on-newline",-151457939),th=new M(null,"illegal-argument","illegal-argument",-1845493170),uh=new M(null,"reader-exception","reader-exception",-1938323098),vh=new M(null,"character","character",380652989),wh=new M(null,"list","list",765357683),xh=new M(null,
"hierarchy","hierarchy",-1053470341),yh=new M(null,"column","column",2078222095),zh=new M(null,"set","set",304602554),Ah=new M(null,"strable","strable",1877668047),Bh=new M(null,"preset-config","preset-config",-736666317),Ch=new M(null,"continue-block","continue-block",-1852047850),Dh=new M(null,"symbol","symbol",-1038572696),Eg=new M(null,"parents","parents",-2027538891),qg=new M(null,"fallback-impl","fallback-impl",-1501286995),Eh=new M(null,"catch-exception","catch-exception",-1997306795),Wa=new M(null,
"readably","readably",1129599760),Bg=new M(null,"keyword-fn","keyword-fn",-64566675),Fh=new sc(null,"blockable","blockable",-28395259,null),Gh=new M(null,"file","file",-1269645878),ie=new sc(null,"meta116585","meta116585",-1200685443,null),Hh=new sc(null,"meta117799","meta117799",-1066701660,null),Ih=new M(null,"vector","vector",1902966158),Jh=new sc(null,"uuid","uuid",-504564192,null),Lh=new sc(null,"NaN","NaN",666918153,null),Mh=new M(null,"finally-block","finally-block",832982472),Nh=new sc(null,
"queue","queue",-1198599890,null),Oh=new M(null,"eof","eof",-489063237),Ph=new sc(null,"f","f",43394975,null),Qh=new sc(null,"js","js",-886355190,null),Rh=new M(null,"keyword","keyword",811389747),Sh=new M(null,"type","type",1174270348),Th=new M(null,"reader-error","reader-error",1610253121),Gg=new M(null,"ancestors","ancestors",-776045424),Uh=new M(null,"source-map-json","source-map-json",-299460036),gg=new M(null,"more-marker","more-marker",-14717935);var Vh={},Wh,Xh={},Yh=function Yh(a,b,c){if(null!=a&&null!=a.Sb)return a.Sb(a,b,c);var e=Yh[ba(null==a?null:a)];if(null!=e)return e.f?e.f(a,b,c):e.call(null,a,b,c);e=Yh._;if(null!=e)return e.f?e.f(a,b,c):e.call(null,a,b,c);throw db("WritePort.put!",a);},Zh=function Zh(a){if(null!=a&&null!=a.rb)return a.rb(a);var c=Zh[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Zh._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("Channel.close!",a);},$h=function $h(a){if(null!=a&&null!=
a.fc)return!0;var c=$h[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=$h._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("Handler.active?",a);},ai=function ai(a){if(null!=a&&null!=a.gc)return a.Aa;var c=ai[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=ai._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("Handler.commit",a);},bi=function bi(a,b){if(null!=a&&null!=a.ec)return a.ec(a,b);var d=bi[ba(null==a?null:a)];if(null!=d)return d.b?d.b(a,b):d.call(null,
a,b);d=bi._;if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);throw db("Buffer.add!*",a);},ci=function ci(a){switch(arguments.length){case 1:return ci.a(arguments[0]);case 2:return ci.b(arguments[0],arguments[1]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}};ci.a=function(a){return a};ci.b=function(a,b){return bi(a,b)};ci.H=2;function di(a,b,c,d,e){for(var f=0;;)if(f<e)c[d+f]=a[b+f],f+=1;else break}function ei(a){this.length=this.I=this.head=0;this.c=a}g=ei.prototype;g.pop=function(){if(0===this.length)return null;var a=this.c[this.I];this.c[this.I]=null;this.I=(this.I+1)%this.c.length;--this.length;return a};g.unshift=function(a){this.c[this.head]=a;this.head=(this.head+1)%this.c.length;this.length+=1;return null};g.unbounded_unshift=function(a){this.length+1===this.c.length&&this.resize();return this.unshift(a)};
g.resize=function(){var a=Array(2*this.c.length);return this.I<this.head?(di(this.c,this.I,a,0,this.length),this.I=0,this.head=this.length,this.c=a):this.I>this.head?(di(this.c,this.I,a,0,this.c.length-this.I),di(this.c,0,a,this.c.length-this.I,this.head),this.I=0,this.head=this.length,this.c=a):this.I===this.head?(this.head=this.I=0,this.c=a):null};g.cleanup=function(a){for(var b=this.length,c=0;;)if(c<b){var d=this.pop();(a.a?a.a(d):a.call(null,d))&&this.unshift(d);c+=1}else return null};
function fi(a,b){this.D=a;this.n=b;this.i=2;this.w=0}function gi(a){return a.D.length===a.n}fi.prototype.ec=function(a,b){this.D.unbounded_unshift(b);return this};fi.prototype.Y=function(){return this.D.length};function hi(){return Fa("iPhone")&&!Fa("iPod")&&!Fa("iPad")};Fa("Opera");Fa("Trident")||Fa("MSIE");Fa("Edge");!Fa("Gecko")||ya("WebKit")&&!Fa("Edge")||Fa("Trident")||Fa("MSIE")||Fa("Edge");ya("WebKit")&&!Fa("Edge")&&Fa("Mobile");Fa("Macintosh");Fa("Windows");Fa("Linux")||Fa("CrOS");var ii=aa.navigator||null;ii&&(ii.appVersion||"").indexOf("X11");Fa("Android");hi();Fa("iPad");Fa("iPod");hi()||Fa("iPad")||Fa("iPod");ya("KaiOS");ya("GAFP");function ji(a){var b=document;a=String(a);"application/xhtml+xml"===b.contentType&&(a=a.toLowerCase());return b.createElement(a)};var ki;
function li(){var a=aa.MessageChannel;"undefined"===typeof a&&"undefined"!==typeof window&&window.postMessage&&window.addEventListener&&!Fa("Presto")&&(a=function(){var e=ji("IFRAME");e.style.display="none";La(e);document.documentElement.appendChild(e);var f=e.contentWindow;e=f.document;e.open();e.write(Ja());e.close();var h="callImmediate"+Math.random(),k="file:"==f.location.protocol?"*":f.location.protocol+"//"+f.location.host;e=ja(function(l){if(("*"==k||l.origin==k)&&l.data==h)this.port1.onmessage()},this);
f.addEventListener("message",e,!1);this.port1={};this.port2={postMessage:function(){f.postMessage(h,k)}}});if("undefined"!==typeof a&&!Fa("Trident")&&!Fa("MSIE")){var b=new a,c={},d=c;b.port1.onmessage=function(){if(void 0!==c.next){c=c.next;var e=c.Yb;c.Yb=null;e()}};return function(e){d.next={Yb:e};d=d.next;b.port2.postMessage(0)}}return"undefined"!==typeof document&&"onreadystatechange"in ji("SCRIPT")?function(e){var f=ji("SCRIPT");f.onreadystatechange=function(){f.onreadystatechange=null;f.parentNode.removeChild(f);
f=null;e();e=null};document.documentElement.appendChild(f)}:function(e){aa.setTimeout(e,0)}};var mi=new ei(Array(32)),ni=!1,oi=!1;function pi(){ni=!0;oi=!1;for(var a=0;;){var b=mi.pop();if(null!=b&&(b.u?b.u():b.call(null),1024>a)){a+=1;continue}break}ni=!1;return 0<mi.length?qi.u?qi.u():qi.call(null):null}function qi(){if(oi&&ni)return null;oi=!0;"function"!=ba(aa.setImmediate)||aa.Window&&aa.Window.prototype&&!Fa("Edge")&&aa.Window.prototype.setImmediate==aa.setImmediate?(ki||(ki=li()),ki(pi)):aa.setImmediate(pi)}function ri(a){mi.unbounded_unshift(a);qi()};var si={},ti;
function ui(a){if("undefined"===typeof Na||"undefined"===typeof Oa||"undefined"===typeof Vh||"undefined"===typeof Xh||"undefined"===typeof si||"undefined"===typeof ti)ti=function(b,c){this.v=b;this.Mc=c;this.i=425984;this.w=0},ti.prototype.S=function(b,c){return new ti(this.v,c)},ti.prototype.N=function(){return this.Mc},ti.prototype.Eb=function(){return this.v},ti.Tb=function(){return new ge(null,2,5,he,[$g,Hh],null)},ti.sb=!0,ti.Xa="cljs.core.async.impl.channels/t_cljs$core$async$impl$channels117798",ti.Gb=
function(b){return Rb(b,"cljs.core.async.impl.channels/t_cljs$core$async$impl$channels117798")};return new ti(a,je)}function vi(a,b){this.vb=a;this.v=b}function wi(a){return $h(a.vb)}function xi(a,b,c,d){this.kb=a;this.Ib=0;this.Oa=b;this.Hb=0;this.D=c;this.closed=!1;this.Ca=d}function yi(a){for(;;){var b=a.Oa.pop();if(null!=b){var c=b.vb;ri(function(d){return function(){return d.a?d.a(!0):d.call(null,!0)}}(c.Aa,c,b.v,b,a))}break}a.Oa.cleanup(ne());a.rb(null)}
xi.prototype.Sb=function(a,b,c){var d=this,e=this,f=d.closed;if(f)return ui(!f);if(H(function(){var q=d.D;return H(q)?bb(gi(d.D)):q}())){var h=Ic(d.Ca.b?d.Ca.b(d.D,b):d.Ca.call(null,d.D,b));c=function(){for(var q=Xc;;)if(0<d.kb.length&&0<W(d.D)){var x=d.kb.pop(),z=x.Aa,E=d.D.D.pop();q=Wc.b(q,function(K,F,T){return function(){return F.a?F.a(T):F.call(null,T)}}(q,z,E,x,h,f,e))}else return q}();h&&yi(e);if(O(c)){c=O(c);a=null;for(var k=0,l=0;;)if(l<k){var m=a.K(null,l);ri(m);l+=1}else if(c=O(c))a=c,
kd(a)?(c=Zb(a),l=$b(a),a=c,k=W(c),c=l):(c=R(a),ri(c),c=U(a),a=null,k=0),l=0;else break}return ui(!0)}a=function(){for(;;){var q=d.kb.pop();if(H(q)){if(H(!0))return q}else return null}}();if(H(a)){var p=a.Aa;ri(function(){return p.a?p.a(b):p.call(null,b)});return ui(!0)}64<d.Hb?(d.Hb=0,d.Oa.cleanup(wi)):d.Hb+=1;H(c.Rb())&&d.Oa.unbounded_unshift(new vi(c,b));return null};
function zi(a,b){if(null!=a.D&&0<W(a.D)){b=b.Aa;if(H(b)){var c=a.D.D.pop(),d=0<a.Oa.length?function(){for(var E=Xc;;){var K=a.Oa.pop(),F=K.v;K=K.vb.Aa;E=H(K)?Wc.b(E,K):E;F=H(K)?Ic(a.Ca.b?a.Ca.b(a.D,F):a.Ca.call(null,a.D,F)):null;if(!(bb(F)&&bb(gi(a.D))&&0<a.Oa.length))return new ge(null,2,5,he,[F,E],null)}}():null,e=X(d,0,null),f=X(d,1,null);H(e)&&yi(a);for(var h=O(f),k=null,l=0,m=0;;)if(m<l){var p=k.K(null,m);ri(function(E,K,F,T,Z){return function(){return Z.a?Z.a(!0):Z.call(null,!0)}}(h,k,l,m,p,
c,d,e,f,b,b,a));m+=1}else{var q=O(h);if(q){p=q;if(kd(p))h=Zb(p),m=$b(p),k=h,l=W(h),h=m;else{var x=R(p);ri(function(E,K,F,T,Z){return function(){return Z.a?Z.a(!0):Z.call(null,!0)}}(h,k,l,m,x,p,q,c,d,e,f,b,b,a));h=U(p);k=null;l=0}m=0}else break}return ui(c)}return null}c=function(){for(;;){var E=a.Oa.pop();if(H(E)){if($h(E.vb))return E}else return null}}();if(H(c)){var z=ai(c.vb);ri(function(){return z.a?z.a(!0):z.call(null,!0)});return ui(c.v)}if(H(a.closed))return H(a.D)&&(a.Ca.a?a.Ca.a(a.D):a.Ca.call(null,
a.D)),H(H(!0)?b.Aa:!0)?(b=function(){var E=a.D;return H(E)?0<W(a.D):E}(),c=H(b)?a.D.D.pop():null,ui(c)):null;64<a.Ib?(a.Ib=0,a.kb.cleanup($h)):a.Ib+=1;H(b.Rb())&&a.kb.unbounded_unshift(b);return null}
xi.prototype.rb=function(){var a=this;if(!a.closed)for(a.closed=!0,H(function(){var e=a.D;return H(e)?0===a.Oa.length:e}())&&(a.Ca.a?a.Ca.a(a.D):a.Ca.call(null,a.D));;){var b=a.kb.pop();if(null!=b){var c=b.Aa,d=H(function(){var e=a.D;return H(e)?0<W(a.D):e}())?a.D.D.pop():null;ri(function(e,f){return function(){return e.a?e.a(f):e.call(null,f)}}(c,d,b,this))}else break}return null};function Ai(a){console.log(a);return null}
function Bi(a,b){var c=H(null)?null:Ai;b=c.a?c.a(b):c.call(null,b);return null==b?a:ci.b(a,b)}
function Ci(a){return new xi(new ei(Array(32)),new ei(Array(32)),a,function(){var b=H(null)?null.a?null.a(ci):null.call(null,ci):ci;return function(){function c(f,h){try{return b.b?b.b(f,h):b.call(null,f,h)}catch(k){return Bi(f,k)}}function d(f){try{return b.a?b.a(f):b.call(null,f)}catch(h){return Bi(f,h)}}var e=null;e=function(f,h){switch(arguments.length){case 1:return d.call(this,f);case 2:return c.call(this,f,h)}throw Error("Invalid arity: "+arguments.length);};e.a=d;e.b=c;return e}()}())};var Di={},Ei;
function Fi(a){if("undefined"===typeof Na||"undefined"===typeof Oa||"undefined"===typeof Vh||"undefined"===typeof Xh||"undefined"===typeof Di||"undefined"===typeof Ei)Ei=function(b,c){this.Aa=b;this.Lc=c;this.i=393216;this.w=0},Ei.prototype.S=function(b,c){return new Ei(this.Aa,c)},Ei.prototype.N=function(){return this.Lc},Ei.prototype.fc=function(){return!0},Ei.prototype.Rb=function(){return!0},Ei.prototype.gc=function(){return this.Aa},Ei.Tb=function(){return new ge(null,2,5,he,[Ph,jh],null)},Ei.sb=
!0,Ei.Xa="cljs.core.async.impl.ioc-helpers/t_cljs$core$async$impl$ioc_helpers117711",Ei.Gb=function(b){return Rb(b,"cljs.core.async.impl.ioc-helpers/t_cljs$core$async$impl$ioc_helpers117711")};return new Ei(a,je)}function Gi(a){try{var b=a[0];return b.a?b.a(a):b.call(null,a)}catch(c){if(c instanceof Object)throw b=c,a[6].rb(null),b;throw c;}}function Hi(a,b){b=zi(b,Fi(function(c){a[2]=c;a[1]=4;return Gi(a)}));return H(b)?(a[2]=Cb(b),a[1]=4,mh):null}
function Ii(a,b){a=a[6];null!=b&&a.Sb(null,b,Fi(function(){return null}));a.rb(null);return a}
function Ji(a){for(;;){var b=a[4],c=kh.a(b),d=Eh.a(b),e=a[5];if(H(function(){var f=e;return H(f)?bb(b):f}()))throw e;if(H(function(){var f=e;return H(f)?(f=c,H(f)?zc.b(Vg,d)||e instanceof d:f):f}())){a[1]=c;a[2]=e;a[5]=null;a[4]=$c.o(b,kh,null,Vc([Eh,null]));break}if(H(function(){var f=e;return H(f)?bb(c)&&bb(Mh.a(b)):f}()))a[4]=ph.a(b);else{if(H(function(){var f=e;return H(f)?bb(c)?Mh.a(b):!1:f}())){a[1]=Mh.a(b);a[4]=$c.f(b,Mh,null);break}if(H(bb(e)?Mh.a(b):!1)){a[1]=Mh.a(b);a[4]=$c.f(b,Mh,null);
break}if(bb(e)&&bb(Mh.a(b))){a[1]=Ch.a(b);a[4]=ph.a(b);break}throw Error("No matching clause");}}};function Ki(a){a=zc.b(a,0)?null:a;return Ci("number"===typeof a?new fi(new ei(Array(a)),a):a)}
var Li=function(a){if("undefined"===typeof Na||"undefined"===typeof Oa||"undefined"===typeof Vh||"undefined"===typeof Wh)Wh=function(b,c,d){this.Aa=b;this.Wb=c;this.Nc=d;this.i=393216;this.w=0},Wh.prototype.S=function(b,c){return new Wh(this.Aa,this.Wb,c)},Wh.prototype.N=function(){return this.Nc},Wh.prototype.fc=function(){return!0},Wh.prototype.Rb=function(){return this.Wb},Wh.prototype.gc=function(){return this.Aa},Wh.Tb=function(){return new ge(null,3,5,he,[Ph,Fh,gh],null)},Wh.sb=!0,Wh.Xa="cljs.core.async/t_cljs$core$async117929",
Wh.Gb=function(b){return Rb(b,"cljs.core.async/t_cljs$core$async117929")};return new Wh(a,!0,je)}(function(){return null});var Mi=/[\s]/;function Ni(a){return null==a?null:","===a?!0:Mi.test(a)}function Oi(a){return null==a?null:!/[^0-9]/.test(a)}
function Pi(a,b){return function e(d){return new Jd(null,function(){for(;;){var f=O(d);if(f){if(kd(f)){var h=Zb(f),k=W(h),l=new Ld(Array(k));return function(){for(var p=0;;)if(p<k){var q=ob.b(h,p),x=l;if(q instanceof sc||q instanceof M){var z=cg()(q),E=X(z,0,null);z=X(z,1,null);var K=q instanceof sc?uc:Hd;q=null==E?K.b?K.b(a,z):K.call(null,a,z):zc.b("_",E)?K.a?K.a(z):K.call(null,z):q}x.add(q);p+=1}else return!0}()?Od(l.za(),e($b(f))):Od(l.za(),null)}var m=R(f);return Uc(m instanceof sc||m instanceof
M?function(){var p=cg()(m),q=X(p,0,null);p=X(p,1,null);var x=m instanceof sc?uc:Hd;return null==q?x.b?x.b(a,p):x.call(null,a,p):zc.b("_",q)?x.a?x.a(p):x.call(null,p):m}():m,e(xc(f)))}return null}},null,null)}(b)}function Qi(a,b){a=parseInt(a,b);return H(isNaN(a))?-1:a};var Ri=function Ri(a){if(null!=a&&null!=a.Ya)return a.Ya(a);var c=Ri[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Ri._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("Reader.read-char",a);},Si=function Si(a){if(null!=a&&null!=a.tb)return a.tb(a);var c=Si[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Si._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("Reader.peek-char",a);},Ti=function Ti(a,b){if(null!=a&&null!=a.hc)return a.hc(a,b);var d=Ti[ba(null==
a?null:a)];if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);d=Ti._;if(null!=d)return d.b?d.b(a,b):d.call(null,a,b);throw db("IPushbackReader.unread",a);},Ui=function Ui(a){if(null!=a&&null!=a.Ic)return a.Ic(a);var c=Ui[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Ui._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IndexingReader.get-line-number",a);},Vi=function Vi(a){if(null!=a&&null!=a.Gc)return a.Gc(a);var c=Vi[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,
a);c=Vi._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IndexingReader.get-column-number",a);},Wi=function Wi(a){if(null!=a&&null!=a.Hc)return a.Hc(a);var c=Wi[ba(null==a?null:a)];if(null!=c)return c.a?c.a(a):c.call(null,a);c=Wi._;if(null!=c)return c.a?c.a(a):c.call(null,a);throw db("IndexingReader.get-file-name",a);};function Xi(a,b){this.B=a;this.lc=b;this.jb=0}Xi.prototype.Ya=function(){if(this.lc>this.jb){var a=this.B.charAt(this.jb);this.jb+=1;return a}return null};
Xi.prototype.tb=function(){return this.lc>this.jb?this.B.charAt(this.jb):null};function Yi(a,b){this.jc=a;this.D=b;this.Fa=this.Nb=1}Yi.prototype.Ya=function(){var a=this.Fa<this.Nb?this.D[this.Fa]:this.jc.Ya(null);this.Fa<this.Nb&&(this.Fa+=1);return null==a?null:yd(a)};Yi.prototype.tb=function(){var a=this.Fa<this.Nb?this.D[this.Fa]:this.jc.tb(null);return null==a?null:yd(a)};
Yi.prototype.hc=function(a,b){if(H(b)){if(0===this.Fa)throw Error("Pushback buffer is full");--this.Fa;return this.D[this.Fa]=b}return null};function Zi(a){return null!=a?v===a.gd?!0:!1:!1};function $i(a,b,c,d){var e=W(b);a=H(a)?0:10<e?10:e;b=te.b(oe(),ue(a,b));b=be(J,ve(1,xe.b(new we(null,-1," ",null),b)));e=a<e?"...":null;return[J.a(c),J.a(b),e,J.a(d)].join("")}function Ug(a,b){return null==b?sh:"string"===typeof b?eh:b instanceof M?Ah:"number"===typeof b?Ah:b instanceof sc?Ah:jd(b)?Ih:Bd(b)?wh:hd(b)?dh:fd(b)?zh:zc.b(b,!0)?Ah:zc.b(b,!1)?Ah:null==b?null:b.constructor}var pe,Qg=new qe(je),Rg=new qe(je),Sg=new qe(je),Tg=new qe(je),Pg=tc.f(je,xh,Dg.u?Dg.u():Dg.call(null));pe=new Og;
Xg(eh,function(a,b){a=H(a)?5:20;var c=b.length>a?'..."':'"',d=b.length;return['"',J.a(b.substring(0,a<d?a:d)),c].join("")});Xg(Ah,function(a,b){return J.a(b)});Xg(wc,function(){return"\x3cindexed seq\x3e"});Xg(jf,function(){return"\x3cmap seq\x3e"});Xg(Kf,function(){return"\x3cmap seq\x3e"});Xg(Ed,function(){return"\x3ccons\x3e"});Xg(Jd,function(){return"\x3clazy seq\x3e"});Xg(sh,function(){return"nil"});Xg(wh,function(a,b){return $i(a,b,"(",")")});
Xg(dh,function(a,b){var c=W(b),d=H(a)?0:c;b=be(Td,ue(d,b));return $i(a,b,"{",c>d?"...}":"}")});Xg(zh,function(a,b){return $i(a,b,"#{","}")});Xg(Ih,function(a,b){return $i(a,b,"[","]")});Xg(Vg,function(a,b){return sg(Vc([null==b?null:b.constructor]))});function aj(a){return pe.b?pe.b(!1,a):pe.call(null,!1,a)};function bj(a,b,c){b=new Ua(null,2,[Sh,uh,nh,b],null);a=Zi(a)?$c.o(b,Gh,Wi(a),Vc([ch,Ui(a),hh,Vi(a)])):b;var d=Gh.a(a);b=ch.a(a);var e=hh.a(a);d=H(d)?[J.a(d)," "].join(""):null;b=H(b)?["[line ",J.a(b),", col ",J.a(e),"]"].join(""):null;c=de(J,d,b,H(H(d)?d:b)?" ":null,c);throw new Zg(c,a,null);}function cj(a,b){return bj(a,Th,Vc([be(J,b)]))}function dj(a,b){return bj(a,th,Vc([be(J,b)]))}function ej(a,b){return bj(a,Oh,Vc([be(J,b)]))}
function fj(a,b,c,d){cj(a,Vc(["The map literal starting with ",aj(R(d)),H(b)?[" on line ",J.a(b)," column ",J.a(c)].join(""):null," contains ",W(d)," form(s). Map literals must contain an even number of forms."]))}function gj(a,b,c){return cj(a,Vc(["Invalid ",Id(b),": ",c,"."]))}function hj(a,b,c){return cj(a,Vc(["Invalid character: ",c," found while reading ",Id(b),"."]))}
function ij(a,b){a:{var c=eh instanceof M?eh.Ma:null;switch(c){case "regex":c='#"';break a;case "string":c='"';break a;default:throw Error(["No matching clause: ",J.a(c)].join(""));}}return ej(a,Vc(["Unexpected EOF reading ",Id(eh)," starting ",ce(J,c,b),"."]))}function jj(a,b){return dj(a,Vc(["Invalid digit ",b," in unicode character."]))}function kj(a){return cj(a,Vc(["Octal escape sequence must be in range [0, 377]."]))}
function lj(a,b){b=function(c){return function f(e){return new Jd(null,function(){for(var h=e;;)if(h=O(h)){if(kd(h)){var k=Zb(h),l=W(k),m=new Ld(Array(l));a:for(var p=0;;)if(p<l){var q=ob.b(k,p),x=X(q,0,null);1<X(q,1,null)&&m.add(x);p+=1}else{k=!0;break a}return k?Od(m.za(),f($b(h))):Od(m.za(),null)}m=R(h);k=X(m,0,null);if(1<X(m,1,null))return Uc(k,f(xc(h)));h=xc(h)}else return null},null,null)}(bg(c))}(b);return de(J,a,1<W(b)?"s":null,": ",ve(1,xe.b(new we(null,-1,", ",null),b)))}
function mj(a,b,c){b=Id(b);cj(a,Vc([lj([String(b.charAt(0)).toUpperCase()+String(b.substr(1)).toLowerCase()," literal contains duplicate key"].join(""),c)]))};function nj(a){for(var b=a.Ya(null);;)if(Ni.a?Ni.a(b):Ni.call(null,b))b=a.Ya(null);else return b}var oj=/^([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?$/,pj=/([-+]?[0-9]+)\/([0-9]+)/,qj=/([-+]?[0-9]+(\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?/;function rj(a,b){a=eg(a,b);return X(a,0,null)===b}
function sj(a){if(rj(oj,a)){var b=Qe(eg(oj,a));if(null!=(b.a?b.a(2):b.call(null,2)))a=0;else{a="-"===(b.a?b.a(1):b.call(null,1));b=null!=(b.a?b.a(3):b.call(null,3))?new ge(null,2,5,he,[b.a?b.a(3):b.call(null,3),10],null):null!=(b.a?b.a(4):b.call(null,4))?new ge(null,2,5,he,[b.a?b.a(4):b.call(null,4),16],null):null!=(b.a?b.a(5):b.call(null,5))?new ge(null,2,5,he,[b.a?b.a(5):b.call(null,5),8],null):null!=(b.a?b.a(7):b.call(null,7))?new ge(null,2,5,he,[b.a?b.a(7):b.call(null,7),parseInt(b.a?b.a(6):b.call(null,
6))],null):new ge(null,2,5,he,[null,null],null);var c=b.a?b.a(0):b.call(null,0);null==c?a=null:(b=parseInt(c,b.a?b.a(1):b.call(null,1)),a=a?-1*b:b,a=H(isNaN(a))?null:a)}}else rj(qj,a)?(b=Qe(eg(qj,a)),a=null!=(b.a?b.a(4):b.call(null,4))?parseFloat(b.a?b.a(1):b.call(null,1)):parseFloat(a)):rj(pj,a)?(b=Qe(eg(pj,a)),a=b.a?b.a(1):b.call(null,1),b=b.a?b.a(2):b.call(null,2),a=H(eg(/^\+/,a))?a.substring(1):a,a=parseInt(a)/parseInt(b)):a=null;return a}
function tj(a){if(""===a||!0===/:$/.test(a)||!0===/^::/.test(a))return null;var b=a.indexOf("/"),c=0<b?a.substring(0,b):null;if(null!=c){b+=1;if(b===W(a))return null;a=a.substring(b);return Oi(Pc(a,0))||""===a||!1!==/:$/.test(c)||"/"!==a&&-1!==a.indexOf("/")?null:new ge(null,2,5,he,[c,a],null)}return"/"===a||-1===a.indexOf("/")?new ge(null,2,5,he,[null,a],null):null}
var uj=function uj(a){for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return uj.o(arguments[0],1<c.length?new wc(c.slice(1),0,null):null)};uj.o=function(a){for(;;){var b=a.Ya(null);if("\n"===b||"\n"===b||null==b)break}return a};uj.H=1;uj.G=function(a){var b=R(a);a=U(a);return this.o(b,a)};
function vj(){return function(){function a(c,d){var e=null;if(1<arguments.length){e=0;for(var f=Array(arguments.length-1);e<f.length;)f[e]=arguments[e+1],++e;e=new wc(f,0,null)}return b.call(this,c,e)}function b(c){return cj(c,Vc(["Unreadable form"]))}a.H=1;a.G=function(c){var d=R(c);c=xc(c);return b(d,c)};a.o=b;return a}()};new Ma;function wj(a){return"#"!==a?"'"!==a?":"!==a?xj.a?xj.a(a):xj.call(null,a):!1:!1:!1}function yj(a){return"@"===a||"`"===a||"~"===a}function zj(a,b,c,d){if(bb(c))return ej(a,Vc(["Unexpected EOF while reading start of ",Id(b),"."]));if(H(H(d)?yj(c):d))return hj(a,b,c);d=new Ma;for(Ti(a,c);;){if(Ni(c)||wj(c)||null==c)return J.a(d);if(yj(c))return hj(a,b,c);d.append(Ri(a));c=Si(a)}}
function Aj(a,b,c){b=Ri(a);if(H(b)){var d=Bj.a?Bj.a(b):Bj.call(null,b);if(H(d))return d.f?d.f(a,b,c):d.call(null,a,b,c);Ti(a,b);c=Cj.f?Cj.f(a,b,c):Cj.call(null,a,b,c);return H(c)?c:cj(a,Vc(["No dispatch macro for ",b,"."]))}return ej(a,Vc(["Unexpected EOF while reading dispatch character."]))}function Dj(a,b){return cj(a,Vc(["Unmatched delimiter ",b,"."]))}
function Ej(a,b,c){b=1+b;if(W(a)!==b)throw dj(null,Vc(["Invalid unicode literal: \\",a,"."]));for(var d=1,e=0;;){if(d===b)return String.fromCharCode(e);var f=Qi(Pc(a,d),c);if(-1===f)return c=Pc(a,d),dj(null,Vc(["Invalid digit ",c," in unicode character \\",a,"."]));e=f+e*c;d+=1}}
function Fj(a,b,c,d,e){for(var f=1,h=Qi(b,c);;){if(-1===h)return jj(a,b);if(f!==d){var k=Si(a);var l=Ni(k);l||(l=xj.a?xj.a(k):xj.call(null,k),l=H(l)?l:null==k);if(H(l))return H(e)?dj(a,Vc(["Invalid unicode literal. Unicode literals should be ",d,"characters long.  ","value suppled is ",f,"characters long."])):String.fromCharCode(h);l=Qi(k,c);Ri(a);if(-1===l)return jj(a,k);h=l+h*c;f+=1}else return String.fromCharCode(h)}}
function Gj(a){var b=Ri(a);if(null!=b){b=wj(b)||yj(b)||Ni(b)?J.a(b):zj(a,vh,b,!1);var c=b.length;if(1===c)return Pc(b,0);if("newline"===b)return"\n";if("space"===b)return" ";if("tab"===b)return"\t";if("backspace"===b)return"\b";if("formfeed"===b)return"\f";if("return"===b)return"\r";if(H(0==b.lastIndexOf("u",0)))return b=Ej(b,4,16),c=b.charCodeAt(),55295<c&&57344>c?(b=c.toString(16),a=cj(a,Vc(["Invalid character literal \\u",b,"."]))):a=b,a;if(H(0==b.lastIndexOf("o",0))){--c;if(3<c)return cj(a,Vc(["Invalid octal escape sequence in a character literal:",
b,". Octal escape sequences must be 3 or fewer digits."]));b=Ej(b,c,8);return 255<(b|0)?kj(a):b}return cj(a,Vc(["Unsupported character: ",b,"."]))}return ej(a,Vc(["Unexpected EOF while reading character."]))}function Hj(a){return Zi(a)?new ge(null,2,5,he,[Ui(a),(Vi(a)|0)-1|0],null):null}
function Ij(a,b,c,d){var e=Hj(c),f=X(e,0,null);e=X(e,1,null);b=null==b?null:yd(b);for(var h=Ub(Xc);;){var k=nj(c);if(!H(k)){var l=a,m=f,p=e,q=W(h);ej(c,Vc(["Unexpected EOF while reading ",H(q)?["item ",J.a(q)," of "].join(""):null,Id(l),H(m)?[", starting at line ",J.a(m)," and column ",J.a(p)].join(""):null,"."]))}if(zc.b(b,null==k?null:yd(k)))return Wb(h);l=xj.a?xj.a(k):xj.call(null,k);H(l)?(k=l.f?l.f(c,k,d):l.call(null,c,k,d),h=k!==c?Ud.b(h,k):h):(Ti(c,k),k=Jj?Jj(c,!0,null,d):Kj.call(null,c,!0,
null,d),h=k!==c?Ud.b(h,k):h)}}function Lj(a,b,c){a=Ij(wh,")",a,c);return null==a||bb(O(a))?yc:be(Dd,a)}function Mj(a,b,c){return Ij(Ih,"]",a,c)}function Nj(a,b,c){var d=Hj(a);b=X(d,0,null);d=X(d,1,null);c=Ij(dh,"}",a,c);var e=W(c),f=ag(2,c),h=$f(f);!me(e)&&fj(a,b,d,c);zc.b(W(h),W(f))||mj(a,dh,f);if(e<=2*of)a=Qd(c),a=new Ua(null,a.length/2,a,null);else a:for(a=Qd(c),b=a.length,d=0,e=Ub(pf);;)if(d<b)c=d+2,e=Xb(e,a[d],a[d+1]),d=c;else{a=Wb(e);break a}return a}
function Oj(a,b){for(var c=function(){var h=new Ma;h.append(b);return h}(),d=Ri(a);;){if(H(function(){var h=Ni(d);if(h)return h;h=xj.a?xj.a(d):xj.call(null,d);return H(h)?h:null==d}())){var e=J.a(c);Ti(a,d);var f=sj(e);return H(f)?f:cj(a,Vc(["Invalid number: ",e,"."]))}e=function(){var h=c;h.append(d);return h}();f=Ri(a);c=e;d=f}}
function Pj(a){var b=Ri(a);switch(b){case "t":return"\t";case "r":return"\r";case "n":return"\n";case "\\":return"\\";case '"':return'"';case "b":return"\b";case "f":return"\f";case "u":return b=Ri(a),-1===parseInt(b|0,16)?cj(a,Vc(["Invalid unicode escape: \\u",b,"."])):Fj(a,b,16,4,!0);default:return Oi(b)?(b=Fj(a,b,8,3,!1),255<(b|0)?kj(a):b):cj(a,Vc(["Unsupported escape character: \\",b,"."]))}}
function Qj(a){for(var b=new Ma,c=Ri(a);;){var d=c;if(zc.b(null,d))return ij(a,Vc(['"',b]));if(zc.b("\\",d)){d=function(){var f=b;f.append(Pj(a));return f}();var e=Ri(a);b=d;c=e}else{if(zc.b('"',d))return J.a(b);d=function(){var f=b;f.append(c);return f}();e=Ri(a);b=d;c=e}}}
function Rj(a,b){b=zj(a,Dh,b,!0);if(H(b))switch(b){case "nil":return null;case "true":return!0;case "false":return!1;case "/":return rh;default:var c=tj(b);c=H(c)?uc.b(c.a?c.a(0):c.call(null,0),c.a?c.a(1):c.call(null,1)):null;return H(c)?c:gj(a,Dh,b)}else return null}
function Sj(a){var b=Ri(a);if(Ni(b))return cj(a,Vc(["A single colon is not a valid keyword."]));b=zj(a,Rh,b,!0);var c=tj(b);if(H(H(c)?-1===b.indexOf("::"):c)){var d=c.a?c.a(0):c.call(null,0);c=c.a?c.a(1):c.call(null,1);return":"===Pc(b,0)?gj(a,Rh,b):Hd.b(d,c)}return gj(a,Rh,b)}
function Tj(a,b,c){b=Jj?Jj(a,!0,null,c):Kj.call(null,a,!0,null,c);b=b instanceof M?ad([b,!0]):b instanceof sc?new Ua(null,1,[ih,b],null):"string"===typeof b?new Ua(null,1,[ih,b],null):b;hd(b)||cj(a,Vc(["Metadata cannot be ",aj(b),". Metadata must be a Symbol, Keyword, String or Map."]));c=Jj?Jj(a,!0,null,c):Kj.call(null,a,!0,null,c);return null!=c&&(c.i&131072||v===c.bc)?dd(c,Vf.o(Vc([ed(c),b]))):cj(a,Vc(["Metadata can not be applied to ",aj(c),". ","Metadata can only be applied to IMetas."]))}
function Uj(a,b,c){b=Ij(zh,"}",a,c);c=$f(b);zc.b(W(b),W(c))||mj(a,zh,b);return c}function Vj(a){Jj?Jj(a,!0,null,!0):Kj.call(null,a,!0,null,!0);return a}
function Wj(a,b,c){b=Ri(a);b=zj(a,fh,b,!0);var d=null==b?null:tj(b);if(null==d)var e=null;else e=X(d,0,null),d=X(d,1,null),e=H(e)?null:d;if(H(e)){if("{"===nj(a)){b=Ij(fh,"}",a,c);!me(W(b))&&fj(a,null,null,b);c=Pi(J.a(e),ag(2,b));b=ag(2,xc(b));zc.b(W($f(c)),W(c))||mj(a,fh,c);a:for(a=Ub(je),c=O(c),b=O(b);;)if(c&&b)a=Vd(a,R(c),R(b)),c=U(c),b=U(b);else{a=Wb(a);break a}return a}return cj(a,Vc(["Namespaced map with namespace ",b," does not specify a map."]))}return cj(a,Vc(["Invalid value used as namespace in namespaced map: ",
b,"."]))}function Xj(a,b,c){b=Jj?Jj(a,!0,null,c):Kj.call(null,a,!0,null,c);return zc.b(Lh,b)?Number.NaN:zc.b(oh,b)?Number.NEGATIVE_INFINITY:zc.b(qh,b)?Number.POSITIVE_INFINITY:cj(a,Vc([["Invalid token: ##",J.a(b)].join("")]))}
function xj(a){switch(a){case '"':return Qj;case ":":return Sj;case ";":return uj;case "^":return Tj;case "(":return Lj;case ")":return Dj;case "[":return Mj;case "]":return Dj;case "{":return Nj;case "}":return Dj;case "\\":return Gj;case "#":return Aj;default:return null}}function Bj(a){switch(a){case "^":return Tj;case "{":return Uj;case "\x3c":return vj();case "!":return uj;case "_":return Vj;case ":":return Wj;case "#":return Xj;default:return null}}
function Cj(a,b,c){b=Jj?Jj(a,!0,null,c):Kj.call(null,a,!0,null,c);var d=Jj?Jj(a,!0,null,c):Kj.call(null,a,!0,null,c);b instanceof sc||cj(a,Vc(["Invalid reader tag: ",aj("Reader tag must be a symbol"),". Reader tags must be symbols."]));var e=tc.b(bh.a(c),b);e=H(e)?e:je.a?je.a(b):je.call(null,b);if(H(e))return e.a?e.a(d):e.call(null,d);c=Vg.a(c);return H(c)?c.b?c.b(b,d):c.call(null,b,d):cj(a,Vc(["No reader function for tag ",aj(b),"."]))}
function Kj(a){switch(arguments.length){case 1:return Yj(je,arguments[0]);case 2:return Yj(arguments[0],arguments[1]);case 4:return Jj(arguments[0],arguments[1],arguments[2],arguments[3]);default:throw Error(["Invalid arity: ",J.a(arguments.length)].join(""));}}function Yj(a,b){a=null!=a&&(a.i&64||v===a.Wa)?be(Sf,a):a;var c=tc.b(a,Oh),d=!od(a,Oh);return Jj(b,d,c,a)}
function Jj(a,b,c,d){try{for(;;){var e=Ri(a);if(!Ni(e)){if(null==e){if(H(b)){b=a;var f=H(null)?ej(b,Vc(["EOF while reading, starting at line ",null,"."])):ej(b,Vc(["EOF while reading."]))}else f=c;return f}if(Oi(e)||("+"===e||"-"===e)&&Oi(a.tb(null)))return Oj(a,e);var h=xj(e);if(H(h)){var k=h.f?h.f(a,e,d):h.call(null,a,e,d);if(k!==a)return k}else return Rj(a,e)}}}catch(l){if(l instanceof Error){f=l;if(f instanceof Zg){b=f instanceof Zg?f.data:null;if(zc.b(uh,Sh.a(b)))throw f;a=Vf.o(Vc([new Ua(null,
1,[Sh,uh],null),b,Zi(a)?new Ua(null,3,[ch,Ui(a),yh,Vi(a),Gh,Wi(a)],null):null]));throw new Zg(f.message,a,f);}a=Vf.o(Vc([new Ua(null,1,[Sh,uh],null),Zi(a)?new Ua(null,3,[ch,Ui(a),yh,Vi(a),Gh,Wi(a)],null):null]));throw new Zg(f.message,a,f);}throw l;}};var Zj=function(){var a=new ge(null,13,5,he,[null,31,28,31,30,31,30,31,31,30,31,30,31],null),b=new ge(null,13,5,he,[null,31,29,31,30,31,30,31,31,30,31,30,31],null);return function(c,d){return tc.b(H(d)?b:a,c)}}(),ak=/(\d\d\d\d)(?:-(\d\d)(?:-(\d\d)(?:[T](\d\d)(?::(\d\d)(?::(\d\d)(?:[.](\d+))?)?)?)?)?)?(?:[Z]|([-+])(\d\d):(\d\d))?/;function bk(a){a=parseInt(a,10);return bb(isNaN(a))?a:null}
function ck(a,b,c,d){if(!(a<=b&&b<=c))throw Error([J.a(d)," Failed:  ",J.a(a),"\x3c\x3d",J.a(b),"\x3c\x3d",J.a(c)].join(""));return b}
function dk(a){var b=dg(ak,a);X(b,0,null);var c=X(b,1,null),d=X(b,2,null),e=X(b,3,null),f=X(b,4,null),h=X(b,5,null),k=X(b,6,null),l=X(b,7,null),m=X(b,8,null),p=X(b,9,null),q=X(b,10,null);if(bb(b))throw Error(["Unrecognized date/time syntax: ",J.a(a)].join(""));a=bk(c);b=function(){var F=bk(d);return H(F)?F:1}();c=function(){var F=bk(e);return H(F)?F:1}();var x=function(){var F=bk(f);return H(F)?F:0}(),z=function(){var F=bk(h);return H(F)?F:0}(),E=function(){var F=bk(k);return H(F)?F:0}(),K=function(){a:if(zc.b(3,
W(l)))var F=l;else if(3<W(l))F=l.substring(0,3);else for(F=new Ma(l);;)if(3>F.getLength())F=F.append("0");else{F=F.toString();break a}F=bk(F);return H(F)?F:0}();m=(zc.b(m,"-")?-1:1)*(60*function(){var F=bk(p);return H(F)?F:0}()+function(){var F=bk(q);return H(F)?F:0}());return new ge(null,8,5,he,[a,ck(1,b,12,"timestamp month field must be in range 1..12"),ck(1,c,Zj(b,0===(a%4+4)%4&&(0!==(a%100+100)%100||0===(a%400+400)%400)),"timestamp day field must be in range 1..last day in month"),ck(0,x,23,"timestamp hour field must be in range 0..23"),
ck(0,z,59,"timestamp minute field must be in range 0..59"),ck(0,E,zc.b(z,59)?60:59,"timestamp second field must be in range 0..60"),ck(0,K,999,"timestamp millisecond field must be in range 0..999"),m],null)}
var ek=new qe(null),fk=new qe(Vf.o(Vc([new Ua(null,4,[lh,function(a){if("string"===typeof a){var b=dk(a);if(H(b)){a=X(b,0,null);var c=X(b,1,null),d=X(b,2,null),e=X(b,3,null),f=X(b,4,null),h=X(b,5,null),k=X(b,6,null);b=X(b,7,null);b=new Date(Date.UTC(a,c-1,d,e,f,h,k)-6E4*b)}else throw Error(["Unrecognized date/time syntax: ",J.a(a)].join(""));return b}throw Error("Instance literal expects a string for its timestamp.");},Jh,function(a){if("string"===typeof a)return new Yg(a.toLowerCase());throw Error("UUID literal expects a string as its representation.");
},Nh,function(a){if(jd(a))return ye(bf,a);throw Error("Queue literal expects a vector for its elements.");},Qh,function(a){if(jd(a)){var b=[];a=O(a);for(var c=null,d=0,e=0;;)if(e<d){var f=c.K(null,e);b.push(f);e+=1}else if(a=O(a))c=a,kd(c)?(a=Zb(c),e=$b(c),c=a,d=W(a),a=e):(a=R(c),b.push(a),a=U(c),c=null,d=0),e=0;else break;return b}if(hd(a)){b={};a=O(a);c=null;for(e=d=0;;)if(e<d){var h=c.K(null,e);f=X(h,0,null);h=X(h,1,null);var k=b;f=Id(f);k[f]=h;e+=1}else if(a=O(a))kd(a)?(d=Zb(a),a=$b(a),c=d,d=
W(d)):(d=R(a),c=X(d,0,null),d=X(d,1,null),e=b,c=Id(c),e[c]=d,a=U(a),c=null,d=0),e=0;else break;return b}throw Error("JS literal expects a vector or map containing only string or unqualified keyword keys");}],null),je])));var gk=__webpack_require__(278);var hk=__webpack_require__(427);var ik=function ik(a){for(var c=[],d=arguments.length,e=0;;)if(e<d)c.push(arguments[e]),e+=1;else break;return ik.o(0<c.length?new wc(c.slice(0),0,null):null)};
ik.o=function(){var a=Ki(null);(function(){var b=Ki(1);ri(function(){var c=function(){function e(f){var h=f[1];if(1===h)return f[7]="",f[2]=null,f[1]=2,mh;if(2===h)return Hi(f,a);if(3===h)return Ii(f,f[2]);if(4===h)return h=f[2],f[8]=h,f[1]=H(null==h)?5:6,mh;if(5===h)return f[2]=null,f[1]=7,mh;if(6===h){var k=f[7];h=f[8];a:for(var l=k;;){k=h.indexOf("\n");k=0>k?null:k;if(bb(k)){h=[J.a(l),J.a(h)].join("");break a}var m=[J.a(l),h.substring(0,k)].join("");l=new Ua(null,3,[bh,Cb(fk),Vg,Cb(ek),Oh,null],
null);if(H(H(m)?!zc.b(m,""):m)){m=new Xi(m,W(m));var p=Array(1);for(var q=0;;)if(1>q)p[q]=null,q+=1;else break;l=Yj(l,new Yi(m,p))}else l=null;p=null!=l&&(l.i&64||v===l.Wa)?be(Sf,l):l;l=tc.b(p,ah);m=tc.b(p,Gh);p=tc.b(p,Bh);m={presets:[bb(p)?hk:[hk,Ag(p)]],plugins:[],babelrc:!1,filename:m,highlightCode:!1,inputSourceMap:!0,sourceMaps:!0};l=gk.transform(l,m);l=new Ua(null,2,[ah,l.code,Uh,JSON.stringify(l.map)],null);ig(sg(Vc([l])));H(Ra)&&(l=Ta(),ig("\n"),tc.b(l,Va));h=h.substring(k+1);l=""}f[7]=h;
f[2]=null;f[1]=2;return mh}return 7===h?(f[2]=f[2],f[1]=3,mh):null}return function(){function f(l){for(;;){a:try{for(;;){var m=e(l);if(!Fd(m,mh)){var p=m;break a}}}catch(q){if(q instanceof Object)l[5]=q,Ji(l),p=mh;else throw q;}if(!Fd(p,mh))return p}}function h(){var l=[null,null,null,null,null,null,null,null,null];l[0]=k;l[1]=1;return l}var k=null;k=function(l){switch(arguments.length){case 0:return h.call(this);case 1:return f.call(this,l)}throw Error("Invalid arity: "+arguments.length);};k.u=h;
k.a=f;return k}()}(),d=function(){var e=c();e[6]=b;return e}();return Gi(d)});return b})();process.stdin.on("data",function(b){b=Yh(a,b.toString(),Li);return H(b)?Cb(b):!0});return process.stdin.on("close",function(){return Zh(a)})};ik.H=0;ik.G=function(a){return this.o(O(a))};be(ik,process.argv.slice(2));
})();


/***/ }),
/* 131 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createItemFromDescriptor = createItemFromDescriptor;
exports.createConfigItem = createConfigItem;
exports.getItemDescriptor = getItemDescriptor;

function _path() {
  const data = _interopRequireDefault(__webpack_require__(267));

  _path = function () {
    return data;
  };

  return data;
}

var _configDescriptors = __webpack_require__(791);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createItemFromDescriptor(desc) {
  return new ConfigItem(desc);
}

function createConfigItem(value, {
  dirname = ".",
  type
} = {}) {
  const descriptor = (0, _configDescriptors.createDescriptor)(value, _path().default.resolve(dirname), {
    type,
    alias: "programmatic item"
  });
  return createItemFromDescriptor(descriptor);
}

function getItemDescriptor(item) {
  if (item instanceof ConfigItem) {
    return item._descriptor;
  }

  return undefined;
}

class ConfigItem {
  constructor(descriptor) {
    this._descriptor = descriptor;
    Object.defineProperty(this, "_descriptor", {
      enumerable: false
    });
    this.value = this._descriptor.value;
    this.options = this._descriptor.options;
    this.dirname = this._descriptor.dirname;
    this.name = this._descriptor.name;
    this.file = this._descriptor.file ? {
      request: this._descriptor.file.request,
      resolved: this._descriptor.file.resolved
    } : undefined;
    Object.freeze(this);
  }

}

Object.freeze(ConfigItem.prototype);

/***/ }),
/* 132 */,
/* 133 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = annotateAsPure;

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const PURE_ANNOTATION = "#__PURE__";

const isPureAnnotated = ({
  leadingComments
}) => !!leadingComments && leadingComments.some(comment => /[@#]__PURE__/.test(comment.value));

function annotateAsPure(pathOrNode) {
  const node = pathOrNode.node || pathOrNode;

  if (isPureAnnotated(node)) {
    return;
  }

  t.addComment(node, "leading", PURE_ANNOTATION);
}

/***/ }),
/* 134 */,
/* 135 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var core = __webpack_require__(391);
var fs = __webpack_require__(747);
var path = __webpack_require__(267);
var caller = __webpack_require__(200);
var nodeModulesPaths = __webpack_require__(575);
var normalizeOptions = __webpack_require__(666);

var defaultIsFile = function isFile(file, cb) {
    fs.stat(file, function (err, stat) {
        if (!err) {
            return cb(null, stat.isFile() || stat.isFIFO());
        }
        if (err.code === 'ENOENT' || err.code === 'ENOTDIR') return cb(null, false);
        return cb(err);
    });
};

var defaultIsDir = function isDirectory(dir, cb) {
    fs.stat(dir, function (err, stat) {
        if (!err) {
            return cb(null, stat.isDirectory());
        }
        if (err.code === 'ENOENT' || err.code === 'ENOTDIR') return cb(null, false);
        return cb(err);
    });
};

var maybeUnwrapSymlink = function maybeUnwrapSymlink(x, opts, cb) {
    if (opts && opts.preserveSymlinks === false) {
        fs.realpath(x, function (realPathErr, realPath) {
            if (realPathErr && realPathErr.code !== 'ENOENT') cb(realPathErr);
            else cb(null, realPathErr ? x : realPath);
        });
    } else {
        cb(null, x);
    }
};

module.exports = function resolve(x, options, callback) {
    var cb = callback;
    var opts = options;
    if (typeof options === 'function') {
        cb = opts;
        opts = {};
    }
    if (typeof x !== 'string') {
        var err = new TypeError('Path must be a string.');
        return process.nextTick(function () {
            cb(err);
        });
    }

    opts = normalizeOptions(x, opts);

    var isFile = opts.isFile || defaultIsFile;
    var isDirectory = opts.isDirectory || defaultIsDir;
    var readFile = opts.readFile || fs.readFile;

    var extensions = opts.extensions || ['.js'];
    var basedir = opts.basedir || path.dirname(caller());
    var parent = opts.filename || basedir;

    opts.paths = opts.paths || [];

    // ensure that `basedir` is an absolute path at this point, resolving against the process' current working directory
    var absoluteStart = path.resolve(basedir);

    maybeUnwrapSymlink(
        absoluteStart,
        opts,
        function (err, realStart) {
            if (err) cb(err);
            else init(realStart);
        }
    );

    var res;
    function init(basedir) {
        if ((/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/).test(x)) {
            res = path.resolve(basedir, x);
            if (x === '..' || x.slice(-1) === '/') res += '/';
            if ((/\/$/).test(x) && res === basedir) {
                loadAsDirectory(res, opts.package, onfile);
            } else loadAsFile(res, opts.package, onfile);
        } else loadNodeModules(x, basedir, function (err, n, pkg) {
            if (err) cb(err);
            else if (core[x]) return cb(null, x);
            else if (n) {
                return maybeUnwrapSymlink(n, opts, function (err, realN) {
                    if (err) {
                        cb(err);
                    } else {
                        cb(null, realN, pkg);
                    }
                });
            } else {
                var moduleError = new Error("Cannot find module '" + x + "' from '" + parent + "'");
                moduleError.code = 'MODULE_NOT_FOUND';
                cb(moduleError);
            }
        });
    }

    function onfile(err, m, pkg) {
        if (err) cb(err);
        else if (m) cb(null, m, pkg);
        else loadAsDirectory(res, function (err, d, pkg) {
            if (err) cb(err);
            else if (d) {
                maybeUnwrapSymlink(d, opts, function (err, realD) {
                    if (err) {
                        cb(err);
                    } else {
                        cb(null, realD, pkg);
                    }
                });
            } else {
                var moduleError = new Error("Cannot find module '" + x + "' from '" + parent + "'");
                moduleError.code = 'MODULE_NOT_FOUND';
                cb(moduleError);
            }
        });
    }

    function loadAsFile(x, thePackage, callback) {
        var loadAsFilePackage = thePackage;
        var cb = callback;
        if (typeof loadAsFilePackage === 'function') {
            cb = loadAsFilePackage;
            loadAsFilePackage = undefined;
        }

        var exts = [''].concat(extensions);
        load(exts, x, loadAsFilePackage);

        function load(exts, x, loadPackage) {
            if (exts.length === 0) return cb(null, undefined, loadPackage);
            var file = x + exts[0];

            var pkg = loadPackage;
            if (pkg) onpkg(null, pkg);
            else loadpkg(path.dirname(file), onpkg);

            function onpkg(err, pkg_, dir) {
                pkg = pkg_;
                if (err) return cb(err);
                if (dir && pkg && opts.pathFilter) {
                    var rfile = path.relative(dir, file);
                    var rel = rfile.slice(0, rfile.length - exts[0].length);
                    var r = opts.pathFilter(pkg, x, rel);
                    if (r) return load(
                        [''].concat(extensions.slice()),
                        path.resolve(dir, r),
                        pkg
                    );
                }
                isFile(file, onex);
            }
            function onex(err, ex) {
                if (err) return cb(err);
                if (ex) return cb(null, file, pkg);
                load(exts.slice(1), x, pkg);
            }
        }
    }

    function loadpkg(dir, cb) {
        if (dir === '' || dir === '/') return cb(null);
        if (process.platform === 'win32' && (/^\w:[/\\]*$/).test(dir)) {
            return cb(null);
        }
        if ((/[/\\]node_modules[/\\]*$/).test(dir)) return cb(null);

        maybeUnwrapSymlink(dir, opts, function (unwrapErr, pkgdir) {
            if (unwrapErr) return loadpkg(path.dirname(dir), cb);
            var pkgfile = path.join(pkgdir, 'package.json');
            isFile(pkgfile, function (err, ex) {
                // on err, ex is false
                if (!ex) return loadpkg(path.dirname(dir), cb);

                readFile(pkgfile, function (err, body) {
                    if (err) cb(err);
                    try { var pkg = JSON.parse(body); } catch (jsonErr) {}

                    if (pkg && opts.packageFilter) {
                        pkg = opts.packageFilter(pkg, pkgfile);
                    }
                    cb(null, pkg, dir);
                });
            });
        });
    }

    function loadAsDirectory(x, loadAsDirectoryPackage, callback) {
        var cb = callback;
        var fpkg = loadAsDirectoryPackage;
        if (typeof fpkg === 'function') {
            cb = fpkg;
            fpkg = opts.package;
        }

        maybeUnwrapSymlink(x, opts, function (unwrapErr, pkgdir) {
            if (unwrapErr) return cb(unwrapErr);
            var pkgfile = path.join(pkgdir, 'package.json');
            isFile(pkgfile, function (err, ex) {
                if (err) return cb(err);
                if (!ex) return loadAsFile(path.join(x, 'index'), fpkg, cb);

                readFile(pkgfile, function (err, body) {
                    if (err) return cb(err);
                    try {
                        var pkg = JSON.parse(body);
                    } catch (jsonErr) {}

                    if (pkg && opts.packageFilter) {
                        pkg = opts.packageFilter(pkg, pkgfile);
                    }

                    if (pkg && pkg.main) {
                        if (typeof pkg.main !== 'string') {
                            var mainError = new TypeError('package “' + pkg.name + '” `main` must be a string');
                            mainError.code = 'INVALID_PACKAGE_MAIN';
                            return cb(mainError);
                        }
                        if (pkg.main === '.' || pkg.main === './') {
                            pkg.main = 'index';
                        }
                        loadAsFile(path.resolve(x, pkg.main), pkg, function (err, m, pkg) {
                            if (err) return cb(err);
                            if (m) return cb(null, m, pkg);
                            if (!pkg) return loadAsFile(path.join(x, 'index'), pkg, cb);

                            var dir = path.resolve(x, pkg.main);
                            loadAsDirectory(dir, pkg, function (err, n, pkg) {
                                if (err) return cb(err);
                                if (n) return cb(null, n, pkg);
                                loadAsFile(path.join(x, 'index'), pkg, cb);
                            });
                        });
                        return;
                    }

                    loadAsFile(path.join(x, '/index'), pkg, cb);
                });
            });
        });
    }

    function processDirs(cb, dirs) {
        if (dirs.length === 0) return cb(null, undefined);
        var dir = dirs[0];

        isDirectory(dir, isdir);

        function isdir(err, isdir) {
            if (err) return cb(err);
            if (!isdir) return processDirs(cb, dirs.slice(1));
            var file = path.join(dir, x);
            loadAsFile(file, opts.package, onfile);
        }

        function onfile(err, m, pkg) {
            if (err) return cb(err);
            if (m) return cb(null, m, pkg);
            loadAsDirectory(path.join(dir, x), opts.package, ondir);
        }

        function ondir(err, n, pkg) {
            if (err) return cb(err);
            if (n) return cb(null, n, pkg);
            processDirs(cb, dirs.slice(1));
        }
    }
    function loadNodeModules(x, start, cb) {
        processDirs(cb, nodeModulesPaths(start, opts, x));
    }
};


/***/ }),
/* 136 */,
/* 137 */,
/* 138 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = validate;
exports.typeIs = typeIs;
exports.validateType = validateType;
exports.validateOptional = validateOptional;
exports.validateOptionalType = validateOptionalType;
exports.arrayOf = arrayOf;
exports.arrayOfType = arrayOfType;
exports.validateArrayOfType = validateArrayOfType;
exports.assertEach = assertEach;
exports.assertOneOf = assertOneOf;
exports.assertNodeType = assertNodeType;
exports.assertNodeOrValueType = assertNodeOrValueType;
exports.assertValueType = assertValueType;
exports.assertShape = assertShape;
exports.chain = chain;
exports.default = defineType;
exports.DEPRECATED_KEYS = exports.BUILDER_KEYS = exports.NODE_FIELDS = exports.FLIPPED_ALIAS_KEYS = exports.ALIAS_KEYS = exports.VISITOR_KEYS = void 0;

var _is = _interopRequireDefault(__webpack_require__(710));

var _validate = __webpack_require__(780);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const VISITOR_KEYS = {};
exports.VISITOR_KEYS = VISITOR_KEYS;
const ALIAS_KEYS = {};
exports.ALIAS_KEYS = ALIAS_KEYS;
const FLIPPED_ALIAS_KEYS = {};
exports.FLIPPED_ALIAS_KEYS = FLIPPED_ALIAS_KEYS;
const NODE_FIELDS = {};
exports.NODE_FIELDS = NODE_FIELDS;
const BUILDER_KEYS = {};
exports.BUILDER_KEYS = BUILDER_KEYS;
const DEPRECATED_KEYS = {};
exports.DEPRECATED_KEYS = DEPRECATED_KEYS;

function getType(val) {
  if (Array.isArray(val)) {
    return "array";
  } else if (val === null) {
    return "null";
  } else if (val === undefined) {
    return "undefined";
  } else {
    return typeof val;
  }
}

function validate(validate) {
  return {
    validate
  };
}

function typeIs(typeName) {
  return typeof typeName === "string" ? assertNodeType(typeName) : assertNodeType(...typeName);
}

function validateType(typeName) {
  return validate(typeIs(typeName));
}

function validateOptional(validate) {
  return {
    validate,
    optional: true
  };
}

function validateOptionalType(typeName) {
  return {
    validate: typeIs(typeName),
    optional: true
  };
}

function arrayOf(elementType) {
  return chain(assertValueType("array"), assertEach(elementType));
}

function arrayOfType(typeName) {
  return arrayOf(typeIs(typeName));
}

function validateArrayOfType(typeName) {
  return validate(arrayOfType(typeName));
}

function assertEach(callback) {
  function validator(node, key, val) {
    if (!Array.isArray(val)) return;

    for (let i = 0; i < val.length; i++) {
      callback(node, `${key}[${i}]`, val[i]);
    }
  }

  validator.each = callback;
  return validator;
}

function assertOneOf(...values) {
  function validate(node, key, val) {
    if (values.indexOf(val) < 0) {
      throw new TypeError(`Property ${key} expected value to be one of ${JSON.stringify(values)} but got ${JSON.stringify(val)}`);
    }
  }

  validate.oneOf = values;
  return validate;
}

function assertNodeType(...types) {
  function validate(node, key, val) {
    let valid = false;

    for (const type of types) {
      if ((0, _is.default)(type, val)) {
        valid = true;
        break;
      }
    }

    if (!valid) {
      throw new TypeError(`Property ${key} of ${node.type} expected node to be of a type ${JSON.stringify(types)} ` + `but instead got ${JSON.stringify(val && val.type)}`);
    }
  }

  validate.oneOfNodeTypes = types;
  return validate;
}

function assertNodeOrValueType(...types) {
  function validate(node, key, val) {
    let valid = false;

    for (const type of types) {
      if (getType(val) === type || (0, _is.default)(type, val)) {
        valid = true;
        break;
      }
    }

    if (!valid) {
      throw new TypeError(`Property ${key} of ${node.type} expected node to be of a type ${JSON.stringify(types)} ` + `but instead got ${JSON.stringify(val && val.type)}`);
    }
  }

  validate.oneOfNodeOrValueTypes = types;
  return validate;
}

function assertValueType(type) {
  function validate(node, key, val) {
    const valid = getType(val) === type;

    if (!valid) {
      throw new TypeError(`Property ${key} expected type of ${type} but got ${getType(val)}`);
    }
  }

  validate.type = type;
  return validate;
}

function assertShape(shape) {
  function validate(node, key, val) {
    const errors = [];

    for (const property of Object.keys(shape)) {
      try {
        (0, _validate.validateField)(node, property, val[property], shape[property]);
      } catch (error) {
        if (error instanceof TypeError) {
          errors.push(error.message);
          continue;
        }

        throw error;
      }
    }

    if (errors.length) {
      throw new TypeError(`Property ${key} of ${node.type} expected to have the following:\n${errors.join("\n")}`);
    }
  }

  validate.shapeOf = shape;
  return validate;
}

function chain(...fns) {
  function validate(...args) {
    for (const fn of fns) {
      fn(...args);
    }
  }

  validate.chainOf = fns;
  return validate;
}

function defineType(type, opts = {}) {
  const inherits = opts.inherits && store[opts.inherits] || {};
  const fields = opts.fields || inherits.fields || {};
  const visitor = opts.visitor || inherits.visitor || [];
  const aliases = opts.aliases || inherits.aliases || [];
  const builder = opts.builder || inherits.builder || opts.visitor || [];

  if (opts.deprecatedAlias) {
    DEPRECATED_KEYS[opts.deprecatedAlias] = type;
  }

  for (const key of visitor.concat(builder)) {
    fields[key] = fields[key] || {};
  }

  for (const key of Object.keys(fields)) {
    const field = fields[key];

    if (builder.indexOf(key) === -1) {
      field.optional = true;
    }

    if (field.default === undefined) {
      field.default = null;
    } else if (!field.validate) {
      field.validate = assertValueType(getType(field.default));
    }
  }

  VISITOR_KEYS[type] = opts.visitor = visitor;
  BUILDER_KEYS[type] = opts.builder = builder;
  NODE_FIELDS[type] = opts.fields = fields;
  ALIAS_KEYS[type] = opts.aliases = aliases;
  aliases.forEach(alias => {
    FLIPPED_ALIAS_KEYS[alias] = FLIPPED_ALIAS_KEYS[alias] || [];
    FLIPPED_ALIAS_KEYS[alias].push(type);
  });
  store[type] = opts;
}

const store = {};

/***/ }),
/* 139 */,
/* 140 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isValidES3Identifier;

var _isValidIdentifier = _interopRequireDefault(__webpack_require__(920));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const RESERVED_WORDS_ES3_ONLY = new Set(["abstract", "boolean", "byte", "char", "double", "enum", "final", "float", "goto", "implements", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "synchronized", "throws", "transient", "volatile"]);

function isValidES3Identifier(name) {
  return (0, _isValidIdentifier.default)(name) && !RESERVED_WORDS_ES3_ONLY.has(name);
}

/***/ }),
/* 141 */,
/* 142 */,
/* 143 */
/***/ (function(module) {

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

module.exports = isArray;


/***/ }),
/* 144 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _data = _interopRequireDefault(__webpack_require__(588));

var _entries = _interopRequireDefault(__webpack_require__(339));

var _getModulesListForTargetVersion = _interopRequireDefault(__webpack_require__(35));

var _filterItems = _interopRequireDefault(__webpack_require__(471));

var _utils = __webpack_require__(882);

var _debug = __webpack_require__(86);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function isBabelPolyfillSource(source) {
  return source === "@babel/polyfill" || source === "babel-polyfill";
}

function isCoreJSSource(source) {
  if (typeof source === "string") {
    source = source.replace(/\\/g, "/").replace(/(\/(index)?)?(\.js)?$/i, "").toLowerCase();
  }

  return (0, _utils.has)(_entries.default, source) && _entries.default[source];
}

const BABEL_POLYFILL_DEPRECATION = `
  \`@babel/polyfill\` is deprecated. Please, use required parts of \`core-js\`
  and \`regenerator-runtime/runtime\` separately`;

function _default(_, {
  corejs,
  include,
  exclude,
  polyfillTargets,
  debug
}) {
  const polyfills = (0, _filterItems.default)(_data.default, include, exclude, polyfillTargets, null);
  const available = new Set((0, _getModulesListForTargetVersion.default)(corejs.version));

  function shouldReplace(source, modules) {
    if (!modules) return false;

    if (modules.length === 1 && polyfills.has(modules[0]) && available.has(modules[0]) && (0, _utils.getModulePath)(modules[0]) === source) {
      return false;
    }

    return true;
  }

  const isPolyfillImport = {
    ImportDeclaration(path) {
      const source = (0, _utils.getImportSource)(path);
      if (!source) return;

      if (isBabelPolyfillSource(source)) {
        console.warn(BABEL_POLYFILL_DEPRECATION);
      } else {
        const modules = isCoreJSSource(source);

        if (shouldReplace(source, modules)) {
          this.replaceBySeparateModulesImport(path, modules);
        }
      }
    },

    Program: {
      enter(path) {
        path.get("body").forEach(bodyPath => {
          const source = (0, _utils.getRequireSource)(bodyPath);
          if (!source) return;

          if (isBabelPolyfillSource(source)) {
            console.warn(BABEL_POLYFILL_DEPRECATION);
          } else {
            const modules = isCoreJSSource(source);

            if (shouldReplace(source, modules)) {
              this.replaceBySeparateModulesImport(bodyPath, modules);
            }
          }
        });
      },

      exit(path) {
        const filtered = (0, _utils.intersection)(polyfills, this.polyfillsSet, available);
        const reversed = Array.from(filtered).reverse();

        for (const module of reversed) {
          if (!this.injectedPolyfills.has(module)) {
            (0, _utils.createImport)(path, module);
          }
        }

        filtered.forEach(module => this.injectedPolyfills.add(module));
      }

    }
  };
  return {
    name: "corejs3-entry",
    visitor: isPolyfillImport,

    pre() {
      this.injectedPolyfills = new Set();
      this.polyfillsSet = new Set();

      this.replaceBySeparateModulesImport = function (path, modules) {
        for (const module of modules) {
          this.polyfillsSet.add(module);
        }

        path.remove();
      };
    },

    post() {
      if (debug) {
        (0, _debug.logEntryPolyfills)("core-js", this.injectedPolyfills.size > 0, this.injectedPolyfills, this.file.opts.filename, polyfillTargets, _data.default);
      }
    }

  };
}

/***/ }),
/* 145 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseSync = parseSync;
exports.parseAsync = parseAsync;
exports.parse = void 0;

var _config = _interopRequireDefault(__webpack_require__(520));

var _normalizeFile = _interopRequireDefault(__webpack_require__(450));

var _normalizeOpts = _interopRequireDefault(__webpack_require__(182));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const parse = function parse(code, opts, callback) {
  if (typeof opts === "function") {
    callback = opts;
    opts = undefined;
  }

  if (callback === undefined) return parseSync(code, opts);
  const config = (0, _config.default)(opts);

  if (config === null) {
    return null;
  }

  const cb = callback;
  process.nextTick(() => {
    let ast = null;

    try {
      const cfg = (0, _config.default)(opts);
      if (cfg === null) return cb(null, null);
      ast = (0, _normalizeFile.default)(cfg.passes, (0, _normalizeOpts.default)(cfg), code).ast;
    } catch (err) {
      return cb(err);
    }

    cb(null, ast);
  });
};

exports.parse = parse;

function parseSync(code, opts) {
  const config = (0, _config.default)(opts);

  if (config === null) {
    return null;
  }

  return (0, _normalizeFile.default)(config.passes, (0, _normalizeOpts.default)(config), code).ast;
}

function parseAsync(code, opts) {
  return new Promise((res, rej) => {
    parse(code, opts, (err, result) => {
      if (err == null) res(result);else rej(err);
    });
  });
}

/***/ }),
/* 146 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var isFunction = __webpack_require__(10),
    isLength = __webpack_require__(611);

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

module.exports = isArrayLike;


/***/ }),
/* 147 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var castPath = __webpack_require__(929),
    toKey = __webpack_require__(503);

/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = castPath(path, object);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

module.exports = baseGet;


/***/ }),
/* 148 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function helpers() {
  const data = _interopRequireWildcard(__webpack_require__(168));

  helpers = function () {
    return data;
  };

  return data;
}

function _traverse() {
  const data = _interopRequireWildcard(__webpack_require__(167));

  _traverse = function () {
    return data;
  };

  return data;
}

function _codeFrame() {
  const data = __webpack_require__(475);

  _codeFrame = function () {
    return data;
  };

  return data;
}

function t() {
  const data = _interopRequireWildcard(__webpack_require__(978));

  t = function () {
    return data;
  };

  return data;
}

function _semver() {
  const data = _interopRequireDefault(__webpack_require__(864));

  _semver = function () {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const errorVisitor = {
  enter(path, state) {
    const loc = path.node.loc;

    if (loc) {
      state.loc = loc;
      path.stop();
    }
  }

};

class File {
  constructor(options, {
    code,
    ast,
    inputMap
  }) {
    this._map = new Map();
    this.declarations = {};
    this.path = null;
    this.ast = {};
    this.metadata = {};
    this.code = "";
    this.inputMap = null;
    this.hub = {
      file: this,
      getCode: () => this.code,
      getScope: () => this.scope,
      addHelper: this.addHelper.bind(this),
      buildError: this.buildCodeFrameError.bind(this)
    };
    this.opts = options;
    this.code = code;
    this.ast = ast;
    this.inputMap = inputMap;
    this.path = _traverse().NodePath.get({
      hub: this.hub,
      parentPath: null,
      parent: this.ast,
      container: this.ast,
      key: "program"
    }).setContext();
    this.scope = this.path.scope;
  }

  get shebang() {
    const {
      interpreter
    } = this.path.node;
    return interpreter ? interpreter.value : "";
  }

  set shebang(value) {
    if (value) {
      this.path.get("interpreter").replaceWith(t().interpreterDirective(value));
    } else {
      this.path.get("interpreter").remove();
    }
  }

  set(key, val) {
    if (key === "helpersNamespace") {
      throw new Error("Babel 7.0.0-beta.56 has dropped support for the 'helpersNamespace' utility." + "If you are using @babel/plugin-external-helpers you will need to use a newer " + "version than the one you currently have installed. " + "If you have your own implementation, you'll want to explore using 'helperGenerator' " + "alongside 'file.availableHelper()'.");
    }

    this._map.set(key, val);
  }

  get(key) {
    return this._map.get(key);
  }

  has(key) {
    return this._map.has(key);
  }

  getModuleName() {
    const {
      filename,
      filenameRelative = filename,
      moduleId,
      moduleIds = !!moduleId,
      getModuleId,
      sourceRoot: sourceRootTmp,
      moduleRoot = sourceRootTmp,
      sourceRoot = moduleRoot
    } = this.opts;
    if (!moduleIds) return null;

    if (moduleId != null && !getModuleId) {
      return moduleId;
    }

    let moduleName = moduleRoot != null ? moduleRoot + "/" : "";

    if (filenameRelative) {
      const sourceRootReplacer = sourceRoot != null ? new RegExp("^" + sourceRoot + "/?") : "";
      moduleName += filenameRelative.replace(sourceRootReplacer, "").replace(/\.(\w*?)$/, "");
    }

    moduleName = moduleName.replace(/\\/g, "/");

    if (getModuleId) {
      return getModuleId(moduleName) || moduleName;
    } else {
      return moduleName;
    }
  }

  addImport() {
    throw new Error("This API has been removed. If you're looking for this " + "functionality in Babel 7, you should import the " + "'@babel/helper-module-imports' module and use the functions exposed " + " from that module, such as 'addNamed' or 'addDefault'.");
  }

  availableHelper(name, versionRange) {
    let minVersion;

    try {
      minVersion = helpers().minVersion(name);
    } catch (err) {
      if (err.code !== "BABEL_HELPER_UNKNOWN") throw err;
      return false;
    }

    if (typeof versionRange !== "string") return true;
    if (_semver().default.valid(versionRange)) versionRange = `^${versionRange}`;
    return !_semver().default.intersects(`<${minVersion}`, versionRange) && !_semver().default.intersects(`>=8.0.0`, versionRange);
  }

  addHelper(name) {
    const declar = this.declarations[name];
    if (declar) return t().cloneNode(declar);
    const generator = this.get("helperGenerator");

    if (generator) {
      const res = generator(name);
      if (res) return res;
    }

    helpers().ensure(name);
    const uid = this.declarations[name] = this.scope.generateUidIdentifier(name);
    const dependencies = {};

    for (const dep of helpers().getDependencies(name)) {
      dependencies[dep] = this.addHelper(dep);
    }

    const {
      nodes,
      globals
    } = helpers().get(name, dep => dependencies[dep], uid, Object.keys(this.scope.getAllBindings()));
    globals.forEach(name => {
      if (this.path.scope.hasBinding(name, true)) {
        this.path.scope.rename(name);
      }
    });
    nodes.forEach(node => {
      node._compact = true;
    });
    this.path.unshiftContainer("body", nodes);
    this.path.get("body").forEach(path => {
      if (nodes.indexOf(path.node) === -1) return;
      if (path.isVariableDeclaration()) this.scope.registerDeclaration(path);
    });
    return uid;
  }

  addTemplateObject() {
    throw new Error("This function has been moved into the template literal transform itself.");
  }

  buildCodeFrameError(node, msg, Error = SyntaxError) {
    let loc = node && (node.loc || node._loc);

    if (!loc && node) {
      const state = {
        loc: null
      };
      (0, _traverse().default)(node, errorVisitor, this.scope, state);
      loc = state.loc;
      let txt = "This is an error on an internal node. Probably an internal error.";
      if (loc) txt += " Location has been estimated.";
      msg += ` (${txt})`;
    }

    if (loc) {
      const {
        highlightCode = true
      } = this.opts;
      msg += "\n" + (0, _codeFrame().codeFrameColumns)(this.code, {
        start: {
          line: loc.start.line,
          column: loc.start.column + 1
        },
        end: loc.end && loc.start.line === loc.end.line ? {
          line: loc.end.line,
          column: loc.end.column + 1
        } : undefined
      }, {
        highlightCode
      });
    }

    return new Error(msg);
  }

}

exports.default = File;

/***/ }),
/* 149 */
/***/ (function(module, exports, __webpack_require__) {

/* eslint-disable node/no-deprecated-api */
var buffer = __webpack_require__(293)
var Buffer = buffer.Buffer

// alternative to using Object.keys for old browsers
function copyProps (src, dst) {
  for (var key in src) {
    dst[key] = src[key]
  }
}
if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
  module.exports = buffer
} else {
  // Copy properties from require('buffer')
  copyProps(buffer, exports)
  exports.Buffer = SafeBuffer
}

function SafeBuffer (arg, encodingOrOffset, length) {
  return Buffer(arg, encodingOrOffset, length)
}

// Copy static methods from Buffer
copyProps(Buffer, SafeBuffer)

SafeBuffer.from = function (arg, encodingOrOffset, length) {
  if (typeof arg === 'number') {
    throw new TypeError('Argument must not be a number')
  }
  return Buffer(arg, encodingOrOffset, length)
}

SafeBuffer.alloc = function (size, fill, encoding) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  var buf = Buffer(size)
  if (fill !== undefined) {
    if (typeof encoding === 'string') {
      buf.fill(fill, encoding)
    } else {
      buf.fill(fill)
    }
  } else {
    buf.fill(0)
  }
  return buf
}

SafeBuffer.allocUnsafe = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return Buffer(size)
}

SafeBuffer.allocUnsafeSlow = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return buffer.SlowBuffer(size)
}


/***/ }),
/* 150 */,
/* 151 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "findPackageData", {
  enumerable: true,
  get: function () {
    return _package.findPackageData;
  }
});
Object.defineProperty(exports, "findConfigUpwards", {
  enumerable: true,
  get: function () {
    return _configuration.findConfigUpwards;
  }
});
Object.defineProperty(exports, "findRelativeConfig", {
  enumerable: true,
  get: function () {
    return _configuration.findRelativeConfig;
  }
});
Object.defineProperty(exports, "findRootConfig", {
  enumerable: true,
  get: function () {
    return _configuration.findRootConfig;
  }
});
Object.defineProperty(exports, "loadConfig", {
  enumerable: true,
  get: function () {
    return _configuration.loadConfig;
  }
});
Object.defineProperty(exports, "resolvePlugin", {
  enumerable: true,
  get: function () {
    return _plugins.resolvePlugin;
  }
});
Object.defineProperty(exports, "resolvePreset", {
  enumerable: true,
  get: function () {
    return _plugins.resolvePreset;
  }
});
Object.defineProperty(exports, "loadPlugin", {
  enumerable: true,
  get: function () {
    return _plugins.loadPlugin;
  }
});
Object.defineProperty(exports, "loadPreset", {
  enumerable: true,
  get: function () {
    return _plugins.loadPreset;
  }
});

var _package = __webpack_require__(848);

var _configuration = __webpack_require__(656);

var _plugins = __webpack_require__(449);

({});

/***/ }),
/* 152 */,
/* 153 */,
/* 154 */,
/* 155 */,
/* 156 */,
/* 157 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _data = _interopRequireDefault(__webpack_require__(588));

var _shippedProposals = _interopRequireDefault(__webpack_require__(695));

var _getModulesListForTargetVersion = _interopRequireDefault(__webpack_require__(35));

var _filterItems = _interopRequireDefault(__webpack_require__(471));

var _builtInDefinitions = __webpack_require__(97);

var _utils = __webpack_require__(882);

var _debug = __webpack_require__(86);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NO_DIRECT_POLYFILL_IMPORT = `
  When setting \`useBuiltIns: 'usage'\`, polyfills are automatically imported when needed.
  Please remove the direct import of \`core-js\` or use \`useBuiltIns: 'entry'\` instead.`;
const corejs3PolyfillsWithoutProposals = Object.keys(_data.default).filter(name => !name.startsWith("esnext.")).reduce((memo, key) => {
  memo[key] = _data.default[key];
  return memo;
}, {});

const corejs3PolyfillsWithShippedProposals = _shippedProposals.default.reduce((memo, key) => {
  memo[key] = _data.default[key];
  return memo;
}, Object.assign({}, corejs3PolyfillsWithoutProposals));

function _default(_, {
  corejs,
  include,
  exclude,
  polyfillTargets,
  proposals,
  shippedProposals,
  debug
}) {
  const polyfills = (0, _filterItems.default)(proposals ? _data.default : shippedProposals ? corejs3PolyfillsWithShippedProposals : corejs3PolyfillsWithoutProposals, include, exclude, polyfillTargets, null);
  const available = new Set((0, _getModulesListForTargetVersion.default)(corejs.version));

  function resolveKey(path, computed) {
    const {
      node,
      parent,
      scope
    } = path;
    if (path.isStringLiteral()) return node.value;
    const {
      name
    } = node;
    const isIdentifier = path.isIdentifier();
    if (isIdentifier && !(computed || parent.computed)) return name;

    if (!isIdentifier || scope.getBindingIdentifier(name)) {
      const {
        value
      } = path.evaluate();
      if (typeof value === "string") return value;
    }
  }

  function resolveSource(path) {
    const {
      node,
      scope
    } = path;
    let builtIn, instanceType;

    if (node) {
      builtIn = node.name;

      if (!path.isIdentifier() || scope.getBindingIdentifier(builtIn)) {
        const {
          deopt,
          value
        } = path.evaluate();

        if (value !== undefined) {
          instanceType = (0, _utils.getType)(value);
        } else if (deopt && deopt.isIdentifier()) {
          builtIn = deopt.node.name;
        }
      }
    }

    return {
      builtIn,
      instanceType,
      isNamespaced: (0, _utils.isNamespaced)(path)
    };
  }

  const addAndRemovePolyfillImports = {
    ImportDeclaration(path) {
      if ((0, _utils.isPolyfillSource)((0, _utils.getImportSource)(path))) {
        console.warn(NO_DIRECT_POLYFILL_IMPORT);
        path.remove();
      }
    },

    Program: {
      enter(path) {
        path.get("body").forEach(bodyPath => {
          if ((0, _utils.isPolyfillSource)((0, _utils.getRequireSource)(bodyPath))) {
            console.warn(NO_DIRECT_POLYFILL_IMPORT);
            bodyPath.remove();
          }
        });
      },

      exit(path) {
        const filtered = (0, _utils.intersection)(polyfills, this.polyfillsSet, available);
        const reversed = Array.from(filtered).reverse();

        for (const module of reversed) {
          if (!this.injectedPolyfills.has(module)) {
            (0, _utils.createImport)(path, module);
          }
        }

        filtered.forEach(module => this.injectedPolyfills.add(module));
      }

    },

    Import() {
      this.addUnsupported(_builtInDefinitions.PromiseDependencies);
    },

    Function({
      node
    }) {
      if (node.async) {
        this.addUnsupported(_builtInDefinitions.PromiseDependencies);
      }
    },

    "ForOfStatement|ArrayPattern"() {
      this.addUnsupported(_builtInDefinitions.CommonIterators);
    },

    SpreadElement({
      parentPath
    }) {
      if (!parentPath.isObjectExpression()) {
        this.addUnsupported(_builtInDefinitions.CommonIterators);
      }
    },

    YieldExpression({
      node
    }) {
      if (node.delegate) {
        this.addUnsupported(_builtInDefinitions.CommonIterators);
      }
    },

    ReferencedIdentifier({
      node: {
        name
      },
      scope
    }) {
      if (scope.getBindingIdentifier(name)) return;
      this.addBuiltInDependencies(name);
    },

    MemberExpression(path) {
      const source = resolveSource(path.get("object"));
      const key = resolveKey(path.get("property"));
      this.addPropertyDependencies(source, key);
    },

    ObjectPattern(path) {
      const {
        parentPath,
        parent,
        key
      } = path;
      let source;

      if (parentPath.isVariableDeclarator()) {
        source = resolveSource(parentPath.get("init"));
      } else if (parentPath.isAssignmentExpression()) {
        source = resolveSource(parentPath.get("right"));
      } else if (parentPath.isFunctionExpression()) {
        const grand = parentPath.parentPath;

        if (grand.isCallExpression() || grand.isNewExpression()) {
          if (grand.node.callee === parent) {
            source = resolveSource(grand.get("arguments")[key]);
          }
        }
      }

      for (const property of path.get("properties")) {
        if (property.isObjectProperty()) {
          const key = resolveKey(property.get("key"));
          this.addPropertyDependencies(source, key);
        }
      }
    },

    BinaryExpression(path) {
      if (path.node.operator !== "in") return;
      const source = resolveSource(path.get("right"));
      const key = resolveKey(path.get("left"), true);
      this.addPropertyDependencies(source, key);
    }

  };
  return {
    name: "corejs3-usage",

    pre() {
      this.injectedPolyfills = new Set();
      this.polyfillsSet = new Set();

      this.addUnsupported = function (builtIn) {
        const modules = Array.isArray(builtIn) ? builtIn : [builtIn];

        for (const module of modules) {
          this.polyfillsSet.add(module);
        }
      };

      this.addBuiltInDependencies = function (builtIn) {
        if ((0, _utils.has)(_builtInDefinitions.BuiltIns, builtIn)) {
          const BuiltInDependencies = _builtInDefinitions.BuiltIns[builtIn];
          this.addUnsupported(BuiltInDependencies);
        }
      };

      this.addPropertyDependencies = function (source = {}, key) {
        const {
          builtIn,
          instanceType,
          isNamespaced
        } = source;
        if (isNamespaced) return;

        if (_builtInDefinitions.PossibleGlobalObjects.has(builtIn)) {
          this.addBuiltInDependencies(key);
        } else if ((0, _utils.has)(_builtInDefinitions.StaticProperties, builtIn)) {
          const BuiltInProperties = _builtInDefinitions.StaticProperties[builtIn];

          if ((0, _utils.has)(BuiltInProperties, key)) {
            const StaticPropertyDependencies = BuiltInProperties[key];
            return this.addUnsupported(StaticPropertyDependencies);
          }
        }

        if (!(0, _utils.has)(_builtInDefinitions.InstanceProperties, key)) return;
        let InstancePropertyDependencies = _builtInDefinitions.InstanceProperties[key];

        if (instanceType) {
          InstancePropertyDependencies = InstancePropertyDependencies.filter(m => m.includes(instanceType) || _builtInDefinitions.CommonInstanceDependencies.has(m));
        }

        this.addUnsupported(InstancePropertyDependencies);
      };
    },

    post() {
      if (debug) {
        (0, _debug.logUsagePolyfills)(this.injectedPolyfills, this.file.opts.filename, polyfillTargets, _data.default);
      }
    },

    visitor: addAndRemovePolyfillImports
  };
}

/***/ }),
/* 158 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = toKeyAlias;

var _generated = __webpack_require__(897);

var _cloneNode = _interopRequireDefault(__webpack_require__(533));

var _removePropertiesDeep = _interopRequireDefault(__webpack_require__(470));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function toKeyAlias(node, key = node.key) {
  let alias;

  if (node.kind === "method") {
    return toKeyAlias.increment() + "";
  } else if ((0, _generated.isIdentifier)(key)) {
    alias = key.name;
  } else if ((0, _generated.isStringLiteral)(key)) {
    alias = JSON.stringify(key.value);
  } else {
    alias = JSON.stringify((0, _removePropertiesDeep.default)((0, _cloneNode.default)(key)));
  }

  if (node.computed) {
    alias = `[${alias}]`;
  }

  if (node.static) {
    alias = `static:${alias}`;
  }

  return alias;
}

toKeyAlias.uid = 0;

toKeyAlias.increment = function () {
  if (toKeyAlias.uid >= Number.MAX_SAFE_INTEGER) {
    return toKeyAlias.uid = 0;
  } else {
    return toKeyAlias.uid++;
  }
};

/***/ }),
/* 159 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var coreJsData = __webpack_require__(396);

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

module.exports = isMasked;


/***/ }),
/* 160 */
/***/ (function(module) {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

module.exports = isIndex;


/***/ }),
/* 161 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var root = __webpack_require__(824);

/** Built-in value references. */
var Uint8Array = root.Uint8Array;

module.exports = Uint8Array;


/***/ }),
/* 162 */,
/* 163 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _helperPluginUtils = __webpack_require__(57);

var _helperFunctionName = _interopRequireDefault(__webpack_require__(297));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = (0, _helperPluginUtils.declare)(api => {
  api.assertVersion(7);
  return {
    name: "transform-function-name",
    visitor: {
      FunctionExpression: {
        exit(path) {
          if (path.key !== "value" && !path.parentPath.isObjectProperty()) {
            const replacement = (0, _helperFunctionName.default)(path);
            if (replacement) path.replaceWith(replacement);
          }
        }

      },

      ObjectProperty(path) {
        const value = path.get("value");

        if (value.isFunction()) {
          const newNode = (0, _helperFunctionName.default)(value);
          if (newNode) value.replaceWith(newNode);
        }
      }

    }
  };
});

exports.default = _default;

/***/ }),
/* 164 */,
/* 165 */,
/* 166 */
/***/ (function(module) {

module.exports = {"v0.10":{"start":"2013-03-11","end":"2016-10-31"},"v0.12":{"start":"2015-02-06","end":"2016-12-31"},"v4":{"start":"2015-09-08","lts":"2015-10-12","maintenance":"2017-04-01","end":"2018-04-30","codename":"Argon"},"v5":{"start":"2015-10-29","maintenance":"2016-04-30","end":"2016-06-30"},"v6":{"start":"2016-04-26","lts":"2016-10-18","maintenance":"2018-04-30","end":"2019-04-30","codename":"Boron"},"v7":{"start":"2016-10-25","maintenance":"2017-04-30","end":"2017-06-30"},"v8":{"start":"2017-05-30","lts":"2017-10-31","maintenance":"2019-01-01","end":"2019-12-31","codename":"Carbon"},"v9":{"start":"2017-10-01","maintenance":"2018-04-01","end":"2018-06-30"},"v10":{"start":"2018-04-24","lts":"2018-10-30","maintenance":"2020-04-01","end":"2021-04-30","codename":"Dubnium"},"v11":{"start":"2018-10-23","maintenance":"2019-04-22","end":"2019-06-01"},"v12":{"start":"2019-04-23","lts":"2019-10-21","maintenance":"2020-10-21","end":"2022-04-30","codename":"Erbium"},"v13":{"start":"2019-10-22","maintenance":"2020-04-01","end":"2020-06-01"},"v14":{"start":"2020-04-21","lts":"2020-10-20","maintenance":"2021-10-20","end":"2023-04-30","codename":""}};

/***/ }),
/* 167 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = traverse;
Object.defineProperty(exports, "NodePath", {
  enumerable: true,
  get: function () {
    return _path.default;
  }
});
Object.defineProperty(exports, "Scope", {
  enumerable: true,
  get: function () {
    return _scope.default;
  }
});
Object.defineProperty(exports, "Hub", {
  enumerable: true,
  get: function () {
    return _hub.default;
  }
});
exports.visitors = void 0;

var _context = _interopRequireDefault(__webpack_require__(298));

var visitors = _interopRequireWildcard(__webpack_require__(966));

exports.visitors = visitors;

var _includes = _interopRequireDefault(__webpack_require__(249));

var t = _interopRequireWildcard(__webpack_require__(978));

var cache = _interopRequireWildcard(__webpack_require__(715));

var _path = _interopRequireDefault(__webpack_require__(774));

var _scope = _interopRequireDefault(__webpack_require__(118));

var _hub = _interopRequireDefault(__webpack_require__(516));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function traverse(parent, opts, scope, state, parentPath) {
  if (!parent) return;
  if (!opts) opts = {};

  if (!opts.noScope && !scope) {
    if (parent.type !== "Program" && parent.type !== "File") {
      throw new Error("You must pass a scope and parentPath unless traversing a Program/File. " + `Instead of that you tried to traverse a ${parent.type} node without ` + "passing scope and parentPath.");
    }
  }

  if (!t.VISITOR_KEYS[parent.type]) {
    return;
  }

  visitors.explode(opts);
  traverse.node(parent, opts, scope, state, parentPath);
}

traverse.visitors = visitors;
traverse.verify = visitors.verify;
traverse.explode = visitors.explode;

traverse.cheap = function (node, enter) {
  return t.traverseFast(node, enter);
};

traverse.node = function (node, opts, scope, state, parentPath, skipKeys) {
  const keys = t.VISITOR_KEYS[node.type];
  if (!keys) return;
  const context = new _context.default(scope, opts, state, parentPath);

  for (const key of keys) {
    if (skipKeys && skipKeys[key]) continue;
    if (context.visit(node, key)) return;
  }
};

traverse.clearNode = function (node, opts) {
  t.removeProperties(node, opts);
  cache.path.delete(node);
};

traverse.removeProperties = function (tree, opts) {
  t.traverseFast(tree, traverse.clearNode, opts);
  return tree;
};

function hasBlacklistedType(path, state) {
  if (path.node.type === state.type) {
    state.has = true;
    path.stop();
  }
}

traverse.hasType = function (tree, type, blacklistTypes) {
  if ((0, _includes.default)(blacklistTypes, tree.type)) return false;
  if (tree.type === type) return true;
  const state = {
    has: false,
    type: type
  };
  traverse(tree, {
    noScope: true,
    blacklist: blacklistTypes,
    enter: hasBlacklistedType
  }, null, state);
  return state.has;
};

traverse.cache = cache;

/***/ }),
/* 168 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.get = get;
exports.minVersion = minVersion;
exports.getDependencies = getDependencies;
exports.ensure = ensure;
exports.default = exports.list = void 0;

var _traverse = _interopRequireDefault(__webpack_require__(167));

var t = _interopRequireWildcard(__webpack_require__(978));

var _helpers = _interopRequireDefault(__webpack_require__(793));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function makePath(path) {
  const parts = [];

  for (; path.parentPath; path = path.parentPath) {
    parts.push(path.key);
    if (path.inList) parts.push(path.listKey);
  }

  return parts.reverse().join(".");
}

function getHelperMetadata(file) {
  const globals = new Set();
  const localBindingNames = new Set();
  const dependencies = new Map();
  let exportName;
  let exportPath;
  const exportBindingAssignments = [];
  const importPaths = [];
  const importBindingsReferences = [];
  (0, _traverse.default)(file, {
    ImportDeclaration(child) {
      const name = child.node.source.value;

      if (!_helpers.default[name]) {
        throw child.buildCodeFrameError(`Unknown helper ${name}`);
      }

      if (child.get("specifiers").length !== 1 || !child.get("specifiers.0").isImportDefaultSpecifier()) {
        throw child.buildCodeFrameError("Helpers can only import a default value");
      }

      const bindingIdentifier = child.node.specifiers[0].local;
      dependencies.set(bindingIdentifier, name);
      importPaths.push(makePath(child));
    },

    ExportDefaultDeclaration(child) {
      const decl = child.get("declaration");

      if (decl.isFunctionDeclaration()) {
        if (!decl.node.id) {
          throw decl.buildCodeFrameError("Helpers should give names to their exported func declaration");
        }

        exportName = decl.node.id.name;
      }

      exportPath = makePath(child);
    },

    ExportAllDeclaration(child) {
      throw child.buildCodeFrameError("Helpers can only export default");
    },

    ExportNamedDeclaration(child) {
      throw child.buildCodeFrameError("Helpers can only export default");
    },

    Statement(child) {
      if (child.isModuleDeclaration()) return;
      child.skip();
    }

  });
  (0, _traverse.default)(file, {
    Program(path) {
      const bindings = path.scope.getAllBindings();
      Object.keys(bindings).forEach(name => {
        if (name === exportName) return;
        if (dependencies.has(bindings[name].identifier)) return;
        localBindingNames.add(name);
      });
    },

    ReferencedIdentifier(child) {
      const name = child.node.name;
      const binding = child.scope.getBinding(name, true);

      if (!binding) {
        globals.add(name);
      } else if (dependencies.has(binding.identifier)) {
        importBindingsReferences.push(makePath(child));
      }
    },

    AssignmentExpression(child) {
      const left = child.get("left");
      if (!(exportName in left.getBindingIdentifiers())) return;

      if (!left.isIdentifier()) {
        throw left.buildCodeFrameError("Only simple assignments to exports are allowed in helpers");
      }

      const binding = child.scope.getBinding(exportName);

      if (binding && binding.scope.path.isProgram()) {
        exportBindingAssignments.push(makePath(child));
      }
    }

  });
  if (!exportPath) throw new Error("Helpers must default-export something.");
  exportBindingAssignments.reverse();
  return {
    globals: Array.from(globals),
    localBindingNames: Array.from(localBindingNames),
    dependencies,
    exportBindingAssignments,
    exportPath,
    exportName,
    importBindingsReferences,
    importPaths
  };
}

function permuteHelperAST(file, metadata, id, localBindings, getDependency) {
  if (localBindings && !id) {
    throw new Error("Unexpected local bindings for module-based helpers.");
  }

  if (!id) return;
  const {
    localBindingNames,
    dependencies,
    exportBindingAssignments,
    exportPath,
    exportName,
    importBindingsReferences,
    importPaths
  } = metadata;
  const dependenciesRefs = {};
  dependencies.forEach((name, id) => {
    dependenciesRefs[id.name] = typeof getDependency === "function" && getDependency(name) || id;
  });
  const toRename = {};
  const bindings = new Set(localBindings || []);
  localBindingNames.forEach(name => {
    let newName = name;

    while (bindings.has(newName)) newName = "_" + newName;

    if (newName !== name) toRename[name] = newName;
  });

  if (id.type === "Identifier" && exportName !== id.name) {
    toRename[exportName] = id.name;
  }

  (0, _traverse.default)(file, {
    Program(path) {
      const exp = path.get(exportPath);
      const imps = importPaths.map(p => path.get(p));
      const impsBindingRefs = importBindingsReferences.map(p => path.get(p));
      const decl = exp.get("declaration");

      if (id.type === "Identifier") {
        if (decl.isFunctionDeclaration()) {
          exp.replaceWith(decl);
        } else {
          exp.replaceWith(t.variableDeclaration("var", [t.variableDeclarator(id, decl.node)]));
        }
      } else if (id.type === "MemberExpression") {
        if (decl.isFunctionDeclaration()) {
          exportBindingAssignments.forEach(assignPath => {
            const assign = path.get(assignPath);
            assign.replaceWith(t.assignmentExpression("=", id, assign.node));
          });
          exp.replaceWith(decl);
          path.pushContainer("body", t.expressionStatement(t.assignmentExpression("=", id, t.identifier(exportName))));
        } else {
          exp.replaceWith(t.expressionStatement(t.assignmentExpression("=", id, decl.node)));
        }
      } else {
        throw new Error("Unexpected helper format.");
      }

      Object.keys(toRename).forEach(name => {
        path.scope.rename(name, toRename[name]);
      });

      for (const path of imps) path.remove();

      for (const path of impsBindingRefs) {
        const node = t.cloneNode(dependenciesRefs[path.node.name]);
        path.replaceWith(node);
      }

      path.stop();
    }

  });
}

const helperData = Object.create(null);

function loadHelper(name) {
  if (!helperData[name]) {
    const helper = _helpers.default[name];

    if (!helper) {
      throw Object.assign(new ReferenceError(`Unknown helper ${name}`), {
        code: "BABEL_HELPER_UNKNOWN",
        helper: name
      });
    }

    const fn = () => {
      return t.file(helper.ast());
    };

    const metadata = getHelperMetadata(fn());
    helperData[name] = {
      build(getDependency, id, localBindings) {
        const file = fn();
        permuteHelperAST(file, metadata, id, localBindings, getDependency);
        return {
          nodes: file.program.body,
          globals: metadata.globals
        };
      },

      minVersion() {
        return helper.minVersion;
      },

      dependencies: metadata.dependencies
    };
  }

  return helperData[name];
}

function get(name, getDependency, id, localBindings) {
  return loadHelper(name).build(getDependency, id, localBindings);
}

function minVersion(name) {
  return loadHelper(name).minVersion();
}

function getDependencies(name) {
  return Array.from(loadHelper(name).dependencies.values());
}

function ensure(name) {
  loadHelper(name);
}

const list = Object.keys(_helpers.default).map(name => name.replace(/^_/, "")).filter(name => name !== "__esModule");
exports.list = list;
var _default = get;
exports.default = _default;

/***/ }),
/* 169 */,
/* 170 */,
/* 171 */,
/* 172 */,
/* 173 */,
/* 174 */
/***/ (function(module, __unusedexports, __webpack_require__) {

module.exports = __webpack_require__(626);


/***/ }),
/* 175 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.call = call;
exports._call = _call;
exports.isBlacklisted = isBlacklisted;
exports.visit = visit;
exports.skip = skip;
exports.skipKey = skipKey;
exports.stop = stop;
exports.setScope = setScope;
exports.setContext = setContext;
exports.resync = resync;
exports._resyncParent = _resyncParent;
exports._resyncKey = _resyncKey;
exports._resyncList = _resyncList;
exports._resyncRemoved = _resyncRemoved;
exports.popContext = popContext;
exports.pushContext = pushContext;
exports.setup = setup;
exports.setKey = setKey;
exports.requeue = requeue;
exports._getQueueContexts = _getQueueContexts;

var _index = _interopRequireDefault(__webpack_require__(167));

var _index2 = __webpack_require__(774);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function call(key) {
  const opts = this.opts;
  this.debug(key);

  if (this.node) {
    if (this._call(opts[key])) return true;
  }

  if (this.node) {
    return this._call(opts[this.node.type] && opts[this.node.type][key]);
  }

  return false;
}

function _call(fns) {
  if (!fns) return false;

  for (const fn of fns) {
    if (!fn) continue;
    const node = this.node;
    if (!node) return true;
    const ret = fn.call(this.state, this, this.state);

    if (ret && typeof ret === "object" && typeof ret.then === "function") {
      throw new Error(`You appear to be using a plugin with an async traversal visitor, ` + `which your current version of Babel does not support. ` + `If you're using a published plugin, you may need to upgrade ` + `your @babel/core version.`);
    }

    if (ret) {
      throw new Error(`Unexpected return value from visitor method ${fn}`);
    }

    if (this.node !== node) return true;
    if (this._traverseFlags > 0) return true;
  }

  return false;
}

function isBlacklisted() {
  const blacklist = this.opts.blacklist;
  return blacklist && blacklist.indexOf(this.node.type) > -1;
}

function visit() {
  if (!this.node) {
    return false;
  }

  if (this.isBlacklisted()) {
    return false;
  }

  if (this.opts.shouldSkip && this.opts.shouldSkip(this)) {
    return false;
  }

  if (this.shouldSkip || this.call("enter") || this.shouldSkip) {
    this.debug("Skip...");
    return this.shouldStop;
  }

  this.debug("Recursing into...");

  _index.default.node(this.node, this.opts, this.scope, this.state, this, this.skipKeys);

  this.call("exit");
  return this.shouldStop;
}

function skip() {
  this.shouldSkip = true;
}

function skipKey(key) {
  if (this.skipKeys == null) {
    this.skipKeys = {};
  }

  this.skipKeys[key] = true;
}

function stop() {
  this._traverseFlags |= _index2.SHOULD_SKIP | _index2.SHOULD_STOP;
}

function setScope() {
  if (this.opts && this.opts.noScope) return;
  let path = this.parentPath;
  let target;

  while (path && !target) {
    if (path.opts && path.opts.noScope) return;
    target = path.scope;
    path = path.parentPath;
  }

  this.scope = this.getScope(target);
  if (this.scope) this.scope.init();
}

function setContext(context) {
  if (this.skipKeys != null) {
    this.skipKeys = {};
  }

  this._traverseFlags = 0;

  if (context) {
    this.context = context;
    this.state = context.state;
    this.opts = context.opts;
  }

  this.setScope();
  return this;
}

function resync() {
  if (this.removed) return;

  this._resyncParent();

  this._resyncList();

  this._resyncKey();
}

function _resyncParent() {
  if (this.parentPath) {
    this.parent = this.parentPath.node;
  }
}

function _resyncKey() {
  if (!this.container) return;
  if (this.node === this.container[this.key]) return;

  if (Array.isArray(this.container)) {
    for (let i = 0; i < this.container.length; i++) {
      if (this.container[i] === this.node) {
        return this.setKey(i);
      }
    }
  } else {
    for (const key of Object.keys(this.container)) {
      if (this.container[key] === this.node) {
        return this.setKey(key);
      }
    }
  }

  this.key = null;
}

function _resyncList() {
  if (!this.parent || !this.inList) return;
  const newContainer = this.parent[this.listKey];
  if (this.container === newContainer) return;
  this.container = newContainer || null;
}

function _resyncRemoved() {
  if (this.key == null || !this.container || this.container[this.key] !== this.node) {
    this._markRemoved();
  }
}

function popContext() {
  this.contexts.pop();

  if (this.contexts.length > 0) {
    this.setContext(this.contexts[this.contexts.length - 1]);
  } else {
    this.setContext(undefined);
  }
}

function pushContext(context) {
  this.contexts.push(context);
  this.setContext(context);
}

function setup(parentPath, container, listKey, key) {
  this.listKey = listKey;
  this.container = container;
  this.parentPath = parentPath || this.parentPath;
  this.setKey(key);
}

function setKey(key) {
  this.key = key;
  this.node = this.container[this.key];
  this.type = this.node && this.node.type;
}

function requeue(pathToQueue = this) {
  if (pathToQueue.removed) return;
  const contexts = this.contexts;

  for (const context of contexts) {
    context.maybeQueue(pathToQueue);
  }
}

function _getQueueContexts() {
  let path = this;
  let contexts = this.contexts;

  while (!contexts.length) {
    path = path.parentPath;
    if (!path) break;
    contexts = path.contexts;
  }

  return contexts;
}

/***/ }),
/* 176 */,
/* 177 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


var _assert = _interopRequireDefault(__webpack_require__(59));

var _util = __webpack_require__(930);

var _private = __webpack_require__(907);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Copyright (c) 2014-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var m = (0, _private.makeAccessor)();
var hasOwn = Object.prototype.hasOwnProperty;

function makePredicate(propertyName, knownTypes) {
  function onlyChildren(node) {
    var t = (0, _util.getTypes)();
    t.assertNode(node); // Assume no side effects until we find out otherwise.

    var result = false;

    function check(child) {
      if (result) {// Do nothing.
      } else if (Array.isArray(child)) {
        child.some(check);
      } else if (t.isNode(child)) {
        _assert["default"].strictEqual(result, false);

        result = predicate(child);
      }

      return result;
    }

    var keys = t.VISITOR_KEYS[node.type];

    if (keys) {
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var child = node[key];
        check(child);
      }
    }

    return result;
  }

  function predicate(node) {
    (0, _util.getTypes)().assertNode(node);
    var meta = m(node);
    if (hasOwn.call(meta, propertyName)) return meta[propertyName]; // Certain types are "opaque," which means they have no side
    // effects or leaps and we don't care about their subexpressions.

    if (hasOwn.call(opaqueTypes, node.type)) return meta[propertyName] = false;
    if (hasOwn.call(knownTypes, node.type)) return meta[propertyName] = true;
    return meta[propertyName] = onlyChildren(node);
  }

  predicate.onlyChildren = onlyChildren;
  return predicate;
}

var opaqueTypes = {
  FunctionExpression: true,
  ArrowFunctionExpression: true
}; // These types potentially have side effects regardless of what side
// effects their subexpressions have.

var sideEffectTypes = {
  CallExpression: true,
  // Anything could happen!
  ForInStatement: true,
  // Modifies the key variable.
  UnaryExpression: true,
  // Think delete.
  BinaryExpression: true,
  // Might invoke .toString() or .valueOf().
  AssignmentExpression: true,
  // Side-effecting by definition.
  UpdateExpression: true,
  // Updates are essentially assignments.
  NewExpression: true // Similar to CallExpression.

}; // These types are the direct cause of all leaps in control flow.

var leapTypes = {
  YieldExpression: true,
  BreakStatement: true,
  ContinueStatement: true,
  ReturnStatement: true,
  ThrowStatement: true
}; // All leap types are also side effect types.

for (var type in leapTypes) {
  if (hasOwn.call(leapTypes, type)) {
    sideEffectTypes[type] = leapTypes[type];
  }
}

exports.hasSideEffects = makePredicate("hasSideEffects", sideEffectTypes);
exports.containsLeap = makePredicate("containsLeap", leapTypes);

/***/ }),
/* 178 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

/*
  Copyright (C) 2013 Yusuke Suzuki <utatane.tea@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


(function () {
    'use strict';

    exports.ast = __webpack_require__(531);
    exports.code = __webpack_require__(613);
    exports.keyword = __webpack_require__(58);
}());
/* vim: set sw=4 ts=4 et tw=80 : */


/***/ }),
/* 179 */,
/* 180 */
/***/ (function(module) {

module.exports={A:"ie",B:"edge",C:"firefox",D:"chrome",E:"safari",F:"opera",G:"ios_saf",H:"op_mini",I:"android",J:"bb",K:"op_mob",L:"and_chr",M:"and_ff",N:"ie_mob",O:"and_uc",P:"samsung",Q:"and_qq",R:"baidu",S:"kaios"};


/***/ }),
/* 181 */,
/* 182 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = normalizeOptions;

function _path() {
  const data = _interopRequireDefault(__webpack_require__(267));

  _path = function () {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function normalizeOptions(config) {
  const {
    filename,
    cwd,
    filenameRelative = typeof filename === "string" ? _path().default.relative(cwd, filename) : "unknown",
    sourceType = "module",
    inputSourceMap,
    sourceMaps = !!inputSourceMap,
    moduleRoot,
    sourceRoot = moduleRoot,
    sourceFileName = _path().default.basename(filenameRelative),
    comments = true,
    compact = "auto"
  } = config.options;
  const opts = config.options;
  const options = Object.assign({}, opts, {
    parserOpts: Object.assign({
      sourceType: _path().default.extname(filenameRelative) === ".mjs" ? "module" : sourceType,
      sourceFileName: filename,
      plugins: []
    }, opts.parserOpts),
    generatorOpts: Object.assign({
      filename,
      auxiliaryCommentBefore: opts.auxiliaryCommentBefore,
      auxiliaryCommentAfter: opts.auxiliaryCommentAfter,
      retainLines: opts.retainLines,
      comments,
      shouldPrintComment: opts.shouldPrintComment,
      compact,
      minified: opts.minified,
      sourceMaps,
      sourceRoot,
      sourceFileName
    }, opts.generatorOpts)
  });

  for (const plugins of config.passes) {
    for (const plugin of plugins) {
      if (plugin.manipulateOptions) {
        plugin.manipulateOptions(options, options.parserOpts);
      }
    }
  }

  return options;
}

/***/ }),
/* 183 */,
/* 184 */
/***/ (function(module) {

module.exports = {
	"8.0": "79",
	"7.1": "78",
	"7.0": "78",
	"6.1": "76",
	"6.0": "76",
	"5.0": "72",
	"4.2": "69",
	"4.1": "69",
	"4.0": "69",
	"3.1": "66",
	"3.0": "66",
	"2.1": "61",
	"2.0": "61",
	"1.8": "59",
	"1.7": "58",
	"1.6": "56",
	"1.5": "54",
	"1.4": "53",
	"1.3": "52",
	"1.2": "51",
	"1.1": "50",
	"1.0": "49",
	"0.37": "49",
	"0.36": "47",
	"0.35": "45",
	"0.34": "45",
	"0.33": "45",
	"0.32": "45",
	"0.31": "44",
	"0.30": "44",
	"0.29": "43",
	"0.28": "43",
	"0.27": "42",
	"0.26": "42",
	"0.25": "42",
	"0.24": "41",
	"0.23": "41",
	"0.22": "41",
	"0.21": "40",
	"0.20": "39"
};

/***/ }),
/* 185 */,
/* 186 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseGetTag = __webpack_require__(51),
    isObjectLike = __webpack_require__(337);

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

module.exports = isSymbol;


/***/ }),
/* 187 */,
/* 188 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = splitExportDeclaration;

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function splitExportDeclaration(exportDeclaration) {
  if (!exportDeclaration.isExportDeclaration()) {
    throw new Error("Only export declarations can be splitted.");
  }

  const isDefault = exportDeclaration.isExportDefaultDeclaration();
  const declaration = exportDeclaration.get("declaration");
  const isClassDeclaration = declaration.isClassDeclaration();

  if (isDefault) {
    const standaloneDeclaration = declaration.isFunctionDeclaration() || isClassDeclaration;
    const scope = declaration.isScope() ? declaration.scope.parent : declaration.scope;
    let id = declaration.node.id;
    let needBindingRegistration = false;

    if (!id) {
      needBindingRegistration = true;
      id = scope.generateUidIdentifier("default");

      if (standaloneDeclaration || declaration.isFunctionExpression() || declaration.isClassExpression()) {
        declaration.node.id = t.cloneNode(id);
      }
    }

    const updatedDeclaration = standaloneDeclaration ? declaration : t.variableDeclaration("var", [t.variableDeclarator(t.cloneNode(id), declaration.node)]);
    const updatedExportDeclaration = t.exportNamedDeclaration(null, [t.exportSpecifier(t.cloneNode(id), t.identifier("default"))]);
    exportDeclaration.insertAfter(updatedExportDeclaration);
    exportDeclaration.replaceWith(updatedDeclaration);

    if (needBindingRegistration) {
      scope.registerDeclaration(exportDeclaration);
    }

    return exportDeclaration;
  }

  if (exportDeclaration.get("specifiers").length > 0) {
    throw new Error("It doesn't make sense to split exported specifiers.");
  }

  const bindingIdentifiers = declaration.getOuterBindingIdentifiers();
  const specifiers = Object.keys(bindingIdentifiers).map(name => {
    return t.exportSpecifier(t.identifier(name), t.identifier(name));
  });
  const aliasDeclar = t.exportNamedDeclaration(null, specifiers);
  exportDeclaration.insertAfter(aliasDeclar);
  exportDeclaration.replaceWith(declaration.node);
  return exportDeclaration;
}

/***/ }),
/* 189 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2014 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

var util = __webpack_require__(290);

/**
 * Determine whether mappingB is after mappingA with respect to generated
 * position.
 */
function generatedPositionAfter(mappingA, mappingB) {
  // Optimized for most common case
  var lineA = mappingA.generatedLine;
  var lineB = mappingB.generatedLine;
  var columnA = mappingA.generatedColumn;
  var columnB = mappingB.generatedColumn;
  return lineB > lineA || lineB == lineA && columnB >= columnA ||
         util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
}

/**
 * A data structure to provide a sorted view of accumulated mappings in a
 * performance conscious manner. It trades a neglibable overhead in general
 * case for a large speedup in case of mappings being added in order.
 */
function MappingList() {
  this._array = [];
  this._sorted = true;
  // Serves as infimum
  this._last = {generatedLine: -1, generatedColumn: 0};
}

/**
 * Iterate through internal items. This method takes the same arguments that
 * `Array.prototype.forEach` takes.
 *
 * NOTE: The order of the mappings is NOT guaranteed.
 */
MappingList.prototype.unsortedForEach =
  function MappingList_forEach(aCallback, aThisArg) {
    this._array.forEach(aCallback, aThisArg);
  };

/**
 * Add the given source mapping.
 *
 * @param Object aMapping
 */
MappingList.prototype.add = function MappingList_add(aMapping) {
  if (generatedPositionAfter(this._last, aMapping)) {
    this._last = aMapping;
    this._array.push(aMapping);
  } else {
    this._sorted = false;
    this._array.push(aMapping);
  }
};

/**
 * Returns the flat, sorted array of mappings. The mappings are sorted by
 * generated position.
 *
 * WARNING: This method returns internal data without copying, for
 * performance. The return value must NOT be mutated, and should be treated as
 * an immutable borrow. If you want to take ownership, you must make your own
 * copy.
 */
MappingList.prototype.toArray = function MappingList_toArray() {
  if (!this._sorted) {
    this._array.sort(util.compareByGeneratedPositionsInflated);
    this._sorted = true;
  }
  return this._array;
};

exports.MappingList = MappingList;


/***/ }),
/* 190 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseIsEqualDeep = __webpack_require__(120),
    isObjectLike = __webpack_require__(337);

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

module.exports = baseIsEqual;


/***/ }),
/* 191 */,
/* 192 */,
/* 193 */,
/* 194 */
/***/ (function(__unusedmodule, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeStrongCache = makeStrongCache;
exports.makeWeakCache = makeWeakCache;
exports.assertSimpleType = assertSimpleType;

function makeStrongCache(handler) {
  return makeCachedFunction(new Map(), handler);
}

function makeWeakCache(handler) {
  return makeCachedFunction(new WeakMap(), handler);
}

function makeCachedFunction(callCache, handler) {
  return function cachedFunction(arg, data) {
    let cachedValue = callCache.get(arg);

    if (cachedValue) {
      for (const _ref of cachedValue) {
        const {
          value,
          valid
        } = _ref;
        if (valid(data)) return value;
      }
    }

    const cache = new CacheConfigurator(data);
    const value = handler(arg, cache);
    if (!cache.configured()) cache.forever();
    cache.deactivate();

    switch (cache.mode()) {
      case "forever":
        cachedValue = [{
          value,
          valid: () => true
        }];
        callCache.set(arg, cachedValue);
        break;

      case "invalidate":
        cachedValue = [{
          value,
          valid: cache.validator()
        }];
        callCache.set(arg, cachedValue);
        break;

      case "valid":
        if (cachedValue) {
          cachedValue.push({
            value,
            valid: cache.validator()
          });
        } else {
          cachedValue = [{
            value,
            valid: cache.validator()
          }];
          callCache.set(arg, cachedValue);
        }

    }

    return value;
  };
}

class CacheConfigurator {
  constructor(data) {
    this._active = true;
    this._never = false;
    this._forever = false;
    this._invalidate = false;
    this._configured = false;
    this._pairs = [];
    this._data = data;
  }

  simple() {
    return makeSimpleConfigurator(this);
  }

  mode() {
    if (this._never) return "never";
    if (this._forever) return "forever";
    if (this._invalidate) return "invalidate";
    return "valid";
  }

  forever() {
    if (!this._active) {
      throw new Error("Cannot change caching after evaluation has completed.");
    }

    if (this._never) {
      throw new Error("Caching has already been configured with .never()");
    }

    this._forever = true;
    this._configured = true;
  }

  never() {
    if (!this._active) {
      throw new Error("Cannot change caching after evaluation has completed.");
    }

    if (this._forever) {
      throw new Error("Caching has already been configured with .forever()");
    }

    this._never = true;
    this._configured = true;
  }

  using(handler) {
    if (!this._active) {
      throw new Error("Cannot change caching after evaluation has completed.");
    }

    if (this._never || this._forever) {
      throw new Error("Caching has already been configured with .never or .forever()");
    }

    this._configured = true;
    const key = handler(this._data);

    this._pairs.push([key, handler]);

    return key;
  }

  invalidate(handler) {
    if (!this._active) {
      throw new Error("Cannot change caching after evaluation has completed.");
    }

    if (this._never || this._forever) {
      throw new Error("Caching has already been configured with .never or .forever()");
    }

    this._invalidate = true;
    this._configured = true;
    const key = handler(this._data);

    this._pairs.push([key, handler]);

    return key;
  }

  validator() {
    const pairs = this._pairs;
    return data => pairs.every(([key, fn]) => key === fn(data));
  }

  deactivate() {
    this._active = false;
  }

  configured() {
    return this._configured;
  }

}

function makeSimpleConfigurator(cache) {
  function cacheFn(val) {
    if (typeof val === "boolean") {
      if (val) cache.forever();else cache.never();
      return;
    }

    return cache.using(() => assertSimpleType(val()));
  }

  cacheFn.forever = () => cache.forever();

  cacheFn.never = () => cache.never();

  cacheFn.using = cb => cache.using(() => assertSimpleType(cb()));

  cacheFn.invalidate = cb => cache.invalidate(() => assertSimpleType(cb()));

  return cacheFn;
}

function assertSimpleType(value) {
  if (value != null && typeof value !== "string" && typeof value !== "boolean" && typeof value !== "number") {
    throw new Error("Cache keys must be either string, boolean, number, null, or undefined.");
  }

  return value;
}

/***/ }),
/* 195 */,
/* 196 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isVar;

var _generated = __webpack_require__(897);

var _constants = __webpack_require__(68);

function isVar(node) {
  return (0, _generated.isVariableDeclaration)(node, {
    kind: "var"
  }) && !node[_constants.BLOCK_SCOPED_SYMBOL];
}

/***/ }),
/* 197 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var core = __webpack_require__(391);
var fs = __webpack_require__(747);
var path = __webpack_require__(267);
var caller = __webpack_require__(200);
var nodeModulesPaths = __webpack_require__(575);
var normalizeOptions = __webpack_require__(666);

var defaultIsFile = function isFile(file) {
    try {
        var stat = fs.statSync(file);
    } catch (e) {
        if (e && (e.code === 'ENOENT' || e.code === 'ENOTDIR')) return false;
        throw e;
    }
    return stat.isFile() || stat.isFIFO();
};

var defaultIsDir = function isDirectory(dir) {
    try {
        var stat = fs.statSync(dir);
    } catch (e) {
        if (e && (e.code === 'ENOENT' || e.code === 'ENOTDIR')) return false;
        throw e;
    }
    return stat.isDirectory();
};

var maybeUnwrapSymlink = function maybeUnwrapSymlink(x, opts) {
    if (opts && opts.preserveSymlinks === false) {
        try {
            return fs.realpathSync(x);
        } catch (realPathErr) {
            if (realPathErr.code !== 'ENOENT') {
                throw realPathErr;
            }
        }
    }
    return x;
};

module.exports = function (x, options) {
    if (typeof x !== 'string') {
        throw new TypeError('Path must be a string.');
    }
    var opts = normalizeOptions(x, options);

    var isFile = opts.isFile || defaultIsFile;
    var readFileSync = opts.readFileSync || fs.readFileSync;
    var isDirectory = opts.isDirectory || defaultIsDir;

    var extensions = opts.extensions || ['.js'];
    var basedir = opts.basedir || path.dirname(caller());
    var parent = opts.filename || basedir;

    opts.paths = opts.paths || [];

    // ensure that `basedir` is an absolute path at this point, resolving against the process' current working directory
    var absoluteStart = maybeUnwrapSymlink(path.resolve(basedir), opts);

    if ((/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/).test(x)) {
        var res = path.resolve(absoluteStart, x);
        if (x === '..' || x.slice(-1) === '/') res += '/';
        var m = loadAsFileSync(res) || loadAsDirectorySync(res);
        if (m) return maybeUnwrapSymlink(m, opts);
    } else if (core[x]) {
        return x;
    } else {
        var n = loadNodeModulesSync(x, absoluteStart);
        if (n) return maybeUnwrapSymlink(n, opts);
    }

    if (core[x]) return x;

    var err = new Error("Cannot find module '" + x + "' from '" + parent + "'");
    err.code = 'MODULE_NOT_FOUND';
    throw err;

    function loadAsFileSync(x) {
        var pkg = loadpkg(path.dirname(x));

        if (pkg && pkg.dir && pkg.pkg && opts.pathFilter) {
            var rfile = path.relative(pkg.dir, x);
            var r = opts.pathFilter(pkg.pkg, x, rfile);
            if (r) {
                x = path.resolve(pkg.dir, r); // eslint-disable-line no-param-reassign
            }
        }

        if (isFile(x)) {
            return x;
        }

        for (var i = 0; i < extensions.length; i++) {
            var file = x + extensions[i];
            if (isFile(file)) {
                return file;
            }
        }
    }

    function loadpkg(dir) {
        if (dir === '' || dir === '/') return;
        if (process.platform === 'win32' && (/^\w:[/\\]*$/).test(dir)) {
            return;
        }
        if ((/[/\\]node_modules[/\\]*$/).test(dir)) return;

        var pkgfile = path.join(maybeUnwrapSymlink(dir, opts), 'package.json');

        if (!isFile(pkgfile)) {
            return loadpkg(path.dirname(dir));
        }

        var body = readFileSync(pkgfile);

        try {
            var pkg = JSON.parse(body);
        } catch (jsonErr) {}

        if (pkg && opts.packageFilter) {
            pkg = opts.packageFilter(pkg, pkgfile, dir);
        }

        return { pkg: pkg, dir: dir };
    }

    function loadAsDirectorySync(x) {
        var pkgfile = path.join(maybeUnwrapSymlink(x, opts), '/package.json');
        if (isFile(pkgfile)) {
            try {
                var body = readFileSync(pkgfile, 'UTF8');
                var pkg = JSON.parse(body);
            } catch (e) {}

            if (pkg && opts.packageFilter) {
                pkg = opts.packageFilter(pkg, pkgfile, x);
            }

            if (pkg && pkg.main) {
                if (typeof pkg.main !== 'string') {
                    var mainError = new TypeError('package “' + pkg.name + '” `main` must be a string');
                    mainError.code = 'INVALID_PACKAGE_MAIN';
                    throw mainError;
                }
                if (pkg.main === '.' || pkg.main === './') {
                    pkg.main = 'index';
                }
                try {
                    var m = loadAsFileSync(path.resolve(x, pkg.main));
                    if (m) return m;
                    var n = loadAsDirectorySync(path.resolve(x, pkg.main));
                    if (n) return n;
                } catch (e) {}
            }
        }

        return loadAsFileSync(path.join(x, '/index'));
    }

    function loadNodeModulesSync(x, start) {
        var dirs = nodeModulesPaths(start, opts, x);
        for (var i = 0; i < dirs.length; i++) {
            var dir = dirs[i];
            if (isDirectory(dir)) {
                var m = loadAsFileSync(path.join(dir, '/', x));
                if (m) return m;
                var n = loadAsDirectorySync(path.join(dir, '/', x));
                if (n) return n;
            }
        }
    }
};


/***/ }),
/* 198 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = __webpack_require__(57);

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

function _helperBuilderBinaryAssignmentOperatorVisitor() {
  const data = _interopRequireDefault(__webpack_require__(996));

  _helperBuilderBinaryAssignmentOperatorVisitor = function () {
    return data;
  };

  return data;
}

function _core() {
  const data = __webpack_require__(278);

  _core = function () {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = (0, _helperPluginUtils().declare)(api => {
  api.assertVersion(7);
  return {
    name: "transform-exponentiation-operator",
    visitor: (0, _helperBuilderBinaryAssignmentOperatorVisitor().default)({
      operator: "**",

      build(left, right) {
        return _core().types.callExpression(_core().types.memberExpression(_core().types.identifier("Math"), _core().types.identifier("pow")), [left, right]);
      }

    })
  };
});

exports.default = _default;

/***/ }),
/* 199 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseIsMatch = __webpack_require__(255),
    getMatchData = __webpack_require__(517),
    matchesStrictComparable = __webpack_require__(2);

/**
 * The base implementation of `_.matches` which doesn't clone `source`.
 *
 * @private
 * @param {Object} source The object of property values to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatches(source) {
  var matchData = getMatchData(source);
  if (matchData.length == 1 && matchData[0][2]) {
    return matchesStrictComparable(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source || baseIsMatch(object, source, matchData);
  };
}

module.exports = baseMatches;


/***/ }),
/* 200 */
/***/ (function(module) {

module.exports = function () {
    // see https://code.google.com/p/v8/wiki/JavaScriptStackTraceApi
    var origPrepareStackTrace = Error.prepareStackTrace;
    Error.prepareStackTrace = function (_, stack) { return stack; };
    var stack = (new Error()).stack;
    Error.prepareStackTrace = origPrepareStackTrace;
    return stack[2].getFileName();
};


/***/ }),
/* 201 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = __webpack_require__(57);

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

var _default = (0, _helperPluginUtils().declare)(api => {
  api.assertVersion(7);
  return {
    name: "syntax-dynamic-import",

    manipulateOptions(opts, parserOpts) {
      parserOpts.plugins.push("dynamicImport");
    }

  };
});

exports.default = _default;

/***/ }),
/* 202 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _helperCreateRegexpFeaturesPlugin = __webpack_require__(362);

var _helperPluginUtils = __webpack_require__(57);

var _default = (0, _helperPluginUtils.declare)(api => {
  api.assertVersion(7);
  return (0, _helperCreateRegexpFeaturesPlugin.createRegExpFeaturePlugin)({
    name: "transform-unicode-regex",
    feature: "unicodeFlag"
  });
});

exports.default = _default;

/***/ }),
/* 203 */,
/* 204 */,
/* 205 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _default(node) {
  if (!this.isReferenced()) return;
  const binding = this.scope.getBinding(node.name);

  if (binding) {
    if (binding.identifier.typeAnnotation) {
      return binding.identifier.typeAnnotation;
    } else {
      return getTypeAnnotationBindingConstantViolations(binding, this, node.name);
    }
  }

  if (node.name === "undefined") {
    return t.voidTypeAnnotation();
  } else if (node.name === "NaN" || node.name === "Infinity") {
    return t.numberTypeAnnotation();
  } else if (node.name === "arguments") {}
}

function getTypeAnnotationBindingConstantViolations(binding, path, name) {
  const types = [];
  const functionConstantViolations = [];
  let constantViolations = getConstantViolationsBefore(binding, path, functionConstantViolations);
  const testType = getConditionalAnnotation(binding, path, name);

  if (testType) {
    const testConstantViolations = getConstantViolationsBefore(binding, testType.ifStatement);
    constantViolations = constantViolations.filter(path => testConstantViolations.indexOf(path) < 0);
    types.push(testType.typeAnnotation);
  }

  if (constantViolations.length) {
    constantViolations = constantViolations.concat(functionConstantViolations);

    for (const violation of constantViolations) {
      types.push(violation.getTypeAnnotation());
    }
  }

  if (types.length) {
    return t.createUnionTypeAnnotation(types);
  }
}

function getConstantViolationsBefore(binding, path, functions) {
  const violations = binding.constantViolations.slice();
  violations.unshift(binding.path);
  return violations.filter(violation => {
    violation = violation.resolve();

    const status = violation._guessExecutionStatusRelativeTo(path);

    if (functions && status === "unknown") functions.push(violation);
    return status === "before";
  });
}

function inferAnnotationFromBinaryExpression(name, path) {
  const operator = path.node.operator;
  const right = path.get("right").resolve();
  const left = path.get("left").resolve();
  let target;

  if (left.isIdentifier({
    name
  })) {
    target = right;
  } else if (right.isIdentifier({
    name
  })) {
    target = left;
  }

  if (target) {
    if (operator === "===") {
      return target.getTypeAnnotation();
    }

    if (t.BOOLEAN_NUMBER_BINARY_OPERATORS.indexOf(operator) >= 0) {
      return t.numberTypeAnnotation();
    }

    return;
  }

  if (operator !== "===" && operator !== "==") return;
  let typeofPath;
  let typePath;

  if (left.isUnaryExpression({
    operator: "typeof"
  })) {
    typeofPath = left;
    typePath = right;
  } else if (right.isUnaryExpression({
    operator: "typeof"
  })) {
    typeofPath = right;
    typePath = left;
  }

  if (!typeofPath) return;
  if (!typeofPath.get("argument").isIdentifier({
    name
  })) return;
  typePath = typePath.resolve();
  if (!typePath.isLiteral()) return;
  const typeValue = typePath.node.value;
  if (typeof typeValue !== "string") return;
  return t.createTypeAnnotationBasedOnTypeof(typeValue);
}

function getParentConditionalPath(binding, path, name) {
  let parentPath;

  while (parentPath = path.parentPath) {
    if (parentPath.isIfStatement() || parentPath.isConditionalExpression()) {
      if (path.key === "test") {
        return;
      }

      return parentPath;
    }

    if (parentPath.isFunction()) {
      if (parentPath.parentPath.scope.getBinding(name) !== binding) return;
    }

    path = parentPath;
  }
}

function getConditionalAnnotation(binding, path, name) {
  const ifStatement = getParentConditionalPath(binding, path, name);
  if (!ifStatement) return;
  const test = ifStatement.get("test");
  const paths = [test];
  const types = [];

  for (let i = 0; i < paths.length; i++) {
    const path = paths[i];

    if (path.isLogicalExpression()) {
      if (path.node.operator === "&&") {
        paths.push(path.get("left"));
        paths.push(path.get("right"));
      }
    } else if (path.isBinaryExpression()) {
      const type = inferAnnotationFromBinaryExpression(name, path);
      if (type) types.push(type);
    }
  }

  if (types.length) {
    return {
      typeAnnotation: t.createUnionTypeAnnotation(types),
      ifStatement
    };
  }

  return getConditionalAnnotation(ifStatement, name);
}

/***/ }),
/* 206 */,
/* 207 */,
/* 208 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseGetTag = __webpack_require__(51),
    isObjectLike = __webpack_require__(337);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

module.exports = baseIsArguments;


/***/ }),
/* 209 */,
/* 210 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var getNative = __webpack_require__(319),
    root = __webpack_require__(824);

/* Built-in method references that are verified to be native. */
var DataView = getNative(root, 'DataView');

module.exports = DataView;


/***/ }),
/* 211 */
/***/ (function(module) {

// These mappings represent the syntax proposals that have been
// shipped by browsers, and are enabled by the `shippedProposals` option.

const proposalPlugins = {};

const pluginSyntaxMap = new Map([
  ["proposal-async-generator-functions", "syntax-async-generators"],
  ["proposal-object-rest-spread", "syntax-object-rest-spread"],
  ["proposal-optional-catch-binding", "syntax-optional-catch-binding"],
  ["proposal-unicode-property-regex", null],
  ["proposal-json-strings", "syntax-json-strings"],
]);

module.exports = { proposalPlugins, pluginSyntaxMap };


/***/ }),
/* 212 */,
/* 213 */
/***/ (function(module) {

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

module.exports = arraySome;


/***/ }),
/* 214 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _corejs2BuiltIns = _interopRequireDefault(__webpack_require__(306));

var _getPlatformSpecificDefault = _interopRequireDefault(__webpack_require__(295));

var _filterItems = _interopRequireDefault(__webpack_require__(471));

var _utils = __webpack_require__(882);

var _debug = __webpack_require__(86);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _default(_, {
  include,
  exclude,
  polyfillTargets,
  regenerator,
  debug
}) {
  const polyfills = (0, _filterItems.default)(_corejs2BuiltIns.default, include, exclude, polyfillTargets, (0, _getPlatformSpecificDefault.default)(polyfillTargets));
  const isPolyfillImport = {
    ImportDeclaration(path) {
      if ((0, _utils.isPolyfillSource)((0, _utils.getImportSource)(path))) {
        this.replaceBySeparateModulesImport(path);
      }
    },

    Program(path) {
      path.get("body").forEach(bodyPath => {
        if ((0, _utils.isPolyfillSource)((0, _utils.getRequireSource)(bodyPath))) {
          this.replaceBySeparateModulesImport(bodyPath);
        }
      });
    }

  };
  return {
    name: "corejs2-entry",
    visitor: isPolyfillImport,

    pre() {
      this.importPolyfillIncluded = false;

      this.replaceBySeparateModulesImport = function (path) {
        this.importPolyfillIncluded = true;

        if (regenerator) {
          (0, _utils.createImport)(path, "regenerator-runtime");
        }

        const modules = Array.from(polyfills).reverse();

        for (const module of modules) {
          (0, _utils.createImport)(path, module);
        }

        path.remove();
      };
    },

    post() {
      if (debug) {
        (0, _debug.logEntryPolyfills)("@babel/polyfill", this.importPolyfillIncluded, polyfills, this.file.opts.filename, polyfillTargets, _corejs2BuiltIns.default);
      }
    }

  };
}

/***/ }),
/* 215 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var isSymbol = __webpack_require__(186);

/**
 * Compares values to sort them in ascending order.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {number} Returns the sort order indicator for `value`.
 */
function compareAscending(value, other) {
  if (value !== other) {
    var valIsDefined = value !== undefined,
        valIsNull = value === null,
        valIsReflexive = value === value,
        valIsSymbol = isSymbol(value);

    var othIsDefined = other !== undefined,
        othIsNull = other === null,
        othIsReflexive = other === other,
        othIsSymbol = isSymbol(other);

    if ((!othIsNull && !othIsSymbol && !valIsSymbol && value > other) ||
        (valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol) ||
        (valIsNull && othIsDefined && othIsReflexive) ||
        (!valIsDefined && othIsReflexive) ||
        !valIsReflexive) {
      return 1;
    }
    if ((!valIsNull && !valIsSymbol && !othIsSymbol && value < other) ||
        (othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol) ||
        (othIsNull && valIsDefined && valIsReflexive) ||
        (!othIsDefined && valIsReflexive) ||
        !othIsReflexive) {
      return -1;
    }
  }
  return 0;
}

module.exports = compareAscending;


/***/ }),
/* 216 */,
/* 217 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var arrayMap = __webpack_require__(766),
    baseIndexOf = __webpack_require__(829),
    baseIndexOfWith = __webpack_require__(685),
    baseUnary = __webpack_require__(231),
    copyArray = __webpack_require__(239);

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * The base implementation of `_.pullAllBy` without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to remove.
 * @param {Function} [iteratee] The iteratee invoked per element.
 * @param {Function} [comparator] The comparator invoked per element.
 * @returns {Array} Returns `array`.
 */
function basePullAll(array, values, iteratee, comparator) {
  var indexOf = comparator ? baseIndexOfWith : baseIndexOf,
      index = -1,
      length = values.length,
      seen = array;

  if (array === values) {
    values = copyArray(values);
  }
  if (iteratee) {
    seen = arrayMap(array, baseUnary(iteratee));
  }
  while (++index < length) {
    var fromIndex = 0,
        value = values[index],
        computed = iteratee ? iteratee(value) : value;

    while ((fromIndex = indexOf(seen, computed, fromIndex, comparator)) > -1) {
      if (seen !== array) {
        splice.call(seen, fromIndex, 1);
      }
      splice.call(array, fromIndex, 1);
    }
  }
  return array;
}

module.exports = basePullAll;


/***/ }),
/* 218 */,
/* 219 */,
/* 220 */,
/* 221 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

function helpers() {
  const data = _interopRequireWildcard(__webpack_require__(168));

  helpers = function () {
    return data;
  };

  return data;
}

function _generator() {
  const data = _interopRequireDefault(__webpack_require__(33));

  _generator = function () {
    return data;
  };

  return data;
}

function _template() {
  const data = _interopRequireDefault(__webpack_require__(5));

  _template = function () {
    return data;
  };

  return data;
}

function t() {
  const data = _interopRequireWildcard(__webpack_require__(978));

  t = function () {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const buildUmdWrapper = replacements => _template().default`
    (function (root, factory) {
      if (typeof define === "function" && define.amd) {
        define(AMD_ARGUMENTS, factory);
      } else if (typeof exports === "object") {
        factory(COMMON_ARGUMENTS);
      } else {
        factory(BROWSER_ARGUMENTS);
      }
    })(UMD_ROOT, function (FACTORY_PARAMETERS) {
      FACTORY_BODY
    });
  `(replacements);

function buildGlobal(whitelist) {
  const namespace = t().identifier("babelHelpers");
  const body = [];
  const container = t().functionExpression(null, [t().identifier("global")], t().blockStatement(body));
  const tree = t().program([t().expressionStatement(t().callExpression(container, [t().conditionalExpression(t().binaryExpression("===", t().unaryExpression("typeof", t().identifier("global")), t().stringLiteral("undefined")), t().identifier("self"), t().identifier("global"))]))]);
  body.push(t().variableDeclaration("var", [t().variableDeclarator(namespace, t().assignmentExpression("=", t().memberExpression(t().identifier("global"), namespace), t().objectExpression([])))]));
  buildHelpers(body, namespace, whitelist);
  return tree;
}

function buildModule(whitelist) {
  const body = [];
  const refs = buildHelpers(body, null, whitelist);
  body.unshift(t().exportNamedDeclaration(null, Object.keys(refs).map(name => {
    return t().exportSpecifier(t().cloneNode(refs[name]), t().identifier(name));
  })));
  return t().program(body, [], "module");
}

function buildUmd(whitelist) {
  const namespace = t().identifier("babelHelpers");
  const body = [];
  body.push(t().variableDeclaration("var", [t().variableDeclarator(namespace, t().identifier("global"))]));
  buildHelpers(body, namespace, whitelist);
  return t().program([buildUmdWrapper({
    FACTORY_PARAMETERS: t().identifier("global"),
    BROWSER_ARGUMENTS: t().assignmentExpression("=", t().memberExpression(t().identifier("root"), namespace), t().objectExpression([])),
    COMMON_ARGUMENTS: t().identifier("exports"),
    AMD_ARGUMENTS: t().arrayExpression([t().stringLiteral("exports")]),
    FACTORY_BODY: body,
    UMD_ROOT: t().identifier("this")
  })]);
}

function buildVar(whitelist) {
  const namespace = t().identifier("babelHelpers");
  const body = [];
  body.push(t().variableDeclaration("var", [t().variableDeclarator(namespace, t().objectExpression([]))]));
  const tree = t().program(body);
  buildHelpers(body, namespace, whitelist);
  body.push(t().expressionStatement(namespace));
  return tree;
}

function buildHelpers(body, namespace, whitelist) {
  const getHelperReference = name => {
    return namespace ? t().memberExpression(namespace, t().identifier(name)) : t().identifier(`_${name}`);
  };

  const refs = {};
  helpers().list.forEach(function (name) {
    if (whitelist && whitelist.indexOf(name) < 0) return;
    const ref = refs[name] = getHelperReference(name);
    const {
      nodes
    } = helpers().get(name, getHelperReference, ref);
    body.push(...nodes);
  });
  return refs;
}

function _default(whitelist, outputType = "global") {
  let tree;
  const build = {
    global: buildGlobal,
    module: buildModule,
    umd: buildUmd,
    var: buildVar
  }[outputType];

  if (build) {
    tree = build(whitelist);
  } else {
    throw new Error(`Unsupported output type ${outputType}`);
  }

  return (0, _generator().default)(tree).code;
}

/***/ }),
/* 222 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = literalTemplate;

var _options = __webpack_require__(653);

var _parse = _interopRequireDefault(__webpack_require__(601));

var _populate = _interopRequireDefault(__webpack_require__(392));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function literalTemplate(formatter, tpl, opts) {
  const {
    metadata,
    names
  } = buildLiteralData(formatter, tpl, opts);
  return arg => {
    const defaultReplacements = arg.reduce((acc, replacement, i) => {
      acc[names[i]] = replacement;
      return acc;
    }, {});
    return arg => {
      const replacements = (0, _options.normalizeReplacements)(arg);

      if (replacements) {
        Object.keys(replacements).forEach(key => {
          if (Object.prototype.hasOwnProperty.call(defaultReplacements, key)) {
            throw new Error("Unexpected replacement overlap.");
          }
        });
      }

      return formatter.unwrap((0, _populate.default)(metadata, replacements ? Object.assign(replacements, defaultReplacements) : defaultReplacements));
    };
  };
}

function buildLiteralData(formatter, tpl, opts) {
  let names;
  let nameSet;
  let metadata;
  let prefix = "";

  do {
    prefix += "$";
    const result = buildTemplateCode(tpl, prefix);
    names = result.names;
    nameSet = new Set(names);
    metadata = (0, _parse.default)(formatter, formatter.code(result.code), {
      parser: opts.parser,
      placeholderWhitelist: new Set(result.names.concat(opts.placeholderWhitelist ? Array.from(opts.placeholderWhitelist) : [])),
      placeholderPattern: opts.placeholderPattern,
      preserveComments: opts.preserveComments,
      syntacticPlaceholders: opts.syntacticPlaceholders
    });
  } while (metadata.placeholders.some(placeholder => placeholder.isDuplicate && nameSet.has(placeholder.name)));

  return {
    metadata,
    names
  };
}

function buildTemplateCode(tpl, prefix) {
  const names = [];
  let code = tpl[0];

  for (let i = 1; i < tpl.length; i++) {
    const value = `${prefix}${i - 1}`;
    names.push(value);
    code += value + tpl[i];
  }

  return {
    names,
    code
  };
}

/***/ }),
/* 223 */,
/* 224 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visitor = void 0;

var _core = __webpack_require__(278);

function getTDZStatus(refPath, bindingPath) {
  const executionStatus = bindingPath._guessExecutionStatusRelativeTo(refPath);

  if (executionStatus === "before") {
    return "outside";
  } else if (executionStatus === "after") {
    return "inside";
  } else {
    return "maybe";
  }
}

function buildTDZAssert(node, state) {
  return _core.types.callExpression(state.addHelper("temporalRef"), [node, _core.types.stringLiteral(node.name)]);
}

function isReference(node, scope, state) {
  const declared = state.letReferences[node.name];
  if (!declared) return false;
  return scope.getBindingIdentifier(node.name) === declared;
}

const visitor = {
  ReferencedIdentifier(path, state) {
    if (!state.tdzEnabled) return;
    const {
      node,
      parent,
      scope
    } = path;
    if (path.parentPath.isFor({
      left: node
    })) return;
    if (!isReference(node, scope, state)) return;
    const bindingPath = scope.getBinding(node.name).path;
    if (bindingPath.isFunctionDeclaration()) return;
    const status = getTDZStatus(path, bindingPath);
    if (status === "outside") return;

    if (status === "maybe") {
      const assert = buildTDZAssert(node, state);
      bindingPath.parent._tdzThis = true;
      path.skip();

      if (path.parentPath.isUpdateExpression()) {
        if (parent._ignoreBlockScopingTDZ) return;
        path.parentPath.replaceWith(_core.types.sequenceExpression([assert, parent]));
      } else {
        path.replaceWith(assert);
      }
    } else if (status === "inside") {
      path.replaceWith(_core.template.ast`${state.addHelper("tdz")}("${node.name}")`);
    }
  },

  AssignmentExpression: {
    exit(path, state) {
      if (!state.tdzEnabled) return;
      const {
        node
      } = path;
      if (node._ignoreBlockScopingTDZ) return;
      const nodes = [];
      const ids = path.getBindingIdentifiers();

      for (const name of Object.keys(ids)) {
        const id = ids[name];

        if (isReference(id, path.scope, state)) {
          nodes.push(id);
        }
      }

      if (nodes.length) {
        node._ignoreBlockScopingTDZ = true;
        nodes.push(node);
        path.replaceWithMultiple(nodes.map(n => _core.types.expressionStatement(n)));
      }
    }

  }
};
exports.visitor = visitor;

/***/ }),
/* 225 */,
/* 226 */,
/* 227 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _helperPluginUtils = __webpack_require__(57);

var _helperModuleTransforms = __webpack_require__(448);

var _helperSimpleAccess = _interopRequireDefault(__webpack_require__(803));

var _core = __webpack_require__(278);

var _utils = __webpack_require__(318);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = (0, _helperPluginUtils.declare)((api, options) => {
  api.assertVersion(7);
  const transformImportCall = (0, _utils.createDynamicImportTransform)(api);
  const {
    loose,
    strictNamespace = false,
    mjsStrictNamespace = true,
    allowTopLevelThis,
    strict,
    strictMode,
    noInterop,
    lazy = false,
    allowCommonJSExports = true
  } = options;

  if (typeof lazy !== "boolean" && typeof lazy !== "function" && (!Array.isArray(lazy) || !lazy.every(item => typeof item === "string"))) {
    throw new Error(`.lazy must be a boolean, array of strings, or a function`);
  }

  if (typeof strictNamespace !== "boolean") {
    throw new Error(`.strictNamespace must be a boolean, or undefined`);
  }

  if (typeof mjsStrictNamespace !== "boolean") {
    throw new Error(`.mjsStrictNamespace must be a boolean, or undefined`);
  }

  const getAssertion = localName => _core.template.expression.ast`
    (function(){
      throw new Error(
        "The CommonJS '" + "${localName}" + "' variable is not available in ES6 modules." +
        "Consider setting setting sourceType:script or sourceType:unambiguous in your " +
        "Babel config for this file.");
    })()
  `;

  const moduleExportsVisitor = {
    ReferencedIdentifier(path) {
      const localName = path.node.name;
      if (localName !== "module" && localName !== "exports") return;
      const localBinding = path.scope.getBinding(localName);
      const rootBinding = this.scope.getBinding(localName);

      if (rootBinding !== localBinding || path.parentPath.isObjectProperty({
        value: path.node
      }) && path.parentPath.parentPath.isObjectPattern() || path.parentPath.isAssignmentExpression({
        left: path.node
      }) || path.isAssignmentExpression({
        left: path.node
      })) {
        return;
      }

      path.replaceWith(getAssertion(localName));
    },

    AssignmentExpression(path) {
      const left = path.get("left");

      if (left.isIdentifier()) {
        const localName = path.node.name;
        if (localName !== "module" && localName !== "exports") return;
        const localBinding = path.scope.getBinding(localName);
        const rootBinding = this.scope.getBinding(localName);
        if (rootBinding !== localBinding) return;
        const right = path.get("right");
        right.replaceWith(_core.types.sequenceExpression([right.node, getAssertion(localName)]));
      } else if (left.isPattern()) {
        const ids = left.getOuterBindingIdentifiers();
        const localName = Object.keys(ids).filter(localName => {
          if (localName !== "module" && localName !== "exports") return false;
          return this.scope.getBinding(localName) === path.scope.getBinding(localName);
        })[0];

        if (localName) {
          const right = path.get("right");
          right.replaceWith(_core.types.sequenceExpression([right.node, getAssertion(localName)]));
        }
      }
    }

  };
  return {
    name: "transform-modules-commonjs",

    pre() {
      this.file.set("@babel/plugin-transform-modules-*", "commonjs");
    },

    visitor: {
      CallExpression(path) {
        if (!this.file.has("@babel/plugin-proposal-dynamic-import")) return;
        if (!path.get("callee").isImport()) return;
        let {
          scope
        } = path;

        do {
          scope.rename("require");
        } while (scope = scope.parent);

        transformImportCall(this, path.get("callee"));
      },

      Program: {
        exit(path, state) {
          if (!(0, _helperModuleTransforms.isModule)(path)) return;
          path.scope.rename("exports");
          path.scope.rename("module");
          path.scope.rename("require");
          path.scope.rename("__filename");
          path.scope.rename("__dirname");

          if (!allowCommonJSExports) {
            (0, _helperSimpleAccess.default)(path, new Set(["module", "exports"]));
            path.traverse(moduleExportsVisitor, {
              scope: path.scope
            });
          }

          let moduleName = this.getModuleName();
          if (moduleName) moduleName = _core.types.stringLiteral(moduleName);
          const {
            meta,
            headers
          } = (0, _helperModuleTransforms.rewriteModuleStatementsAndPrepareHeader)(path, {
            exportName: "exports",
            loose,
            strict,
            strictMode,
            allowTopLevelThis,
            noInterop,
            lazy,
            esNamespaceOnly: typeof state.filename === "string" && /\.mjs$/.test(state.filename) ? mjsStrictNamespace : strictNamespace
          });

          for (const [source, metadata] of meta.source) {
            const loadExpr = _core.types.callExpression(_core.types.identifier("require"), [_core.types.stringLiteral(source)]);

            let header;

            if ((0, _helperModuleTransforms.isSideEffectImport)(metadata)) {
              if (metadata.lazy) throw new Error("Assertion failure");
              header = _core.types.expressionStatement(loadExpr);
            } else {
              const init = (0, _helperModuleTransforms.wrapInterop)(path, loadExpr, metadata.interop) || loadExpr;

              if (metadata.lazy) {
                header = _core.template.ast`
                  function ${metadata.name}() {
                    const data = ${init};
                    ${metadata.name} = function(){ return data; };
                    return data;
                  }
                `;
              } else {
                header = _core.template.ast`
                  var ${metadata.name} = ${init};
                `;
              }
            }

            header.loc = metadata.loc;
            headers.push(header);
            headers.push(...(0, _helperModuleTransforms.buildNamespaceInitStatements)(meta, metadata, loose));
          }

          (0, _helperModuleTransforms.ensureStatementsHoisted)(headers);
          path.unshiftContainer("body", headers);
        }

      }
    }
  };
});

exports.default = _default;

/***/ }),
/* 228 */,
/* 229 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var getTag = __webpack_require__(700),
    isObjectLike = __webpack_require__(337);

/** `Object#toString` result references. */
var mapTag = '[object Map]';

/**
 * The base implementation of `_.isMap` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a map, else `false`.
 */
function baseIsMap(value) {
  return isObjectLike(value) && getTag(value) == mapTag;
}

module.exports = baseIsMap;


/***/ }),
/* 230 */,
/* 231 */
/***/ (function(module) {

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

module.exports = baseUnary;


/***/ }),
/* 232 */,
/* 233 */,
/* 234 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var isObject = __webpack_require__(988),
    isSymbol = __webpack_require__(186);

/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** Used to match leading and trailing whitespace. */
var reTrim = /^\s+|\s+$/g;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = value.replace(reTrim, '');
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

module.exports = toNumber;


/***/ }),
/* 235 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildPresetChain = buildPresetChain;
exports.buildRootChain = buildRootChain;
exports.buildPresetChainWalker = void 0;

function _path() {
  const data = _interopRequireDefault(__webpack_require__(267));

  _path = function () {
    return data;
  };

  return data;
}

function _debug() {
  const data = _interopRequireDefault(__webpack_require__(784));

  _debug = function () {
    return data;
  };

  return data;
}

var _options = __webpack_require__(394);

var _patternToRegex = _interopRequireDefault(__webpack_require__(661));

var _files = __webpack_require__(151);

var _caching = __webpack_require__(194);

var _configDescriptors = __webpack_require__(791);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const debug = (0, _debug().default)("babel:config:config-chain");

function buildPresetChain(arg, context) {
  const chain = buildPresetChainWalker(arg, context);
  if (!chain) return null;
  return {
    plugins: dedupDescriptors(chain.plugins),
    presets: dedupDescriptors(chain.presets),
    options: chain.options.map(o => normalizeOptions(o))
  };
}

const buildPresetChainWalker = makeChainWalker({
  init: arg => arg,
  root: preset => loadPresetDescriptors(preset),
  env: (preset, envName) => loadPresetEnvDescriptors(preset)(envName),
  overrides: (preset, index) => loadPresetOverridesDescriptors(preset)(index),
  overridesEnv: (preset, index, envName) => loadPresetOverridesEnvDescriptors(preset)(index)(envName)
});
exports.buildPresetChainWalker = buildPresetChainWalker;
const loadPresetDescriptors = (0, _caching.makeWeakCache)(preset => buildRootDescriptors(preset, preset.alias, _configDescriptors.createUncachedDescriptors));
const loadPresetEnvDescriptors = (0, _caching.makeWeakCache)(preset => (0, _caching.makeStrongCache)(envName => buildEnvDescriptors(preset, preset.alias, _configDescriptors.createUncachedDescriptors, envName)));
const loadPresetOverridesDescriptors = (0, _caching.makeWeakCache)(preset => (0, _caching.makeStrongCache)(index => buildOverrideDescriptors(preset, preset.alias, _configDescriptors.createUncachedDescriptors, index)));
const loadPresetOverridesEnvDescriptors = (0, _caching.makeWeakCache)(preset => (0, _caching.makeStrongCache)(index => (0, _caching.makeStrongCache)(envName => buildOverrideEnvDescriptors(preset, preset.alias, _configDescriptors.createUncachedDescriptors, index, envName))));

function buildRootChain(opts, context) {
  const programmaticChain = loadProgrammaticChain({
    options: opts,
    dirname: context.cwd
  }, context);
  if (!programmaticChain) return null;
  let configFile;

  if (typeof opts.configFile === "string") {
    configFile = (0, _files.loadConfig)(opts.configFile, context.cwd, context.envName, context.caller);
  } else if (opts.configFile !== false) {
    configFile = (0, _files.findRootConfig)(context.root, context.envName, context.caller);
  }

  let {
    babelrc,
    babelrcRoots
  } = opts;
  let babelrcRootsDirectory = context.cwd;
  const configFileChain = emptyChain();

  if (configFile) {
    const validatedFile = validateConfigFile(configFile);
    const result = loadFileChain(validatedFile, context);
    if (!result) return null;

    if (babelrc === undefined) {
      babelrc = validatedFile.options.babelrc;
    }

    if (babelrcRoots === undefined) {
      babelrcRootsDirectory = validatedFile.dirname;
      babelrcRoots = validatedFile.options.babelrcRoots;
    }

    mergeChain(configFileChain, result);
  }

  const pkgData = typeof context.filename === "string" ? (0, _files.findPackageData)(context.filename) : null;
  let ignoreFile, babelrcFile;
  const fileChain = emptyChain();

  if ((babelrc === true || babelrc === undefined) && pkgData && babelrcLoadEnabled(context, pkgData, babelrcRoots, babelrcRootsDirectory)) {
    ({
      ignore: ignoreFile,
      config: babelrcFile
    } = (0, _files.findRelativeConfig)(pkgData, context.envName, context.caller));

    if (ignoreFile && shouldIgnore(context, ignoreFile.ignore, null, ignoreFile.dirname)) {
      return null;
    }

    if (babelrcFile) {
      const result = loadFileChain(validateBabelrcFile(babelrcFile), context);
      if (!result) return null;
      mergeChain(fileChain, result);
    }
  }

  const chain = mergeChain(mergeChain(mergeChain(emptyChain(), configFileChain), fileChain), programmaticChain);
  return {
    plugins: dedupDescriptors(chain.plugins),
    presets: dedupDescriptors(chain.presets),
    options: chain.options.map(o => normalizeOptions(o)),
    ignore: ignoreFile || undefined,
    babelrc: babelrcFile || undefined,
    config: configFile || undefined
  };
}

function babelrcLoadEnabled(context, pkgData, babelrcRoots, babelrcRootsDirectory) {
  if (typeof babelrcRoots === "boolean") return babelrcRoots;
  const absoluteRoot = context.root;

  if (babelrcRoots === undefined) {
    return pkgData.directories.indexOf(absoluteRoot) !== -1;
  }

  let babelrcPatterns = babelrcRoots;
  if (!Array.isArray(babelrcPatterns)) babelrcPatterns = [babelrcPatterns];
  babelrcPatterns = babelrcPatterns.map(pat => {
    return typeof pat === "string" ? _path().default.resolve(babelrcRootsDirectory, pat) : pat;
  });

  if (babelrcPatterns.length === 1 && babelrcPatterns[0] === absoluteRoot) {
    return pkgData.directories.indexOf(absoluteRoot) !== -1;
  }

  return babelrcPatterns.some(pat => {
    if (typeof pat === "string") {
      pat = (0, _patternToRegex.default)(pat, babelrcRootsDirectory);
    }

    return pkgData.directories.some(directory => {
      return matchPattern(pat, babelrcRootsDirectory, directory, context);
    });
  });
}

const validateConfigFile = (0, _caching.makeWeakCache)(file => ({
  filepath: file.filepath,
  dirname: file.dirname,
  options: (0, _options.validate)("configfile", file.options)
}));
const validateBabelrcFile = (0, _caching.makeWeakCache)(file => ({
  filepath: file.filepath,
  dirname: file.dirname,
  options: (0, _options.validate)("babelrcfile", file.options)
}));
const validateExtendFile = (0, _caching.makeWeakCache)(file => ({
  filepath: file.filepath,
  dirname: file.dirname,
  options: (0, _options.validate)("extendsfile", file.options)
}));
const loadProgrammaticChain = makeChainWalker({
  root: input => buildRootDescriptors(input, "base", _configDescriptors.createCachedDescriptors),
  env: (input, envName) => buildEnvDescriptors(input, "base", _configDescriptors.createCachedDescriptors, envName),
  overrides: (input, index) => buildOverrideDescriptors(input, "base", _configDescriptors.createCachedDescriptors, index),
  overridesEnv: (input, index, envName) => buildOverrideEnvDescriptors(input, "base", _configDescriptors.createCachedDescriptors, index, envName)
});
const loadFileChain = makeChainWalker({
  root: file => loadFileDescriptors(file),
  env: (file, envName) => loadFileEnvDescriptors(file)(envName),
  overrides: (file, index) => loadFileOverridesDescriptors(file)(index),
  overridesEnv: (file, index, envName) => loadFileOverridesEnvDescriptors(file)(index)(envName)
});
const loadFileDescriptors = (0, _caching.makeWeakCache)(file => buildRootDescriptors(file, file.filepath, _configDescriptors.createUncachedDescriptors));
const loadFileEnvDescriptors = (0, _caching.makeWeakCache)(file => (0, _caching.makeStrongCache)(envName => buildEnvDescriptors(file, file.filepath, _configDescriptors.createUncachedDescriptors, envName)));
const loadFileOverridesDescriptors = (0, _caching.makeWeakCache)(file => (0, _caching.makeStrongCache)(index => buildOverrideDescriptors(file, file.filepath, _configDescriptors.createUncachedDescriptors, index)));
const loadFileOverridesEnvDescriptors = (0, _caching.makeWeakCache)(file => (0, _caching.makeStrongCache)(index => (0, _caching.makeStrongCache)(envName => buildOverrideEnvDescriptors(file, file.filepath, _configDescriptors.createUncachedDescriptors, index, envName))));

function buildRootDescriptors({
  dirname,
  options
}, alias, descriptors) {
  return descriptors(dirname, options, alias);
}

function buildEnvDescriptors({
  dirname,
  options
}, alias, descriptors, envName) {
  const opts = options.env && options.env[envName];
  return opts ? descriptors(dirname, opts, `${alias}.env["${envName}"]`) : null;
}

function buildOverrideDescriptors({
  dirname,
  options
}, alias, descriptors, index) {
  const opts = options.overrides && options.overrides[index];
  if (!opts) throw new Error("Assertion failure - missing override");
  return descriptors(dirname, opts, `${alias}.overrides[${index}]`);
}

function buildOverrideEnvDescriptors({
  dirname,
  options
}, alias, descriptors, index, envName) {
  const override = options.overrides && options.overrides[index];
  if (!override) throw new Error("Assertion failure - missing override");
  const opts = override.env && override.env[envName];
  return opts ? descriptors(dirname, opts, `${alias}.overrides[${index}].env["${envName}"]`) : null;
}

function makeChainWalker({
  root,
  env,
  overrides,
  overridesEnv
}) {
  return (input, context, files = new Set()) => {
    const {
      dirname
    } = input;
    const flattenedConfigs = [];
    const rootOpts = root(input);

    if (configIsApplicable(rootOpts, dirname, context)) {
      flattenedConfigs.push(rootOpts);
      const envOpts = env(input, context.envName);

      if (envOpts && configIsApplicable(envOpts, dirname, context)) {
        flattenedConfigs.push(envOpts);
      }

      (rootOpts.options.overrides || []).forEach((_, index) => {
        const overrideOps = overrides(input, index);

        if (configIsApplicable(overrideOps, dirname, context)) {
          flattenedConfigs.push(overrideOps);
          const overrideEnvOpts = overridesEnv(input, index, context.envName);

          if (overrideEnvOpts && configIsApplicable(overrideEnvOpts, dirname, context)) {
            flattenedConfigs.push(overrideEnvOpts);
          }
        }
      });
    }

    if (flattenedConfigs.some(({
      options: {
        ignore,
        only
      }
    }) => shouldIgnore(context, ignore, only, dirname))) {
      return null;
    }

    const chain = emptyChain();

    for (const op of flattenedConfigs) {
      if (!mergeExtendsChain(chain, op.options, dirname, context, files)) {
        return null;
      }

      mergeChainOpts(chain, op);
    }

    return chain;
  };
}

function mergeExtendsChain(chain, opts, dirname, context, files) {
  if (opts.extends === undefined) return true;
  const file = (0, _files.loadConfig)(opts.extends, dirname, context.envName, context.caller);

  if (files.has(file)) {
    throw new Error(`Configuration cycle detected loading ${file.filepath}.\n` + `File already loaded following the config chain:\n` + Array.from(files, file => ` - ${file.filepath}`).join("\n"));
  }

  files.add(file);
  const fileChain = loadFileChain(validateExtendFile(file), context, files);
  files.delete(file);
  if (!fileChain) return false;
  mergeChain(chain, fileChain);
  return true;
}

function mergeChain(target, source) {
  target.options.push(...source.options);
  target.plugins.push(...source.plugins);
  target.presets.push(...source.presets);
  return target;
}

function mergeChainOpts(target, {
  options,
  plugins,
  presets
}) {
  target.options.push(options);
  target.plugins.push(...plugins());
  target.presets.push(...presets());
  return target;
}

function emptyChain() {
  return {
    options: [],
    presets: [],
    plugins: []
  };
}

function normalizeOptions(opts) {
  const options = Object.assign({}, opts);
  delete options.extends;
  delete options.env;
  delete options.overrides;
  delete options.plugins;
  delete options.presets;
  delete options.passPerPreset;
  delete options.ignore;
  delete options.only;
  delete options.test;
  delete options.include;
  delete options.exclude;

  if (Object.prototype.hasOwnProperty.call(options, "sourceMap")) {
    options.sourceMaps = options.sourceMap;
    delete options.sourceMap;
  }

  return options;
}

function dedupDescriptors(items) {
  const map = new Map();
  const descriptors = [];

  for (const item of items) {
    if (typeof item.value === "function") {
      const fnKey = item.value;
      let nameMap = map.get(fnKey);

      if (!nameMap) {
        nameMap = new Map();
        map.set(fnKey, nameMap);
      }

      let desc = nameMap.get(item.name);

      if (!desc) {
        desc = {
          value: item
        };
        descriptors.push(desc);
        if (!item.ownPass) nameMap.set(item.name, desc);
      } else {
        desc.value = item;
      }
    } else {
      descriptors.push({
        value: item
      });
    }
  }

  return descriptors.reduce((acc, desc) => {
    acc.push(desc.value);
    return acc;
  }, []);
}

function configIsApplicable({
  options
}, dirname, context) {
  return (options.test === undefined || configFieldIsApplicable(context, options.test, dirname)) && (options.include === undefined || configFieldIsApplicable(context, options.include, dirname)) && (options.exclude === undefined || !configFieldIsApplicable(context, options.exclude, dirname));
}

function configFieldIsApplicable(context, test, dirname) {
  const patterns = Array.isArray(test) ? test : [test];
  return matchesPatterns(context, patterns, dirname);
}

function shouldIgnore(context, ignore, only, dirname) {
  if (ignore && matchesPatterns(context, ignore, dirname)) {
    debug("Ignored %o because it matched one of %O from %o", context.filename, ignore, dirname);
    return true;
  }

  if (only && !matchesPatterns(context, only, dirname)) {
    debug("Ignored %o because it failed to match one of %O from %o", context.filename, only, dirname);
    return true;
  }

  return false;
}

function matchesPatterns(context, patterns, dirname) {
  return patterns.some(pattern => matchPattern(pattern, dirname, context.filename, context));
}

function matchPattern(pattern, dirname, pathToTest, context) {
  if (typeof pattern === "function") {
    return !!pattern(pathToTest, {
      dirname,
      envName: context.envName,
      caller: context.caller
    });
  }

  if (typeof pathToTest !== "string") {
    throw new Error(`Configuration contains string/RegExp pattern, but no filename was passed to Babel`);
  }

  if (typeof pattern === "string") {
    pattern = (0, _patternToRegex.default)(pattern, dirname);
  }

  return pattern.test(pathToTest);
}

/***/ }),
/* 236 */,
/* 237 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = removeComments;

var _constants = __webpack_require__(68);

function removeComments(node) {
  _constants.COMMENT_KEYS.forEach(key => {
    node[key] = null;
  });

  return node;
}

/***/ }),
/* 238 */,
/* 239 */
/***/ (function(module) {

/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

module.exports = copyArray;


/***/ }),
/* 240 */,
/* 241 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function getObjRef(node, nodes, file, scope) {
  let ref;

  if (t.isSuper(node)) {
    return node;
  } else if (t.isIdentifier(node)) {
    if (scope.hasBinding(node.name)) {
      return node;
    } else {
      ref = node;
    }
  } else if (t.isMemberExpression(node)) {
    ref = node.object;

    if (t.isSuper(ref) || t.isIdentifier(ref) && scope.hasBinding(ref.name)) {
      return ref;
    }
  } else {
    throw new Error(`We can't explode this node type ${node.type}`);
  }

  const temp = scope.generateUidIdentifierBasedOnNode(ref);
  scope.push({
    id: temp
  });
  nodes.push(t.assignmentExpression("=", t.cloneNode(temp), t.cloneNode(ref)));
  return temp;
}

function getPropRef(node, nodes, file, scope) {
  const prop = node.property;
  const key = t.toComputedKey(node, prop);
  if (t.isLiteral(key) && t.isPureish(key)) return key;
  const temp = scope.generateUidIdentifierBasedOnNode(prop);
  scope.push({
    id: temp
  });
  nodes.push(t.assignmentExpression("=", t.cloneNode(temp), t.cloneNode(prop)));
  return temp;
}

function _default(node, nodes, file, scope, allowedSingleIdent) {
  let obj;

  if (t.isIdentifier(node) && allowedSingleIdent) {
    obj = node;
  } else {
    obj = getObjRef(node, nodes, file, scope);
  }

  let ref, uid;

  if (t.isIdentifier(node)) {
    ref = t.cloneNode(node);
    uid = obj;
  } else {
    const prop = getPropRef(node, nodes, file, scope);
    const computed = node.computed || t.isLiteral(prop);
    uid = t.memberExpression(t.cloneNode(obj), t.cloneNode(prop), computed);
    ref = t.memberExpression(t.cloneNode(obj), t.cloneNode(prop), computed);
  }

  return {
    uid: uid,
    ref: ref
  };
}

/***/ }),
/* 242 */,
/* 243 */
/***/ (function(__unusedmodule, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = addComments;

function addComments(node, type, comments) {
  if (!comments || !node) return node;
  const key = `${type}Comments`;

  if (node[key]) {
    if (type === "leading") {
      node[key] = comments.concat(node[key]);
    } else {
      node[key] = node[key].concat(comments);
    }
  } else {
    node[key] = comments;
  }

  return node;
}

/***/ }),
/* 244 */
/***/ (function(module) {

"use strict";


var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;

module.exports = function (str) {
	if (typeof str !== 'string') {
		throw new TypeError('Expected a string');
	}

	return str.replace(matchOperatorsRe, '\\$&');
};


/***/ }),
/* 245 */,
/* 246 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var browserVersions = exports.browserVersions = __webpack_require__(79);

/***/ }),
/* 247 */
/***/ (function(module, __unusedexports, __webpack_require__) {

"use strict";

const os = __webpack_require__(87);
const hasFlag = __webpack_require__(364);

const env = process.env;

let forceColor;
if (hasFlag('no-color') ||
	hasFlag('no-colors') ||
	hasFlag('color=false')) {
	forceColor = false;
} else if (hasFlag('color') ||
	hasFlag('colors') ||
	hasFlag('color=true') ||
	hasFlag('color=always')) {
	forceColor = true;
}
if ('FORCE_COLOR' in env) {
	forceColor = env.FORCE_COLOR.length === 0 || parseInt(env.FORCE_COLOR, 10) !== 0;
}

function translateLevel(level) {
	if (level === 0) {
		return false;
	}

	return {
		level,
		hasBasic: true,
		has256: level >= 2,
		has16m: level >= 3
	};
}

function supportsColor(stream) {
	if (forceColor === false) {
		return 0;
	}

	if (hasFlag('color=16m') ||
		hasFlag('color=full') ||
		hasFlag('color=truecolor')) {
		return 3;
	}

	if (hasFlag('color=256')) {
		return 2;
	}

	if (stream && !stream.isTTY && forceColor !== true) {
		return 0;
	}

	const min = forceColor ? 1 : 0;

	if (process.platform === 'win32') {
		// Node.js 7.5.0 is the first version of Node.js to include a patch to
		// libuv that enables 256 color output on Windows. Anything earlier and it
		// won't work. However, here we target Node.js 8 at minimum as it is an LTS
		// release, and Node.js 7 is not. Windows 10 build 10586 is the first Windows
		// release that supports 256 colors. Windows 10 build 14931 is the first release
		// that supports 16m/TrueColor.
		const osRelease = os.release().split('.');
		if (
			Number(process.versions.node.split('.')[0]) >= 8 &&
			Number(osRelease[0]) >= 10 &&
			Number(osRelease[2]) >= 10586
		) {
			return Number(osRelease[2]) >= 14931 ? 3 : 2;
		}

		return 1;
	}

	if ('CI' in env) {
		if (['TRAVIS', 'CIRCLECI', 'APPVEYOR', 'GITLAB_CI'].some(sign => sign in env) || env.CI_NAME === 'codeship') {
			return 1;
		}

		return min;
	}

	if ('TEAMCITY_VERSION' in env) {
		return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
	}

	if (env.COLORTERM === 'truecolor') {
		return 3;
	}

	if ('TERM_PROGRAM' in env) {
		const version = parseInt((env.TERM_PROGRAM_VERSION || '').split('.')[0], 10);

		switch (env.TERM_PROGRAM) {
			case 'iTerm.app':
				return version >= 3 ? 3 : 2;
			case 'Apple_Terminal':
				return 2;
			// No default
		}
	}

	if (/-256(color)?$/i.test(env.TERM)) {
		return 2;
	}

	if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
		return 1;
	}

	if ('COLORTERM' in env) {
		return 1;
	}

	if (env.TERM === 'dumb') {
		return min;
	}

	return min;
}

function getSupportLevel(stream) {
	const level = supportsColor(stream);
	return translateLevel(level);
}

module.exports = {
	supportsColor: getSupportLevel,
	stdout: getSupportLevel(process.stdout),
	stderr: getSupportLevel(process.stderr)
};


/***/ }),
/* 248 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var isFunction = __webpack_require__(10),
    isMasked = __webpack_require__(159),
    isObject = __webpack_require__(988),
    toSource = __webpack_require__(473);

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

module.exports = baseIsNative;


/***/ }),
/* 249 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseIndexOf = __webpack_require__(829),
    isArrayLike = __webpack_require__(146),
    isString = __webpack_require__(935),
    toInteger = __webpack_require__(813),
    values = __webpack_require__(114);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * Checks if `value` is in `collection`. If `collection` is a string, it's
 * checked for a substring of `value`, otherwise
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * is used for equality comparisons. If `fromIndex` is negative, it's used as
 * the offset from the end of `collection`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Collection
 * @param {Array|Object|string} collection The collection to inspect.
 * @param {*} value The value to search for.
 * @param {number} [fromIndex=0] The index to search from.
 * @param- {Object} [guard] Enables use as an iteratee for methods like `_.reduce`.
 * @returns {boolean} Returns `true` if `value` is found, else `false`.
 * @example
 *
 * _.includes([1, 2, 3], 1);
 * // => true
 *
 * _.includes([1, 2, 3], 1, 2);
 * // => false
 *
 * _.includes({ 'a': 1, 'b': 2 }, 1);
 * // => true
 *
 * _.includes('abcd', 'bc');
 * // => true
 */
function includes(collection, value, fromIndex, guard) {
  collection = isArrayLike(collection) ? collection : values(collection);
  fromIndex = (fromIndex && !guard) ? toInteger(fromIndex) : 0;

  var length = collection.length;
  if (fromIndex < 0) {
    fromIndex = nativeMax(length + fromIndex, 0);
  }
  return isString(collection)
    ? (fromIndex <= length && collection.indexOf(value, fromIndex) > -1)
    : (!!length && baseIndexOf(collection, value, fromIndex) > -1);
}

module.exports = includes;


/***/ }),
/* 250 */,
/* 251 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var region = __webpack_require__(941).default
var path = __webpack_require__(267)
var fs = __webpack_require__(747)

var BrowserslistError = __webpack_require__(76)

var IS_SECTION = /^\s*\[(.+)\]\s*$/
var CONFIG_PATTERN = /^browserslist-config-/
var SCOPED_CONFIG__PATTERN = /@[^/]+\/browserslist-config(-|$|\/)/
var TIME_TO_UPDATE_CANIUSE = 6 * 30 * 24 * 60 * 60 * 1000
var FORMAT = 'Browserslist config should be a string or an array ' +
             'of strings with browser queries'

var dataTimeChecked = false
var filenessCache = { }
var configCache = { }
function checkExtend (name) {
  var use = ' Use `dangerousExtend` option to disable.'
  if (!CONFIG_PATTERN.test(name) && !SCOPED_CONFIG__PATTERN.test(name)) {
    throw new BrowserslistError(
      'Browserslist config needs `browserslist-config-` prefix. ' + use)
  }
  if (name.replace(/^@[^/]+\//, '').indexOf('.') !== -1) {
    throw new BrowserslistError(
      '`.` not allowed in Browserslist config name. ' + use)
  }
  if (name.indexOf('node_modules') !== -1) {
    throw new BrowserslistError(
      '`node_modules` not allowed in Browserslist config.' + use)
  }
}

function isFile (file) {
  if (file in filenessCache) {
    return filenessCache[file]
  }
  var result = fs.existsSync(file) && fs.statSync(file).isFile()
  if (!process.env.BROWSERSLIST_DISABLE_CACHE) {
    filenessCache[file] = result
  }
  return result
}

function eachParent (file, callback) {
  var dir = isFile(file) ? path.dirname(file) : file
  var loc = path.resolve(dir)
  do {
    var result = callback(loc)
    if (typeof result !== 'undefined') return result
  } while (loc !== (loc = path.dirname(loc)))
  return undefined
}

function check (section) {
  if (Array.isArray(section)) {
    for (var i = 0; i < section.length; i++) {
      if (typeof section[i] !== 'string') {
        throw new BrowserslistError(FORMAT)
      }
    }
  } else if (typeof section !== 'string') {
    throw new BrowserslistError(FORMAT)
  }
}

function pickEnv (config, opts) {
  if (typeof config !== 'object') return config

  var name
  if (typeof opts.env === 'string') {
    name = opts.env
  } else if (process.env.BROWSERSLIST_ENV) {
    name = process.env.BROWSERSLIST_ENV
  } else if (process.env.NODE_ENV) {
    name = process.env.NODE_ENV
  } else {
    name = 'production'
  }

  return config[name] || config.defaults
}

function parsePackage (file) {
  var config = JSON.parse(fs.readFileSync(file))
  if (config.browserlist && !config.browserslist) {
    throw new BrowserslistError(
      '`browserlist` key instead of `browserslist` in ' + file
    )
  }
  var list = config.browserslist
  if (Array.isArray(list) || typeof list === 'string') {
    list = { defaults: list }
  }
  for (var i in list) {
    check(list[i])
  }

  return list
}

function latestReleaseTime (agents) {
  var latest = 0
  for (var name in agents) {
    var dates = agents[name].releaseDate || { }
    for (var key in dates) {
      if (latest < dates[key]) {
        latest = dates[key]
      }
    }
  }
  return latest * 1000
}

module.exports = {
  loadQueries: function loadQueries (context, name) {
    if (!context.dangerousExtend) checkExtend(name)
    // eslint-disable-next-line security/detect-non-literal-require
    var queries = require(__webpack_require__(69).resolve(name, { paths: ['.'] }))
    if (!Array.isArray(queries)) {
      throw new BrowserslistError(
        '`' + name + '` config exports not an array of queries'
      )
    }
    return queries
  },

  getStat: function getStat (opts, data) {
    var stats
    if (opts.stats) {
      stats = opts.stats
    } else if (process.env.BROWSERSLIST_STATS) {
      stats = process.env.BROWSERSLIST_STATS
    } else if (opts.path && path.resolve && fs.existsSync) {
      stats = eachParent(opts.path, function (dir) {
        var file = path.join(dir, 'browserslist-stats.json')
        return isFile(file) ? file : undefined
      })
    }

    if (typeof stats === 'string') {
      try {
        stats = JSON.parse(fs.readFileSync(stats))
      } catch (e) {
        throw new BrowserslistError('Can\'t read ' + stats)
      }
    }

    if (stats && 'dataByBrowser' in stats) {
      stats = stats.dataByBrowser
    }

    if (typeof stats !== 'object') return undefined

    var normalized = { }
    for (var i in stats) {
      var versions = Object.keys(stats[i])
      if (versions.length === 1 && data[i] && data[i].versions.length === 1) {
        var normal = Object.keys(data[i].versions)[0]
        normalized[i] = { }
        normalized[i][normal] = stats[i][versions[0]]
      } else {
        normalized[i] = stats[i]
      }
    }

    return normalized
  },

  loadConfig: function loadConfig (opts) {
    if (process.env.BROWSERSLIST) {
      return process.env.BROWSERSLIST
    } else if (opts.config || process.env.BROWSERSLIST_CONFIG) {
      var file = opts.config || process.env.BROWSERSLIST_CONFIG
      if (path.basename(file) === 'package.json') {
        return pickEnv(parsePackage(file), opts)
      } else {
        return pickEnv(module.exports.readConfig(file), opts)
      }
    } else if (opts.path) {
      return pickEnv(module.exports.findConfig(opts.path), opts)
    } else {
      return undefined
    }
  },

  loadCountry: function loadCountry (usage, country) {
    var code = country.replace(/[^\w-]/g, '')
    if (!usage[code]) {
      // eslint-disable-next-line security/detect-non-literal-require
      var compressed = require('caniuse-lite/data/regions/' + code + '.js')
      var data = region(compressed)
      usage[country] = { }
      for (var i in data) {
        for (var j in data[i]) {
          usage[country][i + ' ' + j] = data[i][j]
        }
      }
    }
  },

  parseConfig: function parseConfig (string) {
    var result = { defaults: [] }
    var sections = ['defaults']

    string.toString()
      .replace(/#[^\n]*/g, '')
      .split(/\n|,/)
      .map(function (line) {
        return line.trim()
      })
      .filter(function (line) {
        return line !== ''
      })
      .forEach(function (line) {
        if (IS_SECTION.test(line)) {
          sections = line.match(IS_SECTION)[1].trim().split(' ')
          sections.forEach(function (section) {
            if (result[section]) {
              throw new BrowserslistError(
                'Duplicate section ' + section + ' in Browserslist config'
              )
            }
            result[section] = []
          })
        } else {
          sections.forEach(function (section) {
            result[section].push(line)
          })
        }
      })

    return result
  },

  readConfig: function readConfig (file) {
    if (!isFile(file)) {
      throw new BrowserslistError('Can\'t read ' + file + ' config')
    }
    return module.exports.parseConfig(fs.readFileSync(file))
  },

  findConfig: function findConfig (from) {
    from = path.resolve(from)

    var passed = []
    var resolved = eachParent(from, function (dir) {
      if (dir in configCache) {
        return configCache[dir]
      }

      passed.push(dir)

      var config = path.join(dir, 'browserslist')
      var pkg = path.join(dir, 'package.json')
      var rc = path.join(dir, '.browserslistrc')

      var pkgBrowserslist
      if (isFile(pkg)) {
        try {
          pkgBrowserslist = parsePackage(pkg)
        } catch (e) {
          if (e.name === 'BrowserslistError') throw e
          console.warn(
            '[Browserslist] Could not parse ' + pkg + '. Ignoring it.'
          )
        }
      }

      if (isFile(config) && pkgBrowserslist) {
        throw new BrowserslistError(
          dir + ' contains both browserslist and package.json with browsers'
        )
      } else if (isFile(rc) && pkgBrowserslist) {
        throw new BrowserslistError(
          dir + ' contains both .browserslistrc and package.json with browsers'
        )
      } else if (isFile(config) && isFile(rc)) {
        throw new BrowserslistError(
          dir + ' contains both .browserslistrc and browserslist'
        )
      } else if (isFile(config)) {
        return module.exports.readConfig(config)
      } else if (isFile(rc)) {
        return module.exports.readConfig(rc)
      } else {
        return pkgBrowserslist
      }
    })
    if (!process.env.BROWSERSLIST_DISABLE_CACHE) {
      passed.forEach(function (dir) {
        configCache[dir] = resolved
      })
    }
    return resolved
  },

  clearCaches: function clearCaches () {
    dataTimeChecked = false
    filenessCache = { }
    configCache = { }
  },

  oldDataWarning: function oldDataWarning (agentsObj) {
    if (dataTimeChecked) return
    dataTimeChecked = true
    if (process.env.BROWSERSLIST_IGNORE_OLD_DATA) return

    var latest = latestReleaseTime(agentsObj)
    var halfYearAgo = Date.now() - TIME_TO_UPDATE_CANIUSE

    if (latest !== 0 && latest < halfYearAgo) {
      var command = 'npm update'
      eachParent(__filename, function (dir) {
        var pckg = path.join(dir, 'package.json')
        var yarnLock = path.join(dir, 'yarn.lock')
        if (isFile(pckg) && isFile(yarnLock)) {
          command = 'yarn upgrade'
        }
      })
      console.warn(
        'Browserslist: caniuse-lite is outdated. ' +
        'Please run next command `' + command + '`'
      )
    }
  },

  currentNode: function currentNode () {
    return 'node ' + process.versions.node
  }
}


/***/ }),
/* 252 */,
/* 253 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = inheritTrailingComments;

var _inherit = _interopRequireDefault(__webpack_require__(723));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function inheritTrailingComments(child, parent) {
  (0, _inherit.default)("trailingComments", child, parent);
}

/***/ }),
/* 254 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";
// Generated using `npm run build`. Do not edit.


const regenerate = __webpack_require__(388);

exports.REGULAR = new Map([
	['d', regenerate()
		.addRange(0x30, 0x39)],
	['D', regenerate()
		.addRange(0x0, 0x2F)
		.addRange(0x3A, 0xFFFF)],
	['s', regenerate(0x20, 0xA0, 0x1680, 0x202F, 0x205F, 0x3000, 0xFEFF)
		.addRange(0x9, 0xD)
		.addRange(0x2000, 0x200A)
		.addRange(0x2028, 0x2029)],
	['S', regenerate()
		.addRange(0x0, 0x8)
		.addRange(0xE, 0x1F)
		.addRange(0x21, 0x9F)
		.addRange(0xA1, 0x167F)
		.addRange(0x1681, 0x1FFF)
		.addRange(0x200B, 0x2027)
		.addRange(0x202A, 0x202E)
		.addRange(0x2030, 0x205E)
		.addRange(0x2060, 0x2FFF)
		.addRange(0x3001, 0xFEFE)
		.addRange(0xFF00, 0xFFFF)],
	['w', regenerate(0x5F)
		.addRange(0x30, 0x39)
		.addRange(0x41, 0x5A)
		.addRange(0x61, 0x7A)],
	['W', regenerate(0x60)
		.addRange(0x0, 0x2F)
		.addRange(0x3A, 0x40)
		.addRange(0x5B, 0x5E)
		.addRange(0x7B, 0xFFFF)]
]);

exports.UNICODE = new Map([
	['d', regenerate()
		.addRange(0x30, 0x39)],
	['D', regenerate()
		.addRange(0x0, 0x2F)
		.addRange(0x3A, 0x10FFFF)],
	['s', regenerate(0x20, 0xA0, 0x1680, 0x202F, 0x205F, 0x3000, 0xFEFF)
		.addRange(0x9, 0xD)
		.addRange(0x2000, 0x200A)
		.addRange(0x2028, 0x2029)],
	['S', regenerate()
		.addRange(0x0, 0x8)
		.addRange(0xE, 0x1F)
		.addRange(0x21, 0x9F)
		.addRange(0xA1, 0x167F)
		.addRange(0x1681, 0x1FFF)
		.addRange(0x200B, 0x2027)
		.addRange(0x202A, 0x202E)
		.addRange(0x2030, 0x205E)
		.addRange(0x2060, 0x2FFF)
		.addRange(0x3001, 0xFEFE)
		.addRange(0xFF00, 0x10FFFF)],
	['w', regenerate(0x5F)
		.addRange(0x30, 0x39)
		.addRange(0x41, 0x5A)
		.addRange(0x61, 0x7A)],
	['W', regenerate(0x60)
		.addRange(0x0, 0x2F)
		.addRange(0x3A, 0x40)
		.addRange(0x5B, 0x5E)
		.addRange(0x7B, 0x10FFFF)]
]);

exports.UNICODE_IGNORE_CASE = new Map([
	['d', regenerate()
		.addRange(0x30, 0x39)],
	['D', regenerate()
		.addRange(0x0, 0x2F)
		.addRange(0x3A, 0x10FFFF)],
	['s', regenerate(0x20, 0xA0, 0x1680, 0x202F, 0x205F, 0x3000, 0xFEFF)
		.addRange(0x9, 0xD)
		.addRange(0x2000, 0x200A)
		.addRange(0x2028, 0x2029)],
	['S', regenerate()
		.addRange(0x0, 0x8)
		.addRange(0xE, 0x1F)
		.addRange(0x21, 0x9F)
		.addRange(0xA1, 0x167F)
		.addRange(0x1681, 0x1FFF)
		.addRange(0x200B, 0x2027)
		.addRange(0x202A, 0x202E)
		.addRange(0x2030, 0x205E)
		.addRange(0x2060, 0x2FFF)
		.addRange(0x3001, 0xFEFE)
		.addRange(0xFF00, 0x10FFFF)],
	['w', regenerate(0x5F, 0x17F, 0x212A)
		.addRange(0x30, 0x39)
		.addRange(0x41, 0x5A)
		.addRange(0x61, 0x7A)],
	['W', regenerate(0x60)
		.addRange(0x0, 0x2F)
		.addRange(0x3A, 0x40)
		.addRange(0x5B, 0x5E)
		.addRange(0x7B, 0x17E)
		.addRange(0x180, 0x2129)
		.addRange(0x212B, 0x10FFFF)]
]);


/***/ }),
/* 255 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var Stack = __webpack_require__(598),
    baseIsEqual = __webpack_require__(190);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.isMatch` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to inspect.
 * @param {Object} source The object of property values to match.
 * @param {Array} matchData The property names, values, and compare flags to match.
 * @param {Function} [customizer] The function to customize comparisons.
 * @returns {boolean} Returns `true` if `object` is a match, else `false`.
 */
function baseIsMatch(object, source, matchData, customizer) {
  var index = matchData.length,
      length = index,
      noCustomizer = !customizer;

  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index--) {
    var data = matchData[index];
    if ((noCustomizer && data[2])
          ? data[1] !== object[data[0]]
          : !(data[0] in object)
        ) {
      return false;
    }
  }
  while (++index < length) {
    data = matchData[index];
    var key = data[0],
        objValue = object[key],
        srcValue = data[1];

    if (noCustomizer && data[2]) {
      if (objValue === undefined && !(key in object)) {
        return false;
      }
    } else {
      var stack = new Stack;
      if (customizer) {
        var result = customizer(objValue, srcValue, key, object, source, stack);
      }
      if (!(result === undefined
            ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack)
            : result
          )) {
        return false;
      }
    }
  }
  return true;
}

module.exports = baseIsMatch;


/***/ }),
/* 256 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeStaticFileCache = makeStaticFileCache;

function _fs() {
  const data = _interopRequireDefault(__webpack_require__(747));

  _fs = function () {
    return data;
  };

  return data;
}

var _caching = __webpack_require__(194);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function makeStaticFileCache(fn) {
  return (0, _caching.makeStrongCache)((filepath, cache) => {
    if (cache.invalidate(() => fileMtime(filepath)) === null) {
      cache.forever();
      return null;
    }

    return fn(filepath, _fs().default.readFileSync(filepath, "utf8"));
  });
}

function fileMtime(filepath) {
  try {
    return +_fs().default.statSync(filepath).mtime;
  } catch (e) {
    if (e.code !== "ENOENT" && e.code !== "ENOTDIR") throw e;
  }

  return null;
}

/***/ }),
/* 257 */,
/* 258 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseRepeat = __webpack_require__(479),
    isIterateeCall = __webpack_require__(663),
    toInteger = __webpack_require__(813),
    toString = __webpack_require__(428);

/**
 * Repeats the given string `n` times.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to repeat.
 * @param {number} [n=1] The number of times to repeat the string.
 * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
 * @returns {string} Returns the repeated string.
 * @example
 *
 * _.repeat('*', 3);
 * // => '***'
 *
 * _.repeat('abc', 2);
 * // => 'abcabc'
 *
 * _.repeat('abc', 0);
 * // => ''
 */
function repeat(string, n, guard) {
  if ((guard ? isIterateeCall(string, n, guard) : n === undefined)) {
    n = 1;
  } else {
    n = toInteger(n);
  }
  return baseRepeat(toString(string), n);
}

module.exports = repeat;


/***/ }),
/* 259 */,
/* 260 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var conversions = __webpack_require__(445);

/*
	this function routes a model to all other models.

	all functions that are routed have a property `.conversion` attached
	to the returned synthetic function. This property is an array
	of strings, each with the steps in between the 'from' and 'to'
	color models (inclusive).

	conversions that are not possible simply are not included.
*/

function buildGraph() {
	var graph = {};
	// https://jsperf.com/object-keys-vs-for-in-with-closure/3
	var models = Object.keys(conversions);

	for (var len = models.length, i = 0; i < len; i++) {
		graph[models[i]] = {
			// http://jsperf.com/1-vs-infinity
			// micro-opt, but this is simple.
			distance: -1,
			parent: null
		};
	}

	return graph;
}

// https://en.wikipedia.org/wiki/Breadth-first_search
function deriveBFS(fromModel) {
	var graph = buildGraph();
	var queue = [fromModel]; // unshift -> queue -> pop

	graph[fromModel].distance = 0;

	while (queue.length) {
		var current = queue.pop();
		var adjacents = Object.keys(conversions[current]);

		for (var len = adjacents.length, i = 0; i < len; i++) {
			var adjacent = adjacents[i];
			var node = graph[adjacent];

			if (node.distance === -1) {
				node.distance = graph[current].distance + 1;
				node.parent = current;
				queue.unshift(adjacent);
			}
		}
	}

	return graph;
}

function link(from, to) {
	return function (args) {
		return to(from(args));
	};
}

function wrapConversion(toModel, graph) {
	var path = [graph[toModel].parent, toModel];
	var fn = conversions[graph[toModel].parent][toModel];

	var cur = graph[toModel].parent;
	while (graph[cur].parent) {
		path.unshift(graph[cur].parent);
		fn = link(conversions[graph[cur].parent][cur], fn);
		cur = graph[cur].parent;
	}

	fn.conversion = path;
	return fn;
}

module.exports = function (fromModel) {
	var graph = deriveBFS(fromModel);
	var conversion = {};

	var models = Object.keys(graph);
	for (var len = models.length, i = 0; i < len; i++) {
		var toModel = models[i];
		var node = graph[toModel];

		if (node.parent === null) {
			// no possible conversion, or this node is the source model.
			continue;
		}

		conversion[toModel] = wrapConversion(toModel, graph);
	}

	return conversion;
};



/***/ }),
/* 261 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var nativeCreate = __webpack_require__(878);

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

module.exports = hashSet;


/***/ }),
/* 262 */,
/* 263 */,
/* 264 */
/***/ (function(module, __unusedexports, __webpack_require__) {

"use strict";


const propertyToValueAliases = __webpack_require__(119);

const matchPropertyValue = function(property, value) {
	const aliasToValue = propertyToValueAliases.get(property);
	if (!aliasToValue) {
		throw new Error(`Unknown property \`${ property }\`.`);
	}
	const canonicalValue = aliasToValue.get(value);
	if (canonicalValue) {
		return canonicalValue;
	}
	throw new Error(
		`Unknown value \`${ value }\` for property \`${ property }\`.`
	);
};

module.exports = matchPropertyValue;


/***/ }),
/* 265 */,
/* 266 */,
/* 267 */
/***/ (function(module) {

module.exports = require("path");

/***/ }),
/* 268 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var assocIndexOf = __webpack_require__(820);

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

module.exports = listCacheSet;


/***/ }),
/* 269 */
/***/ (function(module) {

/** Used to match `RegExp` flags from their coerced string values. */
var reFlags = /\w*$/;

/**
 * Creates a clone of `regexp`.
 *
 * @private
 * @param {Object} regexp The regexp to clone.
 * @returns {Object} Returns the cloned regexp.
 */
function cloneRegExp(regexp) {
  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
  result.lastIndex = regexp.lastIndex;
  return result;
}

module.exports = cloneRegExp;


/***/ }),
/* 270 */,
/* 271 */,
/* 272 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = cleanJSXElementLiteralChild;

var _generated = __webpack_require__(405);

function cleanJSXElementLiteralChild(child, args) {
  const lines = child.value.split(/\r\n|\n|\r/);
  let lastNonEmptyLine = 0;

  for (let i = 0; i < lines.length; i++) {
    if (lines[i].match(/[^ \t]/)) {
      lastNonEmptyLine = i;
    }
  }

  let str = "";

  for (let i = 0; i < lines.length; i++) {
    const line = lines[i];
    const isFirstLine = i === 0;
    const isLastLine = i === lines.length - 1;
    const isLastNonEmptyLine = i === lastNonEmptyLine;
    let trimmedLine = line.replace(/\t/g, " ");

    if (!isFirstLine) {
      trimmedLine = trimmedLine.replace(/^[ ]+/, "");
    }

    if (!isLastLine) {
      trimmedLine = trimmedLine.replace(/[ ]+$/, "");
    }

    if (trimmedLine) {
      if (!isLastNonEmptyLine) {
        trimmedLine += " ";
      }

      str += trimmedLine;
    }
  }

  if (str) args.push((0, _generated.stringLiteral)(str));
}

/***/ }),
/* 273 */,
/* 274 */,
/* 275 */
/***/ (function(module) {

/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

module.exports = cacheHas;


/***/ }),
/* 276 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

var util = __webpack_require__(290);
var binarySearch = __webpack_require__(972);
var ArraySet = __webpack_require__(969).ArraySet;
var base64VLQ = __webpack_require__(277);
var quickSort = __webpack_require__(1).quickSort;

function SourceMapConsumer(aSourceMap) {
  var sourceMap = aSourceMap;
  if (typeof aSourceMap === 'string') {
    sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
  }

  return sourceMap.sections != null
    ? new IndexedSourceMapConsumer(sourceMap)
    : new BasicSourceMapConsumer(sourceMap);
}

SourceMapConsumer.fromSourceMap = function(aSourceMap) {
  return BasicSourceMapConsumer.fromSourceMap(aSourceMap);
}

/**
 * The version of the source mapping spec that we are consuming.
 */
SourceMapConsumer.prototype._version = 3;

// `__generatedMappings` and `__originalMappings` are arrays that hold the
// parsed mapping coordinates from the source map's "mappings" attribute. They
// are lazily instantiated, accessed via the `_generatedMappings` and
// `_originalMappings` getters respectively, and we only parse the mappings
// and create these arrays once queried for a source location. We jump through
// these hoops because there can be many thousands of mappings, and parsing
// them is expensive, so we only want to do it if we must.
//
// Each object in the arrays is of the form:
//
//     {
//       generatedLine: The line number in the generated code,
//       generatedColumn: The column number in the generated code,
//       source: The path to the original source file that generated this
//               chunk of code,
//       originalLine: The line number in the original source that
//                     corresponds to this chunk of generated code,
//       originalColumn: The column number in the original source that
//                       corresponds to this chunk of generated code,
//       name: The name of the original symbol which generated this chunk of
//             code.
//     }
//
// All properties except for `generatedLine` and `generatedColumn` can be
// `null`.
//
// `_generatedMappings` is ordered by the generated positions.
//
// `_originalMappings` is ordered by the original positions.

SourceMapConsumer.prototype.__generatedMappings = null;
Object.defineProperty(SourceMapConsumer.prototype, '_generatedMappings', {
  get: function () {
    if (!this.__generatedMappings) {
      this._parseMappings(this._mappings, this.sourceRoot);
    }

    return this.__generatedMappings;
  }
});

SourceMapConsumer.prototype.__originalMappings = null;
Object.defineProperty(SourceMapConsumer.prototype, '_originalMappings', {
  get: function () {
    if (!this.__originalMappings) {
      this._parseMappings(this._mappings, this.sourceRoot);
    }

    return this.__originalMappings;
  }
});

SourceMapConsumer.prototype._charIsMappingSeparator =
  function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
    var c = aStr.charAt(index);
    return c === ";" || c === ",";
  };

/**
 * Parse the mappings in a string in to a data structure which we can easily
 * query (the ordered arrays in the `this.__generatedMappings` and
 * `this.__originalMappings` properties).
 */
SourceMapConsumer.prototype._parseMappings =
  function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
    throw new Error("Subclasses must implement _parseMappings");
  };

SourceMapConsumer.GENERATED_ORDER = 1;
SourceMapConsumer.ORIGINAL_ORDER = 2;

SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
SourceMapConsumer.LEAST_UPPER_BOUND = 2;

/**
 * Iterate over each mapping between an original source/line/column and a
 * generated line/column in this source map.
 *
 * @param Function aCallback
 *        The function that is called with each mapping.
 * @param Object aContext
 *        Optional. If specified, this object will be the value of `this` every
 *        time that `aCallback` is called.
 * @param aOrder
 *        Either `SourceMapConsumer.GENERATED_ORDER` or
 *        `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to
 *        iterate over the mappings sorted by the generated file's line/column
 *        order or the original's source/line/column order, respectively. Defaults to
 *        `SourceMapConsumer.GENERATED_ORDER`.
 */
SourceMapConsumer.prototype.eachMapping =
  function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
    var context = aContext || null;
    var order = aOrder || SourceMapConsumer.GENERATED_ORDER;

    var mappings;
    switch (order) {
    case SourceMapConsumer.GENERATED_ORDER:
      mappings = this._generatedMappings;
      break;
    case SourceMapConsumer.ORIGINAL_ORDER:
      mappings = this._originalMappings;
      break;
    default:
      throw new Error("Unknown order of iteration.");
    }

    var sourceRoot = this.sourceRoot;
    mappings.map(function (mapping) {
      var source = mapping.source === null ? null : this._sources.at(mapping.source);
      if (source != null && sourceRoot != null) {
        source = util.join(sourceRoot, source);
      }
      return {
        source: source,
        generatedLine: mapping.generatedLine,
        generatedColumn: mapping.generatedColumn,
        originalLine: mapping.originalLine,
        originalColumn: mapping.originalColumn,
        name: mapping.name === null ? null : this._names.at(mapping.name)
      };
    }, this).forEach(aCallback, context);
  };

/**
 * Returns all generated line and column information for the original source,
 * line, and column provided. If no column is provided, returns all mappings
 * corresponding to a either the line we are searching for or the next
 * closest line that has any mappings. Otherwise, returns all mappings
 * corresponding to the given line and either the column we are searching for
 * or the next closest column that has any offsets.
 *
 * The only argument is an object with the following properties:
 *
 *   - source: The filename of the original source.
 *   - line: The line number in the original source.
 *   - column: Optional. the column number in the original source.
 *
 * and an array of objects is returned, each with the following properties:
 *
 *   - line: The line number in the generated source, or null.
 *   - column: The column number in the generated source, or null.
 */
SourceMapConsumer.prototype.allGeneratedPositionsFor =
  function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
    var line = util.getArg(aArgs, 'line');

    // When there is no exact match, BasicSourceMapConsumer.prototype._findMapping
    // returns the index of the closest mapping less than the needle. By
    // setting needle.originalColumn to 0, we thus find the last mapping for
    // the given line, provided such a mapping exists.
    var needle = {
      source: util.getArg(aArgs, 'source'),
      originalLine: line,
      originalColumn: util.getArg(aArgs, 'column', 0)
    };

    if (this.sourceRoot != null) {
      needle.source = util.relative(this.sourceRoot, needle.source);
    }
    if (!this._sources.has(needle.source)) {
      return [];
    }
    needle.source = this._sources.indexOf(needle.source);

    var mappings = [];

    var index = this._findMapping(needle,
                                  this._originalMappings,
                                  "originalLine",
                                  "originalColumn",
                                  util.compareByOriginalPositions,
                                  binarySearch.LEAST_UPPER_BOUND);
    if (index >= 0) {
      var mapping = this._originalMappings[index];

      if (aArgs.column === undefined) {
        var originalLine = mapping.originalLine;

        // Iterate until either we run out of mappings, or we run into
        // a mapping for a different line than the one we found. Since
        // mappings are sorted, this is guaranteed to find all mappings for
        // the line we found.
        while (mapping && mapping.originalLine === originalLine) {
          mappings.push({
            line: util.getArg(mapping, 'generatedLine', null),
            column: util.getArg(mapping, 'generatedColumn', null),
            lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
          });

          mapping = this._originalMappings[++index];
        }
      } else {
        var originalColumn = mapping.originalColumn;

        // Iterate until either we run out of mappings, or we run into
        // a mapping for a different line than the one we were searching for.
        // Since mappings are sorted, this is guaranteed to find all mappings for
        // the line we are searching for.
        while (mapping &&
               mapping.originalLine === line &&
               mapping.originalColumn == originalColumn) {
          mappings.push({
            line: util.getArg(mapping, 'generatedLine', null),
            column: util.getArg(mapping, 'generatedColumn', null),
            lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
          });

          mapping = this._originalMappings[++index];
        }
      }
    }

    return mappings;
  };

exports.SourceMapConsumer = SourceMapConsumer;

/**
 * A BasicSourceMapConsumer instance represents a parsed source map which we can
 * query for information about the original file positions by giving it a file
 * position in the generated source.
 *
 * The only parameter is the raw source map (either as a JSON string, or
 * already parsed to an object). According to the spec, source maps have the
 * following attributes:
 *
 *   - version: Which version of the source map spec this map is following.
 *   - sources: An array of URLs to the original source files.
 *   - names: An array of identifiers which can be referrenced by individual mappings.
 *   - sourceRoot: Optional. The URL root from which all sources are relative.
 *   - sourcesContent: Optional. An array of contents of the original source files.
 *   - mappings: A string of base64 VLQs which contain the actual mappings.
 *   - file: Optional. The generated file this source map is associated with.
 *
 * Here is an example source map, taken from the source map spec[0]:
 *
 *     {
 *       version : 3,
 *       file: "out.js",
 *       sourceRoot : "",
 *       sources: ["foo.js", "bar.js"],
 *       names: ["src", "maps", "are", "fun"],
 *       mappings: "AA,AB;;ABCDE;"
 *     }
 *
 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit?pli=1#
 */
function BasicSourceMapConsumer(aSourceMap) {
  var sourceMap = aSourceMap;
  if (typeof aSourceMap === 'string') {
    sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
  }

  var version = util.getArg(sourceMap, 'version');
  var sources = util.getArg(sourceMap, 'sources');
  // Sass 3.3 leaves out the 'names' array, so we deviate from the spec (which
  // requires the array) to play nice here.
  var names = util.getArg(sourceMap, 'names', []);
  var sourceRoot = util.getArg(sourceMap, 'sourceRoot', null);
  var sourcesContent = util.getArg(sourceMap, 'sourcesContent', null);
  var mappings = util.getArg(sourceMap, 'mappings');
  var file = util.getArg(sourceMap, 'file', null);

  // Once again, Sass deviates from the spec and supplies the version as a
  // string rather than a number, so we use loose equality checking here.
  if (version != this._version) {
    throw new Error('Unsupported version: ' + version);
  }

  sources = sources
    .map(String)
    // Some source maps produce relative source paths like "./foo.js" instead of
    // "foo.js".  Normalize these first so that future comparisons will succeed.
    // See bugzil.la/1090768.
    .map(util.normalize)
    // Always ensure that absolute sources are internally stored relative to
    // the source root, if the source root is absolute. Not doing this would
    // be particularly problematic when the source root is a prefix of the
    // source (valid, but why??). See github issue #199 and bugzil.la/1188982.
    .map(function (source) {
      return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source)
        ? util.relative(sourceRoot, source)
        : source;
    });

  // Pass `true` below to allow duplicate names and sources. While source maps
  // are intended to be compressed and deduplicated, the TypeScript compiler
  // sometimes generates source maps with duplicates in them. See Github issue
  // #72 and bugzil.la/889492.
  this._names = ArraySet.fromArray(names.map(String), true);
  this._sources = ArraySet.fromArray(sources, true);

  this.sourceRoot = sourceRoot;
  this.sourcesContent = sourcesContent;
  this._mappings = mappings;
  this.file = file;
}

BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;

/**
 * Create a BasicSourceMapConsumer from a SourceMapGenerator.
 *
 * @param SourceMapGenerator aSourceMap
 *        The source map that will be consumed.
 * @returns BasicSourceMapConsumer
 */
BasicSourceMapConsumer.fromSourceMap =
  function SourceMapConsumer_fromSourceMap(aSourceMap) {
    var smc = Object.create(BasicSourceMapConsumer.prototype);

    var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
    var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
    smc.sourceRoot = aSourceMap._sourceRoot;
    smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(),
                                                            smc.sourceRoot);
    smc.file = aSourceMap._file;

    // Because we are modifying the entries (by converting string sources and
    // names to indices into the sources and names ArraySets), we have to make
    // a copy of the entry or else bad things happen. Shared mutable state
    // strikes again! See github issue #191.

    var generatedMappings = aSourceMap._mappings.toArray().slice();
    var destGeneratedMappings = smc.__generatedMappings = [];
    var destOriginalMappings = smc.__originalMappings = [];

    for (var i = 0, length = generatedMappings.length; i < length; i++) {
      var srcMapping = generatedMappings[i];
      var destMapping = new Mapping;
      destMapping.generatedLine = srcMapping.generatedLine;
      destMapping.generatedColumn = srcMapping.generatedColumn;

      if (srcMapping.source) {
        destMapping.source = sources.indexOf(srcMapping.source);
        destMapping.originalLine = srcMapping.originalLine;
        destMapping.originalColumn = srcMapping.originalColumn;

        if (srcMapping.name) {
          destMapping.name = names.indexOf(srcMapping.name);
        }

        destOriginalMappings.push(destMapping);
      }

      destGeneratedMappings.push(destMapping);
    }

    quickSort(smc.__originalMappings, util.compareByOriginalPositions);

    return smc;
  };

/**
 * The version of the source mapping spec that we are consuming.
 */
BasicSourceMapConsumer.prototype._version = 3;

/**
 * The list of original sources.
 */
Object.defineProperty(BasicSourceMapConsumer.prototype, 'sources', {
  get: function () {
    return this._sources.toArray().map(function (s) {
      return this.sourceRoot != null ? util.join(this.sourceRoot, s) : s;
    }, this);
  }
});

/**
 * Provide the JIT with a nice shape / hidden class.
 */
function Mapping() {
  this.generatedLine = 0;
  this.generatedColumn = 0;
  this.source = null;
  this.originalLine = null;
  this.originalColumn = null;
  this.name = null;
}

/**
 * Parse the mappings in a string in to a data structure which we can easily
 * query (the ordered arrays in the `this.__generatedMappings` and
 * `this.__originalMappings` properties).
 */
BasicSourceMapConsumer.prototype._parseMappings =
  function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
    var generatedLine = 1;
    var previousGeneratedColumn = 0;
    var previousOriginalLine = 0;
    var previousOriginalColumn = 0;
    var previousSource = 0;
    var previousName = 0;
    var length = aStr.length;
    var index = 0;
    var cachedSegments = {};
    var temp = {};
    var originalMappings = [];
    var generatedMappings = [];
    var mapping, str, segment, end, value;

    while (index < length) {
      if (aStr.charAt(index) === ';') {
        generatedLine++;
        index++;
        previousGeneratedColumn = 0;
      }
      else if (aStr.charAt(index) === ',') {
        index++;
      }
      else {
        mapping = new Mapping();
        mapping.generatedLine = generatedLine;

        // Because each offset is encoded relative to the previous one,
        // many segments often have the same encoding. We can exploit this
        // fact by caching the parsed variable length fields of each segment,
        // allowing us to avoid a second parse if we encounter the same
        // segment again.
        for (end = index; end < length; end++) {
          if (this._charIsMappingSeparator(aStr, end)) {
            break;
          }
        }
        str = aStr.slice(index, end);

        segment = cachedSegments[str];
        if (segment) {
          index += str.length;
        } else {
          segment = [];
          while (index < end) {
            base64VLQ.decode(aStr, index, temp);
            value = temp.value;
            index = temp.rest;
            segment.push(value);
          }

          if (segment.length === 2) {
            throw new Error('Found a source, but no line and column');
          }

          if (segment.length === 3) {
            throw new Error('Found a source and line, but no column');
          }

          cachedSegments[str] = segment;
        }

        // Generated column.
        mapping.generatedColumn = previousGeneratedColumn + segment[0];
        previousGeneratedColumn = mapping.generatedColumn;

        if (segment.length > 1) {
          // Original source.
          mapping.source = previousSource + segment[1];
          previousSource += segment[1];

          // Original line.
          mapping.originalLine = previousOriginalLine + segment[2];
          previousOriginalLine = mapping.originalLine;
          // Lines are stored 0-based
          mapping.originalLine += 1;

          // Original column.
          mapping.originalColumn = previousOriginalColumn + segment[3];
          previousOriginalColumn = mapping.originalColumn;

          if (segment.length > 4) {
            // Original name.
            mapping.name = previousName + segment[4];
            previousName += segment[4];
          }
        }

        generatedMappings.push(mapping);
        if (typeof mapping.originalLine === 'number') {
          originalMappings.push(mapping);
        }
      }
    }

    quickSort(generatedMappings, util.compareByGeneratedPositionsDeflated);
    this.__generatedMappings = generatedMappings;

    quickSort(originalMappings, util.compareByOriginalPositions);
    this.__originalMappings = originalMappings;
  };

/**
 * Find the mapping that best matches the hypothetical "needle" mapping that
 * we are searching for in the given "haystack" of mappings.
 */
BasicSourceMapConsumer.prototype._findMapping =
  function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName,
                                         aColumnName, aComparator, aBias) {
    // To return the position we are searching for, we must first find the
    // mapping for the given position and then return the opposite position it
    // points to. Because the mappings are sorted, we can use binary search to
    // find the best mapping.

    if (aNeedle[aLineName] <= 0) {
      throw new TypeError('Line must be greater than or equal to 1, got '
                          + aNeedle[aLineName]);
    }
    if (aNeedle[aColumnName] < 0) {
      throw new TypeError('Column must be greater than or equal to 0, got '
                          + aNeedle[aColumnName]);
    }

    return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
  };

/**
 * Compute the last column for each generated mapping. The last column is
 * inclusive.
 */
BasicSourceMapConsumer.prototype.computeColumnSpans =
  function SourceMapConsumer_computeColumnSpans() {
    for (var index = 0; index < this._generatedMappings.length; ++index) {
      var mapping = this._generatedMappings[index];

      // Mappings do not contain a field for the last generated columnt. We
      // can come up with an optimistic estimate, however, by assuming that
      // mappings are contiguous (i.e. given two consecutive mappings, the
      // first mapping ends where the second one starts).
      if (index + 1 < this._generatedMappings.length) {
        var nextMapping = this._generatedMappings[index + 1];

        if (mapping.generatedLine === nextMapping.generatedLine) {
          mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
          continue;
        }
      }

      // The last mapping for each line spans the entire line.
      mapping.lastGeneratedColumn = Infinity;
    }
  };

/**
 * Returns the original source, line, and column information for the generated
 * source's line and column positions provided. The only argument is an object
 * with the following properties:
 *
 *   - line: The line number in the generated source.
 *   - column: The column number in the generated source.
 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
 *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
 *     closest element that is smaller than or greater than the one we are
 *     searching for, respectively, if the exact element cannot be found.
 *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
 *
 * and an object is returned with the following properties:
 *
 *   - source: The original source file, or null.
 *   - line: The line number in the original source, or null.
 *   - column: The column number in the original source, or null.
 *   - name: The original identifier, or null.
 */
BasicSourceMapConsumer.prototype.originalPositionFor =
  function SourceMapConsumer_originalPositionFor(aArgs) {
    var needle = {
      generatedLine: util.getArg(aArgs, 'line'),
      generatedColumn: util.getArg(aArgs, 'column')
    };

    var index = this._findMapping(
      needle,
      this._generatedMappings,
      "generatedLine",
      "generatedColumn",
      util.compareByGeneratedPositionsDeflated,
      util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND)
    );

    if (index >= 0) {
      var mapping = this._generatedMappings[index];

      if (mapping.generatedLine === needle.generatedLine) {
        var source = util.getArg(mapping, 'source', null);
        if (source !== null) {
          source = this._sources.at(source);
          if (this.sourceRoot != null) {
            source = util.join(this.sourceRoot, source);
          }
        }
        var name = util.getArg(mapping, 'name', null);
        if (name !== null) {
          name = this._names.at(name);
        }
        return {
          source: source,
          line: util.getArg(mapping, 'originalLine', null),
          column: util.getArg(mapping, 'originalColumn', null),
          name: name
        };
      }
    }

    return {
      source: null,
      line: null,
      column: null,
      name: null
    };
  };

/**
 * Return true if we have the source content for every source in the source
 * map, false otherwise.
 */
BasicSourceMapConsumer.prototype.hasContentsOfAllSources =
  function BasicSourceMapConsumer_hasContentsOfAllSources() {
    if (!this.sourcesContent) {
      return false;
    }
    return this.sourcesContent.length >= this._sources.size() &&
      !this.sourcesContent.some(function (sc) { return sc == null; });
  };

/**
 * Returns the original source content. The only argument is the url of the
 * original source file. Returns null if no original source content is
 * available.
 */
BasicSourceMapConsumer.prototype.sourceContentFor =
  function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
    if (!this.sourcesContent) {
      return null;
    }

    if (this.sourceRoot != null) {
      aSource = util.relative(this.sourceRoot, aSource);
    }

    if (this._sources.has(aSource)) {
      return this.sourcesContent[this._sources.indexOf(aSource)];
    }

    var url;
    if (this.sourceRoot != null
        && (url = util.urlParse(this.sourceRoot))) {
      // XXX: file:// URIs and absolute paths lead to unexpected behavior for
      // many users. We can help them out when they expect file:// URIs to
      // behave like it would if they were running a local HTTP server. See
      // https://bugzilla.mozilla.org/show_bug.cgi?id=885597.
      var fileUriAbsPath = aSource.replace(/^file:\/\//, "");
      if (url.scheme == "file"
          && this._sources.has(fileUriAbsPath)) {
        return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)]
      }

      if ((!url.path || url.path == "/")
          && this._sources.has("/" + aSource)) {
        return this.sourcesContent[this._sources.indexOf("/" + aSource)];
      }
    }

    // This function is used recursively from
    // IndexedSourceMapConsumer.prototype.sourceContentFor. In that case, we
    // don't want to throw if we can't find the source - we just want to
    // return null, so we provide a flag to exit gracefully.
    if (nullOnMissing) {
      return null;
    }
    else {
      throw new Error('"' + aSource + '" is not in the SourceMap.');
    }
  };

/**
 * Returns the generated line and column information for the original source,
 * line, and column positions provided. The only argument is an object with
 * the following properties:
 *
 *   - source: The filename of the original source.
 *   - line: The line number in the original source.
 *   - column: The column number in the original source.
 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
 *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
 *     closest element that is smaller than or greater than the one we are
 *     searching for, respectively, if the exact element cannot be found.
 *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
 *
 * and an object is returned with the following properties:
 *
 *   - line: The line number in the generated source, or null.
 *   - column: The column number in the generated source, or null.
 */
BasicSourceMapConsumer.prototype.generatedPositionFor =
  function SourceMapConsumer_generatedPositionFor(aArgs) {
    var source = util.getArg(aArgs, 'source');
    if (this.sourceRoot != null) {
      source = util.relative(this.sourceRoot, source);
    }
    if (!this._sources.has(source)) {
      return {
        line: null,
        column: null,
        lastColumn: null
      };
    }
    source = this._sources.indexOf(source);

    var needle = {
      source: source,
      originalLine: util.getArg(aArgs, 'line'),
      originalColumn: util.getArg(aArgs, 'column')
    };

    var index = this._findMapping(
      needle,
      this._originalMappings,
      "originalLine",
      "originalColumn",
      util.compareByOriginalPositions,
      util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND)
    );

    if (index >= 0) {
      var mapping = this._originalMappings[index];

      if (mapping.source === needle.source) {
        return {
          line: util.getArg(mapping, 'generatedLine', null),
          column: util.getArg(mapping, 'generatedColumn', null),
          lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
        };
      }
    }

    return {
      line: null,
      column: null,
      lastColumn: null
    };
  };

exports.BasicSourceMapConsumer = BasicSourceMapConsumer;

/**
 * An IndexedSourceMapConsumer instance represents a parsed source map which
 * we can query for information. It differs from BasicSourceMapConsumer in
 * that it takes "indexed" source maps (i.e. ones with a "sections" field) as
 * input.
 *
 * The only parameter is a raw source map (either as a JSON string, or already
 * parsed to an object). According to the spec for indexed source maps, they
 * have the following attributes:
 *
 *   - version: Which version of the source map spec this map is following.
 *   - file: Optional. The generated file this source map is associated with.
 *   - sections: A list of section definitions.
 *
 * Each value under the "sections" field has two fields:
 *   - offset: The offset into the original specified at which this section
 *       begins to apply, defined as an object with a "line" and "column"
 *       field.
 *   - map: A source map definition. This source map could also be indexed,
 *       but doesn't have to be.
 *
 * Instead of the "map" field, it's also possible to have a "url" field
 * specifying a URL to retrieve a source map from, but that's currently
 * unsupported.
 *
 * Here's an example source map, taken from the source map spec[0], but
 * modified to omit a section which uses the "url" field.
 *
 *  {
 *    version : 3,
 *    file: "app.js",
 *    sections: [{
 *      offset: {line:100, column:10},
 *      map: {
 *        version : 3,
 *        file: "section.js",
 *        sources: ["foo.js", "bar.js"],
 *        names: ["src", "maps", "are", "fun"],
 *        mappings: "AAAA,E;;ABCDE;"
 *      }
 *    }],
 *  }
 *
 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit#heading=h.535es3xeprgt
 */
function IndexedSourceMapConsumer(aSourceMap) {
  var sourceMap = aSourceMap;
  if (typeof aSourceMap === 'string') {
    sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
  }

  var version = util.getArg(sourceMap, 'version');
  var sections = util.getArg(sourceMap, 'sections');

  if (version != this._version) {
    throw new Error('Unsupported version: ' + version);
  }

  this._sources = new ArraySet();
  this._names = new ArraySet();

  var lastOffset = {
    line: -1,
    column: 0
  };
  this._sections = sections.map(function (s) {
    if (s.url) {
      // The url field will require support for asynchronicity.
      // See https://github.com/mozilla/source-map/issues/16
      throw new Error('Support for url field in sections not implemented.');
    }
    var offset = util.getArg(s, 'offset');
    var offsetLine = util.getArg(offset, 'line');
    var offsetColumn = util.getArg(offset, 'column');

    if (offsetLine < lastOffset.line ||
        (offsetLine === lastOffset.line && offsetColumn < lastOffset.column)) {
      throw new Error('Section offsets must be ordered and non-overlapping.');
    }
    lastOffset = offset;

    return {
      generatedOffset: {
        // The offset fields are 0-based, but we use 1-based indices when
        // encoding/decoding from VLQ.
        generatedLine: offsetLine + 1,
        generatedColumn: offsetColumn + 1
      },
      consumer: new SourceMapConsumer(util.getArg(s, 'map'))
    }
  });
}

IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;

/**
 * The version of the source mapping spec that we are consuming.
 */
IndexedSourceMapConsumer.prototype._version = 3;

/**
 * The list of original sources.
 */
Object.defineProperty(IndexedSourceMapConsumer.prototype, 'sources', {
  get: function () {
    var sources = [];
    for (var i = 0; i < this._sections.length; i++) {
      for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
        sources.push(this._sections[i].consumer.sources[j]);
      }
    }
    return sources;
  }
});

/**
 * Returns the original source, line, and column information for the generated
 * source's line and column positions provided. The only argument is an object
 * with the following properties:
 *
 *   - line: The line number in the generated source.
 *   - column: The column number in the generated source.
 *
 * and an object is returned with the following properties:
 *
 *   - source: The original source file, or null.
 *   - line: The line number in the original source, or null.
 *   - column: The column number in the original source, or null.
 *   - name: The original identifier, or null.
 */
IndexedSourceMapConsumer.prototype.originalPositionFor =
  function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
    var needle = {
      generatedLine: util.getArg(aArgs, 'line'),
      generatedColumn: util.getArg(aArgs, 'column')
    };

    // Find the section containing the generated position we're trying to map
    // to an original position.
    var sectionIndex = binarySearch.search(needle, this._sections,
      function(needle, section) {
        var cmp = needle.generatedLine - section.generatedOffset.generatedLine;
        if (cmp) {
          return cmp;
        }

        return (needle.generatedColumn -
                section.generatedOffset.generatedColumn);
      });
    var section = this._sections[sectionIndex];

    if (!section) {
      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    }

    return section.consumer.originalPositionFor({
      line: needle.generatedLine -
        (section.generatedOffset.generatedLine - 1),
      column: needle.generatedColumn -
        (section.generatedOffset.generatedLine === needle.generatedLine
         ? section.generatedOffset.generatedColumn - 1
         : 0),
      bias: aArgs.bias
    });
  };

/**
 * Return true if we have the source content for every source in the source
 * map, false otherwise.
 */
IndexedSourceMapConsumer.prototype.hasContentsOfAllSources =
  function IndexedSourceMapConsumer_hasContentsOfAllSources() {
    return this._sections.every(function (s) {
      return s.consumer.hasContentsOfAllSources();
    });
  };

/**
 * Returns the original source content. The only argument is the url of the
 * original source file. Returns null if no original source content is
 * available.
 */
IndexedSourceMapConsumer.prototype.sourceContentFor =
  function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
    for (var i = 0; i < this._sections.length; i++) {
      var section = this._sections[i];

      var content = section.consumer.sourceContentFor(aSource, true);
      if (content) {
        return content;
      }
    }
    if (nullOnMissing) {
      return null;
    }
    else {
      throw new Error('"' + aSource + '" is not in the SourceMap.');
    }
  };

/**
 * Returns the generated line and column information for the original source,
 * line, and column positions provided. The only argument is an object with
 * the following properties:
 *
 *   - source: The filename of the original source.
 *   - line: The line number in the original source.
 *   - column: The column number in the original source.
 *
 * and an object is returned with the following properties:
 *
 *   - line: The line number in the generated source, or null.
 *   - column: The column number in the generated source, or null.
 */
IndexedSourceMapConsumer.prototype.generatedPositionFor =
  function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
    for (var i = 0; i < this._sections.length; i++) {
      var section = this._sections[i];

      // Only consider this section if the requested source is in the list of
      // sources of the consumer.
      if (section.consumer.sources.indexOf(util.getArg(aArgs, 'source')) === -1) {
        continue;
      }
      var generatedPosition = section.consumer.generatedPositionFor(aArgs);
      if (generatedPosition) {
        var ret = {
          line: generatedPosition.line +
            (section.generatedOffset.generatedLine - 1),
          column: generatedPosition.column +
            (section.generatedOffset.generatedLine === generatedPosition.line
             ? section.generatedOffset.generatedColumn - 1
             : 0)
        };
        return ret;
      }
    }

    return {
      line: null,
      column: null
    };
  };

/**
 * Parse the mappings in a string in to a data structure which we can easily
 * query (the ordered arrays in the `this.__generatedMappings` and
 * `this.__originalMappings` properties).
 */
IndexedSourceMapConsumer.prototype._parseMappings =
  function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
    this.__generatedMappings = [];
    this.__originalMappings = [];
    for (var i = 0; i < this._sections.length; i++) {
      var section = this._sections[i];
      var sectionMappings = section.consumer._generatedMappings;
      for (var j = 0; j < sectionMappings.length; j++) {
        var mapping = sectionMappings[j];

        var source = section.consumer._sources.at(mapping.source);
        if (section.consumer.sourceRoot !== null) {
          source = util.join(section.consumer.sourceRoot, source);
        }
        this._sources.add(source);
        source = this._sources.indexOf(source);

        var name = section.consumer._names.at(mapping.name);
        this._names.add(name);
        name = this._names.indexOf(name);

        // The mappings coming from the consumer for the section have
        // generated positions relative to the start of the section, so we
        // need to offset them to be relative to the start of the concatenated
        // generated file.
        var adjustedMapping = {
          source: source,
          generatedLine: mapping.generatedLine +
            (section.generatedOffset.generatedLine - 1),
          generatedColumn: mapping.generatedColumn +
            (section.generatedOffset.generatedLine === mapping.generatedLine
            ? section.generatedOffset.generatedColumn - 1
            : 0),
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: name
        };

        this.__generatedMappings.push(adjustedMapping);
        if (typeof adjustedMapping.originalLine === 'number') {
          this.__originalMappings.push(adjustedMapping);
        }
      }
    }

    quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
    quickSort(this.__originalMappings, util.compareByOriginalPositions);
  };

exports.IndexedSourceMapConsumer = IndexedSourceMapConsumer;


/***/ }),
/* 277 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 *
 * Based on the Base 64 VLQ implementation in Closure Compiler:
 * https://code.google.com/p/closure-compiler/source/browse/trunk/src/com/google/debugging/sourcemap/Base64VLQ.java
 *
 * Copyright 2011 The Closure Compiler Authors. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *  * Neither the name of Google Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

var base64 = __webpack_require__(947);

// A single base 64 digit can contain 6 bits of data. For the base 64 variable
// length quantities we use in the source map spec, the first bit is the sign,
// the next four bits are the actual value, and the 6th bit is the
// continuation bit. The continuation bit tells us whether there are more
// digits in this value following this digit.
//
//   Continuation
//   |    Sign
//   |    |
//   V    V
//   101011

var VLQ_BASE_SHIFT = 5;

// binary: 100000
var VLQ_BASE = 1 << VLQ_BASE_SHIFT;

// binary: 011111
var VLQ_BASE_MASK = VLQ_BASE - 1;

// binary: 100000
var VLQ_CONTINUATION_BIT = VLQ_BASE;

/**
 * Converts from a two-complement value to a value where the sign bit is
 * placed in the least significant bit.  For example, as decimals:
 *   1 becomes 2 (10 binary), -1 becomes 3 (11 binary)
 *   2 becomes 4 (100 binary), -2 becomes 5 (101 binary)
 */
function toVLQSigned(aValue) {
  return aValue < 0
    ? ((-aValue) << 1) + 1
    : (aValue << 1) + 0;
}

/**
 * Converts to a two-complement value from a value where the sign bit is
 * placed in the least significant bit.  For example, as decimals:
 *   2 (10 binary) becomes 1, 3 (11 binary) becomes -1
 *   4 (100 binary) becomes 2, 5 (101 binary) becomes -2
 */
function fromVLQSigned(aValue) {
  var isNegative = (aValue & 1) === 1;
  var shifted = aValue >> 1;
  return isNegative
    ? -shifted
    : shifted;
}

/**
 * Returns the base 64 VLQ encoded value.
 */
exports.encode = function base64VLQ_encode(aValue) {
  var encoded = "";
  var digit;

  var vlq = toVLQSigned(aValue);

  do {
    digit = vlq & VLQ_BASE_MASK;
    vlq >>>= VLQ_BASE_SHIFT;
    if (vlq > 0) {
      // There are still more digits in this value, so we must make sure the
      // continuation bit is marked.
      digit |= VLQ_CONTINUATION_BIT;
    }
    encoded += base64.encode(digit);
  } while (vlq > 0);

  return encoded;
};

/**
 * Decodes the next base 64 VLQ value from the given string and returns the
 * value and the rest of the string via the out parameter.
 */
exports.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
  var strLen = aStr.length;
  var result = 0;
  var shift = 0;
  var continuation, digit;

  do {
    if (aIndex >= strLen) {
      throw new Error("Expected more digits in base 64 VLQ value.");
    }

    digit = base64.decode(aStr.charCodeAt(aIndex++));
    if (digit === -1) {
      throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
    }

    continuation = !!(digit & VLQ_CONTINUATION_BIT);
    digit &= VLQ_BASE_MASK;
    result = result + (digit << shift);
    shift += VLQ_BASE_SHIFT;
  } while (continuation);

  aOutParam.value = fromVLQSigned(result);
  aOutParam.rest = aIndex;
};


/***/ }),
/* 278 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = Plugin;
Object.defineProperty(exports, "File", {
  enumerable: true,
  get: function () {
    return _file.default;
  }
});
Object.defineProperty(exports, "buildExternalHelpers", {
  enumerable: true,
  get: function () {
    return _buildExternalHelpers.default;
  }
});
Object.defineProperty(exports, "resolvePlugin", {
  enumerable: true,
  get: function () {
    return _files.resolvePlugin;
  }
});
Object.defineProperty(exports, "resolvePreset", {
  enumerable: true,
  get: function () {
    return _files.resolvePreset;
  }
});
Object.defineProperty(exports, "version", {
  enumerable: true,
  get: function () {
    return _package.version;
  }
});
Object.defineProperty(exports, "getEnv", {
  enumerable: true,
  get: function () {
    return _environment.getEnv;
  }
});
Object.defineProperty(exports, "tokTypes", {
  enumerable: true,
  get: function () {
    return _parser().tokTypes;
  }
});
Object.defineProperty(exports, "traverse", {
  enumerable: true,
  get: function () {
    return _traverse().default;
  }
});
Object.defineProperty(exports, "template", {
  enumerable: true,
  get: function () {
    return _template().default;
  }
});
Object.defineProperty(exports, "createConfigItem", {
  enumerable: true,
  get: function () {
    return _item.createConfigItem;
  }
});
Object.defineProperty(exports, "loadPartialConfig", {
  enumerable: true,
  get: function () {
    return _config.loadPartialConfig;
  }
});
Object.defineProperty(exports, "loadOptions", {
  enumerable: true,
  get: function () {
    return _config.loadOptions;
  }
});
Object.defineProperty(exports, "transform", {
  enumerable: true,
  get: function () {
    return _transform.transform;
  }
});
Object.defineProperty(exports, "transformSync", {
  enumerable: true,
  get: function () {
    return _transform.transformSync;
  }
});
Object.defineProperty(exports, "transformAsync", {
  enumerable: true,
  get: function () {
    return _transform.transformAsync;
  }
});
Object.defineProperty(exports, "transformFile", {
  enumerable: true,
  get: function () {
    return _transformFile.transformFile;
  }
});
Object.defineProperty(exports, "transformFileSync", {
  enumerable: true,
  get: function () {
    return _transformFile.transformFileSync;
  }
});
Object.defineProperty(exports, "transformFileAsync", {
  enumerable: true,
  get: function () {
    return _transformFile.transformFileAsync;
  }
});
Object.defineProperty(exports, "transformFromAst", {
  enumerable: true,
  get: function () {
    return _transformAst.transformFromAst;
  }
});
Object.defineProperty(exports, "transformFromAstSync", {
  enumerable: true,
  get: function () {
    return _transformAst.transformFromAstSync;
  }
});
Object.defineProperty(exports, "transformFromAstAsync", {
  enumerable: true,
  get: function () {
    return _transformAst.transformFromAstAsync;
  }
});
Object.defineProperty(exports, "parse", {
  enumerable: true,
  get: function () {
    return _parse.parse;
  }
});
Object.defineProperty(exports, "parseSync", {
  enumerable: true,
  get: function () {
    return _parse.parseSync;
  }
});
Object.defineProperty(exports, "parseAsync", {
  enumerable: true,
  get: function () {
    return _parse.parseAsync;
  }
});
exports.types = exports.OptionManager = exports.DEFAULT_EXTENSIONS = void 0;

var _file = _interopRequireDefault(__webpack_require__(148));

var _buildExternalHelpers = _interopRequireDefault(__webpack_require__(221));

var _files = __webpack_require__(151);

var _package = __webpack_require__(415);

var _environment = __webpack_require__(983);

function _types() {
  const data = _interopRequireWildcard(__webpack_require__(978));

  _types = function () {
    return data;
  };

  return data;
}

Object.defineProperty(exports, "types", {
  enumerable: true,
  get: function () {
    return _types();
  }
});

function _parser() {
  const data = __webpack_require__(603);

  _parser = function () {
    return data;
  };

  return data;
}

function _traverse() {
  const data = _interopRequireDefault(__webpack_require__(167));

  _traverse = function () {
    return data;
  };

  return data;
}

function _template() {
  const data = _interopRequireDefault(__webpack_require__(5));

  _template = function () {
    return data;
  };

  return data;
}

var _item = __webpack_require__(131);

var _config = __webpack_require__(520);

var _transform = __webpack_require__(552);

var _transformFile = __webpack_require__(333);

var _transformAst = __webpack_require__(103);

var _parse = __webpack_require__(145);

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DEFAULT_EXTENSIONS = Object.freeze([".js", ".jsx", ".es6", ".es", ".mjs"]);
exports.DEFAULT_EXTENSIONS = DEFAULT_EXTENSIONS;

class OptionManager {
  init(opts) {
    return (0, _config.loadOptions)(opts);
  }

}

exports.OptionManager = OptionManager;

function Plugin(alias) {
  throw new Error(`The (${alias}) Babel 5 plugin is being run with an unsupported Babel version.`);
}

/***/ }),
/* 279 */,
/* 280 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var Symbol = __webpack_require__(498),
    arrayMap = __webpack_require__(766),
    isArray = __webpack_require__(143),
    isSymbol = __webpack_require__(186);

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isArray(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return arrayMap(value, baseToString) + '';
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = baseToString;


/***/ }),
/* 281 */,
/* 282 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = __webpack_require__(57);

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

function _pluginSyntaxOptionalCatchBinding() {
  const data = _interopRequireDefault(__webpack_require__(75));

  _pluginSyntaxOptionalCatchBinding = function () {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = (0, _helperPluginUtils().declare)(api => {
  api.assertVersion(7);
  return {
    name: "proposal-optional-catch-binding",
    inherits: _pluginSyntaxOptionalCatchBinding().default,
    visitor: {
      CatchClause(path) {
        if (!path.node.param) {
          const uid = path.scope.generateUidIdentifier("unused");
          const paramPath = path.get("param");
          paramPath.replaceWith(uid);
        }
      }

    }
  };
});

exports.default = _default;

/***/ }),
/* 283 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeCoreJSOption = normalizeCoreJSOption;
exports.default = normalizeOptions;
exports.validateUseBuiltInsOption = exports.validateModulesOption = exports.validateIgnoreBrowserslistConfig = exports.validateBoolOption = exports.validateConfigPathOption = exports.checkDuplicateIncludeExcludes = exports.normalizePluginName = void 0;

var _data = _interopRequireDefault(__webpack_require__(588));

var _invariant = _interopRequireDefault(__webpack_require__(758));

var _semver = __webpack_require__(864);

var _corejs2BuiltIns = _interopRequireDefault(__webpack_require__(306));

var _plugins = _interopRequireDefault(__webpack_require__(865));

var _moduleTransformations = _interopRequireDefault(__webpack_require__(526));

var _options = __webpack_require__(39);

var _getPlatformSpecificDefault = __webpack_require__(295);

var _targetsParser = __webpack_require__(681);

var _utils = __webpack_require__(882);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const validateTopLevelOptions = options => {
  const validOptions = Object.keys(_options.TopLevelOptions);

  for (const option in options) {
    if (!_options.TopLevelOptions[option]) {
      throw new Error(`Invalid Option: ${option} is not a valid top-level option.
        Maybe you meant to use '${(0, _utils.findSuggestion)(validOptions, option)}'?`);
    }
  }
};

const allPluginsList = Object.keys(_plugins.default);
const modulePlugins = ["proposal-dynamic-import", ...Object.keys(_moduleTransformations.default).map(m => _moduleTransformations.default[m])];

const getValidIncludesAndExcludes = (type, corejs) => new Set([...allPluginsList, ...(type === "exclude" ? modulePlugins : []), ...(corejs ? corejs == 2 ? [...Object.keys(_corejs2BuiltIns.default), ..._getPlatformSpecificDefault.defaultWebIncludes] : Object.keys(_data.default) : [])]);

const pluginToRegExp = plugin => {
  if (plugin instanceof RegExp) return plugin;

  try {
    return new RegExp(`^${normalizePluginName(plugin)}$`);
  } catch (e) {
    return null;
  }
};

const selectPlugins = (regexp, type, corejs) => Array.from(getValidIncludesAndExcludes(type, corejs)).filter(item => regexp instanceof RegExp && regexp.test(item));

const flatten = array => [].concat(...array);

const expandIncludesAndExcludes = (plugins = [], type, corejs) => {
  if (plugins.length === 0) return [];
  const selectedPlugins = plugins.map(plugin => selectPlugins(pluginToRegExp(plugin), type, corejs));
  const invalidRegExpList = plugins.filter((p, i) => selectedPlugins[i].length === 0);
  (0, _invariant.default)(invalidRegExpList.length === 0, `Invalid Option: The plugins/built-ins '${invalidRegExpList.join(", ")}' passed to the '${type}' option are not
    valid. Please check data/[plugin-features|built-in-features].js in babel-preset-env`);
  return flatten(selectedPlugins);
};

const normalizePluginName = plugin => plugin.replace(/^(@babel\/|babel-)(plugin-)?/, "");

exports.normalizePluginName = normalizePluginName;

const checkDuplicateIncludeExcludes = (include = [], exclude = []) => {
  const duplicates = include.filter(opt => exclude.indexOf(opt) >= 0);
  (0, _invariant.default)(duplicates.length === 0, `Invalid Option: The plugins/built-ins '${duplicates.join(", ")}' were found in both the "include" and
    "exclude" options.`);
};

exports.checkDuplicateIncludeExcludes = checkDuplicateIncludeExcludes;

const normalizeTargets = targets => {
  if ((0, _targetsParser.isBrowsersQueryValid)(targets)) {
    return {
      browsers: targets
    };
  }

  return Object.assign({}, targets);
};

const validateConfigPathOption = (configPath = process.cwd()) => {
  (0, _invariant.default)(typeof configPath === "string", `Invalid Option: The configPath option '${configPath}' is invalid, only strings are allowed.`);
  return configPath;
};

exports.validateConfigPathOption = validateConfigPathOption;

const validateBoolOption = (name, value, defaultValue) => {
  if (typeof value === "undefined") {
    value = defaultValue;
  }

  if (typeof value !== "boolean") {
    throw new Error(`Preset env: '${name}' option must be a boolean.`);
  }

  return value;
};

exports.validateBoolOption = validateBoolOption;

const validateIgnoreBrowserslistConfig = ignoreBrowserslistConfig => validateBoolOption(_options.TopLevelOptions.ignoreBrowserslistConfig, ignoreBrowserslistConfig, false);

exports.validateIgnoreBrowserslistConfig = validateIgnoreBrowserslistConfig;

const validateModulesOption = (modulesOpt = _options.ModulesOption.auto) => {
  (0, _invariant.default)(_options.ModulesOption[modulesOpt.toString()] || _options.ModulesOption[modulesOpt.toString()] === _options.ModulesOption.false, `Invalid Option: The 'modules' option must be one of \n` + ` - 'false' to indicate no module processing\n` + ` - a specific module type: 'commonjs', 'amd', 'umd', 'systemjs'` + ` - 'auto' (default) which will automatically select 'false' if the current\n` + `   process is known to support ES module syntax, or "commonjs" otherwise\n`);
  return modulesOpt;
};

exports.validateModulesOption = validateModulesOption;

const validateUseBuiltInsOption = (builtInsOpt = false) => {
  (0, _invariant.default)(_options.UseBuiltInsOption[builtInsOpt.toString()] || _options.UseBuiltInsOption[builtInsOpt.toString()] === _options.UseBuiltInsOption.false, `Invalid Option: The 'useBuiltIns' option must be either
    'false' (default) to indicate no polyfill,
    '"entry"' to indicate replacing the entry polyfill, or
    '"usage"' to import only used polyfills per file`);
  return builtInsOpt;
};

exports.validateUseBuiltInsOption = validateUseBuiltInsOption;

function normalizeCoreJSOption(corejs, useBuiltIns) {
  let proposals = false;
  let rawVersion;

  if (useBuiltIns && corejs === undefined) {
    rawVersion = 2;
    console.warn("\nWARNING: We noticed you're using the `useBuiltIns` option without declaring a " + "core-js version. Currently, we assume version 2.x when no version " + "is passed. Since this default version will likely change in future " + "versions of Babel, we recommend explicitly setting the core-js version " + "you are using via the `corejs` option.\n" + "\nYou should also be sure that the version you pass to the `corejs` " + "option matches the version specified in your `package.json`'s " + "`dependencies` section. If it doesn't, you need to run one of the " + "following commands:\n\n" + "  npm install --save core-js@2    npm install --save core-js@3\n" + "  yarn add core-js@2              yarn add core-js@3\n");
  } else if (typeof corejs === "object" && corejs !== null) {
    rawVersion = corejs.version;
    proposals = Boolean(corejs.proposals);
  } else {
    rawVersion = corejs;
  }

  const version = rawVersion ? (0, _semver.coerce)(String(rawVersion)) : false;

  if (!useBuiltIns && version) {
    console.log("\nThe `corejs` option only has an effect when the `useBuiltIns` option is not `false`\n");
  }

  if (useBuiltIns && (!version || version.major < 2 || version.major > 3)) {
    throw new RangeError("Invalid Option: The version passed to `corejs` is invalid. Currently, " + "only core-js@2 and core-js@3 are supported.");
  }

  return {
    version,
    proposals
  };
}

function normalizeOptions(opts) {
  validateTopLevelOptions(opts);
  const useBuiltIns = validateUseBuiltInsOption(opts.useBuiltIns);
  const corejs = normalizeCoreJSOption(opts.corejs, useBuiltIns);
  const include = expandIncludesAndExcludes(opts.include, _options.TopLevelOptions.include, !!corejs.version && corejs.version.major);
  const exclude = expandIncludesAndExcludes(opts.exclude, _options.TopLevelOptions.exclude, !!corejs.version && corejs.version.major);
  checkDuplicateIncludeExcludes(include, exclude);
  const shippedProposals = validateBoolOption(_options.TopLevelOptions.shippedProposals, opts.shippedProposals, false) || corejs.proposals;
  return {
    configPath: validateConfigPathOption(opts.configPath),
    corejs,
    debug: validateBoolOption(_options.TopLevelOptions.debug, opts.debug, false),
    include,
    exclude,
    forceAllTransforms: validateBoolOption(_options.TopLevelOptions.forceAllTransforms, opts.forceAllTransforms, false),
    ignoreBrowserslistConfig: validateIgnoreBrowserslistConfig(opts.ignoreBrowserslistConfig),
    loose: validateBoolOption(_options.TopLevelOptions.loose, opts.loose, false),
    modules: validateModulesOption(opts.modules),
    shippedProposals,
    spec: validateBoolOption(_options.TopLevelOptions.spec, opts.spec, false),
    targets: normalizeTargets(opts.targets),
    useBuiltIns: useBuiltIns
  };
}

/***/ }),
/* 284 */,
/* 285 */,
/* 286 */,
/* 287 */
/***/ (function(module, __unusedexports, __webpack_require__) {

"use strict";


const canonicalProperties = __webpack_require__(615);
const propertyAliases = __webpack_require__(965);

const matchProperty = function(property) {
	if (canonicalProperties.has(property)) {
		return property;
	}
	if (propertyAliases.has(property)) {
		return propertyAliases.get(property);
	}
	throw new Error(`Unknown property: ${ property }`);
};

module.exports = matchProperty;


/***/ }),
/* 288 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "VISITOR_KEYS", {
  enumerable: true,
  get: function () {
    return _utils.VISITOR_KEYS;
  }
});
Object.defineProperty(exports, "ALIAS_KEYS", {
  enumerable: true,
  get: function () {
    return _utils.ALIAS_KEYS;
  }
});
Object.defineProperty(exports, "FLIPPED_ALIAS_KEYS", {
  enumerable: true,
  get: function () {
    return _utils.FLIPPED_ALIAS_KEYS;
  }
});
Object.defineProperty(exports, "NODE_FIELDS", {
  enumerable: true,
  get: function () {
    return _utils.NODE_FIELDS;
  }
});
Object.defineProperty(exports, "BUILDER_KEYS", {
  enumerable: true,
  get: function () {
    return _utils.BUILDER_KEYS;
  }
});
Object.defineProperty(exports, "DEPRECATED_KEYS", {
  enumerable: true,
  get: function () {
    return _utils.DEPRECATED_KEYS;
  }
});
Object.defineProperty(exports, "PLACEHOLDERS", {
  enumerable: true,
  get: function () {
    return _placeholders.PLACEHOLDERS;
  }
});
Object.defineProperty(exports, "PLACEHOLDERS_ALIAS", {
  enumerable: true,
  get: function () {
    return _placeholders.PLACEHOLDERS_ALIAS;
  }
});
Object.defineProperty(exports, "PLACEHOLDERS_FLIPPED_ALIAS", {
  enumerable: true,
  get: function () {
    return _placeholders.PLACEHOLDERS_FLIPPED_ALIAS;
  }
});
exports.TYPES = void 0;

var _toFastProperties = _interopRequireDefault(__webpack_require__(353));

__webpack_require__(565);

__webpack_require__(296);

__webpack_require__(745);

__webpack_require__(422);

__webpack_require__(40);

__webpack_require__(641);

__webpack_require__(976);

var _utils = __webpack_require__(138);

var _placeholders = __webpack_require__(807);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _toFastProperties.default)(_utils.VISITOR_KEYS);
(0, _toFastProperties.default)(_utils.ALIAS_KEYS);
(0, _toFastProperties.default)(_utils.FLIPPED_ALIAS_KEYS);
(0, _toFastProperties.default)(_utils.NODE_FIELDS);
(0, _toFastProperties.default)(_utils.BUILDER_KEYS);
(0, _toFastProperties.default)(_utils.DEPRECATED_KEYS);
(0, _toFastProperties.default)(_placeholders.PLACEHOLDERS_ALIAS);
(0, _toFastProperties.default)(_placeholders.PLACEHOLDERS_FLIPPED_ALIAS);
const TYPES = Object.keys(_utils.VISITOR_KEYS).concat(Object.keys(_utils.FLIPPED_ALIAS_KEYS)).concat(Object.keys(_utils.DEPRECATED_KEYS));
exports.TYPES = TYPES;

/***/ }),
/* 289 */,
/* 290 */
/***/ (function(__unusedmodule, exports) {

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

/**
 * This is a helper function for getting values from parameter/options
 * objects.
 *
 * @param args The object we are extracting values from
 * @param name The name of the property we are getting.
 * @param defaultValue An optional value to return if the property is missing
 * from the object. If this is not specified and the property is missing, an
 * error will be thrown.
 */
function getArg(aArgs, aName, aDefaultValue) {
  if (aName in aArgs) {
    return aArgs[aName];
  } else if (arguments.length === 3) {
    return aDefaultValue;
  } else {
    throw new Error('"' + aName + '" is a required argument.');
  }
}
exports.getArg = getArg;

var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.]*)(?::(\d+))?(\S*)$/;
var dataUrlRegexp = /^data:.+\,.+$/;

function urlParse(aUrl) {
  var match = aUrl.match(urlRegexp);
  if (!match) {
    return null;
  }
  return {
    scheme: match[1],
    auth: match[2],
    host: match[3],
    port: match[4],
    path: match[5]
  };
}
exports.urlParse = urlParse;

function urlGenerate(aParsedUrl) {
  var url = '';
  if (aParsedUrl.scheme) {
    url += aParsedUrl.scheme + ':';
  }
  url += '//';
  if (aParsedUrl.auth) {
    url += aParsedUrl.auth + '@';
  }
  if (aParsedUrl.host) {
    url += aParsedUrl.host;
  }
  if (aParsedUrl.port) {
    url += ":" + aParsedUrl.port
  }
  if (aParsedUrl.path) {
    url += aParsedUrl.path;
  }
  return url;
}
exports.urlGenerate = urlGenerate;

/**
 * Normalizes a path, or the path portion of a URL:
 *
 * - Replaces consecutive slashes with one slash.
 * - Removes unnecessary '.' parts.
 * - Removes unnecessary '<dir>/..' parts.
 *
 * Based on code in the Node.js 'path' core module.
 *
 * @param aPath The path or url to normalize.
 */
function normalize(aPath) {
  var path = aPath;
  var url = urlParse(aPath);
  if (url) {
    if (!url.path) {
      return aPath;
    }
    path = url.path;
  }
  var isAbsolute = exports.isAbsolute(path);

  var parts = path.split(/\/+/);
  for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
    part = parts[i];
    if (part === '.') {
      parts.splice(i, 1);
    } else if (part === '..') {
      up++;
    } else if (up > 0) {
      if (part === '') {
        // The first part is blank if the path is absolute. Trying to go
        // above the root is a no-op. Therefore we can remove all '..' parts
        // directly after the root.
        parts.splice(i + 1, up);
        up = 0;
      } else {
        parts.splice(i, 2);
        up--;
      }
    }
  }
  path = parts.join('/');

  if (path === '') {
    path = isAbsolute ? '/' : '.';
  }

  if (url) {
    url.path = path;
    return urlGenerate(url);
  }
  return path;
}
exports.normalize = normalize;

/**
 * Joins two paths/URLs.
 *
 * @param aRoot The root path or URL.
 * @param aPath The path or URL to be joined with the root.
 *
 * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
 *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
 *   first.
 * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
 *   is updated with the result and aRoot is returned. Otherwise the result
 *   is returned.
 *   - If aPath is absolute, the result is aPath.
 *   - Otherwise the two paths are joined with a slash.
 * - Joining for example 'http://' and 'www.example.com' is also supported.
 */
function join(aRoot, aPath) {
  if (aRoot === "") {
    aRoot = ".";
  }
  if (aPath === "") {
    aPath = ".";
  }
  var aPathUrl = urlParse(aPath);
  var aRootUrl = urlParse(aRoot);
  if (aRootUrl) {
    aRoot = aRootUrl.path || '/';
  }

  // `join(foo, '//www.example.org')`
  if (aPathUrl && !aPathUrl.scheme) {
    if (aRootUrl) {
      aPathUrl.scheme = aRootUrl.scheme;
    }
    return urlGenerate(aPathUrl);
  }

  if (aPathUrl || aPath.match(dataUrlRegexp)) {
    return aPath;
  }

  // `join('http://', 'www.example.com')`
  if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
    aRootUrl.host = aPath;
    return urlGenerate(aRootUrl);
  }

  var joined = aPath.charAt(0) === '/'
    ? aPath
    : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

  if (aRootUrl) {
    aRootUrl.path = joined;
    return urlGenerate(aRootUrl);
  }
  return joined;
}
exports.join = join;

exports.isAbsolute = function (aPath) {
  return aPath.charAt(0) === '/' || !!aPath.match(urlRegexp);
};

/**
 * Make a path relative to a URL or another path.
 *
 * @param aRoot The root path or URL.
 * @param aPath The path or URL to be made relative to aRoot.
 */
function relative(aRoot, aPath) {
  if (aRoot === "") {
    aRoot = ".";
  }

  aRoot = aRoot.replace(/\/$/, '');

  // It is possible for the path to be above the root. In this case, simply
  // checking whether the root is a prefix of the path won't work. Instead, we
  // need to remove components from the root one by one, until either we find
  // a prefix that fits, or we run out of components to remove.
  var level = 0;
  while (aPath.indexOf(aRoot + '/') !== 0) {
    var index = aRoot.lastIndexOf("/");
    if (index < 0) {
      return aPath;
    }

    // If the only part of the root that is left is the scheme (i.e. http://,
    // file:///, etc.), one or more slashes (/), or simply nothing at all, we
    // have exhausted all components, so the path is not relative to the root.
    aRoot = aRoot.slice(0, index);
    if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
      return aPath;
    }

    ++level;
  }

  // Make sure we add a "../" for each component we removed from the root.
  return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
}
exports.relative = relative;

var supportsNullProto = (function () {
  var obj = Object.create(null);
  return !('__proto__' in obj);
}());

function identity (s) {
  return s;
}

/**
 * Because behavior goes wacky when you set `__proto__` on objects, we
 * have to prefix all the strings in our set with an arbitrary character.
 *
 * See https://github.com/mozilla/source-map/pull/31 and
 * https://github.com/mozilla/source-map/issues/30
 *
 * @param String aStr
 */
function toSetString(aStr) {
  if (isProtoString(aStr)) {
    return '$' + aStr;
  }

  return aStr;
}
exports.toSetString = supportsNullProto ? identity : toSetString;

function fromSetString(aStr) {
  if (isProtoString(aStr)) {
    return aStr.slice(1);
  }

  return aStr;
}
exports.fromSetString = supportsNullProto ? identity : fromSetString;

function isProtoString(s) {
  if (!s) {
    return false;
  }

  var length = s.length;

  if (length < 9 /* "__proto__".length */) {
    return false;
  }

  if (s.charCodeAt(length - 1) !== 95  /* '_' */ ||
      s.charCodeAt(length - 2) !== 95  /* '_' */ ||
      s.charCodeAt(length - 3) !== 111 /* 'o' */ ||
      s.charCodeAt(length - 4) !== 116 /* 't' */ ||
      s.charCodeAt(length - 5) !== 111 /* 'o' */ ||
      s.charCodeAt(length - 6) !== 114 /* 'r' */ ||
      s.charCodeAt(length - 7) !== 112 /* 'p' */ ||
      s.charCodeAt(length - 8) !== 95  /* '_' */ ||
      s.charCodeAt(length - 9) !== 95  /* '_' */) {
    return false;
  }

  for (var i = length - 10; i >= 0; i--) {
    if (s.charCodeAt(i) !== 36 /* '$' */) {
      return false;
    }
  }

  return true;
}

/**
 * Comparator between two mappings where the original positions are compared.
 *
 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
 * mappings with the same original source/line/column, but different generated
 * line and column the same. Useful when searching for a mapping with a
 * stubbed out mapping.
 */
function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
  var cmp = mappingA.source - mappingB.source;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0 || onlyCompareOriginal) {
    return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
    return cmp;
  }

  return mappingA.name - mappingB.name;
}
exports.compareByOriginalPositions = compareByOriginalPositions;

/**
 * Comparator between two mappings with deflated source and name indices where
 * the generated positions are compared.
 *
 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
 * mappings with the same generated line and column, but different
 * source/name/original line and column the same. Useful when searching for a
 * mapping with a stubbed out mapping.
 */
function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
  var cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0 || onlyCompareGenerated) {
    return cmp;
  }

  cmp = mappingA.source - mappingB.source;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0) {
    return cmp;
  }

  return mappingA.name - mappingB.name;
}
exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;

function strcmp(aStr1, aStr2) {
  if (aStr1 === aStr2) {
    return 0;
  }

  if (aStr1 > aStr2) {
    return 1;
  }

  return -1;
}

/**
 * Comparator between two mappings with inflated source and name strings where
 * the generated positions are compared.
 */
function compareByGeneratedPositionsInflated(mappingA, mappingB) {
  var cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = strcmp(mappingA.source, mappingB.source);
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
    return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0) {
    return cmp;
  }

  return strcmp(mappingA.name, mappingB.name);
}
exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;


/***/ }),
/* 291 */,
/* 292 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isBlockScoped;

var _generated = __webpack_require__(897);

var _isLet = _interopRequireDefault(__webpack_require__(117));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function isBlockScoped(node) {
  return (0, _generated.isFunctionDeclaration)(node) || (0, _generated.isClassDeclaration)(node) || (0, _isLet.default)(node);
}

/***/ }),
/* 293 */
/***/ (function(module) {

module.exports = require("buffer");

/***/ }),
/* 294 */,
/* 295 */
/***/ (function(__unusedmodule, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
exports.defaultWebIncludes = void 0;
const defaultWebIncludes = ["web.timers", "web.immediate", "web.dom.iterable"];
exports.defaultWebIncludes = defaultWebIncludes;

function _default(targets) {
  const targetNames = Object.keys(targets);
  const isAnyTarget = !targetNames.length;
  const isWebTarget = targetNames.some(name => name !== "node");
  return isAnyTarget || isWebTarget ? defaultWebIncludes : null;
}

/***/ }),
/* 296 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.classMethodOrDeclareMethodCommon = exports.classMethodOrPropertyCommon = void 0;

var _utils = _interopRequireWildcard(__webpack_require__(138));

var _core = __webpack_require__(565);

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

(0, _utils.default)("AssignmentPattern", {
  visitor: ["left", "right", "decorators"],
  builder: ["left", "right"],
  aliases: ["Pattern", "PatternLike", "LVal"],
  fields: Object.assign({}, _core.patternLikeCommon, {
    left: {
      validate: (0, _utils.assertNodeType)("Identifier", "ObjectPattern", "ArrayPattern", "MemberExpression")
    },
    right: {
      validate: (0, _utils.assertNodeType)("Expression")
    },
    decorators: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator")))
    }
  })
});
(0, _utils.default)("ArrayPattern", {
  visitor: ["elements", "typeAnnotation"],
  builder: ["elements"],
  aliases: ["Pattern", "PatternLike", "LVal"],
  fields: Object.assign({}, _core.patternLikeCommon, {
    elements: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("PatternLike")))
    },
    decorators: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator")))
    }
  })
});
(0, _utils.default)("ArrowFunctionExpression", {
  builder: ["params", "body", "async"],
  visitor: ["params", "body", "returnType", "typeParameters"],
  aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
  fields: Object.assign({}, _core.functionCommon, {}, _core.functionTypeAnnotationCommon, {
    expression: {
      validate: (0, _utils.assertValueType)("boolean")
    },
    body: {
      validate: (0, _utils.assertNodeType)("BlockStatement", "Expression")
    }
  })
});
(0, _utils.default)("ClassBody", {
  visitor: ["body"],
  fields: {
    body: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ClassMethod", "ClassPrivateMethod", "ClassProperty", "ClassPrivateProperty", "TSDeclareMethod", "TSIndexSignature")))
    }
  }
});
const classCommon = {
  typeParameters: {
    validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
    optional: true
  },
  body: {
    validate: (0, _utils.assertNodeType)("ClassBody")
  },
  superClass: {
    optional: true,
    validate: (0, _utils.assertNodeType)("Expression")
  },
  superTypeParameters: {
    validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
    optional: true
  },
  implements: {
    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSExpressionWithTypeArguments", "ClassImplements"))),
    optional: true
  }
};
(0, _utils.default)("ClassDeclaration", {
  builder: ["id", "superClass", "body", "decorators"],
  visitor: ["id", "body", "superClass", "mixins", "typeParameters", "superTypeParameters", "implements", "decorators"],
  aliases: ["Scopable", "Class", "Statement", "Declaration", "Pureish"],
  fields: Object.assign({}, classCommon, {
    declare: {
      validate: (0, _utils.assertValueType)("boolean"),
      optional: true
    },
    abstract: {
      validate: (0, _utils.assertValueType)("boolean"),
      optional: true
    },
    id: {
      validate: (0, _utils.assertNodeType)("Identifier"),
      optional: true
    },
    decorators: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
      optional: true
    }
  })
});
(0, _utils.default)("ClassExpression", {
  inherits: "ClassDeclaration",
  aliases: ["Scopable", "Class", "Expression", "Pureish"],
  fields: Object.assign({}, classCommon, {
    id: {
      optional: true,
      validate: (0, _utils.assertNodeType)("Identifier")
    },
    body: {
      validate: (0, _utils.assertNodeType)("ClassBody")
    },
    superClass: {
      optional: true,
      validate: (0, _utils.assertNodeType)("Expression")
    },
    decorators: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
      optional: true
    }
  })
});
(0, _utils.default)("ExportAllDeclaration", {
  visitor: ["source"],
  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
  fields: {
    source: {
      validate: (0, _utils.assertNodeType)("StringLiteral")
    }
  }
});
(0, _utils.default)("ExportDefaultDeclaration", {
  visitor: ["declaration"],
  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
  fields: {
    declaration: {
      validate: (0, _utils.assertNodeType)("FunctionDeclaration", "TSDeclareFunction", "ClassDeclaration", "Expression")
    }
  }
});
(0, _utils.default)("ExportNamedDeclaration", {
  visitor: ["declaration", "specifiers", "source"],
  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
  fields: {
    declaration: {
      validate: (0, _utils.assertNodeType)("Declaration"),
      optional: true
    },
    specifiers: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ExportSpecifier", "ExportDefaultSpecifier", "ExportNamespaceSpecifier")))
    },
    source: {
      validate: (0, _utils.assertNodeType)("StringLiteral"),
      optional: true
    },
    exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value"))
  }
});
(0, _utils.default)("ExportSpecifier", {
  visitor: ["local", "exported"],
  aliases: ["ModuleSpecifier"],
  fields: {
    local: {
      validate: (0, _utils.assertNodeType)("Identifier")
    },
    exported: {
      validate: (0, _utils.assertNodeType)("Identifier")
    }
  }
});
(0, _utils.default)("ForOfStatement", {
  visitor: ["left", "right", "body"],
  aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
  fields: {
    left: {
      validate: (0, _utils.assertNodeType)("VariableDeclaration", "LVal")
    },
    right: {
      validate: (0, _utils.assertNodeType)("Expression")
    },
    body: {
      validate: (0, _utils.assertNodeType)("Statement")
    },
    await: {
      default: false,
      validate: (0, _utils.assertValueType)("boolean")
    }
  }
});
(0, _utils.default)("ImportDeclaration", {
  visitor: ["specifiers", "source"],
  aliases: ["Statement", "Declaration", "ModuleDeclaration"],
  fields: {
    specifiers: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ImportSpecifier", "ImportDefaultSpecifier", "ImportNamespaceSpecifier")))
    },
    source: {
      validate: (0, _utils.assertNodeType)("StringLiteral")
    },
    importKind: {
      validate: (0, _utils.assertOneOf)("type", "typeof", "value"),
      optional: true
    }
  }
});
(0, _utils.default)("ImportDefaultSpecifier", {
  visitor: ["local"],
  aliases: ["ModuleSpecifier"],
  fields: {
    local: {
      validate: (0, _utils.assertNodeType)("Identifier")
    }
  }
});
(0, _utils.default)("ImportNamespaceSpecifier", {
  visitor: ["local"],
  aliases: ["ModuleSpecifier"],
  fields: {
    local: {
      validate: (0, _utils.assertNodeType)("Identifier")
    }
  }
});
(0, _utils.default)("ImportSpecifier", {
  visitor: ["local", "imported"],
  aliases: ["ModuleSpecifier"],
  fields: {
    local: {
      validate: (0, _utils.assertNodeType)("Identifier")
    },
    imported: {
      validate: (0, _utils.assertNodeType)("Identifier")
    },
    importKind: {
      validate: (0, _utils.assertOneOf)("type", "typeof"),
      optional: true
    }
  }
});
(0, _utils.default)("MetaProperty", {
  visitor: ["meta", "property"],
  aliases: ["Expression"],
  fields: {
    meta: {
      validate: (0, _utils.assertNodeType)("Identifier")
    },
    property: {
      validate: (0, _utils.assertNodeType)("Identifier")
    }
  }
});
const classMethodOrPropertyCommon = {
  abstract: {
    validate: (0, _utils.assertValueType)("boolean"),
    optional: true
  },
  accessibility: {
    validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), (0, _utils.assertOneOf)("public", "private", "protected")),
    optional: true
  },
  static: {
    default: false,
    validate: (0, _utils.assertValueType)("boolean")
  },
  computed: {
    default: false,
    validate: (0, _utils.assertValueType)("boolean")
  },
  optional: {
    validate: (0, _utils.assertValueType)("boolean"),
    optional: true
  },
  key: {
    validate: (0, _utils.chain)(function () {
      const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral");
      const computed = (0, _utils.assertNodeType)("Expression");
      return function (node, key, val) {
        const validator = node.computed ? computed : normal;
        validator(node, key, val);
      };
    }(), (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral", "Expression"))
  }
};
exports.classMethodOrPropertyCommon = classMethodOrPropertyCommon;
const classMethodOrDeclareMethodCommon = Object.assign({}, _core.functionCommon, {}, classMethodOrPropertyCommon, {
  kind: {
    validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), (0, _utils.assertOneOf)("get", "set", "method", "constructor")),
    default: "method"
  },
  access: {
    validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), (0, _utils.assertOneOf)("public", "private", "protected")),
    optional: true
  },
  decorators: {
    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    optional: true
  }
});
exports.classMethodOrDeclareMethodCommon = classMethodOrDeclareMethodCommon;
(0, _utils.default)("ClassMethod", {
  aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method"],
  builder: ["kind", "key", "params", "body", "computed", "static"],
  visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
  fields: Object.assign({}, classMethodOrDeclareMethodCommon, {}, _core.functionTypeAnnotationCommon, {
    body: {
      validate: (0, _utils.assertNodeType)("BlockStatement")
    }
  })
});
(0, _utils.default)("ObjectPattern", {
  visitor: ["properties", "typeAnnotation", "decorators"],
  builder: ["properties"],
  aliases: ["Pattern", "PatternLike", "LVal"],
  fields: Object.assign({}, _core.patternLikeCommon, {
    properties: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("RestElement", "ObjectProperty")))
    }
  })
});
(0, _utils.default)("SpreadElement", {
  visitor: ["argument"],
  aliases: ["UnaryLike"],
  deprecatedAlias: "SpreadProperty",
  fields: {
    argument: {
      validate: (0, _utils.assertNodeType)("Expression")
    }
  }
});
(0, _utils.default)("Super", {
  aliases: ["Expression"]
});
(0, _utils.default)("TaggedTemplateExpression", {
  visitor: ["tag", "quasi"],
  aliases: ["Expression"],
  fields: {
    tag: {
      validate: (0, _utils.assertNodeType)("Expression")
    },
    quasi: {
      validate: (0, _utils.assertNodeType)("TemplateLiteral")
    },
    typeParameters: {
      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
      optional: true
    }
  }
});
(0, _utils.default)("TemplateElement", {
  builder: ["value", "tail"],
  fields: {
    value: {
      validate: (0, _utils.assertShape)({
        raw: {
          validate: (0, _utils.assertValueType)("string")
        },
        cooked: {
          validate: (0, _utils.assertValueType)("string"),
          optional: true
        }
      })
    },
    tail: {
      validate: (0, _utils.assertValueType)("boolean"),
      default: false
    }
  }
});
(0, _utils.default)("TemplateLiteral", {
  visitor: ["quasis", "expressions"],
  aliases: ["Expression", "Literal"],
  fields: {
    quasis: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TemplateElement")))
    },
    expressions: {
      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression")), function (node, key, val) {
        if (node.quasis.length !== val.length + 1) {
          throw new TypeError(`Number of ${node.type} quasis should be exactly one more than the number of expressions.\nExpected ${val.length + 1} quasis but got ${node.quasis.length}`);
        }
      })
    }
  }
});
(0, _utils.default)("YieldExpression", {
  builder: ["argument", "delegate"],
  visitor: ["argument"],
  aliases: ["Expression", "Terminatorless"],
  fields: {
    delegate: {
      validate: (0, _utils.assertValueType)("boolean"),
      default: false
    },
    argument: {
      optional: true,
      validate: (0, _utils.assertNodeType)("Expression")
    }
  }
});

/***/ }),
/* 297 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _helperGetFunctionArity = _interopRequireDefault(__webpack_require__(477));

var _template = _interopRequireDefault(__webpack_require__(5));

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const buildPropertyMethodAssignmentWrapper = (0, _template.default)(`
  (function (FUNCTION_KEY) {
    function FUNCTION_ID() {
      return FUNCTION_KEY.apply(this, arguments);
    }

    FUNCTION_ID.toString = function () {
      return FUNCTION_KEY.toString();
    }

    return FUNCTION_ID;
  })(FUNCTION)
`);
const buildGeneratorPropertyMethodAssignmentWrapper = (0, _template.default)(`
  (function (FUNCTION_KEY) {
    function* FUNCTION_ID() {
      return yield* FUNCTION_KEY.apply(this, arguments);
    }

    FUNCTION_ID.toString = function () {
      return FUNCTION_KEY.toString();
    };

    return FUNCTION_ID;
  })(FUNCTION)
`);
const visitor = {
  "ReferencedIdentifier|BindingIdentifier"(path, state) {
    if (path.node.name !== state.name) return;
    const localDeclar = path.scope.getBindingIdentifier(state.name);
    if (localDeclar !== state.outerDeclar) return;
    state.selfReference = true;
    path.stop();
  }

};

function getNameFromLiteralId(id) {
  if (t.isNullLiteral(id)) {
    return "null";
  }

  if (t.isRegExpLiteral(id)) {
    return `_${id.pattern}_${id.flags}`;
  }

  if (t.isTemplateLiteral(id)) {
    return id.quasis.map(quasi => quasi.value.raw).join("");
  }

  if (id.value !== undefined) {
    return id.value + "";
  }

  return "";
}

function wrap(state, method, id, scope) {
  if (state.selfReference) {
    if (scope.hasBinding(id.name) && !scope.hasGlobal(id.name)) {
      scope.rename(id.name);
    } else {
      if (!t.isFunction(method)) return;
      let build = buildPropertyMethodAssignmentWrapper;

      if (method.generator) {
        build = buildGeneratorPropertyMethodAssignmentWrapper;
      }

      const template = build({
        FUNCTION: method,
        FUNCTION_ID: id,
        FUNCTION_KEY: scope.generateUidIdentifier(id.name)
      }).expression;
      const params = template.callee.body.body[0].params;

      for (let i = 0, len = (0, _helperGetFunctionArity.default)(method); i < len; i++) {
        params.push(scope.generateUidIdentifier("x"));
      }

      return template;
    }
  }

  method.id = id;
  scope.getProgramParent().references[id.name] = true;
}

function visit(node, name, scope) {
  const state = {
    selfAssignment: false,
    selfReference: false,
    outerDeclar: scope.getBindingIdentifier(name),
    references: [],
    name: name
  };
  const binding = scope.getOwnBinding(name);

  if (binding) {
    if (binding.kind === "param") {
      state.selfReference = true;
    } else {}
  } else if (state.outerDeclar || scope.hasGlobal(name)) {
    scope.traverse(node, visitor, state);
  }

  return state;
}

function _default({
  node,
  parent,
  scope,
  id
}, localBinding = false) {
  if (node.id) return;

  if ((t.isObjectProperty(parent) || t.isObjectMethod(parent, {
    kind: "method"
  })) && (!parent.computed || t.isLiteral(parent.key))) {
    id = parent.key;
  } else if (t.isVariableDeclarator(parent)) {
    id = parent.id;

    if (t.isIdentifier(id) && !localBinding) {
      const binding = scope.parent.getBinding(id.name);

      if (binding && binding.constant && scope.getBinding(id.name) === binding) {
        node.id = t.cloneNode(id);
        node.id[t.NOT_LOCAL_BINDING] = true;
        return;
      }
    }
  } else if (t.isAssignmentExpression(parent)) {
    id = parent.left;
  } else if (!id) {
    return;
  }

  let name;

  if (id && t.isLiteral(id)) {
    name = getNameFromLiteralId(id);
  } else if (id && t.isIdentifier(id)) {
    name = id.name;
  }

  if (name === undefined) {
    return;
  }

  name = t.toBindingIdentifierName(name);
  id = t.identifier(name);
  id[t.NOT_LOCAL_BINDING] = true;
  const state = visit(node, name, scope);
  return wrap(state, node, id, scope) || node;
}

/***/ }),
/* 298 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _path = _interopRequireDefault(__webpack_require__(774));

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const testing = process.env.NODE_ENV === "test";

class TraversalContext {
  constructor(scope, opts, state, parentPath) {
    this.queue = null;
    this.parentPath = parentPath;
    this.scope = scope;
    this.state = state;
    this.opts = opts;
  }

  shouldVisit(node) {
    const opts = this.opts;
    if (opts.enter || opts.exit) return true;
    if (opts[node.type]) return true;
    const keys = t.VISITOR_KEYS[node.type];
    if (!keys || !keys.length) return false;

    for (const key of keys) {
      if (node[key]) return true;
    }

    return false;
  }

  create(node, obj, key, listKey) {
    return _path.default.get({
      parentPath: this.parentPath,
      parent: node,
      container: obj,
      key: key,
      listKey
    });
  }

  maybeQueue(path, notPriority) {
    if (this.trap) {
      throw new Error("Infinite cycle detected");
    }

    if (this.queue) {
      if (notPriority) {
        this.queue.push(path);
      } else {
        this.priorityQueue.push(path);
      }
    }
  }

  visitMultiple(container, parent, listKey) {
    if (container.length === 0) return false;
    const queue = [];

    for (let key = 0; key < container.length; key++) {
      const node = container[key];

      if (node && this.shouldVisit(node)) {
        queue.push(this.create(parent, container, key, listKey));
      }
    }

    return this.visitQueue(queue);
  }

  visitSingle(node, key) {
    if (this.shouldVisit(node[key])) {
      return this.visitQueue([this.create(node, node, key)]);
    } else {
      return false;
    }
  }

  visitQueue(queue) {
    this.queue = queue;
    this.priorityQueue = [];
    const visited = [];
    let stop = false;

    for (const path of queue) {
      path.resync();

      if (path.contexts.length === 0 || path.contexts[path.contexts.length - 1] !== this) {
        path.pushContext(this);
      }

      if (path.key === null) continue;

      if (testing && queue.length >= 10000) {
        this.trap = true;
      }

      if (visited.indexOf(path.node) >= 0) continue;
      visited.push(path.node);

      if (path.visit()) {
        stop = true;
        break;
      }

      if (this.priorityQueue.length) {
        stop = this.visitQueue(this.priorityQueue);
        this.priorityQueue = [];
        this.queue = queue;
        if (stop) break;
      }
    }

    for (const path of queue) {
      path.popContext();
    }

    this.queue = null;
    return stop;
  }

  visit(node, key) {
    const nodes = node[key];
    if (!nodes) return false;

    if (Array.isArray(nodes)) {
      return this.visitMultiple(nodes, node, key);
    } else {
      return this.visitSingle(node, key);
    }
  }

}

exports.default = TraversalContext;

/***/ }),
/* 299 */
/***/ (function(module, __unusedexports, __webpack_require__) {

const unicode = __webpack_require__(507)

module.exports = {
    isSpaceSeparator (c) {
        return unicode.Space_Separator.test(c)
    },

    isIdStartChar (c) {
        return (
            (c >= 'a' && c <= 'z') ||
        (c >= 'A' && c <= 'Z') ||
        (c === '$') || (c === '_') ||
        unicode.ID_Start.test(c)
        )
    },

    isIdContinueChar (c) {
        return (
            (c >= 'a' && c <= 'z') ||
        (c >= 'A' && c <= 'Z') ||
        (c >= '0' && c <= '9') ||
        (c === '$') || (c === '_') ||
        (c === '\u200C') || (c === '\u200D') ||
        unicode.ID_Continue.test(c)
        )
    },

    isDigit (c) {
        return /[0-9]/.test(c)
    },

    isHexDigit (c) {
        return /[0-9A-Fa-f]/.test(c)
    },
}


/***/ }),
/* 300 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _helperCreateRegexpFeaturesPlugin = __webpack_require__(362);

var _helperPluginUtils = __webpack_require__(57);

var _default = (0, _helperPluginUtils.declare)((api, options) => {
  api.assertVersion(7);
  const {
    useUnicodeFlag = true
  } = options;

  if (typeof useUnicodeFlag !== "boolean") {
    throw new Error(".useUnicodeFlag must be a boolean, or undefined");
  }

  return (0, _helperCreateRegexpFeaturesPlugin.createRegExpFeaturePlugin)({
    name: "proposal-unicode-property-regex",
    feature: "unicodePropertyEscape",
    options: {
      useUnicodeFlag
    }
  });
});

exports.default = _default;

/***/ }),
/* 301 */,
/* 302 */,
/* 303 */,
/* 304 */
/***/ (function(module) {

/** Used to detect hot functions by number of calls within a span of milliseconds. */
var HOT_COUNT = 800,
    HOT_SPAN = 16;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeNow = Date.now;

/**
 * Creates a function that'll short out and invoke `identity` instead
 * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
 * milliseconds.
 *
 * @private
 * @param {Function} func The function to restrict.
 * @returns {Function} Returns the new shortable function.
 */
function shortOut(func) {
  var count = 0,
      lastCalled = 0;

  return function() {
    var stamp = nativeNow(),
        remaining = HOT_SPAN - (stamp - lastCalled);

    lastCalled = stamp;
    if (remaining > 0) {
      if (++count >= HOT_COUNT) {
        return arguments[0];
      }
    } else {
      count = 0;
    }
    return func.apply(undefined, arguments);
  };
}

module.exports = shortOut;


/***/ }),
/* 305 */,
/* 306 */
/***/ (function(module) {

module.exports = {"es6.array.copy-within":{"chrome":"45","edge":"12","firefox":"32","safari":"9","node":"4","ios":"9","samsung":"5","opera":"32","electron":"0.35"},"es6.array.every":{"chrome":"5","opera":"10.10","edge":"12","firefox":"2","safari":"3.1","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.array.fill":{"chrome":"45","edge":"12","firefox":"31","safari":"7.1","node":"4","ios":"8","samsung":"5","opera":"32","electron":"0.35"},"es6.array.filter":{"chrome":"5","opera":"10.10","edge":"12","firefox":"2","safari":"3.1","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.array.find":{"chrome":"45","edge":"12","firefox":"25","safari":"7.1","node":"4","ios":"8","samsung":"5","opera":"32","electron":"0.35"},"es6.array.find-index":{"chrome":"45","edge":"12","firefox":"25","safari":"7.1","node":"4","ios":"8","samsung":"5","opera":"32","electron":"0.35"},"es7.array.flat-map":{"chrome":"69","firefox":"62","safari":"12","node":"11","ios":"12","opera":"56","electron":"4"},"es6.array.for-each":{"chrome":"5","opera":"10.10","edge":"12","firefox":"2","safari":"3.1","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.array.from":{"chrome":"51","edge":"15","firefox":"36","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es7.array.includes":{"chrome":"47","edge":"14","firefox":"43","safari":"10","node":"6","ios":"10","samsung":"5","opera":"34","electron":"0.36"},"es6.array.index-of":{"chrome":"5","opera":"10.10","edge":"12","firefox":"2","safari":"3.1","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.array.is-array":{"chrome":"5","opera":"10.50","edge":"12","firefox":"4","safari":"4","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.array.iterator":{"chrome":"38","edge":"12","firefox":"28","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.array.last-index-of":{"chrome":"5","opera":"10.10","edge":"12","firefox":"2","safari":"3.1","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.array.map":{"chrome":"5","opera":"10.10","edge":"12","firefox":"2","safari":"3.1","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.array.of":{"chrome":"45","edge":"12","firefox":"25","safari":"9","node":"4","ios":"9","samsung":"5","opera":"32","electron":"0.35"},"es6.array.reduce":{"chrome":"5","opera":"10.50","edge":"12","firefox":"3","safari":"4","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.array.reduce-right":{"chrome":"5","opera":"10.50","edge":"12","firefox":"3","safari":"4","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.array.some":{"chrome":"5","opera":"10.10","edge":"12","firefox":"2","safari":"3.1","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.array.sort":{"chrome":"63","opera":"50","edge":"12","firefox":"5","safari":"12","node":"10","ie":"9","ios":"12","samsung":"8.2","electron":"3.1"},"es6.array.species":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.date.now":{"chrome":"5","opera":"10.50","edge":"12","firefox":"2","safari":"4","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.date.to-iso-string":{"chrome":"5","opera":"10.50","edge":"12","firefox":"3.5","safari":"4","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.date.to-json":{"chrome":"5","opera":"12.10","edge":"12","firefox":"4","safari":"10","node":"0.10","ie":"9","android":"4","ios":"10","samsung":"2.1","electron":"1.1"},"es6.date.to-primitive":{"chrome":"47","edge":"15","firefox":"44","safari":"10","node":"6","ios":"10","samsung":"5","opera":"34","electron":"0.36"},"es6.date.to-string":{"chrome":"5","opera":"10.50","edge":"12","firefox":"2","safari":"3.1","node":"0.10","ie":"10","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.function.bind":{"chrome":"7","opera":"12","edge":"12","firefox":"4","safari":"5.1","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"5"},"es6.function.has-instance":{"chrome":"51","edge":"15","firefox":"50","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.function.name":{"chrome":"5","opera":"10.50","edge":"14","firefox":"2","safari":"4","node":"0.10","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.map":{"chrome":"51","edge":"15","firefox":"53","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.math.acosh":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.asinh":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.atanh":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.cbrt":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.clz32":{"chrome":"38","edge":"12","firefox":"31","safari":"9","node":"0.12","ios":"9","samsung":"3","opera":"25","electron":"0.2"},"es6.math.cosh":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.expm1":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.fround":{"chrome":"38","edge":"12","firefox":"26","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.hypot":{"chrome":"38","edge":"12","firefox":"27","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.imul":{"chrome":"30","edge":"12","firefox":"23","safari":"7","node":"0.12","android":"4.4","ios":"7","samsung":"2.1","opera":"17","electron":"0.2"},"es6.math.log1p":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.log10":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.log2":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.sign":{"chrome":"38","edge":"12","firefox":"25","safari":"9","node":"0.12","ios":"9","samsung":"3","opera":"25","electron":"0.2"},"es6.math.sinh":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.tanh":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.math.trunc":{"chrome":"38","edge":"12","firefox":"25","safari":"7.1","node":"0.12","ios":"8","samsung":"3","opera":"25","electron":"0.2"},"es6.number.constructor":{"chrome":"41","edge":"12","firefox":"36","safari":"9","node":"4","ios":"9","samsung":"3.4","opera":"28","electron":"0.24"},"es6.number.epsilon":{"chrome":"34","edge":"12","firefox":"25","safari":"9","node":"0.12","ios":"9","samsung":"2.1","opera":"21","electron":"0.2"},"es6.number.is-finite":{"chrome":"19","edge":"12","firefox":"16","safari":"9","node":"0.12","android":"4.1","ios":"9","samsung":"2.1","electron":"0.2"},"es6.number.is-integer":{"chrome":"34","edge":"12","firefox":"16","safari":"9","node":"0.12","ios":"9","samsung":"2.1","opera":"21","electron":"0.2"},"es6.number.is-nan":{"chrome":"19","edge":"12","firefox":"15","safari":"9","node":"0.12","android":"4.1","ios":"9","samsung":"2.1","electron":"0.2"},"es6.number.is-safe-integer":{"chrome":"34","edge":"12","firefox":"32","safari":"9","node":"0.12","ios":"9","samsung":"2.1","opera":"21","electron":"0.2"},"es6.number.max-safe-integer":{"chrome":"34","edge":"12","firefox":"31","safari":"9","node":"0.12","ios":"9","samsung":"2.1","opera":"21","electron":"0.2"},"es6.number.min-safe-integer":{"chrome":"34","edge":"12","firefox":"31","safari":"9","node":"0.12","ios":"9","samsung":"2.1","opera":"21","electron":"0.2"},"es6.number.parse-float":{"chrome":"34","edge":"12","firefox":"25","safari":"9","node":"0.12","ios":"9","samsung":"2.1","opera":"21","electron":"0.2"},"es6.number.parse-int":{"chrome":"34","edge":"12","firefox":"25","safari":"9","node":"0.12","ios":"9","samsung":"2.1","opera":"21","electron":"0.2"},"es6.object.assign":{"chrome":"49","edge":"13","firefox":"36","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.object.create":{"chrome":"5","opera":"12","edge":"12","firefox":"4","safari":"4","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es7.object.define-getter":{"chrome":"62","edge":"16","firefox":"48","safari":"9","node":"8.10","ios":"9","samsung":"8.2","opera":"49","electron":"3.1"},"es7.object.define-setter":{"chrome":"62","edge":"16","firefox":"48","safari":"9","node":"8.10","ios":"9","samsung":"8.2","opera":"49","electron":"3.1"},"es6.object.define-property":{"chrome":"5","opera":"12","edge":"12","firefox":"4","safari":"5.1","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.object.define-properties":{"chrome":"5","opera":"12","edge":"12","firefox":"4","safari":"4","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es7.object.entries":{"chrome":"54","edge":"14","firefox":"47","safari":"10.1","node":"7","ios":"10.3","samsung":"6.2","opera":"41","electron":"1.5"},"es6.object.freeze":{"chrome":"44","edge":"12","firefox":"35","safari":"9","node":"4","ios":"9","samsung":"4","opera":"31","electron":"0.31"},"es6.object.get-own-property-descriptor":{"chrome":"44","edge":"12","firefox":"35","safari":"9","node":"4","ios":"9","samsung":"4","opera":"31","electron":"0.31"},"es7.object.get-own-property-descriptors":{"chrome":"54","edge":"15","firefox":"50","safari":"10.1","node":"7","ios":"10.3","samsung":"6.2","opera":"41","electron":"1.5"},"es6.object.get-own-property-names":{"chrome":"40","edge":"12","firefox":"33","safari":"9","node":"4","ios":"9","samsung":"3.4","opera":"27","electron":"0.21"},"es6.object.get-prototype-of":{"chrome":"44","edge":"12","firefox":"35","safari":"9","node":"4","ios":"9","samsung":"4","opera":"31","electron":"0.31"},"es7.object.lookup-getter":{"chrome":"62","firefox":"36","safari":"9","node":"8.10","ios":"9","samsung":"8.2","opera":"49","electron":"3.1"},"es7.object.lookup-setter":{"chrome":"62","firefox":"36","safari":"9","node":"8.10","ios":"9","samsung":"8.2","opera":"49","electron":"3.1"},"es6.object.prevent-extensions":{"chrome":"44","edge":"12","firefox":"35","safari":"9","node":"4","ios":"9","samsung":"4","opera":"31","electron":"0.31"},"es6.object.to-string":{"chrome":"57","edge":"15","firefox":"51","safari":"10","node":"8","ios":"10","samsung":"7.2","opera":"44","electron":"1.7"},"es6.object.is":{"chrome":"19","edge":"12","firefox":"22","safari":"9","node":"0.12","android":"4.1","ios":"9","samsung":"2.1","electron":"0.2"},"es6.object.is-frozen":{"chrome":"44","edge":"12","firefox":"35","safari":"9","node":"4","ios":"9","samsung":"4","opera":"31","electron":"0.31"},"es6.object.is-sealed":{"chrome":"44","edge":"12","firefox":"35","safari":"9","node":"4","ios":"9","samsung":"4","opera":"31","electron":"0.31"},"es6.object.is-extensible":{"chrome":"44","edge":"12","firefox":"35","safari":"9","node":"4","ios":"9","samsung":"4","opera":"31","electron":"0.31"},"es6.object.keys":{"chrome":"40","edge":"12","firefox":"35","safari":"9","node":"4","ios":"9","samsung":"3.4","opera":"27","electron":"0.21"},"es6.object.seal":{"chrome":"44","edge":"12","firefox":"35","safari":"9","node":"4","ios":"9","samsung":"4","opera":"31","electron":"0.31"},"es6.object.set-prototype-of":{"chrome":"34","edge":"12","firefox":"31","safari":"9","node":"0.12","ie":"11","ios":"9","samsung":"2.1","opera":"21","electron":"0.2"},"es7.object.values":{"chrome":"54","edge":"14","firefox":"47","safari":"10.1","node":"7","ios":"10.3","samsung":"6.2","opera":"41","electron":"1.5"},"es6.promise":{"chrome":"51","edge":"14","firefox":"45","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es7.promise.finally":{"chrome":"63","edge":"18","firefox":"58","safari":"11.1","node":"10","ios":"11.3","samsung":"8.2","opera":"50","electron":"3.1"},"es6.reflect.apply":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.construct":{"chrome":"49","edge":"13","firefox":"49","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.define-property":{"chrome":"49","edge":"13","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.delete-property":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.get":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.get-own-property-descriptor":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.get-prototype-of":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.has":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.is-extensible":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.own-keys":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.prevent-extensions":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.set":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.reflect.set-prototype-of":{"chrome":"49","edge":"12","firefox":"42","safari":"10","node":"6","ios":"10","samsung":"5","opera":"36","electron":"1"},"es6.regexp.constructor":{"chrome":"50","firefox":"40","safari":"10","node":"6","ios":"10","samsung":"5","opera":"37","electron":"1.1"},"es6.regexp.flags":{"chrome":"49","firefox":"37","safari":"9","node":"6","ios":"9","samsung":"5","opera":"36","electron":"1"},"es6.regexp.match":{"chrome":"50","firefox":"49","safari":"10","node":"6","ios":"10","samsung":"5","opera":"37","electron":"1.1"},"es6.regexp.replace":{"chrome":"50","firefox":"49","safari":"10","node":"6","ios":"10","samsung":"5","opera":"37","electron":"1.1"},"es6.regexp.split":{"chrome":"50","firefox":"49","safari":"10","node":"6","ios":"10","samsung":"5","opera":"37","electron":"1.1"},"es6.regexp.search":{"chrome":"50","firefox":"49","safari":"10","node":"6","ios":"10","samsung":"5","opera":"37","electron":"1.1"},"es6.regexp.to-string":{"chrome":"50","firefox":"39","safari":"10","node":"6","ios":"10","samsung":"5","opera":"37","electron":"1.1"},"es6.set":{"chrome":"51","edge":"15","firefox":"53","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.symbol":{"chrome":"51","firefox":"51","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es7.symbol.async-iterator":{"chrome":"63","firefox":"57","safari":"12","node":"10","ios":"12","samsung":"8.2","opera":"50","electron":"3.1"},"es6.string.anchor":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.big":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.blink":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.bold":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.code-point-at":{"chrome":"41","edge":"12","firefox":"29","safari":"9","node":"4","ios":"9","samsung":"3.4","opera":"28","electron":"0.24"},"es6.string.ends-with":{"chrome":"41","edge":"12","firefox":"29","safari":"9","node":"4","ios":"9","samsung":"3.4","opera":"28","electron":"0.24"},"es6.string.fixed":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.fontcolor":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.fontsize":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.from-code-point":{"chrome":"41","edge":"12","firefox":"29","safari":"9","node":"4","ios":"9","samsung":"3.4","opera":"28","electron":"0.24"},"es6.string.includes":{"chrome":"41","edge":"12","firefox":"40","safari":"9","node":"4","ios":"9","samsung":"3.4","opera":"28","electron":"0.24"},"es6.string.italics":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.iterator":{"chrome":"38","edge":"12","firefox":"36","safari":"9","node":"0.12","ios":"9","samsung":"3","opera":"25","electron":"0.2"},"es6.string.link":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es7.string.pad-start":{"chrome":"57","edge":"15","firefox":"48","safari":"10","node":"8","ios":"10","samsung":"7.2","opera":"44","electron":"1.7"},"es7.string.pad-end":{"chrome":"57","edge":"15","firefox":"48","safari":"10","node":"8","ios":"10","samsung":"7.2","opera":"44","electron":"1.7"},"es6.string.raw":{"chrome":"41","edge":"12","firefox":"34","safari":"9","node":"4","ios":"9","samsung":"3.4","opera":"28","electron":"0.24"},"es6.string.repeat":{"chrome":"41","edge":"12","firefox":"24","safari":"9","node":"4","ios":"9","samsung":"3.4","opera":"28","electron":"0.24"},"es6.string.small":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.starts-with":{"chrome":"41","edge":"12","firefox":"29","safari":"9","node":"4","ios":"9","samsung":"3.4","opera":"28","electron":"0.24"},"es6.string.strike":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.sub":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.sup":{"chrome":"5","edge":"12","firefox":"17","safari":"6","node":"0.10","android":"4","ios":"7","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.string.trim":{"chrome":"5","opera":"10.50","edge":"12","firefox":"3.5","safari":"4","node":"0.10","ie":"9","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es7.string.trim-left":{"chrome":"66","firefox":"61","safari":"12","node":"10","ios":"12","opera":"53","electron":"3.1"},"es7.string.trim-right":{"chrome":"66","firefox":"61","safari":"12","node":"10","ios":"12","opera":"53","electron":"3.1"},"es6.typed.array-buffer":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.typed.data-view":{"chrome":"5","opera":"12","edge":"12","firefox":"15","safari":"5.1","node":"0.10","ie":"10","android":"4","ios":"6","phantom":"2","samsung":"2.1","electron":"1.1"},"es6.typed.int8-array":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.typed.uint8-array":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.typed.uint8-clamped-array":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.typed.int16-array":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.typed.uint16-array":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.typed.int32-array":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.typed.uint32-array":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.typed.float32-array":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.typed.float64-array":{"chrome":"51","edge":"13","firefox":"48","safari":"10","node":"6.5","ios":"10","samsung":"5","opera":"38","electron":"1.2"},"es6.weak-map":{"chrome":"51","edge":"15","firefox":"53","safari":"9","node":"6.5","ios":"9","samsung":"5","opera":"38","electron":"1.2"},"es6.weak-set":{"chrome":"51","edge":"15","firefox":"53","safari":"9","node":"6.5","ios":"9","samsung":"5","opera":"38","electron":"1.2"}};

/***/ }),
/* 307 */,
/* 308 */,
/* 309 */,
/* 310 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var castPath = __webpack_require__(929),
    isArguments = __webpack_require__(460),
    isArray = __webpack_require__(143),
    isIndex = __webpack_require__(160),
    isLength = __webpack_require__(611),
    toKey = __webpack_require__(503);

/**
 * Checks if `path` exists on `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @param {Function} hasFunc The function to check properties.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 */
function hasPath(object, path, hasFunc) {
  path = castPath(path, object);

  var index = -1,
      length = path.length,
      result = false;

  while (++index < length) {
    var key = toKey(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && isLength(length) && isIndex(key, length) &&
    (isArray(object) || isArguments(object));
}

module.exports = hasPath;


/***/ }),
/* 311 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


var _assert = _interopRequireDefault(__webpack_require__(59));

var _emit = __webpack_require__(481);

var _util = __webpack_require__(357);

var _util2 = __webpack_require__(930);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Copyright (c) 2014-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function Entry() {
  _assert["default"].ok(this instanceof Entry);
}

function FunctionEntry(returnLoc) {
  Entry.call(this);
  (0, _util2.getTypes)().assertLiteral(returnLoc);
  this.returnLoc = returnLoc;
}

(0, _util.inherits)(FunctionEntry, Entry);
exports.FunctionEntry = FunctionEntry;

function LoopEntry(breakLoc, continueLoc, label) {
  Entry.call(this);
  var t = (0, _util2.getTypes)();
  t.assertLiteral(breakLoc);
  t.assertLiteral(continueLoc);

  if (label) {
    t.assertIdentifier(label);
  } else {
    label = null;
  }

  this.breakLoc = breakLoc;
  this.continueLoc = continueLoc;
  this.label = label;
}

(0, _util.inherits)(LoopEntry, Entry);
exports.LoopEntry = LoopEntry;

function SwitchEntry(breakLoc) {
  Entry.call(this);
  (0, _util2.getTypes)().assertLiteral(breakLoc);
  this.breakLoc = breakLoc;
}

(0, _util.inherits)(SwitchEntry, Entry);
exports.SwitchEntry = SwitchEntry;

function TryEntry(firstLoc, catchEntry, finallyEntry) {
  Entry.call(this);
  var t = (0, _util2.getTypes)();
  t.assertLiteral(firstLoc);

  if (catchEntry) {
    _assert["default"].ok(catchEntry instanceof CatchEntry);
  } else {
    catchEntry = null;
  }

  if (finallyEntry) {
    _assert["default"].ok(finallyEntry instanceof FinallyEntry);
  } else {
    finallyEntry = null;
  } // Have to have one or the other (or both).


  _assert["default"].ok(catchEntry || finallyEntry);

  this.firstLoc = firstLoc;
  this.catchEntry = catchEntry;
  this.finallyEntry = finallyEntry;
}

(0, _util.inherits)(TryEntry, Entry);
exports.TryEntry = TryEntry;

function CatchEntry(firstLoc, paramId) {
  Entry.call(this);
  var t = (0, _util2.getTypes)();
  t.assertLiteral(firstLoc);
  t.assertIdentifier(paramId);
  this.firstLoc = firstLoc;
  this.paramId = paramId;
}

(0, _util.inherits)(CatchEntry, Entry);
exports.CatchEntry = CatchEntry;

function FinallyEntry(firstLoc, afterLoc) {
  Entry.call(this);
  var t = (0, _util2.getTypes)();
  t.assertLiteral(firstLoc);
  t.assertLiteral(afterLoc);
  this.firstLoc = firstLoc;
  this.afterLoc = afterLoc;
}

(0, _util.inherits)(FinallyEntry, Entry);
exports.FinallyEntry = FinallyEntry;

function LabeledEntry(breakLoc, label) {
  Entry.call(this);
  var t = (0, _util2.getTypes)();
  t.assertLiteral(breakLoc);
  t.assertIdentifier(label);
  this.breakLoc = breakLoc;
  this.label = label;
}

(0, _util.inherits)(LabeledEntry, Entry);
exports.LabeledEntry = LabeledEntry;

function LeapManager(emitter) {
  _assert["default"].ok(this instanceof LeapManager);

  _assert["default"].ok(emitter instanceof _emit.Emitter);

  this.emitter = emitter;
  this.entryStack = [new FunctionEntry(emitter.finalLoc)];
}

var LMp = LeapManager.prototype;
exports.LeapManager = LeapManager;

LMp.withEntry = function (entry, callback) {
  _assert["default"].ok(entry instanceof Entry);

  this.entryStack.push(entry);

  try {
    callback.call(this.emitter);
  } finally {
    var popped = this.entryStack.pop();

    _assert["default"].strictEqual(popped, entry);
  }
};

LMp._findLeapLocation = function (property, label) {
  for (var i = this.entryStack.length - 1; i >= 0; --i) {
    var entry = this.entryStack[i];
    var loc = entry[property];

    if (loc) {
      if (label) {
        if (entry.label && entry.label.name === label.name) {
          return loc;
        }
      } else if (entry instanceof LabeledEntry) {// Ignore LabeledEntry entries unless we are actually breaking to
        // a label.
      } else {
        return loc;
      }
    }
  }

  return null;
};

LMp.getBreakLoc = function (label) {
  return this._findLeapLocation("breakLoc", label);
};

LMp.getContinueLoc = function (label) {
  return this._findLeapLocation("continueLoc", label);
};

/***/ }),
/* 312 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = {
  "syntax-async-generators": __webpack_require__(25),
  "syntax-dynamic-import": __webpack_require__(201),
  "syntax-json-strings": __webpack_require__(468),
  "syntax-object-rest-spread": __webpack_require__(490),
  "syntax-optional-catch-binding": __webpack_require__(75),
  "syntax-top-level-await": __webpack_require__(497),
  "transform-async-to-generator": __webpack_require__(456),
  "proposal-async-generator-functions": __webpack_require__(345),
  "proposal-dynamic-import": __webpack_require__(643),
  "proposal-json-strings": __webpack_require__(640),
  "transform-arrow-functions": __webpack_require__(970),
  "transform-block-scoped-functions": __webpack_require__(544),
  "transform-block-scoping": __webpack_require__(621),
  "transform-classes": __webpack_require__(462),
  "transform-computed-properties": __webpack_require__(559),
  "transform-destructuring": __webpack_require__(881),
  "transform-dotall-regex": __webpack_require__(992),
  "transform-duplicate-keys": __webpack_require__(510),
  "transform-for-of": __webpack_require__(982),
  "transform-function-name": __webpack_require__(163),
  "transform-literals": __webpack_require__(55),
  "transform-member-expression-literals": __webpack_require__(350),
  "transform-modules-amd": __webpack_require__(523),
  "transform-modules-commonjs": __webpack_require__(227),
  "transform-modules-systemjs": __webpack_require__(959),
  "transform-modules-umd": __webpack_require__(668),
  "transform-named-capturing-groups-regex": __webpack_require__(536),
  "transform-object-super": __webpack_require__(706),
  "transform-parameters": __webpack_require__(901),
  "transform-property-literals": __webpack_require__(511),
  "transform-reserved-words": __webpack_require__(446),
  "transform-shorthand-properties": __webpack_require__(856),
  "transform-spread": __webpack_require__(892),
  "transform-sticky-regex": __webpack_require__(50),
  "transform-template-literals": __webpack_require__(366),
  "transform-typeof-symbol": __webpack_require__(472),
  "transform-unicode-regex": __webpack_require__(202),
  "transform-exponentiation-operator": __webpack_require__(198),
  "transform-new-target": __webpack_require__(628),
  "proposal-object-rest-spread": __webpack_require__(23),
  "proposal-optional-catch-binding": __webpack_require__(282),
  "transform-regenerator": __webpack_require__(431),
  "proposal-unicode-property-regex": __webpack_require__(300)
};
exports.default = _default;

/***/ }),
/* 313 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = prependToMemberExpression;

var _generated = __webpack_require__(405);

function prependToMemberExpression(member, prepend) {
  member.object = (0, _generated.memberExpression)(prepend, member.object);
  return member;
}

/***/ }),
/* 314 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = stringTemplate;

var _options = __webpack_require__(653);

var _parse = _interopRequireDefault(__webpack_require__(601));

var _populate = _interopRequireDefault(__webpack_require__(392));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function stringTemplate(formatter, code, opts) {
  code = formatter.code(code);
  let metadata;
  return arg => {
    const replacements = (0, _options.normalizeReplacements)(arg);
    if (!metadata) metadata = (0, _parse.default)(formatter, code, opts);
    return formatter.unwrap((0, _populate.default)(metadata, replacements));
  };
}

/***/ }),
/* 315 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = inheritInnerComments;

var _inherit = _interopRequireDefault(__webpack_require__(723));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function inheritInnerComments(child, parent) {
  (0, _inherit.default)("innerComments", child, parent);
}

/***/ }),
/* 316 */,
/* 317 */,
/* 318 */
/***/ (function(module, __unusedexports, __webpack_require__) {

// Re-export lib/utils, so that consumers can import
// babel-plugin-dynamic-import-node/utils instead of
// babel-plugin-dynamic-import-node/lib/utils

// eslint-disable-next-line import/no-unresolved
module.exports = __webpack_require__(545);


/***/ }),
/* 319 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseIsNative = __webpack_require__(248),
    getValue = __webpack_require__(879);

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

module.exports = getNative;


/***/ }),
/* 320 */,
/* 321 */,
/* 322 */,
/* 323 */,
/* 324 */,
/* 325 */,
/* 326 */,
/* 327 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._params = _params;
exports._parameters = _parameters;
exports._param = _param;
exports._methodHead = _methodHead;
exports._predicate = _predicate;
exports._functionHead = _functionHead;
exports.FunctionDeclaration = exports.FunctionExpression = FunctionExpression;
exports.ArrowFunctionExpression = ArrowFunctionExpression;

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _params(node) {
  this.print(node.typeParameters, node);
  this.token("(");

  this._parameters(node.params, node);

  this.token(")");
  this.print(node.returnType, node);
}

function _parameters(parameters, parent) {
  for (let i = 0; i < parameters.length; i++) {
    this._param(parameters[i], parent);

    if (i < parameters.length - 1) {
      this.token(",");
      this.space();
    }
  }
}

function _param(parameter, parent) {
  this.printJoin(parameter.decorators, parameter);
  this.print(parameter, parent);
  if (parameter.optional) this.token("?");
  this.print(parameter.typeAnnotation, parameter);
}

function _methodHead(node) {
  const kind = node.kind;
  const key = node.key;

  if (kind === "get" || kind === "set") {
    this.word(kind);
    this.space();
  }

  if (node.async) {
    this.word("async");
    this.space();
  }

  if (kind === "method" || kind === "init") {
    if (node.generator) {
      this.token("*");
    }
  }

  if (node.computed) {
    this.token("[");
    this.print(key, node);
    this.token("]");
  } else {
    this.print(key, node);
  }

  if (node.optional) {
    this.token("?");
  }

  this._params(node);
}

function _predicate(node) {
  if (node.predicate) {
    if (!node.returnType) {
      this.token(":");
    }

    this.space();
    this.print(node.predicate, node);
  }
}

function _functionHead(node) {
  if (node.async) {
    this.word("async");
    this.space();
  }

  this.word("function");
  if (node.generator) this.token("*");
  this.space();

  if (node.id) {
    this.print(node.id, node);
  }

  this._params(node);

  this._predicate(node);
}

function FunctionExpression(node) {
  this._functionHead(node);

  this.space();
  this.print(node.body, node);
}

function ArrowFunctionExpression(node) {
  if (node.async) {
    this.word("async");
    this.space();
  }

  const firstParam = node.params[0];

  if (node.params.length === 1 && t.isIdentifier(firstParam) && !hasTypes(node, firstParam)) {
    if (this.format.retainLines && node.loc && node.body.loc && node.loc.start.line < node.body.loc.start.line) {
      this.token("(");

      if (firstParam.loc && firstParam.loc.start.line > node.loc.start.line) {
        this.indent();
        this.print(firstParam, node);
        this.dedent();

        this._catchUp("start", node.body.loc);
      } else {
        this.print(firstParam, node);
      }

      this.token(")");
    } else {
      this.print(firstParam, node);
    }
  } else {
    this._params(node);
  }

  this._predicate(node);

  this.space();
  this.token("=>");
  this.space();
  this.print(node.body, node);
}

function hasTypes(node, param) {
  return node.typeParameters || node.returnType || param.typeAnnotation || param.optional || param.trailingComments;
}

/***/ }),
/* 328 */,
/* 329 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = clone;

var _cloneNode = _interopRequireDefault(__webpack_require__(533));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function clone(node) {
  return (0, _cloneNode.default)(node, false);
}

/***/ }),
/* 330 */,
/* 331 */,
/* 332 */,
/* 333 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFileSync = transformFileSync;
exports.transformFileAsync = transformFileAsync;
exports.transformFile = void 0;

function _fs() {
  const data = _interopRequireDefault(__webpack_require__(747));

  _fs = function () {
    return data;
  };

  return data;
}

var _config = _interopRequireDefault(__webpack_require__(520));

var _transformation = __webpack_require__(367);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

({});

const transformFile = function transformFile(filename, opts, callback) {
  let options;

  if (typeof opts === "function") {
    callback = opts;
    opts = undefined;
  }

  if (opts == null) {
    options = {
      filename
    };
  } else if (opts && typeof opts === "object") {
    options = Object.assign({}, opts, {
      filename
    });
  }

  process.nextTick(() => {
    let cfg;

    try {
      cfg = (0, _config.default)(options);
      if (cfg === null) return callback(null, null);
    } catch (err) {
      return callback(err);
    }

    const config = cfg;

    _fs().default.readFile(filename, "utf8", function (err, code) {
      if (err) return callback(err, null);
      (0, _transformation.runAsync)(config, code, null, callback);
    });
  });
};

exports.transformFile = transformFile;

function transformFileSync(filename, opts) {
  let options;

  if (opts == null) {
    options = {
      filename
    };
  } else if (opts && typeof opts === "object") {
    options = Object.assign({}, opts, {
      filename
    });
  }

  const config = (0, _config.default)(options);
  if (config === null) return null;
  return (0, _transformation.runSync)(config, _fs().default.readFileSync(filename, "utf8"));
}

function transformFileAsync(filename, opts) {
  return new Promise((res, rej) => {
    transformFile(filename, opts, (err, result) => {
      if (err == null) res(result);else rej(err);
    });
  });
}

/***/ }),
/* 334 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var Symbol = __webpack_require__(498);

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * Creates a clone of the `symbol` object.
 *
 * @private
 * @param {Object} symbol The symbol object to clone.
 * @returns {Object} Returns the cloned symbol object.
 */
function cloneSymbol(symbol) {
  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
}

module.exports = cloneSymbol;


/***/ }),
/* 335 */
/***/ (function(module, exports, __webpack_require__) {

/* module decorator */ module = __webpack_require__.nmd(module);
/*!
 * regjsgen 0.5.1
 * Copyright 2014-2019 Benjamin Tan <https://bnjmnt4n.now.sh/>
 * Available under MIT license <https://github.com/bnjmnt4n/regjsgen/blob/master/LICENSE>
 */
;(function() {
  'use strict';

  // Used to determine if values are of the language type `Object`.
  var objectTypes = {
    'function': true,
    'object': true
  };

  // Used as a reference to the global object.
  var root = (objectTypes[typeof window] && window) || this;

  // Detect free variable `exports`.
  var freeExports = objectTypes[typeof exports] && exports && !exports.nodeType && exports;

  // Detect free variable `module`.
  var hasFreeModule = objectTypes["object"] && module && !module.nodeType;

  // Detect free variable `global` from Node.js or Browserified code and use it as `root`.
  var freeGlobal = freeExports && hasFreeModule && typeof global == 'object' && global;
  if (freeGlobal && (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal)) {
    root = freeGlobal;
  }

  // Used to check objects for own properties.
  var hasOwnProperty = Object.prototype.hasOwnProperty;

  /*--------------------------------------------------------------------------*/

  // Generates a string based on the given code point.
  // Based on https://mths.be/fromcodepoint by @mathias.
  function fromCodePoint() {
    var codePoint = Number(arguments[0]);

    if (
      !isFinite(codePoint) || // `NaN`, `+Infinity`, or `-Infinity`
      codePoint < 0 || // not a valid Unicode code point
      codePoint > 0x10FFFF || // not a valid Unicode code point
      Math.floor(codePoint) != codePoint // not an integer
    ) {
      throw RangeError('Invalid code point: ' + codePoint);
    }

    if (codePoint <= 0xFFFF) {
      // BMP code point
      return String.fromCharCode(codePoint);
    } else {
      // Astral code point; split in surrogate halves
      // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
      codePoint -= 0x10000;
      var highSurrogate = (codePoint >> 10) + 0xD800;
      var lowSurrogate = (codePoint % 0x400) + 0xDC00;
      return String.fromCharCode(highSurrogate, lowSurrogate);
    }
  }

  /*--------------------------------------------------------------------------*/

  // Ensures that nodes have the correct types.
  var assertTypeRegexMap = {};
  function assertType(type, expected) {
    if (expected.indexOf('|') == -1) {
      if (type == expected) {
        return;
      }

      throw Error('Invalid node type: ' + type + '; expected type: ' + expected);
    }

    expected = hasOwnProperty.call(assertTypeRegexMap, expected)
      ? assertTypeRegexMap[expected]
      : (assertTypeRegexMap[expected] = RegExp('^(?:' + expected + ')$'));

    if (expected.test(type)) {
      return;
    }

    throw Error('Invalid node type: ' + type + '; expected types: ' + expected);
  }

  /*--------------------------------------------------------------------------*/

  // Generates a regular expression string based on an AST.
  function generate(node) {
    var type = node.type;

    if (hasOwnProperty.call(generators, type)) {
      return generators[type](node);
    }

    throw Error('Invalid node type: ' + type);
  }

  /*--------------------------------------------------------------------------*/

  function generateAlternative(node) {
    assertType(node.type, 'alternative');

    var terms = node.body,
        i = -1,
        length = terms.length,
        result = '';

    while (++i < length) {
      result += generateTerm(terms[i]);
    }

    return result;
  }

  function generateAnchor(node) {
    assertType(node.type, 'anchor');

    switch (node.kind) {
      case 'start':
        return '^';
      case 'end':
        return '$';
      case 'boundary':
        return '\\b';
      case 'not-boundary':
        return '\\B';
      default:
        throw Error('Invalid assertion');
    }
  }

  function generateAtom(node) {
    assertType(node.type, 'anchor|characterClass|characterClassEscape|dot|group|reference|value');

    return generate(node);
  }

  function generateCharacterClass(node) {
    assertType(node.type, 'characterClass');

    var classRanges = node.body,
        i = -1,
        length = classRanges.length,
        result = '';

    if (node.negative) {
      result += '^';
    }

    while (++i < length) {
      result += generateClassAtom(classRanges[i]);
    }

    return '[' + result + ']';
  }

  function generateCharacterClassEscape(node) {
    assertType(node.type, 'characterClassEscape');

    return '\\' + node.value;
  }

  function generateUnicodePropertyEscape(node) {
    assertType(node.type, 'unicodePropertyEscape');

    return '\\' + (node.negative ? 'P' : 'p') + '{' + node.value + '}';
  }

  function generateCharacterClassRange(node) {
    assertType(node.type, 'characterClassRange');

    var min = node.min,
        max = node.max;

    if (min.type == 'characterClassRange' || max.type == 'characterClassRange') {
      throw Error('Invalid character class range');
    }

    return generateClassAtom(min) + '-' + generateClassAtom(max);
  }

  function generateClassAtom(node) {
    assertType(node.type, 'anchor|characterClassEscape|characterClassRange|dot|value');

    return generate(node);
  }

  function generateDisjunction(node) {
    assertType(node.type, 'disjunction');

    var body = node.body,
        i = -1,
        length = body.length,
        result = '';

    while (++i < length) {
      if (i != 0) {
        result += '|';
      }
      result += generate(body[i]);
    }

    return result;
  }

  function generateDot(node) {
    assertType(node.type, 'dot');

    return '.';
  }

  function generateGroup(node) {
    assertType(node.type, 'group');

    var result = '';

    switch (node.behavior) {
      case 'normal':
        if (node.name) {
          result += '?<' + generateIdentifier(node.name) + '>';
        }
        break;
      case 'ignore':
        result += '?:';
        break;
      case 'lookahead':
        result += '?=';
        break;
      case 'negativeLookahead':
        result += '?!';
        break;
      case 'lookbehind':
        result += '?<=';
        break;
      case 'negativeLookbehind':
        result += '?<!';
        break;
      default:
        throw Error('Invalid behaviour: ' + node.behaviour);
    }

    var body = node.body,
        i = -1,
        length = body.length;

    while (++i < length) {
      result += generate(body[i]);
    }

    return '(' + result + ')';
  }

  function generateIdentifier(node) {
    assertType(node.type, 'identifier');

    return node.value;
  }

  function generateQuantifier(node) {
    assertType(node.type, 'quantifier');

    var quantifier = '',
        min = node.min,
        max = node.max;

    if (max == null) {
      if (min == 0) {
        quantifier = '*';
      } else if (min == 1) {
        quantifier = '+';
      } else {
        quantifier = '{' + min + ',}';
      }
    } else if (min == max) {
      quantifier = '{' + min + '}';
    } else if (min == 0 && max == 1) {
      quantifier = '?';
    } else {
      quantifier = '{' + min + ',' + max + '}';
    }

    if (!node.greedy) {
      quantifier += '?';
    }

    return generateAtom(node.body[0]) + quantifier;
  }

  function generateReference(node) {
    assertType(node.type, 'reference');

    if (node.matchIndex) {
      return '\\' + node.matchIndex;
    }
    if (node.name) {
      return '\\k<' + generateIdentifier(node.name) + '>';
    }

    throw new Error('Unknown reference type');
  }

  function generateTerm(node) {
    assertType(node.type, 'anchor|characterClass|characterClassEscape|empty|group|quantifier|reference|unicodePropertyEscape|value|dot');

    return generate(node);
  }

  function generateValue(node) {
    assertType(node.type, 'value');

    var kind = node.kind,
        codePoint = node.codePoint;

    if (typeof codePoint != 'number') {
      throw new Error('Invalid code point: ' + codePoint);
    }

    switch (kind) {
      case 'controlLetter':
        return '\\c' + fromCodePoint(codePoint + 64);
      case 'hexadecimalEscape':
        return '\\x' + ('00' + codePoint.toString(16).toUpperCase()).slice(-2);
      case 'identifier':
        return '\\' + fromCodePoint(codePoint);
      case 'null':
        return '\\' + codePoint;
      case 'octal':
        return '\\' + codePoint.toString(8);
      case 'singleEscape':
        switch (codePoint) {
          case 0x0008:
            return '\\b';
          case 0x0009:
            return '\\t';
          case 0x000A:
            return '\\n';
          case 0x000B:
            return '\\v';
          case 0x000C:
            return '\\f';
          case 0x000D:
            return '\\r';
          default:
            throw Error('Invalid code point: ' + codePoint);
        }
      case 'symbol':
        return fromCodePoint(codePoint);
      case 'unicodeEscape':
        return '\\u' + ('0000' + codePoint.toString(16).toUpperCase()).slice(-4);
      case 'unicodeCodePointEscape':
        return '\\u{' + codePoint.toString(16).toUpperCase() + '}';
      default:
        throw Error('Unsupported node kind: ' + kind);
    }
  }

  /*--------------------------------------------------------------------------*/

  // Used to generate strings for each node type.
  var generators = {
    'alternative': generateAlternative,
    'anchor': generateAnchor,
    'characterClass': generateCharacterClass,
    'characterClassEscape': generateCharacterClassEscape,
    'characterClassRange': generateCharacterClassRange,
    'unicodePropertyEscape': generateUnicodePropertyEscape,
    'disjunction': generateDisjunction,
    'dot': generateDot,
    'group': generateGroup,
    'quantifier': generateQuantifier,
    'reference': generateReference,
    'value': generateValue
  };

  /*--------------------------------------------------------------------------*/

  // Export regjsgen.
  var regjsgen = {
    'generate': generate
  };

  // Some AMD build optimizers, like r.js, check for condition patterns like the following:
  if (typeof define == 'function' && typeof define.amd == 'object' && define.amd) {
    // Define as an anonymous module so it can be aliased through path mapping.
    define(function() {
      return regjsgen;
    });

    root.regjsgen = regjsgen;
  }
  // Check for `exports` after `define` in case a build optimizer adds an `exports` object.
  else if (freeExports && hasFreeModule) {
    // Export for CommonJS support.
    freeExports.generate = generate;
  }
  else {
    // Export to the global object.
    root.regjsgen = regjsgen;
  }
}.call(this));


/***/ }),
/* 336 */,
/* 337 */
/***/ (function(module) {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ }),
/* 338 */
/***/ (function(module) {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ }),
/* 339 */
/***/ (function(module) {

module.exports = {"core-js":["es.symbol","es.symbol.description","es.symbol.async-iterator","es.symbol.has-instance","es.symbol.is-concat-spreadable","es.symbol.iterator","es.symbol.match","es.symbol.match-all","es.symbol.replace","es.symbol.search","es.symbol.species","es.symbol.split","es.symbol.to-primitive","es.symbol.to-string-tag","es.symbol.unscopables","es.array.concat","es.array.copy-within","es.array.every","es.array.fill","es.array.filter","es.array.find","es.array.find-index","es.array.flat","es.array.flat-map","es.array.for-each","es.array.from","es.array.includes","es.array.index-of","es.array.is-array","es.array.iterator","es.array.join","es.array.last-index-of","es.array.map","es.array.of","es.array.reduce","es.array.reduce-right","es.array.reverse","es.array.slice","es.array.some","es.array.sort","es.array.species","es.array.splice","es.array.unscopables.flat","es.array.unscopables.flat-map","es.array-buffer.constructor","es.array-buffer.is-view","es.array-buffer.slice","es.data-view","es.date.now","es.date.to-iso-string","es.date.to-json","es.date.to-primitive","es.date.to-string","es.function.bind","es.function.has-instance","es.function.name","es.global-this","es.json.to-string-tag","es.map","es.math.acosh","es.math.asinh","es.math.atanh","es.math.cbrt","es.math.clz32","es.math.cosh","es.math.expm1","es.math.fround","es.math.hypot","es.math.imul","es.math.log10","es.math.log1p","es.math.log2","es.math.sign","es.math.sinh","es.math.tanh","es.math.to-string-tag","es.math.trunc","es.number.constructor","es.number.epsilon","es.number.is-finite","es.number.is-integer","es.number.is-nan","es.number.is-safe-integer","es.number.max-safe-integer","es.number.min-safe-integer","es.number.parse-float","es.number.parse-int","es.number.to-fixed","es.number.to-precision","es.object.assign","es.object.create","es.object.define-getter","es.object.define-properties","es.object.define-property","es.object.define-setter","es.object.entries","es.object.freeze","es.object.from-entries","es.object.get-own-property-descriptor","es.object.get-own-property-descriptors","es.object.get-own-property-names","es.object.get-prototype-of","es.object.is","es.object.is-extensible","es.object.is-frozen","es.object.is-sealed","es.object.keys","es.object.lookup-getter","es.object.lookup-setter","es.object.prevent-extensions","es.object.seal","es.object.set-prototype-of","es.object.to-string","es.object.values","es.parse-float","es.parse-int","es.promise","es.promise.all-settled","es.promise.finally","es.reflect.apply","es.reflect.construct","es.reflect.define-property","es.reflect.delete-property","es.reflect.get","es.reflect.get-own-property-descriptor","es.reflect.get-prototype-of","es.reflect.has","es.reflect.is-extensible","es.reflect.own-keys","es.reflect.prevent-extensions","es.reflect.set","es.reflect.set-prototype-of","es.regexp.constructor","es.regexp.exec","es.regexp.flags","es.regexp.to-string","es.set","es.string.code-point-at","es.string.ends-with","es.string.from-code-point","es.string.includes","es.string.iterator","es.string.match","es.string.match-all","es.string.pad-end","es.string.pad-start","es.string.raw","es.string.repeat","es.string.replace","es.string.search","es.string.split","es.string.starts-with","es.string.trim","es.string.trim-end","es.string.trim-start","es.string.anchor","es.string.big","es.string.blink","es.string.bold","es.string.fixed","es.string.fontcolor","es.string.fontsize","es.string.italics","es.string.link","es.string.small","es.string.strike","es.string.sub","es.string.sup","es.typed-array.float32-array","es.typed-array.float64-array","es.typed-array.int8-array","es.typed-array.int16-array","es.typed-array.int32-array","es.typed-array.uint8-array","es.typed-array.uint8-clamped-array","es.typed-array.uint16-array","es.typed-array.uint32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string","es.weak-map","es.weak-set","esnext.aggregate-error","esnext.array.is-template-object","esnext.array.last-index","esnext.array.last-item","esnext.async-iterator.constructor","esnext.async-iterator.drop","esnext.async-iterator.filter","esnext.async-iterator.from","esnext.async-iterator.map","esnext.async-iterator.take","esnext.async-iterator.to-array","esnext.composite-key","esnext.composite-symbol","esnext.global-this","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","esnext.iterator.drop","esnext.iterator.every","esnext.iterator.filter","esnext.iterator.find","esnext.iterator.for-each","esnext.iterator.from","esnext.iterator.map","esnext.iterator.reduce","esnext.iterator.some","esnext.iterator.take","esnext.iterator.to-array","esnext.map.delete-all","esnext.map.every","esnext.map.filter","esnext.map.find","esnext.map.find-key","esnext.map.from","esnext.map.group-by","esnext.map.includes","esnext.map.key-by","esnext.map.key-of","esnext.map.map-keys","esnext.map.map-values","esnext.map.merge","esnext.map.of","esnext.map.reduce","esnext.map.some","esnext.map.update","esnext.map.update-or-insert","esnext.map.upsert","esnext.math.clamp","esnext.math.deg-per-rad","esnext.math.degrees","esnext.math.fscale","esnext.math.iaddh","esnext.math.imulh","esnext.math.isubh","esnext.math.rad-per-deg","esnext.math.radians","esnext.math.scale","esnext.math.seeded-prng","esnext.math.signbit","esnext.math.umulh","esnext.number.from-string","esnext.observable","esnext.promise.all-settled","esnext.promise.any","esnext.promise.try","esnext.reflect.define-metadata","esnext.reflect.delete-metadata","esnext.reflect.get-metadata","esnext.reflect.get-metadata-keys","esnext.reflect.get-own-metadata","esnext.reflect.get-own-metadata-keys","esnext.reflect.has-metadata","esnext.reflect.has-own-metadata","esnext.reflect.metadata","esnext.set.add-all","esnext.set.delete-all","esnext.set.difference","esnext.set.every","esnext.set.filter","esnext.set.find","esnext.set.from","esnext.set.intersection","esnext.set.is-disjoint-from","esnext.set.is-subset-of","esnext.set.is-superset-of","esnext.set.join","esnext.set.map","esnext.set.of","esnext.set.reduce","esnext.set.some","esnext.set.symmetric-difference","esnext.set.union","esnext.string.at","esnext.string.code-points","esnext.string.match-all","esnext.string.replace-all","esnext.symbol.async-dispose","esnext.symbol.dispose","esnext.symbol.observable","esnext.symbol.pattern-match","esnext.symbol.replace-all","esnext.weak-map.delete-all","esnext.weak-map.from","esnext.weak-map.of","esnext.weak-map.upsert","esnext.weak-set.add-all","esnext.weak-set.delete-all","esnext.weak-set.from","esnext.weak-set.of","web.dom-collections.for-each","web.dom-collections.iterator","web.immediate","web.queue-microtask","web.timers","web.url","web.url.to-json","web.url-search-params"],"core-js/es/array-buffer/constructor":["es.array-buffer.constructor","es.object.to-string"],"core-js/es/array-buffer":["es.array-buffer.constructor","es.array-buffer.is-view","es.array-buffer.slice","es.object.to-string"],"core-js/es/array-buffer/is-view":["es.array-buffer.is-view"],"core-js/es/array-buffer/slice":["es.array-buffer.slice"],"core-js/es/array/concat":["es.array.concat"],"core-js/es/array/copy-within":["es.array.copy-within"],"core-js/es/array/entries":["es.array.iterator"],"core-js/es/array/every":["es.array.every"],"core-js/es/array/fill":["es.array.fill"],"core-js/es/array/filter":["es.array.filter"],"core-js/es/array/find-index":["es.array.find-index"],"core-js/es/array/find":["es.array.find"],"core-js/es/array/flat-map":["es.array.flat-map","es.array.unscopables.flat-map"],"core-js/es/array/flat":["es.array.flat","es.array.unscopables.flat"],"core-js/es/array/for-each":["es.array.for-each"],"core-js/es/array/from":["es.array.from","es.string.iterator"],"core-js/es/array/includes":["es.array.includes"],"core-js/es/array/index-of":["es.array.index-of"],"core-js/es/array":["es.array.concat","es.array.copy-within","es.array.every","es.array.fill","es.array.filter","es.array.find","es.array.find-index","es.array.flat","es.array.flat-map","es.array.for-each","es.array.from","es.array.includes","es.array.index-of","es.array.is-array","es.array.iterator","es.array.join","es.array.last-index-of","es.array.map","es.array.of","es.array.reduce","es.array.reduce-right","es.array.reverse","es.array.slice","es.array.some","es.array.sort","es.array.species","es.array.splice","es.array.unscopables.flat","es.array.unscopables.flat-map","es.string.iterator"],"core-js/es/array/is-array":["es.array.is-array"],"core-js/es/array/iterator":["es.array.iterator"],"core-js/es/array/join":["es.array.join"],"core-js/es/array/keys":["es.array.iterator"],"core-js/es/array/last-index-of":["es.array.last-index-of"],"core-js/es/array/map":["es.array.map"],"core-js/es/array/of":["es.array.of"],"core-js/es/array/reduce-right":["es.array.reduce-right"],"core-js/es/array/reduce":["es.array.reduce"],"core-js/es/array/reverse":["es.array.reverse"],"core-js/es/array/slice":["es.array.slice"],"core-js/es/array/some":["es.array.some"],"core-js/es/array/sort":["es.array.sort"],"core-js/es/array/splice":["es.array.splice"],"core-js/es/array/values":["es.array.iterator"],"core-js/es/array/virtual/concat":["es.array.concat"],"core-js/es/array/virtual/copy-within":["es.array.copy-within"],"core-js/es/array/virtual/entries":["es.array.iterator"],"core-js/es/array/virtual/every":["es.array.every"],"core-js/es/array/virtual/fill":["es.array.fill"],"core-js/es/array/virtual/filter":["es.array.filter"],"core-js/es/array/virtual/find-index":["es.array.find-index"],"core-js/es/array/virtual/find":["es.array.find"],"core-js/es/array/virtual/flat-map":["es.array.flat-map","es.array.unscopables.flat-map"],"core-js/es/array/virtual/flat":["es.array.flat","es.array.unscopables.flat"],"core-js/es/array/virtual/for-each":["es.array.for-each"],"core-js/es/array/virtual/includes":["es.array.includes"],"core-js/es/array/virtual/index-of":["es.array.index-of"],"core-js/es/array/virtual":["es.array.concat","es.array.copy-within","es.array.every","es.array.fill","es.array.filter","es.array.find","es.array.find-index","es.array.flat","es.array.flat-map","es.array.for-each","es.array.includes","es.array.index-of","es.array.iterator","es.array.join","es.array.last-index-of","es.array.map","es.array.reduce","es.array.reduce-right","es.array.reverse","es.array.slice","es.array.some","es.array.sort","es.array.species","es.array.splice","es.array.unscopables.flat","es.array.unscopables.flat-map"],"core-js/es/array/virtual/iterator":["es.array.iterator"],"core-js/es/array/virtual/join":["es.array.join"],"core-js/es/array/virtual/keys":["es.array.iterator"],"core-js/es/array/virtual/last-index-of":["es.array.last-index-of"],"core-js/es/array/virtual/map":["es.array.map"],"core-js/es/array/virtual/reduce-right":["es.array.reduce-right"],"core-js/es/array/virtual/reduce":["es.array.reduce"],"core-js/es/array/virtual/reverse":["es.array.reverse"],"core-js/es/array/virtual/slice":["es.array.slice"],"core-js/es/array/virtual/some":["es.array.some"],"core-js/es/array/virtual/sort":["es.array.sort"],"core-js/es/array/virtual/splice":["es.array.splice"],"core-js/es/array/virtual/values":["es.array.iterator"],"core-js/es/data-view":["es.data-view","es.object.to-string"],"core-js/es/date":["es.date.now","es.date.to-iso-string","es.date.to-json","es.date.to-primitive","es.date.to-string"],"core-js/es/date/now":["es.date.now"],"core-js/es/date/to-iso-string":["es.date.to-iso-string","es.date.to-json"],"core-js/es/date/to-json":["es.date.to-json"],"core-js/es/date/to-primitive":["es.date.to-primitive"],"core-js/es/date/to-string":["es.date.to-string"],"core-js/es/function/bind":["es.function.bind"],"core-js/es/function/has-instance":["es.function.has-instance"],"core-js/es/function":["es.function.bind","es.function.has-instance","es.function.name"],"core-js/es/function/name":["es.function.name"],"core-js/es/function/virtual/bind":["es.function.bind"],"core-js/es/function/virtual":["es.function.bind"],"core-js/es/global-this":["es.global-this"],"core-js/es":["es.symbol","es.symbol.description","es.symbol.async-iterator","es.symbol.has-instance","es.symbol.is-concat-spreadable","es.symbol.iterator","es.symbol.match","es.symbol.match-all","es.symbol.replace","es.symbol.search","es.symbol.species","es.symbol.split","es.symbol.to-primitive","es.symbol.to-string-tag","es.symbol.unscopables","es.array.concat","es.array.copy-within","es.array.every","es.array.fill","es.array.filter","es.array.find","es.array.find-index","es.array.flat","es.array.flat-map","es.array.for-each","es.array.from","es.array.includes","es.array.index-of","es.array.is-array","es.array.iterator","es.array.join","es.array.last-index-of","es.array.map","es.array.of","es.array.reduce","es.array.reduce-right","es.array.reverse","es.array.slice","es.array.some","es.array.sort","es.array.species","es.array.splice","es.array.unscopables.flat","es.array.unscopables.flat-map","es.array-buffer.constructor","es.array-buffer.is-view","es.array-buffer.slice","es.data-view","es.date.now","es.date.to-iso-string","es.date.to-json","es.date.to-primitive","es.date.to-string","es.function.bind","es.function.has-instance","es.function.name","es.global-this","es.json.to-string-tag","es.map","es.math.acosh","es.math.asinh","es.math.atanh","es.math.cbrt","es.math.clz32","es.math.cosh","es.math.expm1","es.math.fround","es.math.hypot","es.math.imul","es.math.log10","es.math.log1p","es.math.log2","es.math.sign","es.math.sinh","es.math.tanh","es.math.to-string-tag","es.math.trunc","es.number.constructor","es.number.epsilon","es.number.is-finite","es.number.is-integer","es.number.is-nan","es.number.is-safe-integer","es.number.max-safe-integer","es.number.min-safe-integer","es.number.parse-float","es.number.parse-int","es.number.to-fixed","es.number.to-precision","es.object.assign","es.object.create","es.object.define-getter","es.object.define-properties","es.object.define-property","es.object.define-setter","es.object.entries","es.object.freeze","es.object.from-entries","es.object.get-own-property-descriptor","es.object.get-own-property-descriptors","es.object.get-own-property-names","es.object.get-prototype-of","es.object.is","es.object.is-extensible","es.object.is-frozen","es.object.is-sealed","es.object.keys","es.object.lookup-getter","es.object.lookup-setter","es.object.prevent-extensions","es.object.seal","es.object.set-prototype-of","es.object.to-string","es.object.values","es.parse-float","es.parse-int","es.promise","es.promise.all-settled","es.promise.finally","es.reflect.apply","es.reflect.construct","es.reflect.define-property","es.reflect.delete-property","es.reflect.get","es.reflect.get-own-property-descriptor","es.reflect.get-prototype-of","es.reflect.has","es.reflect.is-extensible","es.reflect.own-keys","es.reflect.prevent-extensions","es.reflect.set","es.reflect.set-prototype-of","es.regexp.constructor","es.regexp.exec","es.regexp.flags","es.regexp.to-string","es.set","es.string.code-point-at","es.string.ends-with","es.string.from-code-point","es.string.includes","es.string.iterator","es.string.match","es.string.match-all","es.string.pad-end","es.string.pad-start","es.string.raw","es.string.repeat","es.string.replace","es.string.search","es.string.split","es.string.starts-with","es.string.trim","es.string.trim-end","es.string.trim-start","es.string.anchor","es.string.big","es.string.blink","es.string.bold","es.string.fixed","es.string.fontcolor","es.string.fontsize","es.string.italics","es.string.link","es.string.small","es.string.strike","es.string.sub","es.string.sup","es.typed-array.float32-array","es.typed-array.float64-array","es.typed-array.int8-array","es.typed-array.int16-array","es.typed-array.int32-array","es.typed-array.uint8-array","es.typed-array.uint8-clamped-array","es.typed-array.uint16-array","es.typed-array.uint32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string","es.weak-map","es.weak-set"],"core-js/es/instance/bind":["es.function.bind"],"core-js/es/instance/code-point-at":["es.string.code-point-at"],"core-js/es/instance/concat":["es.array.concat"],"core-js/es/instance/copy-within":["es.array.copy-within"],"core-js/es/instance/ends-with":["es.string.ends-with"],"core-js/es/instance/entries":["es.array.iterator"],"core-js/es/instance/every":["es.array.every"],"core-js/es/instance/fill":["es.array.fill"],"core-js/es/instance/filter":["es.array.filter"],"core-js/es/instance/find-index":["es.array.find-index"],"core-js/es/instance/find":["es.array.find"],"core-js/es/instance/flags":["es.regexp.flags"],"core-js/es/instance/flat-map":["es.array.flat-map","es.array.unscopables.flat-map"],"core-js/es/instance/flat":["es.array.flat","es.array.unscopables.flat"],"core-js/es/instance/for-each":["es.array.for-each"],"core-js/es/instance/includes":["es.array.includes","es.string.includes"],"core-js/es/instance/index-of":["es.array.index-of"],"core-js/es/instance/keys":["es.array.iterator"],"core-js/es/instance/last-index-of":["es.array.last-index-of"],"core-js/es/instance/map":["es.array.map"],"core-js/es/instance/match-all":["es.string.match-all"],"core-js/es/instance/pad-end":["es.string.pad-end"],"core-js/es/instance/pad-start":["es.string.pad-start"],"core-js/es/instance/reduce-right":["es.array.reduce-right"],"core-js/es/instance/reduce":["es.array.reduce"],"core-js/es/instance/repeat":["es.string.repeat"],"core-js/es/instance/reverse":["es.array.reverse"],"core-js/es/instance/slice":["es.array.slice"],"core-js/es/instance/some":["es.array.some"],"core-js/es/instance/sort":["es.array.sort"],"core-js/es/instance/splice":["es.array.splice"],"core-js/es/instance/starts-with":["es.string.starts-with"],"core-js/es/instance/trim-end":["es.string.trim-end"],"core-js/es/instance/trim-left":["es.string.trim-start"],"core-js/es/instance/trim-right":["es.string.trim-end"],"core-js/es/instance/trim-start":["es.string.trim-start"],"core-js/es/instance/trim":["es.string.trim"],"core-js/es/instance/values":["es.array.iterator"],"core-js/es/json":["es.json.to-string-tag"],"core-js/es/json/stringify":["es.json.stringify"],"core-js/es/json/to-string-tag":["es.json.to-string-tag"],"core-js/es/map":["es.map","es.object.to-string","es.string.iterator","web.dom-collections.iterator"],"core-js/es/math/acosh":["es.math.acosh"],"core-js/es/math/asinh":["es.math.asinh"],"core-js/es/math/atanh":["es.math.atanh"],"core-js/es/math/cbrt":["es.math.cbrt"],"core-js/es/math/clz32":["es.math.clz32"],"core-js/es/math/cosh":["es.math.cosh"],"core-js/es/math/expm1":["es.math.expm1"],"core-js/es/math/fround":["es.math.fround"],"core-js/es/math/hypot":["es.math.hypot"],"core-js/es/math/imul":["es.math.imul"],"core-js/es/math":["es.math.acosh","es.math.asinh","es.math.atanh","es.math.cbrt","es.math.clz32","es.math.cosh","es.math.expm1","es.math.fround","es.math.hypot","es.math.imul","es.math.log10","es.math.log1p","es.math.log2","es.math.sign","es.math.sinh","es.math.tanh","es.math.to-string-tag","es.math.trunc"],"core-js/es/math/log10":["es.math.log10"],"core-js/es/math/log1p":["es.math.log1p"],"core-js/es/math/log2":["es.math.log2"],"core-js/es/math/sign":["es.math.sign"],"core-js/es/math/sinh":["es.math.sinh"],"core-js/es/math/tanh":["es.math.tanh"],"core-js/es/math/to-string-tag":["es.math.to-string-tag"],"core-js/es/math/trunc":["es.math.trunc"],"core-js/es/number/constructor":["es.number.constructor"],"core-js/es/number/epsilon":["es.number.epsilon"],"core-js/es/number":["es.number.constructor","es.number.epsilon","es.number.is-finite","es.number.is-integer","es.number.is-nan","es.number.is-safe-integer","es.number.max-safe-integer","es.number.min-safe-integer","es.number.parse-float","es.number.parse-int","es.number.to-fixed","es.number.to-precision"],"core-js/es/number/is-finite":["es.number.is-finite"],"core-js/es/number/is-integer":["es.number.is-integer"],"core-js/es/number/is-nan":["es.number.is-nan"],"core-js/es/number/is-safe-integer":["es.number.is-safe-integer"],"core-js/es/number/max-safe-integer":["es.number.max-safe-integer"],"core-js/es/number/min-safe-integer":["es.number.min-safe-integer"],"core-js/es/number/parse-float":["es.number.parse-float"],"core-js/es/number/parse-int":["es.number.parse-int"],"core-js/es/number/to-fixed":["es.number.to-fixed"],"core-js/es/number/to-precision":["es.number.to-precision"],"core-js/es/number/virtual":["es.number.to-fixed","es.number.to-precision"],"core-js/es/number/virtual/to-fixed":["es.number.to-fixed"],"core-js/es/number/virtual/to-precision":["es.number.to-precision"],"core-js/es/object/assign":["es.object.assign"],"core-js/es/object/create":["es.object.create"],"core-js/es/object/define-getter":["es.object.define-getter"],"core-js/es/object/define-properties":["es.object.define-properties"],"core-js/es/object/define-property":["es.object.define-property"],"core-js/es/object/define-setter":["es.object.define-setter"],"core-js/es/object/entries":["es.object.entries"],"core-js/es/object/freeze":["es.object.freeze"],"core-js/es/object/from-entries":["es.array.iterator","es.object.from-entries"],"core-js/es/object/get-own-property-descriptor":["es.object.get-own-property-descriptor"],"core-js/es/object/get-own-property-descriptors":["es.object.get-own-property-descriptors"],"core-js/es/object/get-own-property-names":["es.object.get-own-property-names"],"core-js/es/object/get-own-property-symbols":["es.symbol"],"core-js/es/object/get-prototype-of":["es.object.get-prototype-of"],"core-js/es/object":["es.symbol","es.json.to-string-tag","es.math.to-string-tag","es.object.assign","es.object.create","es.object.define-getter","es.object.define-properties","es.object.define-property","es.object.define-setter","es.object.entries","es.object.freeze","es.object.from-entries","es.object.get-own-property-descriptor","es.object.get-own-property-descriptors","es.object.get-own-property-names","es.object.get-prototype-of","es.object.is","es.object.is-extensible","es.object.is-frozen","es.object.is-sealed","es.object.keys","es.object.lookup-getter","es.object.lookup-setter","es.object.prevent-extensions","es.object.seal","es.object.set-prototype-of","es.object.to-string","es.object.values"],"core-js/es/object/is-extensible":["es.object.is-extensible"],"core-js/es/object/is-frozen":["es.object.is-frozen"],"core-js/es/object/is-sealed":["es.object.is-sealed"],"core-js/es/object/is":["es.object.is"],"core-js/es/object/keys":["es.object.keys"],"core-js/es/object/lookup-getter":["es.object.lookup-setter"],"core-js/es/object/lookup-setter":["es.object.lookup-setter"],"core-js/es/object/prevent-extensions":["es.object.prevent-extensions"],"core-js/es/object/seal":["es.object.seal"],"core-js/es/object/set-prototype-of":["es.object.set-prototype-of"],"core-js/es/object/to-string":["es.json.to-string-tag","es.math.to-string-tag","es.object.to-string"],"core-js/es/object/values":["es.object.values"],"core-js/es/parse-float":["es.parse-float"],"core-js/es/parse-int":["es.parse-int"],"core-js/es/promise/all-settled":["es.promise","es.promise.all-settled"],"core-js/es/promise/finally":["es.promise","es.promise.finally"],"core-js/es/promise":["es.object.to-string","es.promise","es.promise.all-settled","es.promise.finally","es.string.iterator","web.dom-collections.iterator"],"core-js/es/reflect/apply":["es.reflect.apply"],"core-js/es/reflect/construct":["es.reflect.construct"],"core-js/es/reflect/define-property":["es.reflect.define-property"],"core-js/es/reflect/delete-property":["es.reflect.delete-property"],"core-js/es/reflect/get-own-property-descriptor":["es.reflect.get-own-property-descriptor"],"core-js/es/reflect/get-prototype-of":["es.reflect.get-prototype-of"],"core-js/es/reflect/get":["es.reflect.get"],"core-js/es/reflect/has":["es.reflect.has"],"core-js/es/reflect":["es.reflect.apply","es.reflect.construct","es.reflect.define-property","es.reflect.delete-property","es.reflect.get","es.reflect.get-own-property-descriptor","es.reflect.get-prototype-of","es.reflect.has","es.reflect.is-extensible","es.reflect.own-keys","es.reflect.prevent-extensions","es.reflect.set","es.reflect.set-prototype-of"],"core-js/es/reflect/is-extensible":["es.reflect.is-extensible"],"core-js/es/reflect/own-keys":["es.reflect.own-keys"],"core-js/es/reflect/prevent-extensions":["es.reflect.prevent-extensions"],"core-js/es/reflect/set-prototype-of":["es.reflect.set-prototype-of"],"core-js/es/reflect/set":["es.reflect.set"],"core-js/es/regexp/constructor":["es.regexp.constructor"],"core-js/es/regexp/flags":["es.regexp.flags"],"core-js/es/regexp":["es.regexp.constructor","es.regexp.exec","es.regexp.flags","es.regexp.to-string","es.string.match","es.string.replace","es.string.search","es.string.split"],"core-js/es/regexp/match":["es.string.match"],"core-js/es/regexp/replace":["es.string.replace"],"core-js/es/regexp/search":["es.string.search"],"core-js/es/regexp/split":["es.string.split"],"core-js/es/regexp/to-string":["es.regexp.to-string"],"core-js/es/set":["es.object.to-string","es.set","es.string.iterator","web.dom-collections.iterator"],"core-js/es/string/anchor":["es.string.anchor"],"core-js/es/string/big":["es.string.big"],"core-js/es/string/blink":["es.string.blink"],"core-js/es/string/bold":["es.string.bold"],"core-js/es/string/code-point-at":["es.string.code-point-at"],"core-js/es/string/ends-with":["es.string.ends-with"],"core-js/es/string/fixed":["es.string.fixed"],"core-js/es/string/fontcolor":["es.string.fontcolor"],"core-js/es/string/fontsize":["es.string.fontsize"],"core-js/es/string/from-code-point":["es.string.from-code-point"],"core-js/es/string/includes":["es.string.includes"],"core-js/es/string":["es.string.code-point-at","es.string.ends-with","es.string.from-code-point","es.string.includes","es.string.iterator","es.string.match","es.string.match-all","es.string.pad-end","es.string.pad-start","es.string.raw","es.string.repeat","es.string.replace","es.string.search","es.string.split","es.string.starts-with","es.string.trim","es.string.trim-end","es.string.trim-start","es.string.anchor","es.string.big","es.string.blink","es.string.bold","es.string.fixed","es.string.fontcolor","es.string.fontsize","es.string.italics","es.string.link","es.string.small","es.string.strike","es.string.sub","es.string.sup"],"core-js/es/string/italics":["es.string.italics"],"core-js/es/string/iterator":["es.string.iterator"],"core-js/es/string/link":["es.string.link"],"core-js/es/string/match-all":["es.string.match-all"],"core-js/es/string/match":["es.string.match"],"core-js/es/string/pad-end":["es.string.pad-end"],"core-js/es/string/pad-start":["es.string.pad-start"],"core-js/es/string/raw":["es.string.raw"],"core-js/es/string/repeat":["es.string.repeat"],"core-js/es/string/replace":["es.string.replace"],"core-js/es/string/search":["es.string.search"],"core-js/es/string/small":["es.string.small"],"core-js/es/string/split":["es.string.split"],"core-js/es/string/starts-with":["es.string.starts-with"],"core-js/es/string/strike":["es.string.strike"],"core-js/es/string/sub":["es.string.sub"],"core-js/es/string/sup":["es.string.sup"],"core-js/es/string/trim-end":["es.string.trim-end"],"core-js/es/string/trim-left":["es.string.trim-start"],"core-js/es/string/trim-right":["es.string.trim-end"],"core-js/es/string/trim-start":["es.string.trim-start"],"core-js/es/string/trim":["es.string.trim"],"core-js/es/string/virtual/anchor":["es.string.anchor"],"core-js/es/string/virtual/big":["es.string.big"],"core-js/es/string/virtual/blink":["es.string.blink"],"core-js/es/string/virtual/bold":["es.string.bold"],"core-js/es/string/virtual/code-point-at":["es.string.code-point-at"],"core-js/es/string/virtual/ends-with":["es.string.ends-with"],"core-js/es/string/virtual/fixed":["es.string.fixed"],"core-js/es/string/virtual/fontcolor":["es.string.fontcolor"],"core-js/es/string/virtual/fontsize":["es.string.fontsize"],"core-js/es/string/virtual/includes":["es.string.includes"],"core-js/es/string/virtual":["es.string.code-point-at","es.string.ends-with","es.string.includes","es.string.iterator","es.string.match","es.string.match-all","es.string.pad-end","es.string.pad-start","es.string.repeat","es.string.replace","es.string.search","es.string.split","es.string.starts-with","es.string.trim","es.string.trim-end","es.string.trim-start","es.string.anchor","es.string.big","es.string.blink","es.string.bold","es.string.fixed","es.string.fontcolor","es.string.fontsize","es.string.italics","es.string.link","es.string.small","es.string.strike","es.string.sub","es.string.sup"],"core-js/es/string/virtual/italics":["es.string.italics"],"core-js/es/string/virtual/iterator":["es.string.iterator"],"core-js/es/string/virtual/link":["es.string.link"],"core-js/es/string/virtual/match-all":["es.string.match-all"],"core-js/es/string/virtual/pad-end":["es.string.pad-end"],"core-js/es/string/virtual/pad-start":["es.string.pad-start"],"core-js/es/string/virtual/repeat":["es.string.repeat"],"core-js/es/string/virtual/small":["es.string.small"],"core-js/es/string/virtual/starts-with":["es.string.starts-with"],"core-js/es/string/virtual/strike":["es.string.strike"],"core-js/es/string/virtual/sub":["es.string.sub"],"core-js/es/string/virtual/sup":["es.string.sup"],"core-js/es/string/virtual/trim-end":["es.string.trim-end"],"core-js/es/string/virtual/trim-left":["es.string.trim-start"],"core-js/es/string/virtual/trim-right":["es.string.trim-end"],"core-js/es/string/virtual/trim-start":["es.string.trim-start"],"core-js/es/string/virtual/trim":["es.string.trim"],"core-js/es/symbol/async-iterator":["es.symbol.async-iterator"],"core-js/es/symbol/description":["es.symbol.description"],"core-js/es/symbol/for":["es.symbol"],"core-js/es/symbol/has-instance":["es.symbol.has-instance","es.function.has-instance"],"core-js/es/symbol":["es.symbol","es.symbol.description","es.symbol.async-iterator","es.symbol.has-instance","es.symbol.is-concat-spreadable","es.symbol.iterator","es.symbol.match","es.symbol.match-all","es.symbol.replace","es.symbol.search","es.symbol.species","es.symbol.split","es.symbol.to-primitive","es.symbol.to-string-tag","es.symbol.unscopables","es.array.concat","es.json.to-string-tag","es.math.to-string-tag","es.object.to-string"],"core-js/es/symbol/is-concat-spreadable":["es.symbol.is-concat-spreadable","es.array.concat"],"core-js/es/symbol/iterator":["es.symbol.iterator","es.string.iterator","web.dom-collections.iterator"],"core-js/es/symbol/key-for":["es.symbol"],"core-js/es/symbol/match-all":["es.symbol.match-all","es.string.match-all"],"core-js/es/symbol/match":["es.symbol.match","es.string.match"],"core-js/es/symbol/replace":["es.symbol.replace","es.string.replace"],"core-js/es/symbol/search":["es.symbol.search","es.string.search"],"core-js/es/symbol/species":["es.symbol.species"],"core-js/es/symbol/split":["es.symbol.split","es.string.split"],"core-js/es/symbol/to-primitive":["es.symbol.to-primitive"],"core-js/es/symbol/to-string-tag":["es.symbol.to-string-tag","es.json.to-string-tag","es.math.to-string-tag","es.object.to-string"],"core-js/es/symbol/unscopables":["es.symbol.unscopables"],"core-js/es/typed-array/copy-within":["es.typed-array.copy-within"],"core-js/es/typed-array/entries":["es.typed-array.iterator"],"core-js/es/typed-array/every":["es.typed-array.every"],"core-js/es/typed-array/fill":["es.typed-array.fill"],"core-js/es/typed-array/filter":["es.typed-array.filter"],"core-js/es/typed-array/find-index":["es.typed-array.find-index"],"core-js/es/typed-array/find":["es.typed-array.find"],"core-js/es/typed-array/float32-array":["es.object.to-string","es.typed-array.float32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/float64-array":["es.object.to-string","es.typed-array.float64-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/for-each":["es.typed-array.for-each"],"core-js/es/typed-array/from":["es.typed-array.from"],"core-js/es/typed-array/includes":["es.typed-array.includes"],"core-js/es/typed-array/index-of":["es.typed-array.index-of"],"core-js/es/typed-array":["es.object.to-string","es.typed-array.float32-array","es.typed-array.float64-array","es.typed-array.int8-array","es.typed-array.int16-array","es.typed-array.int32-array","es.typed-array.uint8-array","es.typed-array.uint8-clamped-array","es.typed-array.uint16-array","es.typed-array.uint32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/int16-array":["es.object.to-string","es.typed-array.int16-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/int32-array":["es.object.to-string","es.typed-array.int32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/int8-array":["es.object.to-string","es.typed-array.int8-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/iterator":["es.typed-array.iterator"],"core-js/es/typed-array/join":["es.typed-array.join"],"core-js/es/typed-array/keys":["es.typed-array.iterator"],"core-js/es/typed-array/last-index-of":["es.typed-array.last-index-of"],"core-js/es/typed-array/map":["es.typed-array.map"],"core-js/es/typed-array/methods":["es.object.to-string","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/of":["es.typed-array.of"],"core-js/es/typed-array/reduce-right":["es.typed-array.reduce-right"],"core-js/es/typed-array/reduce":["es.typed-array.reduce"],"core-js/es/typed-array/reverse":["es.typed-array.reverse"],"core-js/es/typed-array/set":["es.typed-array.set"],"core-js/es/typed-array/slice":["es.typed-array.slice"],"core-js/es/typed-array/some":["es.typed-array.some"],"core-js/es/typed-array/sort":["es.typed-array.sort"],"core-js/es/typed-array/subarray":["es.typed-array.subarray"],"core-js/es/typed-array/to-locale-string":["es.typed-array.to-locale-string"],"core-js/es/typed-array/to-string":["es.typed-array.to-string"],"core-js/es/typed-array/uint16-array":["es.object.to-string","es.typed-array.uint16-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/uint32-array":["es.object.to-string","es.typed-array.uint32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/uint8-array":["es.object.to-string","es.typed-array.uint8-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/uint8-clamped-array":["es.object.to-string","es.typed-array.uint8-clamped-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/es/typed-array/values":["es.typed-array.iterator"],"core-js/es/weak-map":["es.object.to-string","es.weak-map","web.dom-collections.iterator"],"core-js/es/weak-set":["es.object.to-string","es.weak-set","web.dom-collections.iterator"],"core-js/features/aggregate-error":["es.string.iterator","esnext.aggregate-error","web.dom-collections.iterator"],"core-js/features/array-buffer/constructor":["es.array-buffer.constructor","es.object.to-string"],"core-js/features/array-buffer":["es.array-buffer.constructor","es.array-buffer.is-view","es.array-buffer.slice","es.object.to-string"],"core-js/features/array-buffer/is-view":["es.array-buffer.is-view"],"core-js/features/array-buffer/slice":["es.array-buffer.slice"],"core-js/features/array/concat":["es.array.concat"],"core-js/features/array/copy-within":["es.array.copy-within"],"core-js/features/array/entries":["es.array.iterator"],"core-js/features/array/every":["es.array.every"],"core-js/features/array/fill":["es.array.fill"],"core-js/features/array/filter":["es.array.filter"],"core-js/features/array/find-index":["es.array.find-index"],"core-js/features/array/find":["es.array.find"],"core-js/features/array/flat-map":["es.array.flat-map","es.array.unscopables.flat-map"],"core-js/features/array/flat":["es.array.flat","es.array.unscopables.flat"],"core-js/features/array/for-each":["es.array.for-each"],"core-js/features/array/from":["es.array.from","es.string.iterator"],"core-js/features/array/includes":["es.array.includes"],"core-js/features/array/index-of":["es.array.index-of"],"core-js/features/array":["es.array.concat","es.array.copy-within","es.array.every","es.array.fill","es.array.filter","es.array.find","es.array.find-index","es.array.flat","es.array.flat-map","es.array.for-each","es.array.from","es.array.includes","es.array.index-of","es.array.is-array","es.array.iterator","es.array.join","es.array.last-index-of","es.array.map","es.array.of","es.array.reduce","es.array.reduce-right","es.array.reverse","es.array.slice","es.array.some","es.array.sort","es.array.species","es.array.splice","es.array.unscopables.flat","es.array.unscopables.flat-map","es.string.iterator","esnext.array.is-template-object","esnext.array.last-index","esnext.array.last-item"],"core-js/features/array/is-array":["es.array.is-array"],"core-js/features/array/is-template-object":["esnext.array.is-template-object"],"core-js/features/array/iterator":["es.array.iterator"],"core-js/features/array/join":["es.array.join"],"core-js/features/array/keys":["es.array.iterator"],"core-js/features/array/last-index-of":["es.array.last-index-of"],"core-js/features/array/last-index":["esnext.array.last-index"],"core-js/features/array/last-item":["esnext.array.last-item"],"core-js/features/array/map":["es.array.map"],"core-js/features/array/of":["es.array.of"],"core-js/features/array/reduce-right":["es.array.reduce-right"],"core-js/features/array/reduce":["es.array.reduce"],"core-js/features/array/reverse":["es.array.reverse"],"core-js/features/array/slice":["es.array.slice"],"core-js/features/array/some":["es.array.some"],"core-js/features/array/sort":["es.array.sort"],"core-js/features/array/splice":["es.array.splice"],"core-js/features/array/values":["es.array.iterator"],"core-js/features/array/virtual/concat":["es.array.concat"],"core-js/features/array/virtual/copy-within":["es.array.copy-within"],"core-js/features/array/virtual/entries":["es.array.iterator"],"core-js/features/array/virtual/every":["es.array.every"],"core-js/features/array/virtual/fill":["es.array.fill"],"core-js/features/array/virtual/filter":["es.array.filter"],"core-js/features/array/virtual/find-index":["es.array.find-index"],"core-js/features/array/virtual/find":["es.array.find"],"core-js/features/array/virtual/flat-map":["es.array.flat-map","es.array.unscopables.flat-map"],"core-js/features/array/virtual/flat":["es.array.flat","es.array.unscopables.flat"],"core-js/features/array/virtual/for-each":["es.array.for-each"],"core-js/features/array/virtual/includes":["es.array.includes"],"core-js/features/array/virtual/index-of":["es.array.index-of"],"core-js/features/array/virtual":["es.array.concat","es.array.copy-within","es.array.every","es.array.fill","es.array.filter","es.array.find","es.array.find-index","es.array.flat","es.array.flat-map","es.array.for-each","es.array.includes","es.array.index-of","es.array.iterator","es.array.join","es.array.last-index-of","es.array.map","es.array.reduce","es.array.reduce-right","es.array.reverse","es.array.slice","es.array.some","es.array.sort","es.array.species","es.array.splice","es.array.unscopables.flat","es.array.unscopables.flat-map"],"core-js/features/array/virtual/iterator":["es.array.iterator"],"core-js/features/array/virtual/join":["es.array.join"],"core-js/features/array/virtual/keys":["es.array.iterator"],"core-js/features/array/virtual/last-index-of":["es.array.last-index-of"],"core-js/features/array/virtual/map":["es.array.map"],"core-js/features/array/virtual/reduce-right":["es.array.reduce-right"],"core-js/features/array/virtual/reduce":["es.array.reduce"],"core-js/features/array/virtual/reverse":["es.array.reverse"],"core-js/features/array/virtual/slice":["es.array.slice"],"core-js/features/array/virtual/some":["es.array.some"],"core-js/features/array/virtual/sort":["es.array.sort"],"core-js/features/array/virtual/splice":["es.array.splice"],"core-js/features/array/virtual/values":["es.array.iterator"],"core-js/features/async-iterator/as-indexed-pairs":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.as-indexed-pairs","web.dom-collections.iterator"],"core-js/features/async-iterator/drop":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.drop","web.dom-collections.iterator"],"core-js/features/async-iterator/every":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.every","web.dom-collections.iterator"],"core-js/features/async-iterator/filter":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.filter","web.dom-collections.iterator"],"core-js/features/async-iterator/find":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.find","web.dom-collections.iterator"],"core-js/features/async-iterator/flat-map":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.flat-map","web.dom-collections.iterator"],"core-js/features/async-iterator/for-each":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.for-each","web.dom-collections.iterator"],"core-js/features/async-iterator/from":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.from","web.dom-collections.iterator"],"core-js/features/async-iterator":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.as-indexed-pairs","esnext.async-iterator.drop","esnext.async-iterator.every","esnext.async-iterator.filter","esnext.async-iterator.find","esnext.async-iterator.flat-map","esnext.async-iterator.for-each","esnext.async-iterator.from","esnext.async-iterator.map","esnext.async-iterator.reduce","esnext.async-iterator.some","esnext.async-iterator.take","esnext.async-iterator.to-array","web.dom-collections.iterator"],"core-js/features/async-iterator/map":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.map","web.dom-collections.iterator"],"core-js/features/async-iterator/reduce":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.reduce","web.dom-collections.iterator"],"core-js/features/async-iterator/some":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.some","web.dom-collections.iterator"],"core-js/features/async-iterator/take":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.take","web.dom-collections.iterator"],"core-js/features/async-iterator/to-array":["es.object.to-string","es.promise","es.string.iterator","esnext.async-iterator.constructor","esnext.async-iterator.to-array","web.dom-collections.iterator"],"core-js/features/clear-immediate":["web.immediate"],"core-js/features/composite-key":["esnext.composite-key"],"core-js/features/composite-symbol":["es.symbol","esnext.composite-symbol"],"core-js/features/data-view":["es.data-view","es.object.to-string"],"core-js/features/date":["es.date.now","es.date.to-iso-string","es.date.to-json","es.date.to-primitive","es.date.to-string"],"core-js/features/date/now":["es.date.now"],"core-js/features/date/to-iso-string":["es.date.to-iso-string","es.date.to-json"],"core-js/features/date/to-json":["es.date.to-json"],"core-js/features/date/to-primitive":["es.date.to-primitive"],"core-js/features/date/to-string":["es.date.to-string"],"core-js/features/dom-collections/for-each":["web.dom-collections.for-each"],"core-js/features/dom-collections":["es.array.iterator","web.dom-collections.for-each","web.dom-collections.iterator"],"core-js/features/dom-collections/iterator":["web.dom-collections.iterator"],"core-js/features/function/bind":["es.function.bind"],"core-js/features/function/has-instance":["es.function.has-instance"],"core-js/features/function":["es.function.bind","es.function.has-instance","es.function.name"],"core-js/features/function/name":["es.function.name"],"core-js/features/function/virtual/bind":["es.function.bind"],"core-js/features/function/virtual":["es.function.bind"],"core-js/features/get-iterator-method":["es.string.iterator","web.dom-collections.iterator"],"core-js/features/get-iterator":["es.string.iterator","web.dom-collections.iterator"],"core-js/features/global-this":["es.global-this","esnext.global-this"],"core-js/features":["es.symbol","es.symbol.description","es.symbol.async-iterator","es.symbol.has-instance","es.symbol.is-concat-spreadable","es.symbol.iterator","es.symbol.match","es.symbol.match-all","es.symbol.replace","es.symbol.search","es.symbol.species","es.symbol.split","es.symbol.to-primitive","es.symbol.to-string-tag","es.symbol.unscopables","es.array.concat","es.array.copy-within","es.array.every","es.array.fill","es.array.filter","es.array.find","es.array.find-index","es.array.flat","es.array.flat-map","es.array.for-each","es.array.from","es.array.includes","es.array.index-of","es.array.is-array","es.array.iterator","es.array.join","es.array.last-index-of","es.array.map","es.array.of","es.array.reduce","es.array.reduce-right","es.array.reverse","es.array.slice","es.array.some","es.array.sort","es.array.species","es.array.splice","es.array.unscopables.flat","es.array.unscopables.flat-map","es.array-buffer.constructor","es.array-buffer.is-view","es.array-buffer.slice","es.data-view","es.date.now","es.date.to-iso-string","es.date.to-json","es.date.to-primitive","es.date.to-string","es.function.bind","es.function.has-instance","es.function.name","es.global-this","es.json.to-string-tag","es.map","es.math.acosh","es.math.asinh","es.math.atanh","es.math.cbrt","es.math.clz32","es.math.cosh","es.math.expm1","es.math.fround","es.math.hypot","es.math.imul","es.math.log10","es.math.log1p","es.math.log2","es.math.sign","es.math.sinh","es.math.tanh","es.math.to-string-tag","es.math.trunc","es.number.constructor","es.number.epsilon","es.number.is-finite","es.number.is-integer","es.number.is-nan","es.number.is-safe-integer","es.number.max-safe-integer","es.number.min-safe-integer","es.number.parse-float","es.number.parse-int","es.number.to-fixed","es.number.to-precision","es.object.assign","es.object.create","es.object.define-getter","es.object.define-properties","es.object.define-property","es.object.define-setter","es.object.entries","es.object.freeze","es.object.from-entries","es.object.get-own-property-descriptor","es.object.get-own-property-descriptors","es.object.get-own-property-names","es.object.get-prototype-of","es.object.is","es.object.is-extensible","es.object.is-frozen","es.object.is-sealed","es.object.keys","es.object.lookup-getter","es.object.lookup-setter","es.object.prevent-extensions","es.object.seal","es.object.set-prototype-of","es.object.to-string","es.object.values","es.parse-float","es.parse-int","es.promise","es.promise.all-settled","es.promise.finally","es.reflect.apply","es.reflect.construct","es.reflect.define-property","es.reflect.delete-property","es.reflect.get","es.reflect.get-own-property-descriptor","es.reflect.get-prototype-of","es.reflect.has","es.reflect.is-extensible","es.reflect.own-keys","es.reflect.prevent-extensions","es.reflect.set","es.reflect.set-prototype-of","es.regexp.constructor","es.regexp.exec","es.regexp.flags","es.regexp.to-string","es.set","es.string.code-point-at","es.string.ends-with","es.string.from-code-point","es.string.includes","es.string.iterator","es.string.match","es.string.match-all","es.string.pad-end","es.string.pad-start","es.string.raw","es.string.repeat","es.string.replace","es.string.search","es.string.split","es.string.starts-with","es.string.trim","es.string.trim-end","es.string.trim-start","es.string.anchor","es.string.big","es.string.blink","es.string.bold","es.string.fixed","es.string.fontcolor","es.string.fontsize","es.string.italics","es.string.link","es.string.small","es.string.strike","es.string.sub","es.string.sup","es.typed-array.float32-array","es.typed-array.float64-array","es.typed-array.int8-array","es.typed-array.int16-array","es.typed-array.int32-array","es.typed-array.uint8-array","es.typed-array.uint8-clamped-array","es.typed-array.uint16-array","es.typed-array.uint32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string","es.weak-map","es.weak-set","esnext.aggregate-error","esnext.array.is-template-object","esnext.array.last-index","esnext.array.last-item","esnext.async-iterator.constructor","esnext.async-iterator.drop","esnext.async-iterator.filter","esnext.async-iterator.from","esnext.async-iterator.map","esnext.async-iterator.take","esnext.async-iterator.to-array","esnext.composite-key","esnext.composite-symbol","esnext.global-this","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","esnext.iterator.drop","esnext.iterator.every","esnext.iterator.filter","esnext.iterator.find","esnext.iterator.for-each","esnext.iterator.from","esnext.iterator.map","esnext.iterator.reduce","esnext.iterator.some","esnext.iterator.take","esnext.iterator.to-array","esnext.map.delete-all","esnext.map.every","esnext.map.filter","esnext.map.find","esnext.map.find-key","esnext.map.from","esnext.map.group-by","esnext.map.includes","esnext.map.key-by","esnext.map.key-of","esnext.map.map-keys","esnext.map.map-values","esnext.map.merge","esnext.map.of","esnext.map.reduce","esnext.map.some","esnext.map.update","esnext.map.update-or-insert","esnext.map.upsert","esnext.math.clamp","esnext.math.deg-per-rad","esnext.math.degrees","esnext.math.fscale","esnext.math.iaddh","esnext.math.imulh","esnext.math.isubh","esnext.math.rad-per-deg","esnext.math.radians","esnext.math.scale","esnext.math.seeded-prng","esnext.math.signbit","esnext.math.umulh","esnext.number.from-string","esnext.observable","esnext.promise.all-settled","esnext.promise.any","esnext.promise.try","esnext.reflect.define-metadata","esnext.reflect.delete-metadata","esnext.reflect.get-metadata","esnext.reflect.get-metadata-keys","esnext.reflect.get-own-metadata","esnext.reflect.get-own-metadata-keys","esnext.reflect.has-metadata","esnext.reflect.has-own-metadata","esnext.reflect.metadata","esnext.set.add-all","esnext.set.delete-all","esnext.set.difference","esnext.set.every","esnext.set.filter","esnext.set.find","esnext.set.from","esnext.set.intersection","esnext.set.is-disjoint-from","esnext.set.is-subset-of","esnext.set.is-superset-of","esnext.set.join","esnext.set.map","esnext.set.of","esnext.set.reduce","esnext.set.some","esnext.set.symmetric-difference","esnext.set.union","esnext.string.at","esnext.string.code-points","esnext.string.match-all","esnext.string.replace-all","esnext.symbol.async-dispose","esnext.symbol.dispose","esnext.symbol.observable","esnext.symbol.pattern-match","esnext.symbol.replace-all","esnext.weak-map.delete-all","esnext.weak-map.from","esnext.weak-map.of","esnext.weak-map.upsert","esnext.weak-set.add-all","esnext.weak-set.delete-all","esnext.weak-set.from","esnext.weak-set.of","web.dom-collections.for-each","web.dom-collections.iterator","web.immediate","web.queue-microtask","web.timers","web.url","web.url.to-json","web.url-search-params"],"core-js/features/instance/at":["esnext.string.at"],"core-js/features/instance/bind":["es.function.bind"],"core-js/features/instance/code-point-at":["es.string.code-point-at"],"core-js/features/instance/code-points":["esnext.string.code-points"],"core-js/features/instance/concat":["es.array.concat"],"core-js/features/instance/copy-within":["es.array.copy-within"],"core-js/features/instance/ends-with":["es.string.ends-with"],"core-js/features/instance/entries":["es.array.iterator","web.dom-collections.iterator"],"core-js/features/instance/every":["es.array.every"],"core-js/features/instance/fill":["es.array.fill"],"core-js/features/instance/filter":["es.array.filter"],"core-js/features/instance/find-index":["es.array.find-index"],"core-js/features/instance/find":["es.array.find"],"core-js/features/instance/flags":["es.regexp.flags"],"core-js/features/instance/flat-map":["es.array.flat-map","es.array.unscopables.flat-map"],"core-js/features/instance/flat":["es.array.flat","es.array.unscopables.flat"],"core-js/features/instance/for-each":["es.array.for-each","web.dom-collections.iterator"],"core-js/features/instance/includes":["es.array.includes","es.string.includes"],"core-js/features/instance/index-of":["es.array.index-of"],"core-js/features/instance/keys":["es.array.iterator","web.dom-collections.iterator"],"core-js/features/instance/last-index-of":["es.array.last-index-of"],"core-js/features/instance/map":["es.array.map"],"core-js/features/instance/match-all":["es.string.match-all"],"core-js/features/instance/pad-end":["es.string.pad-end"],"core-js/features/instance/pad-start":["es.string.pad-start"],"core-js/features/instance/reduce-right":["es.array.reduce-right"],"core-js/features/instance/reduce":["es.array.reduce"],"core-js/features/instance/repeat":["es.string.repeat"],"core-js/features/instance/replace-all":["esnext.string.replace-all"],"core-js/features/instance/reverse":["es.array.reverse"],"core-js/features/instance/slice":["es.array.slice"],"core-js/features/instance/some":["es.array.some"],"core-js/features/instance/sort":["es.array.sort"],"core-js/features/instance/splice":["es.array.splice"],"core-js/features/instance/starts-with":["es.string.starts-with"],"core-js/features/instance/trim-end":["es.string.trim-end"],"core-js/features/instance/trim-left":["es.string.trim-start"],"core-js/features/instance/trim-right":["es.string.trim-end"],"core-js/features/instance/trim-start":["es.string.trim-start"],"core-js/features/instance/trim":["es.string.trim"],"core-js/features/instance/values":["es.array.iterator","web.dom-collections.iterator"],"core-js/features/is-iterable":["es.string.iterator","web.dom-collections.iterator"],"core-js/features/iterator/as-indexed-pairs":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","web.dom-collections.iterator"],"core-js/features/iterator/drop":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.drop","web.dom-collections.iterator"],"core-js/features/iterator/every":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.every","web.dom-collections.iterator"],"core-js/features/iterator/filter":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.filter","web.dom-collections.iterator"],"core-js/features/iterator/find":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.find","web.dom-collections.iterator"],"core-js/features/iterator/flat-map":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.flat-map","web.dom-collections.iterator"],"core-js/features/iterator/for-each":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.for-each","web.dom-collections.iterator"],"core-js/features/iterator/from":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.from","web.dom-collections.iterator"],"core-js/features/iterator":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","esnext.iterator.drop","esnext.iterator.every","esnext.iterator.filter","esnext.iterator.find","esnext.iterator.flat-map","esnext.iterator.for-each","esnext.iterator.from","esnext.iterator.map","esnext.iterator.reduce","esnext.iterator.some","esnext.iterator.take","esnext.iterator.to-array","web.dom-collections.iterator"],"core-js/features/iterator/map":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.map","web.dom-collections.iterator"],"core-js/features/iterator/reduce":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.reduce","web.dom-collections.iterator"],"core-js/features/iterator/some":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.some","web.dom-collections.iterator"],"core-js/features/iterator/take":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.take","web.dom-collections.iterator"],"core-js/features/iterator/to-array":["es.object.to-string","es.string.iterator","esnext.iterator.constructor","esnext.iterator.to-array","web.dom-collections.iterator"],"core-js/features/json":["es.json.to-string-tag"],"core-js/features/json/stringify":["es.json.stringify"],"core-js/features/json/to-string-tag":["es.json.to-string-tag"],"core-js/features/map/delete-all":["es.map","esnext.map.delete-all"],"core-js/features/map/every":["es.map","esnext.map.every"],"core-js/features/map/filter":["es.map","esnext.map.filter"],"core-js/features/map/find-key":["es.map","esnext.map.find-key"],"core-js/features/map/find":["es.map","esnext.map.find"],"core-js/features/map/from":["es.map","es.string.iterator","esnext.map.from","web.dom-collections.iterator"],"core-js/features/map/group-by":["es.map","esnext.map.group-by"],"core-js/features/map/includes":["es.map","esnext.map.includes"],"core-js/features/map":["es.map","es.object.to-string","es.string.iterator","esnext.map.delete-all","esnext.map.every","esnext.map.filter","esnext.map.find","esnext.map.find-key","esnext.map.from","esnext.map.group-by","esnext.map.includes","esnext.map.key-by","esnext.map.key-of","esnext.map.map-keys","esnext.map.map-values","esnext.map.merge","esnext.map.of","esnext.map.reduce","esnext.map.some","esnext.map.update","esnext.map.update-or-insert","esnext.map.upsert","web.dom-collections.iterator"],"core-js/features/map/key-by":["es.map","esnext.map.key-by"],"core-js/features/map/key-of":["es.map","esnext.map.key-of"],"core-js/features/map/map-keys":["es.map","esnext.map.map-keys"],"core-js/features/map/map-values":["es.map","esnext.map.map-values"],"core-js/features/map/merge":["es.map","esnext.map.merge"],"core-js/features/map/of":["es.map","es.string.iterator","esnext.map.of","web.dom-collections.iterator"],"core-js/features/map/reduce":["es.map","esnext.map.reduce"],"core-js/features/map/some":["es.map","esnext.map.some"],"core-js/features/map/update-or-insert":["es.map","esnext.map.update-or-insert"],"core-js/features/map/update":["es.map","esnext.map.update"],"core-js/features/map/upsert":["es.map","esnext.map.upsert"],"core-js/features/math/acosh":["es.math.acosh"],"core-js/features/math/asinh":["es.math.asinh"],"core-js/features/math/atanh":["es.math.atanh"],"core-js/features/math/cbrt":["es.math.cbrt"],"core-js/features/math/clamp":["esnext.math.clamp"],"core-js/features/math/clz32":["es.math.clz32"],"core-js/features/math/cosh":["es.math.cosh"],"core-js/features/math/deg-per-rad":["esnext.math.deg-per-rad"],"core-js/features/math/degrees":["esnext.math.degrees"],"core-js/features/math/expm1":["es.math.expm1"],"core-js/features/math/fround":["es.math.fround"],"core-js/features/math/fscale":["esnext.math.fscale"],"core-js/features/math/hypot":["es.math.hypot"],"core-js/features/math/iaddh":["esnext.math.iaddh"],"core-js/features/math/imul":["es.math.imul"],"core-js/features/math/imulh":["esnext.math.imulh"],"core-js/features/math":["es.math.acosh","es.math.asinh","es.math.atanh","es.math.cbrt","es.math.clz32","es.math.cosh","es.math.expm1","es.math.fround","es.math.hypot","es.math.imul","es.math.log10","es.math.log1p","es.math.log2","es.math.sign","es.math.sinh","es.math.tanh","es.math.to-string-tag","es.math.trunc","esnext.math.clamp","esnext.math.deg-per-rad","esnext.math.degrees","esnext.math.fscale","esnext.math.iaddh","esnext.math.imulh","esnext.math.isubh","esnext.math.rad-per-deg","esnext.math.radians","esnext.math.scale","esnext.math.seeded-prng","esnext.math.signbit","esnext.math.umulh"],"core-js/features/math/isubh":["esnext.math.isubh"],"core-js/features/math/log10":["es.math.log10"],"core-js/features/math/log1p":["es.math.log1p"],"core-js/features/math/log2":["es.math.log2"],"core-js/features/math/rad-per-deg":["esnext.math.rad-per-deg"],"core-js/features/math/radians":["esnext.math.radians"],"core-js/features/math/scale":["esnext.math.scale"],"core-js/features/math/seeded-prng":["esnext.math.seeded-prng"],"core-js/features/math/sign":["es.math.sign"],"core-js/features/math/signbit":["esnext.math.signbit"],"core-js/features/math/sinh":["es.math.sinh"],"core-js/features/math/tanh":["es.math.tanh"],"core-js/features/math/to-string-tag":["es.math.to-string-tag"],"core-js/features/math/trunc":["es.math.trunc"],"core-js/features/math/umulh":["esnext.math.umulh"],"core-js/features/number/constructor":["es.number.constructor"],"core-js/features/number/epsilon":["es.number.epsilon"],"core-js/features/number/from-string":["esnext.number.from-string"],"core-js/features/number":["es.number.constructor","es.number.epsilon","es.number.is-finite","es.number.is-integer","es.number.is-nan","es.number.is-safe-integer","es.number.max-safe-integer","es.number.min-safe-integer","es.number.parse-float","es.number.parse-int","es.number.to-fixed","es.number.to-precision","esnext.number.from-string"],"core-js/features/number/is-finite":["es.number.is-finite"],"core-js/features/number/is-integer":["es.number.is-integer"],"core-js/features/number/is-nan":["es.number.is-nan"],"core-js/features/number/is-safe-integer":["es.number.is-safe-integer"],"core-js/features/number/max-safe-integer":["es.number.max-safe-integer"],"core-js/features/number/min-safe-integer":["es.number.min-safe-integer"],"core-js/features/number/parse-float":["es.number.parse-float"],"core-js/features/number/parse-int":["es.number.parse-int"],"core-js/features/number/to-fixed":["es.number.to-fixed"],"core-js/features/number/to-precision":["es.number.to-precision"],"core-js/features/number/virtual":["es.number.to-fixed","es.number.to-precision"],"core-js/features/number/virtual/to-fixed":["es.number.to-fixed"],"core-js/features/number/virtual/to-precision":["es.number.to-precision"],"core-js/features/object/assign":["es.object.assign"],"core-js/features/object/create":["es.object.create"],"core-js/features/object/define-getter":["es.object.define-getter"],"core-js/features/object/define-properties":["es.object.define-properties"],"core-js/features/object/define-property":["es.object.define-property"],"core-js/features/object/define-setter":["es.object.define-setter"],"core-js/features/object/entries":["es.object.entries"],"core-js/features/object/freeze":["es.object.freeze"],"core-js/features/object/from-entries":["es.array.iterator","es.object.from-entries"],"core-js/features/object/get-own-property-descriptor":["es.object.get-own-property-descriptor"],"core-js/features/object/get-own-property-descriptors":["es.object.get-own-property-descriptors"],"core-js/features/object/get-own-property-names":["es.object.get-own-property-names"],"core-js/features/object/get-own-property-symbols":["es.symbol"],"core-js/features/object/get-prototype-of":["es.object.get-prototype-of"],"core-js/features/object":["es.symbol","es.json.to-string-tag","es.math.to-string-tag","es.object.assign","es.object.create","es.object.define-getter","es.object.define-properties","es.object.define-property","es.object.define-setter","es.object.entries","es.object.freeze","es.object.from-entries","es.object.get-own-property-descriptor","es.object.get-own-property-descriptors","es.object.get-own-property-names","es.object.get-prototype-of","es.object.is","es.object.is-extensible","es.object.is-frozen","es.object.is-sealed","es.object.keys","es.object.lookup-getter","es.object.lookup-setter","es.object.prevent-extensions","es.object.seal","es.object.set-prototype-of","es.object.to-string","es.object.values"],"core-js/features/object/is-extensible":["es.object.is-extensible"],"core-js/features/object/is-frozen":["es.object.is-frozen"],"core-js/features/object/is-sealed":["es.object.is-sealed"],"core-js/features/object/is":["es.object.is"],"core-js/features/object/keys":["es.object.keys"],"core-js/features/object/lookup-getter":["es.object.lookup-setter"],"core-js/features/object/lookup-setter":["es.object.lookup-setter"],"core-js/features/object/prevent-extensions":["es.object.prevent-extensions"],"core-js/features/object/seal":["es.object.seal"],"core-js/features/object/set-prototype-of":["es.object.set-prototype-of"],"core-js/features/object/to-string":["es.json.to-string-tag","es.math.to-string-tag","es.object.to-string"],"core-js/features/object/values":["es.object.values"],"core-js/features/observable":["es.object.to-string","es.string.iterator","esnext.observable","esnext.symbol.observable","web.dom-collections.iterator"],"core-js/features/parse-float":["es.parse-float"],"core-js/features/parse-int":["es.parse-int"],"core-js/features/promise/all-settled":["es.promise","es.promise.all-settled","esnext.promise.all-settled"],"core-js/features/promise/any":["es.promise","esnext.aggregate-error","esnext.promise.any"],"core-js/features/promise/finally":["es.promise","es.promise.finally"],"core-js/features/promise":["es.object.to-string","es.promise","es.promise.all-settled","es.promise.finally","es.string.iterator","esnext.aggregate-error","esnext.promise.all-settled","esnext.promise.any","esnext.promise.try","web.dom-collections.iterator"],"core-js/features/promise/try":["es.promise","esnext.promise.try"],"core-js/features/queue-microtask":["web.queue-microtask"],"core-js/features/reflect/apply":["es.reflect.apply"],"core-js/features/reflect/construct":["es.reflect.construct"],"core-js/features/reflect/define-metadata":["esnext.reflect.define-metadata"],"core-js/features/reflect/define-property":["es.reflect.define-property"],"core-js/features/reflect/delete-metadata":["esnext.reflect.delete-metadata"],"core-js/features/reflect/delete-property":["es.reflect.delete-property"],"core-js/features/reflect/get-metadata-keys":["esnext.reflect.get-metadata-keys"],"core-js/features/reflect/get-metadata":["esnext.reflect.get-metadata"],"core-js/features/reflect/get-own-metadata-keys":["esnext.reflect.get-own-metadata-keys"],"core-js/features/reflect/get-own-metadata":["esnext.reflect.get-own-metadata"],"core-js/features/reflect/get-own-property-descriptor":["es.reflect.get-own-property-descriptor"],"core-js/features/reflect/get-prototype-of":["es.reflect.get-prototype-of"],"core-js/features/reflect/get":["es.reflect.get"],"core-js/features/reflect/has-metadata":["esnext.reflect.has-metadata"],"core-js/features/reflect/has-own-metadata":["esnext.reflect.has-own-metadata"],"core-js/features/reflect/has":["es.reflect.has"],"core-js/features/reflect":["es.reflect.apply","es.reflect.construct","es.reflect.define-property","es.reflect.delete-property","es.reflect.get","es.reflect.get-own-property-descriptor","es.reflect.get-prototype-of","es.reflect.has","es.reflect.is-extensible","es.reflect.own-keys","es.reflect.prevent-extensions","es.reflect.set","es.reflect.set-prototype-of","esnext.reflect.define-metadata","esnext.reflect.delete-metadata","esnext.reflect.get-metadata","esnext.reflect.get-metadata-keys","esnext.reflect.get-own-metadata","esnext.reflect.get-own-metadata-keys","esnext.reflect.has-metadata","esnext.reflect.has-own-metadata","esnext.reflect.metadata"],"core-js/features/reflect/is-extensible":["es.reflect.is-extensible"],"core-js/features/reflect/metadata":["esnext.reflect.metadata"],"core-js/features/reflect/own-keys":["es.reflect.own-keys"],"core-js/features/reflect/prevent-extensions":["es.reflect.prevent-extensions"],"core-js/features/reflect/set-prototype-of":["es.reflect.set-prototype-of"],"core-js/features/reflect/set":["es.reflect.set"],"core-js/features/regexp/constructor":["es.regexp.constructor"],"core-js/features/regexp/flags":["es.regexp.flags"],"core-js/features/regexp":["es.regexp.constructor","es.regexp.exec","es.regexp.flags","es.regexp.to-string","es.string.match","es.string.replace","es.string.search","es.string.split"],"core-js/features/regexp/match":["es.string.match"],"core-js/features/regexp/replace":["es.string.replace"],"core-js/features/regexp/search":["es.string.search"],"core-js/features/regexp/split":["es.string.split"],"core-js/features/regexp/to-string":["es.regexp.to-string"],"core-js/features/set-immediate":["web.immediate"],"core-js/features/set-interval":["web.timers"],"core-js/features/set-timeout":["web.timers"],"core-js/features/set/add-all":["es.set","esnext.set.add-all"],"core-js/features/set/delete-all":["es.set","esnext.set.delete-all"],"core-js/features/set/difference":["es.set","es.string.iterator","esnext.set.difference","web.dom-collections.iterator"],"core-js/features/set/every":["es.set","esnext.set.every"],"core-js/features/set/filter":["es.set","esnext.set.filter"],"core-js/features/set/find":["es.set","esnext.set.find"],"core-js/features/set/from":["es.set","es.string.iterator","esnext.set.from","web.dom-collections.iterator"],"core-js/features/set":["es.object.to-string","es.set","es.string.iterator","esnext.set.add-all","esnext.set.delete-all","esnext.set.difference","esnext.set.every","esnext.set.filter","esnext.set.find","esnext.set.from","esnext.set.intersection","esnext.set.is-disjoint-from","esnext.set.is-subset-of","esnext.set.is-superset-of","esnext.set.join","esnext.set.map","esnext.set.of","esnext.set.reduce","esnext.set.some","esnext.set.symmetric-difference","esnext.set.union","web.dom-collections.iterator"],"core-js/features/set/intersection":["es.set","esnext.set.intersection"],"core-js/features/set/is-disjoint-from":["es.set","esnext.set.is-disjoint-from"],"core-js/features/set/is-subset-of":["es.set","es.string.iterator","esnext.set.is-subset-of","web.dom-collections.iterator"],"core-js/features/set/is-superset-of":["es.set","esnext.set.is-superset-of"],"core-js/features/set/join":["es.set","esnext.set.join"],"core-js/features/set/map":["es.set","esnext.set.map"],"core-js/features/set/of":["es.set","es.string.iterator","esnext.set.of","web.dom-collections.iterator"],"core-js/features/set/reduce":["es.set","esnext.set.reduce"],"core-js/features/set/some":["es.set","esnext.set.some"],"core-js/features/set/symmetric-difference":["es.set","es.string.iterator","esnext.set.symmetric-difference","web.dom-collections.iterator"],"core-js/features/set/union":["es.set","es.string.iterator","esnext.set.union","web.dom-collections.iterator"],"core-js/features/string/anchor":["es.string.anchor"],"core-js/features/string/at":["esnext.string.at"],"core-js/features/string/big":["es.string.big"],"core-js/features/string/blink":["es.string.blink"],"core-js/features/string/bold":["es.string.bold"],"core-js/features/string/code-point-at":["es.string.code-point-at"],"core-js/features/string/code-points":["esnext.string.code-points"],"core-js/features/string/ends-with":["es.string.ends-with"],"core-js/features/string/fixed":["es.string.fixed"],"core-js/features/string/fontcolor":["es.string.fontcolor"],"core-js/features/string/fontsize":["es.string.fontsize"],"core-js/features/string/from-code-point":["es.string.from-code-point"],"core-js/features/string/includes":["es.string.includes"],"core-js/features/string":["es.string.code-point-at","es.string.ends-with","es.string.from-code-point","es.string.includes","es.string.iterator","es.string.match","es.string.match-all","es.string.pad-end","es.string.pad-start","es.string.raw","es.string.repeat","es.string.replace","es.string.search","es.string.split","es.string.starts-with","es.string.trim","es.string.trim-end","es.string.trim-start","es.string.anchor","es.string.big","es.string.blink","es.string.bold","es.string.fixed","es.string.fontcolor","es.string.fontsize","es.string.italics","es.string.link","es.string.small","es.string.strike","es.string.sub","es.string.sup","esnext.string.at","esnext.string.match-all","esnext.string.replace-all"],"core-js/features/string/italics":["es.string.italics"],"core-js/features/string/iterator":["es.string.iterator"],"core-js/features/string/link":["es.string.link"],"core-js/features/string/match-all":["es.string.match-all","esnext.string.match-all"],"core-js/features/string/match":["es.string.match"],"core-js/features/string/pad-end":["es.string.pad-end"],"core-js/features/string/pad-start":["es.string.pad-start"],"core-js/features/string/raw":["es.string.raw"],"core-js/features/string/repeat":["es.string.repeat"],"core-js/features/string/replace-all":["esnext.string.replace-all"],"core-js/features/string/replace":["es.string.replace"],"core-js/features/string/search":["es.string.search"],"core-js/features/string/small":["es.string.small"],"core-js/features/string/split":["es.string.split"],"core-js/features/string/starts-with":["es.string.starts-with"],"core-js/features/string/strike":["es.string.strike"],"core-js/features/string/sub":["es.string.sub"],"core-js/features/string/sup":["es.string.sup"],"core-js/features/string/trim-end":["es.string.trim-end"],"core-js/features/string/trim-left":["es.string.trim-start"],"core-js/features/string/trim-right":["es.string.trim-end"],"core-js/features/string/trim-start":["es.string.trim-start"],"core-js/features/string/trim":["es.string.trim"],"core-js/features/string/virtual/anchor":["es.string.anchor"],"core-js/features/string/virtual/at":["esnext.string.at"],"core-js/features/string/virtual/big":["es.string.big"],"core-js/features/string/virtual/blink":["es.string.blink"],"core-js/features/string/virtual/bold":["es.string.bold"],"core-js/features/string/virtual/code-point-at":["es.string.code-point-at"],"core-js/features/string/virtual/code-points":["esnext.string.code-points"],"core-js/features/string/virtual/ends-with":["es.string.ends-with"],"core-js/features/string/virtual/fixed":["es.string.fixed"],"core-js/features/string/virtual/fontcolor":["es.string.fontcolor"],"core-js/features/string/virtual/fontsize":["es.string.fontsize"],"core-js/features/string/virtual/includes":["es.string.includes"],"core-js/features/string/virtual":["es.string.code-point-at","es.string.ends-with","es.string.includes","es.string.iterator","es.string.match","es.string.match-all","es.string.pad-end","es.string.pad-start","es.string.repeat","es.string.replace","es.string.search","es.string.split","es.string.starts-with","es.string.trim","es.string.trim-end","es.string.trim-start","es.string.anchor","es.string.big","es.string.blink","es.string.bold","es.string.fixed","es.string.fontcolor","es.string.fontsize","es.string.italics","es.string.link","es.string.small","es.string.strike","es.string.sub","es.string.sup","esnext.string.at","esnext.string.match-all","esnext.string.replace-all"],"core-js/features/string/virtual/italics":["es.string.italics"],"core-js/features/string/virtual/iterator":["es.string.iterator"],"core-js/features/string/virtual/link":["es.string.link"],"core-js/features/string/virtual/match-all":["es.string.match-all","esnext.string.match-all"],"core-js/features/string/virtual/pad-end":["es.string.pad-end"],"core-js/features/string/virtual/pad-start":["es.string.pad-start"],"core-js/features/string/virtual/repeat":["es.string.repeat"],"core-js/features/string/virtual/replace-all":["esnext.string.replace-all"],"core-js/features/string/virtual/small":["es.string.small"],"core-js/features/string/virtual/starts-with":["es.string.starts-with"],"core-js/features/string/virtual/strike":["es.string.strike"],"core-js/features/string/virtual/sub":["es.string.sub"],"core-js/features/string/virtual/sup":["es.string.sup"],"core-js/features/string/virtual/trim-end":["es.string.trim-end"],"core-js/features/string/virtual/trim-left":["es.string.trim-start"],"core-js/features/string/virtual/trim-right":["es.string.trim-end"],"core-js/features/string/virtual/trim-start":["es.string.trim-start"],"core-js/features/string/virtual/trim":["es.string.trim"],"core-js/features/symbol/async-dispose":["esnext.symbol.async-dispose"],"core-js/features/symbol/async-iterator":["es.symbol.async-iterator"],"core-js/features/symbol/description":["es.symbol.description"],"core-js/features/symbol/dispose":["esnext.symbol.dispose"],"core-js/features/symbol/for":["es.symbol"],"core-js/features/symbol/has-instance":["es.symbol.has-instance","es.function.has-instance"],"core-js/features/symbol":["es.symbol","es.symbol.description","es.symbol.async-iterator","es.symbol.has-instance","es.symbol.is-concat-spreadable","es.symbol.iterator","es.symbol.match","es.symbol.match-all","es.symbol.replace","es.symbol.search","es.symbol.species","es.symbol.split","es.symbol.to-primitive","es.symbol.to-string-tag","es.symbol.unscopables","es.array.concat","es.json.to-string-tag","es.math.to-string-tag","es.object.to-string","esnext.symbol.async-dispose","esnext.symbol.dispose","esnext.symbol.observable","esnext.symbol.pattern-match","esnext.symbol.replace-all"],"core-js/features/symbol/is-concat-spreadable":["es.symbol.is-concat-spreadable","es.array.concat"],"core-js/features/symbol/iterator":["es.symbol.iterator","es.string.iterator","web.dom-collections.iterator"],"core-js/features/symbol/key-for":["es.symbol"],"core-js/features/symbol/match-all":["es.symbol.match-all","es.string.match-all"],"core-js/features/symbol/match":["es.symbol.match","es.string.match"],"core-js/features/symbol/observable":["esnext.symbol.observable"],"core-js/features/symbol/pattern-match":["esnext.symbol.pattern-match"],"core-js/features/symbol/replace-all":["esnext.symbol.replace-all"],"core-js/features/symbol/replace":["es.symbol.replace","es.string.replace"],"core-js/features/symbol/search":["es.symbol.search","es.string.search"],"core-js/features/symbol/species":["es.symbol.species"],"core-js/features/symbol/split":["es.symbol.split","es.string.split"],"core-js/features/symbol/to-primitive":["es.symbol.to-primitive"],"core-js/features/symbol/to-string-tag":["es.symbol.to-string-tag","es.json.to-string-tag","es.math.to-string-tag","es.object.to-string"],"core-js/features/symbol/unscopables":["es.symbol.unscopables"],"core-js/features/typed-array/copy-within":["es.typed-array.copy-within"],"core-js/features/typed-array/entries":["es.typed-array.iterator"],"core-js/features/typed-array/every":["es.typed-array.every"],"core-js/features/typed-array/fill":["es.typed-array.fill"],"core-js/features/typed-array/filter":["es.typed-array.filter"],"core-js/features/typed-array/find-index":["es.typed-array.find-index"],"core-js/features/typed-array/find":["es.typed-array.find"],"core-js/features/typed-array/float32-array":["es.object.to-string","es.typed-array.float32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/features/typed-array/float64-array":["es.object.to-string","es.typed-array.float64-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/features/typed-array/for-each":["es.typed-array.for-each"],"core-js/features/typed-array/from":["es.typed-array.from"],"core-js/features/typed-array/includes":["es.typed-array.includes"],"core-js/features/typed-array/index-of":["es.typed-array.index-of"],"core-js/features/typed-array":["es.object.to-string","es.typed-array.float32-array","es.typed-array.float64-array","es.typed-array.int8-array","es.typed-array.int16-array","es.typed-array.int32-array","es.typed-array.uint8-array","es.typed-array.uint8-clamped-array","es.typed-array.uint16-array","es.typed-array.uint32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/features/typed-array/int16-array":["es.object.to-string","es.typed-array.int16-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/features/typed-array/int32-array":["es.object.to-string","es.typed-array.int32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/features/typed-array/int8-array":["es.object.to-string","es.typed-array.int8-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/features/typed-array/iterator":["es.typed-array.iterator"],"core-js/features/typed-array/join":["es.typed-array.join"],"core-js/features/typed-array/keys":["es.typed-array.iterator"],"core-js/features/typed-array/last-index-of":["es.typed-array.last-index-of"],"core-js/features/typed-array/map":["es.typed-array.map"],"core-js/features/typed-array/of":["es.typed-array.of"],"core-js/features/typed-array/reduce-right":["es.typed-array.reduce-right"],"core-js/features/typed-array/reduce":["es.typed-array.reduce"],"core-js/features/typed-array/reverse":["es.typed-array.reverse"],"core-js/features/typed-array/set":["es.typed-array.set"],"core-js/features/typed-array/slice":["es.typed-array.slice"],"core-js/features/typed-array/some":["es.typed-array.some"],"core-js/features/typed-array/sort":["es.typed-array.sort"],"core-js/features/typed-array/subarray":["es.typed-array.subarray"],"core-js/features/typed-array/to-locale-string":["es.typed-array.to-locale-string"],"core-js/features/typed-array/to-string":["es.typed-array.to-string"],"core-js/features/typed-array/uint16-array":["es.object.to-string","es.typed-array.uint16-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/features/typed-array/uint32-array":["es.object.to-string","es.typed-array.uint32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/features/typed-array/uint8-array":["es.object.to-string","es.typed-array.uint8-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/features/typed-array/uint8-clamped-array":["es.object.to-string","es.typed-array.uint8-clamped-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/features/typed-array/values":["es.typed-array.iterator"],"core-js/features/url-search-params":["web.url-search-params"],"core-js/features/url":["web.url","web.url.to-json","web.url-search-params"],"core-js/features/url/to-json":["web.url.to-json"],"core-js/features/weak-map/delete-all":["es.weak-map","esnext.weak-map.delete-all"],"core-js/features/weak-map/from":["es.string.iterator","es.weak-map","esnext.weak-map.from","web.dom-collections.iterator"],"core-js/features/weak-map":["es.object.to-string","es.weak-map","esnext.weak-map.delete-all","esnext.weak-map.from","esnext.weak-map.of","esnext.weak-map.upsert","web.dom-collections.iterator"],"core-js/features/weak-map/of":["es.string.iterator","es.weak-map","esnext.weak-map.of","web.dom-collections.iterator"],"core-js/features/weak-map/upsert":["es.weak-map","esnext.weak-map.upsert"],"core-js/features/weak-set/add-all":["es.weak-set","esnext.weak-set.add-all"],"core-js/features/weak-set/delete-all":["es.weak-set","esnext.weak-set.delete-all"],"core-js/features/weak-set/from":["es.string.iterator","es.weak-set","esnext.weak-set.from","web.dom-collections.iterator"],"core-js/features/weak-set":["es.object.to-string","es.weak-set","esnext.weak-set.add-all","esnext.weak-set.delete-all","esnext.weak-set.from","esnext.weak-set.of","web.dom-collections.iterator"],"core-js/features/weak-set/of":["es.string.iterator","es.weak-set","esnext.weak-set.of","web.dom-collections.iterator"],"core-js/proposals/array-is-template-object":["esnext.array.is-template-object"],"core-js/proposals/array-last":["esnext.array.last-index","esnext.array.last-item"],"core-js/proposals/collection-methods":["esnext.map.delete-all","esnext.map.every","esnext.map.filter","esnext.map.find","esnext.map.find-key","esnext.map.group-by","esnext.map.includes","esnext.map.key-by","esnext.map.key-of","esnext.map.map-keys","esnext.map.map-values","esnext.map.merge","esnext.map.reduce","esnext.map.some","esnext.map.update","esnext.set.add-all","esnext.set.delete-all","esnext.set.every","esnext.set.filter","esnext.set.find","esnext.set.join","esnext.set.map","esnext.set.reduce","esnext.set.some","esnext.weak-map.delete-all","esnext.weak-set.add-all","esnext.weak-set.delete-all"],"core-js/proposals/collection-of-from":["esnext.map.from","esnext.map.of","esnext.set.from","esnext.set.of","esnext.weak-map.from","esnext.weak-map.of","esnext.weak-set.from","esnext.weak-set.of"],"core-js/proposals/efficient-64-bit-arithmetic":["esnext.math.iaddh","esnext.math.imulh","esnext.math.isubh","esnext.math.umulh"],"core-js/proposals/global-this":["esnext.global-this"],"core-js/proposals":["esnext.aggregate-error","esnext.array.is-template-object","esnext.array.last-index","esnext.array.last-item","esnext.async-iterator.constructor","esnext.async-iterator.drop","esnext.async-iterator.filter","esnext.async-iterator.from","esnext.async-iterator.map","esnext.async-iterator.take","esnext.async-iterator.to-array","esnext.composite-key","esnext.composite-symbol","esnext.global-this","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","esnext.iterator.drop","esnext.iterator.every","esnext.iterator.filter","esnext.iterator.find","esnext.iterator.for-each","esnext.iterator.from","esnext.iterator.map","esnext.iterator.reduce","esnext.iterator.some","esnext.iterator.take","esnext.iterator.to-array","esnext.map.delete-all","esnext.map.every","esnext.map.filter","esnext.map.find","esnext.map.find-key","esnext.map.from","esnext.map.group-by","esnext.map.includes","esnext.map.key-by","esnext.map.key-of","esnext.map.map-keys","esnext.map.map-values","esnext.map.merge","esnext.map.of","esnext.map.reduce","esnext.map.some","esnext.map.update","esnext.map.update-or-insert","esnext.map.upsert","esnext.math.clamp","esnext.math.deg-per-rad","esnext.math.degrees","esnext.math.fscale","esnext.math.iaddh","esnext.math.imulh","esnext.math.isubh","esnext.math.rad-per-deg","esnext.math.radians","esnext.math.scale","esnext.math.seeded-prng","esnext.math.signbit","esnext.math.umulh","esnext.number.from-string","esnext.observable","esnext.promise.all-settled","esnext.promise.any","esnext.promise.try","esnext.reflect.define-metadata","esnext.reflect.delete-metadata","esnext.reflect.get-metadata","esnext.reflect.get-metadata-keys","esnext.reflect.get-own-metadata","esnext.reflect.get-own-metadata-keys","esnext.reflect.has-metadata","esnext.reflect.has-own-metadata","esnext.reflect.metadata","esnext.set.add-all","esnext.set.delete-all","esnext.set.difference","esnext.set.every","esnext.set.filter","esnext.set.find","esnext.set.from","esnext.set.intersection","esnext.set.is-disjoint-from","esnext.set.is-subset-of","esnext.set.is-superset-of","esnext.set.join","esnext.set.map","esnext.set.of","esnext.set.reduce","esnext.set.some","esnext.set.symmetric-difference","esnext.set.union","esnext.string.at","esnext.string.code-points","esnext.string.match-all","esnext.string.replace-all","esnext.symbol.async-dispose","esnext.symbol.dispose","esnext.symbol.observable","esnext.symbol.pattern-match","esnext.symbol.replace-all","esnext.weak-map.delete-all","esnext.weak-map.from","esnext.weak-map.of","esnext.weak-map.upsert","esnext.weak-set.add-all","esnext.weak-set.delete-all","esnext.weak-set.from","esnext.weak-set.of","web.url","web.url.to-json","web.url-search-params"],"core-js/proposals/iterator-helpers":["esnext.async-iterator.constructor","esnext.async-iterator.drop","esnext.async-iterator.filter","esnext.async-iterator.from","esnext.async-iterator.map","esnext.async-iterator.take","esnext.async-iterator.to-array","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","esnext.iterator.drop","esnext.iterator.every","esnext.iterator.filter","esnext.iterator.find","esnext.iterator.for-each","esnext.iterator.from","esnext.iterator.map","esnext.iterator.reduce","esnext.iterator.some","esnext.iterator.take","esnext.iterator.to-array"],"core-js/proposals/keys-composition":["esnext.composite-key","esnext.composite-symbol"],"core-js/proposals/map-update-or-insert":["esnext.map.update-or-insert","esnext.map.upsert","esnext.weak-map.upsert"],"core-js/proposals/map-upsert":["esnext.map.update-or-insert","esnext.map.upsert","esnext.weak-map.upsert"],"core-js/proposals/math-extensions":["esnext.math.clamp","esnext.math.deg-per-rad","esnext.math.degrees","esnext.math.fscale","esnext.math.rad-per-deg","esnext.math.radians","esnext.math.scale"],"core-js/proposals/math-signbit":["esnext.math.signbit"],"core-js/proposals/number-from-string":["esnext.number.from-string"],"core-js/proposals/observable":["esnext.observable","esnext.symbol.observable"],"core-js/proposals/pattern-matching":["esnext.symbol.pattern-match"],"core-js/proposals/promise-all-settled":["esnext.promise.all-settled"],"core-js/proposals/promise-any":["esnext.aggregate-error","esnext.promise.any"],"core-js/proposals/promise-try":["esnext.promise.try"],"core-js/proposals/reflect-metadata":["esnext.reflect.define-metadata","esnext.reflect.delete-metadata","esnext.reflect.get-metadata","esnext.reflect.get-metadata-keys","esnext.reflect.get-own-metadata","esnext.reflect.get-own-metadata-keys","esnext.reflect.has-metadata","esnext.reflect.has-own-metadata","esnext.reflect.metadata"],"core-js/proposals/seeded-random":["esnext.math.seeded-prng"],"core-js/proposals/set-methods":["esnext.set.difference","esnext.set.intersection","esnext.set.is-disjoint-from","esnext.set.is-subset-of","esnext.set.is-superset-of","esnext.set.symmetric-difference","esnext.set.union"],"core-js/proposals/string-at":["esnext.string.at"],"core-js/proposals/string-code-points":["esnext.string.code-points"],"core-js/proposals/string-match-all":["esnext.string.match-all"],"core-js/proposals/string-replace-all":["esnext.string.replace-all","esnext.symbol.replace-all"],"core-js/proposals/url":["web.url","web.url.to-json","web.url-search-params"],"core-js/proposals/using-statement":["esnext.symbol.async-dispose","esnext.symbol.dispose"],"core-js/stable/array-buffer/constructor":["es.array-buffer.constructor","es.object.to-string"],"core-js/stable/array-buffer":["es.array-buffer.constructor","es.array-buffer.is-view","es.array-buffer.slice","es.object.to-string"],"core-js/stable/array-buffer/is-view":["es.array-buffer.is-view"],"core-js/stable/array-buffer/slice":["es.array-buffer.slice"],"core-js/stable/array/concat":["es.array.concat"],"core-js/stable/array/copy-within":["es.array.copy-within"],"core-js/stable/array/entries":["es.array.iterator"],"core-js/stable/array/every":["es.array.every"],"core-js/stable/array/fill":["es.array.fill"],"core-js/stable/array/filter":["es.array.filter"],"core-js/stable/array/find-index":["es.array.find-index"],"core-js/stable/array/find":["es.array.find"],"core-js/stable/array/flat-map":["es.array.flat-map","es.array.unscopables.flat-map"],"core-js/stable/array/flat":["es.array.flat","es.array.unscopables.flat"],"core-js/stable/array/for-each":["es.array.for-each"],"core-js/stable/array/from":["es.array.from","es.string.iterator"],"core-js/stable/array/includes":["es.array.includes"],"core-js/stable/array/index-of":["es.array.index-of"],"core-js/stable/array":["es.array.concat","es.array.copy-within","es.array.every","es.array.fill","es.array.filter","es.array.find","es.array.find-index","es.array.flat","es.array.flat-map","es.array.for-each","es.array.from","es.array.includes","es.array.index-of","es.array.is-array","es.array.iterator","es.array.join","es.array.last-index-of","es.array.map","es.array.of","es.array.reduce","es.array.reduce-right","es.array.reverse","es.array.slice","es.array.some","es.array.sort","es.array.species","es.array.splice","es.array.unscopables.flat","es.array.unscopables.flat-map","es.string.iterator"],"core-js/stable/array/is-array":["es.array.is-array"],"core-js/stable/array/iterator":["es.array.iterator"],"core-js/stable/array/join":["es.array.join"],"core-js/stable/array/keys":["es.array.iterator"],"core-js/stable/array/last-index-of":["es.array.last-index-of"],"core-js/stable/array/map":["es.array.map"],"core-js/stable/array/of":["es.array.of"],"core-js/stable/array/reduce-right":["es.array.reduce-right"],"core-js/stable/array/reduce":["es.array.reduce"],"core-js/stable/array/reverse":["es.array.reverse"],"core-js/stable/array/slice":["es.array.slice"],"core-js/stable/array/some":["es.array.some"],"core-js/stable/array/sort":["es.array.sort"],"core-js/stable/array/splice":["es.array.splice"],"core-js/stable/array/values":["es.array.iterator"],"core-js/stable/array/virtual/concat":["es.array.concat"],"core-js/stable/array/virtual/copy-within":["es.array.copy-within"],"core-js/stable/array/virtual/entries":["es.array.iterator"],"core-js/stable/array/virtual/every":["es.array.every"],"core-js/stable/array/virtual/fill":["es.array.fill"],"core-js/stable/array/virtual/filter":["es.array.filter"],"core-js/stable/array/virtual/find-index":["es.array.find-index"],"core-js/stable/array/virtual/find":["es.array.find"],"core-js/stable/array/virtual/flat-map":["es.array.flat-map","es.array.unscopables.flat-map"],"core-js/stable/array/virtual/flat":["es.array.flat","es.array.unscopables.flat"],"core-js/stable/array/virtual/for-each":["es.array.for-each"],"core-js/stable/array/virtual/includes":["es.array.includes"],"core-js/stable/array/virtual/index-of":["es.array.index-of"],"core-js/stable/array/virtual":["es.array.concat","es.array.copy-within","es.array.every","es.array.fill","es.array.filter","es.array.find","es.array.find-index","es.array.flat","es.array.flat-map","es.array.for-each","es.array.includes","es.array.index-of","es.array.iterator","es.array.join","es.array.last-index-of","es.array.map","es.array.reduce","es.array.reduce-right","es.array.reverse","es.array.slice","es.array.some","es.array.sort","es.array.species","es.array.splice","es.array.unscopables.flat","es.array.unscopables.flat-map"],"core-js/stable/array/virtual/iterator":["es.array.iterator"],"core-js/stable/array/virtual/join":["es.array.join"],"core-js/stable/array/virtual/keys":["es.array.iterator"],"core-js/stable/array/virtual/last-index-of":["es.array.last-index-of"],"core-js/stable/array/virtual/map":["es.array.map"],"core-js/stable/array/virtual/reduce-right":["es.array.reduce-right"],"core-js/stable/array/virtual/reduce":["es.array.reduce"],"core-js/stable/array/virtual/reverse":["es.array.reverse"],"core-js/stable/array/virtual/slice":["es.array.slice"],"core-js/stable/array/virtual/some":["es.array.some"],"core-js/stable/array/virtual/sort":["es.array.sort"],"core-js/stable/array/virtual/splice":["es.array.splice"],"core-js/stable/array/virtual/values":["es.array.iterator"],"core-js/stable/clear-immediate":["web.immediate"],"core-js/stable/data-view":["es.data-view","es.object.to-string"],"core-js/stable/date":["es.date.now","es.date.to-iso-string","es.date.to-json","es.date.to-primitive","es.date.to-string"],"core-js/stable/date/now":["es.date.now"],"core-js/stable/date/to-iso-string":["es.date.to-iso-string","es.date.to-json"],"core-js/stable/date/to-json":["es.date.to-json"],"core-js/stable/date/to-primitive":["es.date.to-primitive"],"core-js/stable/date/to-string":["es.date.to-string"],"core-js/stable/dom-collections/for-each":["web.dom-collections.for-each"],"core-js/stable/dom-collections":["es.array.iterator","web.dom-collections.for-each","web.dom-collections.iterator"],"core-js/stable/dom-collections/iterator":["web.dom-collections.iterator"],"core-js/stable/function/bind":["es.function.bind"],"core-js/stable/function/has-instance":["es.function.has-instance"],"core-js/stable/function":["es.function.bind","es.function.has-instance","es.function.name"],"core-js/stable/function/name":["es.function.name"],"core-js/stable/function/virtual/bind":["es.function.bind"],"core-js/stable/function/virtual":["es.function.bind"],"core-js/stable/global-this":["es.global-this"],"core-js/stable":["es.symbol","es.symbol.description","es.symbol.async-iterator","es.symbol.has-instance","es.symbol.is-concat-spreadable","es.symbol.iterator","es.symbol.match","es.symbol.match-all","es.symbol.replace","es.symbol.search","es.symbol.species","es.symbol.split","es.symbol.to-primitive","es.symbol.to-string-tag","es.symbol.unscopables","es.array.concat","es.array.copy-within","es.array.every","es.array.fill","es.array.filter","es.array.find","es.array.find-index","es.array.flat","es.array.flat-map","es.array.for-each","es.array.from","es.array.includes","es.array.index-of","es.array.is-array","es.array.iterator","es.array.join","es.array.last-index-of","es.array.map","es.array.of","es.array.reduce","es.array.reduce-right","es.array.reverse","es.array.slice","es.array.some","es.array.sort","es.array.species","es.array.splice","es.array.unscopables.flat","es.array.unscopables.flat-map","es.array-buffer.constructor","es.array-buffer.is-view","es.array-buffer.slice","es.data-view","es.date.now","es.date.to-iso-string","es.date.to-json","es.date.to-primitive","es.date.to-string","es.function.bind","es.function.has-instance","es.function.name","es.global-this","es.json.to-string-tag","es.map","es.math.acosh","es.math.asinh","es.math.atanh","es.math.cbrt","es.math.clz32","es.math.cosh","es.math.expm1","es.math.fround","es.math.hypot","es.math.imul","es.math.log10","es.math.log1p","es.math.log2","es.math.sign","es.math.sinh","es.math.tanh","es.math.to-string-tag","es.math.trunc","es.number.constructor","es.number.epsilon","es.number.is-finite","es.number.is-integer","es.number.is-nan","es.number.is-safe-integer","es.number.max-safe-integer","es.number.min-safe-integer","es.number.parse-float","es.number.parse-int","es.number.to-fixed","es.number.to-precision","es.object.assign","es.object.create","es.object.define-getter","es.object.define-properties","es.object.define-property","es.object.define-setter","es.object.entries","es.object.freeze","es.object.from-entries","es.object.get-own-property-descriptor","es.object.get-own-property-descriptors","es.object.get-own-property-names","es.object.get-prototype-of","es.object.is","es.object.is-extensible","es.object.is-frozen","es.object.is-sealed","es.object.keys","es.object.lookup-getter","es.object.lookup-setter","es.object.prevent-extensions","es.object.seal","es.object.set-prototype-of","es.object.to-string","es.object.values","es.parse-float","es.parse-int","es.promise","es.promise.all-settled","es.promise.finally","es.reflect.apply","es.reflect.construct","es.reflect.define-property","es.reflect.delete-property","es.reflect.get","es.reflect.get-own-property-descriptor","es.reflect.get-prototype-of","es.reflect.has","es.reflect.is-extensible","es.reflect.own-keys","es.reflect.prevent-extensions","es.reflect.set","es.reflect.set-prototype-of","es.regexp.constructor","es.regexp.exec","es.regexp.flags","es.regexp.to-string","es.set","es.string.code-point-at","es.string.ends-with","es.string.from-code-point","es.string.includes","es.string.iterator","es.string.match","es.string.match-all","es.string.pad-end","es.string.pad-start","es.string.raw","es.string.repeat","es.string.replace","es.string.search","es.string.split","es.string.starts-with","es.string.trim","es.string.trim-end","es.string.trim-start","es.string.anchor","es.string.big","es.string.blink","es.string.bold","es.string.fixed","es.string.fontcolor","es.string.fontsize","es.string.italics","es.string.link","es.string.small","es.string.strike","es.string.sub","es.string.sup","es.typed-array.float32-array","es.typed-array.float64-array","es.typed-array.int8-array","es.typed-array.int16-array","es.typed-array.int32-array","es.typed-array.uint8-array","es.typed-array.uint8-clamped-array","es.typed-array.uint16-array","es.typed-array.uint32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string","es.weak-map","es.weak-set","web.dom-collections.for-each","web.dom-collections.iterator","web.immediate","web.queue-microtask","web.timers","web.url","web.url.to-json","web.url-search-params"],"core-js/stable/instance/bind":["es.function.bind"],"core-js/stable/instance/code-point-at":["es.string.code-point-at"],"core-js/stable/instance/concat":["es.array.concat"],"core-js/stable/instance/copy-within":["es.array.copy-within"],"core-js/stable/instance/ends-with":["es.string.ends-with"],"core-js/stable/instance/entries":["es.array.iterator","web.dom-collections.iterator"],"core-js/stable/instance/every":["es.array.every"],"core-js/stable/instance/fill":["es.array.fill"],"core-js/stable/instance/filter":["es.array.filter"],"core-js/stable/instance/find-index":["es.array.find-index"],"core-js/stable/instance/find":["es.array.find"],"core-js/stable/instance/flags":["es.regexp.flags"],"core-js/stable/instance/flat-map":["es.array.flat-map","es.array.unscopables.flat-map"],"core-js/stable/instance/flat":["es.array.flat","es.array.unscopables.flat"],"core-js/stable/instance/for-each":["es.array.for-each","web.dom-collections.iterator"],"core-js/stable/instance/includes":["es.array.includes","es.string.includes"],"core-js/stable/instance/index-of":["es.array.index-of"],"core-js/stable/instance/keys":["es.array.iterator","web.dom-collections.iterator"],"core-js/stable/instance/last-index-of":["es.array.last-index-of"],"core-js/stable/instance/map":["es.array.map"],"core-js/stable/instance/match-all":["es.string.match-all"],"core-js/stable/instance/pad-end":["es.string.pad-end"],"core-js/stable/instance/pad-start":["es.string.pad-start"],"core-js/stable/instance/reduce-right":["es.array.reduce-right"],"core-js/stable/instance/reduce":["es.array.reduce"],"core-js/stable/instance/repeat":["es.string.repeat"],"core-js/stable/instance/reverse":["es.array.reverse"],"core-js/stable/instance/slice":["es.array.slice"],"core-js/stable/instance/some":["es.array.some"],"core-js/stable/instance/sort":["es.array.sort"],"core-js/stable/instance/splice":["es.array.splice"],"core-js/stable/instance/starts-with":["es.string.starts-with"],"core-js/stable/instance/trim-end":["es.string.trim-end"],"core-js/stable/instance/trim-left":["es.string.trim-start"],"core-js/stable/instance/trim-right":["es.string.trim-end"],"core-js/stable/instance/trim-start":["es.string.trim-start"],"core-js/stable/instance/trim":["es.string.trim"],"core-js/stable/instance/values":["es.array.iterator","web.dom-collections.iterator"],"core-js/stable/json":["es.json.to-string-tag"],"core-js/stable/json/stringify":["es.json.stringify"],"core-js/stable/json/to-string-tag":["es.json.to-string-tag"],"core-js/stable/map":["es.map","es.object.to-string","es.string.iterator","web.dom-collections.iterator"],"core-js/stable/math/acosh":["es.math.acosh"],"core-js/stable/math/asinh":["es.math.asinh"],"core-js/stable/math/atanh":["es.math.atanh"],"core-js/stable/math/cbrt":["es.math.cbrt"],"core-js/stable/math/clz32":["es.math.clz32"],"core-js/stable/math/cosh":["es.math.cosh"],"core-js/stable/math/expm1":["es.math.expm1"],"core-js/stable/math/fround":["es.math.fround"],"core-js/stable/math/hypot":["es.math.hypot"],"core-js/stable/math/imul":["es.math.imul"],"core-js/stable/math":["es.math.acosh","es.math.asinh","es.math.atanh","es.math.cbrt","es.math.clz32","es.math.cosh","es.math.expm1","es.math.fround","es.math.hypot","es.math.imul","es.math.log10","es.math.log1p","es.math.log2","es.math.sign","es.math.sinh","es.math.tanh","es.math.to-string-tag","es.math.trunc"],"core-js/stable/math/log10":["es.math.log10"],"core-js/stable/math/log1p":["es.math.log1p"],"core-js/stable/math/log2":["es.math.log2"],"core-js/stable/math/sign":["es.math.sign"],"core-js/stable/math/sinh":["es.math.sinh"],"core-js/stable/math/tanh":["es.math.tanh"],"core-js/stable/math/to-string-tag":["es.math.to-string-tag"],"core-js/stable/math/trunc":["es.math.trunc"],"core-js/stable/number/constructor":["es.number.constructor"],"core-js/stable/number/epsilon":["es.number.epsilon"],"core-js/stable/number":["es.number.constructor","es.number.epsilon","es.number.is-finite","es.number.is-integer","es.number.is-nan","es.number.is-safe-integer","es.number.max-safe-integer","es.number.min-safe-integer","es.number.parse-float","es.number.parse-int","es.number.to-fixed","es.number.to-precision"],"core-js/stable/number/is-finite":["es.number.is-finite"],"core-js/stable/number/is-integer":["es.number.is-integer"],"core-js/stable/number/is-nan":["es.number.is-nan"],"core-js/stable/number/is-safe-integer":["es.number.is-safe-integer"],"core-js/stable/number/max-safe-integer":["es.number.max-safe-integer"],"core-js/stable/number/min-safe-integer":["es.number.min-safe-integer"],"core-js/stable/number/parse-float":["es.number.parse-float"],"core-js/stable/number/parse-int":["es.number.parse-int"],"core-js/stable/number/to-fixed":["es.number.to-fixed"],"core-js/stable/number/to-precision":["es.number.to-precision"],"core-js/stable/number/virtual":["es.number.to-fixed","es.number.to-precision"],"core-js/stable/number/virtual/to-fixed":["es.number.to-fixed"],"core-js/stable/number/virtual/to-precision":["es.number.to-precision"],"core-js/stable/object/assign":["es.object.assign"],"core-js/stable/object/create":["es.object.create"],"core-js/stable/object/define-getter":["es.object.define-getter"],"core-js/stable/object/define-properties":["es.object.define-properties"],"core-js/stable/object/define-property":["es.object.define-property"],"core-js/stable/object/define-setter":["es.object.define-setter"],"core-js/stable/object/entries":["es.object.entries"],"core-js/stable/object/freeze":["es.object.freeze"],"core-js/stable/object/from-entries":["es.array.iterator","es.object.from-entries"],"core-js/stable/object/get-own-property-descriptor":["es.object.get-own-property-descriptor"],"core-js/stable/object/get-own-property-descriptors":["es.object.get-own-property-descriptors"],"core-js/stable/object/get-own-property-names":["es.object.get-own-property-names"],"core-js/stable/object/get-own-property-symbols":["es.symbol"],"core-js/stable/object/get-prototype-of":["es.object.get-prototype-of"],"core-js/stable/object":["es.symbol","es.json.to-string-tag","es.math.to-string-tag","es.object.assign","es.object.create","es.object.define-getter","es.object.define-properties","es.object.define-property","es.object.define-setter","es.object.entries","es.object.freeze","es.object.from-entries","es.object.get-own-property-descriptor","es.object.get-own-property-descriptors","es.object.get-own-property-names","es.object.get-prototype-of","es.object.is","es.object.is-extensible","es.object.is-frozen","es.object.is-sealed","es.object.keys","es.object.lookup-getter","es.object.lookup-setter","es.object.prevent-extensions","es.object.seal","es.object.set-prototype-of","es.object.to-string","es.object.values"],"core-js/stable/object/is-extensible":["es.object.is-extensible"],"core-js/stable/object/is-frozen":["es.object.is-frozen"],"core-js/stable/object/is-sealed":["es.object.is-sealed"],"core-js/stable/object/is":["es.object.is"],"core-js/stable/object/keys":["es.object.keys"],"core-js/stable/object/lookup-getter":["es.object.lookup-setter"],"core-js/stable/object/lookup-setter":["es.object.lookup-setter"],"core-js/stable/object/prevent-extensions":["es.object.prevent-extensions"],"core-js/stable/object/seal":["es.object.seal"],"core-js/stable/object/set-prototype-of":["es.object.set-prototype-of"],"core-js/stable/object/to-string":["es.json.to-string-tag","es.math.to-string-tag","es.object.to-string"],"core-js/stable/object/values":["es.object.values"],"core-js/stable/parse-float":["es.parse-float"],"core-js/stable/parse-int":["es.parse-int"],"core-js/stable/promise/all-settled":["es.promise","es.promise.all-settled"],"core-js/stable/promise/finally":["es.promise","es.promise.finally"],"core-js/stable/promise":["es.object.to-string","es.promise","es.promise.all-settled","es.promise.finally","es.string.iterator","web.dom-collections.iterator"],"core-js/stable/queue-microtask":["web.queue-microtask"],"core-js/stable/reflect/apply":["es.reflect.apply"],"core-js/stable/reflect/construct":["es.reflect.construct"],"core-js/stable/reflect/define-property":["es.reflect.define-property"],"core-js/stable/reflect/delete-property":["es.reflect.delete-property"],"core-js/stable/reflect/get-own-property-descriptor":["es.reflect.get-own-property-descriptor"],"core-js/stable/reflect/get-prototype-of":["es.reflect.get-prototype-of"],"core-js/stable/reflect/get":["es.reflect.get"],"core-js/stable/reflect/has":["es.reflect.has"],"core-js/stable/reflect":["es.reflect.apply","es.reflect.construct","es.reflect.define-property","es.reflect.delete-property","es.reflect.get","es.reflect.get-own-property-descriptor","es.reflect.get-prototype-of","es.reflect.has","es.reflect.is-extensible","es.reflect.own-keys","es.reflect.prevent-extensions","es.reflect.set","es.reflect.set-prototype-of"],"core-js/stable/reflect/is-extensible":["es.reflect.is-extensible"],"core-js/stable/reflect/own-keys":["es.reflect.own-keys"],"core-js/stable/reflect/prevent-extensions":["es.reflect.prevent-extensions"],"core-js/stable/reflect/set-prototype-of":["es.reflect.set-prototype-of"],"core-js/stable/reflect/set":["es.reflect.set"],"core-js/stable/regexp/constructor":["es.regexp.constructor"],"core-js/stable/regexp/flags":["es.regexp.flags"],"core-js/stable/regexp":["es.regexp.constructor","es.regexp.exec","es.regexp.flags","es.regexp.to-string","es.string.match","es.string.replace","es.string.search","es.string.split"],"core-js/stable/regexp/match":["es.string.match"],"core-js/stable/regexp/replace":["es.string.replace"],"core-js/stable/regexp/search":["es.string.search"],"core-js/stable/regexp/split":["es.string.split"],"core-js/stable/regexp/to-string":["es.regexp.to-string"],"core-js/stable/set-immediate":["web.immediate"],"core-js/stable/set-interval":["web.timers"],"core-js/stable/set-timeout":["web.timers"],"core-js/stable/set":["es.object.to-string","es.set","es.string.iterator","web.dom-collections.iterator"],"core-js/stable/string/anchor":["es.string.anchor"],"core-js/stable/string/big":["es.string.big"],"core-js/stable/string/blink":["es.string.blink"],"core-js/stable/string/bold":["es.string.bold"],"core-js/stable/string/code-point-at":["es.string.code-point-at"],"core-js/stable/string/ends-with":["es.string.ends-with"],"core-js/stable/string/fixed":["es.string.fixed"],"core-js/stable/string/fontcolor":["es.string.fontcolor"],"core-js/stable/string/fontsize":["es.string.fontsize"],"core-js/stable/string/from-code-point":["es.string.from-code-point"],"core-js/stable/string/includes":["es.string.includes"],"core-js/stable/string":["es.string.code-point-at","es.string.ends-with","es.string.from-code-point","es.string.includes","es.string.iterator","es.string.match","es.string.match-all","es.string.pad-end","es.string.pad-start","es.string.raw","es.string.repeat","es.string.replace","es.string.search","es.string.split","es.string.starts-with","es.string.trim","es.string.trim-end","es.string.trim-start","es.string.anchor","es.string.big","es.string.blink","es.string.bold","es.string.fixed","es.string.fontcolor","es.string.fontsize","es.string.italics","es.string.link","es.string.small","es.string.strike","es.string.sub","es.string.sup"],"core-js/stable/string/italics":["es.string.italics"],"core-js/stable/string/iterator":["es.string.iterator"],"core-js/stable/string/link":["es.string.link"],"core-js/stable/string/match-all":["es.string.match-all"],"core-js/stable/string/match":["es.string.match"],"core-js/stable/string/pad-end":["es.string.pad-end"],"core-js/stable/string/pad-start":["es.string.pad-start"],"core-js/stable/string/raw":["es.string.raw"],"core-js/stable/string/repeat":["es.string.repeat"],"core-js/stable/string/replace":["es.string.replace"],"core-js/stable/string/search":["es.string.search"],"core-js/stable/string/small":["es.string.small"],"core-js/stable/string/split":["es.string.split"],"core-js/stable/string/starts-with":["es.string.starts-with"],"core-js/stable/string/strike":["es.string.strike"],"core-js/stable/string/sub":["es.string.sub"],"core-js/stable/string/sup":["es.string.sup"],"core-js/stable/string/trim-end":["es.string.trim-end"],"core-js/stable/string/trim-left":["es.string.trim-start"],"core-js/stable/string/trim-right":["es.string.trim-end"],"core-js/stable/string/trim-start":["es.string.trim-start"],"core-js/stable/string/trim":["es.string.trim"],"core-js/stable/string/virtual/anchor":["es.string.anchor"],"core-js/stable/string/virtual/big":["es.string.big"],"core-js/stable/string/virtual/blink":["es.string.blink"],"core-js/stable/string/virtual/bold":["es.string.bold"],"core-js/stable/string/virtual/code-point-at":["es.string.code-point-at"],"core-js/stable/string/virtual/ends-with":["es.string.ends-with"],"core-js/stable/string/virtual/fixed":["es.string.fixed"],"core-js/stable/string/virtual/fontcolor":["es.string.fontcolor"],"core-js/stable/string/virtual/fontsize":["es.string.fontsize"],"core-js/stable/string/virtual/includes":["es.string.includes"],"core-js/stable/string/virtual":["es.string.code-point-at","es.string.ends-with","es.string.includes","es.string.iterator","es.string.match","es.string.match-all","es.string.pad-end","es.string.pad-start","es.string.repeat","es.string.replace","es.string.search","es.string.split","es.string.starts-with","es.string.trim","es.string.trim-end","es.string.trim-start","es.string.anchor","es.string.big","es.string.blink","es.string.bold","es.string.fixed","es.string.fontcolor","es.string.fontsize","es.string.italics","es.string.link","es.string.small","es.string.strike","es.string.sub","es.string.sup"],"core-js/stable/string/virtual/italics":["es.string.italics"],"core-js/stable/string/virtual/iterator":["es.string.iterator"],"core-js/stable/string/virtual/link":["es.string.link"],"core-js/stable/string/virtual/match-all":["es.string.match-all"],"core-js/stable/string/virtual/pad-end":["es.string.pad-end"],"core-js/stable/string/virtual/pad-start":["es.string.pad-start"],"core-js/stable/string/virtual/repeat":["es.string.repeat"],"core-js/stable/string/virtual/small":["es.string.small"],"core-js/stable/string/virtual/starts-with":["es.string.starts-with"],"core-js/stable/string/virtual/strike":["es.string.strike"],"core-js/stable/string/virtual/sub":["es.string.sub"],"core-js/stable/string/virtual/sup":["es.string.sup"],"core-js/stable/string/virtual/trim-end":["es.string.trim-end"],"core-js/stable/string/virtual/trim-left":["es.string.trim-start"],"core-js/stable/string/virtual/trim-right":["es.string.trim-end"],"core-js/stable/string/virtual/trim-start":["es.string.trim-start"],"core-js/stable/string/virtual/trim":["es.string.trim"],"core-js/stable/symbol/async-iterator":["es.symbol.async-iterator"],"core-js/stable/symbol/description":["es.symbol.description"],"core-js/stable/symbol/for":["es.symbol"],"core-js/stable/symbol/has-instance":["es.symbol.has-instance","es.function.has-instance"],"core-js/stable/symbol":["es.symbol","es.symbol.description","es.symbol.async-iterator","es.symbol.has-instance","es.symbol.is-concat-spreadable","es.symbol.iterator","es.symbol.match","es.symbol.match-all","es.symbol.replace","es.symbol.search","es.symbol.species","es.symbol.split","es.symbol.to-primitive","es.symbol.to-string-tag","es.symbol.unscopables","es.array.concat","es.json.to-string-tag","es.math.to-string-tag","es.object.to-string"],"core-js/stable/symbol/is-concat-spreadable":["es.symbol.is-concat-spreadable","es.array.concat"],"core-js/stable/symbol/iterator":["es.symbol.iterator","es.string.iterator","web.dom-collections.iterator"],"core-js/stable/symbol/key-for":["es.symbol"],"core-js/stable/symbol/match-all":["es.symbol.match-all","es.string.match-all"],"core-js/stable/symbol/match":["es.symbol.match","es.string.match"],"core-js/stable/symbol/replace":["es.symbol.replace","es.string.replace"],"core-js/stable/symbol/search":["es.symbol.search","es.string.search"],"core-js/stable/symbol/species":["es.symbol.species"],"core-js/stable/symbol/split":["es.symbol.split","es.string.split"],"core-js/stable/symbol/to-primitive":["es.symbol.to-primitive"],"core-js/stable/symbol/to-string-tag":["es.symbol.to-string-tag","es.json.to-string-tag","es.math.to-string-tag","es.object.to-string"],"core-js/stable/symbol/unscopables":["es.symbol.unscopables"],"core-js/stable/typed-array/copy-within":["es.typed-array.copy-within"],"core-js/stable/typed-array/entries":["es.typed-array.iterator"],"core-js/stable/typed-array/every":["es.typed-array.every"],"core-js/stable/typed-array/fill":["es.typed-array.fill"],"core-js/stable/typed-array/filter":["es.typed-array.filter"],"core-js/stable/typed-array/find-index":["es.typed-array.find-index"],"core-js/stable/typed-array/find":["es.typed-array.find"],"core-js/stable/typed-array/float32-array":["es.object.to-string","es.typed-array.float32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/stable/typed-array/float64-array":["es.object.to-string","es.typed-array.float64-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/stable/typed-array/for-each":["es.typed-array.for-each"],"core-js/stable/typed-array/from":["es.typed-array.from"],"core-js/stable/typed-array/includes":["es.typed-array.includes"],"core-js/stable/typed-array/index-of":["es.typed-array.index-of"],"core-js/stable/typed-array":["es.object.to-string","es.typed-array.float32-array","es.typed-array.float64-array","es.typed-array.int8-array","es.typed-array.int16-array","es.typed-array.int32-array","es.typed-array.uint8-array","es.typed-array.uint8-clamped-array","es.typed-array.uint16-array","es.typed-array.uint32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/stable/typed-array/int16-array":["es.object.to-string","es.typed-array.int16-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/stable/typed-array/int32-array":["es.object.to-string","es.typed-array.int32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/stable/typed-array/int8-array":["es.object.to-string","es.typed-array.int8-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/stable/typed-array/iterator":["es.typed-array.iterator"],"core-js/stable/typed-array/join":["es.typed-array.join"],"core-js/stable/typed-array/keys":["es.typed-array.iterator"],"core-js/stable/typed-array/last-index-of":["es.typed-array.last-index-of"],"core-js/stable/typed-array/map":["es.typed-array.map"],"core-js/stable/typed-array/of":["es.typed-array.of"],"core-js/stable/typed-array/reduce-right":["es.typed-array.reduce-right"],"core-js/stable/typed-array/reduce":["es.typed-array.reduce"],"core-js/stable/typed-array/reverse":["es.typed-array.reverse"],"core-js/stable/typed-array/set":["es.typed-array.set"],"core-js/stable/typed-array/slice":["es.typed-array.slice"],"core-js/stable/typed-array/some":["es.typed-array.some"],"core-js/stable/typed-array/sort":["es.typed-array.sort"],"core-js/stable/typed-array/subarray":["es.typed-array.subarray"],"core-js/stable/typed-array/to-locale-string":["es.typed-array.to-locale-string"],"core-js/stable/typed-array/to-string":["es.typed-array.to-string"],"core-js/stable/typed-array/uint16-array":["es.object.to-string","es.typed-array.uint16-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/stable/typed-array/uint32-array":["es.object.to-string","es.typed-array.uint32-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/stable/typed-array/uint8-array":["es.object.to-string","es.typed-array.uint8-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/stable/typed-array/uint8-clamped-array":["es.object.to-string","es.typed-array.uint8-clamped-array","es.typed-array.copy-within","es.typed-array.every","es.typed-array.fill","es.typed-array.filter","es.typed-array.find","es.typed-array.find-index","es.typed-array.for-each","es.typed-array.from","es.typed-array.includes","es.typed-array.index-of","es.typed-array.iterator","es.typed-array.join","es.typed-array.last-index-of","es.typed-array.map","es.typed-array.of","es.typed-array.reduce","es.typed-array.reduce-right","es.typed-array.reverse","es.typed-array.set","es.typed-array.slice","es.typed-array.some","es.typed-array.sort","es.typed-array.subarray","es.typed-array.to-locale-string","es.typed-array.to-string"],"core-js/stable/typed-array/values":["es.typed-array.iterator"],"core-js/stable/url-search-params":["web.url-search-params"],"core-js/stable/url":["web.url","web.url.to-json","web.url-search-params"],"core-js/stable/url/to-json":["web.url.to-json"],"core-js/stable/weak-map":["es.object.to-string","es.weak-map","web.dom-collections.iterator"],"core-js/stable/weak-set":["es.object.to-string","es.weak-set","web.dom-collections.iterator"],"core-js/stage/0":["esnext.aggregate-error","esnext.array.is-template-object","esnext.array.last-index","esnext.array.last-item","esnext.async-iterator.constructor","esnext.async-iterator.drop","esnext.async-iterator.filter","esnext.async-iterator.from","esnext.async-iterator.map","esnext.async-iterator.take","esnext.async-iterator.to-array","esnext.composite-key","esnext.composite-symbol","esnext.global-this","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","esnext.iterator.drop","esnext.iterator.every","esnext.iterator.filter","esnext.iterator.find","esnext.iterator.for-each","esnext.iterator.from","esnext.iterator.map","esnext.iterator.reduce","esnext.iterator.some","esnext.iterator.take","esnext.iterator.to-array","esnext.map.delete-all","esnext.map.every","esnext.map.filter","esnext.map.find","esnext.map.find-key","esnext.map.from","esnext.map.group-by","esnext.map.includes","esnext.map.key-by","esnext.map.key-of","esnext.map.map-keys","esnext.map.map-values","esnext.map.merge","esnext.map.of","esnext.map.reduce","esnext.map.some","esnext.map.update","esnext.map.update-or-insert","esnext.map.upsert","esnext.math.clamp","esnext.math.deg-per-rad","esnext.math.degrees","esnext.math.fscale","esnext.math.iaddh","esnext.math.imulh","esnext.math.isubh","esnext.math.rad-per-deg","esnext.math.radians","esnext.math.scale","esnext.math.seeded-prng","esnext.math.signbit","esnext.math.umulh","esnext.number.from-string","esnext.observable","esnext.promise.all-settled","esnext.promise.any","esnext.promise.try","esnext.set.add-all","esnext.set.delete-all","esnext.set.difference","esnext.set.every","esnext.set.filter","esnext.set.find","esnext.set.from","esnext.set.intersection","esnext.set.is-disjoint-from","esnext.set.is-subset-of","esnext.set.is-superset-of","esnext.set.join","esnext.set.map","esnext.set.of","esnext.set.reduce","esnext.set.some","esnext.set.symmetric-difference","esnext.set.union","esnext.string.at","esnext.string.code-points","esnext.string.match-all","esnext.string.replace-all","esnext.symbol.async-dispose","esnext.symbol.dispose","esnext.symbol.observable","esnext.symbol.pattern-match","esnext.symbol.replace-all","esnext.weak-map.delete-all","esnext.weak-map.from","esnext.weak-map.of","esnext.weak-map.upsert","esnext.weak-set.add-all","esnext.weak-set.delete-all","esnext.weak-set.from","esnext.weak-set.of","web.url","web.url.to-json","web.url-search-params"],"core-js/stage/1":["esnext.aggregate-error","esnext.array.is-template-object","esnext.array.last-index","esnext.array.last-item","esnext.async-iterator.constructor","esnext.async-iterator.drop","esnext.async-iterator.filter","esnext.async-iterator.from","esnext.async-iterator.map","esnext.async-iterator.take","esnext.async-iterator.to-array","esnext.composite-key","esnext.composite-symbol","esnext.global-this","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","esnext.iterator.drop","esnext.iterator.every","esnext.iterator.filter","esnext.iterator.find","esnext.iterator.for-each","esnext.iterator.from","esnext.iterator.map","esnext.iterator.reduce","esnext.iterator.some","esnext.iterator.take","esnext.iterator.to-array","esnext.map.delete-all","esnext.map.every","esnext.map.filter","esnext.map.find","esnext.map.find-key","esnext.map.from","esnext.map.group-by","esnext.map.includes","esnext.map.key-by","esnext.map.key-of","esnext.map.map-keys","esnext.map.map-values","esnext.map.merge","esnext.map.of","esnext.map.reduce","esnext.map.some","esnext.map.update","esnext.map.update-or-insert","esnext.map.upsert","esnext.math.clamp","esnext.math.deg-per-rad","esnext.math.degrees","esnext.math.fscale","esnext.math.rad-per-deg","esnext.math.radians","esnext.math.scale","esnext.math.seeded-prng","esnext.math.signbit","esnext.number.from-string","esnext.observable","esnext.promise.all-settled","esnext.promise.any","esnext.promise.try","esnext.set.add-all","esnext.set.delete-all","esnext.set.difference","esnext.set.every","esnext.set.filter","esnext.set.find","esnext.set.from","esnext.set.intersection","esnext.set.is-disjoint-from","esnext.set.is-subset-of","esnext.set.is-superset-of","esnext.set.join","esnext.set.map","esnext.set.of","esnext.set.reduce","esnext.set.some","esnext.set.symmetric-difference","esnext.set.union","esnext.string.code-points","esnext.string.match-all","esnext.string.replace-all","esnext.symbol.async-dispose","esnext.symbol.dispose","esnext.symbol.observable","esnext.symbol.pattern-match","esnext.symbol.replace-all","esnext.weak-map.delete-all","esnext.weak-map.from","esnext.weak-map.of","esnext.weak-map.upsert","esnext.weak-set.add-all","esnext.weak-set.delete-all","esnext.weak-set.from","esnext.weak-set.of"],"core-js/stage/2":["esnext.aggregate-error","esnext.array.is-template-object","esnext.async-iterator.constructor","esnext.async-iterator.drop","esnext.async-iterator.filter","esnext.async-iterator.from","esnext.async-iterator.map","esnext.async-iterator.take","esnext.async-iterator.to-array","esnext.global-this","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","esnext.iterator.drop","esnext.iterator.every","esnext.iterator.filter","esnext.iterator.find","esnext.iterator.for-each","esnext.iterator.from","esnext.iterator.map","esnext.iterator.reduce","esnext.iterator.some","esnext.iterator.take","esnext.iterator.to-array","esnext.map.update-or-insert","esnext.map.upsert","esnext.promise.all-settled","esnext.promise.any","esnext.set.difference","esnext.set.intersection","esnext.set.is-disjoint-from","esnext.set.is-subset-of","esnext.set.is-superset-of","esnext.set.symmetric-difference","esnext.set.union","esnext.string.match-all","esnext.string.replace-all","esnext.symbol.async-dispose","esnext.symbol.dispose","esnext.symbol.replace-all","esnext.weak-map.upsert"],"core-js/stage/3":["esnext.aggregate-error","esnext.global-this","esnext.promise.all-settled","esnext.promise.any","esnext.string.match-all","esnext.string.replace-all","esnext.symbol.replace-all"],"core-js/stage/4":["esnext.global-this","esnext.promise.all-settled","esnext.string.match-all"],"core-js/stage":["esnext.aggregate-error","esnext.array.is-template-object","esnext.array.last-index","esnext.array.last-item","esnext.async-iterator.constructor","esnext.async-iterator.drop","esnext.async-iterator.filter","esnext.async-iterator.from","esnext.async-iterator.map","esnext.async-iterator.take","esnext.async-iterator.to-array","esnext.composite-key","esnext.composite-symbol","esnext.global-this","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","esnext.iterator.drop","esnext.iterator.every","esnext.iterator.filter","esnext.iterator.find","esnext.iterator.for-each","esnext.iterator.from","esnext.iterator.map","esnext.iterator.reduce","esnext.iterator.some","esnext.iterator.take","esnext.iterator.to-array","esnext.map.delete-all","esnext.map.every","esnext.map.filter","esnext.map.find","esnext.map.find-key","esnext.map.from","esnext.map.group-by","esnext.map.includes","esnext.map.key-by","esnext.map.key-of","esnext.map.map-keys","esnext.map.map-values","esnext.map.merge","esnext.map.of","esnext.map.reduce","esnext.map.some","esnext.map.update","esnext.map.update-or-insert","esnext.map.upsert","esnext.math.clamp","esnext.math.deg-per-rad","esnext.math.degrees","esnext.math.fscale","esnext.math.iaddh","esnext.math.imulh","esnext.math.isubh","esnext.math.rad-per-deg","esnext.math.radians","esnext.math.scale","esnext.math.seeded-prng","esnext.math.signbit","esnext.math.umulh","esnext.number.from-string","esnext.observable","esnext.promise.all-settled","esnext.promise.any","esnext.promise.try","esnext.reflect.define-metadata","esnext.reflect.delete-metadata","esnext.reflect.get-metadata","esnext.reflect.get-metadata-keys","esnext.reflect.get-own-metadata","esnext.reflect.get-own-metadata-keys","esnext.reflect.has-metadata","esnext.reflect.has-own-metadata","esnext.reflect.metadata","esnext.set.add-all","esnext.set.delete-all","esnext.set.difference","esnext.set.every","esnext.set.filter","esnext.set.find","esnext.set.from","esnext.set.intersection","esnext.set.is-disjoint-from","esnext.set.is-subset-of","esnext.set.is-superset-of","esnext.set.join","esnext.set.map","esnext.set.of","esnext.set.reduce","esnext.set.some","esnext.set.symmetric-difference","esnext.set.union","esnext.string.at","esnext.string.code-points","esnext.string.match-all","esnext.string.replace-all","esnext.symbol.async-dispose","esnext.symbol.dispose","esnext.symbol.observable","esnext.symbol.pattern-match","esnext.symbol.replace-all","esnext.weak-map.delete-all","esnext.weak-map.from","esnext.weak-map.of","esnext.weak-map.upsert","esnext.weak-set.add-all","esnext.weak-set.delete-all","esnext.weak-set.from","esnext.weak-set.of","web.url","web.url.to-json","web.url-search-params"],"core-js/stage/pre":["esnext.aggregate-error","esnext.array.is-template-object","esnext.array.last-index","esnext.array.last-item","esnext.async-iterator.constructor","esnext.async-iterator.drop","esnext.async-iterator.filter","esnext.async-iterator.from","esnext.async-iterator.map","esnext.async-iterator.take","esnext.async-iterator.to-array","esnext.composite-key","esnext.composite-symbol","esnext.global-this","esnext.iterator.constructor","esnext.iterator.as-indexed-pairs","esnext.iterator.drop","esnext.iterator.every","esnext.iterator.filter","esnext.iterator.find","esnext.iterator.for-each","esnext.iterator.from","esnext.iterator.map","esnext.iterator.reduce","esnext.iterator.some","esnext.iterator.take","esnext.iterator.to-array","esnext.map.delete-all","esnext.map.every","esnext.map.filter","esnext.map.find","esnext.map.find-key","esnext.map.from","esnext.map.group-by","esnext.map.includes","esnext.map.key-by","esnext.map.key-of","esnext.map.map-keys","esnext.map.map-values","esnext.map.merge","esnext.map.of","esnext.map.reduce","esnext.map.some","esnext.map.update","esnext.map.update-or-insert","esnext.map.upsert","esnext.math.clamp","esnext.math.deg-per-rad","esnext.math.degrees","esnext.math.fscale","esnext.math.iaddh","esnext.math.imulh","esnext.math.isubh","esnext.math.rad-per-deg","esnext.math.radians","esnext.math.scale","esnext.math.seeded-prng","esnext.math.signbit","esnext.math.umulh","esnext.number.from-string","esnext.observable","esnext.promise.all-settled","esnext.promise.any","esnext.promise.try","esnext.reflect.define-metadata","esnext.reflect.delete-metadata","esnext.reflect.get-metadata","esnext.reflect.get-metadata-keys","esnext.reflect.get-own-metadata","esnext.reflect.get-own-metadata-keys","esnext.reflect.has-metadata","esnext.reflect.has-own-metadata","esnext.reflect.metadata","esnext.set.add-all","esnext.set.delete-all","esnext.set.difference","esnext.set.every","esnext.set.filter","esnext.set.find","esnext.set.from","esnext.set.intersection","esnext.set.is-disjoint-from","esnext.set.is-subset-of","esnext.set.is-superset-of","esnext.set.join","esnext.set.map","esnext.set.of","esnext.set.reduce","esnext.set.some","esnext.set.symmetric-difference","esnext.set.union","esnext.string.at","esnext.string.code-points","esnext.string.match-all","esnext.string.replace-all","esnext.symbol.async-dispose","esnext.symbol.dispose","esnext.symbol.observable","esnext.symbol.pattern-match","esnext.symbol.replace-all","esnext.weak-map.delete-all","esnext.weak-map.from","esnext.weak-map.of","esnext.weak-map.upsert","esnext.weak-set.add-all","esnext.weak-set.delete-all","esnext.weak-set.from","esnext.weak-set.of","web.url","web.url.to-json","web.url-search-params"],"core-js/web/dom-collections":["web.dom-collections.for-each","web.dom-collections.iterator"],"core-js/web/immediate":["web.immediate"],"core-js/web":["web.dom-collections.for-each","web.dom-collections.iterator","web.immediate","web.queue-microtask","web.timers","web.url","web.url.to-json","web.url-search-params"],"core-js/web/queue-microtask":["web.queue-microtask"],"core-js/web/timers":["web.timers"],"core-js/web/url-search-params":["web.url-search-params"],"core-js/web/url":["web.url","web.url.to-json","web.url-search-params"],"core-js/modules/es.array-buffer.constructor":["es.array-buffer.constructor"],"core-js/modules/es.array-buffer.is-view":["es.array-buffer.is-view"],"core-js/modules/es.array-buffer.slice":["es.array-buffer.slice"],"core-js/modules/es.array.concat":["es.array.concat"],"core-js/modules/es.array.copy-within":["es.array.copy-within"],"core-js/modules/es.array.every":["es.array.every"],"core-js/modules/es.array.fill":["es.array.fill"],"core-js/modules/es.array.filter":["es.array.filter"],"core-js/modules/es.array.find-index":["es.array.find-index"],"core-js/modules/es.array.find":["es.array.find"],"core-js/modules/es.array.flat-map":["es.array.flat-map"],"core-js/modules/es.array.flat":["es.array.flat"],"core-js/modules/es.array.for-each":["es.array.for-each"],"core-js/modules/es.array.from":["es.array.from"],"core-js/modules/es.array.includes":["es.array.includes"],"core-js/modules/es.array.index-of":["es.array.index-of"],"core-js/modules/es.array.is-array":["es.array.is-array"],"core-js/modules/es.array.iterator":["es.array.iterator"],"core-js/modules/es.array.join":["es.array.join"],"core-js/modules/es.array.last-index-of":["es.array.last-index-of"],"core-js/modules/es.array.map":["es.array.map"],"core-js/modules/es.array.of":["es.array.of"],"core-js/modules/es.array.reduce-right":["es.array.reduce-right"],"core-js/modules/es.array.reduce":["es.array.reduce"],"core-js/modules/es.array.reverse":["es.array.reverse"],"core-js/modules/es.array.slice":["es.array.slice"],"core-js/modules/es.array.some":["es.array.some"],"core-js/modules/es.array.sort":["es.array.sort"],"core-js/modules/es.array.species":["es.array.species"],"core-js/modules/es.array.splice":["es.array.splice"],"core-js/modules/es.array.unscopables.flat-map":["es.array.unscopables.flat-map"],"core-js/modules/es.array.unscopables.flat":["es.array.unscopables.flat"],"core-js/modules/es.data-view":["es.data-view"],"core-js/modules/es.date.now":["es.date.now"],"core-js/modules/es.date.to-iso-string":["es.date.to-iso-string"],"core-js/modules/es.date.to-json":["es.date.to-json"],"core-js/modules/es.date.to-primitive":["es.date.to-primitive"],"core-js/modules/es.date.to-string":["es.date.to-string"],"core-js/modules/es.function.bind":["es.function.bind"],"core-js/modules/es.function.has-instance":["es.function.has-instance"],"core-js/modules/es.function.name":["es.function.name"],"core-js/modules/es.global-this":["es.global-this"],"core-js/modules/es.json.stringify":["es.json.stringify"],"core-js/modules/es.json.to-string-tag":["es.json.to-string-tag"],"core-js/modules/es.map":["es.map"],"core-js/modules/es.math.acosh":["es.math.acosh"],"core-js/modules/es.math.asinh":["es.math.asinh"],"core-js/modules/es.math.atanh":["es.math.atanh"],"core-js/modules/es.math.cbrt":["es.math.cbrt"],"core-js/modules/es.math.clz32":["es.math.clz32"],"core-js/modules/es.math.cosh":["es.math.cosh"],"core-js/modules/es.math.expm1":["es.math.expm1"],"core-js/modules/es.math.fround":["es.math.fround"],"core-js/modules/es.math.hypot":["es.math.hypot"],"core-js/modules/es.math.imul":["es.math.imul"],"core-js/modules/es.math.log10":["es.math.log10"],"core-js/modules/es.math.log1p":["es.math.log1p"],"core-js/modules/es.math.log2":["es.math.log2"],"core-js/modules/es.math.sign":["es.math.sign"],"core-js/modules/es.math.sinh":["es.math.sinh"],"core-js/modules/es.math.tanh":["es.math.tanh"],"core-js/modules/es.math.to-string-tag":["es.math.to-string-tag"],"core-js/modules/es.math.trunc":["es.math.trunc"],"core-js/modules/es.number.constructor":["es.number.constructor"],"core-js/modules/es.number.epsilon":["es.number.epsilon"],"core-js/modules/es.number.is-finite":["es.number.is-finite"],"core-js/modules/es.number.is-integer":["es.number.is-integer"],"core-js/modules/es.number.is-nan":["es.number.is-nan"],"core-js/modules/es.number.is-safe-integer":["es.number.is-safe-integer"],"core-js/modules/es.number.max-safe-integer":["es.number.max-safe-integer"],"core-js/modules/es.number.min-safe-integer":["es.number.min-safe-integer"],"core-js/modules/es.number.parse-float":["es.number.parse-float"],"core-js/modules/es.number.parse-int":["es.number.parse-int"],"core-js/modules/es.number.to-fixed":["es.number.to-fixed"],"core-js/modules/es.number.to-precision":["es.number.to-precision"],"core-js/modules/es.object.assign":["es.object.assign"],"core-js/modules/es.object.create":["es.object.create"],"core-js/modules/es.object.define-getter":["es.object.define-getter"],"core-js/modules/es.object.define-properties":["es.object.define-properties"],"core-js/modules/es.object.define-property":["es.object.define-property"],"core-js/modules/es.object.define-setter":["es.object.define-setter"],"core-js/modules/es.object.entries":["es.object.entries"],"core-js/modules/es.object.freeze":["es.object.freeze"],"core-js/modules/es.object.from-entries":["es.object.from-entries"],"core-js/modules/es.object.get-own-property-descriptor":["es.object.get-own-property-descriptor"],"core-js/modules/es.object.get-own-property-descriptors":["es.object.get-own-property-descriptors"],"core-js/modules/es.object.get-own-property-names":["es.object.get-own-property-names"],"core-js/modules/es.object.get-prototype-of":["es.object.get-prototype-of"],"core-js/modules/es.object.is-extensible":["es.object.is-extensible"],"core-js/modules/es.object.is-frozen":["es.object.is-frozen"],"core-js/modules/es.object.is-sealed":["es.object.is-sealed"],"core-js/modules/es.object.is":["es.object.is"],"core-js/modules/es.object.keys":["es.object.keys"],"core-js/modules/es.object.lookup-getter":["es.object.lookup-getter"],"core-js/modules/es.object.lookup-setter":["es.object.lookup-setter"],"core-js/modules/es.object.prevent-extensions":["es.object.prevent-extensions"],"core-js/modules/es.object.seal":["es.object.seal"],"core-js/modules/es.object.set-prototype-of":["es.object.set-prototype-of"],"core-js/modules/es.object.to-string":["es.object.to-string"],"core-js/modules/es.object.values":["es.object.values"],"core-js/modules/es.parse-float":["es.parse-float"],"core-js/modules/es.parse-int":["es.parse-int"],"core-js/modules/es.promise.all-settled":["es.promise.all-settled"],"core-js/modules/es.promise.finally":["es.promise.finally"],"core-js/modules/es.promise":["es.promise"],"core-js/modules/es.reflect.apply":["es.reflect.apply"],"core-js/modules/es.reflect.construct":["es.reflect.construct"],"core-js/modules/es.reflect.define-property":["es.reflect.define-property"],"core-js/modules/es.reflect.delete-property":["es.reflect.delete-property"],"core-js/modules/es.reflect.get-own-property-descriptor":["es.reflect.get-own-property-descriptor"],"core-js/modules/es.reflect.get-prototype-of":["es.reflect.get-prototype-of"],"core-js/modules/es.reflect.get":["es.reflect.get"],"core-js/modules/es.reflect.has":["es.reflect.has"],"core-js/modules/es.reflect.is-extensible":["es.reflect.is-extensible"],"core-js/modules/es.reflect.own-keys":["es.reflect.own-keys"],"core-js/modules/es.reflect.prevent-extensions":["es.reflect.prevent-extensions"],"core-js/modules/es.reflect.set-prototype-of":["es.reflect.set-prototype-of"],"core-js/modules/es.reflect.set":["es.reflect.set"],"core-js/modules/es.regexp.constructor":["es.regexp.constructor"],"core-js/modules/es.regexp.exec":["es.regexp.exec"],"core-js/modules/es.regexp.flags":["es.regexp.flags"],"core-js/modules/es.regexp.to-string":["es.regexp.to-string"],"core-js/modules/es.set":["es.set"],"core-js/modules/es.string.anchor":["es.string.anchor"],"core-js/modules/es.string.big":["es.string.big"],"core-js/modules/es.string.blink":["es.string.blink"],"core-js/modules/es.string.bold":["es.string.bold"],"core-js/modules/es.string.code-point-at":["es.string.code-point-at"],"core-js/modules/es.string.ends-with":["es.string.ends-with"],"core-js/modules/es.string.fixed":["es.string.fixed"],"core-js/modules/es.string.fontcolor":["es.string.fontcolor"],"core-js/modules/es.string.fontsize":["es.string.fontsize"],"core-js/modules/es.string.from-code-point":["es.string.from-code-point"],"core-js/modules/es.string.includes":["es.string.includes"],"core-js/modules/es.string.italics":["es.string.italics"],"core-js/modules/es.string.iterator":["es.string.iterator"],"core-js/modules/es.string.link":["es.string.link"],"core-js/modules/es.string.match-all":["es.string.match-all"],"core-js/modules/es.string.match":["es.string.match"],"core-js/modules/es.string.pad-end":["es.string.pad-end"],"core-js/modules/es.string.pad-start":["es.string.pad-start"],"core-js/modules/es.string.raw":["es.string.raw"],"core-js/modules/es.string.repeat":["es.string.repeat"],"core-js/modules/es.string.replace":["es.string.replace"],"core-js/modules/es.string.search":["es.string.search"],"core-js/modules/es.string.small":["es.string.small"],"core-js/modules/es.string.split":["es.string.split"],"core-js/modules/es.string.starts-with":["es.string.starts-with"],"core-js/modules/es.string.strike":["es.string.strike"],"core-js/modules/es.string.sub":["es.string.sub"],"core-js/modules/es.string.sup":["es.string.sup"],"core-js/modules/es.string.trim-end":["es.string.trim-end"],"core-js/modules/es.string.trim-start":["es.string.trim-start"],"core-js/modules/es.string.trim":["es.string.trim"],"core-js/modules/es.symbol.async-iterator":["es.symbol.async-iterator"],"core-js/modules/es.symbol.description":["es.symbol.description"],"core-js/modules/es.symbol.has-instance":["es.symbol.has-instance"],"core-js/modules/es.symbol.is-concat-spreadable":["es.symbol.is-concat-spreadable"],"core-js/modules/es.symbol.iterator":["es.symbol.iterator"],"core-js/modules/es.symbol":["es.symbol"],"core-js/modules/es.symbol.match-all":["es.symbol.match-all"],"core-js/modules/es.symbol.match":["es.symbol.match"],"core-js/modules/es.symbol.replace":["es.symbol.replace"],"core-js/modules/es.symbol.search":["es.symbol.search"],"core-js/modules/es.symbol.species":["es.symbol.species"],"core-js/modules/es.symbol.split":["es.symbol.split"],"core-js/modules/es.symbol.to-primitive":["es.symbol.to-primitive"],"core-js/modules/es.symbol.to-string-tag":["es.symbol.to-string-tag"],"core-js/modules/es.symbol.unscopables":["es.symbol.unscopables"],"core-js/modules/es.typed-array.copy-within":["es.typed-array.copy-within"],"core-js/modules/es.typed-array.every":["es.typed-array.every"],"core-js/modules/es.typed-array.fill":["es.typed-array.fill"],"core-js/modules/es.typed-array.filter":["es.typed-array.filter"],"core-js/modules/es.typed-array.find-index":["es.typed-array.find-index"],"core-js/modules/es.typed-array.find":["es.typed-array.find"],"core-js/modules/es.typed-array.float32-array":["es.typed-array.float32-array"],"core-js/modules/es.typed-array.float64-array":["es.typed-array.float64-array"],"core-js/modules/es.typed-array.for-each":["es.typed-array.for-each"],"core-js/modules/es.typed-array.from":["es.typed-array.from"],"core-js/modules/es.typed-array.includes":["es.typed-array.includes"],"core-js/modules/es.typed-array.index-of":["es.typed-array.index-of"],"core-js/modules/es.typed-array.int16-array":["es.typed-array.int16-array"],"core-js/modules/es.typed-array.int32-array":["es.typed-array.int32-array"],"core-js/modules/es.typed-array.int8-array":["es.typed-array.int8-array"],"core-js/modules/es.typed-array.iterator":["es.typed-array.iterator"],"core-js/modules/es.typed-array.join":["es.typed-array.join"],"core-js/modules/es.typed-array.last-index-of":["es.typed-array.last-index-of"],"core-js/modules/es.typed-array.map":["es.typed-array.map"],"core-js/modules/es.typed-array.of":["es.typed-array.of"],"core-js/modules/es.typed-array.reduce-right":["es.typed-array.reduce-right"],"core-js/modules/es.typed-array.reduce":["es.typed-array.reduce"],"core-js/modules/es.typed-array.reverse":["es.typed-array.reverse"],"core-js/modules/es.typed-array.set":["es.typed-array.set"],"core-js/modules/es.typed-array.slice":["es.typed-array.slice"],"core-js/modules/es.typed-array.some":["es.typed-array.some"],"core-js/modules/es.typed-array.sort":["es.typed-array.sort"],"core-js/modules/es.typed-array.subarray":["es.typed-array.subarray"],"core-js/modules/es.typed-array.to-locale-string":["es.typed-array.to-locale-string"],"core-js/modules/es.typed-array.to-string":["es.typed-array.to-string"],"core-js/modules/es.typed-array.uint16-array":["es.typed-array.uint16-array"],"core-js/modules/es.typed-array.uint32-array":["es.typed-array.uint32-array"],"core-js/modules/es.typed-array.uint8-array":["es.typed-array.uint8-array"],"core-js/modules/es.typed-array.uint8-clamped-array":["es.typed-array.uint8-clamped-array"],"core-js/modules/es.weak-map":["es.weak-map"],"core-js/modules/es.weak-set":["es.weak-set"],"core-js/modules/esnext.aggregate-error":["esnext.aggregate-error"],"core-js/modules/esnext.array.is-template-object":["esnext.array.is-template-object"],"core-js/modules/esnext.array.last-index":["esnext.array.last-index"],"core-js/modules/esnext.array.last-item":["esnext.array.last-item"],"core-js/modules/esnext.async-iterator.as-indexed-pairs":["esnext.async-iterator.as-indexed-pairs"],"core-js/modules/esnext.async-iterator.constructor":["esnext.async-iterator.constructor"],"core-js/modules/esnext.async-iterator.drop":["esnext.async-iterator.drop"],"core-js/modules/esnext.async-iterator.every":["esnext.async-iterator.every"],"core-js/modules/esnext.async-iterator.filter":["esnext.async-iterator.filter"],"core-js/modules/esnext.async-iterator.find":["esnext.async-iterator.find"],"core-js/modules/esnext.async-iterator.flat-map":["esnext.async-iterator.flat-map"],"core-js/modules/esnext.async-iterator.for-each":["esnext.async-iterator.for-each"],"core-js/modules/esnext.async-iterator.from":["esnext.async-iterator.from"],"core-js/modules/esnext.async-iterator.map":["esnext.async-iterator.map"],"core-js/modules/esnext.async-iterator.reduce":["esnext.async-iterator.reduce"],"core-js/modules/esnext.async-iterator.some":["esnext.async-iterator.some"],"core-js/modules/esnext.async-iterator.take":["esnext.async-iterator.take"],"core-js/modules/esnext.async-iterator.to-array":["esnext.async-iterator.to-array"],"core-js/modules/esnext.composite-key":["esnext.composite-key"],"core-js/modules/esnext.composite-symbol":["esnext.composite-symbol"],"core-js/modules/esnext.global-this":["esnext.global-this"],"core-js/modules/esnext.iterator.as-indexed-pairs":["esnext.iterator.as-indexed-pairs"],"core-js/modules/esnext.iterator.constructor":["esnext.iterator.constructor"],"core-js/modules/esnext.iterator.drop":["esnext.iterator.drop"],"core-js/modules/esnext.iterator.every":["esnext.iterator.every"],"core-js/modules/esnext.iterator.filter":["esnext.iterator.filter"],"core-js/modules/esnext.iterator.find":["esnext.iterator.find"],"core-js/modules/esnext.iterator.flat-map":["esnext.iterator.flat-map"],"core-js/modules/esnext.iterator.for-each":["esnext.iterator.for-each"],"core-js/modules/esnext.iterator.from":["esnext.iterator.from"],"core-js/modules/esnext.iterator.map":["esnext.iterator.map"],"core-js/modules/esnext.iterator.reduce":["esnext.iterator.reduce"],"core-js/modules/esnext.iterator.some":["esnext.iterator.some"],"core-js/modules/esnext.iterator.take":["esnext.iterator.take"],"core-js/modules/esnext.iterator.to-array":["esnext.iterator.to-array"],"core-js/modules/esnext.map.delete-all":["esnext.map.delete-all"],"core-js/modules/esnext.map.every":["esnext.map.every"],"core-js/modules/esnext.map.filter":["esnext.map.filter"],"core-js/modules/esnext.map.find-key":["esnext.map.find-key"],"core-js/modules/esnext.map.find":["esnext.map.find"],"core-js/modules/esnext.map.from":["esnext.map.from"],"core-js/modules/esnext.map.group-by":["esnext.map.group-by"],"core-js/modules/esnext.map.includes":["esnext.map.includes"],"core-js/modules/esnext.map.key-by":["esnext.map.key-by"],"core-js/modules/esnext.map.key-of":["esnext.map.key-of"],"core-js/modules/esnext.map.map-keys":["esnext.map.map-keys"],"core-js/modules/esnext.map.map-values":["esnext.map.map-values"],"core-js/modules/esnext.map.merge":["esnext.map.merge"],"core-js/modules/esnext.map.of":["esnext.map.of"],"core-js/modules/esnext.map.reduce":["esnext.map.reduce"],"core-js/modules/esnext.map.some":["esnext.map.some"],"core-js/modules/esnext.map.update-or-insert":["esnext.map.update-or-insert"],"core-js/modules/esnext.map.update":["esnext.map.update"],"core-js/modules/esnext.map.upsert":["esnext.map.upsert"],"core-js/modules/esnext.math.clamp":["esnext.math.clamp"],"core-js/modules/esnext.math.deg-per-rad":["esnext.math.deg-per-rad"],"core-js/modules/esnext.math.degrees":["esnext.math.degrees"],"core-js/modules/esnext.math.fscale":["esnext.math.fscale"],"core-js/modules/esnext.math.iaddh":["esnext.math.iaddh"],"core-js/modules/esnext.math.imulh":["esnext.math.imulh"],"core-js/modules/esnext.math.isubh":["esnext.math.isubh"],"core-js/modules/esnext.math.rad-per-deg":["esnext.math.rad-per-deg"],"core-js/modules/esnext.math.radians":["esnext.math.radians"],"core-js/modules/esnext.math.scale":["esnext.math.scale"],"core-js/modules/esnext.math.seeded-prng":["esnext.math.seeded-prng"],"core-js/modules/esnext.math.signbit":["esnext.math.signbit"],"core-js/modules/esnext.math.umulh":["esnext.math.umulh"],"core-js/modules/esnext.number.from-string":["esnext.number.from-string"],"core-js/modules/esnext.observable":["esnext.observable"],"core-js/modules/esnext.promise.all-settled":["esnext.promise.all-settled"],"core-js/modules/esnext.promise.any":["esnext.promise.any"],"core-js/modules/esnext.promise.try":["esnext.promise.try"],"core-js/modules/esnext.reflect.define-metadata":["esnext.reflect.define-metadata"],"core-js/modules/esnext.reflect.delete-metadata":["esnext.reflect.delete-metadata"],"core-js/modules/esnext.reflect.get-metadata-keys":["esnext.reflect.get-metadata-keys"],"core-js/modules/esnext.reflect.get-metadata":["esnext.reflect.get-metadata"],"core-js/modules/esnext.reflect.get-own-metadata-keys":["esnext.reflect.get-own-metadata-keys"],"core-js/modules/esnext.reflect.get-own-metadata":["esnext.reflect.get-own-metadata"],"core-js/modules/esnext.reflect.has-metadata":["esnext.reflect.has-metadata"],"core-js/modules/esnext.reflect.has-own-metadata":["esnext.reflect.has-own-metadata"],"core-js/modules/esnext.reflect.metadata":["esnext.reflect.metadata"],"core-js/modules/esnext.set.add-all":["esnext.set.add-all"],"core-js/modules/esnext.set.delete-all":["esnext.set.delete-all"],"core-js/modules/esnext.set.difference":["esnext.set.difference"],"core-js/modules/esnext.set.every":["esnext.set.every"],"core-js/modules/esnext.set.filter":["esnext.set.filter"],"core-js/modules/esnext.set.find":["esnext.set.find"],"core-js/modules/esnext.set.from":["esnext.set.from"],"core-js/modules/esnext.set.intersection":["esnext.set.intersection"],"core-js/modules/esnext.set.is-disjoint-from":["esnext.set.is-disjoint-from"],"core-js/modules/esnext.set.is-subset-of":["esnext.set.is-subset-of"],"core-js/modules/esnext.set.is-superset-of":["esnext.set.is-superset-of"],"core-js/modules/esnext.set.join":["esnext.set.join"],"core-js/modules/esnext.set.map":["esnext.set.map"],"core-js/modules/esnext.set.of":["esnext.set.of"],"core-js/modules/esnext.set.reduce":["esnext.set.reduce"],"core-js/modules/esnext.set.some":["esnext.set.some"],"core-js/modules/esnext.set.symmetric-difference":["esnext.set.symmetric-difference"],"core-js/modules/esnext.set.union":["esnext.set.union"],"core-js/modules/esnext.string.at":["esnext.string.at"],"core-js/modules/esnext.string.code-points":["esnext.string.code-points"],"core-js/modules/esnext.string.match-all":["esnext.string.match-all"],"core-js/modules/esnext.string.replace-all":["esnext.string.replace-all"],"core-js/modules/esnext.symbol.async-dispose":["esnext.symbol.async-dispose"],"core-js/modules/esnext.symbol.dispose":["esnext.symbol.dispose"],"core-js/modules/esnext.symbol.observable":["esnext.symbol.observable"],"core-js/modules/esnext.symbol.pattern-match":["esnext.symbol.pattern-match"],"core-js/modules/esnext.symbol.replace-all":["esnext.symbol.replace-all"],"core-js/modules/esnext.weak-map.delete-all":["esnext.weak-map.delete-all"],"core-js/modules/esnext.weak-map.from":["esnext.weak-map.from"],"core-js/modules/esnext.weak-map.of":["esnext.weak-map.of"],"core-js/modules/esnext.weak-map.upsert":["esnext.weak-map.upsert"],"core-js/modules/esnext.weak-set.add-all":["esnext.weak-set.add-all"],"core-js/modules/esnext.weak-set.delete-all":["esnext.weak-set.delete-all"],"core-js/modules/esnext.weak-set.from":["esnext.weak-set.from"],"core-js/modules/esnext.weak-set.of":["esnext.weak-set.of"],"core-js/modules/web.dom-collections.for-each":["web.dom-collections.for-each"],"core-js/modules/web.dom-collections.iterator":["web.dom-collections.iterator"],"core-js/modules/web.immediate":["web.immediate"],"core-js/modules/web.queue-microtask":["web.queue-microtask"],"core-js/modules/web.timers":["web.timers"],"core-js/modules/web.url-search-params":["web.url-search-params"],"core-js/modules/web.url":["web.url"],"core-js/modules/web.url.to-json":["web.url.to-json"]};

/***/ }),
/* 340 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isPlaceholderType;

var _definitions = __webpack_require__(288);

function isPlaceholderType(placeholderType, targetType) {
  if (placeholderType === targetType) return true;
  const aliases = _definitions.PLACEHOLDERS_ALIAS[placeholderType];

  if (aliases) {
    for (const alias of aliases) {
      if (targetType === alias) return true;
    }
  }

  return false;
}

/***/ }),
/* 341 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseFor = __webpack_require__(843),
    keys = __webpack_require__(863);

/**
 * The base implementation of `_.forOwn` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Object} Returns `object`.
 */
function baseForOwn(object, iteratee) {
  return object && baseFor(object, iteratee, keys);
}

module.exports = baseForOwn;


/***/ }),
/* 342 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseGet = __webpack_require__(147);

/**
 * Gets the value at `path` of `object`. If the resolved value is
 * `undefined`, the `defaultValue` is returned in its place.
 *
 * @static
 * @memberOf _
 * @since 3.7.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
 * @returns {*} Returns the resolved value.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.get(object, 'a[0].b.c');
 * // => 3
 *
 * _.get(object, ['a', '0', 'b', 'c']);
 * // => 3
 *
 * _.get(object, 'a.b.c', 'default');
 * // => 'default'
 */
function get(object, path, defaultValue) {
  var result = object == null ? undefined : baseGet(object, path);
  return result === undefined ? defaultValue : result;
}

module.exports = get;


/***/ }),
/* 343 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var isKeyable = __webpack_require__(633);

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

module.exports = getMapData;


/***/ }),
/* 344 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isInteger = _interopRequireDefault(__webpack_require__(550));

var _repeat = _interopRequireDefault(__webpack_require__(258));

var _buffer = _interopRequireDefault(__webpack_require__(677));

var n = _interopRequireWildcard(__webpack_require__(582));

var t = _interopRequireWildcard(__webpack_require__(978));

var generatorFunctions = _interopRequireWildcard(__webpack_require__(657));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const SCIENTIFIC_NOTATION = /e/i;
const ZERO_DECIMAL_INTEGER = /\.0+$/;
const NON_DECIMAL_LITERAL = /^0[box]/;

class Printer {
  constructor(format, map) {
    this.inForStatementInitCounter = 0;
    this._printStack = [];
    this._indent = 0;
    this._insideAux = false;
    this._printedCommentStarts = {};
    this._parenPushNewlineState = null;
    this._noLineTerminator = false;
    this._printAuxAfterOnNextUserNode = false;
    this._printedComments = new WeakSet();
    this._endsWithInteger = false;
    this._endsWithWord = false;
    this.format = format || {};
    this._buf = new _buffer.default(map);
  }

  generate(ast) {
    this.print(ast);

    this._maybeAddAuxComment();

    return this._buf.get();
  }

  indent() {
    if (this.format.compact || this.format.concise) return;
    this._indent++;
  }

  dedent() {
    if (this.format.compact || this.format.concise) return;
    this._indent--;
  }

  semicolon(force = false) {
    this._maybeAddAuxComment();

    this._append(";", !force);
  }

  rightBrace() {
    if (this.format.minified) {
      this._buf.removeLastSemicolon();
    }

    this.token("}");
  }

  space(force = false) {
    if (this.format.compact) return;

    if (this._buf.hasContent() && !this.endsWith(" ") && !this.endsWith("\n") || force) {
      this._space();
    }
  }

  word(str) {
    if (this._endsWithWord || this.endsWith("/") && str.indexOf("/") === 0) {
      this._space();
    }

    this._maybeAddAuxComment();

    this._append(str);

    this._endsWithWord = true;
  }

  number(str) {
    this.word(str);
    this._endsWithInteger = (0, _isInteger.default)(+str) && !NON_DECIMAL_LITERAL.test(str) && !SCIENTIFIC_NOTATION.test(str) && !ZERO_DECIMAL_INTEGER.test(str) && str[str.length - 1] !== ".";
  }

  token(str) {
    if (str === "--" && this.endsWith("!") || str[0] === "+" && this.endsWith("+") || str[0] === "-" && this.endsWith("-") || str[0] === "." && this._endsWithInteger) {
      this._space();
    }

    this._maybeAddAuxComment();

    this._append(str);
  }

  newline(i) {
    if (this.format.retainLines || this.format.compact) return;

    if (this.format.concise) {
      this.space();
      return;
    }

    if (this.endsWith("\n\n")) return;
    if (typeof i !== "number") i = 1;
    i = Math.min(2, i);
    if (this.endsWith("{\n") || this.endsWith(":\n")) i--;
    if (i <= 0) return;

    for (let j = 0; j < i; j++) {
      this._newline();
    }
  }

  endsWith(str) {
    return this._buf.endsWith(str);
  }

  removeTrailingNewline() {
    this._buf.removeTrailingNewline();
  }

  exactSource(loc, cb) {
    this._catchUp("start", loc);

    this._buf.exactSource(loc, cb);
  }

  source(prop, loc) {
    this._catchUp(prop, loc);

    this._buf.source(prop, loc);
  }

  withSource(prop, loc, cb) {
    this._catchUp(prop, loc);

    this._buf.withSource(prop, loc, cb);
  }

  _space() {
    this._append(" ", true);
  }

  _newline() {
    this._append("\n", true);
  }

  _append(str, queue = false) {
    this._maybeAddParen(str);

    this._maybeIndent(str);

    if (queue) this._buf.queue(str);else this._buf.append(str);
    this._endsWithWord = false;
    this._endsWithInteger = false;
  }

  _maybeIndent(str) {
    if (this._indent && this.endsWith("\n") && str[0] !== "\n") {
      this._buf.queue(this._getIndent());
    }
  }

  _maybeAddParen(str) {
    const parenPushNewlineState = this._parenPushNewlineState;
    if (!parenPushNewlineState) return;
    this._parenPushNewlineState = null;
    let i;

    for (i = 0; i < str.length && str[i] === " "; i++) continue;

    if (i === str.length) return;
    const cha = str[i];

    if (cha !== "\n") {
      if (cha !== "/") return;
      if (i + 1 === str.length) return;
      const chaPost = str[i + 1];
      if (chaPost !== "/" && chaPost !== "*") return;
    }

    this.token("(");
    this.indent();
    parenPushNewlineState.printed = true;
  }

  _catchUp(prop, loc) {
    if (!this.format.retainLines) return;
    const pos = loc ? loc[prop] : null;

    if (pos && pos.line !== null) {
      const count = pos.line - this._buf.getCurrentLine();

      for (let i = 0; i < count; i++) {
        this._newline();
      }
    }
  }

  _getIndent() {
    return (0, _repeat.default)(this.format.indent.style, this._indent);
  }

  startTerminatorless(isLabel = false) {
    if (isLabel) {
      this._noLineTerminator = true;
      return null;
    } else {
      return this._parenPushNewlineState = {
        printed: false
      };
    }
  }

  endTerminatorless(state) {
    this._noLineTerminator = false;

    if (state && state.printed) {
      this.dedent();
      this.newline();
      this.token(")");
    }
  }

  print(node, parent) {
    if (!node) return;
    const oldConcise = this.format.concise;

    if (node._compact) {
      this.format.concise = true;
    }

    const printMethod = this[node.type];

    if (!printMethod) {
      throw new ReferenceError(`unknown node of type ${JSON.stringify(node.type)} with constructor ${JSON.stringify(node && node.constructor.name)}`);
    }

    this._printStack.push(node);

    const oldInAux = this._insideAux;
    this._insideAux = !node.loc;

    this._maybeAddAuxComment(this._insideAux && !oldInAux);

    let needsParens = n.needsParens(node, parent, this._printStack);

    if (this.format.retainFunctionParens && node.type === "FunctionExpression" && node.extra && node.extra.parenthesized) {
      needsParens = true;
    }

    if (needsParens) this.token("(");

    this._printLeadingComments(node);

    const loc = t.isProgram(node) || t.isFile(node) ? null : node.loc;
    this.withSource("start", loc, () => {
      printMethod.call(this, node, parent);
    });

    this._printTrailingComments(node);

    if (needsParens) this.token(")");

    this._printStack.pop();

    this.format.concise = oldConcise;
    this._insideAux = oldInAux;
  }

  _maybeAddAuxComment(enteredPositionlessNode) {
    if (enteredPositionlessNode) this._printAuxBeforeComment();
    if (!this._insideAux) this._printAuxAfterComment();
  }

  _printAuxBeforeComment() {
    if (this._printAuxAfterOnNextUserNode) return;
    this._printAuxAfterOnNextUserNode = true;
    const comment = this.format.auxiliaryCommentBefore;

    if (comment) {
      this._printComment({
        type: "CommentBlock",
        value: comment
      });
    }
  }

  _printAuxAfterComment() {
    if (!this._printAuxAfterOnNextUserNode) return;
    this._printAuxAfterOnNextUserNode = false;
    const comment = this.format.auxiliaryCommentAfter;

    if (comment) {
      this._printComment({
        type: "CommentBlock",
        value: comment
      });
    }
  }

  getPossibleRaw(node) {
    const extra = node.extra;

    if (extra && extra.raw != null && extra.rawValue != null && node.value === extra.rawValue) {
      return extra.raw;
    }
  }

  printJoin(nodes, parent, opts = {}) {
    if (!nodes || !nodes.length) return;
    if (opts.indent) this.indent();
    const newlineOpts = {
      addNewlines: opts.addNewlines
    };

    for (let i = 0; i < nodes.length; i++) {
      const node = nodes[i];
      if (!node) continue;
      if (opts.statement) this._printNewline(true, node, parent, newlineOpts);
      this.print(node, parent);

      if (opts.iterator) {
        opts.iterator(node, i);
      }

      if (opts.separator && i < nodes.length - 1) {
        opts.separator.call(this);
      }

      if (opts.statement) this._printNewline(false, node, parent, newlineOpts);
    }

    if (opts.indent) this.dedent();
  }

  printAndIndentOnComments(node, parent) {
    const indent = node.leadingComments && node.leadingComments.length > 0;
    if (indent) this.indent();
    this.print(node, parent);
    if (indent) this.dedent();
  }

  printBlock(parent) {
    const node = parent.body;

    if (!t.isEmptyStatement(node)) {
      this.space();
    }

    this.print(node, parent);
  }

  _printTrailingComments(node) {
    this._printComments(this._getComments(false, node));
  }

  _printLeadingComments(node) {
    this._printComments(this._getComments(true, node));
  }

  printInnerComments(node, indent = true) {
    if (!node.innerComments || !node.innerComments.length) return;
    if (indent) this.indent();

    this._printComments(node.innerComments);

    if (indent) this.dedent();
  }

  printSequence(nodes, parent, opts = {}) {
    opts.statement = true;
    return this.printJoin(nodes, parent, opts);
  }

  printList(items, parent, opts = {}) {
    if (opts.separator == null) {
      opts.separator = commaSeparator;
    }

    return this.printJoin(items, parent, opts);
  }

  _printNewline(leading, node, parent, opts) {
    if (this.format.retainLines || this.format.compact) return;

    if (this.format.concise) {
      this.space();
      return;
    }

    let lines = 0;

    if (this._buf.hasContent()) {
      if (!leading) lines++;
      if (opts.addNewlines) lines += opts.addNewlines(leading, node) || 0;
      const needs = leading ? n.needsWhitespaceBefore : n.needsWhitespaceAfter;
      if (needs(node, parent)) lines++;
    }

    this.newline(lines);
  }

  _getComments(leading, node) {
    return node && (leading ? node.leadingComments : node.trailingComments) || [];
  }

  _printComment(comment) {
    if (!this.format.shouldPrintComment(comment.value)) return;
    if (comment.ignore) return;
    if (this._printedComments.has(comment)) return;

    this._printedComments.add(comment);

    if (comment.start != null) {
      if (this._printedCommentStarts[comment.start]) return;
      this._printedCommentStarts[comment.start] = true;
    }

    const isBlockComment = comment.type === "CommentBlock";
    this.newline(this._buf.hasContent() && !this._noLineTerminator && isBlockComment ? 1 : 0);
    if (!this.endsWith("[") && !this.endsWith("{")) this.space();
    let val = !isBlockComment && !this._noLineTerminator ? `//${comment.value}\n` : `/*${comment.value}*/`;

    if (isBlockComment && this.format.indent.adjustMultilineComment) {
      const offset = comment.loc && comment.loc.start.column;

      if (offset) {
        const newlineRegex = new RegExp("\\n\\s{1," + offset + "}", "g");
        val = val.replace(newlineRegex, "\n");
      }

      const indentSize = Math.max(this._getIndent().length, this._buf.getCurrentColumn());
      val = val.replace(/\n(?!$)/g, `\n${(0, _repeat.default)(" ", indentSize)}`);
    }

    if (this.endsWith("/")) this._space();
    this.withSource("start", comment.loc, () => {
      this._append(val);
    });
    this.newline(isBlockComment && !this._noLineTerminator ? 1 : 0);
  }

  _printComments(comments) {
    if (!comments || !comments.length) return;

    for (const comment of comments) {
      this._printComment(comment);
    }
  }

}

exports.default = Printer;
Object.assign(Printer.prototype, generatorFunctions);

function commaSeparator() {
  this.token(",");
  this.space();
}

/***/ }),
/* 345 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _helperPluginUtils = __webpack_require__(57);

var _helperRemapAsyncToGenerator = _interopRequireDefault(__webpack_require__(624));

var _pluginSyntaxAsyncGenerators = _interopRequireDefault(__webpack_require__(25));

var _core = __webpack_require__(278);

var _forAwait = _interopRequireDefault(__webpack_require__(47));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = (0, _helperPluginUtils.declare)(api => {
  api.assertVersion(7);
  const yieldStarVisitor = {
    Function(path) {
      path.skip();
    },

    YieldExpression({
      node
    }, state) {
      if (!node.delegate) return;
      const callee = state.addHelper("asyncGeneratorDelegate");
      node.argument = _core.types.callExpression(callee, [_core.types.callExpression(state.addHelper("asyncIterator"), [node.argument]), state.addHelper("awaitAsyncGenerator")]);
    }

  };
  const forAwaitVisitor = {
    Function(path) {
      path.skip();
    },

    ForOfStatement(path, {
      file
    }) {
      const {
        node
      } = path;
      if (!node.await) return;
      const build = (0, _forAwait.default)(path, {
        getAsyncIterator: file.addHelper("asyncIterator")
      });
      const {
        declar,
        loop
      } = build;
      const block = loop.body;
      path.ensureBlock();

      if (declar) {
        block.body.push(declar);
      }

      block.body = block.body.concat(node.body.body);

      _core.types.inherits(loop, node);

      _core.types.inherits(loop.body, node.body);

      if (build.replaceParent) {
        path.parentPath.replaceWithMultiple(build.node);
      } else {
        path.replaceWithMultiple(build.node);
      }
    }

  };
  const visitor = {
    Function(path, state) {
      if (!path.node.async) return;
      path.traverse(forAwaitVisitor, state);
      if (!path.node.generator) return;
      path.traverse(yieldStarVisitor, state);
      (0, _helperRemapAsyncToGenerator.default)(path, {
        wrapAsync: state.addHelper("wrapAsyncGenerator"),
        wrapAwait: state.addHelper("awaitAsyncGenerator")
      });
    }

  };
  return {
    name: "proposal-async-generator-functions",
    inherits: _pluginSyntaxAsyncGenerators.default,
    visitor: {
      Program(path, state) {
        path.traverse(visitor, state);
      }

    }
  };
});

exports.default = _default;

/***/ }),
/* 346 */,
/* 347 */,
/* 348 */
/***/ (function(module) {

/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

module.exports = arrayFilter;


/***/ }),
/* 349 */,
/* 350 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = __webpack_require__(57);

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

function _core() {
  const data = __webpack_require__(278);

  _core = function () {
    return data;
  };

  return data;
}

var _default = (0, _helperPluginUtils().declare)(api => {
  api.assertVersion(7);
  return {
    name: "transform-member-expression-literals",
    visitor: {
      MemberExpression: {
        exit({
          node
        }) {
          const prop = node.property;

          if (!node.computed && _core().types.isIdentifier(prop) && !_core().types.isValidES3Identifier(prop.name)) {
            node.property = _core().types.stringLiteral(prop.name);
            node.computed = true;
          }
        }

      }
    }
  };
});

exports.default = _default;

/***/ }),
/* 351 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var isPrototype = __webpack_require__(514),
    nativeKeys = __webpack_require__(773);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

module.exports = baseKeys;


/***/ }),
/* 352 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isNode;

var _definitions = __webpack_require__(288);

function isNode(node) {
  return !!(node && _definitions.VISITOR_KEYS[node.type]);
}

/***/ }),
/* 353 */
/***/ (function(module) {

"use strict";


let fastProto = null;

// Creates an object with permanently fast properties in V8. See Toon Verwaest's
// post https://medium.com/@tverwaes/setting-up-prototypes-in-v8-ec9c9491dfe2#5f62
// for more details. Use %HasFastProperties(object) and the Node.js flag
// --allow-natives-syntax to check whether an object has fast properties.
function FastObject(o) {
	// A prototype object will have "fast properties" enabled once it is checked
	// against the inline property cache of a function, e.g. fastProto.property:
	// https://github.com/v8/v8/blob/6.0.122/test/mjsunit/fast-prototype.js#L48-L63
	if (fastProto !== null && typeof fastProto.property) {
		const result = fastProto;
		fastProto = FastObject.prototype = null;
		return result;
	}
	fastProto = FastObject.prototype = o == null ? Object.create(null) : o;
	return new FastObject;
}

// Initialize the inline property cache of FastObject
FastObject();

module.exports = function toFastproperties(o) {
	return FastObject(o);
};


/***/ }),
/* 354 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseMatches = __webpack_require__(199),
    baseMatchesProperty = __webpack_require__(728),
    identity = __webpack_require__(83),
    isArray = __webpack_require__(143),
    property = __webpack_require__(631);

/**
 * The base implementation of `_.iteratee`.
 *
 * @private
 * @param {*} [value=_.identity] The value to convert to an iteratee.
 * @returns {Function} Returns the iteratee.
 */
function baseIteratee(value) {
  // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
  // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
  if (typeof value == 'function') {
    return value;
  }
  if (value == null) {
    return identity;
  }
  if (typeof value == 'object') {
    return isArray(value)
      ? baseMatchesProperty(value[0], value[1])
      : baseMatches(value);
  }
  return property(value);
}

module.exports = baseIteratee;


/***/ }),
/* 355 */,
/* 356 */
/***/ (function(__unusedmodule, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.msg = msg;
exports.access = access;
exports.assertRootMode = assertRootMode;
exports.assertSourceMaps = assertSourceMaps;
exports.assertCompact = assertCompact;
exports.assertSourceType = assertSourceType;
exports.assertCallerMetadata = assertCallerMetadata;
exports.assertInputSourceMap = assertInputSourceMap;
exports.assertString = assertString;
exports.assertFunction = assertFunction;
exports.assertBoolean = assertBoolean;
exports.assertObject = assertObject;
exports.assertArray = assertArray;
exports.assertIgnoreList = assertIgnoreList;
exports.assertConfigApplicableTest = assertConfigApplicableTest;
exports.assertConfigFileSearch = assertConfigFileSearch;
exports.assertBabelrcSearch = assertBabelrcSearch;
exports.assertPluginList = assertPluginList;

function msg(loc) {
  switch (loc.type) {
    case "root":
      return ``;

    case "env":
      return `${msg(loc.parent)}.env["${loc.name}"]`;

    case "overrides":
      return `${msg(loc.parent)}.overrides[${loc.index}]`;

    case "option":
      return `${msg(loc.parent)}.${loc.name}`;

    case "access":
      return `${msg(loc.parent)}[${JSON.stringify(loc.name)}]`;

    default:
      throw new Error(`Assertion failure: Unknown type ${loc.type}`);
  }
}

function access(loc, name) {
  return {
    type: "access",
    name,
    parent: loc
  };
}

function assertRootMode(loc, value) {
  if (value !== undefined && value !== "root" && value !== "upward" && value !== "upward-optional") {
    throw new Error(`${msg(loc)} must be a "root", "upward", "upward-optional" or undefined`);
  }

  return value;
}

function assertSourceMaps(loc, value) {
  if (value !== undefined && typeof value !== "boolean" && value !== "inline" && value !== "both") {
    throw new Error(`${msg(loc)} must be a boolean, "inline", "both", or undefined`);
  }

  return value;
}

function assertCompact(loc, value) {
  if (value !== undefined && typeof value !== "boolean" && value !== "auto") {
    throw new Error(`${msg(loc)} must be a boolean, "auto", or undefined`);
  }

  return value;
}

function assertSourceType(loc, value) {
  if (value !== undefined && value !== "module" && value !== "script" && value !== "unambiguous") {
    throw new Error(`${msg(loc)} must be "module", "script", "unambiguous", or undefined`);
  }

  return value;
}

function assertCallerMetadata(loc, value) {
  const obj = assertObject(loc, value);

  if (obj) {
    if (typeof obj["name"] !== "string") {
      throw new Error(`${msg(loc)} set but does not contain "name" property string`);
    }

    for (const prop of Object.keys(obj)) {
      const propLoc = access(loc, prop);
      const value = obj[prop];

      if (value != null && typeof value !== "boolean" && typeof value !== "string" && typeof value !== "number") {
        throw new Error(`${msg(propLoc)} must be null, undefined, a boolean, a string, or a number.`);
      }
    }
  }

  return value;
}

function assertInputSourceMap(loc, value) {
  if (value !== undefined && typeof value !== "boolean" && (typeof value !== "object" || !value)) {
    throw new Error(`${msg(loc)} must be a boolean, object, or undefined`);
  }

  return value;
}

function assertString(loc, value) {
  if (value !== undefined && typeof value !== "string") {
    throw new Error(`${msg(loc)} must be a string, or undefined`);
  }

  return value;
}

function assertFunction(loc, value) {
  if (value !== undefined && typeof value !== "function") {
    throw new Error(`${msg(loc)} must be a function, or undefined`);
  }

  return value;
}

function assertBoolean(loc, value) {
  if (value !== undefined && typeof value !== "boolean") {
    throw new Error(`${msg(loc)} must be a boolean, or undefined`);
  }

  return value;
}

function assertObject(loc, value) {
  if (value !== undefined && (typeof value !== "object" || Array.isArray(value) || !value)) {
    throw new Error(`${msg(loc)} must be an object, or undefined`);
  }

  return value;
}

function assertArray(loc, value) {
  if (value != null && !Array.isArray(value)) {
    throw new Error(`${msg(loc)} must be an array, or undefined`);
  }

  return value;
}

function assertIgnoreList(loc, value) {
  const arr = assertArray(loc, value);

  if (arr) {
    arr.forEach((item, i) => assertIgnoreItem(access(loc, i), item));
  }

  return arr;
}

function assertIgnoreItem(loc, value) {
  if (typeof value !== "string" && typeof value !== "function" && !(value instanceof RegExp)) {
    throw new Error(`${msg(loc)} must be an array of string/Function/RegExp values, or undefined`);
  }

  return value;
}

function assertConfigApplicableTest(loc, value) {
  if (value === undefined) return value;

  if (Array.isArray(value)) {
    value.forEach((item, i) => {
      if (!checkValidTest(item)) {
        throw new Error(`${msg(access(loc, i))} must be a string/Function/RegExp.`);
      }
    });
  } else if (!checkValidTest(value)) {
    throw new Error(`${msg(loc)} must be a string/Function/RegExp, or an array of those`);
  }

  return value;
}

function checkValidTest(value) {
  return typeof value === "string" || typeof value === "function" || value instanceof RegExp;
}

function assertConfigFileSearch(loc, value) {
  if (value !== undefined && typeof value !== "boolean" && typeof value !== "string") {
    throw new Error(`${msg(loc)} must be a undefined, a boolean, a string, ` + `got ${JSON.stringify(value)}`);
  }

  return value;
}

function assertBabelrcSearch(loc, value) {
  if (value === undefined || typeof value === "boolean") return value;

  if (Array.isArray(value)) {
    value.forEach((item, i) => {
      if (!checkValidTest(item)) {
        throw new Error(`${msg(access(loc, i))} must be a string/Function/RegExp.`);
      }
    });
  } else if (!checkValidTest(value)) {
    throw new Error(`${msg(loc)} must be a undefined, a boolean, a string/Function/RegExp ` + `or an array of those, got ${JSON.stringify(value)}`);
  }

  return value;
}

function assertPluginList(loc, value) {
  const arr = assertArray(loc, value);

  if (arr) {
    arr.forEach((item, i) => assertPluginItem(access(loc, i), item));
  }

  return arr;
}

function assertPluginItem(loc, value) {
  if (Array.isArray(value)) {
    if (value.length === 0) {
      throw new Error(`${msg(loc)} must include an object`);
    }

    if (value.length > 3) {
      throw new Error(`${msg(loc)} may only be a two-tuple or three-tuple`);
    }

    assertPluginTarget(access(loc, 0), value[0]);

    if (value.length > 1) {
      const opts = value[1];

      if (opts !== undefined && opts !== false && (typeof opts !== "object" || Array.isArray(opts) || opts === null)) {
        throw new Error(`${msg(access(loc, 1))} must be an object, false, or undefined`);
      }
    }

    if (value.length === 3) {
      const name = value[2];

      if (name !== undefined && typeof name !== "string") {
        throw new Error(`${msg(access(loc, 2))} must be a string, or undefined`);
      }
    }
  } else {
    assertPluginTarget(loc, value);
  }

  return value;
}

function assertPluginTarget(loc, value) {
  if ((typeof value !== "object" || !value) && typeof value !== "string" && typeof value !== "function") {
    throw new Error(`${msg(loc)} must be a string, object, function`);
  }

  return value;
}

/***/ }),
/* 357 */
/***/ (function(module) {

module.exports = require("util");

/***/ }),
/* 358 */,
/* 359 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = matchesPattern;

var _generated = __webpack_require__(897);

function matchesPattern(member, match, allowPartial) {
  if (!(0, _generated.isMemberExpression)(member)) return false;
  const parts = Array.isArray(match) ? match : match.split(".");
  const nodes = [];
  let node;

  for (node = member; (0, _generated.isMemberExpression)(node); node = node.object) {
    nodes.push(node.property);
  }

  nodes.push(node);
  if (nodes.length < parts.length) return false;
  if (!allowPartial && nodes.length > parts.length) return false;

  for (let i = 0, j = nodes.length - 1; i < parts.length; i++, j--) {
    const node = nodes[j];
    let value;

    if ((0, _generated.isIdentifier)(node)) {
      value = node.name;
    } else if ((0, _generated.isStringLiteral)(node)) {
      value = node.value;
    } else {
      return false;
    }

    if (parts[i] !== value) return false;
  }

  return true;
}

/***/ }),
/* 360 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseHasIn = __webpack_require__(754),
    hasPath = __webpack_require__(310);

/**
 * Checks if `path` is a direct or inherited property of `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 * @example
 *
 * var object = _.create({ 'a': _.create({ 'b': 2 }) });
 *
 * _.hasIn(object, 'a');
 * // => true
 *
 * _.hasIn(object, 'a.b');
 * // => true
 *
 * _.hasIn(object, ['a', 'b']);
 * // => true
 *
 * _.hasIn(object, 'b');
 * // => false
 */
function hasIn(object, path) {
  return object != null && hasPath(object, path, baseHasIn);
}

module.exports = hasIn;


/***/ }),
/* 361 */,
/* 362 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRegExpFeaturePlugin = createRegExpFeaturePlugin;

var _regexpuCore = _interopRequireDefault(__webpack_require__(495));

var _features = __webpack_require__(871);

var _util = __webpack_require__(874);

var _package = _interopRequireDefault(__webpack_require__(689));

var _core = __webpack_require__(278);

var _helperRegex = __webpack_require__(106);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const version = _package.default.version.split(".").reduce((v, x) => v * 1e5 + +x, 0);

const versionKey = "@babel/plugin-regexp-features/version";

function createRegExpFeaturePlugin({
  name,
  feature,
  options = {}
}) {
  return {
    name,

    pre() {
      var _file$get;

      const {
        file
      } = this;
      const features = (_file$get = file.get(_features.featuresKey)) !== null && _file$get !== void 0 ? _file$get : 0;
      let newFeatures = (0, _features.enableFeature)(features, _features.FEATURES[feature]);
      const {
        useUnicodeFlag,
        runtime = true
      } = options;

      if (useUnicodeFlag === false) {
        newFeatures = (0, _features.enableFeature)(newFeatures, _features.FEATURES.unicodeFlag);
      }

      if (newFeatures !== features) {
        file.set(_features.featuresKey, newFeatures);
      }

      if (!runtime) {
        file.set(_features.runtimeKey, false);
      }

      if (!file.has(versionKey) || file.get(versionKey) < version) {
        file.set(versionKey, version);
      }
    },

    visitor: {
      RegExpLiteral(path) {
        var _file$get2;

        const {
          node
        } = path;
        const {
          file
        } = this;
        const features = file.get(_features.featuresKey);
        const runtime = (_file$get2 = file.get(_features.runtimeKey)) !== null && _file$get2 !== void 0 ? _file$get2 : true;
        const regexpuOptions = (0, _util.generateRegexpuOptions)(node, features);

        if (regexpuOptions === null) {
          return;
        }

        const namedCaptureGroups = {};

        if (regexpuOptions.namedGroup) {
          regexpuOptions.onNamedGroup = (name, index) => {
            namedCaptureGroups[name] = index;
          };
        }

        node.pattern = (0, _regexpuCore.default)(node.pattern, node.flags, regexpuOptions);

        if (regexpuOptions.namedGroup && Object.keys(namedCaptureGroups).length > 0 && runtime && !isRegExpTest(path)) {
          path.replaceWith(_core.types.callExpression(this.addHelper("wrapRegExp"), [node, _core.types.valueToNode(namedCaptureGroups)]));
        }

        if ((0, _features.hasFeature)(features, _features.FEATURES.unicodeFlag)) {
          (0, _helperRegex.pullFlag)(node, "u");
        }

        if ((0, _features.hasFeature)(features, _features.FEATURES.dotAllFlag)) {
          (0, _helperRegex.pullFlag)(node, "s");
        }
      }

    }
  };
}

function isRegExpTest(path) {
  return path.parentPath.isMemberExpression({
    object: path.node,
    computed: false
  }) && path.parentPath.get("property").isIdentifier({
    name: "test"
  });
}

/***/ }),
/* 363 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseAssignValue = __webpack_require__(772),
    eq = __webpack_require__(338);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignValue;


/***/ }),
/* 364 */
/***/ (function(module) {

"use strict";

module.exports = (flag, argv) => {
	argv = argv || process.argv;
	const prefix = flag.startsWith('-') ? '' : (flag.length === 1 ? '-' : '--');
	const pos = argv.indexOf(prefix + flag);
	const terminatorPos = argv.indexOf('--');
	return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
};


/***/ }),
/* 365 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.remove = remove;
exports._removeFromScope = _removeFromScope;
exports._callRemovalHooks = _callRemovalHooks;
exports._remove = _remove;
exports._markRemoved = _markRemoved;
exports._assertUnremoved = _assertUnremoved;

var _removalHooks = __webpack_require__(99);

var _index = __webpack_require__(774);

function remove() {
  this._assertUnremoved();

  this.resync();

  this._removeFromScope();

  if (this._callRemovalHooks()) {
    this._markRemoved();

    return;
  }

  this.shareCommentsWithSiblings();

  this._remove();

  this._markRemoved();
}

function _removeFromScope() {
  const bindings = this.getBindingIdentifiers();
  Object.keys(bindings).forEach(name => this.scope.removeBinding(name));
}

function _callRemovalHooks() {
  for (const fn of _removalHooks.hooks) {
    if (fn(this, this.parentPath)) return true;
  }
}

function _remove() {
  if (Array.isArray(this.container)) {
    this.container.splice(this.key, 1);
    this.updateSiblingKeys(this.key, -1);
  } else {
    this._replaceWith(null);
  }
}

function _markRemoved() {
  this._traverseFlags |= _index.SHOULD_SKIP | _index.REMOVED;
  this.node = null;
}

function _assertUnremoved() {
  if (this.removed) {
    throw this.buildCodeFrameError("NodePath has been removed so is read-only.");
  }
}

/***/ }),
/* 366 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = __webpack_require__(57);

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

function _core() {
  const data = __webpack_require__(278);

  _core = function () {
    return data;
  };

  return data;
}

var _default = (0, _helperPluginUtils().declare)((api, options) => {
  api.assertVersion(7);
  const {
    loose
  } = options;
  let helperName = "taggedTemplateLiteral";
  if (loose) helperName += "Loose";

  function buildConcatCallExpressions(items) {
    let avail = true;
    return items.reduce(function (left, right) {
      let canBeInserted = _core().types.isLiteral(right);

      if (!canBeInserted && avail) {
        canBeInserted = true;
        avail = false;
      }

      if (canBeInserted && _core().types.isCallExpression(left)) {
        left.arguments.push(right);
        return left;
      }

      return _core().types.callExpression(_core().types.memberExpression(left, _core().types.identifier("concat")), [right]);
    });
  }

  return {
    name: "transform-template-literals",
    visitor: {
      TaggedTemplateExpression(path) {
        const {
          node
        } = path;
        const {
          quasi
        } = node;
        const strings = [];
        const raws = [];
        let isStringsRawEqual = true;

        for (const elem of quasi.quasis) {
          const {
            raw,
            cooked
          } = elem.value;
          const value = cooked == null ? path.scope.buildUndefinedNode() : _core().types.stringLiteral(cooked);
          strings.push(value);
          raws.push(_core().types.stringLiteral(raw));

          if (raw !== cooked) {
            isStringsRawEqual = false;
          }
        }

        const scope = path.scope.getProgramParent();
        const templateObject = scope.generateUidIdentifier("templateObject");
        const helperId = this.addHelper(helperName);
        const callExpressionInput = [_core().types.arrayExpression(strings)];

        if (!isStringsRawEqual) {
          callExpressionInput.push(_core().types.arrayExpression(raws));
        }

        const lazyLoad = _core().template.ast`
          function ${templateObject}() {
            const data = ${_core().types.callExpression(helperId, callExpressionInput)};
            ${templateObject} = function() { return data };
            return data;
          } 
        `;
        scope.path.unshiftContainer("body", lazyLoad);
        path.replaceWith(_core().types.callExpression(node.tag, [_core().types.callExpression(_core().types.cloneNode(templateObject), []), ...quasi.expressions]));
      },

      TemplateLiteral(path) {
        const nodes = [];
        const expressions = path.get("expressions");
        let index = 0;

        for (const elem of path.node.quasis) {
          if (elem.value.cooked) {
            nodes.push(_core().types.stringLiteral(elem.value.cooked));
          }

          if (index < expressions.length) {
            const expr = expressions[index++];
            const node = expr.node;

            if (!_core().types.isStringLiteral(node, {
              value: ""
            })) {
              nodes.push(node);
            }
          }
        }

        const considerSecondNode = !loose || !_core().types.isStringLiteral(nodes[1]);

        if (!_core().types.isStringLiteral(nodes[0]) && considerSecondNode) {
          nodes.unshift(_core().types.stringLiteral(""));
        }

        let root = nodes[0];

        if (loose) {
          for (let i = 1; i < nodes.length; i++) {
            root = _core().types.binaryExpression("+", root, nodes[i]);
          }
        } else if (nodes.length > 1) {
          root = buildConcatCallExpressions(nodes);
        }

        path.replaceWith(root);
      }

    }
  };
});

exports.default = _default;

/***/ }),
/* 367 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runAsync = runAsync;
exports.runSync = runSync;

function _traverse() {
  const data = _interopRequireDefault(__webpack_require__(167));

  _traverse = function () {
    return data;
  };

  return data;
}

var _pluginPass = _interopRequireDefault(__webpack_require__(952));

var _blockHoistPlugin = _interopRequireDefault(__webpack_require__(895));

var _normalizeOpts = _interopRequireDefault(__webpack_require__(182));

var _normalizeFile = _interopRequireDefault(__webpack_require__(450));

var _generate = _interopRequireDefault(__webpack_require__(29));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function runAsync(config, code, ast, callback) {
  let result;

  try {
    result = runSync(config, code, ast);
  } catch (err) {
    return callback(err);
  }

  return callback(null, result);
}

function runSync(config, code, ast) {
  const file = (0, _normalizeFile.default)(config.passes, (0, _normalizeOpts.default)(config), code, ast);
  const opts = file.opts;

  try {
    transformFile(file, config.passes);
  } catch (e) {
    var _opts$filename;

    e.message = `${(_opts$filename = opts.filename) !== null && _opts$filename !== void 0 ? _opts$filename : "unknown"}: ${e.message}`;

    if (!e.code) {
      e.code = "BABEL_TRANSFORM_ERROR";
    }

    throw e;
  }

  let outputCode, outputMap;

  try {
    if (opts.code !== false) {
      ({
        outputCode,
        outputMap
      } = (0, _generate.default)(config.passes, file));
    }
  } catch (e) {
    var _opts$filename2;

    e.message = `${(_opts$filename2 = opts.filename) !== null && _opts$filename2 !== void 0 ? _opts$filename2 : "unknown"}: ${e.message}`;

    if (!e.code) {
      e.code = "BABEL_GENERATE_ERROR";
    }

    throw e;
  }

  return {
    metadata: file.metadata,
    options: opts,
    ast: opts.ast === true ? file.ast : null,
    code: outputCode === undefined ? null : outputCode,
    map: outputMap === undefined ? null : outputMap,
    sourceType: file.ast.program.sourceType
  };
}

function transformFile(file, pluginPasses) {
  for (const pluginPairs of pluginPasses) {
    const passPairs = [];
    const passes = [];
    const visitors = [];

    for (const plugin of pluginPairs.concat([(0, _blockHoistPlugin.default)()])) {
      const pass = new _pluginPass.default(file, plugin.key, plugin.options);
      passPairs.push([plugin, pass]);
      passes.push(pass);
      visitors.push(plugin.visitor);
    }

    for (const [plugin, pass] of passPairs) {
      const fn = plugin.pre;

      if (fn) {
        const result = fn.call(pass, file);

        if (isThenable(result)) {
          throw new Error(`You appear to be using an plugin with an async .pre, ` + `which your current version of Babel does not support. ` + `If you're using a published plugin, you may need to upgrade ` + `your @babel/core version.`);
        }
      }
    }

    const visitor = _traverse().default.visitors.merge(visitors, passes, file.opts.wrapPluginVisitorMethod);

    (0, _traverse().default)(file.ast, visitor, file.scope);

    for (const [plugin, pass] of passPairs) {
      const fn = plugin.post;

      if (fn) {
        const result = fn.call(pass, file);

        if (isThenable(result)) {
          throw new Error(`You appear to be using an plugin with an async .post, ` + `which your current version of Babel does not support. ` + `If you're using a published plugin, you may need to upgrade ` + `your @babel/core version.`);
        }
      }
    }
  }
}

function isThenable(val) {
  return !!val && (typeof val === "object" || typeof val === "function") && !!val.then && typeof val.then === "function";
}

/***/ }),
/* 368 */,
/* 369 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matchesPattern = matchesPattern;
exports.has = has;
exports.isStatic = isStatic;
exports.isnt = isnt;
exports.equals = equals;
exports.isNodeType = isNodeType;
exports.canHaveVariableDeclarationOrExpression = canHaveVariableDeclarationOrExpression;
exports.canSwapBetweenExpressionAndStatement = canSwapBetweenExpressionAndStatement;
exports.isCompletionRecord = isCompletionRecord;
exports.isStatementOrBlock = isStatementOrBlock;
exports.referencesImport = referencesImport;
exports.getSource = getSource;
exports.willIMaybeExecuteBefore = willIMaybeExecuteBefore;
exports._guessExecutionStatusRelativeTo = _guessExecutionStatusRelativeTo;
exports._guessExecutionStatusRelativeToDifferentFunctions = _guessExecutionStatusRelativeToDifferentFunctions;
exports.resolve = resolve;
exports._resolve = _resolve;
exports.isConstantExpression = isConstantExpression;
exports.isInStrictMode = isInStrictMode;
exports.is = void 0;

var _includes = _interopRequireDefault(__webpack_require__(249));

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function matchesPattern(pattern, allowPartial) {
  return t.matchesPattern(this.node, pattern, allowPartial);
}

function has(key) {
  const val = this.node && this.node[key];

  if (val && Array.isArray(val)) {
    return !!val.length;
  } else {
    return !!val;
  }
}

function isStatic() {
  return this.scope.isStatic(this.node);
}

const is = has;
exports.is = is;

function isnt(key) {
  return !this.has(key);
}

function equals(key, value) {
  return this.node[key] === value;
}

function isNodeType(type) {
  return t.isType(this.type, type);
}

function canHaveVariableDeclarationOrExpression() {
  return (this.key === "init" || this.key === "left") && this.parentPath.isFor();
}

function canSwapBetweenExpressionAndStatement(replacement) {
  if (this.key !== "body" || !this.parentPath.isArrowFunctionExpression()) {
    return false;
  }

  if (this.isExpression()) {
    return t.isBlockStatement(replacement);
  } else if (this.isBlockStatement()) {
    return t.isExpression(replacement);
  }

  return false;
}

function isCompletionRecord(allowInsideFunction) {
  let path = this;
  let first = true;

  do {
    const container = path.container;

    if (path.isFunction() && !first) {
      return !!allowInsideFunction;
    }

    first = false;

    if (Array.isArray(container) && path.key !== container.length - 1) {
      return false;
    }
  } while ((path = path.parentPath) && !path.isProgram());

  return true;
}

function isStatementOrBlock() {
  if (this.parentPath.isLabeledStatement() || t.isBlockStatement(this.container)) {
    return false;
  } else {
    return (0, _includes.default)(t.STATEMENT_OR_BLOCK_KEYS, this.key);
  }
}

function referencesImport(moduleSource, importName) {
  if (!this.isReferencedIdentifier()) return false;
  const binding = this.scope.getBinding(this.node.name);
  if (!binding || binding.kind !== "module") return false;
  const path = binding.path;
  const parent = path.parentPath;
  if (!parent.isImportDeclaration()) return false;

  if (parent.node.source.value === moduleSource) {
    if (!importName) return true;
  } else {
    return false;
  }

  if (path.isImportDefaultSpecifier() && importName === "default") {
    return true;
  }

  if (path.isImportNamespaceSpecifier() && importName === "*") {
    return true;
  }

  if (path.isImportSpecifier() && path.node.imported.name === importName) {
    return true;
  }

  return false;
}

function getSource() {
  const node = this.node;

  if (node.end) {
    const code = this.hub.getCode();
    if (code) return code.slice(node.start, node.end);
  }

  return "";
}

function willIMaybeExecuteBefore(target) {
  return this._guessExecutionStatusRelativeTo(target) !== "after";
}

function getOuterFunction(path) {
  return (path.scope.getFunctionParent() || path.scope.getProgramParent()).path;
}

function isExecutionUncertain(type, key) {
  switch (type) {
    case "LogicalExpression":
      return key === "right";

    case "ConditionalExpression":
    case "IfStatement":
      return key === "consequent" || key === "alternate";

    case "WhileStatement":
    case "DoWhileStatement":
    case "ForInStatement":
    case "ForOfStatement":
      return key === "body";

    case "ForStatement":
      return key === "body" || key === "update";

    case "SwitchStatement":
      return key === "cases";

    case "TryStatement":
      return key === "handler";

    case "AssignmentPattern":
      return key === "right";

    case "OptionalMemberExpression":
      return key === "property";

    case "OptionalCallExpression":
      return key === "arguments";

    default:
      return false;
  }
}

function isExecutionUncertainInList(paths, maxIndex) {
  for (let i = 0; i < maxIndex; i++) {
    const path = paths[i];

    if (isExecutionUncertain(path.parent.type, path.parentKey)) {
      return true;
    }
  }

  return false;
}

function _guessExecutionStatusRelativeTo(target) {
  const funcParent = {
    this: getOuterFunction(this),
    target: getOuterFunction(target)
  };

  if (funcParent.target.node !== funcParent.this.node) {
    return this._guessExecutionStatusRelativeToDifferentFunctions(funcParent.target);
  }

  const paths = {
    target: target.getAncestry(),
    this: this.getAncestry()
  };
  if (paths.target.indexOf(this) >= 0) return "after";
  if (paths.this.indexOf(target) >= 0) return "before";
  let commonPath;
  const commonIndex = {
    target: 0,
    this: 0
  };

  while (!commonPath && commonIndex.this < paths.this.length) {
    const path = paths.this[commonIndex.this];
    commonIndex.target = paths.target.indexOf(path);

    if (commonIndex.target >= 0) {
      commonPath = path;
    } else {
      commonIndex.this++;
    }
  }

  if (!commonPath) {
    throw new Error("Internal Babel error - The two compared nodes" + " don't appear to belong to the same program.");
  }

  if (isExecutionUncertainInList(paths.this, commonIndex.this - 1) || isExecutionUncertainInList(paths.target, commonIndex.target - 1)) {
    return "unknown";
  }

  const divergence = {
    this: paths.this[commonIndex.this - 1],
    target: paths.target[commonIndex.target - 1]
  };

  if (divergence.target.listKey && divergence.this.listKey && divergence.target.container === divergence.this.container) {
    return divergence.target.key > divergence.this.key ? "before" : "after";
  }

  const keys = t.VISITOR_KEYS[commonPath.type];
  const keyPosition = {
    this: keys.indexOf(divergence.this.parentKey),
    target: keys.indexOf(divergence.target.parentKey)
  };
  return keyPosition.target > keyPosition.this ? "before" : "after";
}

const executionOrderCheckedNodes = new WeakSet();

function _guessExecutionStatusRelativeToDifferentFunctions(target) {
  if (!target.isFunctionDeclaration() || target.parentPath.isExportDeclaration()) {
    return "unknown";
  }

  const binding = target.scope.getBinding(target.node.id.name);
  if (!binding.references) return "before";
  const referencePaths = binding.referencePaths;
  let allStatus;

  for (const path of referencePaths) {
    const childOfFunction = !!path.find(path => path.node === target.node);
    if (childOfFunction) continue;

    if (path.key !== "callee" || !path.parentPath.isCallExpression()) {
      return "unknown";
    }

    if (executionOrderCheckedNodes.has(path.node)) continue;
    executionOrderCheckedNodes.add(path.node);

    const status = this._guessExecutionStatusRelativeTo(path);

    executionOrderCheckedNodes.delete(path.node);

    if (allStatus && allStatus !== status) {
      return "unknown";
    } else {
      allStatus = status;
    }
  }

  return allStatus;
}

function resolve(dangerous, resolved) {
  return this._resolve(dangerous, resolved) || this;
}

function _resolve(dangerous, resolved) {
  if (resolved && resolved.indexOf(this) >= 0) return;
  resolved = resolved || [];
  resolved.push(this);

  if (this.isVariableDeclarator()) {
    if (this.get("id").isIdentifier()) {
      return this.get("init").resolve(dangerous, resolved);
    } else {}
  } else if (this.isReferencedIdentifier()) {
    const binding = this.scope.getBinding(this.node.name);
    if (!binding) return;
    if (!binding.constant) return;
    if (binding.kind === "module") return;

    if (binding.path !== this) {
      const ret = binding.path.resolve(dangerous, resolved);
      if (this.find(parent => parent.node === ret.node)) return;
      return ret;
    }
  } else if (this.isTypeCastExpression()) {
    return this.get("expression").resolve(dangerous, resolved);
  } else if (dangerous && this.isMemberExpression()) {
    const targetKey = this.toComputedKey();
    if (!t.isLiteral(targetKey)) return;
    const targetName = targetKey.value;
    const target = this.get("object").resolve(dangerous, resolved);

    if (target.isObjectExpression()) {
      const props = target.get("properties");

      for (const prop of props) {
        if (!prop.isProperty()) continue;
        const key = prop.get("key");
        let match = prop.isnt("computed") && key.isIdentifier({
          name: targetName
        });
        match = match || key.isLiteral({
          value: targetName
        });
        if (match) return prop.get("value").resolve(dangerous, resolved);
      }
    } else if (target.isArrayExpression() && !isNaN(+targetName)) {
      const elems = target.get("elements");
      const elem = elems[targetName];
      if (elem) return elem.resolve(dangerous, resolved);
    }
  }
}

function isConstantExpression() {
  if (this.isIdentifier()) {
    const binding = this.scope.getBinding(this.node.name);
    if (!binding) return false;
    return binding.constant;
  }

  if (this.isLiteral()) {
    if (this.isRegExpLiteral()) {
      return false;
    }

    if (this.isTemplateLiteral()) {
      return this.get("expressions").every(expression => expression.isConstantExpression());
    }

    return true;
  }

  if (this.isUnaryExpression()) {
    if (this.get("operator").node !== "void") {
      return false;
    }

    return this.get("argument").isConstantExpression();
  }

  if (this.isBinaryExpression()) {
    return this.get("left").isConstantExpression() && this.get("right").isConstantExpression();
  }

  return false;
}

function isInStrictMode() {
  const start = this.isProgram() ? this : this.parentPath;
  const strictParent = start.find(path => {
    if (path.isProgram({
      sourceType: "module"
    })) return true;
    if (path.isClass()) return true;
    if (!path.isProgram() && !path.isFunction()) return false;

    if (path.isArrowFunctionExpression() && !path.get("body").isBlockStatement()) {
      return false;
    }

    let {
      node
    } = path;
    if (path.isFunction()) node = node.body;

    for (const directive of node.directives) {
      if (directive.value.value === "use strict") {
        return true;
      }
    }
  });
  return !!strictParent;
}

/***/ }),
/* 370 */,
/* 371 */,
/* 372 */,
/* 373 */,
/* 374 */,
/* 375 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTypeAnnotation = getTypeAnnotation;
exports._getTypeAnnotation = _getTypeAnnotation;
exports.isBaseType = isBaseType;
exports.couldBeBaseType = couldBeBaseType;
exports.baseTypeStrictlyMatches = baseTypeStrictlyMatches;
exports.isGenericType = isGenericType;

var inferers = _interopRequireWildcard(__webpack_require__(43));

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function getTypeAnnotation() {
  if (this.typeAnnotation) return this.typeAnnotation;
  let type = this._getTypeAnnotation() || t.anyTypeAnnotation();
  if (t.isTypeAnnotation(type)) type = type.typeAnnotation;
  return this.typeAnnotation = type;
}

function _getTypeAnnotation() {
  const node = this.node;

  if (!node) {
    if (this.key === "init" && this.parentPath.isVariableDeclarator()) {
      const declar = this.parentPath.parentPath;
      const declarParent = declar.parentPath;

      if (declar.key === "left" && declarParent.isForInStatement()) {
        return t.stringTypeAnnotation();
      }

      if (declar.key === "left" && declarParent.isForOfStatement()) {
        return t.anyTypeAnnotation();
      }

      return t.voidTypeAnnotation();
    } else {
      return;
    }
  }

  if (node.typeAnnotation) {
    return node.typeAnnotation;
  }

  let inferer = inferers[node.type];

  if (inferer) {
    return inferer.call(this, node);
  }

  inferer = inferers[this.parentPath.type];

  if (inferer && inferer.validParent) {
    return this.parentPath.getTypeAnnotation();
  }
}

function isBaseType(baseName, soft) {
  return _isBaseType(baseName, this.getTypeAnnotation(), soft);
}

function _isBaseType(baseName, type, soft) {
  if (baseName === "string") {
    return t.isStringTypeAnnotation(type);
  } else if (baseName === "number") {
    return t.isNumberTypeAnnotation(type);
  } else if (baseName === "boolean") {
    return t.isBooleanTypeAnnotation(type);
  } else if (baseName === "any") {
    return t.isAnyTypeAnnotation(type);
  } else if (baseName === "mixed") {
    return t.isMixedTypeAnnotation(type);
  } else if (baseName === "empty") {
    return t.isEmptyTypeAnnotation(type);
  } else if (baseName === "void") {
    return t.isVoidTypeAnnotation(type);
  } else {
    if (soft) {
      return false;
    } else {
      throw new Error(`Unknown base type ${baseName}`);
    }
  }
}

function couldBeBaseType(name) {
  const type = this.getTypeAnnotation();
  if (t.isAnyTypeAnnotation(type)) return true;

  if (t.isUnionTypeAnnotation(type)) {
    for (const type2 of type.types) {
      if (t.isAnyTypeAnnotation(type2) || _isBaseType(name, type2, true)) {
        return true;
      }
    }

    return false;
  } else {
    return _isBaseType(name, type, true);
  }
}

function baseTypeStrictlyMatches(right) {
  const left = this.getTypeAnnotation();
  right = right.getTypeAnnotation();

  if (!t.isAnyTypeAnnotation(left) && t.isFlowBaseAnnotation(left)) {
    return right.type === left.type;
  }
}

function isGenericType(genericName) {
  const type = this.getTypeAnnotation();
  return t.isGenericTypeAnnotation(type) && t.isIdentifier(type.id, {
    name: genericName
  });
}

/***/ }),
/* 376 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = appendToMemberExpression;

var _generated = __webpack_require__(405);

function appendToMemberExpression(member, append, computed = false) {
  member.object = (0, _generated.memberExpression)(member.object, member.property, member.computed);
  member.property = append;
  member.computed = !!computed;
  return member;
}

/***/ }),
/* 377 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var Stack = __webpack_require__(598),
    arrayEach = __webpack_require__(698),
    assignValue = __webpack_require__(363),
    baseAssign = __webpack_require__(629),
    baseAssignIn = __webpack_require__(610),
    cloneBuffer = __webpack_require__(744),
    copyArray = __webpack_require__(239),
    copySymbols = __webpack_require__(760),
    copySymbolsIn = __webpack_require__(589),
    getAllKeys = __webpack_require__(620),
    getAllKeysIn = __webpack_require__(590),
    getTag = __webpack_require__(700),
    initCloneArray = __webpack_require__(430),
    initCloneByTag = __webpack_require__(538),
    initCloneObject = __webpack_require__(66),
    isArray = __webpack_require__(143),
    isBuffer = __webpack_require__(546),
    isMap = __webpack_require__(401),
    isObject = __webpack_require__(988),
    isSet = __webpack_require__(713),
    keys = __webpack_require__(863);

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1,
    CLONE_FLAT_FLAG = 2,
    CLONE_SYMBOLS_FLAG = 4;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values supported by `_.clone`. */
var cloneableTags = {};
cloneableTags[argsTag] = cloneableTags[arrayTag] =
cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
cloneableTags[boolTag] = cloneableTags[dateTag] =
cloneableTags[float32Tag] = cloneableTags[float64Tag] =
cloneableTags[int8Tag] = cloneableTags[int16Tag] =
cloneableTags[int32Tag] = cloneableTags[mapTag] =
cloneableTags[numberTag] = cloneableTags[objectTag] =
cloneableTags[regexpTag] = cloneableTags[setTag] =
cloneableTags[stringTag] = cloneableTags[symbolTag] =
cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
cloneableTags[errorTag] = cloneableTags[funcTag] =
cloneableTags[weakMapTag] = false;

/**
 * The base implementation of `_.clone` and `_.cloneDeep` which tracks
 * traversed objects.
 *
 * @private
 * @param {*} value The value to clone.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Deep clone
 *  2 - Flatten inherited properties
 *  4 - Clone symbols
 * @param {Function} [customizer] The function to customize cloning.
 * @param {string} [key] The key of `value`.
 * @param {Object} [object] The parent object of `value`.
 * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
 * @returns {*} Returns the cloned value.
 */
function baseClone(value, bitmask, customizer, key, object, stack) {
  var result,
      isDeep = bitmask & CLONE_DEEP_FLAG,
      isFlat = bitmask & CLONE_FLAT_FLAG,
      isFull = bitmask & CLONE_SYMBOLS_FLAG;

  if (customizer) {
    result = object ? customizer(value, key, object, stack) : customizer(value);
  }
  if (result !== undefined) {
    return result;
  }
  if (!isObject(value)) {
    return value;
  }
  var isArr = isArray(value);
  if (isArr) {
    result = initCloneArray(value);
    if (!isDeep) {
      return copyArray(value, result);
    }
  } else {
    var tag = getTag(value),
        isFunc = tag == funcTag || tag == genTag;

    if (isBuffer(value)) {
      return cloneBuffer(value, isDeep);
    }
    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
      result = (isFlat || isFunc) ? {} : initCloneObject(value);
      if (!isDeep) {
        return isFlat
          ? copySymbolsIn(value, baseAssignIn(result, value))
          : copySymbols(value, baseAssign(result, value));
      }
    } else {
      if (!cloneableTags[tag]) {
        return object ? value : {};
      }
      result = initCloneByTag(value, tag, isDeep);
    }
  }
  // Check for circular references and return its corresponding clone.
  stack || (stack = new Stack);
  var stacked = stack.get(value);
  if (stacked) {
    return stacked;
  }
  stack.set(value, result);

  if (isSet(value)) {
    value.forEach(function(subValue) {
      result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
    });
  } else if (isMap(value)) {
    value.forEach(function(subValue, key) {
      result.set(key, baseClone(subValue, bitmask, customizer, key, value, stack));
    });
  }

  var keysFunc = isFull
    ? (isFlat ? getAllKeysIn : getAllKeys)
    : (isFlat ? keysIn : keys);

  var props = isArr ? undefined : keysFunc(value);
  arrayEach(props || value, function(subValue, key) {
    if (props) {
      key = subValue;
      subValue = value[key];
    }
    // Recursively populate clone (susceptible to call stack limits).
    assignValue(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));
  });
  return result;
}

module.exports = baseClone;


/***/ }),
/* 378 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var arrayMap = __webpack_require__(766);

/**
 * The base implementation of `_.values` and `_.valuesIn` which creates an
 * array of `object` property values corresponding to the property names
 * of `props`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array} props The property names to get values for.
 * @returns {Object} Returns the array of property values.
 */
function baseValues(object, props) {
  return arrayMap(props, function(key) {
    return object[key];
  });
}

module.exports = baseValues;


/***/ }),
/* 379 */,
/* 380 */,
/* 381 */,
/* 382 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var getNative = __webpack_require__(319);

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

module.exports = defineProperty;


/***/ }),
/* 383 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getOuterBindingIdentifiers;

var _getBindingIdentifiers = _interopRequireDefault(__webpack_require__(705));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getOuterBindingIdentifiers(node, duplicates) {
  return (0, _getBindingIdentifiers.default)(node, duplicates, true);
}

/***/ }),
/* 384 */
/***/ (function(module) {

module.exports = {
  safari: "tp",
};


/***/ }),
/* 385 */,
/* 386 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var arrayPush = __webpack_require__(883),
    getPrototype = __webpack_require__(931),
    getSymbols = __webpack_require__(709),
    stubArray = __webpack_require__(48);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own and inherited enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
  var result = [];
  while (object) {
    arrayPush(result, getSymbols(object));
    object = getPrototype(object);
  }
  return result;
};

module.exports = getSymbolsIn;


/***/ }),
/* 387 */,
/* 388 */
/***/ (function(module, exports, __webpack_require__) {

/* module decorator */ module = __webpack_require__.nmd(module);
/*! https://mths.be/regenerate v1.3.3 by @mathias | MIT license */
;(function(root) {

	// Detect free variables `exports`.
	var freeExports =  true && exports;

	// Detect free variable `module`.
	var freeModule =  true && module &&
		module.exports == freeExports && module;

	// Detect free variable `global`, from Node.js/io.js or Browserified code,
	// and use it as `root`.
	var freeGlobal = typeof global == 'object' && global;
	if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal) {
		root = freeGlobal;
	}

	/*--------------------------------------------------------------------------*/

	var ERRORS = {
		'rangeOrder': 'A range\u2019s `stop` value must be greater than or equal ' +
			'to the `start` value.',
		'codePointRange': 'Invalid code point value. Code points range from ' +
			'U+000000 to U+10FFFF.'
	};

	// https://mathiasbynens.be/notes/javascript-encoding#surrogate-pairs
	var HIGH_SURROGATE_MIN = 0xD800;
	var HIGH_SURROGATE_MAX = 0xDBFF;
	var LOW_SURROGATE_MIN = 0xDC00;
	var LOW_SURROGATE_MAX = 0xDFFF;

	// In Regenerate output, `\0` is never preceded by `\` because we sort by
	// code point value, so let’s keep this regular expression simple.
	var regexNull = /\\x00([^0123456789]|$)/g;

	var object = {};
	var hasOwnProperty = object.hasOwnProperty;
	var extend = function(destination, source) {
		var key;
		for (key in source) {
			if (hasOwnProperty.call(source, key)) {
				destination[key] = source[key];
			}
		}
		return destination;
	};

	var forEach = function(array, callback) {
		var index = -1;
		var length = array.length;
		while (++index < length) {
			callback(array[index], index);
		}
	};

	var toString = object.toString;
	var isArray = function(value) {
		return toString.call(value) == '[object Array]';
	};
	var isNumber = function(value) {
		return typeof value == 'number' ||
			toString.call(value) == '[object Number]';
	};

	// This assumes that `number` is a positive integer that `toString()`s nicely
	// (which is the case for all code point values).
	var zeroes = '0000';
	var pad = function(number, totalCharacters) {
		var string = String(number);
		return string.length < totalCharacters
			? (zeroes + string).slice(-totalCharacters)
			: string;
	};

	var hex = function(number) {
		return Number(number).toString(16).toUpperCase();
	};

	var slice = [].slice;

	/*--------------------------------------------------------------------------*/

	var dataFromCodePoints = function(codePoints) {
		var index = -1;
		var length = codePoints.length;
		var max = length - 1;
		var result = [];
		var isStart = true;
		var tmp;
		var previous = 0;
		while (++index < length) {
			tmp = codePoints[index];
			if (isStart) {
				result.push(tmp);
				previous = tmp;
				isStart = false;
			} else {
				if (tmp == previous + 1) {
					if (index != max) {
						previous = tmp;
						continue;
					} else {
						isStart = true;
						result.push(tmp + 1);
					}
				} else {
					// End the previous range and start a new one.
					result.push(previous + 1, tmp);
					previous = tmp;
				}
			}
		}
		if (!isStart) {
			result.push(tmp + 1);
		}
		return result;
	};

	var dataRemove = function(data, codePoint) {
		// Iterate over the data per `(start, end)` pair.
		var index = 0;
		var start;
		var end;
		var length = data.length;
		while (index < length) {
			start = data[index];
			end = data[index + 1];
			if (codePoint >= start && codePoint < end) {
				// Modify this pair.
				if (codePoint == start) {
					if (end == start + 1) {
						// Just remove `start` and `end`.
						data.splice(index, 2);
						return data;
					} else {
						// Just replace `start` with a new value.
						data[index] = codePoint + 1;
						return data;
					}
				} else if (codePoint == end - 1) {
					// Just replace `end` with a new value.
					data[index + 1] = codePoint;
					return data;
				} else {
					// Replace `[start, end]` with `[startA, endA, startB, endB]`.
					data.splice(index, 2, start, codePoint, codePoint + 1, end);
					return data;
				}
			}
			index += 2;
		}
		return data;
	};

	var dataRemoveRange = function(data, rangeStart, rangeEnd) {
		if (rangeEnd < rangeStart) {
			throw Error(ERRORS.rangeOrder);
		}
		// Iterate over the data per `(start, end)` pair.
		var index = 0;
		var start;
		var end;
		while (index < data.length) {
			start = data[index];
			end = data[index + 1] - 1; // Note: the `- 1` makes `end` inclusive.

			// Exit as soon as no more matching pairs can be found.
			if (start > rangeEnd) {
				return data;
			}

			// Check if this range pair is equal to, or forms a subset of, the range
			// to be removed.
			// E.g. we have `[0, 11, 40, 51]` and want to remove 0-10 → `[40, 51]`.
			// E.g. we have `[40, 51]` and want to remove 0-100 → `[]`.
			if (rangeStart <= start && rangeEnd >= end) {
				// Remove this pair.
				data.splice(index, 2);
				continue;
			}

			// Check if both `rangeStart` and `rangeEnd` are within the bounds of
			// this pair.
			// E.g. we have `[0, 11]` and want to remove 4-6 → `[0, 4, 7, 11]`.
			if (rangeStart >= start && rangeEnd < end) {
				if (rangeStart == start) {
					// Replace `[start, end]` with `[startB, endB]`.
					data[index] = rangeEnd + 1;
					data[index + 1] = end + 1;
					return data;
				}
				// Replace `[start, end]` with `[startA, endA, startB, endB]`.
				data.splice(index, 2, start, rangeStart, rangeEnd + 1, end + 1);
				return data;
			}

			// Check if only `rangeStart` is within the bounds of this pair.
			// E.g. we have `[0, 11]` and want to remove 4-20 → `[0, 4]`.
			if (rangeStart >= start && rangeStart <= end) {
				// Replace `end` with `rangeStart`.
				data[index + 1] = rangeStart;
				// Note: we cannot `return` just yet, in case any following pairs still
				// contain matching code points.
				// E.g. we have `[0, 11, 14, 31]` and want to remove 4-20
				// → `[0, 4, 21, 31]`.
			}

			// Check if only `rangeEnd` is within the bounds of this pair.
			// E.g. we have `[14, 31]` and want to remove 4-20 → `[21, 31]`.
			else if (rangeEnd >= start && rangeEnd <= end) {
				// Just replace `start`.
				data[index] = rangeEnd + 1;
				return data;
			}

			index += 2;
		}
		return data;
	};

	 var dataAdd = function(data, codePoint) {
		// Iterate over the data per `(start, end)` pair.
		var index = 0;
		var start;
		var end;
		var lastIndex = null;
		var length = data.length;
		if (codePoint < 0x0 || codePoint > 0x10FFFF) {
			throw RangeError(ERRORS.codePointRange);
		}
		while (index < length) {
			start = data[index];
			end = data[index + 1];

			// Check if the code point is already in the set.
			if (codePoint >= start && codePoint < end) {
				return data;
			}

			if (codePoint == start - 1) {
				// Just replace `start` with a new value.
				data[index] = codePoint;
				return data;
			}

			// At this point, if `start` is `greater` than `codePoint`, insert a new
			// `[start, end]` pair before the current pair, or after the current pair
			// if there is a known `lastIndex`.
			if (start > codePoint) {
				data.splice(
					lastIndex != null ? lastIndex + 2 : 0,
					0,
					codePoint,
					codePoint + 1
				);
				return data;
			}

			if (codePoint == end) {
				// Check if adding this code point causes two separate ranges to become
				// a single range, e.g. `dataAdd([0, 4, 5, 10], 4)` → `[0, 10]`.
				if (codePoint + 1 == data[index + 2]) {
					data.splice(index, 4, start, data[index + 3]);
					return data;
				}
				// Else, just replace `end` with a new value.
				data[index + 1] = codePoint + 1;
				return data;
			}
			lastIndex = index;
			index += 2;
		}
		// The loop has finished; add the new pair to the end of the data set.
		data.push(codePoint, codePoint + 1);
		return data;
	};

	var dataAddData = function(dataA, dataB) {
		// Iterate over the data per `(start, end)` pair.
		var index = 0;
		var start;
		var end;
		var data = dataA.slice();
		var length = dataB.length;
		while (index < length) {
			start = dataB[index];
			end = dataB[index + 1] - 1;
			if (start == end) {
				data = dataAdd(data, start);
			} else {
				data = dataAddRange(data, start, end);
			}
			index += 2;
		}
		return data;
	};

	var dataRemoveData = function(dataA, dataB) {
		// Iterate over the data per `(start, end)` pair.
		var index = 0;
		var start;
		var end;
		var data = dataA.slice();
		var length = dataB.length;
		while (index < length) {
			start = dataB[index];
			end = dataB[index + 1] - 1;
			if (start == end) {
				data = dataRemove(data, start);
			} else {
				data = dataRemoveRange(data, start, end);
			}
			index += 2;
		}
		return data;
	};

	var dataAddRange = function(data, rangeStart, rangeEnd) {
		if (rangeEnd < rangeStart) {
			throw Error(ERRORS.rangeOrder);
		}
		if (
			rangeStart < 0x0 || rangeStart > 0x10FFFF ||
			rangeEnd < 0x0 || rangeEnd > 0x10FFFF
		) {
			throw RangeError(ERRORS.codePointRange);
		}
		// Iterate over the data per `(start, end)` pair.
		var index = 0;
		var start;
		var end;
		var added = false;
		var length = data.length;
		while (index < length) {
			start = data[index];
			end = data[index + 1];

			if (added) {
				// The range has already been added to the set; at this point, we just
				// need to get rid of the following ranges in case they overlap.

				// Check if this range can be combined with the previous range.
				if (start == rangeEnd + 1) {
					data.splice(index - 1, 2);
					return data;
				}

				// Exit as soon as no more possibly overlapping pairs can be found.
				if (start > rangeEnd) {
					return data;
				}

				// E.g. `[0, 11, 12, 16]` and we’ve added 5-15, so we now have
				// `[0, 16, 12, 16]`. Remove the `12,16` part, as it lies within the
				// `0,16` range that was previously added.
				if (start >= rangeStart && start <= rangeEnd) {
					// `start` lies within the range that was previously added.

					if (end > rangeStart && end - 1 <= rangeEnd) {
						// `end` lies within the range that was previously added as well,
						// so remove this pair.
						data.splice(index, 2);
						index -= 2;
						// Note: we cannot `return` just yet, as there may still be other
						// overlapping pairs.
					} else {
						// `start` lies within the range that was previously added, but
						// `end` doesn’t. E.g. `[0, 11, 12, 31]` and we’ve added 5-15, so
						// now we have `[0, 16, 12, 31]`. This must be written as `[0, 31]`.
						// Remove the previously added `end` and the current `start`.
						data.splice(index - 1, 2);
						index -= 2;
					}

					// Note: we cannot return yet.
				}

			}

			else if (start == rangeEnd + 1) {
				data[index] = rangeStart;
				return data;
			}

			// Check if a new pair must be inserted *before* the current one.
			else if (start > rangeEnd) {
				data.splice(index, 0, rangeStart, rangeEnd + 1);
				return data;
			}

			else if (rangeStart >= start && rangeStart < end && rangeEnd + 1 <= end) {
				// The new range lies entirely within an existing range pair. No action
				// needed.
				return data;
			}

			else if (
				// E.g. `[0, 11]` and you add 5-15 → `[0, 16]`.
				(rangeStart >= start && rangeStart < end) ||
				// E.g. `[0, 3]` and you add 3-6 → `[0, 7]`.
				end == rangeStart
			) {
				// Replace `end` with the new value.
				data[index + 1] = rangeEnd + 1;
				// Make sure the next range pair doesn’t overlap, e.g. `[0, 11, 12, 14]`
				// and you add 5-15 → `[0, 16]`, i.e. remove the `12,14` part.
				added = true;
				// Note: we cannot `return` just yet.
			}

			else if (rangeStart <= start && rangeEnd + 1 >= end) {
				// The new range is a superset of the old range.
				data[index] = rangeStart;
				data[index + 1] = rangeEnd + 1;
				added = true;
			}

			index += 2;
		}
		// The loop has finished without doing anything; add the new pair to the end
		// of the data set.
		if (!added) {
			data.push(rangeStart, rangeEnd + 1);
		}
		return data;
	};

	var dataContains = function(data, codePoint) {
		var index = 0;
		var length = data.length;
		// Exit early if `codePoint` is not within `data`’s overall range.
		var start = data[index];
		var end = data[length - 1];
		if (length >= 2) {
			if (codePoint < start || codePoint > end) {
				return false;
			}
		}
		// Iterate over the data per `(start, end)` pair.
		while (index < length) {
			start = data[index];
			end = data[index + 1];
			if (codePoint >= start && codePoint < end) {
				return true;
			}
			index += 2;
		}
		return false;
	};

	var dataIntersection = function(data, codePoints) {
		var index = 0;
		var length = codePoints.length;
		var codePoint;
		var result = [];
		while (index < length) {
			codePoint = codePoints[index];
			if (dataContains(data, codePoint)) {
				result.push(codePoint);
			}
			++index;
		}
		return dataFromCodePoints(result);
	};

	var dataIsEmpty = function(data) {
		return !data.length;
	};

	var dataIsSingleton = function(data) {
		// Check if the set only represents a single code point.
		return data.length == 2 && data[0] + 1 == data[1];
	};

	var dataToArray = function(data) {
		// Iterate over the data per `(start, end)` pair.
		var index = 0;
		var start;
		var end;
		var result = [];
		var length = data.length;
		while (index < length) {
			start = data[index];
			end = data[index + 1];
			while (start < end) {
				result.push(start);
				++start;
			}
			index += 2;
		}
		return result;
	};

	/*--------------------------------------------------------------------------*/

	// https://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
	var floor = Math.floor;
	var highSurrogate = function(codePoint) {
		return parseInt(
			floor((codePoint - 0x10000) / 0x400) + HIGH_SURROGATE_MIN,
			10
		);
	};

	var lowSurrogate = function(codePoint) {
		return parseInt(
			(codePoint - 0x10000) % 0x400 + LOW_SURROGATE_MIN,
			10
		);
	};

	var stringFromCharCode = String.fromCharCode;
	var codePointToString = function(codePoint) {
		var string;
		// https://mathiasbynens.be/notes/javascript-escapes#single
		// Note: the `\b` escape sequence for U+0008 BACKSPACE in strings has a
		// different meaning in regular expressions (word boundary), so it cannot
		// be used here.
		if (codePoint == 0x09) {
			string = '\\t';
		}
		// Note: IE < 9 treats `'\v'` as `'v'`, so avoid using it.
		// else if (codePoint == 0x0B) {
		// 	string = '\\v';
		// }
		else if (codePoint == 0x0A) {
			string = '\\n';
		}
		else if (codePoint == 0x0C) {
			string = '\\f';
		}
		else if (codePoint == 0x0D) {
			string = '\\r';
		}
		else if (codePoint == 0x2D) {
			// https://mathiasbynens.be/notes/javascript-escapes#hexadecimal
			// Note: `-` (U+002D HYPHEN-MINUS) is escaped in this way rather
			// than by backslash-escaping, in case the output is used outside
			// of a character class in a `u` RegExp. /\-/u throws, but
			// /\x2D/u is fine.
			string = '\\x2D';
		}
		else if (codePoint == 0x5C) {
			string = '\\\\';
		}
		else if (
			codePoint == 0x24 ||
			(codePoint >= 0x28 && codePoint <= 0x2B) ||
			codePoint == 0x2E || codePoint == 0x2F ||
			codePoint == 0x3F ||
			(codePoint >= 0x5B && codePoint <= 0x5E) ||
			(codePoint >= 0x7B && codePoint <= 0x7D)
		) {
			// The code point maps to an unsafe printable ASCII character;
			// backslash-escape it. Here’s the list of those symbols:
			//
			//     $()*+./?[\]^{|}
			//
			// This matches SyntaxCharacters as well as `/` (U+002F SOLIDUS).
			// https://tc39.github.io/ecma262/#prod-SyntaxCharacter
			string = '\\' + stringFromCharCode(codePoint);
		}
		else if (codePoint >= 0x20 && codePoint <= 0x7E) {
			// The code point maps to one of these printable ASCII symbols
			// (including the space character):
			//
			//      !"#%&',/0123456789:;<=>@ABCDEFGHIJKLMNO
			//     PQRSTUVWXYZ_`abcdefghijklmnopqrstuvwxyz~
			//
			// These can safely be used directly.
			string = stringFromCharCode(codePoint);
		}
		else if (codePoint <= 0xFF) {
			string = '\\x' + pad(hex(codePoint), 2);
		}
		else { // `codePoint <= 0xFFFF` holds true.
			// https://mathiasbynens.be/notes/javascript-escapes#unicode
			string = '\\u' + pad(hex(codePoint), 4);
		}

		// There’s no need to account for astral symbols / surrogate pairs here,
		// since `codePointToString` is private and only used for BMP code points.
		// But if that’s what you need, just add an `else` block with this code:
		//
		//     string = '\\u' + pad(hex(highSurrogate(codePoint)), 4)
		//     	+ '\\u' + pad(hex(lowSurrogate(codePoint)), 4);

		return string;
	};

	var codePointToStringUnicode = function(codePoint) {
		if (codePoint <= 0xFFFF) {
			return codePointToString(codePoint);
		}
		return '\\u{' + codePoint.toString(16).toUpperCase() + '}';
	};

	var symbolToCodePoint = function(symbol) {
		var length = symbol.length;
		var first = symbol.charCodeAt(0);
		var second;
		if (
			first >= HIGH_SURROGATE_MIN && first <= HIGH_SURROGATE_MAX &&
			length > 1 // There is a next code unit.
		) {
			// `first` is a high surrogate, and there is a next character. Assume
			// it’s a low surrogate (else it’s invalid usage of Regenerate anyway).
			second = symbol.charCodeAt(1);
			// https://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
			return (first - HIGH_SURROGATE_MIN) * 0x400 +
				second - LOW_SURROGATE_MIN + 0x10000;
		}
		return first;
	};

	var createBMPCharacterClasses = function(data) {
		// Iterate over the data per `(start, end)` pair.
		var result = '';
		var index = 0;
		var start;
		var end;
		var length = data.length;
		if (dataIsSingleton(data)) {
			return codePointToString(data[0]);
		}
		while (index < length) {
			start = data[index];
			end = data[index + 1] - 1; // Note: the `- 1` makes `end` inclusive.
			if (start == end) {
				result += codePointToString(start);
			} else if (start + 1 == end) {
				result += codePointToString(start) + codePointToString(end);
			} else {
				result += codePointToString(start) + '-' + codePointToString(end);
			}
			index += 2;
		}
		return '[' + result + ']';
	};

	var createUnicodeCharacterClasses = function(data) {
		// Iterate over the data per `(start, end)` pair.
		var result = '';
		var index = 0;
		var start;
		var end;
		var length = data.length;
		if (dataIsSingleton(data)) {
			return codePointToStringUnicode(data[0]);
		}
		while (index < length) {
			start = data[index];
			end = data[index + 1] - 1; // Note: the `- 1` makes `end` inclusive.
			if (start == end) {
				result += codePointToStringUnicode(start);
			} else if (start + 1 == end) {
				result += codePointToStringUnicode(start) + codePointToStringUnicode(end);
			} else {
				result += codePointToStringUnicode(start) + '-' + codePointToStringUnicode(end);
			}
			index += 2;
		}
		return '[' + result + ']';
	};

	var splitAtBMP = function(data) {
		// Iterate over the data per `(start, end)` pair.
		var loneHighSurrogates = [];
		var loneLowSurrogates = [];
		var bmp = [];
		var astral = [];
		var index = 0;
		var start;
		var end;
		var length = data.length;
		while (index < length) {
			start = data[index];
			end = data[index + 1] - 1; // Note: the `- 1` makes `end` inclusive.

			if (start < HIGH_SURROGATE_MIN) {

				// The range starts and ends before the high surrogate range.
				// E.g. (0, 0x10).
				if (end < HIGH_SURROGATE_MIN) {
					bmp.push(start, end + 1);
				}

				// The range starts before the high surrogate range and ends within it.
				// E.g. (0, 0xD855).
				if (end >= HIGH_SURROGATE_MIN && end <= HIGH_SURROGATE_MAX) {
					bmp.push(start, HIGH_SURROGATE_MIN);
					loneHighSurrogates.push(HIGH_SURROGATE_MIN, end + 1);
				}

				// The range starts before the high surrogate range and ends in the low
				// surrogate range. E.g. (0, 0xDCFF).
				if (end >= LOW_SURROGATE_MIN && end <= LOW_SURROGATE_MAX) {
					bmp.push(start, HIGH_SURROGATE_MIN);
					loneHighSurrogates.push(HIGH_SURROGATE_MIN, HIGH_SURROGATE_MAX + 1);
					loneLowSurrogates.push(LOW_SURROGATE_MIN, end + 1);
				}

				// The range starts before the high surrogate range and ends after the
				// low surrogate range. E.g. (0, 0x10FFFF).
				if (end > LOW_SURROGATE_MAX) {
					bmp.push(start, HIGH_SURROGATE_MIN);
					loneHighSurrogates.push(HIGH_SURROGATE_MIN, HIGH_SURROGATE_MAX + 1);
					loneLowSurrogates.push(LOW_SURROGATE_MIN, LOW_SURROGATE_MAX + 1);
					if (end <= 0xFFFF) {
						bmp.push(LOW_SURROGATE_MAX + 1, end + 1);
					} else {
						bmp.push(LOW_SURROGATE_MAX + 1, 0xFFFF + 1);
						astral.push(0xFFFF + 1, end + 1);
					}
				}

			} else if (start >= HIGH_SURROGATE_MIN && start <= HIGH_SURROGATE_MAX) {

				// The range starts and ends in the high surrogate range.
				// E.g. (0xD855, 0xD866).
				if (end >= HIGH_SURROGATE_MIN && end <= HIGH_SURROGATE_MAX) {
					loneHighSurrogates.push(start, end + 1);
				}

				// The range starts in the high surrogate range and ends in the low
				// surrogate range. E.g. (0xD855, 0xDCFF).
				if (end >= LOW_SURROGATE_MIN && end <= LOW_SURROGATE_MAX) {
					loneHighSurrogates.push(start, HIGH_SURROGATE_MAX + 1);
					loneLowSurrogates.push(LOW_SURROGATE_MIN, end + 1);
				}

				// The range starts in the high surrogate range and ends after the low
				// surrogate range. E.g. (0xD855, 0x10FFFF).
				if (end > LOW_SURROGATE_MAX) {
					loneHighSurrogates.push(start, HIGH_SURROGATE_MAX + 1);
					loneLowSurrogates.push(LOW_SURROGATE_MIN, LOW_SURROGATE_MAX + 1);
					if (end <= 0xFFFF) {
						bmp.push(LOW_SURROGATE_MAX + 1, end + 1);
					} else {
						bmp.push(LOW_SURROGATE_MAX + 1, 0xFFFF + 1);
						astral.push(0xFFFF + 1, end + 1);
					}
				}

			} else if (start >= LOW_SURROGATE_MIN && start <= LOW_SURROGATE_MAX) {

				// The range starts and ends in the low surrogate range.
				// E.g. (0xDCFF, 0xDDFF).
				if (end >= LOW_SURROGATE_MIN && end <= LOW_SURROGATE_MAX) {
					loneLowSurrogates.push(start, end + 1);
				}

				// The range starts in the low surrogate range and ends after the low
				// surrogate range. E.g. (0xDCFF, 0x10FFFF).
				if (end > LOW_SURROGATE_MAX) {
					loneLowSurrogates.push(start, LOW_SURROGATE_MAX + 1);
					if (end <= 0xFFFF) {
						bmp.push(LOW_SURROGATE_MAX + 1, end + 1);
					} else {
						bmp.push(LOW_SURROGATE_MAX + 1, 0xFFFF + 1);
						astral.push(0xFFFF + 1, end + 1);
					}
				}

			} else if (start > LOW_SURROGATE_MAX && start <= 0xFFFF) {

				// The range starts and ends after the low surrogate range.
				// E.g. (0xFFAA, 0x10FFFF).
				if (end <= 0xFFFF) {
					bmp.push(start, end + 1);
				} else {
					bmp.push(start, 0xFFFF + 1);
					astral.push(0xFFFF + 1, end + 1);
				}

			} else {

				// The range starts and ends in the astral range.
				astral.push(start, end + 1);

			}

			index += 2;
		}
		return {
			'loneHighSurrogates': loneHighSurrogates,
			'loneLowSurrogates': loneLowSurrogates,
			'bmp': bmp,
			'astral': astral
		};
	};

	var optimizeSurrogateMappings = function(surrogateMappings) {
		var result = [];
		var tmpLow = [];
		var addLow = false;
		var mapping;
		var nextMapping;
		var highSurrogates;
		var lowSurrogates;
		var nextHighSurrogates;
		var nextLowSurrogates;
		var index = -1;
		var length = surrogateMappings.length;
		while (++index < length) {
			mapping = surrogateMappings[index];
			nextMapping = surrogateMappings[index + 1];
			if (!nextMapping) {
				result.push(mapping);
				continue;
			}
			highSurrogates = mapping[0];
			lowSurrogates = mapping[1];
			nextHighSurrogates = nextMapping[0];
			nextLowSurrogates = nextMapping[1];

			// Check for identical high surrogate ranges.
			tmpLow = lowSurrogates;
			while (
				nextHighSurrogates &&
				highSurrogates[0] == nextHighSurrogates[0] &&
				highSurrogates[1] == nextHighSurrogates[1]
			) {
				// Merge with the next item.
				if (dataIsSingleton(nextLowSurrogates)) {
					tmpLow = dataAdd(tmpLow, nextLowSurrogates[0]);
				} else {
					tmpLow = dataAddRange(
						tmpLow,
						nextLowSurrogates[0],
						nextLowSurrogates[1] - 1
					);
				}
				++index;
				mapping = surrogateMappings[index];
				highSurrogates = mapping[0];
				lowSurrogates = mapping[1];
				nextMapping = surrogateMappings[index + 1];
				nextHighSurrogates = nextMapping && nextMapping[0];
				nextLowSurrogates = nextMapping && nextMapping[1];
				addLow = true;
			}
			result.push([
				highSurrogates,
				addLow ? tmpLow : lowSurrogates
			]);
			addLow = false;
		}
		return optimizeByLowSurrogates(result);
	};

	var optimizeByLowSurrogates = function(surrogateMappings) {
		if (surrogateMappings.length == 1) {
			return surrogateMappings;
		}
		var index = -1;
		var innerIndex = -1;
		while (++index < surrogateMappings.length) {
			var mapping = surrogateMappings[index];
			var lowSurrogates = mapping[1];
			var lowSurrogateStart = lowSurrogates[0];
			var lowSurrogateEnd = lowSurrogates[1];
			innerIndex = index; // Note: the loop starts at the next index.
			while (++innerIndex < surrogateMappings.length) {
				var otherMapping = surrogateMappings[innerIndex];
				var otherLowSurrogates = otherMapping[1];
				var otherLowSurrogateStart = otherLowSurrogates[0];
				var otherLowSurrogateEnd = otherLowSurrogates[1];
				if (
					lowSurrogateStart == otherLowSurrogateStart &&
					lowSurrogateEnd == otherLowSurrogateEnd
				) {
					// Add the code points in the other item to this one.
					if (dataIsSingleton(otherMapping[0])) {
						mapping[0] = dataAdd(mapping[0], otherMapping[0][0]);
					} else {
						mapping[0] = dataAddRange(
							mapping[0],
							otherMapping[0][0],
							otherMapping[0][1] - 1
						);
					}
					// Remove the other, now redundant, item.
					surrogateMappings.splice(innerIndex, 1);
					--innerIndex;
				}
			}
		}
		return surrogateMappings;
	};

	var surrogateSet = function(data) {
		// Exit early if `data` is an empty set.
		if (!data.length) {
			return [];
		}

		// Iterate over the data per `(start, end)` pair.
		var index = 0;
		var start;
		var end;
		var startHigh;
		var startLow;
		var endHigh;
		var endLow;
		var surrogateMappings = [];
		var length = data.length;
		while (index < length) {
			start = data[index];
			end = data[index + 1] - 1;

			startHigh = highSurrogate(start);
			startLow = lowSurrogate(start);
			endHigh = highSurrogate(end);
			endLow = lowSurrogate(end);

			var startsWithLowestLowSurrogate = startLow == LOW_SURROGATE_MIN;
			var endsWithHighestLowSurrogate = endLow == LOW_SURROGATE_MAX;
			var complete = false;

			// Append the previous high-surrogate-to-low-surrogate mappings.
			// Step 1: `(startHigh, startLow)` to `(startHigh, LOW_SURROGATE_MAX)`.
			if (
				startHigh == endHigh ||
				startsWithLowestLowSurrogate && endsWithHighestLowSurrogate
			) {
				surrogateMappings.push([
					[startHigh, endHigh + 1],
					[startLow, endLow + 1]
				]);
				complete = true;
			} else {
				surrogateMappings.push([
					[startHigh, startHigh + 1],
					[startLow, LOW_SURROGATE_MAX + 1]
				]);
			}

			// Step 2: `(startHigh + 1, LOW_SURROGATE_MIN)` to
			// `(endHigh - 1, LOW_SURROGATE_MAX)`.
			if (!complete && startHigh + 1 < endHigh) {
				if (endsWithHighestLowSurrogate) {
					// Combine step 2 and step 3.
					surrogateMappings.push([
						[startHigh + 1, endHigh + 1],
						[LOW_SURROGATE_MIN, endLow + 1]
					]);
					complete = true;
				} else {
					surrogateMappings.push([
						[startHigh + 1, endHigh],
						[LOW_SURROGATE_MIN, LOW_SURROGATE_MAX + 1]
					]);
				}
			}

			// Step 3. `(endHigh, LOW_SURROGATE_MIN)` to `(endHigh, endLow)`.
			if (!complete) {
				surrogateMappings.push([
					[endHigh, endHigh + 1],
					[LOW_SURROGATE_MIN, endLow + 1]
				]);
			}

			index += 2;
		}

		// The format of `surrogateMappings` is as follows:
		//
		//     [ surrogateMapping1, surrogateMapping2 ]
		//
		// i.e.:
		//
		//     [
		//       [ highSurrogates1, lowSurrogates1 ],
		//       [ highSurrogates2, lowSurrogates2 ]
		//     ]
		return optimizeSurrogateMappings(surrogateMappings);
	};

	var createSurrogateCharacterClasses = function(surrogateMappings) {
		var result = [];
		forEach(surrogateMappings, function(surrogateMapping) {
			var highSurrogates = surrogateMapping[0];
			var lowSurrogates = surrogateMapping[1];
			result.push(
				createBMPCharacterClasses(highSurrogates) +
				createBMPCharacterClasses(lowSurrogates)
			);
		});
		return result.join('|');
	};

	var createCharacterClassesFromData = function(data, bmpOnly, hasUnicodeFlag) {
		if (hasUnicodeFlag) {
			return createUnicodeCharacterClasses(data);
		}
		var result = [];

		var parts = splitAtBMP(data);
		var loneHighSurrogates = parts.loneHighSurrogates;
		var loneLowSurrogates = parts.loneLowSurrogates;
		var bmp = parts.bmp;
		var astral = parts.astral;
		var hasLoneHighSurrogates = !dataIsEmpty(loneHighSurrogates);
		var hasLoneLowSurrogates = !dataIsEmpty(loneLowSurrogates);

		var surrogateMappings = surrogateSet(astral);

		if (bmpOnly) {
			bmp = dataAddData(bmp, loneHighSurrogates);
			hasLoneHighSurrogates = false;
			bmp = dataAddData(bmp, loneLowSurrogates);
			hasLoneLowSurrogates = false;
		}

		if (!dataIsEmpty(bmp)) {
			// The data set contains BMP code points that are not high surrogates
			// needed for astral code points in the set.
			result.push(createBMPCharacterClasses(bmp));
		}
		if (surrogateMappings.length) {
			// The data set contains astral code points; append character classes
			// based on their surrogate pairs.
			result.push(createSurrogateCharacterClasses(surrogateMappings));
		}
		// https://gist.github.com/mathiasbynens/bbe7f870208abcfec860
		if (hasLoneHighSurrogates) {
			result.push(
				createBMPCharacterClasses(loneHighSurrogates) +
				// Make sure the high surrogates aren’t part of a surrogate pair.
				'(?![\\uDC00-\\uDFFF])'
			);
		}
		if (hasLoneLowSurrogates) {
			result.push(
				// It is not possible to accurately assert the low surrogates aren’t
				// part of a surrogate pair, since JavaScript regular expressions do
				// not support lookbehind.
				'(?:[^\\uD800-\\uDBFF]|^)' +
				createBMPCharacterClasses(loneLowSurrogates)
			);
		}
		return result.join('|');
	};

	/*--------------------------------------------------------------------------*/

	// `regenerate` can be used as a constructor (and new methods can be added to
	// its prototype) but also as a regular function, the latter of which is the
	// documented and most common usage. For that reason, it’s not capitalized.
	var regenerate = function(value) {
		if (arguments.length > 1) {
			value = slice.call(arguments);
		}
		if (this instanceof regenerate) {
			this.data = [];
			return value ? this.add(value) : this;
		}
		return (new regenerate).add(value);
	};

	regenerate.version = '1.3.3';

	var proto = regenerate.prototype;
	extend(proto, {
		'add': function(value) {
			var $this = this;
			if (value == null) {
				return $this;
			}
			if (value instanceof regenerate) {
				// Allow passing other Regenerate instances.
				$this.data = dataAddData($this.data, value.data);
				return $this;
			}
			if (arguments.length > 1) {
				value = slice.call(arguments);
			}
			if (isArray(value)) {
				forEach(value, function(item) {
					$this.add(item);
				});
				return $this;
			}
			$this.data = dataAdd(
				$this.data,
				isNumber(value) ? value : symbolToCodePoint(value)
			);
			return $this;
		},
		'remove': function(value) {
			var $this = this;
			if (value == null) {
				return $this;
			}
			if (value instanceof regenerate) {
				// Allow passing other Regenerate instances.
				$this.data = dataRemoveData($this.data, value.data);
				return $this;
			}
			if (arguments.length > 1) {
				value = slice.call(arguments);
			}
			if (isArray(value)) {
				forEach(value, function(item) {
					$this.remove(item);
				});
				return $this;
			}
			$this.data = dataRemove(
				$this.data,
				isNumber(value) ? value : symbolToCodePoint(value)
			);
			return $this;
		},
		'addRange': function(start, end) {
			var $this = this;
			$this.data = dataAddRange($this.data,
				isNumber(start) ? start : symbolToCodePoint(start),
				isNumber(end) ? end : symbolToCodePoint(end)
			);
			return $this;
		},
		'removeRange': function(start, end) {
			var $this = this;
			var startCodePoint = isNumber(start) ? start : symbolToCodePoint(start);
			var endCodePoint = isNumber(end) ? end : symbolToCodePoint(end);
			$this.data = dataRemoveRange(
				$this.data,
				startCodePoint,
				endCodePoint
			);
			return $this;
		},
		'intersection': function(argument) {
			var $this = this;
			// Allow passing other Regenerate instances.
			// TODO: Optimize this by writing and using `dataIntersectionData()`.
			var array = argument instanceof regenerate ?
				dataToArray(argument.data) :
				argument;
			$this.data = dataIntersection($this.data, array);
			return $this;
		},
		'contains': function(codePoint) {
			return dataContains(
				this.data,
				isNumber(codePoint) ? codePoint : symbolToCodePoint(codePoint)
			);
		},
		'clone': function() {
			var set = new regenerate;
			set.data = this.data.slice(0);
			return set;
		},
		'toString': function(options) {
			var result = createCharacterClassesFromData(
				this.data,
				options ? options.bmpOnly : false,
				options ? options.hasUnicodeFlag : false
			);
			if (!result) {
				// For an empty set, return something that can be inserted `/here/` to
				// form a valid regular expression. Avoid `(?:)` since that matches the
				// empty string.
				return '[]';
			}
			// Use `\0` instead of `\x00` where possible.
			return result.replace(regexNull, '\\0$1');
		},
		'toRegExp': function(flags) {
			var pattern = this.toString(
				flags && flags.indexOf('u') != -1 ?
					{ 'hasUnicodeFlag': true } :
					null
			);
			return RegExp(pattern, flags || '');
		},
		'valueOf': function() { // Note: `valueOf` is aliased as `toArray`.
			return dataToArray(this.data);
		}
	});

	proto.toArray = proto.valueOf;

	// Some AMD build optimizers, like r.js, check for specific condition patterns
	// like the following:
	if (
		typeof define == 'function' &&
		typeof define.amd == 'object' &&
		define.amd
	) {
		define(function() {
			return regenerate;
		});
	}	else if (freeExports && !freeExports.nodeType) {
		if (freeModule) { // in Node.js, io.js, or RingoJS v0.8.0+
			freeModule.exports = regenerate;
		} else { // in Narwhal or RingoJS v0.7.0-
			freeExports.regenerate = regenerate;
		}
	} else { // in Rhino or a web browser
		root.regenerate = regenerate;
	}

}(this));


/***/ }),
/* 389 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var baseTimes = __webpack_require__(553),
    isArguments = __webpack_require__(460),
    isArray = __webpack_require__(143),
    isBuffer = __webpack_require__(546),
    isIndex = __webpack_require__(160),
    isTypedArray = __webpack_require__(850);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = arrayLikeKeys;


/***/ }),
/* 390 */
/***/ (function(__unusedmodule, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeOptions = mergeOptions;

function mergeOptions(target, source) {
  for (const k of Object.keys(source)) {
    if (k === "parserOpts" && source.parserOpts) {
      const parserOpts = source.parserOpts;
      const targetObj = target.parserOpts = target.parserOpts || {};
      mergeDefaultFields(targetObj, parserOpts);
    } else if (k === "generatorOpts" && source.generatorOpts) {
      const generatorOpts = source.generatorOpts;
      const targetObj = target.generatorOpts = target.generatorOpts || {};
      mergeDefaultFields(targetObj, generatorOpts);
    } else {
      const val = source[k];
      if (val !== undefined) target[k] = val;
    }
  }
}

function mergeDefaultFields(target, source) {
  for (const k of Object.keys(source)) {
    const val = source[k];
    if (val !== undefined) target[k] = val;
  }
}

/***/ }),
/* 391 */
/***/ (function(module, __unusedexports, __webpack_require__) {

var current = (process.versions && process.versions.node && process.versions.node.split('.')) || [];

function specifierIncluded(specifier) {
    var parts = specifier.split(' ');
    var op = parts.length > 1 ? parts[0] : '=';
    var versionParts = (parts.length > 1 ? parts[1] : parts[0]).split('.');

    for (var i = 0; i < 3; ++i) {
        var cur = Number(current[i] || 0);
        var ver = Number(versionParts[i] || 0);
        if (cur === ver) {
            continue; // eslint-disable-line no-restricted-syntax, no-continue
        }
        if (op === '<') {
            return cur < ver;
        } else if (op === '>=') {
            return cur >= ver;
        } else {
            return false;
        }
    }
    return op === '>=';
}

function matchesRange(range) {
    var specifiers = range.split(/ ?&& ?/);
    if (specifiers.length === 0) { return false; }
    for (var i = 0; i < specifiers.length; ++i) {
        if (!specifierIncluded(specifiers[i])) { return false; }
    }
    return true;
}

function versionIncluded(specifierValue) {
    if (typeof specifierValue === 'boolean') { return specifierValue; }
    if (specifierValue && typeof specifierValue === 'object') {
        for (var i = 0; i < specifierValue.length; ++i) {
            if (matchesRange(specifierValue[i])) { return true; }
        }
        return false;
    }
    return matchesRange(specifierValue);
}

var data = __webpack_require__(529);

var core = {};
for (var mod in data) { // eslint-disable-line no-restricted-syntax
    if (Object.prototype.hasOwnProperty.call(data, mod)) {
        core[mod] = versionIncluded(data[mod]);
    }
}
module.exports = core;


/***/ }),
/* 392 */
/***/ (function(__unusedmodule, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = populatePlaceholders;

var t = _interopRequireWildcard(__webpack_require__(978));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function populatePlaceholders(metadata, replacements) {
  const ast = t.cloneNode(metadata.ast);

  if (replacements) {
    metadata.placeholders.forEach(placeholder => {
      if (!Object.prototype.hasOwnProperty.call(replacements, placeholder.name)) {
        const placeholderName = placeholder.name;
        throw new Error(`Error: No substitution given for "${placeholderName}". If this is not meant to be a
            placeholder you may want to consider passing one of the following options to @babel/template:
            - { placeholderPattern: false, placeholderWhitelist: new Set(['${placeholderName}'])}
            - { placeholderPattern: /^${placeholderName}$/ }`);
      }
    });
    Object.keys(replacements).forEach(key => {
      if (!metadata.placeholderNames.has(key)) {
        throw new Error(`Unknown substitution "${key}" given`);
      }
    });
  }

  metadata.placeholders.slice().reverse().forEach(placeholder => {
    try {
      applyReplacement(placeholder, ast, replacements && replacements[placeholder.name] || null);
    } catch (e) {
      e.message = `@babel/template placeholder "${placeholder.name}": ${e.message}`;
      throw e;
    }
  });
  return ast;
}

function applyReplacement(placeholder, ast, replacement) {
  if (placeholder.isDuplicate) {
    if (Array.isArray(replacement)) {
      replacement = replacement.map(node => t.cloneNode(node));
    } else if (typeof replacement === "object") {
      replacement = t.cloneNode(replacement);
    }
  }

  const {
    parent,
    key,
    index
  } = placeholder.resolve(ast);

  if (placeholder.type === "string") {
    if (typeof replacement === "string") {
      replacement = t.stringLiteral(replacement);
    }

    if (!replacement || !t.isStringLiteral(replacement)) {
      throw new Error("Expected string substitution");
    }
  } else if (placeholder.type === "statement") {
    if (index === undefined) {
      if (!replacement) {
        replacement = t.emptyStatement();
      } else if (Array.isArray(replacement)) {
        replacement = t.blockStatement(replacement);
      } else if (typeof replacement === "string") {
        replacement = t.expressionStatement(t.identifier(replacement));
      } else if (!t.isStatement(replacement)) {
        replacement = t.expressionStatement(replacement);
      }
    } else {
      if (replacement && !Array.isArray(replacement)) {
        if (typeof replacement === "string") {
          replacement = t.identifier(replacement);
        }

        if (!t.isStatement(replacement)) {
          replacement = t.expressionStatement(repla