/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.widget.unit;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import nectec.thai.unit.Area;
import nectec.thai.widget.ViewUtils;
import nectec.thai.widget.unit.AreaPickerDialog;
import nectec.thai.widget.unit.AreaPopup;
import nectec.thai.widget.unit.AreaSaveState;
import nectec.thai.widget.unit.AreaView;

public class AreaPicker
extends EditText
implements AreaView,
View.OnClickListener {
    protected static final String HINT_MESSAGE = "\u0e23\u0e30\u0e1a\u0e38\u0e02\u0e19\u0e32\u0e14\u0e1e\u0e37\u0e49\u0e19\u0e17\u0e35\u0e48";
    private AreaPopup popup;
    private Area area = new Area(0);
    private AreaView.OnAreaChangedListener listener;
    private final AreaPickerDialog.OnAreaPickListener dialogListener = new AreaPickerDialog.OnAreaPickListener(){

        @Override
        public void onAreaPick(Area area) {
            AreaPicker.this.setArea(area);
        }

        @Override
        public void onCancel() {
            AreaPicker.this.setText(null);
            AreaPicker.this.setArea(new Area(0));
        }
    };

    public AreaPicker(Context context) {
        this(context, null);
    }

    public AreaPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public AreaPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (TextUtils.isEmpty((CharSequence)this.getHint())) {
            this.setHint(HINT_MESSAGE);
        }
        this.setGravity(16);
        ViewUtils.updatePaddingRight((View)this);
        if (!this.isInEditMode()) {
            this.setupPickerDialog();
        }
    }

    private void setupPickerDialog() {
        this.popup = new AreaPickerDialog(this.getContext(), this.dialogListener);
        this.setOnClickListener(this);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.setFocusable(false);
        this.setLongClickable(false);
        this.setClickable(true);
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    public void onClick(View view) {
        this.popup.show(this.area);
    }

    public Parcelable onSaveInstanceState() {
        if (this.area == null) {
            return super.onSaveInstanceState();
        }
        Parcelable parcelable = super.onSaveInstanceState();
        AreaSaveState savedState = new AreaSaveState(parcelable);
        savedState.setArea(this.area);
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof AreaSaveState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        AreaSaveState ss = (AreaSaveState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setArea(ss.getArea());
    }

    @Override
    public void setArea(Area area) {
        if (area == null) {
            throw new IllegalArgumentException("area must not be null");
        }
        this.area = area;
        this.setText(area.prettyPrint());
        if (this.listener != null) {
            this.listener.onAreaChanged(area);
        }
    }

    public void setTitle(String title) {
        this.popup.setPopupTitle(title);
    }

    public void setOnAreaChangeListener(AreaView.OnAreaChangedListener listener) {
        this.listener = listener;
    }
}

