/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.widget.identity;

import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.widget.EditText;
import nectec.thai.identity.Identity;

public abstract class IdentityEditTextHandler
implements TextWatcher {
    private EditText editText;
    private boolean watching = true;
    private Identity id;

    public IdentityEditTextHandler(EditText editText) {
        this.editText = editText;
        this.id = this.onCreateNewId(editText.getText().toString());
        editText.setInputType(2);
        editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.getMaxLength())});
        editText.setKeyListener((KeyListener)DigitsKeyListener.getInstance((boolean)false, (boolean)true));
        editText.addTextChangedListener((TextWatcher)this);
    }

    protected abstract int getMaxLength();

    protected abstract Identity onCreateNewId(String var1);

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable editable) {
        if (this.watching) {
            this.onIdChanged(editable);
        }
    }

    void onIdChanged(Editable editable) {
        Identity id2 = this.onCreateNewId(editable.toString());
        this.updateText(id2);
        this.updateErrorMessage(id2);
    }

    private void updateText(Identity id2) {
        String newText = id2.prettyPrint();
        String currentText = this.editText.getText().toString();
        if (newText.length() > currentText.length()) {
            this.watching = false;
            this.id = id2;
            this.editText.setText((CharSequence)newText);
            this.editText.setSelection(newText.length());
            this.watching = true;
        }
    }

    private void updateErrorMessage(Identity id2) {
        if (id2.isValidFormat()) {
            this.editText.setError((CharSequence)(id2.validate() ? null : this.getErrorMessage()));
        } else {
            this.editText.setError(null);
        }
    }

    protected abstract String getErrorMessage();

    public Identity getId() {
        return this.id;
    }
}

