/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.address;

import nectec.thai.address.AddressEntity;
import nectec.thai.address.InvalidAddressCodeFormatException;
import nectec.util.TextUtils;

public class District
implements AddressEntity,
Comparable<District> {
    private final String code;
    private final String name;

    public District(String code, String name) {
        if (code.length() != 4 || !TextUtils.isDigitOnly(code)) {
            throw new InvalidAddressCodeFormatException.InvalidDistrictCodeException(code);
        }
        this.code = code;
        this.name = name;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getProvinceCode() {
        return this.code.substring(0, 2);
    }

    public int hashCode() {
        int result = this.code.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        District otherDistrict = (District)other;
        return this.code.equals(otherDistrict.code) && this.name.equals(otherDistrict.name);
    }

    public String toString() {
        return "District{code='" + this.code + '\'' + ", name='" + this.name + '\'' + '}';
    }

    @Override
    public int compareTo(District that) {
        return this.name.compareTo(that.name);
    }
}

