/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.widget.address.repository;

import android.content.Context;
import nectec.thai.address.Address;
import nectec.thai.address.District;
import nectec.thai.address.InvalidAddressCodeFormatException;
import nectec.thai.address.Province;
import nectec.thai.address.SubDistrict;
import nectec.thai.widget.address.repository.DistrictRepository;
import nectec.thai.widget.address.repository.ProvinceRepository;
import nectec.thai.widget.address.repository.SubDistrictRepository;
import nectec.util.TextUtils;

public final class AddressRepositoryImpl {
    private static AddressRepositoryImpl instance;
    private final ProvinceRepository provinceRepository;
    private final DistrictRepository districtRepository;
    private final SubDistrictRepository subDistrictRepository;

    private AddressRepositoryImpl(SubDistrictRepository subDistrictRepository, DistrictRepository districtRepository, ProvinceRepository provinceRepository) {
        this.subDistrictRepository = subDistrictRepository;
        this.districtRepository = districtRepository;
        this.provinceRepository = provinceRepository;
    }

    public static AddressRepositoryImpl getInstance(Context context) {
        if (instance == null) {
            instance = new AddressRepositoryImpl(SubDistrictRepository.getInstance(context), DistrictRepository.getInstance(context), ProvinceRepository.getInstance(context));
        }
        return instance;
    }

    public Address findByCode(String subDistrictCode) {
        if (subDistrictCode.length() != 6 || !TextUtils.isDigitOnly(subDistrictCode)) {
            throw new InvalidAddressCodeFormatException.InvalidSubDistrictCodeException(subDistrictCode);
        }
        SubDistrict subDistrict = this.subDistrictRepository.findByCode(subDistrictCode);
        District district = this.districtRepository.findByCode(subDistrict.getDistrictCode());
        Province province = this.provinceRepository.findByCode(district.getProvinceCode());
        return new Address(subDistrict, district, province);
    }
}

