/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.identity;

import nectec.thai.identity.IdPrettyPrinter;
import nectec.thai.identity.Identity;
import nectec.thai.identity.PrettyPrinter;
import nectec.util.TextUtils;

public class CitizenId
implements Identity {
    private static final int[] MULTIPLIER_TABLE = new int[]{13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final int LENGTH = 13;
    private final String id;
    private final PrettyPrinter printer = new IdPrettyPrinter(){

        @Override
        protected boolean positionToInsertSeparatorBefore(int position) {
            switch (position) {
                case 1: 
                case 5: 
                case 10: 
                case 12: {
                    return true;
                }
            }
            return false;
        }
    };

    public CitizenId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.id = id = id.replace(this.printer.separator(), "");
    }

    public static boolean isValid(String id) {
        CitizenId cid = new CitizenId(id);
        return cid.validate();
    }

    @Override
    public boolean validate() {
        return this.isValidFormat() && !this.isRepeatNumber() && this.calculateCheckDigit() == this.getCheckDigit();
    }

    @Override
    public boolean isValidFormat() {
        return this.id.length() == 13 && TextUtils.isDigitOnly(this.id);
    }

    private boolean isRepeatNumber() {
        String idWithoutCheckDigit = this.id.substring(0, 12);
        return TextUtils.isRepeatingNumber(idWithoutCheckDigit) || TextUtils.isRepeatPatternNumber(idWithoutCheckDigit);
    }

    protected int getCheckDigit() {
        int lastIndex = 12;
        return Character.digit(this.id.charAt(lastIndex), 10);
    }

    protected int calculateCheckDigit() {
        int sum = 0;
        for (int position = 0; position < 12; ++position) {
            sum += Character.digit(this.id.charAt(position), 10) * MULTIPLIER_TABLE[position];
        }
        int x = sum % 11;
        return (11 - x) % 10;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CitizenId)) {
            return false;
        }
        CitizenId citizenId = (CitizenId)o;
        return this.id.equals(citizenId.id);
    }

    public String toString() {
        return this.printer.print(this.id);
    }

    @Override
    public String prettyPrint() {
        return this.printer.print(this.id);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

