/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.widget.unit;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.NumberPicker;
import nectec.thai.unit.Area;
import th.or.nectec.thai.widget.R;
import th.or.nectec.thai.widget.unit.AreaPopup;
import th.or.nectec.thai.widget.utils.ViewUtils;

public class AreaPickerDialog
extends AlertDialog
implements AreaPopup {
    public static final String DEFALT_TITLE = "\u0e23\u0e30\u0e1a\u0e38\u0e02\u0e19\u0e32\u0e14\u0e1e\u0e37\u0e49\u0e19\u0e17\u0e35\u0e48";
    private final OnAreaPickListener onAreaPickListener;
    private final DialogInterface.OnClickListener onNegativeButtonClick = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialogInterface, int i) {
            AreaPickerDialog.this.onAreaPickListener.onCancel();
            AreaPickerDialog.this.dismiss();
        }
    };
    private NumberPicker rai;
    private NumberPicker ngan;
    private NumberPicker squareWa;
    private final DialogInterface.OnClickListener onPositiveButtonClick = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialogInterface, int i) {
            View currentFocus = AreaPickerDialog.this.getCurrentFocus();
            if (currentFocus != null) {
                currentFocus.clearFocus();
            }
            Area area = new Area(AreaPickerDialog.this.rai.getValue(), AreaPickerDialog.this.ngan.getValue(), AreaPickerDialog.this.squareWa.getValue());
            AreaPickerDialog.this.onAreaPickListener.onAreaPick(area);
            AreaPickerDialog.this.dismiss();
        }
    };

    public AreaPickerDialog(Context context, OnAreaPickListener listener) {
        super(context);
        this.onAreaPickListener = listener;
        this.setTitle(DEFALT_TITLE);
        this.setupView(context);
    }

    private void setupView(Context context) {
        View view = ViewUtils.inflateView(context, R.layout.dialog_area_picker);
        this.setView(view);
        this.findView(view);
        this.initRai();
        this.initNgan();
        this.initSquareWa();
        this.initButton();
    }

    private void findView(View view) {
        this.rai = (NumberPicker)view.findViewById(R.id.rai);
        this.ngan = (NumberPicker)view.findViewById(R.id.ngan);
        this.squareWa = (NumberPicker)view.findViewById(R.id.squareWa);
    }

    private void initRai() {
        this.rai.setMaxValue(10000);
        this.rai.setMinValue(0);
        this.rai.setValue(0);
    }

    private void initNgan() {
        this.ngan.setMaxValue(3);
        this.ngan.setMinValue(0);
        this.ngan.setValue(0);
    }

    private void initSquareWa() {
        this.squareWa.setMaxValue(99);
        this.squareWa.setMinValue(0);
        this.squareWa.setValue(0);
    }

    private void initButton() {
        this.setButton(-1, this.getContext().getString(R.string.ok), this.onPositiveButtonClick);
        this.setButton(-2, this.getContext().getString(R.string.cancel), this.onNegativeButtonClick);
    }

    @Override
    public void setPopupTitle(String title) {
        this.setTitle(title);
    }

    @Override
    public void show(Area area) {
        this.updateValue(area);
        this.show();
    }

    private void updateValue(Area area) {
        this.rai.setValue(area.getRai());
        this.ngan.setValue(area.getNgan());
        this.squareWa.setValue((int)Math.round(area.getSquareWa()));
    }

    public static interface OnAreaPickListener {
        public void onAreaPick(Area var1);

        public void onCancel();
    }
}

