/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.widget.unit;

import android.content.Context;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import th.or.nectec.thai.unit.Area;
import th.or.nectec.thai.widget.unit.AreaPickerDialog;
import th.or.nectec.thai.widget.unit.AreaSaveState;
import th.or.nectec.thai.widget.unit.AreaView;
import th.or.nectec.thai.widget.utils.ViewUtils;

public class AreaPicker
extends TextView
implements AreaView,
View.OnClickListener {
    protected static final String HINT_MESSAGE = "\u0e23\u0e30\u0e1a\u0e38\u0e02\u0e19\u0e32\u0e14\u0e1e\u0e37\u0e49\u0e19\u0e17\u0e35\u0e48";
    private AreaPopup pickerDialog;
    private Area area = new Area(0);
    private final AreaPickerDialog.OnAreaPickListener listener = new AreaPickerDialog.OnAreaPickListener(){

        @Override
        public void onAreaPick(Area area) {
            AreaPicker.this.setArea(area);
        }

        @Override
        public void onCancel() {
            AreaPicker.this.setText(null);
            AreaPicker.this.setArea(Area.fromSquareMeter((int)0));
        }
    };

    public AreaPicker(Context context) {
        this(context, null);
    }

    public AreaPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010081);
    }

    public AreaPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setHint(HINT_MESSAGE);
        this.setGravity(16);
        ViewUtils.updatePaddingRight((View)this);
        if (!this.isInEditMode()) {
            this.setupPickerDialog();
        }
    }

    private void setupPickerDialog() {
        this.pickerDialog = new AreaPickerDialog(this.getContext(), this.listener);
        this.setOnClickListener(this);
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    @Override
    public void setArea(Area area) {
        if (area == null) {
            throw new IllegalArgumentException("area must not be null");
        }
        this.area = area;
        this.setText(area.prettyPrint());
    }

    public void onClick(View view) {
        this.pickerDialog.show(this.area);
    }

    public Parcelable onSaveInstanceState() {
        if (this.area == null) {
            return super.onSaveInstanceState();
        }
        Parcelable parcelable = super.onSaveInstanceState();
        AreaSaveState savedState = new AreaSaveState(parcelable);
        savedState.setArea(this.area);
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof AreaSaveState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        AreaSaveState ss = (AreaSaveState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setArea(ss.getArea());
    }

    static interface AreaPopup {
        public void show(Area var1);
    }
}

