/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.widget.address.repository;

import android.content.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import th.or.nectec.thai.address.AddressRepository;
import th.or.nectec.thai.address.InvalidAddressCodeFormatException;
import th.or.nectec.thai.address.Province;
import th.or.nectec.thai.address.Region;
import th.or.nectec.thai.widget.address.repository.JsonParser;

public class ProvinceRepository
implements AddressRepository<Province> {
    private static ProvinceRepository instance;
    private List<Province> allProvince = new ArrayList<Province>();

    private ProvinceRepository(Context context) {
        this.allProvince = JsonParser.parse(context, "province.json", Province.class);
        Collections.sort(this.allProvince);
    }

    public static ProvinceRepository getInstance(Context context) {
        if (instance == null) {
            instance = new ProvinceRepository(context);
        }
        return instance;
    }

    public List<Province> find() {
        return this.allProvince;
    }

    public List<Province> findByParentCode(String regionName) {
        Region region = Region.fromName((String)regionName);
        ArrayList<Province> queryProvince = new ArrayList<Province>();
        for (Province eachProvince : this.allProvince) {
            if (!eachProvince.getRegion().equals((Object)region)) continue;
            queryProvince.add(eachProvince);
        }
        return queryProvince.isEmpty() ? null : queryProvince;
    }

    public Province findByCode(String provinceCode) {
        if (provinceCode.length() != 2) {
            throw new InvalidAddressCodeFormatException.InvalidProvinceCodeException(provinceCode);
        }
        for (Province eachProvince : this.allProvince) {
            if (!eachProvince.getCode().equals(provinceCode)) continue;
            return eachProvince;
        }
        return null;
    }
}

