/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.widget.address;

import android.content.Context;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.widget.Button;
import th.or.nectec.thai.address.Address;
import th.or.nectec.thai.widget.address.AddressPickerDialog;
import th.or.nectec.thai.widget.address.AddressPopup;
import th.or.nectec.thai.widget.address.AddressSavedState;
import th.or.nectec.thai.widget.address.AddressView;
import th.or.nectec.thai.widget.address.repository.AddressRepositoryImpl;
import th.or.nectec.thai.widget.thai.R;

public class AddressPicker
extends Button
implements AddressView {
    private Address address;
    private AddressRepositoryImpl addressRepository;
    private AddressPopup popup;
    private AddressView.OnAddressChangedListener onAddressChangedListener;
    private AddressView.OnAddressChangedListener onPopupAddressChangedListener = new AddressView.OnAddressChangedListener(){

        @Override
        public void onAddressChanged(Address address) {
            AddressPicker.this.setAddressCode(address.getCode());
            if (AddressPicker.this.onAddressChangedListener != null) {
                AddressPicker.this.onAddressChangedListener.onAddressChanged(address);
            }
        }

        @Override
        public void onAddressCanceled() {
            AddressPicker.this.emptyView();
            if (AddressPicker.this.onAddressChangedListener != null) {
                AddressPicker.this.onAddressChangedListener.onAddressCanceled();
            }
        }
    };

    public AddressPicker(Context context) {
        this(context, null);
    }

    public AddressPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010081);
    }

    public AddressPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.emptyView();
        this.addressRepository = AddressRepositoryImpl.getInstance(context);
        this.popup = new AddressPickerDialog(context, this.onPopupAddressChangedListener);
    }

    private void emptyView() {
        this.address = null;
        this.setText(R.string.please_define_address);
    }

    public void setPopup(AddressPopup popup) {
        this.popup = popup;
        this.popup.setOnAddressChangedListener(this.onPopupAddressChangedListener);
    }

    public boolean performClick() {
        this.popup.show(this.address);
        return true;
    }

    public Parcelable onSaveInstanceState() {
        if (this.address == null) {
            return super.onSaveInstanceState();
        }
        Parcelable parcelable = super.onSaveInstanceState();
        AddressSavedState savedState = new AddressSavedState(parcelable);
        savedState.addressCode = this.address.getCode();
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof AddressSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        AddressSavedState ss = (AddressSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setAddressCode(ss.addressCode);
    }

    @Override
    public void setAddressCode(String addressCode) {
        this.address = this.addressRepository.findByCode(addressCode);
        if (this.address != null) {
            this.setText(this.address.getName());
        }
    }

    @Override
    public void setOnAddressChangedListener(AddressView.OnAddressChangedListener onAddressChangedListener) {
        this.onAddressChangedListener = onAddressChangedListener;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }
}

