/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.widget.address.repository;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import th.or.nectec.thai.address.AddressRepository;
import th.or.nectec.thai.address.District;
import th.or.nectec.thai.address.InvalidAddressCodeFormatException;
import th.or.nectec.thai.widget.address.repository.JsonParser;

public class DistrictRepository
implements AddressRepository<District> {
    private static DistrictRepository instance;
    private List<District> allDistrict = new ArrayList<District>();

    private DistrictRepository(Context context) {
        this.allDistrict = JsonParser.parse(context, "district.json", District.class);
    }

    public static DistrictRepository getInstance(Context context) {
        if (instance == null) {
            instance = new DistrictRepository(context);
        }
        return instance;
    }

    public List<District> find() {
        return this.allDistrict;
    }

    public List<District> findByParentCode(String provinceCode) {
        if (provinceCode.length() != 2) {
            throw new InvalidAddressCodeFormatException.InvalidProvinceCodeException(provinceCode);
        }
        ArrayList<District> queryDistrict = new ArrayList<District>();
        for (District eachDistrict : this.allDistrict) {
            String queryDistrictCode = eachDistrict.getCode();
            if (!queryDistrictCode.startsWith(provinceCode)) continue;
            queryDistrict.add(eachDistrict);
        }
        return queryDistrict.isEmpty() ? null : queryDistrict;
    }

    public District findByCode(String districtCode) {
        if (districtCode.length() != 4) {
            throw new InvalidAddressCodeFormatException.InvalidDistrictCodeException(districtCode);
        }
        for (District eachDistrict : this.allDistrict) {
            String queryDistrictCode = eachDistrict.getCode();
            if (!queryDistrictCode.startsWith(districtCode)) continue;
            return eachDistrict;
        }
        return null;
    }
}

