/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.address;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import th.or.nectec.android.widget.thai.address.JsonAdapter;
import th.or.nectec.domain.thai.address.SubdistrictRepository;
import th.or.nectec.entity.thai.InvalidCodeFormatException;
import th.or.nectec.entity.thai.Subdistrict;

class InMemoryJsonSubdistrictRepository
implements SubdistrictRepository {
    private static InMemoryJsonSubdistrictRepository instance;
    ArrayList<Subdistrict> allSubdistrict = new ArrayList();

    private InMemoryJsonSubdistrictRepository(Context context) {
        this.allSubdistrict = JsonAdapter.parse(context, "subdistrict.json", Subdistrict.class);
    }

    public static InMemoryJsonSubdistrictRepository getInstance(Context context) {
        if (instance == null) {
            instance = new InMemoryJsonSubdistrictRepository(context);
        }
        return instance;
    }

    public List<Subdistrict> findByDistrictCode(String districtCode) {
        if (districtCode.length() != 4) {
            throw new InvalidCodeFormatException();
        }
        ArrayList<Subdistrict> querySubdistrict = new ArrayList<Subdistrict>();
        for (Subdistrict eachSubdistrict : this.allSubdistrict) {
            String queryAddressCode = eachSubdistrict.getDistrictCode();
            if (!queryAddressCode.equals(districtCode)) continue;
            querySubdistrict.add(eachSubdistrict);
        }
        return querySubdistrict.isEmpty() ? null : querySubdistrict;
    }

    public Subdistrict findBySubdistrictCode(String addressCode) {
        for (Subdistrict eachSubdistrict : this.allSubdistrict) {
            String queryAddressCode = eachSubdistrict.getCode();
            if (!queryAddressCode.equals(addressCode)) continue;
            return eachSubdistrict;
        }
        return null;
    }

    public ArrayList<Subdistrict> findByName(String subdistrict) {
        ArrayList<Subdistrict> subdistricts = new ArrayList<Subdistrict>();
        for (Subdistrict eachSubdistrict : this.allSubdistrict) {
            if (!eachSubdistrict.getName().equals(subdistrict)) continue;
            subdistricts.add(eachSubdistrict);
        }
        return subdistricts.isEmpty() ? null : subdistricts;
    }
}

