/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.address;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import th.or.nectec.android.widget.thai.address.JsonAdapter;
import th.or.nectec.domain.thai.address.ProvinceRepository;
import th.or.nectec.entity.thai.Province;
import th.or.nectec.entity.thai.Region;

class InMemoryJsonProvinceRepository
implements ProvinceRepository {
    private static InMemoryJsonProvinceRepository instance;
    ArrayList<Province> allProvince = new ArrayList();

    private InMemoryJsonProvinceRepository(Context context) {
        this.allProvince = JsonAdapter.parse(context, "province.json", Province.class);
    }

    public static InMemoryJsonProvinceRepository getInstance(Context context) {
        if (instance == null) {
            instance = new InMemoryJsonProvinceRepository(context);
        }
        return instance;
    }

    public List<Province> findByRegion(Region targetRegion) {
        ArrayList<Province> queryProvince = new ArrayList<Province>();
        for (Province eachProvince : this.allProvince) {
            if (!eachProvince.getRegion().equals((Object)targetRegion)) continue;
            queryProvince.add(eachProvince);
        }
        return queryProvince.isEmpty() ? null : queryProvince;
    }

    public Province findByProvinceCode(String provinceCode) {
        for (Province eachProvince : this.allProvince) {
            if (!eachProvince.getCode().equals(provinceCode)) continue;
            return eachProvince;
        }
        return null;
    }

    public List<Province> find() {
        return this.allProvince;
    }
}

