/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.address;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import th.or.nectec.android.widget.thai.address.JsonAdapter;
import th.or.nectec.domain.thai.address.DistrictRepository;
import th.or.nectec.entity.thai.District;
import th.or.nectec.entity.thai.InvalidCodeFormatException;

class InMemoryJsonDistrictRepository
implements DistrictRepository {
    private static InMemoryJsonDistrictRepository instance;
    ArrayList<District> allDistrict = new ArrayList();

    private InMemoryJsonDistrictRepository(Context context) {
        this.allDistrict = JsonAdapter.parse(context, "district.json", District.class);
    }

    public static InMemoryJsonDistrictRepository getInstance(Context context) {
        if (instance == null) {
            instance = new InMemoryJsonDistrictRepository(context);
        }
        return instance;
    }

    public List<District> findByProvinceCode(String provinceCode) {
        if (provinceCode.length() != 2) {
            throw new InvalidCodeFormatException();
        }
        ArrayList<District> queryDistrict = new ArrayList<District>();
        for (District eachDistrict : this.allDistrict) {
            String queryDistrictCode = eachDistrict.getCode();
            if (!queryDistrictCode.startsWith(provinceCode)) continue;
            queryDistrict.add(eachDistrict);
        }
        return queryDistrict.isEmpty() ? null : queryDistrict;
    }

    public District findByDistrictCode(String districtCode) {
        if (districtCode.length() != 4) {
            throw new InvalidCodeFormatException();
        }
        for (District eachDistrict : this.allDistrict) {
            String queryDistrictCode = eachDistrict.getCode();
            if (!queryDistrictCode.startsWith(districtCode)) continue;
            return eachDistrict;
        }
        return null;
    }
}

