/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.address;

import android.content.Context;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.widget.Button;
import android.widget.TextView;
import th.or.nectec.android.widget.thai.OnAddressChangedListener;
import th.or.nectec.android.widget.thai.address.AddressPickerHandler;
import th.or.nectec.android.widget.thai.address.AddressSavedState;
import th.or.nectec.android.widget.thai.address.AddressView;
import th.or.nectec.entity.thai.Address;

public class AddressPicker
extends Button
implements AddressView {
    AddressPickerHandler addressPickerHandler;

    public AddressPicker(Context context) {
        this(context, null);
    }

    public AddressPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010081);
    }

    public AddressPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.addressPickerHandler = new AddressPickerHandler((TextView)this, context);
    }

    public boolean performClick() {
        return this.addressPickerHandler.performClick();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        AddressSavedState savedState = new AddressSavedState(parcelable);
        Address address = this.addressPickerHandler.getAddress();
        savedState.addressCode = address == null ? null : address.getSubdistrictCode();
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof AddressSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        AddressSavedState ss = (AddressSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setAddressCode(ss.addressCode);
    }

    @Override
    public void setAddressCode(String addressCode) {
        this.addressPickerHandler.setAddressCode(addressCode);
    }

    @Override
    public void setAddress(String subdistrict, String district, String province) {
        this.addressPickerHandler.setAddress(subdistrict, district, province);
    }

    @Override
    public void setOnAddressChangedListener(OnAddressChangedListener onAddressChangedListener) {
        this.addressPickerHandler.setOnAddressChangedListener(onAddressChangedListener);
    }

    @Override
    public Address getAddress() {
        return this.addressPickerHandler.getAddress();
    }
}

