/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import th.or.nectec.android.widget.thai.AreaPickerDialog;
import th.or.nectec.android.widget.thai.AreaView;
import th.or.nectec.domain.thai.Area;

public class AreaPicker
extends TextView
implements AreaView {
    public static final String DEFAULT_MESSAGE = "\u0e23\u0e30\u0e1a\u0e38\u0e02\u0e19\u0e32\u0e14\u0e1e\u0e37\u0e49\u0e19\u0e17\u0e35\u0e48";
    AreaPickerDialog pickerDialog;
    private Area area = new Area(0);
    private AreaPickerDialog.OnAreaPickListener onDialogPickListener = new AreaPickerDialog.OnAreaPickListener(){

        @Override
        public void onAreaPick(Area area) {
            AreaPicker.this.setText(area.prettyPrint());
            AreaPicker.this.setArea(area);
        }

        @Override
        public void onCancel() {
            AreaPicker.this.setText(AreaPicker.DEFAULT_MESSAGE);
            AreaPicker.this.setArea(Area.fromSquareMeter((int)0));
        }
    };
    private View.OnClickListener onViewClick = new View.OnClickListener(){

        public void onClick(View view) {
            AreaPicker.this.pickerDialog.show(AreaPicker.this.area);
        }
    };

    public AreaPicker(Context context) {
        this(context, null);
    }

    public AreaPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010081);
    }

    public AreaPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    private void initialize() {
        this.setText(DEFAULT_MESSAGE);
        this.setGravity(16);
        if (!this.isInEditMode()) {
            this.setupPickerDialog();
        }
    }

    private void setupPickerDialog() {
        this.pickerDialog = new AreaPickerDialog(this.getContext(), this.onDialogPickListener);
        this.setOnClickListener(this.onViewClick);
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    @Override
    public void setArea(Area area) {
        if (area == null) {
            throw new NullPointerException("area must not be null");
        }
        this.area = area;
    }
}

