/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget.prename;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import th.or.nectec.android.library.provider.NTTable;
import th.or.nectec.android.library.widget.prename.PrenameListDialog;

public class PrenameView
extends Button
implements PrenameListDialog.onPrenameListener {
    onPrenameChangeListener mListener;
    private Activity mActivity;
    private Uri mUri;
    private PrenameListDialog mDialog;
    String tag = "prename_dialog";
    String prename;
    String full_prename;
    String gender;

    public PrenameView(Context context, AttributeSet attrs) {
        super(context, attrs, 16842862);
        if (context instanceof Activity) {
            Activity act = (Activity)context;
            this.initialize(act, NTTable.RefAddress.CONTENT_URI);
        }
    }

    private void initialize(Activity activity, Uri uri) {
        this.mActivity = activity;
        this.mUri = uri;
        this.mDialog = new PrenameListDialog();
        this.mDialog.setOnPrenameSelectListener(this);
    }

    public boolean performClick() {
        boolean handle = false;
        this.requestFocus();
        if (this.mActivity != null && this.mUri != null) {
            FragmentManager fm = this.mActivity.getFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            Fragment prev = fm.findFragmentByTag(this.tag);
            if (prev != null) {
                ft.remove(prev);
            }
            if (this.mDialog != null) {
                this.mDialog.setOnPrenameSelectListener(this);
                this.mDialog.show(fm, this.tag);
                handle = true;
            }
            ft.commit();
        }
        return handle;
    }

    public String getPrename() {
        return this.prename;
    }

    public String getFullPrename() {
        return this.full_prename;
    }

    public String getGender() {
        return this.gender;
    }

    public void setPrename(String prename) {
        if (!TextUtils.isEmpty((CharSequence)prename)) {
            Cursor findPrenameInfo = this.getContext().getContentResolver().query(NTTable.RefPrename.CONTENT_URI, new String[]{"prename", "prename_full", "gender"}, "prename=? OR prename_full=?", new String[]{prename}, null);
            if (findPrenameInfo.moveToNext()) {
                this.prename = findPrenameInfo.getString(0);
                this.full_prename = findPrenameInfo.getString(1);
                this.gender = findPrenameInfo.getString(2);
            }
        } else {
            return;
        }
        this.setText(prename);
        this.mListener.onPrenameChange(this.prename, this.gender);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.gender = this.gender;
        ss.full_prename = this.full_prename;
        ss.prename = this.prename;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.onPrenameSelect(ss.prename);
    }

    @Override
    public void onPrenameSelect(String prename) {
        this.setPrename(prename);
    }

    public void setOnPrenameChangeListener(onPrenameChangeListener listener) {
        this.mListener = listener;
    }

    public static interface onPrenameChangeListener {
        public void onPrenameChange(String var1, String var2);
    }

    static class SavedState
    extends View.BaseSavedState {
        String prename;
        String full_prename;
        String gender;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.gender = in.readString();
            this.full_prename = in.readString();
            this.prename = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.gender);
            out.writeString(this.full_prename);
            out.writeString(this.prename);
        }
    }
}

