/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.util;

import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.conn.util.InetAddressUtils;

public class DeviceInfo {
    public String getUDID(Context context) {
        String wifiMacAddress = DeviceInfo.getWifiMacAddress(context);
        if (!TextUtils.isEmpty((CharSequence)wifiMacAddress)) {
            return wifiMacAddress;
        }
        String androidID = DeviceInfo.getAndroidId(context);
        if (!TextUtils.isEmpty((CharSequence)androidID)) {
            return androidID;
        }
        return null;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    public static int getSdkVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static String getSerailNumber() {
        return Build.SERIAL;
    }

    public static String getAndroidId(Context context) {
        String id2 = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return id2;
    }

    public static String getWifiMacAddress(Context context) {
        WifiManager manager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = manager.getConnectionInfo();
        if (wifiInfo == null || wifiInfo.getMacAddress() == null) {
            return null;
        }
        return wifiInfo.getMacAddress().replace(":", "").replace(".", "");
    }

    public static String getImei(Context context) {
        TelephonyManager m = (TelephonyManager)context.getSystemService("phone");
        String imei = m != null ? m.getDeviceId() : null;
        return imei;
    }

    public static String getIpAddress(boolean useIPv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    if (addr.isLoopbackAddress()) continue;
                    String sAddr = addr.getHostAddress().toUpperCase();
                    boolean isIPv4 = InetAddressUtils.isIPv4Address((String)sAddr);
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return sAddr;
                    }
                    if (isIPv4) continue;
                    int delim = sAddr.indexOf(37);
                    return delim < 0 ? sAddr : sAddr.substring(0, delim);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getMacAddress(String interfaceName) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                if (interfaceName != null && !intf.getName().equalsIgnoreCase(interfaceName)) continue;
                byte[] mac = intf.getHardwareAddress();
                if (mac == null) {
                    return "";
                }
                StringBuilder buf = new StringBuilder();
                for (int idx = 0; idx < mac.length; ++idx) {
                    buf.append(String.format("%02X:", mac[idx]));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                return buf.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

