/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.smartcard;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.idvision.androididcardlib.iCardUsbReader;
import java.security.InvalidParameterException;
import java.util.HashMap;

public class SmartCardProvider {
    private iCardUsbReader sReader;
    private UsbManager mUsbManager;
    private UsbDevice mDevice;
    private static final String TAG = "SmartCardProvider";
    public static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private ReaderStatusListener mStatusListener;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (SmartCardProvider.ACTION_USB_PERMISSION.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    SmartCardProvider.this.mDevice = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        SmartCardProvider.this.sReader.init(SmartCardProvider.this.mUsbManager, SmartCardProvider.this.mDevice);
                        if (SmartCardProvider.this.mStatusListener != null) {
                            SmartCardProvider.this.mStatusListener.onReaderPermissinoGranted(SmartCardProvider.this.sReader);
                            SmartCardProvider.this.mStatusListener.onReaderStatusChanged(SmartCardProvider.this.sReader, SmartCardProvider.this.sReader.getReaderStatus());
                        }
                    } else {
                        Log.d((String)SmartCardProvider.TAG, (String)("permission denied for device " + SmartCardProvider.this.mDevice));
                        if (SmartCardProvider.this.mStatusListener != null) {
                            SmartCardProvider.this.mStatusListener.onReaderPermissionDenial(SmartCardProvider.this.sReader);
                            SmartCardProvider.this.mStatusListener.onReaderStatusChanged(SmartCardProvider.this.sReader, false);
                        }
                    }
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                SmartCardProvider.this.sReader.init(SmartCardProvider.this.mUsbManager, SmartCardProvider.this.mDevice);
                if (!SmartCardProvider.this.sReader.getReaderStatus()) {
                    SmartCardProvider.this.sReader.close();
                    SmartCardProvider.this.sReader = null;
                    SmartCardProvider.this.sReader = new iCardUsbReader();
                    SmartCardProvider.this.requestPermission();
                }
                if (SmartCardProvider.this.mStatusListener != null) {
                    SmartCardProvider.this.mStatusListener.onReaderAttached(SmartCardProvider.this.sReader);
                    SmartCardProvider.this.mStatusListener.onReaderStatusChanged(SmartCardProvider.this.sReader, SmartCardProvider.this.sReader.getReaderStatus());
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                SmartCardProvider.this.sReader.close();
                if (SmartCardProvider.this.mStatusListener != null) {
                    SmartCardProvider.this.mStatusListener.onReaderDetached(SmartCardProvider.this.sReader);
                    SmartCardProvider.this.mStatusListener.onReaderStatusChanged(SmartCardProvider.this.sReader, false);
                }
            }
        }
    };
    Context mContext;

    private void registerReaderReceiver(Context context) {
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_USB_PERMISSION);
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        context.registerReceiver(this.mUsbReceiver, filter);
        this.requestPermission();
        this.sReader = new iCardUsbReader();
    }

    public void unregisterReaderReceiver() {
        this.mContext.unregisterReceiver(this.mUsbReceiver);
    }

    public SmartCardProvider(Context context, ReaderStatusListener listener) {
        this.mContext = context;
        this.registerReaderReceiver(this.mContext);
        this.setReaderStatusListener(listener);
    }

    public void requestPermission() {
        PendingIntent mPermissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        HashMap map = this.mUsbManager.getDeviceList();
        for (UsbDevice device : map.values()) {
            if (device.getDeviceClass() != 0) continue;
            this.mDevice = device;
            this.mUsbManager.requestPermission(device, mPermissionIntent);
        }
    }

    public iCardUsbReader getReader() {
        if (this.sReader == null) {
            throw new IllegalStateException("must register context before call getReader");
        }
        return this.sReader;
    }

    public void setReaderStatusListener(ReaderStatusListener statusListener) {
        if (statusListener == null) {
            throw new InvalidParameterException("ReaderStatusListener is NULL");
        }
        this.mStatusListener = statusListener;
        this.mStatusListener.onReaderStatusChanged(this.sReader, this.sReader.getReaderStatus());
    }

    public static interface ReaderStatusListener {
        public void onReaderPermissionDenial(iCardUsbReader var1);

        public void onReaderPermissinoGranted(iCardUsbReader var1);

        public void onReaderAttached(iCardUsbReader var1);

        public void onReaderDetached(iCardUsbReader var1);

        public void onReaderStatusChanged(iCardUsbReader var1, boolean var2);
    }
}

